/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dialogs;

import com.rhinosoft.archive.CRhinoArchive;
import com.rhinosoft.attrs.CBoolAttr;
import com.rhinosoft.attrs.CColorAttr;
import com.rhinosoft.attrs.CIntAttr;
import com.rhinosoft.dialogs.CRhinoPrefsTreePanel;
import com.rhinosoft.strings.CString;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import com.rhinosoft.ui.controls.CSeparator;
import com.rhinosoft.ui.controls.buttons.CColorChooserBtn;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class CTransferPrefs
extends CRhinoPrefsTreePanel
implements ActionListener {
    private CIntAttr m_rnNumOfTransferThreads;
    private CBoolAttr m_rbColorRows;
    private CColorAttr m_rclrOddRows;
    private CColorAttr m_rclrEvenRows;
    private CBoolAttr m_rbAutoExpandNewTransfers;
    private CBoolAttr m_rbAutoStartNewTransfers;
    private CBoolAttr m_rbAutoRemoveCompletedTransfers;
    private CSeparator m_cThreadConfigSep;
    private JLabel m_cNumOfThreadsLabel;
    private JSpinner m_cNumOfThreadsSpinner;
    private CSeparator m_cRowColorsSep;
    private JCheckBox m_cEnableRowColorsBtn;
    private CColorChooserBtn m_cOddRowClrBtn;
    private CColorChooserBtn m_cEvenRowClrBtn;
    private CSeparator m_cAutomaticOperationsSep;
    private JCheckBox m_cAutoExpandNewTransfers;
    private JCheckBox m_cAutoStartNewTransfers;
    private JCheckBox m_cAutoRemoveCompletedTransfers;

    public CTransferPrefs() {
        super(CString.LoadString("IDS_TRANSFER_PREFS_TITLE"), CString.LoadString("IDS_TRANSFER_PREFS_TITLE"));
        this._CTransferPrefs();
    }

    private void _CTransferPrefs() {
        this.OnCreate();
    }

    @Override
    protected void InitAttrs() {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            this.m_rnNumOfTransferThreads = CRhinoApp.GET_RHINO_APP().GetAttr_NumOfTransferThreads();
            this.m_rbColorRows = CRhinoApp.GET_RHINO_APP().GetAttr_TransferRowsEnableColor();
            this.m_rclrOddRows = CRhinoApp.GET_RHINO_APP().GetAttr_TransferRowColorOdd();
            this.m_rclrEvenRows = CRhinoApp.GET_RHINO_APP().GetAttr_TransferRowColorEven();
            this.m_rbAutoExpandNewTransfers = CRhinoApp.GET_RHINO_APP().GetAttr_AutoExpandNewTransfers();
            this.m_rbAutoStartNewTransfers = CRhinoApp.GET_RHINO_APP().GetAttr_AutoStartNewTransfers();
            this.m_rbAutoRemoveCompletedTransfers = CRhinoApp.GET_RHINO_APP().GetAttr_AutoRemoveCompletedTransfers();
        }
    }

    @Override
    protected String GetTreeNodeIconFileName() {
        return IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_PANE_16_PNG.GetFileName();
    }

    @Override
    protected String GetHeaderIconFileName() {
        return IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_PANE_48_PNG.GetFileName();
    }

    @Override
    public void OnCreate() {
        super.OnCreate();
        if (this.GetHeaderMsgCtrl() != null) {
            this.GetHeaderMsgCtrl().setText(CString.LoadString("IDS_TRANSFER_PREFS_DESC"));
        }
        this.m_cThreadConfigSep = new CSeparator();
        this.m_cThreadConfigSep.setText(CString.LoadString("IDS_SEP_THREAD_CONFIGURATION"));
        this.m_cRowColorsSep = new CSeparator();
        this.m_cRowColorsSep.setText(CString.LoadString("IDS_SEP_ROW_COLORS"));
        this.m_cAutomaticOperationsSep = new CSeparator();
        this.m_cAutomaticOperationsSep.setText(CString.LoadString("IDS_SEP_AUTOMATIC_OPERATIONS"));
        Color clrDefault = Color.decode("#eeeeee");
        this.m_cOddRowClrBtn = new CColorChooserBtn(clrDefault, CString.LoadString("IDS_EVEN_ROW_CLR"));
        this.m_cOddRowClrBtn.setText(CString.LoadString("IDS_EVEN_ROW_CLR"));
        clrDefault = Color.WHITE;
        this.m_cEvenRowClrBtn = new CColorChooserBtn(clrDefault, CString.LoadString("IDS_ODD_ROW_CLR"));
        this.m_cEvenRowClrBtn.setText(CString.LoadString("IDS_ODD_ROW_CLR"));
        this.m_cEnableRowColorsBtn = new JCheckBox(CString.LoadString("IDS_ENABLE_ROW_CLRS"));
        this.m_cEnableRowColorsBtn.addActionListener(this);
        int nMin = 1;
        int nMax = 10;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            nMin = CRhinoApp.GET_RHINO_APP().GetNumOfTransferThreadsMin();
            nMax = CRhinoApp.GET_RHINO_APP().GetNumOfTransferThreadsMax();
        }
        this.m_cNumOfThreadsLabel = new JLabel(CString.LoadString("IDS_NUM_OF_THREADS"));
        SpinnerNumberModel rSpinModel = new SpinnerNumberModel(4, nMin, nMax, 1);
        this.m_cNumOfThreadsSpinner = new JSpinner(rSpinModel);
        Dimension dimSize = new Dimension(40, 24);
        this.m_cNumOfThreadsSpinner.setPreferredSize(dimSize);
        dimSize = new Dimension(100, dimSize.height);
        this.m_cNumOfThreadsLabel.setPreferredSize(dimSize);
        this.m_cAutoExpandNewTransfers = new JCheckBox(CString.LoadString("IDS_AUTO_EXPAND_NEW_TRANSFERS"));
        this.m_cAutoExpandNewTransfers.addActionListener(this);
        this.m_cAutoStartNewTransfers = new JCheckBox(CString.LoadString("IDS_AUTO_START_NEW_TRANSFERS"));
        this.m_cAutoStartNewTransfers.addActionListener(this);
        this.m_cAutoRemoveCompletedTransfers = new JCheckBox(CString.LoadString("IDS_AUTO_REMOVE_COMPLETED_TRANSFERS"));
        this.m_cAutoRemoveCompletedTransfers.addActionListener(this);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.GetHeaderIconCtrl(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 10, 10).addComponent(this.GetHeaderMsgCtrl(), -1, -2, Short.MAX_VALUE)).addComponent(this.m_cThreadConfigSep, -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.m_cNumOfThreadsLabel, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, 10).addComponent(this.m_cNumOfThreadsSpinner, -1, -2, -2)).addComponent(this.m_cRowColorsSep, -1, -2, Short.MAX_VALUE).addComponent(this.m_cEnableRowColorsBtn, -1, -2, -2).addComponent(this.m_cEvenRowClrBtn, -1, -2, -2).addComponent(this.m_cOddRowClrBtn, -1, -2, -2).addComponent(this.m_cAutomaticOperationsSep, -1, -2, Short.MAX_VALUE).addComponent(this.m_cAutoExpandNewTransfers, -1, -2, -2).addComponent(this.m_cAutoStartNewTransfers, -1, -2, -2).addComponent(this.m_cAutoRemoveCompletedTransfers, -1, -2, -2));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.GetHeaderIconCtrl(), -1, -2, -2).addComponent(this.GetHeaderMsgCtrl(), -1, -2, -2)).addGap(10).addComponent(this.m_cThreadConfigSep, -1, -2, -2).addGap(5).addGroup(layout.createParallelGroup().addComponent(this.m_cNumOfThreadsLabel, -1, -2, -2).addComponent(this.m_cNumOfThreadsSpinner, -1, -2, -2)).addGap(10).addComponent(this.m_cRowColorsSep, -1, -2, -2).addGap(5).addComponent(this.m_cEnableRowColorsBtn, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent(this.m_cEvenRowClrBtn, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 3, 3).addComponent(this.m_cOddRowClrBtn, -1, -2, -2).addGap(10).addComponent(this.m_cAutomaticOperationsSep, -1, -2, -2).addGap(5).addComponent(this.m_cAutoExpandNewTransfers, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 3, 3).addComponent(this.m_cAutoStartNewTransfers, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 3, 3).addComponent(this.m_cAutoRemoveCompletedTransfers, -1, -2, -2));
    }

    @Override
    public void actionPerformed(ActionEvent rEvent) {
        if (rEvent.getSource() == this.m_cEnableRowColorsBtn) {
            boolean bEnableClrs = this.m_cEnableRowColorsBtn.isSelected();
            this.OnUpdateColorBtns();
        }
    }

    private void OnUpdateColorBtns() {
        boolean bEnableClrs = this.m_cEnableRowColorsBtn.isSelected();
        this.m_cOddRowClrBtn.setEnabled(bEnableClrs);
        this.m_cEvenRowClrBtn.setEnabled(bEnableClrs);
    }

    @Override
    protected void OnSaveAttrs() {
        super.OnSaveAttrs();
        this.m_rnNumOfTransferThreads.SetValue(((Integer)this.m_cNumOfThreadsSpinner.getValue()).intValue());
        this.m_rbColorRows.SetValue(this.m_cEnableRowColorsBtn.isSelected());
        this.m_rclrOddRows.SetValue(this.m_cOddRowClrBtn.GetCurColor());
        this.m_rclrEvenRows.SetValue(this.m_cEvenRowClrBtn.GetCurColor());
        this.m_rbAutoExpandNewTransfers.SetValue(this.m_cAutoExpandNewTransfers.isSelected());
        this.m_rbAutoStartNewTransfers.SetValue(this.m_cAutoStartNewTransfers.isSelected());
        this.m_rbAutoRemoveCompletedTransfers.SetValue(this.m_cAutoRemoveCompletedTransfers.isSelected());
        CRhinoArchive rArchive = null;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            rArchive = CRhinoApp.GET_RHINO_APP().GetArchive();
        }
        if (rArchive != null) {
            this.m_rnNumOfTransferThreads.Save(rArchive);
            this.m_rbColorRows.Save(rArchive);
            this.m_rclrOddRows.Save(rArchive);
            this.m_rclrEvenRows.Save(rArchive);
            this.m_rbAutoExpandNewTransfers.Save(rArchive);
            this.m_rbAutoStartNewTransfers.Save(rArchive);
            this.m_rbAutoRemoveCompletedTransfers.Save(rArchive);
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag && this.m_cOddRowClrBtn != null && this.m_cEvenRowClrBtn != null) {
            Dimension dimSize = new Dimension(30, 15);
            Dimension dimEvenSize = null;
            Dimension dimOddSize = null;
            for (int nIdx = 0; nIdx < 2; ++nIdx) {
                dimEvenSize = null;
                dimOddSize = null;
                if (nIdx == 0) {
                    dimEvenSize = this.m_cEvenRowClrBtn.getMinimumSize();
                    dimOddSize = this.m_cOddRowClrBtn.getMinimumSize();
                } else if (nIdx == 1) {
                    dimEvenSize = this.m_cEvenRowClrBtn.getPreferredSize();
                    dimOddSize = this.m_cOddRowClrBtn.getPreferredSize();
                } else {
                    dimEvenSize = this.m_cEvenRowClrBtn.getSize();
                    dimOddSize = this.m_cOddRowClrBtn.getSize();
                }
                dimSize.width = Math.max(dimEvenSize.width, dimOddSize.width);
                dimSize.height = Math.max(dimEvenSize.height, dimOddSize.height);
                if (nIdx == 0) {
                    this.m_cEvenRowClrBtn.setMinimumSize(dimSize);
                    this.m_cOddRowClrBtn.setMinimumSize(dimSize);
                    continue;
                }
                if (nIdx == 1) {
                    this.m_cEvenRowClrBtn.setPreferredSize(dimSize);
                    this.m_cOddRowClrBtn.setPreferredSize(dimSize);
                    continue;
                }
                this.m_cEvenRowClrBtn.setSize(dimSize);
                this.m_cOddRowClrBtn.setSize(dimSize);
            }
        }
    }

    @Override
    protected void OnLoadAttrs() {
        super.OnLoadAttrs();
        CRhinoArchive rArchive = null;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            rArchive = CRhinoApp.GET_RHINO_APP().GetArchive();
        }
        if (rArchive != null) {
            this.m_rnNumOfTransferThreads.Load(rArchive);
            this.m_rbColorRows.Load(rArchive);
            this.m_rclrOddRows.Load(rArchive);
            this.m_rclrEvenRows.Load(rArchive);
            this.m_rbAutoExpandNewTransfers.Load(rArchive);
            this.m_rbAutoStartNewTransfers.Load(rArchive);
            this.m_rbAutoRemoveCompletedTransfers.Load(rArchive);
        }
        this.m_cNumOfThreadsSpinner.setValue(this.m_rnNumOfTransferThreads.GetValueInt());
        this.m_cEnableRowColorsBtn.setSelected(this.m_rbColorRows.GetValue());
        this.m_cOddRowClrBtn.SetCurColor(this.m_rclrOddRows.GetValue());
        this.m_cEvenRowClrBtn.SetCurColor(this.m_rclrEvenRows.GetValue());
        this.m_cAutoExpandNewTransfers.setSelected(this.m_rbAutoExpandNewTransfers.GetValue());
        this.m_cAutoStartNewTransfers.setSelected(this.m_rbAutoStartNewTransfers.GetValue());
        this.m_cAutoRemoveCompletedTransfers.setSelected(this.m_rbAutoRemoveCompletedTransfers.GetValue());
        this.OnUpdateColorBtns();
    }
}

