/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dialogs;

import com.rhinosoft.attrs.CAttrs;
import com.rhinosoft.dialogs.CRhinoDialog;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CCacheMsg;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import java.awt.Dimension;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;

public class CRhinoPrefsTreePanel
extends JPanel {
    public static final int DLG_MIN_WIDTH = 400;
    public static final int DLG_MIN_HEIGHT = 300;
    private String m_sLookupKey;
    private String m_sTitle;
    private JLabel m_cHeaderIcon;
    private JTextPane m_cHeaderMsg;
    private JSeparator m_cHeaderSeparator;
    private Icon m_TreeNodeIcon;

    public CRhinoPrefsTreePanel(String sLookupKey, String sTitle) {
        this._CRhinoPrefsTreePanel(sLookupKey, sTitle);
    }

    private void _CRhinoPrefsTreePanel(String sLookupKey, String sTitle) {
        this.m_sLookupKey = sLookupKey;
        this.m_sTitle = sTitle;
        this.InitAttrs();
    }

    protected void InitAttrs() {
    }

    public void OnCreate() {
        String sTreeNodeFileName = this.GetTreeNodeIconFileName();
        if (sTreeNodeFileName != null) {
            this.SetTreeNodeIcon(CRhinoApp.GetImage(sTreeNodeFileName));
        }
        this.m_cHeaderIcon = new JLabel();
        this.m_cHeaderMsg = new JTextPane();
        this.m_cHeaderSeparator = new JSeparator();
        if (this.GetHeaderMsgCtrl() != null) {
            CRhinoDialog.AddEscapeKeyListener(this.GetHeaderMsgCtrl());
            this.GetHeaderMsgCtrl().setEditable(false);
            this.GetHeaderMsgCtrl().setOpaque(false);
        }
        if (this.GetHeaderIconCtrl() != null) {
            this.GetHeaderIconCtrl().setHorizontalAlignment(0);
            ImageIcon icoIcon = CRhinoApp.GetImage(this.GetHeaderIconFileName());
            this.GetHeaderIconCtrl().setIcon(icoIcon);
            if (icoIcon != null) {
                Dimension dimSize = new Dimension(icoIcon.getIconWidth(), icoIcon.getIconHeight());
                this.GetHeaderIconCtrl().setMinimumSize(dimSize);
                this.GetHeaderIconCtrl().setPreferredSize(dimSize);
                this.GetHeaderIconCtrl().setMaximumSize(dimSize);
            }
        }
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.GetHeaderIconCtrl(), -1, -2, Short.MAX_VALUE).addComponent(this.GetHeaderMsgCtrl(), -1, -2, Short.MAX_VALUE)).addComponent(this.GetHeaderSeparator(), -1, -2, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.GetHeaderIconCtrl(), -1, -2, -2).addComponent(this.GetHeaderMsgCtrl(), -1, -2, -2)).addComponent(this.GetHeaderSeparator(), -1, -2, -2));
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(this.getMinimumSize());
    }

    protected JLabel GetHeaderIconCtrl() {
        return this.m_cHeaderIcon;
    }

    protected JTextPane GetHeaderMsgCtrl() {
        return this.m_cHeaderMsg;
    }

    protected JSeparator GetHeaderSeparator() {
        return this.m_cHeaderSeparator;
    }

    public void SavePage() {
    }

    public boolean ValidatePage() {
        return true;
    }

    public final void OnHelp() {
        if (CAttrs.DEBUG) {
            CDebugLog.INFO("Show the help documentation.");
        }
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().PostShowHelpDoc(this.GetHelpDoc(), this.GetHelpNode());
        }
    }

    protected String GetHelpDoc() {
        return null;
    }

    protected String GetHelpNode() {
        return "none";
    }

    public String GetLookupKey() {
        return this.m_sLookupKey;
    }

    public String GetTitle() {
        return this.m_sTitle;
    }

    public void OnMessage(CAttrMsg rMsg) {
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 3010: 
                case 3202: 
                case 3203: 
                case 3204: 
                case 3205: 
                case 3207: 
                case 3208: 
                case 3211: 
                case 3212: 
                case 3213: 
                case 3215: 
                case 3217: 
                case 3218: 
                case 3219: {
                    SwingUtilities.updateComponentTreeUI(this);
                    break;
                }
                case 4005: {
                    this.OnSaveAttrs();
                    break;
                }
                case 4004: {
                    this.OnLoadAttrs();
                    break;
                }
                case 4235: {
                    if (!(rMsg instanceof CCacheMsg)) break;
                    CCacheMsg rCacheMsg = (CCacheMsg)rMsg;
                    this.OnRecvCacheImage(rCacheMsg.GetFileName());
                    break;
                }
            }
        }
    }

    protected void OnRecvCacheImage(String sFileName) {
        if (this.GetHeaderIconFileName().equals(sFileName)) {
            this.GetHeaderIconCtrl().repaint();
        }
    }

    protected void OnSaveAttrs() {
    }

    protected void OnLoadAttrs() {
    }

    protected String GetTreeNodeIconFileName() {
        return null;
    }

    protected String GetHeaderIconFileName() {
        return IRhinoConsts.CACHE_IMAGES_COMMON.IMG_RHINO_48x48_PNG.GetFileName();
    }

    public Icon GetTreeNodeIcon() {
        return this.m_TreeNodeIcon;
    }

    public void SetTreeNodeIcon(Icon rIcon) {
        this.m_TreeNodeIcon = rIcon;
    }
}

