/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dialogs;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.dialogs.CRhinoDialog;
import com.rhinosoft.dialogs.CRhinoPrefsTreePanel;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.strings.CString;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import com.rhinosoft.ui.controls.CGradientLabel;
import com.rhinosoft.ui.controls.CLinkLabel;
import com.rhinosoft.ui.controls.CTreeCtrl;
import com.rhinosoft.ui.controls.CTreeCtrlModel;
import com.rhinosoft.ui.controls.CTwoToneLabel;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public abstract class CRhinoPrefsDlg
extends CRhinoDialog
implements TreeSelectionListener {
    public static boolean DEBUG = CAttr.DEBUG;
    public static final String URL_RHINOSOFT = "http://www.RhinoSoft.com/";
    public static final int GAP_FRAME = 6;
    public static final int GAP_FRAME_NORTH = 6;
    public static final int GAP_FRAME_SOUTH = 6;
    public static final int GAP_FRAME_WEST = 6;
    public static final int GAP_FRAME_EAST = 6;
    public static final int GAP_BETWEEN_PANES = 6;
    public static final int GAP_BETWEEN_LOGOS = 3;
    public static final int DLG_MIN_WIDTH = 450;
    public static final int DLG_MIN_HEIGHT = 350;
    private JPanel m_cTreeTitlePanel;
    private JLabel m_cTreeTitleLabel;
    private JPanel m_cTreePanel;
    private JScrollPane m_cTreeScrollPane;
    private CTreeCtrl m_cTree;
    private JLabel m_cRhinoLogo;
    private JLabel m_cResellerLogo;
    private JPanel m_cTreeNodePanel;
    private CGradientLabel m_cTreeNodeLabel;
    private JScrollPane m_cDynamicPanel;
    private LinkedHashMap<String, CRhinoPrefsTreePanel> m_aTreePanels;
    private CRhinoPrefsTreePanel m_cCurTreePanel;
    private JPanel m_cBtnSeparatorPanel;
    private JPanel m_cBtnPanel;
    private CTwoToneLabel m_cTextBanner;
    private JButton m_cOKBtn;
    private JButton m_cCancelBtn;
    private JButton m_cHelpBtn;

    public CRhinoPrefsDlg(Window wndOwner, String sTitle) {
        super(wndOwner, sTitle, Dialog.ModalityType.DOCUMENT_MODAL);
        this._CRhinoPrefsDlg();
    }

    public CRhinoPrefsDlg(Window wndOwner, String sTitle, Dialog.ModalityType nModalType) {
        super(wndOwner, sTitle, nModalType);
        this._CRhinoPrefsDlg();
    }

    private void _CRhinoPrefsDlg() {
        this.OnCreate();
    }

    private void OnCreate() {
        this.m_aTreePanels = new LinkedHashMap();
        this.setMinimumSize(new Dimension(450, 350));
        this.InitTitleIcon();
        this.m_cTreeTitlePanel = new JPanel();
        this.m_cTreeTitleLabel = new JLabel(CString.LoadString("IDS_TREE_CATEGORY"));
        this.m_cTreePanel = new JPanel();
        this.m_cTree = new CTreeCtrl(false, "DEFAULT_ROOT");
        if (this.GetTreeCtrl() != null) {
            CRhinoPrefsDlg.AddEscapeKeyListener(this.GetTreeCtrl());
            this.GetTreeCtrl().getSelectionModel().setSelectionMode(1);
            this.GetTreeCtrl().addTreeSelectionListener(this);
        }
        this.m_cTreeScrollPane = new JScrollPane(this.m_cTree);
        this.m_cResellerLogo = this.CreateLinkLabel(CString.LoadString("IDS_RESELLER_COMPANY_URL"));
        if (this.m_cResellerLogo != null) {
            this.m_cResellerLogo.setVisible(false);
        }
        this.m_cRhinoLogo = this.CreateLinkLabel(URL_RHINOSOFT);
        if (this.m_cRhinoLogo != null) {
            this.m_cRhinoLogo.setVisible(false);
        }
        this.m_cTreeNodePanel = new JPanel();
        this.m_cTreeNodeLabel = new CGradientLabel();
        this.m_cTreeNodeLabel.SetGradientColors(Color.BLACK, this.m_cTreeNodePanel.getBackground());
        this.m_cTreeNodeLabel.setForeground(Color.WHITE);
        this.m_cBtnSeparatorPanel = new JPanel();
        this.m_cTextBanner = new CTwoToneLabel();
        this.m_cBtnPanel = new JPanel();
        this.m_cOKBtn = new JButton();
        this.SetBtnTxt(this.m_cOKBtn, CString.LoadString("IDS_OK", false));
        CRhinoPrefsDlg.AddEscapeKeyListener(this.m_cOKBtn);
        this.m_cOKBtn.addActionListener(this);
        this.m_cCancelBtn = new JButton();
        this.SetBtnTxt(this.m_cCancelBtn, CString.LoadString("IDS_CANCEL", false));
        CRhinoPrefsDlg.AddEscapeKeyListener(this.m_cCancelBtn);
        this.m_cCancelBtn.addActionListener(this);
        this.m_cHelpBtn = new JButton();
        this.SetBtnTxt(this.m_cHelpBtn, CString.LoadString("IDS_HELP_MENU", false));
        CRhinoPrefsDlg.AddEscapeKeyListener(this.m_cHelpBtn);
        this.m_cHelpBtn.addActionListener(this);
        this.m_cDynamicPanel = new JScrollPane();
        this.m_cDynamicPanel.setBorder(BorderFactory.createEmptyBorder());
        this.InitCategoryLabelPanel(this.m_cTreeTitlePanel);
        this.m_cResellerLogo.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_cRhinoLogo.setBorder(BorderFactory.createLoweredBevelBorder());
        ImageIcon iRhinoLogo = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_RHINOSOFT_LOGO_PNG.GetFileName());
        this.SetResellerLogo(this.FetchResellerLogo());
        this.SetRhinoLogo(iRhinoLogo);
        this.InitSelectionPanel(this.m_cTreePanel);
        this.InitTreeNodePanel(this.m_cTreeNodePanel);
        this.InitButtonSeparatorPanel(this.m_cBtnSeparatorPanel);
        this.InitButtons(this.m_cBtnPanel);
        JPanel cPanel = new JPanel();
        GroupLayout layout = new GroupLayout(cPanel);
        cPanel.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGap(6).addGroup(layout.createParallelGroup().addComponent(this.m_cTreeTitlePanel, -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.m_cTreePanel, -1, -2, -2).addGap(6).addComponent(this.m_cTreeNodePanel, -1, -2, Short.MAX_VALUE)).addComponent(this.m_cBtnSeparatorPanel, -1, -2, Short.MAX_VALUE).addComponent(this.m_cBtnPanel, -1, -2, Short.MAX_VALUE)).addGap(6));
        layout.setVerticalGroup(layout.createSequentialGroup().addGap(6).addComponent(this.m_cTreeTitlePanel, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cTreePanel, -1, -2, Short.MAX_VALUE).addComponent(this.m_cTreeNodePanel, -1, -2, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 8, 8).addComponent(this.m_cBtnSeparatorPanel, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 4, 4).addComponent(this.m_cBtnPanel, -1, -2, -2).addGap(6));
        this.setContentPane(cPanel);
        this.setDefaultCloseOperation(2);
        this.InitTreePanels();
    }

    protected void InitCategoryLabelPanel(JPanel rPanel) {
        if (rPanel != null) {
            GroupLayout layout = new GroupLayout(rPanel);
            rPanel.setLayout(layout);
            layout.setAutoCreateGaps(false);
            layout.setAutoCreateContainerGaps(false);
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.m_cTreeTitleLabel, -1, -2, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.m_cTreeTitleLabel, -1, -2, Short.MAX_VALUE));
        }
    }

    protected void InitTreeNodePanel(JPanel rPanel) {
        if (rPanel != null) {
            GroupLayout layout = new GroupLayout(rPanel);
            rPanel.setLayout(layout);
            layout.setAutoCreateGaps(false);
            layout.setAutoCreateContainerGaps(false);
            layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.m_cTreeNodeLabel, -1, -2, Short.MAX_VALUE).addComponent(this.m_cDynamicPanel, -1, -2, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.m_cTreeNodeLabel, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 8, 8).addComponent(this.m_cDynamicPanel, -1, -2, Short.MAX_VALUE));
        }
    }

    protected void InitSelectionPanel(JPanel rPanel) {
        if (rPanel != null) {
            GroupLayout layout = new GroupLayout(rPanel);
            rPanel.setLayout(layout);
            layout.setAutoCreateGaps(false);
            layout.setAutoCreateContainerGaps(false);
            layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.m_cTreeScrollPane, -1, -2, Short.MAX_VALUE).addComponent(this.m_cResellerLogo, -1, -2, Short.MAX_VALUE).addComponent(this.m_cRhinoLogo, -1, -2, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.m_cTreeScrollPane, -1, -2, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 3, 3).addComponent(this.m_cResellerLogo, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 3, 3).addComponent(this.m_cRhinoLogo, -1, -2, -2));
        }
    }

    protected void InitEastPanel(JPanel rPanel) {
    }

    protected void InitButtonSeparatorPanel(JPanel rPanel) {
        if (rPanel != null) {
            JSeparator cSep = new JSeparator();
            cSep.setOrientation(0);
            GroupLayout layout = new GroupLayout(rPanel);
            rPanel.setLayout(layout);
            layout.setAutoCreateGaps(false);
            layout.setAutoCreateContainerGaps(false);
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(cSep, -1, -2, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(cSep, 3, -2, -2));
        }
    }

    protected JButton GetDefaultBtn() {
        return this.m_cOKBtn;
    }

    protected void InitButtons(JPanel rPanel) {
        if (rPanel != null) {
            this.m_cTextBanner.setText(this.GetBannerText());
            if (this.getRootPane() != null) {
                this.getRootPane().setDefaultButton(this.GetDefaultBtn());
            }
            GroupLayout layout = new GroupLayout(rPanel);
            rPanel.setLayout(layout);
            layout.setAutoCreateGaps(false);
            layout.setAutoCreateContainerGaps(false);
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.m_cTextBanner, -1, -2, Short.MAX_VALUE).addComponent(this.m_cOKBtn, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 4, 4).addComponent(this.m_cCancelBtn, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 4, 4).addComponent(this.m_cHelpBtn, -1, -2, -2));
            layout.setVerticalGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 1, 1).addGroup(layout.createParallelGroup().addComponent(this.m_cTextBanner, -1, -2, Short.MAX_VALUE).addComponent(this.m_cOKBtn, -1, -2, -2).addComponent(this.m_cCancelBtn, -1, -2, -2).addComponent(this.m_cHelpBtn, -1, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 1, 1));
        }
    }

    private void SetLogo(JLabel rComp, ImageIcon rLogo) {
        if (rComp != null) {
            rComp.setIcon(rLogo);
            rComp.setVisible(rLogo != null);
        }
    }

    public void SetResellerLogo(ImageIcon rLogo) {
        this.SetLogo(this.m_cResellerLogo, rLogo);
    }

    public void SetRhinoLogo(ImageIcon rLogo) {
        this.SetLogo(this.m_cRhinoLogo, rLogo);
        this.UpdateLogoSizes();
    }

    private JLabel GetLogoCtrl() {
        return this.m_cRhinoLogo;
    }

    private JLabel GetResellerLogoCtrl() {
        return this.m_cResellerLogo;
    }

    private CLinkLabel CreateLinkLabel(String sURL) {
        CLinkLabel cLinkLabel = new CLinkLabel(sURL){

            @Override
            protected void paintComponent(Graphics rGraphics) {
                Graphics2D g2d = (Graphics2D)rGraphics;
                Paint oldPaint = g2d.getPaint();
                int nWidth = this.getWidth();
                int nHeight = this.getHeight();
                GradientPaint paint = new GradientPaint(0.0f, 0.0f, Color.WHITE, nWidth, nHeight, Color.WHITE, true);
                g2d.setPaint(paint);
                g2d.fillRect(0, 0, nWidth, nHeight);
                g2d.setPaint(oldPaint);
                super.paintComponent(rGraphics);
            }
        };
        cLinkLabel.setHorizontalAlignment(0);
        return cLinkLabel;
    }

    @Override
    public void actionPerformed(ActionEvent rEvent) {
        if (rEvent != null) {
            if (rEvent.getSource() == this.m_cOKBtn) {
                this.OnOK();
            } else if (rEvent.getSource() == this.m_cCancelBtn) {
                this.OnCancelBtn();
            } else if (rEvent.getSource() == this.m_cHelpBtn) {
                this.OnHelpBtn();
            }
        }
    }

    protected void OnOK() {
        this.OnClose(0);
    }

    protected void OnCancelBtn() {
        this.OnClose(2);
    }

    protected void OnHelpBtn() {
        if (this.GetCurTreePanel() != null) {
            this.GetCurTreePanel().OnHelp();
        }
    }

    protected CTreeCtrl GetTreeCtrl() {
        return this.m_cTree;
    }

    @Override
    public void valueChanged(TreeSelectionEvent rTreeEvent) {
        TreePath rNewTreePath;
        if (rTreeEvent != null && (rNewTreePath = rTreeEvent.getNewLeadSelectionPath()) != null && this.GetTreeCtrl() != null) {
            String sSelTreePath = this.GetTreeCtrl().FormatTreePath(rNewTreePath);
            if (this.GetTreePanels() != null) {
                CRhinoPrefsTreePanel cNewPanel = this.GetTreePanels().get(sSelTreePath);
                boolean bChangePanel = true;
                if (this.GetCurTreePanel() != null) {
                    bChangePanel = this.GetCurTreePanel().ValidatePage();
                }
                if (bChangePanel) {
                    this.SetStoredTreePath(sSelTreePath);
                    this.SetCurTreePanel(cNewPanel);
                } else {
                    this.GetTreeCtrl().SetSelectionPath(this.GetKey(this.GetCurTreePanel()));
                }
            }
        }
    }

    protected LinkedHashMap<String, CRhinoPrefsTreePanel> GetTreePanels() {
        return this.m_aTreePanels;
    }

    protected String GetKey(JPanel rTreePanel) {
        String sRetKey = null;
        LinkedHashMap<String, CRhinoPrefsTreePanel> aTreePanels = this.GetTreePanels();
        if (aTreePanels != null) {
            Set<String> aKeys = aTreePanels.keySet();
            for (String sKey : aKeys) {
                if (sKey == null || sKey.isEmpty() || aTreePanels.get(sKey) != rTreePanel) continue;
                sRetKey = sKey;
                break;
            }
        } else if (DEBUG) {
            System.out.println("ASSERT:  Programming error, aTreePanels = null");
        }
        return sRetKey;
    }

    public boolean AddTreePanel(CRhinoPrefsTreePanel rTreePanel) {
        LinkedHashMap<String, CRhinoPrefsTreePanel> aTreePanels;
        String sKey;
        boolean bAdded = false;
        if (rTreePanel != null && (sKey = rTreePanel.GetLookupKey()) != null && !sKey.isEmpty() && (aTreePanels = this.GetTreePanels()) != null) {
            CRhinoPrefsTreePanel objVal;
            boolean bCanAdd = true;
            if (aTreePanels.containsKey(sKey = CTreeCtrlModel.FormatTreePath(sKey, "DEFAULT_ROOT")) && (objVal = aTreePanels.get(sKey)) != null) {
                bCanAdd = false;
            }
            if (bCanAdd) {
                int nSize = aTreePanels.size();
                aTreePanels.put(sKey, rTreePanel);
                if (this.GetTreeCtrl() != null) {
                    this.GetTreeCtrl().AddNode(sKey, rTreePanel.GetTreeNodeIcon());
                    if (nSize < 1) {
                        this.GetTreeCtrl().SetSelectionPath(sKey);
                    }
                }
                bAdded = true;
            }
        }
        return bAdded;
    }

    protected CRhinoPrefsTreePanel GetCurTreePanel() {
        return this.m_cCurTreePanel;
    }

    protected JScrollPane GetDynamicPanel() {
        return this.m_cDynamicPanel;
    }

    private void SetCurTreePanel(CRhinoPrefsTreePanel rNewPanel) {
        if (this.GetDynamicPanel() != null) {
            if (this.GetCurTreePanel() != null) {
                this.GetCurTreePanel().setVisible(false);
                this.GetDynamicPanel().getViewport().setView(null);
            }
            this.m_cCurTreePanel = rNewPanel;
            this.m_cTreeNodeLabel.SetText(rNewPanel.GetTitle());
            if (this.GetCurTreePanel() != null) {
                this.GetCurTreePanel().setVisible(true);
                this.GetDynamicPanel().getViewport().setView(this.GetCurTreePanel());
                this.GetDynamicPanel().validate();
            }
        }
    }

    protected void SetStoredTreePath(String sTreePath) {
    }

    protected void InitTreePanels() {
    }

    protected JButton GetOKBtn() {
        return this.m_cOKBtn;
    }

    protected JButton GetCancelBtn() {
        return this.m_cCancelBtn;
    }

    protected JButton GetHelpBtn() {
        return this.m_cHelpBtn;
    }

    protected String GetBannerText() {
        return CRhinoApp.GetAppNameAndVersion();
    }

    protected ImageIcon FetchResellerLogo() {
        return null;
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        LinkedHashMap<String, CRhinoPrefsTreePanel> aTreePanels;
        super.OnMessage(rMsg);
        if (this.GetTreeCtrl() != null) {
            this.GetTreeCtrl().OnMessage(rMsg);
        }
        if ((aTreePanels = this.GetTreePanels()) != null) {
            Set<String> aKeys = aTreePanels.keySet();
            for (String sKey : aKeys) {
                CRhinoPrefsTreePanel rPanel = aTreePanels.get(sKey);
                if (rPanel == null) continue;
                rPanel.OnMessage(rMsg);
            }
        }
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 3010: 
                case 3202: 
                case 3203: 
                case 3204: 
                case 3205: 
                case 3207: 
                case 3208: 
                case 3211: 
                case 3212: 
                case 3213: 
                case 3215: 
                case 3217: 
                case 3218: 
                case 3219: {
                    SwingUtilities.updateComponentTreeUI(this);
                    break;
                }
            }
        }
    }

    @Override
    protected void OnRecvCacheImage(String sFileName) {
        LinkedHashMap<String, CRhinoPrefsTreePanel> aTreePanels;
        super.OnRecvCacheImage(sFileName);
        if (IRhinoConsts.CACHE_IMAGES_COMMON.IMG_RHINOSOFT_LOGO_PNG.GetFileName().equals(sFileName)) {
            this.m_cRhinoLogo.repaint();
        }
        IRhinoConsts.CACHE_IMAGES_COMMON rImage = null;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            rImage = CRhinoApp.GET_RHINO_APP().GetResellerImage();
        }
        if (rImage != null && rImage.GetFileName().equals(sFileName)) {
            this.m_cResellerLogo.repaint();
        }
        if ((aTreePanels = this.GetTreePanels()) != null) {
            Set<String> aKeys = aTreePanels.keySet();
            for (String sKey : aKeys) {
                String sIconName;
                CRhinoPrefsTreePanel rPanel;
                if (sKey == null || sKey.isEmpty() || (rPanel = aTreePanels.get(sKey)) == null || (sIconName = rPanel.GetTreeNodeIconFileName()) == null || !sIconName.equals(sFileName)) continue;
                this.GetTreeCtrl().repaint();
                break;
            }
        }
    }

    protected int GetTreeSizeWidth() {
        int nWidth = IRhinoConsts.CACHE_IMAGES_COMMON.IMG_RHINOSOFT_LOGO_PNG.GetWidth();
        if (this.GetLogoCtrl() != null && this.GetLogoCtrl().getIcon() != null) {
            Insets rInsets;
            nWidth = this.GetLogoCtrl().getIcon().getIconWidth();
            if (this.GetLogoCtrl().getBorder() != null && (rInsets = this.GetLogoCtrl().getBorder().getBorderInsets(this.GetLogoCtrl())) != null) {
                nWidth += rInsets.left + rInsets.right;
            }
        }
        return nWidth;
    }

    private void UpdateLogoSizes() {
        if (this.GetLogoCtrl() != null && this.GetLogoCtrl().getIcon() != null) {
            int nWidth = this.GetTreeSizeWidth();
            int nHeight = this.GetLogoCtrl().getIcon().getIconHeight();
            this.GetLogoCtrl().setMinimumSize(new Dimension(nWidth, nHeight));
            this.GetLogoCtrl().setPreferredSize(new Dimension(nWidth, nHeight));
            this.GetLogoCtrl().setSize(new Dimension(nWidth, nHeight));
            if (this.GetResellerLogoCtrl() != null) {
                this.GetResellerLogoCtrl().setMinimumSize(new Dimension(nWidth, nHeight));
                this.GetResellerLogoCtrl().setPreferredSize(new Dimension(nWidth, nHeight));
                this.GetResellerLogoCtrl().setSize(new Dimension(nWidth, nHeight));
            }
            if (this.GetTreePaneCtrl() != null) {
                this.GetTreePaneCtrl().setMinimumSize(new Dimension(nWidth, 100));
                this.GetTreePaneCtrl().setPreferredSize(new Dimension(nWidth, 100));
                this.GetTreePaneCtrl().setSize(new Dimension(nWidth, 100));
            }
        }
    }

    protected JScrollPane GetTreePaneCtrl() {
        return this.m_cTreeScrollPane;
    }

    @Override
    public void setVisible(boolean bVisible) {
        if (bVisible && this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(this.GetDefaultBtn());
        }
        super.setVisible(bVisible);
    }
}

