/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dialogs;

import com.rhinosoft.archive.CRhinoArchive;
import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.CConnectionAttrs;
import com.rhinosoft.dialogs.CRhinoOverwriteBtn;
import com.rhinosoft.files.CFile;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CThumbnailMsg;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CWorkerThread;
import com.rhinosoft.ui.CRhinoApp;
import java.awt.Dimension;
import java.util.Date;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public class CRhinoOverwriteFileBtn
extends CRhinoOverwriteBtn {
    public static final boolean DEBUG_AFTER_ACTION_THUMB = DEBUG;
    public static final String THREAD_NAME_OVERWRITE_THUMB = "OverwriteThumbThread";
    public static final int THUMB_WIDTH = 70;
    public static final int THUMB_HEIGHT = 70;
    protected JLabel m_cThumb;
    private CFile m_rFile;
    private CWorkerThread m_rThumbThread;
    private CConnectionAttrs m_rConnectionAttrs;
    private long m_lUISourceAttrID;
    private CThumbnailMsg m_ThumbnailMsg;
    private boolean m_bReceivedThumb = true;

    public CRhinoOverwriteFileBtn(String sTitle, String sDesc, CWorkerThread rThumbThread, CConnectionAttrs rConnectionAttrs, long lUISourceAttrID) {
        super(sTitle, sDesc);
        this._CRhinoOverwriteFileBtn(rThumbThread, rConnectionAttrs, lUISourceAttrID);
    }

    protected CRhinoOverwriteFileBtn(CWorkerThread rThumbThread, CConnectionAttrs rConnectionAttrs, long lUISourceAttrID) {
        this._CRhinoOverwriteFileBtn(rThumbThread, rConnectionAttrs, lUISourceAttrID);
    }

    private void _CRhinoOverwriteFileBtn(CWorkerThread rThumbThread, CConnectionAttrs rConnectionAttrs, long lUISourceAttrID) {
        this.m_rThumbThread = rThumbThread;
        this.m_rConnectionAttrs = rConnectionAttrs;
        this.m_lUISourceAttrID = lUISourceAttrID;
        this.m_cThumb = new JLabel();
        this.m_cThumb.setHorizontalAlignment(0);
        this.m_cThumb.setVerticalAlignment(0);
        Dimension dimSize = new Dimension(this.GetThumbWidth(), this.GetThumbHeight());
        this.m_cThumb.setPreferredSize(dimSize);
        this.m_cThumb.setMaximumSize(dimSize);
        this.m_cThumb.setMinimumSize(dimSize);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.GetArrowLabel(), -1, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.GetTitleLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetDescLabel(), -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.m_cThumb, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, -2).addComponent(this.GetFmtScrollPane(), -1, -2, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.GetArrowLabel(), -1, -2, -2).addComponent(this.GetTitleLabel(), -1, -2, -2)).addComponent(this.GetDescLabel(), -1, -2, -2).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, -2).addComponent(this.m_cThumb, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE)).addComponent(this.GetFmtScrollPane(), -1, -2, Short.MAX_VALUE)));
    }

    protected CWorkerThread GetThumbThread() {
        return this.m_rThumbThread;
    }

    protected CConnectionAttrs GetConnectionAttrs() {
        return this.m_rConnectionAttrs;
    }

    protected long GetUISourceAttrID() {
        return this.m_lUISourceAttrID;
    }

    protected CFile GetFile() {
        return this.m_rFile;
    }

    public void FetchThumbs() {
        if (this.GetFile() != null) {
            CThumbnailMsg[] arThumbMsg = new CThumbnailMsg[]{null};
            Icon rIcon = this.GetFile().GetThumbnail(false, this.GetThumbWidth(), this.GetThumbHeight(), this.GetThumbThread(), this.GetConnectionAttrs(), this.GetAttrID(), arThumbMsg);
            if (arThumbMsg != null && arThumbMsg.length == 1) {
                this.m_ThumbnailMsg = arThumbMsg[0];
            }
            this.m_bReceivedThumb = arThumbMsg[0] == null;
            this.UpdateThumbImage(rIcon, this.GetFile());
        }
    }

    public void SetFile(CFile rFile) {
        this.m_rFile = rFile;
        if (rFile != null) {
            String sAbsPath = rFile.GetAbsPath();
            String sFileName = rFile.GetDisplayName();
            String sParentPath = CString.GetFilePath(sAbsPath, true);
            long lSize = rFile.GetSize();
            String sSize = CFile.FormatFileSize(lSize);
            sSize = String.format(CString.LoadString("IDS_FMT_OVERWRITE_BTN_FILE_SIZE"), sSize);
            Date dtModified = rFile.GetDateModified();
            CRhinoArchive rArchive = null;
            if (CRhinoApp.GET_RHINO_APP() != null) {
                rArchive = CRhinoApp.GET_RHINO_APP().GetArchive();
            }
            String sModifiedTimestamp = CFile.FormatFileTimestamp(dtModified, rArchive, false);
            sModifiedTimestamp = String.format(CString.LoadString("IDS_FMT_OVERWRITE_BTN_FILE_MODIFIED"), sModifiedTimestamp);
            this.SetFileNameText(sFileName);
            this.SetFileNameExText(sParentPath);
            this.SetVisible_FileNameEx(true);
            boolean bCanAppendSize = this.CanAppendSize(rFile);
            if (bCanAppendSize) {
                this.SetSizeText(sSize);
            }
            this.SetVisible_Size(bCanAppendSize);
            this.SetModifiedTimestampText(sModifiedTimestamp);
            this.SetVisible_ModifiedTimestamp(bCanAppendSize);
        }
    }

    protected boolean CanAppendSize(CFile rFile) {
        return true;
    }

    private void UpdateThumbImage(Icon rIcon, CFile fFile) {
        if (fFile != null) {
            if (rIcon == null) {
                rIcon = fFile.GetIcon32();
            }
            if (rIcon == null) {
                rIcon = fFile.GetIcon16();
            }
        }
        if (this.m_cThumb != null && rIcon != null) {
            this.m_cThumb.setIcon(rIcon);
        }
    }

    public CThumbnailMsg GetThumbMsg() {
        return this.m_ThumbnailMsg;
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 4239: {
                    CThumbnailMsg rThumbMsg = (CThumbnailMsg)rMsg;
                    this.OnRecvThumbnail(rThumbMsg);
                    break;
                }
                case 4201: {
                    CThumbnailMsg rThumbMsg;
                    if (!(rMsg instanceof CThumbnailMsg) || this.m_ThumbnailMsg != (rThumbMsg = (CThumbnailMsg)rMsg)) break;
                    this.OnRecvThumbnail(rThumbMsg);
                    break;
                }
            }
        }
        super.OnMessage(rMsg);
    }

    protected void OnRecvThumbnail(CThumbnailMsg rThumbMsg) {
        if (rThumbMsg != null && this.GetAttrID() == rThumbMsg.GetUISourceAttrID() && this.GetFile() != null) {
            String sPath = this.GetFile().GetAbsPath();
            String sSourcePath = rThumbMsg.GetSourcePath();
            if (sPath != null && sSourcePath != null && sPath.equals(sSourcePath)) {
                this.m_bReceivedThumb = true;
                ImageIcon rThumbImg = rThumbMsg.GetThumbImage();
                if (rThumbImg != null) {
                    this.UpdateThumbImage(rThumbImg, this.GetFile());
                }
                rThumbMsg.RemoveSUConnection();
            }
        }
    }

    public void CancelThumbs() {
        if (this.GetThumbMsg() != null) {
            this.GetThumbMsg().SetCancel(true);
        }
    }

    protected int GetThumbWidth() {
        int nThumbWidth = 70;
        return nThumbWidth;
    }

    protected int GetThumbHeight() {
        int nThumbHeight = 70;
        return nThumbHeight;
    }

    public boolean HasReceivedThumb() {
        return this.m_bReceivedThumb;
    }

    public void CheckForAfterActionThumb(long lUISourceAttrID, CThumbnailMsg.AFTER_THUMB_ACTION nAfterThumbAction) {
        if (!this.HasReceivedThumb() && this.GetThumbMsg() != null) {
            this.GetThumbMsg().SetAfterThumbAction(nAfterThumbAction);
            if (DEBUG_AFTER_ACTION_THUMB) {
                CAttr rFrom = CAttr.FindGlobalAttr(this.GetThumbMsg().GetUISourceAttrID());
                CAttr rTo = CAttr.FindGlobalAttr(lUISourceAttrID);
                CDebugLog.INFO(String.format("From: %s | To: %s\r\n", rFrom.toString(), rTo.toString()));
            }
            this.GetThumbMsg().SetUISourceAttrID_AfterThumb(lUISourceAttrID);
            if (DEBUG_AFTER_ACTION_THUMB) {
                CDebugLog.INFO("UISourceAttrID: " + lUISourceAttrID);
            }
        }
    }
}

