/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dialogs;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.CObjectAttr;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.CRhinoEvent;
import com.rhinosoft.ui.IRhinoConsts;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;

public class CRhinoOverwriteBtn
extends AbstractButton
implements MouseListener,
FocusListener,
KeyListener {
    public static boolean DEBUG = CAttr.DEBUG;
    private CObjectAttr m_ObjectAttr;
    private boolean m_bPaintEffects;
    private Color m_clrBlue;
    private Insets m_Insets;
    private boolean m_bPaintMouseRolloverEffect;
    private Color m_MouseRolloverBorderClr;
    private Color m_MouseRolloverClr1;
    private Color m_MouseRolloverClr2;
    private boolean m_bPaintFocusRolloverEffect;
    private Color m_KeyboardRolloverBorderClr;
    private Color m_KeyboardRolloverClr1;
    private Color m_KeyboardRolloverClr2;
    private String m_sTitle;
    private String m_sDesc;
    private JLabel m_cArrow;
    private JLabel m_cTitle;
    private JLabel m_cDesc;
    private JScrollPane m_ScrollFmtLabel;
    private JLabel m_cFileName;
    private JLabel m_cFileNameEx;
    private JLabel m_cFileSize;
    private JLabel m_cModifiedTimestamp;
    protected StringBuilder m_sbHTML = new StringBuilder();
    private boolean m_bAllowFocusEffect = true;
    private boolean m_bAllowFocusBorder = true;
    private boolean m_bAllowMouseEffect = true;
    private boolean m_bAllowMouseBorder = true;

    public CRhinoOverwriteBtn() {
        this._CRhinoOverwriteBtn(null, null);
    }

    public CRhinoOverwriteBtn(String sTitle, String sDesc) {
        this._CRhinoOverwriteBtn(sTitle, sDesc);
    }

    private void _CRhinoOverwriteBtn(String sTitle, String sDesc) {
        this.m_ObjectAttr = new CObjectAttr();
        this.m_ObjectAttr.SetObject(this);
        this.m_bPaintEffects = this.GetPaintEffects();
        this.m_bPaintMouseRolloverEffect = false;
        this.m_bPaintFocusRolloverEffect = true;
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.m_MouseRolloverBorderClr = new Color(185, 215, 252);
        this.m_MouseRolloverClr1 = new Color(237, 245, 255);
        this.m_MouseRolloverClr2 = new Color(253, 254, 255);
        this.m_KeyboardRolloverBorderClr = new Color(218, 218, 218);
        this.m_KeyboardRolloverClr1 = new Color(251, 251, 252);
        this.m_KeyboardRolloverClr2 = new Color(230, 230, 230);
        this.setOpaque(false);
        this.setFocusable(true);
        this.m_clrBlue = new Color(0, 51, 153);
        this.m_cArrow = new JLabel();
        this.m_cArrow.setIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_ARROW_EAST_16_PNG.GetFileName()));
        this.m_cArrow.setVerticalAlignment(3);
        this.m_cTitle = new JLabel();
        this.m_cTitle.setForeground(this.m_clrBlue);
        this.m_cDesc = new JLabel();
        this.m_cDesc.setForeground(this.m_clrBlue);
        if (this.CanChangeFont()) {
            Font font = this.m_cTitle.getFont();
            font = new Font(font.getName(), 0, 16);
            this.m_cTitle.setFont(font);
            font = this.m_cDesc.getFont();
            font = new Font(font.getName(), 0, font.getSize());
            this.m_cDesc.setFont(font);
        }
        this.SetTitle(sTitle);
        this.SetDesc(sDesc);
        this.InitScrollControls();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        this.m_cArrow.setPreferredSize(new Dimension(this.m_cArrow.getPreferredSize().width, this.m_cTitle.getPreferredSize().height));
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.m_cArrow, -1, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cTitle, -1, -2, Short.MAX_VALUE).addComponent(this.m_cDesc, -1, -2, Short.MAX_VALUE).addComponent(this.m_ScrollFmtLabel, -1, -2, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.m_cArrow, -1, -2, -2).addComponent(this.m_cTitle, -1, -2, -2)).addComponent(this.m_cDesc, -1, -2, -2).addComponent(this.m_ScrollFmtLabel, -1, -2, Short.MAX_VALUE));
    }

    @Override
    public Insets getInsets() {
        if (this.m_Insets == null) {
            this.m_Insets = new Insets(5, 5, 5, 5);
        }
        return this.m_Insets;
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    protected Color GetBlueClr() {
        return this.m_clrBlue;
    }

    protected JLabel GetArrowLabel() {
        return this.m_cArrow;
    }

    protected JLabel GetTitleLabel() {
        return this.m_cTitle;
    }

    protected JLabel GetDescLabel() {
        return this.m_cDesc;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.FireEvent();
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.m_bPaintMouseRolloverEffect = true;
        this.m_bPaintFocusRolloverEffect = false;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.m_bPaintMouseRolloverEffect = false;
        this.m_bPaintFocusRolloverEffect = true;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.m_bPaintEffects) {
            RoundRectangle2D.Float roundedRectangle;
            GradientPaint gradient;
            Graphics2D g2 = (Graphics2D)g;
            if (this.isFocusOwner() && this.m_bPaintFocusRolloverEffect) {
                if (this.m_bAllowFocusEffect) {
                    gradient = new GradientPaint(2.0f, 2.0f, this.m_KeyboardRolloverClr1, 2.0f, this.getHeight() - 2, this.m_KeyboardRolloverClr2);
                    g2.setPaint(gradient);
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                if (this.m_bAllowFocusBorder) {
                    g2.setPaint(this.m_KeyboardRolloverBorderClr);
                    roundedRectangle = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth() - 1, this.getHeight() - 1, 5.0f, 5.0f);
                    g2.draw(roundedRectangle);
                }
            }
            if (this.m_bPaintMouseRolloverEffect) {
                if (this.m_bAllowMouseEffect) {
                    gradient = new GradientPaint(2.0f, 2.0f, this.m_MouseRolloverClr2, 2.0f, this.getHeight() - 2, this.m_MouseRolloverClr1);
                    g2.setPaint(gradient);
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                if (this.m_bAllowMouseBorder) {
                    g2.setPaint(this.m_MouseRolloverBorderClr);
                    roundedRectangle = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth() - 1, this.getHeight() - 1, 5.0f, 5.0f);
                    g2.draw(roundedRectangle);
                }
            }
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent event) {
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 32) {
            event.consume();
            this.FireEvent();
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    private void FireEvent() {
        if (this.getModel() != null) {
            this.getModel().setArmed(true);
        }
        this.fireActionPerformed(new ActionEvent(this, 1001, ""));
    }

    public void SetTitle(String sTitle) {
        this.m_sTitle = sTitle;
        if (this.m_cTitle != null) {
            this.m_cTitle.setText(sTitle);
        }
    }

    public void SetDesc(String sDesc) {
        this.m_sDesc = sDesc;
        if (this.m_cDesc != null) {
            this.m_cDesc.setText(sDesc);
        }
    }

    public void SetPaintFocusRolloverEffect(boolean bPaint) {
        this.m_bPaintFocusRolloverEffect = bPaint;
        this.repaint();
    }

    protected boolean GetPaintEffects() {
        return true;
    }

    protected boolean CanChangeFont() {
        boolean bCanChangeFont = true;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            bCanChangeFont = CRhinoApp.GET_RHINO_APP().CanChangeFont();
        }
        return bCanChangeFont;
    }

    @Override
    protected void processEvent(AWTEvent event) {
        super.processEvent(event);
        if (event instanceof CRhinoEvent) {
            CRhinoEvent rRhinoEvent = (CRhinoEvent)event;
            Object objSource = rRhinoEvent.getSource();
            if (objSource instanceof CAttrMsg) {
                CAttrMsg rMsg = (CAttrMsg)objSource;
                this.OnMessage(rMsg);
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  We only handle CAttrMsg objects!");
            }
        }
    }

    public void OnMessage(CAttrMsg rMsg) {
    }

    public long GetAttrID() {
        return this.m_ObjectAttr.GetUniqueID();
    }

    public boolean GetPaintMouseRolloverEffect() {
        return this.m_bPaintMouseRolloverEffect;
    }

    public Color GetMouseRolloverClr1() {
        return this.m_MouseRolloverClr1;
    }

    public Color GetMouseRolloverClr2() {
        return this.m_MouseRolloverClr2;
    }

    public boolean GetPaintFocusRolloverEffect() {
        return this.m_bPaintFocusRolloverEffect;
    }

    public Color GetKeyboardRolloverClr1() {
        return this.m_KeyboardRolloverClr1;
    }

    public Color GetKeyboardRolloverClr2() {
        return this.m_KeyboardRolloverClr2;
    }

    public void SetAllowFocusEffect(boolean bAllow) {
        this.m_bAllowFocusEffect = bAllow;
    }

    public void SetAllowFocusBorder(boolean bAllow) {
        this.m_bAllowFocusBorder = bAllow;
    }

    public void SetAllowMouseEffect(boolean bAllow) {
        this.m_bAllowMouseEffect = bAllow;
    }

    public void SetAllowMouseBorder(boolean bAllow) {
        this.m_bAllowMouseBorder = bAllow;
    }

    public void SetAllowEffects(boolean bAllow) {
        this.SetAllowFocusEffect(bAllow);
        this.SetAllowMouseEffect(bAllow);
    }

    private void InitScrollControls() {
        this.m_cFileName = new JLabel();
        this.m_cFileNameEx = new JLabel();
        this.m_cFileNameEx.setForeground(this.GetBlueClr());
        this.m_cFileSize = new JLabel();
        this.m_cModifiedTimestamp = new JLabel();
        if (this.CanChangeFont()) {
            Font font = this.m_cFileName.getFont();
            font = new Font(font.getName(), 1, font.getSize() + 1);
            this.m_cFileName.setFont(font);
            JLabel[] aLbls = new JLabel[]{this.m_cFileNameEx, this.m_cFileSize, this.m_cModifiedTimestamp};
            for (int nIdx = 0; nIdx < aLbls.length; ++nIdx) {
                JLabel rLbl = aLbls[nIdx];
                if (rLbl == null) continue;
                font = rLbl.getFont();
                font = new Font(font.getName(), 0, font.getSize());
                rLbl.setFont(font);
            }
        }
        this.m_cFileName.addMouseListener(this);
        this.m_cFileNameEx.addMouseListener(this);
        this.m_cFileSize.addMouseListener(this);
        this.m_cModifiedTimestamp.addMouseListener(this);
        JPanel rPanel = new JPanel();
        rPanel.setOpaque(false);
        rPanel.setFocusable(false);
        rPanel.addMouseListener(this);
        GroupLayout layout = new GroupLayout(rPanel);
        rPanel.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cFileName, -1, -2, Short.MAX_VALUE).addComponent(this.m_cFileNameEx, -1, -2, Short.MAX_VALUE).addComponent(this.m_cFileSize, -1, -2, Short.MAX_VALUE).addComponent(this.m_cModifiedTimestamp, -1, -2, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.m_cFileName, -1, -2, -2).addComponent(this.m_cFileNameEx, -1, -2, -2).addComponent(this.m_cFileSize, -1, -2, -2).addComponent(this.m_cModifiedTimestamp, -1, -2, -2));
        this.m_ScrollFmtLabel = new JScrollPane(rPanel);
        this.m_ScrollFmtLabel.setOpaque(false);
        this.m_ScrollFmtLabel.getViewport().setOpaque(false);
        this.m_ScrollFmtLabel.getViewport().setFocusable(false);
        this.m_ScrollFmtLabel.setBorder(BorderFactory.createEmptyBorder());
        this.m_ScrollFmtLabel.setMinimumSize(this.GetMinScrollSize());
        this.SetVisible_FileNameEx(false);
        this.SetVisible_Size(false);
        this.SetVisible_ModifiedTimestamp(false);
    }

    protected Dimension GetMinScrollSize() {
        return new Dimension(100, 35);
    }

    public void SetFileNameText(String sText) {
        this.m_cFileName.setText(sText);
    }

    public void SetFileNameExText(String sText) {
        this.m_cFileNameEx.setText(sText);
    }

    public void SetSizeText(String sText) {
        this.m_cFileSize.setText(sText);
    }

    public void SetModifiedTimestampText(String sText) {
        this.m_cModifiedTimestamp.setText(sText);
    }

    protected JScrollPane GetFmtScrollPane() {
        return this.m_ScrollFmtLabel;
    }

    protected void SetVisible_FileNameEx(boolean bIsVisible) {
        if (this.m_cFileNameEx != null) {
            this.m_cFileNameEx.setVisible(bIsVisible);
        }
    }

    protected void SetVisible_Size(boolean bIsVisible) {
        if (this.m_cFileSize != null) {
            this.m_cFileSize.setVisible(bIsVisible);
        }
    }

    protected void SetVisible_ModifiedTimestamp(boolean bIsVisible) {
        if (this.m_cModifiedTimestamp != null) {
            this.m_cModifiedTimestamp.setVisible(bIsVisible);
        }
    }
}

