/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dialogs;

import com.rhinosoft.attrs.CFilePathAttr;
import com.rhinosoft.attrs.CLongAttr;
import com.rhinosoft.attrs.CStringAttr;
import com.rhinosoft.dialogs.CLogOptionsTreePanel;
import com.rhinosoft.dialogs.CRhinoOptionsPanel;
import com.rhinosoft.dialogs.CRhinoPrefsDlg;
import com.rhinosoft.dialogs.CRhinoPrefsTreePanel;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.util.Locale;
import javax.swing.ImageIcon;

public class CRhinoOptionsDlg
extends CRhinoPrefsDlg {
    public CRhinoOptionsDlg(Window wndOwner, String sTitle) {
        super(wndOwner, sTitle, Dialog.ModalityType.DOCUMENT_MODAL);
        this.OnCreate();
    }

    private void OnCreate() {
        ImageIcon ico = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PREFERENCES_PNG.GetFileName());
        if (ico != null) {
            this.setIconImage(ico.getImage());
        }
        this.setTitle(CString.LoadString("IDS_OPTIONS_DLG_TITLE"));
        this.SetRhinoLogo(null);
        this.SetResellerLogo(null);
    }

    @Override
    protected void InitTreePanels() {
        CRhinoPrefsTreePanel rPanel = new CRhinoOptionsPanel(CString.LoadString("IDS_OPTIONS_NODE"), CString.LoadString("IDS_OPTIONS_NODE"));
        this.AddTreePanel(rPanel);
        CStringAttr rsDesc = new CStringAttr("", "");
        CLongAttr rnFormat = new CLongAttr(1L, 1L);
        CFilePathAttr rsAbsPath = new CFilePathAttr("C:\\Temp2\\Log.html", "C:\\Temp2\\Log.html");
        CLongAttr rnItemsBeforeFlush = new CLongAttr(10L, 10L);
        CLongAttr rnItemsKeptBetweenFlushes = new CLongAttr(5L, 5L);
        rPanel = new CLogOptionsTreePanel(CString.LoadString("IDS_LOG_OPTS_TITLE"), CString.LoadString("IDS_LOG_OPTS_TITLE"), rsDesc, rnFormat, rsAbsPath, rnItemsBeforeFlush, rnItemsKeptBetweenFlushes);
        this.AddTreePanel(rPanel);
    }

    @Override
    protected String GetBannerText() {
        String sRet = "RhinoSoft";
        if (CRhinoApp.GET_RHINO_APP() != null) {
            sRet = String.format("%s", CRhinoApp.GET_RHINO_APP().GetAppName());
        }
        return sRet;
    }

    @Override
    protected int GetTreeSizeWidth() {
        CLocalFileSystem rLFS;
        String sLang;
        int nWidth = super.GetTreeSizeWidth();
        if (CRhinoApp.GET_RHINO_APP() != null && (sLang = CRhinoApp.GET_RHINO_APP().GetLanguageCode()) != null && (rLFS = CLocalFileSystem.GetLocalFileSystem()) != null) {
            if (rLFS.IsMac()) {
                if (sLang.equalsIgnoreCase(Locale.GERMAN.getLanguage())) {
                    nWidth += 20;
                } else if (sLang.equalsIgnoreCase(Locale.ITALIAN.getLanguage())) {
                    nWidth += 120;
                } else if (sLang.equalsIgnoreCase("es")) {
                    nWidth += 150;
                } else if (sLang.equalsIgnoreCase(Locale.CHINESE.getLanguage())) {
                    nWidth += 0;
                } else if (sLang.equalsIgnoreCase(Locale.JAPANESE.getLanguage())) {
                    nWidth += 20;
                }
            } else if (rLFS.IsNIX()) {
                if (sLang.equalsIgnoreCase(Locale.GERMAN.getLanguage())) {
                    nWidth += 80;
                } else if (sLang.equalsIgnoreCase(Locale.ITALIAN.getLanguage())) {
                    nWidth += 130;
                } else if (sLang.equalsIgnoreCase("es")) {
                    nWidth += 180;
                } else if (sLang.equalsIgnoreCase("ru")) {
                    nWidth += 60;
                } else if (sLang.equalsIgnoreCase(Locale.CHINESE.getLanguage())) {
                    nWidth += 0;
                } else if (sLang.equalsIgnoreCase(Locale.JAPANESE.getLanguage())) {
                    nWidth += 20;
                }
            } else {
                nWidth = sLang.equalsIgnoreCase(Locale.GERMAN.getLanguage()) ? (nWidth += 10) : (sLang.equalsIgnoreCase(Locale.ITALIAN.getLanguage()) ? (nWidth += 80) : (sLang.equalsIgnoreCase("es") ? (nWidth += 100) : (sLang.equalsIgnoreCase("ru") ? (nWidth += 5) : (sLang.equalsIgnoreCase(Locale.CHINESE.getLanguage()) ? (nWidth += 0) : (sLang.equalsIgnoreCase(Locale.JAPANESE.getLanguage()) ? (nWidth += 0) : (nWidth += 5))))));
            }
        }
        return nWidth;
    }

    @Override
    protected Dimension CreateInitialSize() {
        CLocalFileSystem rLFS;
        String sLang;
        Dimension dim = new Dimension(680, 600);
        if (CRhinoApp.GET_RHINO_APP() != null && (sLang = CRhinoApp.GET_RHINO_APP().GetLanguageCode()) != null && (rLFS = CLocalFileSystem.GetLocalFileSystem()) != null) {
            if (rLFS.IsMac()) {
                if (sLang.equalsIgnoreCase(Locale.GERMAN.getLanguage())) {
                    dim.width += 290;
                    dim.height += 120;
                } else if (sLang.equalsIgnoreCase(Locale.ITALIAN.getLanguage())) {
                    dim.width += 280;
                    dim.height += 120;
                } else if (sLang.equalsIgnoreCase(Locale.FRENCH.getLanguage())) {
                    dim.width += 260;
                    dim.height += 100;
                } else if (sLang.equalsIgnoreCase("es")) {
                    dim.width += 270;
                    dim.height += 120;
                } else if (sLang.equalsIgnoreCase("ru")) {
                    dim.width += 280;
                    dim.height += 120;
                } else if (sLang.equalsIgnoreCase(Locale.CHINESE.getLanguage())) {
                    dim.width += 20;
                    dim.height += 90;
                } else if (sLang.equalsIgnoreCase(Locale.JAPANESE.getLanguage())) {
                    dim.width += 180;
                    dim.height += 130;
                } else {
                    dim.width += 160;
                    dim.height += 120;
                }
            } else if (rLFS.IsNIX()) {
                if (sLang.equalsIgnoreCase(Locale.GERMAN.getLanguage())) {
                    dim.width += 330;
                    dim.height += 90;
                } else if (sLang.equalsIgnoreCase(Locale.ITALIAN.getLanguage())) {
                    dim.width += 330;
                    dim.height += 90;
                } else if (sLang.equalsIgnoreCase(Locale.FRENCH.getLanguage())) {
                    dim.width += 320;
                    dim.height += 80;
                } else if (sLang.equalsIgnoreCase("es")) {
                    dim.width += 330;
                    dim.height += 100;
                } else if (sLang.equalsIgnoreCase("ru")) {
                    dim.width += 340;
                    dim.height += 100;
                } else if (sLang.equalsIgnoreCase(Locale.CHINESE.getLanguage())) {
                    dim.width += 20;
                    dim.height += 90;
                } else {
                    dim.width += 160;
                    dim.height += 80;
                }
            } else if (sLang.equalsIgnoreCase(Locale.GERMAN.getLanguage())) {
                dim.width += 80;
                dim.height += 20;
            } else if (sLang.equalsIgnoreCase(Locale.ITALIAN.getLanguage())) {
                dim.width += 80;
                dim.height += 20;
            } else if (sLang.equalsIgnoreCase(Locale.FRENCH.getLanguage())) {
                dim.width += 80;
            } else if (sLang.equalsIgnoreCase("es")) {
                dim.width += 180;
                dim.height += 20;
            } else if (sLang.equalsIgnoreCase("ru")) {
                dim.width += 140;
                dim.height += 20;
            } else if (sLang.equalsIgnoreCase(Locale.CHINESE.getLanguage())) {
                dim.width += 0;
                dim.height += 0;
            } else {
                dim.width += 20;
                dim.height += 40;
            }
        }
        return dim;
    }
}

