/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dialogs;

import com.rhinosoft.attrs.CAttrs;
import com.rhinosoft.dialogs.CConfirmOnCloseDlg;
import com.rhinosoft.dialogs.CRhinoDialog;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CWorkerThreadMsg;
import com.rhinosoft.strings.CString;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.CRhinoEvent;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;

public class CRhinoMessageBox
extends JDialog
implements ActionListener,
WindowListener,
KeyListener {
    public static boolean DEBUG = CAttrs.DEBUG;
    public static boolean DEBUG_ASSERT_ON_NON_RHINO_EVENTS = CRhinoApp.DEBUG_ASSERT_ON_NON_RHINO_EVENTS;
    public static final int CLOSED_OPTION = -1;
    public static final int OK_OPTION = 0;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    private int m_nDlgType = -1;
    private int m_nImageType = -1;
    private int m_nResult = -1;
    protected JLabel m_cImage;
    private String m_sMessage;
    protected JScrollPane m_cScrollPaneMessage;
    protected JTextPane m_cMessage;
    protected String m_sYesBtnText;
    protected String m_sNoBtnText;
    protected String m_sCancelBtnText;
    protected JButton m_cYes;
    protected JButton m_cNo;
    protected JButton m_cCancel;
    protected JCheckBox m_cDoNotAskAgain;
    private boolean m_bInitialized;
    private Window m_rCenterTo;
    protected JPanel m_MainPanel;
    private boolean m_bConfirmClose = false;
    private CConfirmOnCloseDlg m_ConfirmCloseDlg;

    protected CRhinoMessageBox(Window rOwnerWnd) {
        this(rOwnerWnd, Dialog.DEFAULT_MODALITY_TYPE);
    }

    protected CRhinoMessageBox(Window rOwnerWnd, Dialog.ModalityType modalityType) {
        super(rOwnerWnd, modalityType);
        this.CheckModalityType(modalityType);
        this.m_rCenterTo = rOwnerWnd;
    }

    public CRhinoMessageBox(Window rOwnerWnd, String sTitle, ArrayList<Image> aWindowImages, int nDlgType, int nImageType, String sMessage) {
        this(rOwnerWnd, Dialog.DEFAULT_MODALITY_TYPE, sTitle, aWindowImages, nDlgType, nImageType, sMessage);
    }

    public CRhinoMessageBox(Window rOwnerWnd, Dialog.ModalityType modalityType, String sTitle, ArrayList<Image> aWindowImages, int nDlgType, int nImageType, String sMessage) {
        super(rOwnerWnd, modalityType);
        this.CheckModalityType(modalityType);
        this.Init(rOwnerWnd, sTitle, aWindowImages, nDlgType, nImageType, sMessage);
    }

    protected final void Init(Window rCenterTo, String sTitle, ArrayList<Image> aWindowImages, int nDlgType, int nImageType, String sMessage) {
        JButton rBtn;
        int nIdx;
        this.m_sMessage = sMessage;
        this.m_rCenterTo = rCenterTo;
        this.setDefaultCloseOperation(0);
        this.m_bInitialized = false;
        this.m_bConfirmClose = this.FetchConfirmClose();
        if (this.m_bConfirmClose) {
            this.m_ConfirmCloseDlg = new CConfirmOnCloseDlg((Window)this);
        }
        this.setTitle(sTitle);
        if (aWindowImages == null) {
            this.InitTitleImages();
        } else {
            this.setIconImages(aWindowImages);
        }
        this.addWindowListener(this);
        this.addKeyListener(this);
        this.m_cImage = new JLabel();
        this.m_cYes = this.CreateYesBtn();
        this.m_cNo = this.CreateNoBtn();
        this.m_cCancel = this.CreateCancelBtn();
        this.m_cDoNotAskAgain = this.CreateDoNotShowAgainBtn();
        this.m_nDlgType = nDlgType;
        this.SetBtnTxt(this.m_cYes, this.GetYesBtnText());
        this.SetBtnTxt(this.m_cNo, this.GetNoBtnText());
        this.SetBtnTxt(this.m_cCancel, this.GetCancelBtnText());
        this.SetBtnTxt(this.m_cDoNotAskAgain, this.GetDoNotShowAgainBtnText());
        Dimension dimSize = this.m_cYes.getPreferredSize();
        JButton[] aBtns = new JButton[]{this.m_cYes, this.m_cNo, this.m_cCancel};
        for (nIdx = 0; nIdx < aBtns.length; ++nIdx) {
            rBtn = aBtns[nIdx];
            Dimension dimTemp = rBtn.getPreferredSize();
            dimSize.width = Math.max(dimSize.width, dimTemp.width);
            dimSize.height = Math.max(dimSize.height, dimTemp.height);
        }
        for (nIdx = 0; nIdx < aBtns.length; ++nIdx) {
            rBtn = aBtns[nIdx];
            rBtn.setPreferredSize(dimSize);
            rBtn.addActionListener(this);
        }
        this.AddKeyListener(this.m_cYes);
        this.AddKeyListener(this.m_cNo);
        this.AddKeyListener(this.m_cCancel);
        this.AddKeyListener(this.m_cDoNotAskAgain);
        this.AddKeyListener(this);
        this.SetDialogType(nDlgType);
        this.SetImageType(nImageType);
        this.CreateUI();
        if (this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(this.GetDefaultBtn());
        }
    }

    private void CheckModalityType(Dialog.ModalityType nModalType) {
        Dialog.ModalityType nCheckedType;
        if (CRhinoApp.GET_RHINO_APP() != null && nModalType != (nCheckedType = CRhinoApp.GET_RHINO_APP().SendFetchDialogModalityType(this))) {
            this.setModalityType(nCheckedType);
        }
    }

    protected boolean FetchConfirmClose() {
        return false;
    }

    public final boolean GetConfirmClose() {
        return this.m_bConfirmClose;
    }

    protected void CreateUI() {
        this.m_cMessage = new JTextPane();
        this.m_cScrollPaneMessage = new JScrollPane(this.m_cMessage);
        this.SetMessage(this.m_sMessage);
        this.m_cMessage.setEditable(false);
        this.m_cMessage.setBorder(BorderFactory.createEmptyBorder());
        this.m_cScrollPaneMessage.setBorder(BorderFactory.createEmptyBorder());
        Color clr = UIManager.getColor("Label.background");
        this.m_cMessage.setBackground(clr);
        this.m_MainPanel = new JPanel();
        GroupLayout layout = new GroupLayout(this.m_MainPanel);
        this.m_MainPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.m_cImage, -1, -2, -2).addGap(10).addComponent(this.m_cScrollPaneMessage, -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.m_cDoNotAskAgain, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -2, Short.MAX_VALUE).addComponent(this.m_cYes, -1, -2, -2).addComponent(this.m_cNo, -1, -2, -2).addComponent(this.m_cCancel, -1, -2, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.m_cImage, -1, -2, -2).addComponent(this.m_cScrollPaneMessage, -1, -2, Short.MAX_VALUE)).addGroup(layout.createParallelGroup().addComponent(this.m_cDoNotAskAgain, -1, -2, -2).addComponent(this.m_cYes, -1, -2, -2).addComponent(this.m_cNo, -1, -2, -2).addComponent(this.m_cCancel, -1, -2, -2)));
        this.add(this.m_MainPanel);
        this.m_cScrollPaneMessage.setMinimumSize(new Dimension(100, 40));
        this.m_cScrollPaneMessage.setPreferredSize(new Dimension(100, 40));
        this.setMinimumSize(new Dimension(350, 140));
        this.setPreferredSize(new Dimension(350, 140));
        this.AddKeyListener(this.m_cImage);
        this.AddKeyListener(this.m_cScrollPaneMessage);
        this.AddKeyListener(this.m_cMessage);
        this.AddKeyListener(this.m_MainPanel);
        this.SetVisible_DoNotAskAgain(false);
    }

    protected JButton GetDefaultBtn() {
        return this.m_cYes;
    }

    public int GetImageType() {
        return this.m_nImageType;
    }

    public void SetImageType(int nImageType) {
        this.m_nImageType = nImageType;
        this.InitImage();
    }

    protected void InitImage() {
        Icon icon = null;
        switch (this.GetImageType()) {
            case 3: {
                icon = UIManager.getIcon("OptionPane.questionIcon");
                break;
            }
            case 1: {
                icon = UIManager.getIcon("OptionPane.informationIcon");
                break;
            }
            case 2: {
                icon = UIManager.getIcon("OptionPane.warningIcon");
                break;
            }
            case 0: {
                icon = UIManager.getIcon("OptionPane.errorIcon");
                break;
            }
            default: {
                icon = null;
            }
        }
        this.m_cImage.setIcon(icon);
    }

    public boolean GetDoNotShowAgain() {
        return this.m_cDoNotAskAgain.isSelected();
    }

    public int GetResult() {
        return this.m_nResult;
    }

    protected void SetResult(int nResult) {
        this.m_nResult = nResult;
    }

    @Override
    public void windowOpened(WindowEvent event) {
    }

    @Override
    public void windowClosing(WindowEvent event) {
        this.OnClose(-1);
    }

    @Override
    public void windowClosed(WindowEvent event) {
    }

    @Override
    public void windowIconified(WindowEvent event) {
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
    }

    @Override
    public void windowActivated(WindowEvent event) {
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int nResult = -1;
        if (event.getSource() == this.m_cNo) {
            nResult = 1;
        } else if (event.getSource() == this.m_cCancel) {
            nResult = 2;
        } else if (event.getSource() == this.m_cYes) {
            nResult = 0;
        }
        this.OnClose(nResult);
    }

    public void OnClose(int nResult) {
        if (nResult == -1) {
            if (this.GetConfirmClose() && this.GetConfirmCloseDlg() != null) {
                this.GetConfirmCloseDlg().setVisible(true);
                if (this.GetConfirmCloseDlg().GetResult() == 0) {
                    this.OnClose(2);
                }
            } else {
                this.OnClose(2);
            }
        } else {
            this.SetResult(nResult);
            if (nResult != -1 || nResult != 2) {
                this.OnSaveAttrs();
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void setVisible(boolean bVisible) {
        if (bVisible) {
            this.SetResult(-1);
            if (!this.m_bInitialized) {
                this.m_bInitialized = true;
                this.pack();
                if (CRhinoApp.GET_RHINO_APP() != null) {
                    CRhinoApp.GET_RHINO_APP().CenterWindow(this, this.m_rCenterTo);
                } else if (this.m_rCenterTo != null) {
                    this.setLocationRelativeTo(this.m_rCenterTo);
                }
                if (this.getRootPane() != null && this.getRootPane().getDefaultButton() != null) {
                    this.getRootPane().getDefaultButton().requestFocusInWindow();
                }
                this.OnLoadAttrs();
                this.CheckDialogSize();
            }
        }
        super.setVisible(bVisible);
    }

    public int GetDialogType() {
        return this.m_nDlgType;
    }

    public void SetDialogType(int nDlgType) {
        this.m_nDlgType = nDlgType;
        this.OnUpdateDlgType();
    }

    protected void OnUpdateDlgType() {
        boolean bShowYes = true;
        boolean bShowNo = false;
        boolean bShowCancel = false;
        String sOk = CString.LoadString("IDS_OK", false);
        String sYes = this.GetYesBtnText();
        String sNo = this.GetNoBtnText();
        String sCancel = this.GetCancelBtnText();
        switch (this.GetDialogType()) {
            case 0: {
                bShowYes = true;
                bShowNo = true;
                bShowCancel = false;
                break;
            }
            case 1: {
                bShowYes = true;
                bShowNo = true;
                bShowCancel = true;
                break;
            }
            case 2: {
                bShowYes = true;
                bShowNo = false;
                bShowCancel = true;
                sYes = sOk;
                break;
            }
            default: {
                bShowYes = true;
                bShowNo = false;
                bShowCancel = false;
                sYes = sOk;
            }
        }
        this.m_cYes.setVisible(bShowYes);
        this.m_cNo.setVisible(bShowNo);
        this.m_cCancel.setVisible(bShowCancel);
        this.SetBtnTxt(this.m_cYes, sYes);
        this.SetBtnTxt(this.m_cNo, sNo);
        this.SetBtnTxt(this.m_cCancel, sCancel);
    }

    public void SetMessage(String sMessage) {
        this.m_sMessage = sMessage;
        if (this.m_cMessage != null) {
            this.m_cMessage.setText(this.m_sMessage);
        }
    }

    protected String GetYesBtnText() {
        return CString.LoadString("IDS_YES", false);
    }

    protected String GetNoBtnText() {
        return CString.LoadString("IDS_NO", false);
    }

    protected String GetCancelBtnText() {
        return CString.LoadString("IDS_CANCEL", false);
    }

    protected String GetDoNotShowAgainBtnText() {
        return CString.LoadString("IDS_DO_NOT_SHOW_AGAIN", false);
    }

    protected JButton CreateYesBtn() {
        return new JButton();
    }

    protected JButton CreateNoBtn() {
        return new JButton();
    }

    protected JButton CreateCancelBtn() {
        return new JButton();
    }

    protected JCheckBox CreateDoNotShowAgainBtn() {
        return new JCheckBox();
    }

    protected void InitTitleImages() {
    }

    protected void SetBtnTxt(AbstractButton rBtn, String sTxt) {
        CRhinoDialog.SetButtonText(rBtn, sTxt);
    }

    @Override
    public void keyTyped(KeyEvent rKeyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent rKeyEvent) {
        if (rKeyEvent != null) {
            switch (rKeyEvent.getKeyCode()) {
                case 27: {
                    this.OnClose(-1);
                    rKeyEvent.consume();
                    break;
                }
                case 89: {
                    if (!this.CheckGlobalKeySource(rKeyEvent.getSource())) break;
                    this.OnClose(0);
                    rKeyEvent.consume();
                    break;
                }
                case 78: {
                    if (!this.CheckGlobalKeySource(rKeyEvent.getSource())) break;
                    this.OnClose(1);
                    rKeyEvent.consume();
                    break;
                }
            }
        }
    }

    private boolean CheckGlobalKeySource(Object rSource) {
        boolean bIncluded = false;
        Component[] arIncluded = new Component[]{this, this.m_MainPanel, this.m_cImage, this.m_cScrollPaneMessage, this.m_cMessage, this.m_cYes, this.m_cNo, this.m_cCancel, this.m_cDoNotAskAgain};
        for (int nIdx = 0; nIdx < arIncluded.length; ++nIdx) {
            if (rSource != arIncluded[nIdx]) continue;
            bIncluded = true;
        }
        return bIncluded;
    }

    @Override
    public void keyReleased(KeyEvent rKeyEvent) {
    }

    protected void AddKeyListener(Component rComp) {
        if (rComp != null) {
            rComp.addKeyListener(this);
        }
    }

    public void SetVisible_DoNotAskAgain(boolean bVisible) {
        if (this.m_cDoNotAskAgain != null) {
            this.m_cDoNotAskAgain.setVisible(bVisible);
        }
    }

    public int GetResult_ConfirmCloseDlg() {
        int nResult = 1;
        if (this.GetConfirmCloseDlg() != null) {
            nResult = this.GetConfirmCloseDlg().GetResult();
        }
        return nResult;
    }

    public boolean GetDoNotShowAgain_ConfirmCloseDlg() {
        boolean bDoNotShowAgain = false;
        if (this.GetConfirmCloseDlg() != null) {
            bDoNotShowAgain = this.GetConfirmCloseDlg().GetDoNotShowAgain();
        }
        return bDoNotShowAgain;
    }

    public void SetConfirmClose(boolean bConfirmClose) {
        this.m_bConfirmClose = bConfirmClose;
    }

    public final CConfirmOnCloseDlg GetConfirmCloseDlg() {
        return this.m_ConfirmCloseDlg;
    }

    @Override
    protected void processEvent(AWTEvent rEvent) {
        super.processEvent(rEvent);
        if (rEvent instanceof CRhinoEvent) {
            CRhinoEvent rRhinoEvent = (CRhinoEvent)rEvent;
            Object objSource = rRhinoEvent.getSource();
            if (objSource instanceof CWorkerThreadMsg) {
                CWorkerThreadMsg rMsg = (CWorkerThreadMsg)objSource;
                this.OnMessage(rMsg);
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  We only handle CWorkerThreadMsg objects!");
            }
        } else if (DEBUG_ASSERT_ON_NON_RHINO_EVENTS) {
            CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  We only handle CRhinoEvent objects!");
        }
    }

    public void OnMessage(CAttrMsg rMsg) {
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 4005: {
                    this.OnSaveAttrs();
                    break;
                }
                case 4004: {
                    this.OnLoadAttrs();
                    break;
                }
            }
        }
    }

    protected void OnSaveAttrs() {
    }

    protected void OnLoadAttrs() {
    }

    protected void CheckDialogSize() {
    }
}

