/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dialogs;

import com.rhinosoft.attrs.CAttrs;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CCacheMsg;
import com.rhinosoft.messages.CWorkerThreadMsg;
import com.rhinosoft.strings.CString;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.CRhinoEvent;
import com.rhinosoft.ui.IRhinoConsts;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class CRhinoDialog
extends JDialog
implements ActionListener,
KeyListener {
    public static boolean DEBUG = CAttrs.DEBUG;
    private int m_nExitCode;
    protected ImageIcon m_TitleIcon;
    private Dimension m_dimInitialSize;
    private boolean m_bSetInitialSizeAndLocation;

    public CRhinoDialog(Window wndOwner, String sTitle, Dialog.ModalityType nModalType) {
        super(wndOwner, sTitle, nModalType);
        this.CheckModalityType(nModalType);
        this.m_nExitCode = 2;
        this.setDefaultCloseOperation(0);
        this.addKeyListener(this);
        this.InitTitleIcon();
        this.m_dimInitialSize = this.CreateInitialSize();
        this.m_bSetInitialSizeAndLocation = true;
    }

    private void CheckModalityType(Dialog.ModalityType nModalType) {
        Dialog.ModalityType nCheckedType;
        if (CRhinoApp.GET_RHINO_APP() != null && nModalType != (nCheckedType = CRhinoApp.GET_RHINO_APP().SendFetchDialogModalityType(this))) {
            this.setModalityType(nCheckedType);
        }
    }

    @Override
    public void actionPerformed(ActionEvent rEvent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void SetBtnTxt(AbstractButton rBtn, String sTxt) {
        CRhinoDialog.SetButtonText(rBtn, sTxt);
    }

    public static void SetButtonText(AbstractButton rBtn, String sTxt) {
        if (rBtn != null) {
            Character chMnemonic = CString.GetMnemonic(sTxt);
            if (chMnemonic != null) {
                rBtn.setMnemonic(chMnemonic.charValue());
            }
            rBtn.setText(CString.RemoveMnemonic(sTxt));
        }
    }

    public void OnClose(int nExitCode) {
        this.SetExitCode(nExitCode);
        this.setVisible(false);
        this.dispose();
    }

    public int GetExitCode() {
        return this.m_nExitCode;
    }

    protected void SetExitCode(int nExitCode) {
        this.m_nExitCode = nExitCode;
    }

    public static void AddEscapeKeyListener(JComponent rComp) {
        if (rComp != null) {
            rComp.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent rKeyEvent) {
                    Component rCompSource;
                    JDialog rDlg;
                    Object rSource;
                    if (rKeyEvent != null && rKeyEvent.getKeyCode() == 27 && (rSource = rKeyEvent.getSource()) instanceof Component && (rDlg = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, rCompSource = (Component)rSource)) != null) {
                        rDlg.dispatchEvent(new KeyEvent(rDlg, rKeyEvent.getID(), rKeyEvent.getWhen(), rKeyEvent.getModifiers(), rKeyEvent.getKeyCode(), rKeyEvent.getKeyChar(), rKeyEvent.getKeyLocation()));
                    }
                }
            });
        }
    }

    @Override
    public void keyTyped(KeyEvent rKeyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent rKeyEvent) {
        if (rKeyEvent != null && rKeyEvent.getKeyCode() == 27) {
            this.OnClose(-1);
            rKeyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent rKeyEvent) {
    }

    protected void OnRecvCacheImage(String sFileName) {
        if (this.GetTitleIconFileName().equals(sFileName) && this.GetTitleIcon() != null) {
            this.setIconImage(this.GetTitleIcon().getImage());
        }
    }

    protected void OnSaveAttrs() {
    }

    protected void OnLoadAttrs() {
    }

    @Override
    public void setVisible(boolean bVisible) {
        if (bVisible) {
            this.OnMessage(new CWorkerThreadMsg(4004));
            if (this.m_bSetInitialSizeAndLocation) {
                this.m_bSetInitialSizeAndLocation = false;
                this.setSize(this.GetInitialSize());
                if (CRhinoApp.GET_RHINO_APP() != null) {
                    CRhinoApp.GET_RHINO_APP().CenterWindow(this, null);
                }
            }
        } else if (this.GetExitCode() == 0) {
            this.OnMessage(new CWorkerThreadMsg(4005));
        }
        super.setVisible(bVisible);
    }

    protected String GetTitleIconFileName() {
        return IRhinoConsts.CACHE_IMAGES_COMMON.IMG_RHINO_16x16_PNG.GetFileName();
    }

    protected ImageIcon GetTitleIcon() {
        return this.m_TitleIcon;
    }

    protected void InitTitleIcon() {
        this.m_TitleIcon = CRhinoApp.GetImage(this.GetTitleIconFileName());
        if (this.m_TitleIcon != null) {
            this.setIconImage(this.m_TitleIcon.getImage());
        }
    }

    protected Dimension CreateInitialSize() {
        return new Dimension(800, 600);
    }

    public Dimension GetInitialSize() {
        return this.m_dimInitialSize;
    }

    @Override
    protected void processEvent(AWTEvent rEvent) {
        super.processEvent(rEvent);
        if (rEvent instanceof CRhinoEvent) {
            CRhinoEvent rRhinoEvent = (CRhinoEvent)rEvent;
            Object objSource = rRhinoEvent.getSource();
            if (objSource instanceof CWorkerThreadMsg) {
                CWorkerThreadMsg rMsg = (CWorkerThreadMsg)objSource;
                this.OnMessage(rMsg);
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  We only handle CWorkerThreadMsg objects!");
            }
        }
    }

    public void OnMessage(CAttrMsg rMsg) {
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 3010: 
                case 3202: 
                case 3203: 
                case 3204: 
                case 3205: 
                case 3207: 
                case 3208: 
                case 3211: 
                case 3212: 
                case 3213: 
                case 3215: 
                case 3217: 
                case 3218: 
                case 3219: {
                    SwingUtilities.updateComponentTreeUI(this);
                    break;
                }
                case 4005: {
                    this.OnSaveAttrs();
                    break;
                }
                case 4004: {
                    this.OnLoadAttrs();
                    break;
                }
                case 4235: {
                    if (!(rMsg instanceof CCacheMsg)) break;
                    CCacheMsg rCacheMsg = (CCacheMsg)rMsg;
                    this.OnRecvCacheImage(rCacheMsg.GetFileName());
                    break;
                }
            }
        }
    }
}

