/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dialogs;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.dialogs.CRhinoDialog;
import com.rhinosoft.dialogs.CRhinoPrefsTreePanel;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.strings.CString;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import com.rhinosoft.ui.controls.CLinkLabel;
import com.rhinosoft.ui.controls.CSeparator;
import com.rhinosoft.ui.controls.CSeparatorLink;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;

public abstract class CRhinoAboutProgInfoPanel
extends CRhinoPrefsTreePanel {
    public static final String HTML_FMT_BOLD = "<html><span style=\"font-weight: bold;\">%s</span></html>";
    protected CLinkLabel m_cSmallLogo;
    protected JPanel m_cLogoSpacer;
    protected JLabel m_jlblName;
    protected JLabel m_jlblVersion1;
    protected JLabel m_jlblVersion2;
    protected JSeparator m_cBuildDateSep;
    protected JLabel m_jlblBuildDate1;
    protected JLabel m_jlblBuildDate2;
    protected CSeparatorLink m_cContactCtrl;
    protected JLabel m_cCompanyName;
    protected JLabel m_cCompanyAddress1;
    protected JLabel m_cCompanyAddress2;
    protected CLinkLabel m_cCompanyLink;
    protected JLabel m_cResellerCompanyName;
    protected JLabel m_cResellerCompanyAddress1;
    protected JLabel m_cResellerCompanyAddress2;
    protected CLinkLabel m_cResellerLink;
    protected CSeparator m_cDevelopmentSep;
    protected JLabel m_cDevelopedByTitle;
    protected CLinkLabel m_cDevelopedByMsg;
    protected JLabel m_cResellerDevelopedByTitle;
    protected CLinkLabel m_cResellerDevelopedByMsg;
    protected JLabel m_cCopyright;
    protected CSeparator m_cLegalSep;
    protected JScrollPane m_cLegal;
    protected JTextArea m_cLegalEditor;

    public CRhinoAboutProgInfoPanel(String sLookupKey, String sTitle) {
        super(sLookupKey, sTitle);
        this.OnCreate();
    }

    @Override
    public void OnCreate() {
        super.OnCreate();
        this.m_cSmallLogo = new CLinkLabel(this.GetURL_Product());
        if (this.GetSmallLogoCtrl() != null) {
            this.GetSmallLogoCtrl().setBorder(BorderFactory.createLoweredBevelBorder());
            this.GetSmallLogoCtrl().setOpaque(true);
            this.GetSmallLogoCtrl().setBackground(new Color(255, 255, 255));
            ImageIcon rIcon = CRhinoApp.GetImage(this.GetSmallLogoIconFileName());
            if (rIcon != null) {
                Insets rInsets;
                this.GetSmallLogoCtrl().setIcon(rIcon);
                Dimension dimSize = new Dimension(rIcon.getIconWidth(), rIcon.getIconHeight());
                Border rBorder = this.GetSmallLogoCtrl().getBorder();
                if (rBorder != null && (rInsets = rBorder.getBorderInsets(this.GetSmallLogoCtrl())) != null) {
                    dimSize.width += rInsets.left + rInsets.right;
                    dimSize.height += rInsets.top + rInsets.bottom;
                }
                this.GetSmallLogoCtrl().setMinimumSize(dimSize);
                this.GetSmallLogoCtrl().setPreferredSize(dimSize);
                this.GetSmallLogoCtrl().setMaximumSize(dimSize);
            } else if (CAttr.DEBUG) {
                CDebugLog.ASSERT(CRhinoAboutProgInfoPanel.class.getName(), CDebugLog.GetLineNumber(), "Small logo is null?!");
            }
        }
        this.m_jlblName = new JLabel();
        this.m_jlblVersion1 = new JLabel();
        this.m_jlblVersion2 = new JLabel();
        this.m_jlblBuildDate1 = new JLabel();
        this.m_jlblBuildDate2 = new JLabel();
        this.m_cContactCtrl = new CSeparatorLink(this.GetURL_ContactInfo(), CString.LoadString("IDS_CONTACT_INFORMATION"));
        this.m_cCompanyName = new JLabel();
        this.m_cCompanyAddress1 = new JLabel();
        this.m_cCompanyAddress2 = new JLabel();
        this.m_cCompanyLink = new CLinkLabel(this.GetURL_WwwRhinosoftDotCom(), this.GetString_WwwRhinosoftDotCom());
        this.m_cResellerCompanyName = new JLabel(CString.LoadString("IDS_RESELLER_COMPANY_NAME"));
        this.m_cResellerCompanyAddress1 = new JLabel(CString.LoadString("IDS_RESELLER_COMPANY_ADDRESS1"));
        this.m_cResellerCompanyAddress2 = new JLabel(CString.LoadString("IDS_RESELLER_COMPANY_ADDRESS2"));
        this.m_cResellerLink = new CLinkLabel(CString.LoadString("IDS_RESELLER_COMPANY_URL"), CString.LoadString("IDS_RESELLER_COMPANY_NAME"));
        this.m_cDevelopmentSep = new CSeparator();
        this.m_cDevelopedByTitle = new JLabel();
        this.m_cDevelopedByMsg = new CLinkLabel(this.GetURL_WwwRhinosoftDotCom(), this.GetString_Rhinosoft());
        this.m_cResellerDevelopedByTitle = new JLabel(CString.LoadString("IDS_RESELLER_TRANSLATEDBY_TITLE"));
        this.m_cResellerDevelopedByMsg = new CLinkLabel(CString.LoadString("IDS_RESELLER_TRANSLATEDBY_URL"), CString.LoadString("IDS_RESELLER_TRANSLATEDBY_MSG"));
        this.m_cCopyright = new JLabel();
        this.m_cLegalSep = new CSeparator();
        this.m_cLegalEditor = new JTextArea();
        this.m_cLegal = new JScrollPane(this.m_cLegalEditor);
        CRhinoDialog.AddEscapeKeyListener(this.m_cLegalEditor);
        this.m_jlblName.setText(this.GetAppName());
        this.m_jlblVersion1.setText(CString.LoadString("IDS_VERSION"));
        this.m_jlblVersion2.setText(String.format("%d.%d.%d.%d", this.GetVersionMajor1(), this.GetVersionMajor2(), this.GetVersionMinor1(), this.GetVersionMinor2()));
        Border cMargin = BorderFactory.createEmptyBorder(0, 2, 0, 0);
        this.m_jlblName.setBorder(cMargin);
        this.m_jlblVersion1.setBorder(cMargin);
        this.m_jlblVersion2.setBorder(cMargin);
        this.m_jlblBuildDate1.setBorder(cMargin);
        this.m_jlblBuildDate2.setBorder(cMargin);
        this.m_jlblBuildDate1.setText(CString.LoadString("IDS_BUILD_PANEL_BUILD_DATE"));
        if (this.m_jlblBuildDate2 != null) {
            this.m_jlblBuildDate2.setText(String.format(HTML_FMT_BOLD, this.GetBuildDateAsString()));
        }
        this.m_cCompanyName.setText(this.GetString_Rhinosoft());
        this.m_cCompanyAddress1.setText(this.GetString_CompanyStreetAddress());
        this.m_cCompanyAddress2.setText(this.GetString_CompanyCityStateZip());
        this.m_cDevelopmentSep.setText(CString.LoadString("IDS_DEVELOPMENT"));
        this.m_cDevelopedByTitle.setText(CString.LoadString("IDS_DEVELOPED_BY"));
        GregorianCalendar awtCalendar = new GregorianCalendar();
        int nYear = awtCalendar.get(1);
        String sCopyright = String.format(CString.LoadString("IDS_COPYRIGHT"), nYear);
        this.m_cCopyright.setText(sCopyright);
        this.m_cLegalSep.setText(CString.LoadString("IDS_LEGAL"));
        this.m_cLegal.setVerticalScrollBarPolicy(20);
        this.m_cLegal.setHorizontalScrollBarPolicy(31);
        this.m_cLegal.setPreferredSize(new Dimension(100, 72));
        this.m_cLegalEditor.setEditable(false);
        this.m_cLegalEditor.setText(CString.LoadString("IDS_LEGAL_EXT"));
        this.m_cLegalEditor.setBackground(this.getBackground());
        this.m_cLegalEditor.setMargin(new Insets(1, 2, 0, 1));
        this.m_cLegalEditor.setLineWrap(true);
        this.m_cLegalEditor.setWrapStyleWord(true);
        this.m_cLegalEditor.setCaretPosition(0);
        this.m_cLegalEditor.setFont(this.m_cLegal.getFont());
        JLabel[] arComps = new JLabel[]{this.m_jlblName, this.m_jlblVersion1, this.m_jlblVersion2, this.m_jlblBuildDate2};
        for (int nIdx = 0; nIdx < arComps.length; ++nIdx) {
            JLabel rNext = arComps[nIdx];
            if (rNext == null) continue;
            String sText = String.format(HTML_FMT_BOLD, rNext.getText());
            rNext.setText(sText);
        }
        this.m_cBuildDateSep = new JSeparator();
        this.m_cLogoSpacer = new JPanel();
        if (this.GetSmallLogoCtrl() != null) {
            Dimension dimSize = this.GetSmallLogoCtrl().getMinimumSize();
            dimSize.height = dimSize.height / 4 * 3;
            this.m_cLogoSpacer.setMinimumSize(dimSize);
            dimSize = this.GetSmallLogoCtrl().getPreferredSize();
            dimSize.height = dimSize.height / 4 * 3;
            this.m_cLogoSpacer.setPreferredSize(dimSize);
            dimSize = this.GetSmallLogoCtrl().getMaximumSize();
            dimSize.height = dimSize.height / 4 * 3;
            this.m_cLogoSpacer.setMaximumSize(dimSize);
        }
        this.m_cLegal.setBorder(BorderFactory.createEtchedBorder(1));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        int nCompanyCtrlWidth = 150;
        int nDevelopedSize = 100;
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.GetHeaderIconCtrl(), -1, -2, -2).addComponent(this.GetHeaderMsgCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.GetSmallLogoCtrl(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 10, 10).addGroup(layout.createParallelGroup().addComponent(this.m_jlblName, -1, -2, -2).addGroup(layout.createSequentialGroup().addComponent(this.m_jlblVersion1, -2, -2, -2).addComponent(this.m_jlblVersion2, -2, -2, -2)))).addGroup(layout.createSequentialGroup().addComponent(this.m_cLogoSpacer, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 10, 10).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 2, 2).addComponent(this.m_cBuildDateSep, -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.m_jlblBuildDate1, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, 15).addComponent(this.m_jlblBuildDate2, -2, -2, Short.MAX_VALUE)))).addComponent(this.GetContactCtrl(), -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.m_cCompanyName, nCompanyCtrlWidth, nCompanyCtrlWidth, nCompanyCtrlWidth).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 30, 30).addComponent(this.m_cResellerCompanyName, -1, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.m_cCompanyAddress1, nCompanyCtrlWidth, nCompanyCtrlWidth, nCompanyCtrlWidth).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 30, 30).addComponent(this.m_cResellerCompanyAddress1, -1, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.m_cCompanyAddress2, nCompanyCtrlWidth, nCompanyCtrlWidth, nCompanyCtrlWidth).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 30, 30).addComponent(this.m_cResellerCompanyAddress2, -1, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.m_cCompanyLink, nCompanyCtrlWidth, nCompanyCtrlWidth, nCompanyCtrlWidth).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 30, 30).addComponent(this.m_cResellerLink, -1, -2, -2)).addComponent(this.m_cDevelopmentSep, -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.m_cDevelopedByTitle, nDevelopedSize, nDevelopedSize, nDevelopedSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, 15).addComponent(this.m_cDevelopedByMsg, -1, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.m_cResellerDevelopedByTitle, nDevelopedSize, nDevelopedSize, nDevelopedSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, 15).addComponent(this.m_cResellerDevelopedByMsg, -1, -2, -2)).addComponent(this.m_cCopyright, -1, -2, -2).addComponent(this.m_cLegalSep, -1, -2, Short.MAX_VALUE).addComponent(this.m_cLegal, -1, -2, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.GetHeaderIconCtrl(), -1, -2, -2).addComponent(this.GetHeaderMsgCtrl(), -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(this.GetSmallLogoCtrl(), -1, -2, -2).addGroup(layout.createSequentialGroup().addComponent(this.m_jlblName, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 1, 1).addGroup(layout.createParallelGroup().addComponent(this.m_jlblVersion1, -1, -2, -2).addComponent(this.m_jlblVersion2, -1, -2, -2)))).addGroup(layout.createParallelGroup().addComponent(this.m_cLogoSpacer, -1, -2, -2).addGroup(layout.createSequentialGroup().addComponent(this.m_cBuildDateSep, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 2, 2).addGroup(layout.createParallelGroup().addComponent(this.m_jlblBuildDate1, -1, -2, -2).addComponent(this.m_jlblBuildDate2, -1, -2, -2)))).addComponent(this.GetContactCtrl(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addGroup(layout.createParallelGroup().addComponent(this.m_cCompanyName, -1, -2, -2).addComponent(this.m_cResellerCompanyName, -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(this.m_cCompanyAddress1, -1, -2, -2).addComponent(this.m_cResellerCompanyAddress1, -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(this.m_cCompanyAddress2, -1, -2, -2).addComponent(this.m_cResellerCompanyAddress2, -1, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addGroup(layout.createParallelGroup().addComponent(this.m_cCompanyLink, -1, -2, -2).addComponent(this.m_cResellerLink, -1, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 8, 8).addComponent(this.m_cDevelopmentSep, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addGroup(layout.createParallelGroup().addComponent(this.m_cDevelopedByTitle, -1, -2, -2).addComponent(this.m_cDevelopedByMsg, -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(this.m_cResellerDevelopedByTitle, -1, -2, -2).addComponent(this.m_cResellerDevelopedByMsg, -1, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent(this.m_cCopyright, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 8, 8).addComponent(this.m_cLegalSep, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent(this.m_cLegal, -1, -2, Short.MAX_VALUE));
        JLabel[] aResellerCtrls = new JLabel[]{this.m_cResellerCompanyName, this.m_cResellerCompanyAddress1, this.m_cResellerCompanyAddress2, this.m_cResellerLink, this.m_cResellerDevelopedByTitle, this.m_cResellerDevelopedByMsg};
        for (int nIdx = 0; nIdx < aResellerCtrls.length; ++nIdx) {
            String sTxt;
            JLabel rNext = aResellerCtrls[nIdx];
            if (rNext == null || (sTxt = rNext.getText()) != null && !sTxt.isEmpty()) continue;
            rNext.setVisible(false);
        }
        if (this.GetHeaderIconCtrl() != null) {
            this.GetHeaderIconCtrl().setVisible(false);
        }
        if (this.GetHeaderMsgCtrl() != null) {
            this.GetHeaderMsgCtrl().setVisible(false);
        }
    }

    protected CSeparatorLink GetContactCtrl() {
        return this.m_cContactCtrl;
    }

    protected JLabel GetSmallLogoCtrl() {
        return this.m_cSmallLogo;
    }

    protected String GetAppName() {
        String sAppName = "";
        if (CRhinoApp.GET_RHINO_APP() != null) {
            sAppName = CRhinoApp.GET_RHINO_APP().GetAppName();
        }
        return sAppName;
    }

    protected int GetVersionMajor1() {
        return CRhinoApp.GetAppVersionMajor1();
    }

    protected int GetVersionMajor2() {
        return CRhinoApp.GetAppVersionMajor2();
    }

    protected int GetVersionMinor1() {
        return CRhinoApp.GetAppVersionMinor1();
    }

    protected int GetVersionMinor2() {
        return CRhinoApp.GetAppVersionMinor2();
    }

    protected abstract String GetURL_Product();

    protected String GetURL_ContactInfo() {
        return "http://www.RhinoSoft.com/contact.asp?prod=su";
    }

    protected String GetURL_WwwRhinosoftDotCom() {
        return "http://www.RhinoSoft.com/";
    }

    protected String GetString_Rhinosoft() {
        return "RhinoSoft";
    }

    protected String GetString_WwwRhinosoftDotCom() {
        return "www.RhinoSoft.com";
    }

    protected String GetString_CompanyStreetAddress() {
        return "P.O. Box 53";
    }

    protected String GetString_CompanyCityStateZip() {
        return "Helenville, WI  53137  USA";
    }

    protected Date GetBuildDate() {
        return CRhinoApp.GET_RHINO_APP().GetBuildDate();
    }

    protected String GetBuildDateAsString() {
        String sDate = CString.LoadString("IDS_NOT_AVAILABLE");
        Date dtBuildDate = this.GetBuildDate();
        if (dtBuildDate != null) {
            sDate = DateFormat.getInstance().format(dtBuildDate);
        }
        return sDate;
    }

    @Override
    protected void OnRecvCacheImage(String sFileName) {
        super.OnRecvCacheImage(sFileName);
        if (this.GetSmallLogoIconFileName().equals(sFileName)) {
            this.GetSmallLogoCtrl().repaint();
        }
    }

    protected String GetSmallLogoIconFileName() {
        return IRhinoConsts.CACHE_IMAGES_COMMON.IMG_RHINO_32x32_PNG.GetFileName();
    }

    @Override
    protected String GetTreeNodeIconFileName() {
        return IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PROGRAM_INFO_16x16_PNG.GetFileName();
    }
}

