/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dialogs;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.CAttrs;
import com.rhinosoft.dialogs.CRhinoAboutProgInfoPanel;
import com.rhinosoft.dialogs.CRhinoDialog;
import com.rhinosoft.dialogs.CRhinoMessageBox;
import com.rhinosoft.dialogs.CRhinoPrefsTreePanel;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import com.rhinosoft.ui.controls.CLinkLabel;
import com.rhinosoft.ui.controls.CSeparator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class CRhinoAboutComputerInfoPanel
extends CRhinoPrefsTreePanel
implements ClipboardOwner,
ActionListener {
    public static final boolean HIDE_EXTRA_INFO = true;
    public static boolean DEBUG = CAttrs.DEBUG;
    private CLinkLabel m_cSmallLogo;
    private CSeparator m_cOSSep;
    private JLabel m_cOS;
    private JLabel m_cOSVersion;
    private JLabel m_cOSArch;
    private JLabel m_cCPUEndian;
    private JLabel m_cUnicodeEncoding;
    private JLabel m_cUserLanguage;
    private JLabel m_cUserCountry;
    private CSeparator m_cRuntimeSep;
    private JLabel m_cRuntimeName;
    private JLabel m_cRuntimeVersion;
    private JLabel m_cRuntimeVendor;
    private JLabel m_cRuntimeVMVendor;
    private JLabel m_cRuntimeVMVersion;
    private JButton m_cCopyClipBtn;

    public CRhinoAboutComputerInfoPanel(String sLookupKey, String sTitle) {
        super(sLookupKey, sTitle);
        this.OnCreate();
    }

    @Override
    public void OnCreate() {
        JLabel cRuntimeVMVersionLabel;
        JLabel cRuntimeVMVendorLabel;
        JLabel cRuntimeVendorLabel;
        JLabel cRuntimeVersionLabel;
        JLabel cRuntimeNameLabel;
        JLabel cUserCountryLabel;
        JLabel cUserLangLabel;
        JLabel cUnicodeEncodingLabel;
        JLabel cCPUEndianLabel;
        JLabel cOSArchLabel;
        JLabel cOSVersionLabel;
        JLabel cOSLabel;
        block50: {
            block49: {
                block48: {
                    block47: {
                        block46: {
                            block45: {
                                block44: {
                                    block43: {
                                        block42: {
                                            super.OnCreate();
                                            this.m_cSmallLogo = new CLinkLabel(this.GetURL_Product());
                                            if (this.GetSmallLogoCtrl() != null) {
                                                this.GetSmallLogoCtrl().setBorder(BorderFactory.createLoweredBevelBorder());
                                                this.GetSmallLogoCtrl().setOpaque(true);
                                                this.GetSmallLogoCtrl().setBackground(new Color(255, 255, 255));
                                                ImageIcon rIcon = CRhinoApp.GetImage(this.GetSmallLogoIconFileName());
                                                if (rIcon != null) {
                                                    Insets rInsets;
                                                    this.GetSmallLogoCtrl().setIcon(rIcon);
                                                    Dimension dimSize = new Dimension(rIcon.getIconWidth(), rIcon.getIconHeight());
                                                    Border rBorder = this.GetSmallLogoCtrl().getBorder();
                                                    if (rBorder != null && (rInsets = rBorder.getBorderInsets(this.GetSmallLogoCtrl())) != null) {
                                                        dimSize.width += rInsets.left + rInsets.right;
                                                        dimSize.height += rInsets.top + rInsets.bottom;
                                                    }
                                                    this.GetSmallLogoCtrl().setMinimumSize(dimSize);
                                                    this.GetSmallLogoCtrl().setPreferredSize(dimSize);
                                                    this.GetSmallLogoCtrl().setMaximumSize(dimSize);
                                                } else if (CAttr.DEBUG) {
                                                    CDebugLog.ASSERT(CRhinoAboutProgInfoPanel.class.getName(), CDebugLog.GetLineNumber(), "Small logo is null?!");
                                                }
                                            }
                                            this.m_cOSSep = new CSeparator();
                                            if (this.GetOSSep() != null) {
                                                this.GetOSSep().setText(CString.LoadString("IDS_OS_INFO"));
                                            }
                                            cOSLabel = new JLabel(CString.LoadString("IDS_OS"));
                                            this.m_cOS = new JLabel();
                                            if (this.GetOSCtrl() != null) {
                                                this.ApplyBoldFont(this.GetOSCtrl());
                                                String sTemp = System.getProperty("os.name");
                                                this.GetOSCtrl().setText(sTemp);
                                            }
                                            cOSVersionLabel = new JLabel(CString.LoadString("IDS_OS_VERSION"));
                                            this.m_cOSVersion = new JLabel();
                                            if (this.GetOSVersionCtrl() != null) {
                                                this.ApplyBoldFont(this.GetOSVersionCtrl());
                                                String sTemp = System.getProperty("os.version");
                                                this.GetOSVersionCtrl().setText(sTemp);
                                            }
                                            cOSArchLabel = new JLabel(CString.LoadString("IDS_CPU_ARCH"));
                                            this.m_cOSArch = new JLabel();
                                            if (this.GetOSArchCtrl() != null) {
                                                this.ApplyBoldFont(this.GetOSArchCtrl());
                                                String sTemp = System.getProperty("os.arch");
                                                this.GetOSArchCtrl().setText(sTemp);
                                            }
                                            cCPUEndianLabel = new JLabel(CString.LoadString("IDS_CPU_ENDIAN"));
                                            this.m_cCPUEndian = new JLabel();
                                            if (this.GetCPUEndianCtrl() != null) {
                                                this.ApplyBoldFont(this.GetCPUEndianCtrl());
                                                try {
                                                    String sTemp = System.getProperty("sun.cpu.endian");
                                                    this.GetCPUEndianCtrl().setText(sTemp);
                                                }
                                                catch (Exception e) {
                                                    if (!DEBUG) break block42;
                                                    e.printStackTrace();
                                                }
                                            }
                                        }
                                        cUnicodeEncodingLabel = new JLabel(CString.LoadString("IDS_UNICODE_ENCODING"));
                                        this.m_cUnicodeEncoding = new JLabel();
                                        if (this.GetUnicodeEncodingCtrl() != null) {
                                            this.ApplyBoldFont(this.GetUnicodeEncodingCtrl());
                                            try {
                                                String sTemp = System.getProperty("sun.io.unicode.encoding");
                                                this.GetUnicodeEncodingCtrl().setText(sTemp);
                                            }
                                            catch (Exception e) {
                                                if (!DEBUG) break block43;
                                                e.printStackTrace();
                                            }
                                        }
                                    }
                                    cUserLangLabel = new JLabel(CString.LoadString("IDS_USER_LANGUAGE"));
                                    this.m_cUserLanguage = new JLabel();
                                    if (this.GetUserLanguageCtrl() != null) {
                                        this.ApplyBoldFont(this.GetUserLanguageCtrl());
                                        try {
                                            String sTemp = System.getProperty("user.language");
                                            this.GetUserLanguageCtrl().setText(sTemp);
                                        }
                                        catch (Exception e) {
                                            if (!DEBUG) break block44;
                                            e.printStackTrace();
                                        }
                                    }
                                }
                                cUserCountryLabel = new JLabel(CString.LoadString("IDS_USER_COUNTRY"));
                                this.m_cUserCountry = new JLabel();
                                if (this.GetUserCountryCtrl() != null) {
                                    this.ApplyBoldFont(this.GetUserCountryCtrl());
                                    try {
                                        String sTemp = System.getProperty("user.country");
                                        this.GetUserCountryCtrl().setText(sTemp);
                                    }
                                    catch (Exception e) {
                                        if (!DEBUG) break block45;
                                        e.printStackTrace();
                                    }
                                }
                            }
                            this.m_cRuntimeSep = new CSeparator();
                            if (this.GetRuntimeSep() != null) {
                                this.GetRuntimeSep().setText(CString.LoadString("IDS_RUNTIME_INFO"));
                            }
                            cRuntimeNameLabel = new JLabel(CString.LoadString("IDS_RUNTIME_NAME"));
                            this.m_cRuntimeName = new JLabel();
                            if (this.GetRuntimeNameCtrl() != null) {
                                this.ApplyBoldFont(this.GetRuntimeNameCtrl());
                                try {
                                    String sTemp = System.getProperty("java.runtime.name");
                                    this.GetRuntimeNameCtrl().setText(sTemp);
                                }
                                catch (Exception e) {
                                    if (!DEBUG) break block46;
                                    e.printStackTrace();
                                }
                            }
                        }
                        cRuntimeVersionLabel = new JLabel(CString.LoadString("IDS_RUNTIME_VERSION"));
                        this.m_cRuntimeVersion = new JLabel();
                        if (this.GetRuntimeVersionCtrl() != null) {
                            this.ApplyBoldFont(this.GetRuntimeVersionCtrl());
                            try {
                                String sTemp = System.getProperty("java.version");
                                this.GetRuntimeVersionCtrl().setText(sTemp);
                            }
                            catch (Exception e) {
                                if (!DEBUG) break block47;
                                e.printStackTrace();
                            }
                        }
                    }
                    cRuntimeVendorLabel = new JLabel(CString.LoadString("IDS_RUNTIME_VENDOR"));
                    this.m_cRuntimeVendor = new JLabel();
                    if (this.GetRuntimeVendorCtrl() != null) {
                        this.ApplyBoldFont(this.GetRuntimeVendorCtrl());
                        try {
                            String sTemp = System.getProperty("java.vendor");
                            this.GetRuntimeVendorCtrl().setText(sTemp);
                        }
                        catch (Exception e) {
                            if (!DEBUG) break block48;
                            e.printStackTrace();
                        }
                    }
                }
                cRuntimeVMVendorLabel = new JLabel(CString.LoadString("IDS_RUNTIME_VM_VENDOR"));
                this.m_cRuntimeVMVendor = new JLabel();
                if (this.GetRuntimeVMVendorCtrl() != null) {
                    this.ApplyBoldFont(this.GetRuntimeVMVendorCtrl());
                    try {
                        String sTemp = System.getProperty("java.vm.vendor");
                        this.GetRuntimeVMVendorCtrl().setText(sTemp);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block49;
                        e.printStackTrace();
                    }
                }
            }
            cRuntimeVMVersionLabel = new JLabel(CString.LoadString("IDS_RUNTIME_VM_VERSION"));
            this.m_cRuntimeVMVersion = new JLabel();
            if (this.GetRuntimeVMVersionCtrl() != null) {
                this.ApplyBoldFont(this.GetRuntimeVMVersionCtrl());
                try {
                    String sTemp = System.getProperty("java.vm.version");
                    this.GetRuntimeVMVersionCtrl().setText(sTemp);
                }
                catch (Exception e) {
                    if (!DEBUG) break block50;
                    e.printStackTrace();
                }
            }
        }
        this.m_cCopyClipBtn = new JButton(CString.LoadString("IDS_COPY_TO_CLIPBOARD"));
        CRhinoDialog.AddEscapeKeyListener(this.m_cCopyClipBtn);
        if (this.GetCopyClipBtn() != null) {
            this.GetCopyClipBtn().addActionListener(this);
        }
        JPanel cSpacer = new JPanel();
        if (this.GetSmallLogoCtrl() != null) {
            Dimension dimSize = this.GetSmallLogoCtrl().getMinimumSize();
            dimSize.height = dimSize.height / 4 * 3;
            cSpacer.setMinimumSize(dimSize);
            dimSize = this.GetSmallLogoCtrl().getPreferredSize();
            dimSize.height = dimSize.height / 4 * 3;
            cSpacer.setPreferredSize(dimSize);
            dimSize = this.GetSmallLogoCtrl().getMaximumSize();
            dimSize.height = dimSize.height / 4 * 3;
            cSpacer.setMaximumSize(dimSize);
        }
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        int nLabelWidth = 150;
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.GetSmallLogoCtrl(), -1, -2, -2).addGap(5).addComponent(this.GetHeaderMsgCtrl(), -1, -2, Short.MAX_VALUE)).addComponent(this.GetOSSep(), -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(cOSLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetOSCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cOSVersionLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetOSVersionCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cOSArchLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetOSArchCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cCPUEndianLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetCPUEndianCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cUnicodeEncodingLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetUnicodeEncodingCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cUserLangLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetUserLanguageCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cUserCountryLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetUserCountryCtrl(), -1, -2, Short.MAX_VALUE)).addComponent(this.GetRuntimeSep(), -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(cRuntimeNameLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetRuntimeNameCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cRuntimeVersionLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetRuntimeVersionCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cRuntimeVendorLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetRuntimeVendorCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cRuntimeVMVendorLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetRuntimeVMVendorCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cRuntimeVMVersionLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetRuntimeVMVersionCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.GetCopyClipBtn(), -1, -2, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.GetSmallLogoCtrl(), -1, -2, -2).addComponent(this.GetHeaderMsgCtrl(), -1, -2, -2)).addGap(10).addComponent(this.GetOSSep(), -1, -2, -2).addGap(5).addGroup(layout.createParallelGroup().addComponent(cOSLabel, -1, -2, -2).addComponent(this.GetOSCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cOSVersionLabel, -1, -2, -2).addComponent(this.GetOSVersionCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cOSArchLabel, -1, -2, -2).addComponent(this.GetOSArchCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cCPUEndianLabel, -1, -2, -2).addComponent(this.GetCPUEndianCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cUnicodeEncodingLabel, -1, -2, -2).addComponent(this.GetUnicodeEncodingCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cUserLangLabel, -1, -2, -2).addComponent(this.GetUserLanguageCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cUserCountryLabel, -1, -2, -2).addComponent(this.GetUserCountryCtrl(), -1, -2, -2)).addGap(10).addComponent(this.GetRuntimeSep(), -1, -2, -2).addGap(5).addGroup(layout.createParallelGroup().addComponent(cRuntimeNameLabel, -1, -2, -2).addComponent(this.GetRuntimeNameCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cRuntimeVersionLabel, -1, -2, -2).addComponent(this.GetRuntimeVersionCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cRuntimeVendorLabel, -1, -2, -2).addComponent(this.GetRuntimeVendorCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cRuntimeVMVendorLabel, -1, -2, -2).addComponent(this.GetRuntimeVMVendorCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cRuntimeVMVersionLabel, -1, -2, -2).addComponent(this.GetRuntimeVMVersionCtrl(), -1, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.GetCopyClipBtn(), -1, -2, -2));
        if (this.GetHeaderIconCtrl() != null) {
            this.GetHeaderIconCtrl().setVisible(false);
        }
        Component[] aHideComps = new Component[]{cCPUEndianLabel, this.GetCPUEndianCtrl(), cUnicodeEncodingLabel, this.GetUnicodeEncodingCtrl(), cUserLangLabel, this.GetUserLanguageCtrl(), cUserCountryLabel, this.GetUserCountryCtrl(), cRuntimeVMVendorLabel, this.GetRuntimeVMVendorCtrl(), cRuntimeVMVersionLabel, this.GetRuntimeVMVersionCtrl(), null};
        for (int nIdx = 0; nIdx < aHideComps.length; ++nIdx) {
            Component rNext = aHideComps[nIdx];
            if (rNext == null) continue;
            rNext.setVisible(false);
        }
        if (this.GetHeaderMsgCtrl() != null) {
            this.GetHeaderMsgCtrl().setText(CString.LoadString("IDS_COMPUTER_HEADER_MSG"));
        }
    }

    protected JLabel GetSmallLogoCtrl() {
        return this.m_cSmallLogo;
    }

    protected CSeparator GetOSSep() {
        return this.m_cOSSep;
    }

    protected JLabel GetOSCtrl() {
        return this.m_cOS;
    }

    protected JLabel GetOSVersionCtrl() {
        return this.m_cOSVersion;
    }

    protected JLabel GetOSArchCtrl() {
        return this.m_cOSArch;
    }

    protected JLabel GetCPUEndianCtrl() {
        return this.m_cCPUEndian;
    }

    protected JLabel GetUnicodeEncodingCtrl() {
        return this.m_cUnicodeEncoding;
    }

    protected JLabel GetUserLanguageCtrl() {
        return this.m_cUserLanguage;
    }

    protected JLabel GetUserCountryCtrl() {
        return this.m_cUserCountry;
    }

    protected CSeparator GetRuntimeSep() {
        return this.m_cRuntimeSep;
    }

    protected JLabel GetRuntimeNameCtrl() {
        return this.m_cRuntimeName;
    }

    protected JLabel GetRuntimeVersionCtrl() {
        return this.m_cRuntimeVersion;
    }

    protected JLabel GetRuntimeVendorCtrl() {
        return this.m_cRuntimeVendor;
    }

    protected JLabel GetRuntimeVMVendorCtrl() {
        return this.m_cRuntimeVMVendor;
    }

    protected JLabel GetRuntimeVMVersionCtrl() {
        return this.m_cRuntimeVMVersion;
    }

    protected JButton GetCopyClipBtn() {
        return this.m_cCopyClipBtn;
    }

    private void OnCopyToClipboard() {
        Clipboard clipboard;
        String sInfo = this.CompileEnvironmentInfo();
        if (sInfo != null && (clipboard = Toolkit.getDefaultToolkit().getSystemClipboard()) != null) {
            StringSelection objTransferable = new StringSelection(sInfo);
            clipboard.setContents(objTransferable, this);
            JDialog rMainDlg = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this);
            CRhinoMessageBox dlg = new CRhinoMessageBox(rMainDlg, CString.LoadString("IDS_COPY_TO_CLIP_CONFIRM_TITLE"), null, -1, 1, CString.LoadString("IDS_COPY_TO_CLIP_CONFIRM_MSG"));
            Dimension dimSize = new Dimension(300, 180);
            if (CLocalFileSystem.GetLocalFileSystem().IsMac()) {
                dimSize.width += 100;
                dimSize.height += 50;
            }
            dlg.setPreferredSize(dimSize);
            dlg.setVisible(true);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private String CompileEnvironmentInfo() {
        StringBuffer sRet = new StringBuffer();
        sRet.append("----------  System.getenv()  ------------\r\n\r\n");
        for (String sKey : System.getenv().keySet()) {
            sRet.append(String.format("%30s = %s\r\n", sKey, System.getenv().get(sKey)));
        }
        ArrayList<Object> SortedProps = new ArrayList<Object>();
        SortedProps.addAll(System.getProperties().keySet());
        Collections.sort(SortedProps);
        sRet.append("----------  System.getProperties()  ------------\r\n\r\n");
        Object objKey = null;
        for (int nIdx = 0; nIdx < SortedProps.size(); ++nIdx) {
            Object[] objectArray = new Object[2];
            Object e = SortedProps.get(nIdx);
            objKey = e;
            objectArray[0] = e;
            objectArray[1] = System.getProperties().get(objKey);
            sRet.append(String.format("%30s = %s\r\n", objectArray));
        }
        return sRet.toString();
    }

    @Override
    public void actionPerformed(ActionEvent rActionEvent) {
        if (rActionEvent != null && rActionEvent.getSource() == this.GetCopyClipBtn()) {
            this.OnCopyToClipboard();
        }
    }

    private void ApplyBoldFont(JComponent rComp) {
        if (rComp != null) {
            rComp.setFont(new Font("Arial Bold", 1, 12));
        }
    }

    protected String GetURL_Product() {
        return "";
    }

    @Override
    protected void OnRecvCacheImage(String sFileName) {
        super.OnRecvCacheImage(sFileName);
        if (this.GetSmallLogoIconFileName().equals(sFileName)) {
            this.GetSmallLogoCtrl().repaint();
        }
    }

    protected String GetSmallLogoIconFileName() {
        return IRhinoConsts.CACHE_IMAGES_COMMON.IMG_RHINO_32x32_PNG.GetFileName();
    }

    @Override
    protected String GetTreeNodeIconFileName() {
        return IRhinoConsts.CACHE_IMAGES_COMMON.IMG_NETWORK_INFO_16x16_PNG.GetFileName();
    }
}

