/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dialogs;

import com.rhinosoft.dialogs.CFileChooser;
import com.rhinosoft.strings.CString;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JDialog;

public class CFileChooserTransfer
extends CFileChooser {
    protected boolean m_bIsDownload;
    private Object[] m_asAbsSourcePaths;
    private String m_sAbsTargetDir;
    private File m_fDownloadSelFile = null;

    public CFileChooserTransfer(Component rCenterTo, File fCurDir, boolean bIsDownload) {
        super(rCenterTo, fCurDir, true, true);
        this._CFileChooserTransfer(bIsDownload, null);
    }

    public CFileChooserTransfer(Component rCenterTo, File fCurDir, boolean bIsDownload, Object[] asAbsSourcePaths) {
        super(rCenterTo, fCurDir, true, true);
        this._CFileChooserTransfer(bIsDownload, asAbsSourcePaths);
        this.m_fDownloadSelFile = fCurDir;
        if (this.IsSingleDownloadFile(bIsDownload, asAbsSourcePaths)) {
            String sTargetFile = null;
            if (fCurDir != null) {
                String sSourcePath;
                sTargetFile = fCurDir.getAbsolutePath();
                sTargetFile = CString.EnsureLastCharIsAFileSeparator(sTargetFile);
                if (asAbsSourcePaths != null && asAbsSourcePaths.length == 2 && (sSourcePath = (String)asAbsSourcePaths[0]) != null) {
                    sSourcePath = CString.GetFileName(sSourcePath);
                    sTargetFile = sTargetFile + sSourcePath;
                    this.m_fDownloadSelFile = new File(sTargetFile);
                }
            }
        }
    }

    private void _CFileChooserTransfer(boolean bIsDownload, Object[] asAbsSourcePaths) {
        this.m_bIsDownload = bIsDownload;
        if (!bIsDownload) {
            this.setMultiSelectionEnabled(true);
            this.setFileSelectionMode(2);
            this.setDialogTitle(CString.LoadString("IDS_SELECT_UPLOAD_ITEMS"));
        } else {
            this.setMultiSelectionEnabled(false);
            this.setFileSelectionMode(1);
            this.setDialogTitle(CString.LoadString("IDS_DOWNLOAD_TO_MENU"));
            this.SetAbsSourcePaths(asAbsSourcePaths);
        }
        this.m_fDownloadSelFile = null;
    }

    @Override
    public void Destroy() {
        this.m_asAbsSourcePaths = null;
        this.m_fDownloadSelFile = null;
        super.Destroy();
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        JDialog rDlg = super.createDialog(parent);
        ImageIcon rImage = null;
        rImage = this.m_bIsDownload ? CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_FILE_DOWNLOAD_PNG.GetFileName()) : CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_FILE_UPLOAD_PNG.GetFileName());
        if (rImage != null) {
            rDlg.setIconImage(rImage.getImage());
        }
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().CenterWindow(rDlg);
        }
        return rDlg;
    }

    @Override
    protected String GetDirConfirmMsg() {
        String sRet = super.GetDirConfirmMsg();
        sRet = this.m_bIsDownload ? CString.LoadString("IDS_CONFIRM_FILE_CHOOSER_DIR_DOWNLOAD_MSG") : CString.LoadString("IDS_CONFIRM_FILE_CHOOSER_DIR_UPLOAD_MSG");
        return sRet;
    }

    @Override
    protected boolean CanShowDirConfirmation(int nRet) {
        boolean bShowDirConfirmation = false;
        this.SetDirConfirmLoc(null);
        if (nRet == 0 && !this.m_bIsDownload) {
            File fSelFile = null;
            File[] afSelFiles = this.getSelectedFiles();
            if (afSelFiles != null && afSelFiles.length > 0) {
                if (afSelFiles.length == 1) {
                    fSelFile = afSelFiles[0];
                }
            } else {
                fSelFile = this.getSelectedFile();
            }
            if (fSelFile != null && fSelFile.isDirectory()) {
                bShowDirConfirmation = true;
                this.SetDirConfirmLoc(fSelFile);
            }
        }
        return bShowDirConfirmation;
    }

    public boolean IsDownload() {
        return this.m_bIsDownload;
    }

    public void SetAbsSourcePaths(Object[] asAbsSourcePaths) {
        Boolean bIsDir;
        this.m_asAbsSourcePaths = asAbsSourcePaths;
        if (this.m_asAbsSourcePaths != null && this.m_asAbsSourcePaths.length == 2 && (bIsDir = (Boolean)this.m_asAbsSourcePaths[1]) != null && !bIsDir.booleanValue()) {
            this.setFileSelectionMode(2);
        }
    }

    public Object[] GetAbsSourcePaths() {
        return this.m_asAbsSourcePaths;
    }

    public void SetAbsTargetDir(String sAbsTargetDir) {
        this.m_sAbsTargetDir = sAbsTargetDir;
    }

    public String GetAbsTargetDir() {
        return this.m_sAbsTargetDir;
    }

    private boolean IsSingleDownloadFile(boolean bIsDownload, Object[] arSourcePaths) {
        Boolean bIsDir;
        boolean bIsSingleDownloadFile = false;
        if (bIsDownload && arSourcePaths != null && arSourcePaths.length == 2 && (bIsDir = (Boolean)arSourcePaths[1]) != null && !bIsDir.booleanValue()) {
            bIsSingleDownloadFile = true;
        }
        return bIsSingleDownloadFile;
    }

    public boolean IsSingleDownload() {
        return this.IsSingleDownloadFile(this.m_bIsDownload, this.GetAbsSourcePaths());
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        if (this.IsSingleDownload()) {
            this.setSelectedFile(this.m_fDownloadSelFile);
        }
        return super.showDialog(parent, approveButtonText);
    }

    @Override
    protected CFileChooser.INSPECT_CODE InspectSelectedFileDoesNotExist(CFileChooser.INSPECT_CODE nRet, File fInspectFile) {
        if ((nRet = super.InspectSelectedFileDoesNotExist(nRet, fInspectFile)) == CFileChooser.INSPECT_CODE.DOES_NOT_EXIST && this.IsSingleDownload()) {
            String sStartedOnPath = null;
            if (this.m_fDownloadSelFile != null) {
                sStartedOnPath = this.m_fDownloadSelFile.getAbsolutePath();
            }
            String sCurPath = null;
            if (this.getSelectedFile() != null) {
                sCurPath = this.getSelectedFile().getAbsolutePath();
            }
            if (sStartedOnPath != null && sCurPath != null) {
                sStartedOnPath = CString.GetFileName(sStartedOnPath);
                sCurPath = CString.GetFileName(sCurPath);
                if (sStartedOnPath != null && sCurPath != null && sStartedOnPath.equals(sCurPath)) {
                    nRet = CFileChooser.INSPECT_CODE.EXISTS;
                }
            }
        }
        return nRet;
    }
}

