/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dialogs;

import com.rhinosoft.attrs.CAttrs;
import com.rhinosoft.attrs.IRhinoDestroy;
import com.rhinosoft.dialogs.CRhinoMessageBox;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class CFileChooser
extends JFileChooser
implements IRhinoDestroy {
    public static boolean DEBUG = CAttrs.DEBUG;
    protected static boolean DEBUG_EVENTS;
    protected static boolean DEBUG_PRINT_RESULTS;
    private boolean m_bAutoCheckExistence = false;
    private boolean m_bAutoChangeOnExistence = false;
    private File m_fInspectionFile = null;
    private File m_fConfirmDirLoc = null;
    private USER_INTENTION m_nUserIntention = USER_INTENTION.UNKNOWN;
    private boolean m_bIsApproveBtn = false;
    private Component m_rCenterTo;

    public CFileChooser(Component rCenterTo, File fCurDir) {
        super(fCurDir);
        this._CFileChooser(rCenterTo, false, false);
    }

    public CFileChooser(Component rCenterTo, File fCurDir, boolean bAutoCheckExistence, boolean bAutoChangeOnExistence) {
        super(fCurDir);
        this._CFileChooser(rCenterTo, bAutoCheckExistence, bAutoChangeOnExistence);
    }

    private void _CFileChooser(Component rCenterTo, boolean bAutoCheckExistence, boolean bAutoChangeOnExistence) {
        this.m_rCenterTo = rCenterTo;
        this.m_bAutoCheckExistence = bAutoCheckExistence;
        this.m_bAutoChangeOnExistence = bAutoChangeOnExistence;
    }

    @Override
    public void Destroy() {
        this.m_fInspectionFile = null;
        this.m_fConfirmDirLoc = null;
        this.m_rCenterTo = null;
    }

    public Component GetCenterTo() {
        return this.m_rCenterTo;
    }

    public void SetAutoCheckExistence(boolean bAutoCheckExistence) {
        this.m_bAutoCheckExistence = bAutoCheckExistence;
    }

    public void SetAutoChangeOnExistence(boolean bAutoChangeOnExistence) {
        this.m_bAutoChangeOnExistence = bAutoChangeOnExistence;
    }

    public File CheckExistence(File fFile, boolean bCanRetParent) {
        String[] asDirs;
        String sFileName;
        String sAbsPath;
        File fRet = fFile;
        if (fFile != null && CLocalFileSystem.GetLocalFileSystem() != null && CLocalFileSystem.GetLocalFileSystem().IsMac() && (sAbsPath = fFile.getAbsolutePath()) != null && !sAbsPath.isEmpty() && (sFileName = CString.GetFileName(sAbsPath)) != null && !sFileName.isEmpty() && (asDirs = sAbsPath.split(File.separator)) != null && asDirs.length > 1) {
            File fParent;
            String sLastDir = asDirs[asDirs.length - 1];
            String sLastDir2 = asDirs[asDirs.length - 2];
            if (sLastDir != null && !sLastDir.isEmpty() && sLastDir.equals(sFileName) && sLastDir2 != null && !sLastDir2.isEmpty() && sLastDir2.equals(sFileName) && !fFile.exists() && (fParent = fFile.getParentFile()) != null && fParent.exists() && bCanRetParent) {
                fRet = fParent;
            }
        }
        return fRet;
    }

    @Override
    public File getSelectedFile() {
        File fSelectedFile = super.getSelectedFile();
        if (this.getFileSelectionMode() == 1 && !this.isMultiSelectionEnabled() && this.m_bAutoCheckExistence) {
            fSelectedFile = this.CheckExistence(fSelectedFile, this.m_bAutoChangeOnExistence);
        }
        return fSelectedFile;
    }

    protected String GetDirConfirmMsg() {
        return CString.LoadString("IDS_CONFIRM_FILE_CHOOSER_DIR_MSG");
    }

    @Override
    protected void fireActionPerformed(String command) {
        AWTEvent rCurEvent = EventQueue.getCurrentEvent();
        if (rCurEvent instanceof InputEvent) {
            InputEvent rInputEvent = (InputEvent)rCurEvent;
            if (rInputEvent instanceof KeyEvent) {
                KeyEvent rKeyEvent = (KeyEvent)rInputEvent;
                if (rKeyEvent.getKeyCode() == 10) {
                    if (DEBUG_EVENTS) {
                        CDebugLog.INFO("Key event: ENTER key was pressed or released?");
                    }
                    this.m_nUserIntention = USER_INTENTION.ENTER_KEY_PRESSED;
                }
            } else if (rInputEvent instanceof MouseEvent) {
                Object rSource;
                MouseEvent rMouseEvent = (MouseEvent)rInputEvent;
                this.m_nUserIntention = USER_INTENTION.MOUSE_RELEASED;
                String sApproveBtnText = this.getApproveButtonText();
                if (sApproveBtnText != null && !sApproveBtnText.isEmpty() && (rSource = rMouseEvent.getSource()) != null) {
                    String sText = null;
                    if (rSource instanceof JButton) {
                        JButton rBtn = (JButton)rSource;
                        sText = rBtn.getText();
                    } else if (rSource instanceof Button) {
                        Button rBtn = (Button)rSource;
                        sText = rBtn.getLabel();
                    }
                    if (sText != null && !sText.isEmpty() && sText.equals(sApproveBtnText)) {
                        this.m_bIsApproveBtn = true;
                    }
                }
            }
        }
        super.fireActionPerformed(command);
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        INSPECT_CODE nInspectionCode;
        int nRet = super.showDialog(parent, approveButtonText);
        USER_INTENTION nUserIntention = this.m_nUserIntention;
        this.m_nUserIntention = USER_INTENTION.UNKNOWN;
        boolean bIsApproveBtn = this.m_bIsApproveBtn;
        this.m_bIsApproveBtn = false;
        if (DEBUG_PRINT_RESULTS) {
            String sMsg = "--- CFileChooser.showDialog ---\r\n";
            sMsg = sMsg + String.format("Dialog result: %s\r\n", nRet == 0 ? "Approved" : (nRet == 1 ? "Cancelled" : "Unknown"));
            sMsg = sMsg + String.format("User Intention: %s\r\n", nUserIntention == USER_INTENTION.ENTER_KEY_PRESSED ? "[ENTER] key pressed" : (nUserIntention == USER_INTENTION.MOUSE_RELEASED ? "Mouse Released" : "Unknown"));
            sMsg = sMsg + String.format("Multi-selection enabled: %s\r\n", this.isMultiSelectionEnabled() ? "true" : "false");
            File[] afSelFiles = this.getSelectedFiles();
            sMsg = sMsg + String.format("Selected Files: %s\r\n", afSelFiles == null ? "null" : (afSelFiles.length < 1 ? "empty" : Integer.toString(afSelFiles.length)));
            File fSelFile = this.getSelectedFile();
            sMsg = sMsg + String.format("Selected File: %s\r\n", fSelFile != null ? fSelFile.getAbsolutePath() : "null");
            System.out.println(sMsg);
        }
        if (nRet == 1) {
            boolean bManuallyApproveIt = false;
            if (nUserIntention == USER_INTENTION.ENTER_KEY_PRESSED) {
                bManuallyApproveIt = true;
            } else if (nUserIntention == USER_INTENTION.MOUSE_RELEASED && bIsApproveBtn) {
                bManuallyApproveIt = true;
            }
            if (bManuallyApproveIt) {
                nRet = 0;
                this.EnsureSelectedFile();
            }
        }
        if (nRet == 0 && (nInspectionCode = this.InspectSelectedFiles()) != INSPECT_CODE.EXISTS) {
            int nOpt = this.ShowInspectionConfirmation(nInspectionCode, parent);
            if (nOpt == 0) {
                nRet = this.showDialog(parent, approveButtonText);
            } else if (nOpt == 2) {
                nRet = 1;
            }
        }
        if (nRet == 0 && this.CanShowDirConfirmation(nRet)) {
            int nOpt = this.ShowDirConfirmation(parent);
            if (nOpt == 1) {
                if (this.GetDirConfirmLoc() != null) {
                    this.setCurrentDirectory(this.GetDirConfirmLoc());
                }
                nRet = this.showDialog(parent, approveButtonText);
            } else if (nOpt == 2) {
                nRet = 1;
            }
        }
        return nRet;
    }

    protected File GetDirConfirmLoc() {
        return this.m_fConfirmDirLoc;
    }

    protected void SetDirConfirmLoc(File fDir) {
        this.m_fConfirmDirLoc = fDir != null && fDir.exists() && fDir.isDirectory() ? fDir : null;
    }

    protected boolean CanShowDirConfirmation(int nRet) {
        return false;
    }

    public String GetSelectedFileName() {
        String sAbsSelectedFilename = null;
        if (this.getUI() instanceof BasicFileChooserUI) {
            BasicFileChooserUI rBasicUI = (BasicFileChooserUI)this.getUI();
            sAbsSelectedFilename = rBasicUI.getFileName();
        }
        return sAbsSelectedFilename;
    }

    protected INSPECT_CODE InspectSelectedFiles() {
        INSPECT_CODE nRet = INSPECT_CODE.EXISTS;
        this.m_fInspectionFile = null;
        File[] afSelFiles = this.getSelectedFiles();
        File fSelFile = this.getSelectedFile();
        if (afSelFiles != null && afSelFiles.length > 0) {
            boolean bIsMultiSelectionEnabled = this.isMultiSelectionEnabled();
            for (int nIdx = 0; nIdx < afSelFiles.length && nRet == INSPECT_CODE.EXISTS; ++nIdx) {
                File fNext = afSelFiles[nIdx];
                if (fNext == null || (nRet = this.InspectSelectedFile(fNext)) != INSPECT_CODE.EXISTS || bIsMultiSelectionEnabled || nIdx <= 0) continue;
                nRet = INSPECT_CODE.MULTI_SEL_NOT_SUPPORTED;
            }
        } else if (fSelFile != null) {
            nRet = this.InspectSelectedFile(fSelFile);
        }
        return nRet;
    }

    protected INSPECT_CODE InspectSelectedFile(File fInspectFile) {
        INSPECT_CODE nRet = INSPECT_CODE.EXISTS;
        this.m_fInspectionFile = null;
        if (fInspectFile != null) {
            if ((nRet = this.InspectSelectedFileDoesNotExist(nRet, fInspectFile)) == INSPECT_CODE.EXISTS) {
                if (this.getFileSystemView() != null && !fInspectFile.isDirectory() && !this.getFileSystemView().isDrive(fInspectFile)) {
                    if (this.getFileSelectionMode() == 1) {
                        nRet = INSPECT_CODE.DIR_IS_FILE;
                    }
                } else if (this.getFileSelectionMode() == 0) {
                    nRet = INSPECT_CODE.FILE_IS_DIR;
                }
            }
            if (nRet != INSPECT_CODE.EXISTS) {
                this.m_fInspectionFile = fInspectFile;
            }
        }
        return nRet;
    }

    protected void EnsureSelectedFile() {
        File fSelPath;
        String sAbsSelPath;
        File[] afSelFiles = this.getSelectedFiles();
        File fSelFile = this.getSelectedFile();
        if (!(afSelFiles != null && afSelFiles.length >= 1 && fSelFile != null || this.isMultiSelectionEnabled() || (sAbsSelPath = this.GetSelectedFileName()) == null || sAbsSelPath.isEmpty() || (fSelPath = new File(sAbsSelPath)) == null)) {
            this.setSelectedFile(fSelPath);
        }
    }

    protected int ShowInspectionConfirmation(INSPECT_CODE nInspectionCode, Component rParent) {
        int nRet = 0;
        String sMsg = CString.LoadString("IDS_CONFIRM_FILE_CHOOSER_INSPECT_MSG_DEF");
        if (this.m_fInspectionFile != null) {
            String sInspectionMsg = "";
            switch (nInspectionCode) {
                case DOES_NOT_EXIST: {
                    sInspectionMsg = CString.LoadString("IDS_CONFIRM_FILE_CHOOSER_INSPECT_MSG_DNE");
                    break;
                }
                case FILE_IS_DIR: {
                    sInspectionMsg = CString.LoadString("IDS_CONFIRM_FILE_CHOOSER_INSPECT_MSG_FID");
                    break;
                }
                case DIR_IS_FILE: {
                    sInspectionMsg = CString.LoadString("IDS_CONFIRM_FILE_CHOOSER_INSPECT_MSG_DIF");
                    break;
                }
            }
            if (!sInspectionMsg.isEmpty()) {
                sMsg = String.format(sInspectionMsg, this.m_fInspectionFile.getAbsolutePath());
            }
        } else if (nInspectionCode == INSPECT_CODE.MULTI_SEL_NOT_SUPPORTED) {
            sMsg = CString.LoadString("IDS_CONFIRM_FILE_CHOOSER_INSPECT_MSG_MSNS");
        } else if (DEBUG) {
            CDebugLog.ASSERT(CFileChooser.class.getName(), CDebugLog.GetLineNumber(), "Programming error, m_fInspectionFile is null!");
        }
        ArrayList<Image> aWindowImages = new ArrayList<Image>();
        ImageIcon ico = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_ERROR_16_PNG.GetFileName());
        if (ico != null) {
            aWindowImages.add(ico.getImage());
        }
        if ((ico = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_ERROR_32_PNG.GetFileName())) != null) {
            aWindowImages.add(ico.getImage());
        }
        CRhinoMessageBox rMsgBox = new CRhinoMessageBox(CRhinoApp.GetParentWindow(rParent), CString.LoadString("IDS_CONFIRM_FILE_CHOOSER_INSPECT_TITLE"), aWindowImages, 2, 0, sMsg);
        Dimension dimSize = rMsgBox.getMinimumSize();
        dimSize.width = Math.max(dimSize.width, 300);
        dimSize.height = Math.max(dimSize.height, 180);
        rMsgBox.setMinimumSize(dimSize);
        dimSize = rMsgBox.getPreferredSize();
        dimSize.width = Math.max(dimSize.width, 300);
        dimSize.height = Math.max(dimSize.height, 180);
        rMsgBox.setPreferredSize(dimSize);
        rMsgBox.setVisible(true);
        nRet = rMsgBox.GetResult();
        return nRet;
    }

    protected int ShowDirConfirmation(Component rParent) {
        String sMsg = CString.LoadString("IDS_CONFIRM_FILE_CHOOSER_DIR_MSG");
        File fSelFile = this.getSelectedFile();
        if (fSelFile != null) {
            sMsg = this.GetDirConfirmMsg();
            sMsg = String.format(sMsg, fSelFile.getAbsolutePath());
        } else if (DEBUG) {
            CDebugLog.ASSERT(CFileChooser.class.getName(), CDebugLog.GetLineNumber(), "Programming error, selected file is null!");
        }
        ArrayList<Image> aWindowImages = new ArrayList<Image>();
        ImageIcon ico = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_QUESTION_16_PNG.GetFileName());
        if (ico != null) {
            aWindowImages.add(ico.getImage());
        }
        if ((ico = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_QUESTION_32_PNG.GetFileName())) != null) {
            aWindowImages.add(ico.getImage());
        }
        CRhinoMessageBox rMsgBox = new CRhinoMessageBox(CRhinoApp.GetParentWindow(rParent), CString.LoadString("IDS_CONFIRM_FILE_CHOOSER_DIR_TITLE"), aWindowImages, 1, 3, sMsg);
        Dimension dimSize = rMsgBox.getMinimumSize();
        dimSize.width = Math.max(dimSize.width, 300);
        dimSize.height = Math.max(dimSize.height, 180);
        rMsgBox.setMinimumSize(dimSize);
        dimSize = rMsgBox.getPreferredSize();
        dimSize.width = Math.max(dimSize.width, 300);
        dimSize.height = Math.max(dimSize.height, 180);
        rMsgBox.setPreferredSize(dimSize);
        rMsgBox.setVisible(true);
        return rMsgBox.GetResult();
    }

    protected INSPECT_CODE InspectSelectedFileDoesNotExist(INSPECT_CODE nRet, File fInspectFile) {
        if (nRet == INSPECT_CODE.EXISTS && fInspectFile != null && !fInspectFile.exists()) {
            nRet = INSPECT_CODE.DOES_NOT_EXIST;
        }
        return nRet;
    }

    static {
        if (CAttrs.DEBUG) {
            // empty if block
        }
        DEBUG_EVENTS = false;
        if (CAttrs.DEBUG) {
            // empty if block
        }
        DEBUG_PRINT_RESULTS = false;
    }

    protected static enum USER_INTENTION {
        UNKNOWN,
        ENTER_KEY_PRESSED,
        MOUSE_RELEASED;

    }

    protected static enum INSPECT_CODE {
        EXISTS,
        DOES_NOT_EXIST,
        MULTI_SEL_NOT_SUPPORTED,
        FILE_IS_DIR,
        DIR_IS_FILE;

    }
}

