/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dialogs;

import com.rhinosoft.attrs.CConnectionAttrs;
import com.rhinosoft.dialogs.CConfirmDlg;
import com.rhinosoft.dialogs.CConfirmThumbDlg;
import com.rhinosoft.dialogs.CRhinoOverwriteBtn;
import com.rhinosoft.dialogs.CRhinoOverwriteFileBtn;
import com.rhinosoft.files.CFile;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CSUMsg;
import com.rhinosoft.messages.CThumbnailMsg;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.threads.CWorkerThread;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;

public class CConfirmOverwriteDlg
extends CConfirmThumbDlg
implements MouseListener {
    public static final int RESULT_OVERWRITE_TARGET = 0;
    public static final int RESULT_DO_NOTHING = 1;
    public static final int RESULT_RESUME_SOURCE = 4;
    public static final int RESULT_RENAME_TARGET = 5;
    private boolean m_bIsMove;
    private Color m_clrBlue;
    private JLabel m_cTitle;
    private JLabel m_cDesc;
    private CRhinoOverwriteFileBtn m_cOverwriteTargetBtn;
    private CRhinoOverwriteFileBtn m_cDoNothingBtn;
    private CRhinoOverwriteBtn m_cResumeSourceBtn;
    private CRhinoOverwriteBtn m_cRenameTargetBtn;

    public CConfirmOverwriteDlg(Window rOwnerWnd, CSUMsg rSUMsg, CFile fSource, CWorkerThread rThumbThread, CConnectionAttrs rConnAttrs, long lUISourceAttrID, boolean bIsMove) {
        super(rOwnerWnd, CConfirmDlg.TYPE.OVERWRITE_FILE, rSUMsg, fSource, rThumbThread, rConnAttrs, lUISourceAttrID);
        this._CConfirmFileOverwriteDlg(rOwnerWnd, fSource, bIsMove);
    }

    private void _CConfirmFileOverwriteDlg(Window rOwnerWnd, CFile fSource, boolean bIsMove) {
        ImageIcon ico32;
        this.m_bIsMove = bIsMove;
        String sTitle = CString.LoadString("IDS_CONFIRM_OVERWRITE_DLG_TITLE");
        ArrayList<Image> aImages = new ArrayList<Image>();
        ImageIcon ico16 = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_QUESTION_16_PNG.GetFileName());
        if (ico16 != null) {
            aImages.add(ico16.getImage());
        }
        if ((ico32 = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_QUESTION_32_PNG.GetFileName())) != null) {
            aImages.add(ico32.getImage());
        }
        this.Init(rOwnerWnd, sTitle, aImages, 2, 0, null);
        if (this.m_cOverwriteTargetBtn != null) {
            this.m_cOverwriteTargetBtn.SetFile(fSource);
        }
        this.setMinimumSize(this.CreateDlgSizeMin());
        this.setPreferredSize(this.CreateDlgSizeMin());
    }

    protected Dimension CreateDlgSizeMin() {
        Dimension dimSize = new Dimension(480, 480);
        if (CLocalFileSystem.GetLocalFileSystem().IsMac() || CLocalFileSystem.GetLocalFileSystem().IsNIX()) {
            dimSize.width += 100;
            dimSize.height += 50;
        }
        return dimSize;
    }

    @Override
    protected void CreateUI() {
        Font fFont;
        super.CreateUI();
        this.m_clrBlue = new Color(0, 51, 153);
        this.m_cTitle = new JLabel(CString.LoadString("IDS_OVERWRITE_DLG_HEADER"));
        if (this.CanChangeFont()) {
            fFont = this.m_cTitle.getFont();
            if (fFont != null) {
                fFont = new Font(fFont.getName(), 0, 16);
            }
            this.m_cTitle.setFont(fFont);
        }
        this.m_cTitle.setForeground(this.m_clrBlue);
        this.m_cDesc = new JLabel(CString.LoadString("IDS_OVERWRITE_DLG_DESC"));
        if (this.CanChangeFont()) {
            fFont = this.m_cDesc.getFont();
            if (fFont != null) {
                fFont = new Font(fFont.getName(), 0, fFont.getSize());
            }
            this.m_cDesc.setFont(fFont);
        }
        String sTemp = CString.LoadString("IDS_OVERWRITE_BTN_REPLACE_TITLE");
        if (this.m_bIsMove) {
            sTemp = CString.LoadString("IDS_OVERWRITE_BTN_MOVE_REPLACE_TITLE");
        }
        String sTemp2 = CString.LoadString("IDS_OVERWRITE_BTN_REPLACE_DESC");
        if (this.m_bIsMove) {
            sTemp2 = CString.LoadString("IDS_OVERWRITE_BTN_MOVE_REPLACE_DESC");
        }
        this.m_cOverwriteTargetBtn = new CRhinoOverwriteFileBtn(sTemp, sTemp2, this.GetThumbThread(), this.GetConnectionAttrs(), this.GetUISourceAttrID());
        sTemp = CString.LoadString("IDS_OVERWRITE_BTN_DO_NOTHING_TITLE");
        if (this.m_bIsMove) {
            sTemp = CString.LoadString("IDS_OVERWRITE_BTN_MOVE_DO_NOTHING_TITLE");
        }
        sTemp2 = CString.LoadString("IDS_OVERWRITE_BTN_DO_NOTHING_DESC");
        this.m_cDoNothingBtn = new CRhinoOverwriteFileBtn(sTemp, sTemp2, this.GetThumbThread(), this.GetConnectionAttrs(), this.GetUISourceAttrID());
        sTemp = CString.LoadString("IDS_OVERWRITE_BTN_RESUME_TITLE");
        sTemp2 = CString.LoadString("IDS_OVERWRITE_BTN_RESUME_DESC");
        if (this.m_bIsMove) {
            sTemp2 = CString.LoadString("IDS_OVERWRITE_BTN_MOVE_RESUME_DESC");
        }
        this.m_cResumeSourceBtn = new CRhinoOverwriteBtn(sTemp, sTemp2);
        sTemp = CString.LoadString("IDS_OVERWRITE_BTN_RENAME_TITLE");
        if (this.m_bIsMove) {
            sTemp = CString.LoadString("IDS_OVERWRITE_BTN_MOVE_RENAME_TITLE");
        }
        sTemp2 = CString.LoadString("IDS_FMT_OVERWRITE_BTN_RENAME_DESC");
        if (this.m_bIsMove) {
            sTemp2 = CString.LoadString("IDS_FMT_OVERWRITE_BTN_MOVE_RENAME_DESC");
        }
        this.m_cRenameTargetBtn = new CRhinoOverwriteBtn(sTemp, sTemp2);
        AbstractButton[] aBtns = new AbstractButton[]{this.m_cOverwriteTargetBtn, this.m_cDoNothingBtn, this.m_cResumeSourceBtn, this.m_cRenameTargetBtn};
        for (int nIdx = 0; nIdx < aBtns.length; ++nIdx) {
            aBtns[nIdx].addActionListener(this);
        }
        CRhinoOverwriteBtn[] aOverwriteBtns = new CRhinoOverwriteBtn[]{this.m_cOverwriteTargetBtn, this.m_cDoNothingBtn, this.m_cResumeSourceBtn, this.m_cRenameTargetBtn};
        for (int nIdx = 0; nIdx < aOverwriteBtns.length; ++nIdx) {
            aOverwriteBtns[nIdx].addMouseListener(this);
        }
        Color clr = Color.WHITE;
        clr = UIManager.getColor("TextField.background");
        JPanel rCenter = new JPanel();
        rCenter.setBackground(clr);
        this.remove(this.m_MainPanel);
        GroupLayout layout = new GroupLayout(rCenter);
        rCenter.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.m_cTitle, -1, -2, -2).addComponent(this.m_cDesc, -1, -2, -2).addComponent(this.m_cOverwriteTargetBtn, -1, -2, Short.MAX_VALUE).addComponent(this.m_cDoNothingBtn, -1, -2, Short.MAX_VALUE).addComponent(this.m_cResumeSourceBtn, -1, -2, Short.MAX_VALUE).addComponent(this.m_cRenameTargetBtn, -1, -2, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.m_cTitle, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, -2).addComponent(this.m_cDesc, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, -2).addComponent(this.m_cOverwriteTargetBtn, -1, -2, -2).addComponent(this.m_cDoNothingBtn, -1, -2, -2).addComponent(this.m_cResumeSourceBtn, -1, -2, -2).addComponent(this.m_cRenameTargetBtn, -1, -2, -2));
        JPanel rBottom = new JPanel();
        layout = new GroupLayout(rBottom);
        rBottom.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.m_cDoNotAskAgain, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.m_cCancel, -1, -2, -2));
        layout.setVerticalGroup(layout.createSequentialGroup().addGap(5).addGroup(layout.createParallelGroup().addComponent(this.m_cDoNotAskAgain, -1, -2, -2).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.m_cCancel, -1, -2, -2))));
        rBottom.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY));
        this.setLayout(new BorderLayout());
        this.add((Component)rCenter, "Center");
        this.add((Component)rBottom, "South");
    }

    @Override
    protected boolean FetchConfirmClose() {
        return true;
    }

    @Override
    protected JButton GetDefaultBtn() {
        return this.m_cCancel;
    }

    public void ShowResumeBtn(boolean bShowResume) {
        if (this.m_cResumeSourceBtn != null) {
            this.m_cResumeSourceBtn.setVisible(bShowResume);
            String sAbsPath = "";
            String sFileName = "";
            if (this.GetSourceFile() != null) {
                sAbsPath = this.GetSourceFile().GetAbsPath();
                sFileName = this.GetSourceFile().GetDisplayName();
            }
            String sParentPath = CString.GetFilePath(sAbsPath, true);
            String sFileNameAndPath = String.format("%s (%s)", sFileName, sParentPath);
            this.m_cResumeSourceBtn.SetFileNameText(sFileNameAndPath);
        }
    }

    @Override
    public void SetSourceFile(CFile rSource) {
        super.SetSourceFile(rSource);
        if (this.m_cOverwriteTargetBtn != null) {
            this.m_cOverwriteTargetBtn.SetFile(rSource);
        }
    }

    public void SetTargetFile(CFile rTarget) {
        if (this.m_cDoNothingBtn != null) {
            this.m_cDoNothingBtn.SetFile(rTarget);
        }
    }

    public void SetAbsRenameTo(String sAbsRenameTo) {
        if (sAbsRenameTo != null && !sAbsRenameTo.isEmpty()) {
            String sDesc = CString.LoadString("IDS_FMT_OVERWRITE_BTN_RENAME_DESC");
            if (this.m_bIsMove) {
                sDesc = CString.LoadString("IDS_FMT_OVERWRITE_BTN_MOVE_RENAME_DESC");
            }
            this.m_cRenameTargetBtn.SetDesc(sDesc);
            this.m_cRenameTargetBtn.SetFileNameText(CString.GetFileName(sAbsRenameTo));
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        CRhinoOverwriteBtn[] aOverwriteBtns = new CRhinoOverwriteBtn[]{this.m_cOverwriteTargetBtn, this.m_cDoNothingBtn, this.m_cResumeSourceBtn, this.m_cRenameTargetBtn};
        for (int nIdx = 0; nIdx < aOverwriteBtns.length; ++nIdx) {
            aOverwriteBtns[nIdx].SetPaintFocusRolloverEffect(false);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        CRhinoOverwriteBtn[] aOverwriteBtns = new CRhinoOverwriteBtn[]{this.m_cOverwriteTargetBtn, this.m_cDoNothingBtn, this.m_cResumeSourceBtn, this.m_cRenameTargetBtn};
        for (int nIdx = 0; nIdx < aOverwriteBtns.length; ++nIdx) {
            aOverwriteBtns[nIdx].SetPaintFocusRolloverEffect(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int nResult = 2;
        if (event.getSource() == this.m_cOverwriteTargetBtn) {
            nResult = 0;
        } else if (event.getSource() == this.m_cDoNothingBtn) {
            nResult = 1;
        } else if (event.getSource() == this.m_cResumeSourceBtn) {
            nResult = 4;
        } else if (event.getSource() == this.m_cRenameTargetBtn) {
            nResult = 5;
        }
        this.OnClose(nResult);
    }

    @Override
    protected void SetResult(int nResult) {
        if (nResult == 0 || nResult == 4) {
            if (this.m_cDoNothingBtn != null && this.m_cDoNothingBtn.GetFile() != null && this.m_cDoNothingBtn.GetFile().IsRemote()) {
                this.m_cDoNothingBtn.CheckForAfterActionThumb(this.GetUISourceAttrID(), CThumbnailMsg.AFTER_THUMB_ACTION.OVERWRITE);
            } else if (this.m_cOverwriteTargetBtn != null && this.m_cOverwriteTargetBtn.GetFile() != null && this.m_cOverwriteTargetBtn.GetFile().IsRemote()) {
                this.m_cOverwriteTargetBtn.CheckForAfterActionThumb(this.GetUISourceAttrID(), CThumbnailMsg.AFTER_THUMB_ACTION.OVERWRITE);
            }
        }
        super.SetResult(nResult);
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        super.OnMessage(rMsg);
        CRhinoOverwriteBtn[] arComps = new CRhinoOverwriteBtn[]{this.m_cOverwriteTargetBtn, this.m_cDoNothingBtn, this.m_cResumeSourceBtn, this.m_cRenameTargetBtn};
        for (int nIdx = 0; nIdx < arComps.length; ++nIdx) {
            arComps[nIdx].OnMessage(rMsg);
        }
    }

    @Override
    protected void CancelThumbs() {
        CRhinoOverwriteFileBtn[] arComps = new CRhinoOverwriteFileBtn[]{this.m_cOverwriteTargetBtn, this.m_cDoNothingBtn};
        for (int nIdx = 0; nIdx < arComps.length; ++nIdx) {
            arComps[nIdx].CancelThumbs();
        }
    }

    @Override
    protected void CheckDialogSize() {
        super.CheckDialogSize();
        if (this.m_cResumeSourceBtn != null) {
            boolean bShowResume = this.m_cResumeSourceBtn.isVisible();
            Dimension dimCreationSize = this.CreateDlgSizeMin();
            int nHeight = this.m_cResumeSourceBtn.getHeight() + 4;
            Dimension dimSize = this.getPreferredSize();
            if (bShowResume) {
                dimSize.height += nHeight;
            } else {
                dimSize = dimCreationSize;
            }
            this.setPreferredSize(dimSize);
            dimSize = this.getMinimumSize();
            if (bShowResume) {
                dimSize.height += nHeight;
            } else {
                dimSize = dimCreationSize;
            }
            this.setMinimumSize(dimSize);
        }
    }

    @Override
    protected void FetchThumbs() {
        if (this.m_cOverwriteTargetBtn != null) {
            this.m_cOverwriteTargetBtn.FetchThumbs();
        }
        if (this.m_cDoNothingBtn != null) {
            this.m_cDoNothingBtn.FetchThumbs();
        }
    }

    @Override
    public boolean GetWaitForThumb() {
        boolean bWaitForThumb = super.GetWaitForThumb();
        if (this.m_cDoNothingBtn != null && this.m_cDoNothingBtn.GetFile() != null && this.m_cDoNothingBtn.GetFile().IsRemote()) {
            boolean bl = bWaitForThumb = !this.m_cDoNothingBtn.HasReceivedThumb();
        }
        if (this.m_cOverwriteTargetBtn != null && this.m_cOverwriteTargetBtn.GetFile() != null && this.m_cOverwriteTargetBtn.GetFile().IsRemote()) {
            bWaitForThumb = !this.m_cOverwriteTargetBtn.HasReceivedThumb();
        }
        return bWaitForThumb;
    }

    protected boolean CanChangeFont() {
        boolean bCanChangeFont = true;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            bCanChangeFont = CRhinoApp.GET_RHINO_APP().CanChangeFont();
        }
        return bCanChangeFont;
    }
}

