/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dialogs;

import com.rhinosoft.dialogs.CConfirmDlg;
import com.rhinosoft.files.CFile;
import com.rhinosoft.strings.CString;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class CConfirmMultiDeleteDlg
extends CConfirmDlg {
    public CConfirmMultiDeleteDlg(Window rOwnerWnd, int nNumOfFiles) {
        super(rOwnerWnd, CConfirmDlg.TYPE.DELETE_MULTI, null);
        this._CConfirmMultiDeleteDlg(rOwnerWnd, nNumOfFiles, false);
    }

    public CConfirmMultiDeleteDlg(Window rOwnerWnd, int nNumOfFiles, boolean bHasReadOnlyItems) {
        super(rOwnerWnd, CConfirmDlg.TYPE.DELETE_MULTI, null);
        this._CConfirmMultiDeleteDlg(rOwnerWnd, nNumOfFiles, bHasReadOnlyItems);
    }

    private void _CConfirmMultiDeleteDlg(Window rOwnerWnd, int nNumOfFiles, boolean bHasReadOnlyItems) {
        String sTitle = CString.LoadString("IDS_CONFIRM_DEL_TITLE3");
        String sMsg = String.format(CString.LoadString("IDS_CONFIRM_DEL_PERMANENT3"), nNumOfFiles);
        if (bHasReadOnlyItems) {
            sMsg = String.format(CString.LoadString("IDS_CONFIRM_DEL_PERMANENT3r"), nNumOfFiles);
        }
        ArrayList<Image> aImages = new ArrayList<Image>();
        ImageIcon ico16 = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_DELETE_PNG.GetFileName());
        if (ico16 != null) {
            aImages.add(ico16.getImage());
        }
        this.Init(rOwnerWnd, sTitle, aImages, 0, 2, sMsg);
        this.setMinimumSize(new Dimension(480, 120));
        this.setPreferredSize(new Dimension(480, 120));
    }

    private boolean ContainsReadOnlyFile(CFile[] afFiles) {
        boolean bContainsReadOnlyFile = false;
        if (afFiles != null) {
            for (int nIdx = 0; nIdx < afFiles.length && !bContainsReadOnlyFile; ++nIdx) {
                CFile fNext = afFiles[nIdx];
                if (fNext == null || !fNext.IsReadOnly()) continue;
                bContainsReadOnlyFile = true;
            }
        }
        return bContainsReadOnlyFile;
    }
}

