/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dialogs;

import com.rhinosoft.archive.CRhinoArchive;
import com.rhinosoft.dialogs.CConfirmDlg;
import com.rhinosoft.files.CFile;
import com.rhinosoft.files.CLocalFile;
import com.rhinosoft.messages.CSUMsg;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class CConfirmFolderMergeDlg
extends CConfirmDlg {
    public static final int RESULT_MERGE_FOLDERS = 0;
    public static final int RESULT_DO_NOTHING = 1;
    public static final int RESULT_CANCELLED = 2;
    public static final int RESULT_CLOSED = -1;
    private JLabel m_cSourceIcon;
    private JScrollPane m_cSourceScroll;
    private JLabel m_cSourcePath;
    private JLabel m_cSourceDateModified;
    private JLabel m_cWithThisOne;
    private JLabel m_cTargetIcon;
    private JScrollPane m_cTargetScroll;
    private JLabel m_cTargetPath;
    private JLabel m_cTargetDateModified;
    private CFile m_fTarget;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final JFrame frame = new JFrame("OverwriteDlgTest");
                frame.setDefaultCloseOperation(2);
                frame.setPreferredSize(new Dimension(800, 600));
                boolean bTestReallyLongFilename = true;
                CLocalFile fSource = null;
                CLocalFile fTarget = null;
                if (!bTestReallyLongFilename) {
                    fSource = new CLocalFile(new File("C:\\Temp2\\Test"));
                    fTarget = new CLocalFile(new File("C:\\Temp2\\Test"));
                } else {
                    fSource = new CLocalFile(new File("C:\\Temp2\\\u0e09\u0e31\u0e19\u0e01\u0e34\u0e19\u0e01\u0e23\u0e30\u0e08\u0e01\u0e44\u0e14\u0e49 \u0e41\u0e15\u0e48\u0e21\u0e31\u0e19\u0e44\u0e21\u0e48\u0e17\u0e33\u0e43\u0e2b\u0e49\u0e09\u0e31\u0e19\u0e40\u0e08\u0e47\u0e1a 121020120132013012321030213021302130213021302130210321030213021032103021302103021032103021302103210302103120302130210321030123012\\\u0e09\u0e31\u0e19\u0e01\u0e34\u0e19\u0e01\u0e23\u0e30\u0e08\u0e01\u0e44\u0e14\u0e49 \u0e41\u0e15\u0e48\u0e21\u0e31\u0e19\u0e44\u0e21\u0e48\u0e17\u0e33\u0e43\u0e2b\u0e49\u0e09\u0e31\u0e19\u0e40\u0e08\u0e47\u0e1a 121020120132013012321030213021302130213021302130210321030213021032103021302103021032103021302103210302103120302130210321030123012.jpg"));
                    fTarget = new CLocalFile(new File("C:\\Temp2\\\u0e09\u0e31\u0e19\u0e01\u0e34\u0e19\u0e01\u0e23\u0e30\u0e08\u0e01\u0e44\u0e14\u0e49 \u0e41\u0e15\u0e48\u0e21\u0e31\u0e19\u0e44\u0e21\u0e48\u0e17\u0e33\u0e43\u0e2b\u0e49\u0e09\u0e31\u0e19\u0e40\u0e08\u0e47\u0e1a 121020120132013012321030213021302130213021302130210321030213021032103021302103021032103021302103210302103120302130210321030123012\\\u0e09\u0e31\u0e19\u0e01\u0e34\u0e19\u0e01\u0e23\u0e30\u0e08\u0e01\u0e44\u0e14\u0e49 \u0e41\u0e15\u0e48\u0e21\u0e31\u0e19\u0e44\u0e21\u0e48\u0e17\u0e33\u0e43\u0e2b\u0e49\u0e09\u0e31\u0e19\u0e40\u0e08\u0e47\u0e1a 121020120132013012321030213021302130213021302130210321030213021032103021302103021032103021302103210302103120302130210321030123012.jpg"));
                }
                final CLocalFile fSource2 = fSource;
                final CLocalFile fTarget2 = fTarget;
                JButton rBtn = new JButton("Test Dialog");
                rBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CConfirmFolderMergeDlg dlg = new CConfirmFolderMergeDlg((Window)frame, null, fSource2, fTarget2);
                        dlg.setVisible(true);
                        int result = dlg.GetResult();
                        if (result == 0) {
                            System.out.println("Merge Folders");
                        } else if (result == 1) {
                            System.out.println("Do Nothing");
                        } else if (result == 2) {
                            System.out.println("Cancelled");
                        }
                    }
                });
                JPanel rPanel = new JPanel();
                rPanel.add(rBtn);
                frame.setContentPane(rPanel);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    public CConfirmFolderMergeDlg(Window rOwnerWnd, CSUMsg rSUMsg, CFile fSource, CFile fTarget) {
        super(rOwnerWnd, CConfirmDlg.TYPE.MERGE_FOLDER, rSUMsg, fSource);
        ImageIcon ico32;
        this.m_fTarget = fTarget;
        String sTitle = CString.LoadString("IDS_MERGE_FOLDERS_DLG_TITLE");
        String sFolderName = fSource.GetDisplayName();
        String sMessage1 = CString.LoadString("IDS_MERGE_FOLDERS_DLG_MSG_1");
        sMessage1 = String.format(sMessage1, sFolderName);
        ArrayList<Image> aImages = new ArrayList<Image>();
        ImageIcon ico16 = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_QUESTION_16_PNG.GetFileName());
        if (ico16 != null) {
            aImages.add(ico16.getImage());
        }
        if ((ico32 = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_QUESTION_32_PNG.GetFileName())) != null) {
            aImages.add(ico32.getImage());
        }
        this.Init(rOwnerWnd, sTitle, aImages, 0, 3, sMessage1);
        this._CConfirmFolderMergeDlg();
    }

    private void _CConfirmFolderMergeDlg() {
        this.setMinimumSize(this.CreateDlgSizeMin());
        this.setPreferredSize(this.CreateDlgSizeMin());
    }

    protected Dimension CreateDlgSizeMin() {
        Dimension dimSize = new Dimension(500, 400);
        if (CLocalFileSystem.GetLocalFileSystem().IsMac() || CLocalFileSystem.GetLocalFileSystem().IsNIX()) {
            dimSize.width += 150;
            dimSize.height += 40;
        }
        return dimSize;
    }

    private String FmtDateModifiedString(CFile fFile) {
        String sFmtModified = "";
        if (fFile != null) {
            Date dtModified;
            String sDateModified = CString.LoadString("IDS_MERGE_FOLDERS_DLG_DATE_MODIFIED");
            CRhinoArchive rArchive = null;
            if (CRhinoApp.GET_RHINO_APP() != null) {
                rArchive = CRhinoApp.GET_RHINO_APP().GetArchive();
            }
            if ((dtModified = this.GetSourceFile().GetDateModified()) != null) {
                sFmtModified = String.format(sDateModified, CFile.FormatFileTimestamp(dtModified, rArchive, false));
            }
        }
        return sFmtModified;
    }

    private void InitSourceControls() {
        this.m_cSourceIcon = new JLabel(this.GetSourceFile().GetIcon32());
        this.m_cSourcePath = new JLabel(this.GetSourceFile().GetAbsPath());
        this.m_cSourceDateModified = new JLabel();
        String sFmtModified = this.FmtDateModifiedString(this.GetSourceFile());
        if (sFmtModified == null || sFmtModified.isEmpty()) {
            this.m_cSourceDateModified.setVisible(false);
        }
        this.m_cSourceDateModified.setText(sFmtModified);
        this.m_cSourceIcon.setMinimumSize(new Dimension(32, 32));
        this.m_cSourceIcon.setHorizontalAlignment(0);
        this.m_cSourceIcon.setVerticalAlignment(0);
        JPanel rPanel = new JPanel();
        GroupLayout layout = new GroupLayout(rPanel);
        rPanel.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cSourcePath, -1, -2, Short.MAX_VALUE).addComponent(this.m_cSourceDateModified, -1, -2, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.m_cSourcePath, -1, -2, -2).addComponent(this.m_cSourceDateModified, -1, -2, -2));
        this.m_cSourceScroll = new JScrollPane(rPanel);
        this.m_cSourceScroll.setMinimumSize(new Dimension(100, 50));
        this.m_cSourceScroll.setBorder(BorderFactory.createEmptyBorder());
    }

    private void InitTargetControls() {
        this.m_cTargetIcon = new JLabel(this.m_fTarget.GetIcon32());
        this.m_cTargetPath = new JLabel(this.m_fTarget.GetAbsPath());
        this.m_cTargetDateModified = new JLabel();
        String sFmtModified = this.FmtDateModifiedString(this.m_fTarget);
        if (sFmtModified == null || sFmtModified.isEmpty()) {
            this.m_cTargetDateModified.setVisible(false);
        }
        this.m_cTargetDateModified.setText(sFmtModified);
        this.m_cTargetIcon.setMinimumSize(new Dimension(32, 32));
        this.m_cTargetIcon.setHorizontalAlignment(0);
        this.m_cTargetIcon.setVerticalAlignment(0);
        JPanel rPanel = new JPanel();
        GroupLayout layout = new GroupLayout(rPanel);
        rPanel.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cTargetPath, -1, -2, Short.MAX_VALUE).addComponent(this.m_cTargetDateModified, -1, -2, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.m_cTargetPath, -1, -2, -2).addComponent(this.m_cTargetDateModified, -1, -2, -2));
        this.m_cTargetScroll = new JScrollPane(rPanel);
        this.m_cTargetScroll.setMinimumSize(new Dimension(100, 50));
        this.m_cTargetScroll.setBorder(BorderFactory.createEmptyBorder());
    }

    @Override
    protected void CreateUI() {
        super.CreateUI();
        this.InitSourceControls();
        this.InitTargetControls();
        this.m_cWithThisOne = new JLabel(CString.LoadString("IDS_MERGE_FOLDERS_DLG_MSG_2"));
        GroupLayout layout = new GroupLayout(this.m_MainPanel);
        this.m_MainPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        JPanel rSpacer1 = new JPanel();
        JPanel rSpacer2 = new JPanel();
        JPanel rSpacer3 = new JPanel();
        JPanel[] aSpacers = new JPanel[]{rSpacer1, rSpacer2, rSpacer3};
        for (int nIdx = 0; nIdx < aSpacers.length; ++nIdx) {
            aSpacers[nIdx].setPreferredSize(this.m_cImage.getPreferredSize());
            aSpacers[nIdx].setMinimumSize(this.m_cImage.getMinimumSize());
        }
        this.m_cScrollPaneMessage.setPreferredSize(new Dimension(300, 100));
        this.m_cScrollPaneMessage.setMaximumSize(new Dimension(300, 100));
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.m_cImage, -1, -2, -2).addGap(10).addComponent(this.m_cScrollPaneMessage, -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(rSpacer1, -1, -2, -2).addComponent(this.m_cSourceIcon, -1, -2, -2).addGap(10).addComponent(this.m_cSourceScroll, -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(rSpacer2, -1, -2, -2).addComponent(this.m_cWithThisOne, -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(rSpacer3, -1, -2, -2).addComponent(this.m_cTargetIcon, -1, -2, -2).addGap(10).addComponent(this.m_cTargetScroll, -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.m_cDoNotAskAgain, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -2, Short.MAX_VALUE).addComponent(this.m_cYes, -1, -2, -2).addComponent(this.m_cNo, -1, -2, -2).addComponent(this.m_cCancel, -1, -2, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.m_cImage, -1, -2, -2).addComponent(this.m_cScrollPaneMessage, -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(rSpacer1, -1, -2, -2).addComponent(this.m_cSourceIcon, -1, -2, -2).addComponent(this.m_cSourceScroll, -1, -2, -2)).addGap(15).addGroup(layout.createParallelGroup().addComponent(rSpacer2, -1, -2, -2).addComponent(this.m_cWithThisOne, -1, -2, -2)).addGap(15).addGroup(layout.createParallelGroup().addComponent(rSpacer3, -1, -2, -2).addComponent(this.m_cTargetIcon, -1, -2, -2).addComponent(this.m_cTargetScroll, -1, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -2, Short.MAX_VALUE).addGroup(layout.createParallelGroup().addComponent(this.m_cDoNotAskAgain, -1, -2, -2).addComponent(this.m_cYes, -1, -2, -2).addComponent(this.m_cNo, -1, -2, -2).addComponent(this.m_cCancel, -1, -2, -2)).addGap(10));
    }

    @Override
    protected boolean FetchConfirmClose() {
        return true;
    }

    @Override
    protected void CheckDialogSize() {
        super.CheckDialogSize();
    }
}

