/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dialogs;

import com.rhinosoft.attrs.CBoolAttr;
import com.rhinosoft.dialogs.CConfirmDlg;
import com.rhinosoft.files.CLocalFile;
import com.rhinosoft.messages.CSUMsg;
import com.rhinosoft.strings.CString;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class CConfirmErrorDlg
extends CConfirmDlg {
    public static final int RETRY_IGNORE_OPTION = 7;
    public static final int RETRY_CANCEL_OPTION = 8;
    public static final int RETRY_SKIP_CANCEL_OPTION = 9;
    public static final int RESULT_RETRY = 0;
    public static final int RESULT_SKIP = 1;
    protected JLabel m_cBtnLabel;
    private JButton m_cDetailsBtn;
    private JTextPane m_cDetailsField;
    private JScrollPane m_cDetailsScrollPane;
    private Dimension m_dimPrevSize = null;
    private CBoolAttr m_rbConfirmOnCloseAttr;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final JFrame frame = new JFrame("OverwriteDlgTest");
                frame.setDefaultCloseOperation(2);
                frame.setPreferredSize(new Dimension(800, 600));
                CLocalFile fSource = new CLocalFile(new File("C:\\Temp2\\Test"));
                CLocalFile fTarget = new CLocalFile(new File("C:\\Temp2\\Test"));
                JButton rBtn = new JButton("Test Dialog");
                rBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CConfirmErrorDlg dlg = new CConfirmErrorDlg((Window)frame, null, "Error Dialog", 9, "An error has occurred.", "More Details", null);
                        dlg.SetMessage("really_long_text_123122141324321453543253417143543u589147548908741098490485409854905840954819014835908591405149038549854839218590481534295329058532190854930814815098435848490859018094584095845908504584054854-0");
                        dlg.setVisible(true);
                        int result = dlg.GetResult();
                        if (result == 0) {
                            System.out.println("Retry");
                        } else if (result == 1) {
                            System.out.println("Skip");
                        } else if (result == 2) {
                            System.out.println("Cancelled");
                        }
                    }
                });
                JPanel rPanel = new JPanel();
                rPanel.add(rBtn);
                frame.setContentPane(rPanel);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    public CConfirmErrorDlg(Window rOwnerWnd, CSUMsg rSUMsg, String sTitle, int nDlgType, String sMessage, String sDetails, CBoolAttr rbConfirmOnCloseAttr) {
        super(rOwnerWnd, CConfirmDlg.TYPE.ERROR, rSUMsg);
        ArrayList<Image> aWindowImages = new ArrayList<Image>();
        ImageIcon ico = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_ERROR_16_PNG.GetFileName());
        if (ico != null) {
            aWindowImages.add(ico.getImage());
        }
        if ((ico = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_ERROR_32_PNG.GetFileName())) != null) {
            aWindowImages.add(ico.getImage());
        }
        this.Init(rOwnerWnd, sTitle, aWindowImages, nDlgType, 0, sMessage);
        this._CRhinoErrorDlg(sDetails, rbConfirmOnCloseAttr);
    }

    private void _CRhinoErrorDlg(String sDetails, CBoolAttr rbConfirmOnCloseAttr) {
        this.m_rbConfirmOnCloseAttr = rbConfirmOnCloseAttr;
        this.setResizable(false);
        if (this.m_cDetailsField != null) {
            this.m_cDetailsField.setText(sDetails);
        }
    }

    @Override
    protected void CreateUI() {
        super.CreateUI();
        this.m_cBtnLabel = new JLabel(CString.LoadString("IDS_PROMPT_BTNS_WHAT_TO_DO"));
        this.m_cBtnLabel.setHorizontalAlignment(0);
        this.m_cDetailsBtn = new JButton();
        this.SetBtnTxt(this.m_cDetailsBtn, CString.LoadString("IDS_DETAILS_SHOW", false));
        this.m_cDetailsBtn.addActionListener(this);
        this.m_cDetailsField = new JTextPane();
        this.m_cDetailsScrollPane = new JScrollPane(this.m_cDetailsField);
        this.m_cDetailsField.setEditable(false);
        GroupLayout layout = new GroupLayout(this.m_MainPanel);
        this.m_MainPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.m_cImage, -1, -2, -2).addGap(10).addComponent(this.m_cScrollPaneMessage, -1, -2, Short.MAX_VALUE)).addComponent(this.m_cBtnLabel, -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -2, Short.MAX_VALUE).addComponent(this.m_cYes, -1, -2, -2).addComponent(this.m_cNo, -1, -2, -2).addComponent(this.m_cCancel, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -2, Short.MAX_VALUE)).addComponent(this.m_cDetailsBtn, -1, -2, -2).addComponent(this.m_cDetailsScrollPane, -1, -2, Short.MAX_VALUE).addComponent(this.m_cDoNotAskAgain, -1, -2, -2));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.m_cImage, -1, -2, -2).addComponent(this.m_cScrollPaneMessage, -1, -2, -2)).addComponent(this.m_cBtnLabel, -1, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cYes, -1, -2, -2).addComponent(this.m_cNo, -1, -2, -2).addComponent(this.m_cCancel, -1, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -2, -2).addComponent(this.m_cDetailsBtn, -1, -2, -2).addComponent(this.m_cDetailsScrollPane, -1, -2, Short.MAX_VALUE).addComponent(this.m_cDoNotAskAgain, -1, -2, -2).addGap(8));
        this.m_cScrollPaneMessage.setMinimumSize(new Dimension(200, 100));
        this.m_cScrollPaneMessage.setPreferredSize(new Dimension(200, 100));
        this.setMinimumSize(new Dimension(400, 250));
        this.setPreferredSize(new Dimension(400, 250));
        this.m_cDetailsScrollPane.setVisible(false);
        this.m_cDoNotAskAgain.setVisible(false);
        this.m_cDetailsScrollPane.setMinimumSize(new Dimension(200, 100));
        this.m_cDetailsScrollPane.setPreferredSize(new Dimension(200, 100));
        this.AddKeyListener(this.m_cBtnLabel);
        this.AddKeyListener(this.m_cDetailsBtn);
        this.AddKeyListener(this.m_cDetailsField);
    }

    @Override
    protected JButton GetDefaultBtn() {
        return this.m_cYes;
    }

    @Override
    protected boolean FetchConfirmClose() {
        return true;
    }

    @Override
    protected String GetYesBtnText() {
        String sBtnTxt = super.GetYesBtnText();
        if (this.GetDialogType() == 7 || this.GetDialogType() == 8 || this.GetDialogType() == 9) {
            sBtnTxt = CString.LoadString("IDS_RETRY", false);
        }
        return sBtnTxt;
    }

    @Override
    protected String GetNoBtnText() {
        String sBtnTxt = super.GetNoBtnText();
        if (this.GetDialogType() == 9) {
            sBtnTxt = CString.LoadString("IDS_SKIP", false);
        } else if (this.GetDialogType() == 7) {
            sBtnTxt = CString.LoadString("IDS_IGNORE", false);
        }
        return sBtnTxt;
    }

    @Override
    protected String GetCancelBtnText() {
        String sBtnTxt = super.GetCancelBtnText();
        return sBtnTxt;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_cDetailsBtn) {
            this.OnDetailsBtn();
        } else {
            super.actionPerformed(event);
        }
    }

    private void OnDetailsBtn() {
        if (this.m_cDetailsScrollPane != null) {
            boolean bShowing = this.m_cDetailsScrollPane.isVisible();
            this.m_cDetailsScrollPane.setVisible(!bShowing);
            String sBtn = CString.LoadString("IDS_DETAILS_SHOW");
            if (this.m_cDetailsScrollPane.isVisible()) {
                sBtn = CString.LoadString("IDS_DETAILS_HIDE");
            }
            this.m_cDetailsBtn.setText(sBtn);
            Dimension dimMinSize = this.m_cDetailsScrollPane.getMinimumSize();
            Dimension dimSize = this.getSize();
            if (this.m_cDetailsScrollPane.isVisible()) {
                int nVertLoc = this.m_cDetailsBtn.getLocation().y + this.m_cDetailsBtn.getSize().height + 5;
                if (dimSize.height - nVertLoc <= dimMinSize.height) {
                    this.m_dimPrevSize = (Dimension)dimSize.clone();
                    dimSize.height += dimMinSize.height;
                } else {
                    this.m_dimPrevSize = null;
                }
            } else if (this.m_dimPrevSize != null) {
                dimSize.height = this.m_dimPrevSize.height;
            }
            this.setSize(dimSize);
        }
    }

    private boolean GetConfirmOnClose() {
        boolean bConfirmOnClose = true;
        if (this.m_rbConfirmOnCloseAttr != null) {
            bConfirmOnClose = this.m_rbConfirmOnCloseAttr.GetValue();
        }
        return bConfirmOnClose;
    }

    @Override
    protected void OnUpdateDlgType() {
        boolean bHandleIt = true;
        boolean bShowYes = true;
        boolean bShowNo = false;
        boolean bShowCancel = false;
        switch (this.GetDialogType()) {
            case 7: {
                bShowYes = true;
                bShowNo = true;
                bShowCancel = false;
                break;
            }
            case 8: {
                bShowYes = true;
                bShowNo = false;
                bShowCancel = true;
                break;
            }
            case 9: {
                bShowYes = true;
                bShowNo = true;
                bShowCancel = true;
                break;
            }
            default: {
                bHandleIt = false;
                super.OnUpdateDlgType();
            }
        }
        if (bHandleIt) {
            this.m_cYes.setVisible(bShowYes);
            this.m_cNo.setVisible(bShowNo);
            this.m_cCancel.setVisible(bShowCancel);
        }
    }
}

