/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dialogs;

import com.rhinosoft.dialogs.CRhinoMessageBox;
import com.rhinosoft.files.CFile;
import com.rhinosoft.messages.CSUMsg;
import com.rhinosoft.strings.CString;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JButton;

public abstract class CConfirmDlg
extends CRhinoMessageBox {
    public static final int RESULT_RESET = -5;
    public static final int RESULT_CONFIRMED = 0;
    public static final int RESULT_IGNORED = 1;
    public static final int RESULT_CANCELLED = 2;
    public static final int RESULT_CLOSED = -1;
    public static final int TYPE_UNKNOWN = 0;
    private TYPE m_nType = TYPE.UNKNOWN;
    private CFile m_fSource;
    private CSUMsg m_rSUMsg;

    public CConfirmDlg(Window rOwnerWnd, TYPE nType, CSUMsg rSUMsg) {
        super(rOwnerWnd);
        this._CConfirmDlg(nType, rSUMsg, null);
    }

    protected CConfirmDlg(Window rOwnerWnd, TYPE nType, CSUMsg rSUMsg, CFile fSource) {
        super(rOwnerWnd);
        this._CConfirmDlg(nType, rSUMsg, fSource);
    }

    private void _CConfirmDlg(TYPE nType, CSUMsg rSUMsg, CFile fSource) {
        this.m_nType = nType;
        this.SetSUMsg(rSUMsg);
        this.SetSourceFile(fSource);
        this.setMinimumSize(new Dimension(480, 110));
        this.setPreferredSize(new Dimension(480, 110));
    }

    public void SetSourceFile(CFile fSource) {
        this.m_fSource = fSource;
    }

    public CFile GetSourceFile() {
        return this.m_fSource;
    }

    public void SetSUMsg(CSUMsg rSUMsg) {
        this.m_rSUMsg = rSUMsg;
    }

    public CSUMsg GetSUMsg() {
        return this.m_rSUMsg;
    }

    @Override
    protected JButton GetDefaultBtn() {
        return this.m_cNo;
    }

    @Override
    protected boolean FetchConfirmClose() {
        return true;
    }

    @Override
    protected String GetDoNotShowAgainBtnText() {
        return CString.LoadString("IDS_CONFIRM_DO_FOR_REMAINING_CONFLICTS", false);
    }

    public TYPE GetType() {
        return this.m_nType;
    }

    public boolean GetWaitForThumb() {
        return false;
    }

    public static enum TYPE {
        UNKNOWN,
        DELETE_FOLDER,
        DELETE_FILE,
        DELETE_MULTI,
        OVERWRITE_FILE,
        MERGE_FOLDER,
        ERROR;

    }
}

