/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dialogs;

import com.rhinosoft.attrs.CConnectionAttrs;
import com.rhinosoft.dialogs.CConfirmDlg;
import com.rhinosoft.dialogs.CConfirmThumbDlg;
import com.rhinosoft.dialogs.CRhinoOverwriteDelBtn;
import com.rhinosoft.files.CFile;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CSUMsg;
import com.rhinosoft.messages.CThumbnailMsg;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.threads.CWorkerThread;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.LayoutStyle;

public class CConfirmDeleteDlg
extends CConfirmThumbDlg {
    private Icon m_rIcon;
    private CRhinoOverwriteDelBtn m_cDeleteTargetBtn;

    public CConfirmDeleteDlg(Window rOwnerWnd, CSUMsg rSUMsg, boolean bSourceIsDir, CFile fSource, CWorkerThread rThumbThread, CConnectionAttrs rConnAttrs, long lUISourceAttrID) {
        super(rOwnerWnd, bSourceIsDir ? CConfirmDlg.TYPE.DELETE_FOLDER : CConfirmDlg.TYPE.DELETE_FILE, rSUMsg, fSource, rThumbThread, rConnAttrs, lUISourceAttrID);
        this._CConfirmFileDeleteDlg(rOwnerWnd);
    }

    private void _CConfirmFileDeleteDlg(Window rCenterTo) {
        String sTitle = CString.LoadString("IDS_CONFIRM_DEL_TITLE1");
        String sMsg = CString.LoadString("IDS_CONFIRM_DEL_PERMANENT_FILE");
        this.m_rIcon = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_DELETE_FILE_32_PNG.GetFileName());
        CFile fSource = this.GetSourceFile();
        if (fSource != null && fSource.IsDirectory()) {
            sTitle = CString.LoadString("IDS_CONFIRM_DEL_TITLE2");
            sMsg = CString.LoadString("IDS_CONFIRM_DEL_PERMANENT_FOLDER");
            this.m_rIcon = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_DELETE_FOLDER_32_PNG.GetFileName());
        }
        ArrayList<Image> aImages = new ArrayList<Image>();
        ImageIcon ico16 = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_DELETE_PNG.GetFileName());
        if (ico16 != null) {
            aImages.add(ico16.getImage());
        }
        this.Init(rCenterTo, sTitle, aImages, 0, 0, sMsg);
        if (this.m_cImage != null) {
            this.m_cImage.setIcon(this.m_rIcon);
        }
        this.setMinimumSize(this.CreateDlgSizeMin());
        this.setPreferredSize(this.CreateDlgSizeMin());
    }

    protected Dimension CreateDlgSizeMin() {
        Dimension dimSize = new Dimension(440, 240);
        if (CLocalFileSystem.GetLocalFileSystem().IsMac() || CLocalFileSystem.GetLocalFileSystem().IsNIX()) {
            dimSize.width += 100;
            dimSize.height += 50;
        }
        return dimSize;
    }

    @Override
    protected void CreateUI() {
        super.CreateUI();
        Dimension dimMinimumSize = new Dimension(100, 40);
        this.m_cScrollPaneMessage.setMinimumSize(dimMinimumSize);
        this.m_cScrollPaneMessage.setPreferredSize(dimMinimumSize);
        this.m_cMessage.setMinimumSize(dimMinimumSize);
        this.m_cMessage.setPreferredSize(dimMinimumSize);
        if (CLocalFileSystem.GetLocalFileSystem().IsNIX()) {
            this.m_cScrollPaneMessage.setBorder(BorderFactory.createEmptyBorder());
            this.m_cMessage.setBorder(BorderFactory.createEmptyBorder());
        }
        this.m_cDeleteTargetBtn = new CRhinoOverwriteDelBtn(this.GetThumbThread(), this.GetConnectionAttrs(), this.GetUISourceAttrID());
        this.m_cDeleteTargetBtn.SetFile(this.GetSourceFile());
        GroupLayout layout = new GroupLayout(this.m_MainPanel);
        this.m_MainPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.m_cImage, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cScrollPaneMessage, -2, -2, Short.MAX_VALUE).addComponent(this.m_cDeleteTargetBtn, -1, -2, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.m_cDoNotAskAgain, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -2, Short.MAX_VALUE).addComponent(this.m_cYes, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, -2).addComponent(this.m_cNo, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, -2).addComponent(this.m_cCancel, -1, -2, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.m_cImage, -1, -2, -2).addGroup(layout.createSequentialGroup().addComponent(this.m_cScrollPaneMessage, -2, -2, -2).addComponent(this.m_cDeleteTargetBtn, -1, -2, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cDoNotAskAgain, -1, -2, -2).addComponent(this.m_cYes, -1, -2, -2).addComponent(this.m_cNo, -1, -2, -2).addComponent(this.m_cCancel, -1, -2, -2)));
    }

    @Override
    public void SetSourceFile(CFile rSource) {
        super.SetSourceFile(rSource);
        if (this.m_cDeleteTargetBtn != null) {
            this.m_cDeleteTargetBtn.SetFile(rSource);
        }
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        super.OnMessage(rMsg);
        if (this.m_cDeleteTargetBtn != null) {
            this.m_cDeleteTargetBtn.OnMessage(rMsg);
        }
    }

    @Override
    protected void CancelThumbs() {
        if (this.m_cDeleteTargetBtn != null) {
            this.m_cDeleteTargetBtn.CancelThumbs();
        }
    }

    @Override
    protected String GetDoNotShowAgainBtnText() {
        return CString.LoadString("IDS_CONFIRM_DO_FOR_REMAINING_ITEMS", false);
    }

    @Override
    protected void CheckDialogSize() {
        super.CheckDialogSize();
    }

    @Override
    protected void SetResult(int nResult) {
        if (nResult != 0) {
            nResult = 2;
        } else if (this.m_cDeleteTargetBtn != null) {
            this.m_cDeleteTargetBtn.CheckForAfterActionThumb(this.GetUISourceAttrID(), CThumbnailMsg.AFTER_THUMB_ACTION.DELETE);
        }
        super.SetResult(nResult);
    }

    @Override
    protected void FetchThumbs() {
        if (this.m_cDeleteTargetBtn != null) {
            this.m_cDeleteTargetBtn.FetchThumbs();
        }
    }

    @Override
    public boolean GetWaitForThumb() {
        boolean bWaitForThumb = super.GetWaitForThumb();
        if (this.m_cDeleteTargetBtn != null) {
            bWaitForThumb = !this.m_cDeleteTargetBtn.HasReceivedThumb();
        }
        return bWaitForThumb;
    }
}

