/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.attrs;

import com.rhinosoft.archive.IArchive;
import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.strings.CString;

public class CStringAttr
extends CAttr {
    protected static boolean DEBUG_ENCODING_CHARS;
    protected static boolean DEBUG_ENCODINGS;
    private String m_sDefault;
    private String m_sValue;

    public CStringAttr(String sValue, String sDefault) {
        this._CStringAttr(sValue, sDefault);
    }

    public CStringAttr(String sValue, String sDefault, String sArchiveKey) {
        super(sArchiveKey);
        this._CStringAttr(sValue, sDefault);
    }

    public CStringAttr(String sValue, String sDefault, long lMin, long lMax) {
        super(lMin, lMax);
        this._CStringAttr(sValue, sDefault);
    }

    public CStringAttr(String sValue, String sDefault, long lMin, long lMax, String sArchiveKey) {
        super(lMin, lMax, sArchiveKey);
        this._CStringAttr(sValue, sDefault);
    }

    private void _CStringAttr(String sValue, String sDefault) {
        this.m_sValue = sValue;
        this.m_sDefault = sDefault;
    }

    public String GetDefault() {
        return this.m_sDefault;
    }

    public void SetDefault(String sVal) {
        this.m_sDefault = sVal;
    }

    public String GetValue() {
        return this.m_sValue;
    }

    public void SetValue(String sVal) {
        this.m_sValue = sVal;
    }

    @Override
    public void Save(IArchive rArchive) {
        if (CStringAttr.IsValid(this.GetArchiveKey()) && rArchive != null) {
            rArchive.SetValue(this.GetArchiveKey(), this.m_sValue, this.m_sDefault);
        } else if (DEBUG) {
            CDebugLog.ASSERT(CAttr.class.getName(), CDebugLog.GetLineNumber(), "Cannot save CAttr due to an invalid ArchiveKey!");
        }
    }

    @Override
    public void Load(IArchive rArchive) {
        if (CStringAttr.IsValid(this.GetArchiveKey()) && rArchive != null) {
            this.m_sValue = rArchive.GetValue(this.GetArchiveKey(), this.m_sDefault);
        } else if (DEBUG) {
            CDebugLog.ASSERT(CAttr.class.getName(), CDebugLog.GetLineNumber(), "Cannot load CAttr due to an invalid ArchiveKey!");
        }
    }

    @Override
    public String toString() {
        StringBuilder sRet = new StringBuilder(super.toString());
        sRet.append(String.format("Value: %s\r\n", this.GetValue() == null ? "null" : this.GetValue().toString()));
        sRet.append(String.format("Default: %s\r\n", this.GetDefault() == null ? "null" : this.GetDefault().toString()));
        return sRet.toString();
    }

    public String HTMLEncode(String sOriginal) {
        return CString.HTMLEncode(sOriginal, DEBUG_ENCODINGS, DEBUG_ENCODING_CHARS);
    }

    public static String HexEncode(String sOriginal) {
        return CString.HexEncode(sOriginal, DEBUG_ENCODINGS, DEBUG_ENCODING_CHARS);
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_ENCODING_CHARS = false;
        DEBUG_ENCODINGS = DEBUG;
    }
}

