/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.attrs;

import com.rhinosoft.archive.IArchive;
import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.log.CDebugLog;

public class CLongAttr
extends CAttr {
    private long m_lDefault;
    private long m_lValue;

    public CLongAttr(long lValue, long lDefault) {
        super(ABSOLUTE_MIN_VAL, ABSOLUTE_MAX_VAL);
        this._CLongAttr(lValue, lDefault);
    }

    public CLongAttr(long lValue, long lDefault, String sArchiveKey) {
        super(ABSOLUTE_MIN_VAL, ABSOLUTE_MAX_VAL, sArchiveKey);
        this._CLongAttr(lValue, lDefault);
    }

    public CLongAttr(long lValue, long lDefault, long lMin, long lMax) {
        super(lMin, lMax);
        this._CLongAttr(lValue, lDefault);
    }

    public CLongAttr(long lValue, long lDefault, long lMin, long lMax, String sArchiveKey) {
        super(lMin, lMax, sArchiveKey);
        this._CLongAttr(lValue, lDefault);
    }

    private void _CLongAttr(long lValue, long lDefault) {
        this.m_lValue = lValue;
        this.m_lDefault = lDefault;
    }

    public long GetDefault() {
        return this.m_lDefault;
    }

    public void SetDefault(long lVal) {
        this.m_lDefault = lVal;
    }

    public long GetValue() {
        return this.m_lValue;
    }

    public void SetValue(long lVal) {
        this.m_lValue = lVal;
    }

    @Override
    public void Save(IArchive rArchive) {
        if (rArchive != null && CLongAttr.IsValid(this.GetArchiveKey())) {
            rArchive.SetValue(this.GetArchiveKey(), this.m_lValue, this.m_lDefault);
        } else if (DEBUG) {
            CDebugLog.ASSERT(CAttr.class.getName(), CDebugLog.GetLineNumber(), "Cannot save CAttr due to an invalid ArchiveKey!");
        }
    }

    @Override
    public void Load(IArchive rArchive) {
        if (rArchive != null && CLongAttr.IsValid(this.GetArchiveKey())) {
            this.m_lValue = rArchive.GetValueLong(this.GetArchiveKey(), this.m_lDefault);
        } else if (DEBUG) {
            CDebugLog.ASSERT(CAttr.class.getName(), CDebugLog.GetLineNumber(), "Cannot load CAttr due to an invalid ArchiveKey!");
        }
    }

    @Override
    public String toString() {
        StringBuilder sRet = new StringBuilder(super.toString());
        sRet.append(String.format("Value: %s\r\n", Long.toString(this.GetValue())));
        sRet.append(String.format("Default: %s\r\n", Long.toString(this.GetDefault())));
        return sRet.toString();
    }
}

