/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.attrs;

import com.rhinosoft.archive.IArchive;
import com.rhinosoft.attrs.CAttr;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class CDateAttr
extends CAttr {
    public static final String DEFAULT_FORMAT = "EEE, d MMM yyyy HH:mm:ss";
    public static final String HTTP_FORMAT = "EEE, dd MMM yyyy HH:mm:ss";
    private Date m_dtDefault;
    private Date m_dtValue;

    public CDateAttr(long lNumOfMillisFromEpoch, long lDefaultNumOfMillisFromEpoch) {
        this._CDateAttr(new Date(lDefaultNumOfMillisFromEpoch), new Date(lNumOfMillisFromEpoch));
    }

    public CDateAttr(long lNumOfMillisFromEpoch, long lDefaultNumOfMillisFromEpoch, String sArchiveKey) {
        super(sArchiveKey);
        this._CDateAttr(new Date(lDefaultNumOfMillisFromEpoch), new Date(lNumOfMillisFromEpoch));
    }

    public CDateAttr(long lNumOfMillisFromEpoch, long lDefaultNumOfMillisFromEpoch, long lMin, long lMax) {
        super(lMin, lMax);
        this._CDateAttr(new Date(lDefaultNumOfMillisFromEpoch), new Date(lNumOfMillisFromEpoch));
    }

    public CDateAttr(long lNumOfMillisFromEpoch, long lDefaultNumOfMillisFromEpoch, long lMin, long lMax, String sArchiveKey) {
        super(lMin, lMax, sArchiveKey);
        this._CDateAttr(new Date(lDefaultNumOfMillisFromEpoch), new Date(lNumOfMillisFromEpoch));
    }

    public CDateAttr(Date dtValue, Date dtDefault) {
        this._CDateAttr(dtValue, dtDefault);
    }

    public CDateAttr(Date dtValue, Date dtDefault, String sArchiveKey) {
        super(sArchiveKey);
        this._CDateAttr(dtValue, dtDefault);
    }

    public CDateAttr(Date dtValue, Date dtDefault, long lMin, long lMax) {
        super(lMin, lMax);
        this._CDateAttr(dtValue, dtDefault);
    }

    public CDateAttr(Date dtValue, Date dtDefault, long lMin, long lMax, String sArchiveKey) {
        super(lMin, lMax, sArchiveKey);
        this._CDateAttr(dtValue, dtDefault);
    }

    private void _CDateAttr(Date dtValue, Date dtDefault) {
        this.m_dtValue = dtValue;
        this.m_dtDefault = dtDefault;
    }

    public Date GetDefault() {
        return this.m_dtDefault;
    }

    public void SetDefault(Date dtVal) {
        this.m_dtDefault = dtVal;
    }

    public Date GetValue() {
        return this.m_dtValue;
    }

    public void SetValue(Date dtVal) {
        this.m_dtValue = dtVal;
    }

    public String Format(String sPattern) {
        long lTime = 0L;
        if (this.GetValue() != null) {
            lTime = this.GetValue().getTime();
        }
        return CDateAttr.Format(lTime, sPattern);
    }

    public static String Format(long lTime, String sPattern) {
        String sRet = Long.toString(lTime);
        SimpleDateFormat Formatter = new SimpleDateFormat(sPattern);
        if (Formatter != null) {
            sRet = Formatter.format(lTime);
            Formatter = null;
        }
        return sRet;
    }

    @Override
    public void Save(IArchive rArchive) {
    }

    @Override
    public void Load(IArchive rArchive) {
    }

    @Override
    public String toString() {
        StringBuilder sRet = new StringBuilder(super.toString());
        sRet.append(String.format("Value: %s\r\n", this.GetValue() == null ? "null" : this.GetValue().toString()));
        sRet.append(String.format("Default: %s\r\n", this.GetDefault() == null ? "null" : this.GetDefault().toString()));
        return sRet.toString();
    }

    public static long ConvertDateToTimeT(long lDate) {
        return lDate / 1000L;
    }

    public static long ConvertTimeT(long lTimeT) {
        return lTimeT * 1000L;
    }

    public static Date ConvertTimeTToDate(long lTimeT) {
        return new Date(CDateAttr.ConvertTimeT(lTimeT));
    }

    public static String FormatURLDate(long lTime) {
        SimpleDateFormat HttpFormatter = new SimpleDateFormat(HTTP_FORMAT, Locale.US);
        HttpFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String sRet = HttpFormatter.format(new Date(lTime)) + " GMT";
        return sRet;
    }
}

