/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.attrs;

import com.rhinosoft.attrs.CAttrs;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.strings.CString;
import java.util.Locale;
import javax.swing.UIManager;

public class CConnectionAttrs
extends CAttrs {
    private static final String DEFAULT_USER = "DefaultUser";
    private static final String LOCAL_ADMIN_USER = "LocalAdmin";
    private String m_sHost;
    private long m_lServerPort;
    private long m_lHeaderPort;
    private String m_sEncSessionID;
    private String m_sUserAgent;
    private Locale m_Locale;
    private String m_sLoginID;
    private String m_sSupportLink;
    private boolean m_bIsSecure;
    private boolean m_bIsCaseSensitiveOS;
    private boolean m_bCanChangePword;
    private boolean m_bIsLocalAdmin;
    private String m_sEmailAddress;
    private boolean m_bUserCanSetEmailAddress;
    private boolean m_bRequireEmailAddress;

    public CConnectionAttrs() {
        this._CConnectionAttrs();
    }

    private void _CConnectionAttrs() {
        this.m_sHost = null;
        this.m_lServerPort = -1L;
        this.m_lHeaderPort = -1L;
        this.m_sEncSessionID = null;
        this.m_sUserAgent = null;
        this.m_Locale = Locale.getDefault();
        this.m_sLoginID = DEFAULT_USER;
        this.m_sSupportLink = null;
        this.m_bIsSecure = false;
        this.m_bIsCaseSensitiveOS = true;
        this.m_bCanChangePword = false;
        this.m_bIsLocalAdmin = false;
        this.m_bUserCanSetEmailAddress = false;
        this.m_bRequireEmailAddress = false;
    }

    public void Copy(CConnectionAttrs rConnAttr) {
        if (rConnAttr != null) {
            this.m_sHost = rConnAttr.m_sHost;
            this.m_lServerPort = rConnAttr.m_lServerPort;
            this.m_lHeaderPort = rConnAttr.m_lHeaderPort;
            this.m_sEncSessionID = rConnAttr.m_sEncSessionID;
            this.m_sUserAgent = rConnAttr.m_sUserAgent;
            this.m_Locale = new Locale(rConnAttr.m_Locale.getLanguage(), rConnAttr.m_Locale.getCountry());
            this.m_sLoginID = rConnAttr.m_sLoginID;
            this.m_sSupportLink = rConnAttr.m_sSupportLink;
            this.m_bIsSecure = rConnAttr.m_bIsSecure;
            this.m_bIsCaseSensitiveOS = rConnAttr.m_bIsCaseSensitiveOS;
            this.m_bCanChangePword = rConnAttr.m_bCanChangePword;
            this.m_bIsLocalAdmin = rConnAttr.m_bIsLocalAdmin;
            this.m_sEmailAddress = rConnAttr.m_sEmailAddress;
            this.m_bUserCanSetEmailAddress = rConnAttr.m_bUserCanSetEmailAddress;
            this.m_bRequireEmailAddress = rConnAttr.m_bRequireEmailAddress;
        }
    }

    public void SetHost(String sHost) {
        this.m_sHost = sHost;
    }

    public String GetHost() {
        return this.GetHost(false);
    }

    public String GetHost(boolean bRemoveInvalidPathChars) {
        String sRetHost = this.m_sHost;
        if (bRemoveInvalidPathChars) {
            sRetHost = CConnectionAttrs.FormatHostForPath(this.m_sHost);
        }
        return sRetHost;
    }

    public static String FormatHostForPath(String sHost) {
        String sRetHost = sHost;
        if (sHost != null && !sHost.isEmpty()) {
            StringBuilder sCompiledHost = new StringBuilder();
            char[] achExcludedChars = new char[]{':', '*', '?', '\"', '<', '>', '|'};
            for (int nIdx = 0; nIdx < sHost.length(); ++nIdx) {
                char chNext = sHost.charAt(nIdx);
                boolean bIsExcludedChar = false;
                for (int nIdx2 = 0; nIdx2 < achExcludedChars.length; ++nIdx2) {
                    if (chNext != achExcludedChars[nIdx2]) continue;
                    bIsExcludedChar = true;
                    break;
                }
                if (!bIsExcludedChar) {
                    sCompiledHost.append(chNext);
                    continue;
                }
                sCompiledHost.append('_');
            }
            if (sCompiledHost != null && sCompiledHost.length() > 0) {
                sRetHost = sCompiledHost.toString();
            }
        }
        return sRetHost;
    }

    public void SetUserAgent(String sUserAgent) {
        this.m_sUserAgent = sUserAgent;
    }

    public final String GetUserAgent() {
        return this.m_sUserAgent;
    }

    public void SetServerPort(long lPort) {
        this.m_lServerPort = lPort;
    }

    public final long GetServerPort() {
        return this.m_lServerPort;
    }

    public void SetHeaderPort(long lPort) {
        this.m_lHeaderPort = lPort;
    }

    public final long GetHeaderPort() {
        return this.m_lHeaderPort;
    }

    public long GetPublicPort() {
        long lPublicPort = this.GetServerPort();
        if (lPublicPort != this.GetHeaderPort() && this.GetHeaderPort() > 0L) {
            lPublicPort = this.GetHeaderPort();
        }
        return lPublicPort;
    }

    public void SetEncSessionID(String sID) {
        this.m_sEncSessionID = sID;
    }

    public final String GetEncSessionID() {
        return this.m_sEncSessionID;
    }

    public void SetLocaleCodes(String sLanguageCode, String sCountryCode) {
        block4: {
            if (sLanguageCode != null && sLanguageCode.toLowerCase().equals("jp")) {
                sLanguageCode = Locale.JAPANESE.getLanguage();
            }
            if (sLanguageCode != null && !sLanguageCode.isEmpty() && sCountryCode != null && !sCountryCode.isEmpty()) {
                this.m_Locale = new Locale(sLanguageCode, sCountryCode);
                try {
                    UIManager.put("FileChooser.lookInLabelText", CString.LoadString("IDS_FILE_CHOOSER_LOOK_IN_LABEL"));
                    UIManager.put("FileChooser.filesOfTypeLabelText", CString.LoadString("IDS_FILE_CHOOSER_FILES_OF_TYPE_LABEL"));
                    UIManager.put("FileChooser.upFolderToolTipText", CString.LoadString("IDS_FILE_CHOOSER_UP_FOLDER_TIP"));
                    UIManager.put("FileChooser.fileNameLabelText", CString.LoadString("IDS_FILE_CHOOSER_FILENAME_LABEL"));
                    UIManager.put("FileChooser.homeFolderToolTipText", CString.LoadString("IDS_FILE_CHOOSER_HOME_FOLDER_TIP"));
                    UIManager.put("FileChooser.newFolderToolTipText", CString.LoadString("IDS_FILE_CHOOSER_NEW_FOLDER_TIP"));
                    UIManager.put("FileChooser.listViewButtonToolTipText", CString.LoadString("IDS_FILE_CHOOSER_LIST_VIEW_TIP"));
                    UIManager.put("FileChooser.detailsViewButtonToolTipText", CString.LoadString("IDS_FILE_CHOOSER_DETAILS_VIEW_TIP"));
                    UIManager.put("FileChooser.saveButtonText", CString.LoadString("IDS_FILE_CHOOSER_SAVE_BTN"));
                    UIManager.put("FileChooser.openButtonText", CString.LoadString("IDS_FILE_CHOOSER_OPEN_BTN"));
                    UIManager.put("FileChooser.cancelButtonText", CString.LoadString("IDS_FILE_CHOOSER_CANCEL_BTN"));
                    UIManager.put("FileChooser.updateButtonText", CString.LoadString("IDS_FILE_CHOOSER_UPDATE_BTN"));
                    UIManager.put("FileChooser.helpButtonText", CString.LoadString("IDS_FILE_CHOOSER_HELP_BTN"));
                    UIManager.put("FileChooser.saveButtonToolTipText", CString.LoadString("IDS_FILE_CHOOSER_SAVE_TIP"));
                    UIManager.put("FileChooser.openButtonToolTipText", CString.LoadString("IDS_FILE_CHOOSER_OPEN_TIP"));
                    UIManager.put("FileChooser.cancelButtonToolTipText", CString.LoadString("IDS_FILE_CHOOSER_CANCEL_TIP"));
                    UIManager.put("FileChooser.updateButtonToolTipText", CString.LoadString("IDS_FILE_CHOOSER_UPDATE_TIP"));
                    UIManager.put("FileChooser.helpButtonToolTipText", CString.LoadString("IDS_FILE_CHOOSER_HELP_TIP"));
                }
                catch (Exception e) {
                    if (!DEBUG) break block4;
                    CDebugLog.EXCEPTION(CConnectionAttrs.class.getName(), CDebugLog.GetLineNumber(), e.getMessage(), false);
                }
            }
        }
    }

    public final String GetLanguageCode() {
        return this.m_Locale.getLanguage();
    }

    public final String GetCountryCode() {
        return this.m_Locale.getCountry();
    }

    public final Locale GetLocale() {
        return this.m_Locale;
    }

    public void SetLoginID(String sLoginID) {
        this.m_sLoginID = sLoginID;
    }

    public final String GetLoginID() {
        return this.m_sLoginID;
    }

    public void SetSupportLink(String sSupportLink) {
        this.m_sSupportLink = sSupportLink;
    }

    public final String GetSupportLink() {
        return this.m_sSupportLink;
    }

    public void SetIsSecure(boolean bIsSecure) {
        this.m_bIsSecure = bIsSecure;
    }

    public final boolean IsSecure() {
        return this.m_bIsSecure;
    }

    public void SetCaseSensitiveOS(boolean bIsCaseSensitiveOS) {
        this.m_bIsCaseSensitiveOS = bIsCaseSensitiveOS;
    }

    public final boolean IsCaseSensitiveOS() {
        return this.m_bIsCaseSensitiveOS;
    }

    public void SetCanChangePword(boolean bCanChangePword) {
        this.m_bCanChangePword = bCanChangePword;
    }

    public final boolean GetCanChangePword() {
        return this.m_bCanChangePword;
    }

    public void SetIsLocalAdmin(boolean bIsLocalAdmin) {
        this.m_bIsLocalAdmin = bIsLocalAdmin;
        if (this.m_sLoginID == null || this.m_sLoginID.isEmpty() || this.m_sLoginID.equals(DEFAULT_USER) || this.m_sLoginID.equals(LOCAL_ADMIN_USER)) {
            if (this.m_bIsLocalAdmin) {
                this.SetLoginID(LOCAL_ADMIN_USER);
            } else {
                this.SetLoginID(DEFAULT_USER);
            }
        }
    }

    public final boolean IsLocalAdmin() {
        return this.m_bIsLocalAdmin;
    }

    public void SetUserEmailAddress(String sEmailAddress) {
        this.m_sEmailAddress = sEmailAddress;
    }

    public final String GetUserEmailAddress() {
        return this.m_sEmailAddress;
    }

    public void SetRequireEmailAddress(boolean bRequireEmailAddress) {
        this.m_bRequireEmailAddress = bRequireEmailAddress;
    }

    public boolean GetRequireEmailAddress() {
        return this.m_bRequireEmailAddress;
    }

    public void SetUserCanSetEmailAddress(boolean bUserCanSetEmailAddress) {
        this.m_bUserCanSetEmailAddress = bUserCanSetEmailAddress;
    }

    public boolean GetUserCanSetEmailAddress() {
        return this.m_bUserCanSetEmailAddress;
    }
}

