/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.attrs;

import com.rhinosoft.archive.IArchive;
import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.strings.CString;
import java.awt.Color;

public class CColorAttr
extends CAttr {
    public static final Color DEFAULT_COLOR = Color.BLACK;
    private Color m_clrDefault;
    private Color m_clrValue;

    public CColorAttr(Color clrVal, Color clrDefault) {
        this._CColorAttr(clrVal, clrDefault);
    }

    public CColorAttr(Color clrVal, Color clrDefault, String sArchiveKey) {
        super(sArchiveKey);
        this._CColorAttr(clrVal, clrDefault);
    }

    private void _CColorAttr(Color clrVal, Color clrDefault) {
        this.m_clrValue = clrVal;
        this.m_clrDefault = clrDefault;
    }

    public Color GetDefault() {
        return this.m_clrDefault;
    }

    public void SetDefault(Color clrVal) {
        this.m_clrDefault = clrVal;
    }

    public Color GetValue() {
        return this.m_clrValue;
    }

    public void SetValue(Color clrVal) {
        this.m_clrValue = clrVal;
    }

    private String EnsureDigits(String sTemp, int nDigits) {
        StringBuilder sRet = new StringBuilder();
        if (sTemp.length() < nDigits) {
            for (int nIdx = sTemp.length(); nIdx < nDigits; ++nIdx) {
                sRet = sRet.append("0");
            }
        }
        sRet.append(sTemp);
        return sRet.toString();
    }

    public String GetHexValue() {
        String sHexRed = this.EnsureDigits(String.format("%s", Long.toHexString(this.GetValue().getRed())), 2);
        String sHexGreen = this.EnsureDigits(Long.toHexString(this.GetValue().getGreen()), 2);
        String sHexBlue = this.EnsureDigits(Long.toHexString(this.GetValue().getBlue()), 2);
        String sRet = String.format("%s%s%s", sHexRed, sHexGreen, sHexBlue);
        return sRet;
    }

    public String GetHtmlValue() {
        String sRet = this.GetHexValue();
        sRet = CString.EnsureFirstChar('#', sRet);
        return sRet;
    }

    public static boolean IsADarkColor(Color clrTest) {
        boolean bIsADarkColor = false;
        if (clrTest != null) {
            int nRed = clrTest.getRed();
            int nGreen = clrTest.getGreen();
            int nBlue = clrTest.getBlue();
            if (nRed < 129 && nGreen < 129 || nRed < 129 && nBlue < 129 || nGreen < 129 && nBlue < 129) {
                bIsADarkColor = true;
            }
        }
        return bIsADarkColor;
    }

    @Override
    public void Save(IArchive rArchive) {
        if (CColorAttr.IsValid(this.GetArchiveKey()) && rArchive != null) {
            rArchive.SetValue(this.GetArchiveKey(), this.m_clrValue, this.m_clrDefault);
        } else if (DEBUG) {
            CDebugLog.ASSERT(CAttr.class.getName(), CDebugLog.GetLineNumber(), "Cannot save CAttr due to an invalid ArchiveKey!");
        }
    }

    @Override
    public void Load(IArchive rArchive) {
        if (CColorAttr.IsValid(this.GetArchiveKey()) && rArchive != null) {
            this.m_clrValue = rArchive.GetValueColor(this.GetArchiveKey(), this.m_clrDefault);
        } else if (DEBUG) {
            CDebugLog.ASSERT(CAttr.class.getName(), CDebugLog.GetLineNumber(), "Cannot load CAttr due to an invalid ArchiveKey!");
        }
    }

    @Override
    public String toString() {
        StringBuilder sRet = new StringBuilder(super.toString());
        sRet.append(String.format("Value: %s\r\n", this.GetValue() == null ? "null" : this.GetValue().toString()));
        sRet.append(String.format("Default: %s\r\n", this.GetDefault() == null ? "null" : this.GetDefault().toString()));
        return sRet.toString();
    }
}

