/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.attrs;

import com.rhinosoft.archive.IArchive;
import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.log.CDebugLog;

public class CBoolAttr
extends CAttr {
    private boolean m_bDefault;
    private boolean m_bValue;

    public CBoolAttr(boolean bValue, boolean bDefault) {
        this._CBoolAttr(bValue, bDefault);
    }

    public CBoolAttr(boolean bValue, boolean bDefault, String sArchiveKey) {
        super(sArchiveKey);
        this._CBoolAttr(bValue, bDefault);
    }

    private void _CBoolAttr(boolean bValue, boolean bDefault) {
        this.m_bValue = bValue;
        this.m_bDefault = bDefault;
    }

    public boolean GetDefault() {
        return this.m_bDefault;
    }

    public void SetDefault(boolean bVal) {
        this.m_bDefault = bVal;
    }

    public boolean GetValue() {
        return this.m_bValue;
    }

    public void SetValue(boolean bVal) {
        this.m_bValue = bVal;
    }

    @Override
    public void Save(IArchive rArchive) {
        if (CBoolAttr.IsValid(this.GetArchiveKey()) && rArchive != null) {
            rArchive.SetValue(this.GetArchiveKey(), this.m_bValue, this.m_bDefault);
        } else if (DEBUG) {
            CDebugLog.ASSERT(CAttr.class.getName(), CDebugLog.GetLineNumber(), "Cannot save CAttr due to an invalid ArchiveKey!");
        }
    }

    @Override
    public void Load(IArchive rArchive) {
        if (CBoolAttr.IsValid(this.GetArchiveKey()) && rArchive != null) {
            this.m_bValue = rArchive.GetValueBool(this.GetArchiveKey(), this.m_bDefault);
        } else if (DEBUG) {
            CDebugLog.ASSERT(CAttr.class.getName(), CDebugLog.GetLineNumber(), "Cannot load CAttr due to an invalid ArchiveKey!");
        }
    }

    @Override
    public String toString() {
        StringBuilder sRet = new StringBuilder(super.toString());
        sRet.append(String.format("Value: %s\r\n", Boolean.toString(this.GetValue())));
        sRet.append(String.format("Default: %s\r\n", Boolean.toString(this.GetDefault())));
        return sRet.toString();
    }

    public static boolean ConvertToBool(Object rValue) {
        boolean bVal = false;
        try {
            if (rValue instanceof Boolean) {
                bVal = (Boolean)rValue;
            } else if (rValue instanceof String) {
                bVal = Boolean.parseBoolean((String)rValue);
            } else if (rValue instanceof Integer && (Integer)rValue != 0) {
                bVal = true;
            }
        }
        catch (Exception e) {
            CDebugLog.EXCEPTION(CBoolAttr.class.getName(), CDebugLog.GetLineNumber(), String.format("EXCEPTION:  failed to convert object to int (%s)", e.getMessage()), false);
        }
        return bVal;
    }

    public static boolean IsTrue(String sVal) {
        String sLower;
        boolean bIsTrue = false;
        if (!(sVal == null || sVal.isEmpty() || (sLower = sVal.toLowerCase()).equals("0") || sLower.equals("false") || sLower.equals("null"))) {
            bIsTrue = true;
        }
        return bIsTrue;
    }
}

