/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.attrs;

import com.rhinosoft.archive.CRhinoArchive;
import com.rhinosoft.archive.IArchive;
import com.rhinosoft.archive.IArchiveObj;
import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.CAttrsOptionsDlg;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class CAttrs
extends CAttr
implements IArchiveObj {
    private static boolean DEBUG_LOAD_SAVE_ATTRS;
    private CAttrsOptionsDlg m_AttrOptionsDlg;
    private HashMap<Long, CAttr> m_aAttrs;
    private CRhinoArchive m_Archive;

    public CAttrs() {
        this._CAttrs(false);
    }

    public CAttrs(boolean bCreateArchive) {
        this._CAttrs(bCreateArchive);
    }

    public CAttrs(String sArchiveKey) {
        super(sArchiveKey);
        this._CAttrs(false);
    }

    public CAttrs(long lUniqueID) {
        super(lUniqueID);
        this._CAttrs(false);
    }

    public CAttrs(long lUniqueID, boolean bCreateArchive) {
        super(lUniqueID);
        this._CAttrs(bCreateArchive);
    }

    public CAttrs(long lUniqueID, String sArchiveKey) {
        super(lUniqueID, sArchiveKey);
        this._CAttrs(false);
    }

    private void _CAttrs(boolean bCreateArchive) {
        this.m_aAttrs = new HashMap();
        if (bCreateArchive) {
            this.SetArchive(this.CreateArchive());
        }
    }

    @Override
    public void Destroy() {
        this.m_AttrOptionsDlg = null;
        if (this.m_aAttrs != null) {
            Set<Long> aKeys = this.m_aAttrs.keySet();
            Iterator<Long> itr = aKeys.iterator();
            while (itr.hasNext()) {
                CAttr rAttr = this.m_aAttrs.get(itr.next());
                if (rAttr == null) continue;
                rAttr.Destroy();
            }
            this.m_aAttrs.clear();
        }
        this.m_aAttrs = null;
        if (this.m_Archive != null) {
            this.m_Archive = null;
        }
        super.Destroy();
    }

    protected void SetOptionsDlg(CAttrsOptionsDlg rDlg) {
        this.m_AttrOptionsDlg = rDlg;
    }

    protected CAttrsOptionsDlg GetOptionsDlg() {
        return this.m_AttrOptionsDlg;
    }

    public void ShowOptionsDlg() {
        if (this.GetOptionsDlg() != null) {
            this.GetOptionsDlg().setVisible(true);
        }
    }

    public boolean AddAttr(CAttr rAttr) {
        boolean bAdded = false;
        if (rAttr != null) {
            this.m_aAttrs.put(rAttr.GetUniqueID(), rAttr);
            bAdded = true;
        }
        return bAdded;
    }

    public CAttr GetAttr(long lUniqueID) {
        return this.m_aAttrs.get(lUniqueID);
    }

    public CAttr RemoveAttr(long lUniqueID) {
        CAttr rRemovedAttr = this.m_aAttrs.remove(lUniqueID);
        return rRemovedAttr;
    }

    public CAttr RemoveAttr(CAttr rAttr) {
        return this.RemoveAttr(rAttr.GetUniqueID());
    }

    @Override
    public void Save(IArchive rArchive) {
        if (DEBUG) {
            CDebugLog.INFO("Implementation detail, we do nothing here.  B/c CAttrs is supposed to contain multiple CAttr objs.");
        }
    }

    @Override
    public void Load(IArchive rArchive) {
        if (DEBUG) {
            CDebugLog.INFO("Implementation detail, we do nothing here.  B/c CAttrs is supposed to contain multiple CAttr objs.");
        }
    }

    protected CRhinoArchive CreateArchive() {
        return null;
    }

    protected CRhinoArchive GetArchive() {
        return this.m_Archive;
    }

    public void SetArchive(CRhinoArchive rArchive) {
        this.m_Archive = rArchive;
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        super.OnMessage(rMsg);
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 4004: {
                    this.OnLoadAttrs();
                    break;
                }
                case 4005: {
                    this.OnSaveAttrs();
                    break;
                }
            }
        }
    }

    @Override
    public void OnLoadAttrs() {
        if (DEBUG_LOAD_SAVE_ATTRS) {
            CDebugLog.INFO("Override if you need to load attrs within this attr collection.");
        }
    }

    @Override
    public void OnSaveAttrs() {
        if (DEBUG_LOAD_SAVE_ATTRS) {
            CDebugLog.INFO("Override if you need to save attrs within this attr collection.");
        }
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_LOAD_SAVE_ATTRS = false;
    }
}

