/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.attrs;

import com.rhinosoft.archive.IArchive;
import com.rhinosoft.attrs.CAttrs;
import com.rhinosoft.attrs.CBoolAttr;
import com.rhinosoft.attrs.CFilePathAttr;
import com.rhinosoft.attrs.CLongAttr;
import com.rhinosoft.attrs.CStringAttr;
import com.rhinosoft.attrs.CStringEncryptedAttr;
import com.rhinosoft.attrs.IRhinoDestroy;
import com.rhinosoft.attrs.IRhinoNewMessage;
import com.rhinosoft.attrs.IRhinoOnMessage;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.utils.CSpeedTest;
import java.util.HashMap;
import javax.swing.SwingUtilities;

public abstract class CAttr
implements IRhinoNewMessage,
IRhinoOnMessage,
IRhinoDestroy {
    public static final String STARTUP_PARAM_DEBUG = "-debug";
    public static boolean DEBUG = false;
    public static final String STARTUP_PARAM_FUTURE_FEATURES = "-FutureFeatures";
    public static boolean FUTURE_FEATURES = false;
    private static long UNIQUE_ATTR_ID_INVALID = Long.MIN_VALUE;
    private static long UNIQUE_ATTR_ID_MAX = Long.MAX_VALUE;
    private static long UNIQUE_ATTR_ID_ATTRS = 0L;
    private static long UNIQUE_ATTR_ID_START = UNIQUE_ATTR_ID_ATTRS + 10L;
    protected static long ABSOLUTE_MIN_VAL = Long.MIN_VALUE;
    protected static long ABSOLUTE_MAX_VAL = Long.MAX_VALUE;
    private static boolean m_bRolledIDs = false;
    private static long m_lNextAttrID = UNIQUE_ATTR_ID_START - 1L;
    private static final Object m_gCrit = new Object();
    private static HashMap<Long, CAttr> m_gLookup = new HashMap();
    private long m_lUniqueID;
    private long m_lMin;
    private long m_lMax;
    private String m_sArchiveKey;
    private CSpeedTest m_SpeedTest;

    public static void main(String[] asArguments) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CAttr rAttr = null;
                rAttr = new CAttrs(1L);
                rAttr = new CBoolAttr(false, false);
                rAttr = new CBoolAttr(true, false);
                rAttr = new CBoolAttr(false, true);
                rAttr = new CLongAttr(7L, 5L, 0L, 10L);
                rAttr = new CStringAttr("Brdiget", "Bridgette", 0L, 10L);
                rAttr = new CStringEncryptedAttr("Jane", "J@ne", 0L, 10L);
                rAttr = new CFilePathAttr("/D:/Temp", "/D:/Temp");
            }
        });
    }

    public CAttr() {
        this._CAttr(UNIQUE_ATTR_ID_INVALID, null, ABSOLUTE_MIN_VAL, ABSOLUTE_MAX_VAL);
    }

    public CAttr(String sArchiveKey) {
        this._CAttr(UNIQUE_ATTR_ID_INVALID, sArchiveKey, ABSOLUTE_MIN_VAL, ABSOLUTE_MAX_VAL);
    }

    public CAttr(long lMin, long lMax) {
        this._CAttr(UNIQUE_ATTR_ID_INVALID, null, lMin, lMax);
    }

    public CAttr(long lMin, long lMax, String sArchiveKey) {
        this._CAttr(UNIQUE_ATTR_ID_INVALID, sArchiveKey, lMin, lMax);
    }

    protected CAttr(long lUniqueID) {
        this._CAttr(lUniqueID, null, ABSOLUTE_MIN_VAL, ABSOLUTE_MAX_VAL);
    }

    protected CAttr(long lUniqueID, String sArchiveKey) {
        this._CAttr(lUniqueID, sArchiveKey, ABSOLUTE_MIN_VAL, ABSOLUTE_MAX_VAL);
    }

    private void _CAttr(long lUniqueID, String sArchiveKey, long lMin, long lMax) {
        this.m_lUniqueID = lUniqueID == UNIQUE_ATTR_ID_INVALID ? this.GetNextAttrID() : lUniqueID;
        this.m_sArchiveKey = sArchiveKey;
        this.m_lMin = lMin;
        this.m_lMax = lMax;
        CAttr.AddGlobalAttr(this);
        this.m_SpeedTest = new CSpeedTest();
    }

    @Override
    public void Destroy() {
        this.m_SpeedTest = null;
        CAttr.RemoveGlobalAttr(this);
    }

    private static int GetStartupKeyIndex(String[] asArguments, String sKey) {
        int nFoundIndex = -1;
        if (asArguments != null && asArguments.length > 0 && sKey != null && !sKey.isEmpty()) {
            for (int nIdx = 0; nIdx < asArguments.length && nFoundIndex == -1; ++nIdx) {
                String sNextArg = asArguments[nIdx];
                if (sNextArg == null || sNextArg.isEmpty() || !sNextArg.startsWith(sKey)) continue;
                nFoundIndex = nIdx;
            }
        }
        return nFoundIndex;
    }

    public static String GetStartupArgument(String[] asArguments, String sKey) {
        int nFoundIdx;
        String sFoundArgument = "";
        if (asArguments != null && (nFoundIdx = CAttr.GetStartupKeyIndex(asArguments, sKey)) > -1 && nFoundIdx < asArguments.length) {
            sFoundArgument = asArguments[nFoundIdx];
        }
        return sFoundArgument;
    }

    public static void InitDebugFlag(String[] asArguments) {
        String sArgument = CAttr.GetStartupArgument(asArguments, STARTUP_PARAM_DEBUG);
        if (sArgument != null && !sArgument.isEmpty()) {
            String[] asSplit = sArgument.split(",");
            if (asSplit != null && asSplit.length == 2) {
                if (CBoolAttr.IsTrue(asSplit[1])) {
                    DEBUG = true;
                }
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  invalid startup argument");
            }
        }
    }

    public static void InitFutureFeatureFlag(String[] asArguments) {
        String sArgument = CAttr.GetStartupArgument(asArguments, STARTUP_PARAM_FUTURE_FEATURES);
        if (sArgument != null && !sArgument.isEmpty()) {
            String[] asSplit = sArgument.split(",");
            if (asSplit != null && asSplit.length == 2) {
                if (CBoolAttr.IsTrue(asSplit[1])) {
                    FUTURE_FEATURES = true;
                }
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  invalid startup argument");
            }
            if (CRhinoApp.GET_RHINO_APP() != null) {
                CRhinoApp.GET_RHINO_APP().InitVersionNumbers();
            }
        }
    }

    public long GetUniqueID() {
        return this.m_lUniqueID;
    }

    protected void SetUniqueID(long lVal) {
        this.m_lUniqueID = lVal;
    }

    public long GetMin() {
        return this.m_lMin;
    }

    public void SetMin(long lVal) {
        this.m_lMin = lVal;
    }

    public long GetMax() {
        return this.m_lMax;
    }

    public void SetMax(long lVal) {
        this.m_lMax = lVal;
    }

    public static boolean IsValid(String sTest) {
        return sTest != null && !sTest.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long GetNextAttrID() {
        Object object = m_gCrit;
        synchronized (object) {
            boolean bOutOfBounds;
            boolean bl = bOutOfBounds = m_lNextAttrID + 1L >= UNIQUE_ATTR_ID_MAX;
            if (m_bRolledIDs || bOutOfBounds) {
                if (!m_bRolledIDs && DEBUG) {
                    System.out.println("CAttr.GetNextAttrID has run out of unique IDs; will return next available from now on.");
                }
                if (bOutOfBounds) {
                    m_bRolledIDs = true;
                }
                long lUnusedAttrID = m_lNextAttrID;
                CAttr rObj = null;
                do {
                    if (++lUnusedAttrID < UNIQUE_ATTR_ID_MAX) continue;
                    lUnusedAttrID = UNIQUE_ATTR_ID_START;
                } while ((rObj = m_gLookup.get(lUnusedAttrID)) != null);
                m_lNextAttrID = lUnusedAttrID;
            } else {
                ++m_lNextAttrID;
            }
        }
        return m_lNextAttrID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean AddGlobalAttr(CAttr rAttr) {
        boolean bAdded = false;
        if (rAttr != null) {
            Object object = m_gCrit;
            synchronized (object) {
                m_gLookup.put(rAttr.GetUniqueID(), rAttr);
            }
            bAdded = true;
        }
        return bAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CAttr FindGlobalAttr(long lUniqueID) {
        CAttr rAttr = null;
        Object object = m_gCrit;
        synchronized (object) {
            rAttr = m_gLookup.get(lUniqueID);
        }
        return rAttr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CAttr RemoveGlobalAttr(long lUniqueID) {
        CAttr rRemovedAttr = null;
        Object object = m_gCrit;
        synchronized (object) {
            rRemovedAttr = m_gLookup.remove(lUniqueID);
        }
        return rRemovedAttr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DestroyGlobalAttrMap() {
        Object object = m_gCrit;
        synchronized (object) {
            m_gLookup = null;
        }
    }

    public static CAttr RemoveGlobalAttr(CAttr rAttr) {
        return CAttr.RemoveGlobalAttr(rAttr.GetUniqueID());
    }

    @Override
    public void NewMessage(CAttrMsg rMsg) {
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
    }

    public String GetArchiveKey() {
        return this.m_sArchiveKey;
    }

    protected void SetArchiveKey(String sArchiveKey) {
        this.m_sArchiveKey = sArchiveKey;
    }

    public abstract void Save(IArchive var1);

    public abstract void Load(IArchive var1);

    public String toString() {
        StringBuilder sRet = new StringBuilder();
        sRet.append(String.format("UID: %s\r\n", this.GetUniqueID()));
        sRet.append(String.format("ArchiveKey: %s\r\n", this.GetArchiveKey()));
        return sRet.toString();
    }

    protected void StartSpeedTest() {
        this.m_SpeedTest.Start();
    }

    protected void StopSpeedTest(String sMsg) {
        this.m_SpeedTest.Stop();
        this.m_SpeedTest.PrintResults(sMsg);
    }
}

