/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.archive;

import com.rhinosoft.archive.IArchive;
import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.strings.CString;
import com.rhinosoft.ui.CRhinoApp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.IllegalFormatException;
import java.util.Properties;
import java.util.Set;

public class CRhinoArchive
extends Properties
implements IArchive {
    protected static final boolean DEBUG = CAttr.DEBUG;
    protected static final String DELIMITER_KEY_VALUE_PAIR = "=";
    protected static final String DELIMITER_COLOR = ",";
    protected static final String DELIMITER_DIMENSION = ",";
    protected static final String DELIMITER_POINT = ",";
    protected static final String DELIMITER_ARRAYS = ",";
    private String m_sAbsFile;

    protected CRhinoArchive() {
        this._CRhinoArchive(null);
    }

    public CRhinoArchive(String sAbsFileName) {
        this._CRhinoArchive(sAbsFileName);
    }

    public CRhinoArchive(CRhinoArchive rCopyFrom) {
        if (rCopyFrom != null) {
            this.m_sAbsFile = rCopyFrom.m_sAbsFile;
        }
        this.CopyMap(rCopyFrom, this);
    }

    private void _CRhinoArchive(String sAbsFileName) {
        this.m_sAbsFile = sAbsFileName;
        this.Load();
    }

    protected void CopyMap(Properties rFrom, Properties rTo) {
        if (rFrom != null && rTo != null) {
            Set<Object> rKeySet = rFrom.keySet();
            for (Object objKey : rKeySet) {
                if (objKey == null) continue;
                Object objVal = rFrom.get(objKey);
                if (!(objKey instanceof String) || !(objVal instanceof String)) continue;
                rTo.setProperty(new String((String)objKey), new String((String)objVal));
            }
        }
    }

    protected String GetFilePath() {
        return this.m_sAbsFile;
    }

    protected boolean Load() {
        boolean bLoaded = true;
        if (this.GetFilePath() != null) {
            String sFilePath = this.GetFilePath().trim();
            if (!sFilePath.isEmpty()) {
                File fFile = new File(sFilePath);
                if (fFile.exists()) {
                    FileInputStream fInputStream;
                    block13: {
                        fInputStream = null;
                        try {
                            fInputStream = new FileInputStream(fFile);
                        }
                        catch (FileNotFoundException ioe) {
                            if (!DEBUG) break block13;
                            ioe.printStackTrace();
                        }
                    }
                    if (fInputStream != null) {
                        block14: {
                            try {
                                this.load(fInputStream);
                            }
                            catch (IOException ioe) {
                                if (!DEBUG) break block14;
                                ioe.printStackTrace();
                            }
                        }
                        try {
                            fInputStream.close();
                        }
                        catch (IOException ioe) {
                            if (DEBUG) {
                                ioe.printStackTrace();
                            }
                        }
                    }
                }
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoArchive.class.getName(), CDebugLog.GetLineNumber(), "Programming error, sFilePath is empty\tCRhinoProperties.Load\tFailed to load the UserProperties file.");
            }
        }
        return bLoaded;
    }

    protected boolean Save() {
        boolean bSaved = true;
        if (this.GetFilePath() != null) {
            String sFilePath = this.GetFilePath().trim();
            if (!sFilePath.isEmpty()) {
                File fFile = new File(sFilePath);
                if (!fFile.exists()) {
                    this.CreateFile();
                }
                if (fFile.exists()) {
                    FileOutputStream fOutputStream;
                    block17: {
                        fOutputStream = null;
                        try {
                            fOutputStream = new FileOutputStream(fFile);
                        }
                        catch (FileNotFoundException fnfe) {
                            bSaved = false;
                            if (!DEBUG) break block17;
                            System.out.println("EXCEPTION:  CRhinoProperties.Save failed to create the user properties file.");
                            fnfe.printStackTrace();
                        }
                    }
                    if (fOutputStream != null) {
                        block18: {
                            try {
                                String sDesc = "--- Property File ---";
                                if (CRhinoApp.GET_RHINO_APP() != null) {
                                    sDesc = String.format("--- %s Property File ---", CRhinoApp.GET_RHINO_APP().GetAppName());
                                }
                                this.store(fOutputStream, sDesc);
                            }
                            catch (IOException ioe) {
                                if (!DEBUG) break block18;
                                ioe.printStackTrace();
                            }
                        }
                        try {
                            fOutputStream.close();
                        }
                        catch (IOException ioe) {
                            if (DEBUG) {
                                ioe.printStackTrace();
                            }
                        }
                    }
                }
            } else if (DEBUG) {
                System.out.println("ASSERT:  Programming error, sFilePath is empty\tCRhinoProperties.Save\tFailed to save the UserProperties file.");
            }
        } else if (DEBUG) {
            System.out.println("ASSERT:  Programming error, GetFilePath() = null\tCRhinoProperties.Save\tFailed to save the UserProperties file.");
        }
        return bSaved;
    }

    private File CreateFile() {
        File fFile;
        block4: {
            fFile = null;
            String sAbsDir = CString.GetFilePath(this.GetFilePath(), false);
            File fDir = new File(sAbsDir);
            if (!fDir.exists()) {
                fDir.mkdirs();
            }
            if (fDir.exists()) {
                fFile = new File(this.GetFilePath());
                try {
                    fFile.createNewFile();
                }
                catch (IOException ioe) {
                    if (!DEBUG) break block4;
                    System.out.println("EXCEPTION:  Could not create new file.");
                    ioe.printStackTrace();
                }
            }
        }
        return fFile != null && fFile.exists() ? fFile : null;
    }

    public boolean DeleteFile() {
        boolean bDeleted = true;
        File fFile = new File(this.GetFilePath());
        if (fFile != null && fFile.exists()) {
            try {
                bDeleted = fFile.delete();
            }
            catch (Exception e) {
                if (DEBUG) {
                    System.out.println("EXCEPTION:  Could not delete file.");
                    e.printStackTrace();
                }
                fFile.deleteOnExit();
                bDeleted = false;
            }
        }
        return bDeleted;
    }

    protected String toString(boolean bDumpMap) {
        Set<Object> aKeySet;
        StringBuilder sbRet = new StringBuilder("CRhinoProperties\r\n");
        if (bDumpMap && (aKeySet = this.keySet()) != null) {
            for (Object objKey : aKeySet) {
                if (objKey == null || !(objKey instanceof String)) continue;
                String sKey = (String)objKey;
                String sValue = this.getProperty(sKey);
                sbRet.append(String.format("%s, %s\r\n", sKey, sValue));
            }
        }
        return sbRet.toString();
    }

    @Override
    public String GetValue(String sKey, String sDefault) {
        String sVal = null;
        if (sKey != null && !sKey.isEmpty()) {
            sVal = this.getProperty(sKey);
        } else if (DEBUG) {
            CDebugLog.ASSERT(CRhinoArchive.class.getName(), CDebugLog.GetLineNumber(), "sKey cannot be null when trying to load an attr from the archive!");
        }
        if (sVal == null || sVal.isEmpty()) {
            sVal = sDefault;
        }
        return sVal;
    }

    @Override
    public Boolean GetValueBool(String sKey, boolean bDefault) {
        Boolean bTemp;
        Boolean bVal = null;
        String sVal = this.GetValue(sKey, Boolean.toString(bDefault));
        if (sVal != null && (bTemp = Boolean.valueOf(Boolean.parseBoolean(sVal))) != null) {
            bVal = bTemp;
        }
        return bVal;
    }

    @Override
    public Double GetValueDouble(String sKey, double dDefault) {
        Double dTemp;
        Double dVal = null;
        String sVal = this.GetValue(sKey, Double.toString(dDefault));
        if (sVal != null && (dTemp = Double.valueOf(Double.parseDouble(sVal))) != null) {
            dVal = dTemp;
        }
        return dVal;
    }

    @Override
    public Integer GetValueInt(String sKey, int nDefault) {
        Integer nTemp;
        Integer nVal = null;
        String sVal = this.GetValue(sKey, Integer.toString(nDefault));
        if (sVal != null && (nTemp = Integer.valueOf(Integer.parseInt(sVal))) != null) {
            nVal = nTemp;
        }
        return nVal;
    }

    @Override
    public Color GetValueColor(String sKey, Color clrDefault) {
        Color clrVal;
        block3: {
            String[] asTemp;
            clrVal = null;
            String sVal = this.GetValue(sKey, this.Format(clrDefault));
            if (sVal != null && (asTemp = sVal.split(",")) != null && asTemp.length == 3) {
                try {
                    clrVal = new Color(Integer.parseInt(asTemp[0]), Integer.parseInt(asTemp[1]), Integer.parseInt(asTemp[2]));
                }
                catch (NumberFormatException nfe) {
                    clrVal = null;
                    if (!DEBUG) break block3;
                    nfe.printStackTrace();
                }
            }
        }
        return clrVal;
    }

    @Override
    public Dimension GetValueDimension(String sKey, Dimension dimDefault) {
        Dimension dimVal;
        block3: {
            String[] asTemp;
            dimVal = null;
            String sVal = this.GetValue(sKey, this.Format(dimDefault));
            if (sVal != null && (asTemp = sVal.split(",")) != null && asTemp.length == 2) {
                try {
                    dimVal = new Dimension(Integer.parseInt(asTemp[0]), Integer.parseInt(asTemp[1]));
                }
                catch (NumberFormatException nfe) {
                    dimVal = null;
                    if (!DEBUG) break block3;
                    nfe.printStackTrace();
                }
            }
        }
        return dimVal;
    }

    @Override
    public Point GetValuePoint(String sKey, Point ptDefault) {
        Point ptVal;
        block3: {
            String[] asTemp;
            ptVal = null;
            String sVal = this.GetValue(sKey, this.Format(ptDefault));
            if (sVal != null && (asTemp = sVal.split(",")) != null && asTemp.length == 2) {
                try {
                    ptVal = new Point(Integer.parseInt(asTemp[0]), Integer.parseInt(asTemp[1]));
                }
                catch (NumberFormatException nfe) {
                    ptVal = null;
                    if (!DEBUG) break block3;
                    nfe.printStackTrace();
                }
            }
        }
        return ptVal;
    }

    @Override
    public int[] GetValueInts(String sKey, int[] anDefaults) {
        String[] asTemp;
        int[] anVals = null;
        String sVal = this.GetValue(sKey, this.Format(anDefaults));
        if (sVal != null && (asTemp = sVal.split(",")) != null) {
            anVals = new int[asTemp.length];
            for (int nIdx = 0; nIdx < asTemp.length; ++nIdx) {
                try {
                    anVals[nIdx] = Integer.parseInt(asTemp[nIdx]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    if (!DEBUG) continue;
                    nfe.printStackTrace();
                }
            }
        }
        return anVals;
    }

    @Override
    public boolean SetValue(String sKey, String sNewValue, String sDefault) {
        boolean bDirty = false;
        if (sKey != null && !sKey.isEmpty()) {
            if (sNewValue != null && !sNewValue.isEmpty()) {
                boolean bUpdate = true;
                String sCurVal = this.GetValue(sKey, sDefault);
                if (sCurVal != null && !sCurVal.isEmpty() && sCurVal.equals(sNewValue)) {
                    bUpdate = false;
                }
                if (bUpdate) {
                    bDirty = true;
                    this.setProperty(sKey, sNewValue);
                    this.Save();
                }
            } else if (sDefault != null) {
                this.setProperty(sKey, sDefault);
                this.Save();
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoArchive.class.getName(), CDebugLog.GetLineNumber(), "Programming error, sDefault = null");
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CRhinoArchive.class.getName(), CDebugLog.GetLineNumber(), "Programming error, sKey = null");
        }
        return bDirty;
    }

    @Override
    public boolean SetValue(String sKey, boolean bNewValue, boolean bDefault) {
        boolean bDirty = false;
        Boolean bCurVal = this.GetValueBool(sKey, bDefault);
        if (bCurVal != null) {
            if (bCurVal != bNewValue) {
                bDirty = true;
                this.SetValue(sKey, Boolean.toString(bNewValue), Boolean.toString(bDefault));
            }
        } else {
            this.SetValue(sKey, Boolean.toString(bNewValue), Boolean.toString(bDefault));
        }
        return bDirty;
    }

    @Override
    public boolean SetValue(String sKey, int nNewValue, int nDefault) {
        boolean bDirty = false;
        Integer nCurVal = this.GetValueInt(sKey, nDefault);
        if (nCurVal != null) {
            if (nCurVal != nNewValue) {
                bDirty = true;
                this.SetValue(sKey, Integer.toString(nNewValue), Integer.toString(nDefault));
            }
        } else {
            this.SetValue(sKey, Integer.toString(nNewValue), Integer.toString(nDefault));
        }
        return bDirty;
    }

    @Override
    public boolean SetValue(String sKey, double dNewValue, double dDefault) {
        boolean bDirty = false;
        Double dCurVal = this.GetValueDouble(sKey, dDefault);
        if (dCurVal != null) {
            if (dCurVal != dNewValue) {
                bDirty = true;
                this.SetValue(sKey, Double.toString(dNewValue), Double.toString(dDefault));
            }
        } else {
            this.SetValue(sKey, Double.toString(dNewValue), Double.toString(dDefault));
        }
        return bDirty;
    }

    @Override
    public boolean SetValue(String sKey, Color clrNewValue, Color clrDefault) {
        boolean bDirty = false;
        if (clrNewValue != null) {
            Color clrCurVal = this.GetValueColor(sKey, clrDefault);
            if (clrCurVal != null) {
                if (clrCurVal.getRed() != clrNewValue.getRed() || clrCurVal.getGreen() != clrNewValue.getGreen() || clrCurVal.getBlue() != clrNewValue.getBlue()) {
                    bDirty = true;
                    this.SetValue(sKey, this.Format(clrNewValue), this.Format(clrDefault));
                }
            } else {
                this.SetValue(sKey, this.Format(clrNewValue), this.Format(clrDefault));
            }
        } else if (clrDefault != null) {
            this.SetValue(sKey, null, this.Format(clrDefault));
        } else if (DEBUG) {
            System.out.println("ASSERT:  Programming error, clrDefault = null\r\nCRhinoProperties.SetValue(Color)");
        }
        return bDirty;
    }

    @Override
    public boolean SetValue(String sKey, Dimension dimNewValue, Dimension dimDefault) {
        boolean bDirty = false;
        if (dimNewValue != null) {
            Dimension dimCurVal = this.GetValueDimension(sKey, dimDefault);
            if (dimCurVal != null) {
                if (dimCurVal.getWidth() != dimNewValue.getWidth() || dimCurVal.getHeight() != dimNewValue.getHeight()) {
                    bDirty = true;
                    this.SetValue(sKey, this.Format(dimNewValue), this.Format(dimDefault));
                }
            } else {
                this.SetValue(sKey, this.Format(dimNewValue), this.Format(dimDefault));
            }
        } else if (dimDefault != null) {
            this.SetValue(sKey, null, this.Format(dimDefault));
        } else if (DEBUG) {
            System.out.println("ASSERT:  Programming error, clrDefault = null\r\nCRhinoProperties.SetValue(Color)");
        }
        return bDirty;
    }

    @Override
    public boolean SetValue(String sKey, Point ptNewValue, Point ptDefault) {
        boolean bDirty = false;
        if (ptNewValue != null) {
            Point ptCurVal = this.GetValuePoint(sKey, ptDefault);
            if (ptCurVal != null) {
                if (ptCurVal.getX() != ptNewValue.getX() || ptCurVal.getY() != ptNewValue.getY()) {
                    bDirty = true;
                    this.SetValue(sKey, this.Format(ptNewValue), this.Format(ptDefault));
                }
            } else {
                this.SetValue(sKey, this.Format(ptNewValue), this.Format(ptDefault));
            }
        } else if (ptDefault != null) {
            this.SetValue(sKey, null, this.Format(ptDefault));
        } else if (DEBUG) {
            System.out.println("ASSERT:  Programming error, clrDefault = null\r\nCRhinoProperties.SetValue(Color)");
        }
        return bDirty;
    }

    @Override
    public boolean SetValue(String sKey, int[] anNewValues, int[] anDefaults) {
        boolean bDirty = false;
        if (anNewValues != null) {
            bDirty = true;
            this.SetValue(sKey, this.Format(anNewValues), this.Format(anDefaults));
        } else if (anDefaults != null) {
            this.SetValue(sKey, null, this.Format(anDefaults));
        } else if (DEBUG) {
            System.out.println("ASSERT:  Programming error, clrDefault = null\r\nCRhinoProperties.SetValue(Color)");
        }
        return bDirty;
    }

    protected String Format(Color clr) {
        String sRet;
        block3: {
            sRet = "";
            if (clr != null) {
                try {
                    sRet = String.format("%d%s%d%s%d", clr.getRed(), ",", clr.getGreen(), ",", clr.getBlue());
                }
                catch (IllegalFormatException ife) {
                    if (!DEBUG) break block3;
                    ife.printStackTrace();
                }
            }
        }
        return sRet;
    }

    protected String Format(Dimension dim) {
        String sRet;
        block3: {
            sRet = "";
            if (dim != null) {
                try {
                    sRet = String.format("%d%s%d", dim.width, ",", dim.height);
                }
                catch (IllegalFormatException ife) {
                    if (!DEBUG) break block3;
                    ife.printStackTrace();
                }
            }
        }
        return sRet;
    }

    protected String Format(Point pt) {
        String sRet;
        block3: {
            sRet = "";
            if (pt != null) {
                try {
                    sRet = String.format("%d%s%d", pt.x, ",", pt.y);
                }
                catch (IllegalFormatException ife) {
                    if (!DEBUG) break block3;
                    ife.printStackTrace();
                }
            }
        }
        return sRet;
    }

    protected String Format(int[] anItems) {
        StringBuilder sRet = new StringBuilder();
        if (anItems != null) {
            for (int nIdx = 0; nIdx < anItems.length; ++nIdx) {
                sRet.append(anItems[nIdx]);
                if (nIdx + 1 >= anItems.length) continue;
                sRet.append(",");
            }
        }
        return sRet.toString();
    }

    public static String GetDefaultDatePattern() {
        String sPattern = "M/d/yy h:mm a";
        SimpleDateFormat Formatter = new SimpleDateFormat();
        sPattern = Formatter.toPattern();
        Formatter = null;
        return sPattern;
    }

    @Override
    public boolean RemoveKey(String sKey) {
        Object objRemoved;
        boolean bRemoved = false;
        if (sKey != null && !sKey.isEmpty() && (objRemoved = this.remove(sKey)) != null) {
            bRemoved = true;
            this.Save();
        }
        return bRemoved;
    }

    @Override
    public Date GetValueDate(String sKey, Date dtDefault) {
        Long lVal;
        Date dtVal = null;
        if (dtDefault != null && (lVal = this.GetValueLong(sKey, dtDefault.getTime())) != null) {
            dtVal = new Date(lVal);
        }
        return dtVal;
    }

    @Override
    public Long GetValueLong(String sKey, long lDefault) {
        Long lTemp;
        Long lVal = null;
        String sVal = this.GetValue(sKey, Long.toString(lDefault));
        if (sVal != null && (lTemp = Long.valueOf(Long.parseLong(sVal))) != null) {
            lVal = lTemp;
        }
        return lVal;
    }

    @Override
    public boolean SetValue(String sKey, long lNewValue, long lDefault) {
        boolean bDirty = false;
        Long lCurVal = this.GetValueLong(sKey, lDefault);
        if (lCurVal != null) {
            if (lCurVal != lNewValue) {
                bDirty = true;
                this.SetValue(sKey, Long.toString(lNewValue), Long.toString(lDefault));
            }
        } else {
            this.SetValue(sKey, Long.toString(lNewValue), Long.toString(lDefault));
        }
        return bDirty;
    }

    @Override
    public boolean SetValue(String sKey, Date dtNewValue, Date dtDefault) {
        boolean bDirty = false;
        if (dtNewValue != null && dtDefault != null) {
            bDirty = this.SetValue(sKey, dtNewValue.getTime(), dtDefault.getTime());
        }
        return bDirty;
    }
}

