// SCUM (0.1.17) SDK

#ifdef _MSC_VER
	#pragma pack(push, 0x8)
#endif

#include "SCUM_Engine_classes.hpp"

namespace SDK
{
//---------------------------------------------------------------------------
//Functions
//---------------------------------------------------------------------------

// Function Engine.Actor.WasRecentlyRendered
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          Tolerance                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AActor::WasRecentlyRendered(float Tolerance)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.WasRecentlyRendered");

	struct
	{
		float                          Tolerance;
		bool                           ReturnValue;
	} params;

	params.Tolerance = Tolerance;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.UserConstructionScript
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)

void AActor::UserConstructionScript()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.UserConstructionScript");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.TearOff
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AActor::TearOff()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.TearOff");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.SnapRootComponentTo
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class AActor*                  InParentActor                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   InSocketName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::SnapRootComponentTo(class AActor* InParentActor, const struct FName& InSocketName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.SnapRootComponentTo");

	struct
	{
		class AActor*                  InParentActor;
		struct FName                   InSocketName;
	} params;

	params.InParentActor = InParentActor;
	params.InSocketName = InSocketName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.SetTickGroup
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// TEnumAsByte<ETickingGroup>     NewTickGroup                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::SetTickGroup(TEnumAsByte<ETickingGroup> NewTickGroup)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.SetTickGroup");

	struct
	{
		TEnumAsByte<ETickingGroup>     NewTickGroup;
	} params;

	params.NewTickGroup = NewTickGroup;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.SetTickableWhenPaused
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bTickableWhenPaused            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::SetTickableWhenPaused(bool bTickableWhenPaused)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.SetTickableWhenPaused");

	struct
	{
		bool                           bTickableWhenPaused;
	} params;

	params.bTickableWhenPaused = bTickableWhenPaused;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.SetReplicates
// (FUNC_Final, FUNC_BlueprintAuthorityOnly, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bInReplicates                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::SetReplicates(bool bInReplicates)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.SetReplicates");

	struct
	{
		bool                           bInReplicates;
	} params;

	params.bInReplicates = bInReplicates;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.SetReplicateMovement
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bInReplicateMovement           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::SetReplicateMovement(bool bInReplicateMovement)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.SetReplicateMovement");

	struct
	{
		bool                           bInReplicateMovement;
	} params;

	params.bInReplicateMovement = bInReplicateMovement;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.SetOwner
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class AActor*                  NewOwner                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::SetOwner(class AActor* NewOwner)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.SetOwner");

	struct
	{
		class AActor*                  NewOwner;
	} params;

	params.NewOwner = NewOwner;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.SetNetDormancy
// (FUNC_Final, FUNC_BlueprintAuthorityOnly, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// TEnumAsByte<ENetDormancy>      NewDormancy                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::SetNetDormancy(TEnumAsByte<ENetDormancy> NewDormancy)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.SetNetDormancy");

	struct
	{
		TEnumAsByte<ENetDormancy>      NewDormancy;
	} params;

	params.NewDormancy = NewDormancy;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.SetLifeSpan
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InLifespan                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::SetLifeSpan(float InLifespan)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.SetLifeSpan");

	struct
	{
		float                          InLifespan;
	} params;

	params.InLifespan = InLifespan;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.SetActorTickInterval
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          TickInterval                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::SetActorTickInterval(float TickInterval)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.SetActorTickInterval");

	struct
	{
		float                          TickInterval;
	} params;

	params.TickInterval = TickInterval;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.SetActorTickEnabled
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bEnabled                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::SetActorTickEnabled(bool bEnabled)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.SetActorTickEnabled");

	struct
	{
		bool                           bEnabled;
	} params;

	params.bEnabled = bEnabled;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.SetActorScale3D
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewScale3D                     (CPF_Parm, CPF_IsPlainOldData)

void AActor::SetActorScale3D(const struct FVector& NewScale3D)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.SetActorScale3D");

	struct
	{
		struct FVector                 NewScale3D;
	} params;

	params.NewScale3D = NewScale3D;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.SetActorRelativeScale3D
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewRelativeScale               (CPF_Parm, CPF_IsPlainOldData)

void AActor::SetActorRelativeScale3D(const struct FVector& NewRelativeScale)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.SetActorRelativeScale3D");

	struct
	{
		struct FVector                 NewRelativeScale;
	} params;

	params.NewRelativeScale = NewRelativeScale;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.SetActorHiddenInGame
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewHidden                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::SetActorHiddenInGame(bool bNewHidden)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.SetActorHiddenInGame");

	struct
	{
		bool                           bNewHidden;
	} params;

	params.bNewHidden = bNewHidden;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.SetActorEnableCollision
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewActorEnableCollision       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::SetActorEnableCollision(bool bNewActorEnableCollision)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.SetActorEnableCollision");

	struct
	{
		bool                           bNewActorEnableCollision;
	} params;

	params.bNewActorEnableCollision = bNewActorEnableCollision;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.RemoveTickPrerequisiteComponent
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UActorComponent*         PrerequisiteComponent          (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)

void AActor::RemoveTickPrerequisiteComponent(class UActorComponent* PrerequisiteComponent)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.RemoveTickPrerequisiteComponent");

	struct
	{
		class UActorComponent*         PrerequisiteComponent;
	} params;

	params.PrerequisiteComponent = PrerequisiteComponent;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.RemoveTickPrerequisiteActor
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class AActor*                  PrerequisiteActor              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::RemoveTickPrerequisiteActor(class AActor* PrerequisiteActor)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.RemoveTickPrerequisiteActor");

	struct
	{
		class AActor*                  PrerequisiteActor;
	} params;

	params.PrerequisiteActor = PrerequisiteActor;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.ReceiveTick
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// float                          DeltaSeconds                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::ReceiveTick(float DeltaSeconds)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ReceiveTick");

	struct
	{
		float                          DeltaSeconds;
	} params;

	params.DeltaSeconds = DeltaSeconds;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.ReceiveRadialDamage
// (FUNC_BlueprintAuthorityOnly, FUNC_Event, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintEvent)
// Parameters:
// float                          DamageReceived                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UDamageType*             DamageType                     (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 Origin                         (CPF_Parm, CPF_IsPlainOldData)
// struct FHitResult              HitInfo                        (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// class AController*             InstigatedBy                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class AActor*                  DamageCauser                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::ReceiveRadialDamage(float DamageReceived, class UDamageType* DamageType, const struct FVector& Origin, const struct FHitResult& HitInfo, class AController* InstigatedBy, class AActor* DamageCauser)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ReceiveRadialDamage");

	struct
	{
		float                          DamageReceived;
		class UDamageType*             DamageType;
		struct FVector                 Origin;
		struct FHitResult              HitInfo;
		class AController*             InstigatedBy;
		class AActor*                  DamageCauser;
	} params;

	params.DamageReceived = DamageReceived;
	params.DamageType = DamageType;
	params.Origin = Origin;
	params.HitInfo = HitInfo;
	params.InstigatedBy = InstigatedBy;
	params.DamageCauser = DamageCauser;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.ReceivePointDamage
// (FUNC_BlueprintAuthorityOnly, FUNC_Event, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintEvent)
// Parameters:
// float                          Damage                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UDamageType*             DamageType                     (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 HitLocation                    (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 HitNormal                      (CPF_Parm, CPF_IsPlainOldData)
// class UPrimitiveComponent*     HitComponent                   (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 ShotFromDirection              (CPF_Parm, CPF_IsPlainOldData)
// class AController*             InstigatedBy                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class AActor*                  DamageCauser                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              HitInfo                        (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)

void AActor::ReceivePointDamage(float Damage, class UDamageType* DamageType, const struct FVector& HitLocation, const struct FVector& HitNormal, class UPrimitiveComponent* HitComponent, const struct FName& BoneName, const struct FVector& ShotFromDirection, class AController* InstigatedBy, class AActor* DamageCauser, const struct FHitResult& HitInfo)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ReceivePointDamage");

	struct
	{
		float                          Damage;
		class UDamageType*             DamageType;
		struct FVector                 HitLocation;
		struct FVector                 HitNormal;
		class UPrimitiveComponent*     HitComponent;
		struct FName                   BoneName;
		struct FVector                 ShotFromDirection;
		class AController*             InstigatedBy;
		class AActor*                  DamageCauser;
		struct FHitResult              HitInfo;
	} params;

	params.Damage = Damage;
	params.DamageType = DamageType;
	params.HitLocation = HitLocation;
	params.HitNormal = HitNormal;
	params.HitComponent = HitComponent;
	params.BoneName = BoneName;
	params.ShotFromDirection = ShotFromDirection;
	params.InstigatedBy = InstigatedBy;
	params.DamageCauser = DamageCauser;
	params.HitInfo = HitInfo;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.ReceiveHit
// (FUNC_Event, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintEvent)
// Parameters:
// class UPrimitiveComponent*     MyComp                         (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// class AActor*                  Other                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UPrimitiveComponent*     OtherComp                      (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// bool                           bSelfMoved                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 HitLocation                    (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 HitNormal                      (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 NormalImpulse                  (CPF_Parm, CPF_IsPlainOldData)
// struct FHitResult              Hit                            (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)

void AActor::ReceiveHit(class UPrimitiveComponent* MyComp, class AActor* Other, class UPrimitiveComponent* OtherComp, bool bSelfMoved, const struct FVector& HitLocation, const struct FVector& HitNormal, const struct FVector& NormalImpulse, const struct FHitResult& Hit)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ReceiveHit");

	struct
	{
		class UPrimitiveComponent*     MyComp;
		class AActor*                  Other;
		class UPrimitiveComponent*     OtherComp;
		bool                           bSelfMoved;
		struct FVector                 HitLocation;
		struct FVector                 HitNormal;
		struct FVector                 NormalImpulse;
		struct FHitResult              Hit;
	} params;

	params.MyComp = MyComp;
	params.Other = Other;
	params.OtherComp = OtherComp;
	params.bSelfMoved = bSelfMoved;
	params.HitLocation = HitLocation;
	params.HitNormal = HitNormal;
	params.NormalImpulse = NormalImpulse;
	params.Hit = Hit;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.ReceiveEndPlay
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// TEnumAsByte<EEndPlayReason>    EndPlayReason                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::ReceiveEndPlay(TEnumAsByte<EEndPlayReason> EndPlayReason)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ReceiveEndPlay");

	struct
	{
		TEnumAsByte<EEndPlayReason>    EndPlayReason;
	} params;

	params.EndPlayReason = EndPlayReason;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.ReceiveDestroyed
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)

void AActor::ReceiveDestroyed()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ReceiveDestroyed");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.ReceiveBeginPlay
// (FUNC_Event, FUNC_Protected, FUNC_BlueprintEvent)

void AActor::ReceiveBeginPlay()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ReceiveBeginPlay");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.ReceiveAnyDamage
// (FUNC_BlueprintAuthorityOnly, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// float                          Damage                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UDamageType*             DamageType                     (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class AController*             InstigatedBy                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class AActor*                  DamageCauser                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::ReceiveAnyDamage(float Damage, class UDamageType* DamageType, class AController* InstigatedBy, class AActor* DamageCauser)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ReceiveAnyDamage");

	struct
	{
		float                          Damage;
		class UDamageType*             DamageType;
		class AController*             InstigatedBy;
		class AActor*                  DamageCauser;
	} params;

	params.Damage = Damage;
	params.DamageType = DamageType;
	params.InstigatedBy = InstigatedBy;
	params.DamageCauser = DamageCauser;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.ReceiveActorOnReleased
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// struct FKey                    ButtonReleased                 (CPF_Parm)

void AActor::ReceiveActorOnReleased(const struct FKey& ButtonReleased)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ReceiveActorOnReleased");

	struct
	{
		struct FKey                    ButtonReleased;
	} params;

	params.ButtonReleased = ButtonReleased;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.ReceiveActorOnInputTouchLeave
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// TEnumAsByte<ETouchIndex>       FingerIndex                    (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::ReceiveActorOnInputTouchLeave(TEnumAsByte<ETouchIndex> FingerIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ReceiveActorOnInputTouchLeave");

	struct
	{
		TEnumAsByte<ETouchIndex>       FingerIndex;
	} params;

	params.FingerIndex = FingerIndex;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.ReceiveActorOnInputTouchEnter
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// TEnumAsByte<ETouchIndex>       FingerIndex                    (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::ReceiveActorOnInputTouchEnter(TEnumAsByte<ETouchIndex> FingerIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ReceiveActorOnInputTouchEnter");

	struct
	{
		TEnumAsByte<ETouchIndex>       FingerIndex;
	} params;

	params.FingerIndex = FingerIndex;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.ReceiveActorOnInputTouchEnd
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// TEnumAsByte<ETouchIndex>       FingerIndex                    (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::ReceiveActorOnInputTouchEnd(TEnumAsByte<ETouchIndex> FingerIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ReceiveActorOnInputTouchEnd");

	struct
	{
		TEnumAsByte<ETouchIndex>       FingerIndex;
	} params;

	params.FingerIndex = FingerIndex;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.ReceiveActorOnInputTouchBegin
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// TEnumAsByte<ETouchIndex>       FingerIndex                    (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::ReceiveActorOnInputTouchBegin(TEnumAsByte<ETouchIndex> FingerIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ReceiveActorOnInputTouchBegin");

	struct
	{
		TEnumAsByte<ETouchIndex>       FingerIndex;
	} params;

	params.FingerIndex = FingerIndex;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.ReceiveActorOnClicked
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// struct FKey                    ButtonPressed                  (CPF_Parm)

void AActor::ReceiveActorOnClicked(const struct FKey& ButtonPressed)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ReceiveActorOnClicked");

	struct
	{
		struct FKey                    ButtonPressed;
	} params;

	params.ButtonPressed = ButtonPressed;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.ReceiveActorEndOverlap
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class AActor*                  OtherActor                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::ReceiveActorEndOverlap(class AActor* OtherActor)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ReceiveActorEndOverlap");

	struct
	{
		class AActor*                  OtherActor;
	} params;

	params.OtherActor = OtherActor;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.ReceiveActorEndCursorOver
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)

void AActor::ReceiveActorEndCursorOver()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ReceiveActorEndCursorOver");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.ReceiveActorBeginOverlap
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class AActor*                  OtherActor                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::ReceiveActorBeginOverlap(class AActor* OtherActor)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ReceiveActorBeginOverlap");

	struct
	{
		class AActor*                  OtherActor;
	} params;

	params.OtherActor = OtherActor;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.ReceiveActorBeginCursorOver
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)

void AActor::ReceiveActorBeginCursorOver()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ReceiveActorBeginCursorOver");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.PrestreamTextures
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Seconds                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bEnableStreaming               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            CinematicTextureGroups         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::PrestreamTextures(float Seconds, bool bEnableStreaming, int CinematicTextureGroups)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.PrestreamTextures");

	struct
	{
		float                          Seconds;
		bool                           bEnableStreaming;
		int                            CinematicTextureGroups;
	} params;

	params.Seconds = Seconds;
	params.bEnableStreaming = bEnableStreaming;
	params.CinematicTextureGroups = CinematicTextureGroups;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.OnRep_ReplicateMovement
// (FUNC_Native, FUNC_Public)

void AActor::OnRep_ReplicateMovement()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.OnRep_ReplicateMovement");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.OnRep_ReplicatedMovement
// (FUNC_Native, FUNC_Public)

void AActor::OnRep_ReplicatedMovement()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.OnRep_ReplicatedMovement");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.OnRep_Owner
// (FUNC_Native, FUNC_Protected)

void AActor::OnRep_Owner()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.OnRep_Owner");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.OnRep_Instigator
// (FUNC_Native, FUNC_Public)

void AActor::OnRep_Instigator()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.OnRep_Instigator");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.OnRep_AttachmentReplication
// (FUNC_Native, FUNC_Public)

void AActor::OnRep_AttachmentReplication()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.OnRep_AttachmentReplication");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.MakeNoise
// (FUNC_Final, FUNC_BlueprintAuthorityOnly, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// float                          Loudness                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class APawn*                   NoiseInstigator                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 NoiseLocation                  (CPF_Parm, CPF_IsPlainOldData)
// float                          MaxRange                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   Tag                            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::MakeNoise(float Loudness, class APawn* NoiseInstigator, const struct FVector& NoiseLocation, float MaxRange, const struct FName& Tag)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.MakeNoise");

	struct
	{
		float                          Loudness;
		class APawn*                   NoiseInstigator;
		struct FVector                 NoiseLocation;
		float                          MaxRange;
		struct FName                   Tag;
	} params;

	params.Loudness = Loudness;
	params.NoiseInstigator = NoiseInstigator;
	params.NoiseLocation = NoiseLocation;
	params.MaxRange = MaxRange;
	params.Tag = Tag;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.MakeMIDForMaterial
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UMaterialInterface*      Parent                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UMaterialInstanceDynamic* ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UMaterialInstanceDynamic* AActor::MakeMIDForMaterial(class UMaterialInterface* Parent)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.MakeMIDForMaterial");

	struct
	{
		class UMaterialInterface*      Parent;
		class UMaterialInstanceDynamic* ReturnValue;
	} params;

	params.Parent = Parent;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.K2_TeleportTo
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 DestLocation                   (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                DestRotation                   (CPF_Parm, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AActor::K2_TeleportTo(const struct FVector& DestLocation, const struct FRotator& DestRotation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_TeleportTo");

	struct
	{
		struct FVector                 DestLocation;
		struct FRotator                DestRotation;
		bool                           ReturnValue;
	} params;

	params.DestLocation = DestLocation;
	params.DestRotation = DestRotation;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.K2_SetActorTransform
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FTransform              NewTransform                   (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AActor::K2_SetActorTransform(const struct FTransform& NewTransform, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_SetActorTransform");

	struct
	{
		struct FTransform              NewTransform;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
		bool                           ReturnValue;
	} params;

	params.NewTransform = NewTransform;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;

	return params.ReturnValue;
}


// Function Engine.Actor.K2_SetActorRotation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FRotator                NewRotation                    (CPF_Parm, CPF_IsPlainOldData)
// bool                           bTeleportPhysics               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AActor::K2_SetActorRotation(const struct FRotator& NewRotation, bool bTeleportPhysics)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_SetActorRotation");

	struct
	{
		struct FRotator                NewRotation;
		bool                           bTeleportPhysics;
		bool                           ReturnValue;
	} params;

	params.NewRotation = NewRotation;
	params.bTeleportPhysics = bTeleportPhysics;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.K2_SetActorRelativeTransform
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FTransform              NewRelativeTransform           (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::K2_SetActorRelativeTransform(const struct FTransform& NewRelativeTransform, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_SetActorRelativeTransform");

	struct
	{
		struct FTransform              NewRelativeTransform;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.NewRelativeTransform = NewRelativeTransform;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.Actor.K2_SetActorRelativeRotation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FRotator                NewRelativeRotation            (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::K2_SetActorRelativeRotation(const struct FRotator& NewRelativeRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_SetActorRelativeRotation");

	struct
	{
		struct FRotator                NewRelativeRotation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.NewRelativeRotation = NewRelativeRotation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.Actor.K2_SetActorRelativeLocation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewRelativeLocation            (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::K2_SetActorRelativeLocation(const struct FVector& NewRelativeLocation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_SetActorRelativeLocation");

	struct
	{
		struct FVector                 NewRelativeLocation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.NewRelativeLocation = NewRelativeLocation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.Actor.K2_SetActorLocationAndRotation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewLocation                    (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                NewRotation                    (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AActor::K2_SetActorLocationAndRotation(const struct FVector& NewLocation, const struct FRotator& NewRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_SetActorLocationAndRotation");

	struct
	{
		struct FVector                 NewLocation;
		struct FRotator                NewRotation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
		bool                           ReturnValue;
	} params;

	params.NewLocation = NewLocation;
	params.NewRotation = NewRotation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;

	return params.ReturnValue;
}


// Function Engine.Actor.K2_SetActorLocation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewLocation                    (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AActor::K2_SetActorLocation(const struct FVector& NewLocation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_SetActorLocation");

	struct
	{
		struct FVector                 NewLocation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
		bool                           ReturnValue;
	} params;

	params.NewLocation = NewLocation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;

	return params.ReturnValue;
}


// Function Engine.Actor.K2_OnReset
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)

void AActor::K2_OnReset()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_OnReset");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.K2_OnEndViewTarget
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class APlayerController*       PC                             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::K2_OnEndViewTarget(class APlayerController* PC)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_OnEndViewTarget");

	struct
	{
		class APlayerController*       PC;
	} params;

	params.PC = PC;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.K2_OnBecomeViewTarget
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class APlayerController*       PC                             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::K2_OnBecomeViewTarget(class APlayerController* PC)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_OnBecomeViewTarget");

	struct
	{
		class APlayerController*       PC;
	} params;

	params.PC = PC;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.K2_GetRootComponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class USceneComponent*         ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_InstancedReference, CPF_IsPlainOldData)

class USceneComponent* AActor::K2_GetRootComponent()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_GetRootComponent");

	struct
	{
		class USceneComponent*         ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.K2_GetActorRotation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FRotator                ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FRotator AActor::K2_GetActorRotation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_GetActorRotation");

	struct
	{
		struct FRotator                ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.K2_GetActorLocation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector AActor::K2_GetActorLocation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_GetActorLocation");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.K2_DetachFromActor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// EDetachmentRule                LocationRule                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// EDetachmentRule                RotationRule                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// EDetachmentRule                ScaleRule                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::K2_DetachFromActor(EDetachmentRule LocationRule, EDetachmentRule RotationRule, EDetachmentRule ScaleRule)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_DetachFromActor");

	struct
	{
		EDetachmentRule                LocationRule;
		EDetachmentRule                RotationRule;
		EDetachmentRule                ScaleRule;
	} params;

	params.LocationRule = LocationRule;
	params.RotationRule = RotationRule;
	params.ScaleRule = ScaleRule;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.K2_DestroyComponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UActorComponent*         Component                      (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)

void AActor::K2_DestroyComponent(class UActorComponent* Component)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_DestroyComponent");

	struct
	{
		class UActorComponent*         Component;
	} params;

	params.Component = Component;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.K2_DestroyActor
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AActor::K2_DestroyActor()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_DestroyActor");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.K2_AttachToComponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class USceneComponent*         Parent                         (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FName                   SocketName                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// EAttachmentRule                LocationRule                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// EAttachmentRule                RotationRule                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// EAttachmentRule                ScaleRule                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bWeldSimulatedBodies           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::K2_AttachToComponent(class USceneComponent* Parent, const struct FName& SocketName, EAttachmentRule LocationRule, EAttachmentRule RotationRule, EAttachmentRule ScaleRule, bool bWeldSimulatedBodies)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_AttachToComponent");

	struct
	{
		class USceneComponent*         Parent;
		struct FName                   SocketName;
		EAttachmentRule                LocationRule;
		EAttachmentRule                RotationRule;
		EAttachmentRule                ScaleRule;
		bool                           bWeldSimulatedBodies;
	} params;

	params.Parent = Parent;
	params.SocketName = SocketName;
	params.LocationRule = LocationRule;
	params.RotationRule = RotationRule;
	params.ScaleRule = ScaleRule;
	params.bWeldSimulatedBodies = bWeldSimulatedBodies;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.K2_AttachToActor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class AActor*                  ParentActor                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   SocketName                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// EAttachmentRule                LocationRule                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// EAttachmentRule                RotationRule                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// EAttachmentRule                ScaleRule                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bWeldSimulatedBodies           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::K2_AttachToActor(class AActor* ParentActor, const struct FName& SocketName, EAttachmentRule LocationRule, EAttachmentRule RotationRule, EAttachmentRule ScaleRule, bool bWeldSimulatedBodies)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_AttachToActor");

	struct
	{
		class AActor*                  ParentActor;
		struct FName                   SocketName;
		EAttachmentRule                LocationRule;
		EAttachmentRule                RotationRule;
		EAttachmentRule                ScaleRule;
		bool                           bWeldSimulatedBodies;
	} params;

	params.ParentActor = ParentActor;
	params.SocketName = SocketName;
	params.LocationRule = LocationRule;
	params.RotationRule = RotationRule;
	params.ScaleRule = ScaleRule;
	params.bWeldSimulatedBodies = bWeldSimulatedBodies;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.K2_AttachRootComponentToActor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class AActor*                  InParentActor                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   InSocketName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TEnumAsByte<EAttachLocation>   AttachLocationType             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bWeldSimulatedBodies           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::K2_AttachRootComponentToActor(class AActor* InParentActor, const struct FName& InSocketName, TEnumAsByte<EAttachLocation> AttachLocationType, bool bWeldSimulatedBodies)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_AttachRootComponentToActor");

	struct
	{
		class AActor*                  InParentActor;
		struct FName                   InSocketName;
		TEnumAsByte<EAttachLocation>   AttachLocationType;
		bool                           bWeldSimulatedBodies;
	} params;

	params.InParentActor = InParentActor;
	params.InSocketName = InSocketName;
	params.AttachLocationType = AttachLocationType;
	params.bWeldSimulatedBodies = bWeldSimulatedBodies;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.K2_AttachRootComponentTo
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class USceneComponent*         InParent                       (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FName                   InSocketName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TEnumAsByte<EAttachLocation>   AttachLocationType             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bWeldSimulatedBodies           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::K2_AttachRootComponentTo(class USceneComponent* InParent, const struct FName& InSocketName, TEnumAsByte<EAttachLocation> AttachLocationType, bool bWeldSimulatedBodies)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_AttachRootComponentTo");

	struct
	{
		class USceneComponent*         InParent;
		struct FName                   InSocketName;
		TEnumAsByte<EAttachLocation>   AttachLocationType;
		bool                           bWeldSimulatedBodies;
	} params;

	params.InParent = InParent;
	params.InSocketName = InSocketName;
	params.AttachLocationType = AttachLocationType;
	params.bWeldSimulatedBodies = bWeldSimulatedBodies;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.K2_AddActorWorldTransform
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FTransform              DeltaTransform                 (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::K2_AddActorWorldTransform(const struct FTransform& DeltaTransform, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_AddActorWorldTransform");

	struct
	{
		struct FTransform              DeltaTransform;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.DeltaTransform = DeltaTransform;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.Actor.K2_AddActorWorldRotation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FRotator                DeltaRotation                  (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::K2_AddActorWorldRotation(const struct FRotator& DeltaRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_AddActorWorldRotation");

	struct
	{
		struct FRotator                DeltaRotation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.DeltaRotation = DeltaRotation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.Actor.K2_AddActorWorldOffset
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 DeltaLocation                  (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::K2_AddActorWorldOffset(const struct FVector& DeltaLocation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_AddActorWorldOffset");

	struct
	{
		struct FVector                 DeltaLocation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.DeltaLocation = DeltaLocation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.Actor.K2_AddActorLocalTransform
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FTransform              NewTransform                   (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::K2_AddActorLocalTransform(const struct FTransform& NewTransform, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_AddActorLocalTransform");

	struct
	{
		struct FTransform              NewTransform;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.NewTransform = NewTransform;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.Actor.K2_AddActorLocalRotation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FRotator                DeltaRotation                  (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::K2_AddActorLocalRotation(const struct FRotator& DeltaRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_AddActorLocalRotation");

	struct
	{
		struct FRotator                DeltaRotation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.DeltaRotation = DeltaRotation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.Actor.K2_AddActorLocalOffset
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 DeltaLocation                  (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::K2_AddActorLocalOffset(const struct FVector& DeltaLocation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.K2_AddActorLocalOffset");

	struct
	{
		struct FVector                 DeltaLocation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.DeltaLocation = DeltaLocation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.Actor.IsOverlappingActor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AActor*                  Other                          (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AActor::IsOverlappingActor(class AActor* Other)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.IsOverlappingActor");

	struct
	{
		class AActor*                  Other;
		bool                           ReturnValue;
	} params;

	params.Other = Other;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.IsChildActor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AActor::IsChildActor()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.IsChildActor");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.IsActorTickEnabled
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AActor::IsActorTickEnabled()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.IsActorTickEnabled");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.IsActorBeingDestroyed
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AActor::IsActorBeingDestroyed()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.IsActorBeingDestroyed");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.HasAuthority
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AActor::HasAuthority()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.HasAuthority");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetVerticalDistanceTo
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AActor*                  OtherActor                     (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float AActor::GetVerticalDistanceTo(class AActor* OtherActor)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetVerticalDistanceTo");

	struct
	{
		class AActor*                  OtherActor;
		float                          ReturnValue;
	} params;

	params.OtherActor = OtherActor;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetVelocity
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector AActor::GetVelocity()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetVelocity");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetTransform
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FTransform              ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FTransform AActor::GetTransform()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetTransform");

	struct
	{
		struct FTransform              ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetTickableWhenPaused
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AActor::GetTickableWhenPaused()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetTickableWhenPaused");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetSquaredDistanceTo
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AActor*                  OtherActor                     (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float AActor::GetSquaredDistanceTo(class AActor* OtherActor)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetSquaredDistanceTo");

	struct
	{
		class AActor*                  OtherActor;
		float                          ReturnValue;
	} params;

	params.OtherActor = OtherActor;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetRemoteRole
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TEnumAsByte<ENetRole>          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

TEnumAsByte<ENetRole> AActor::GetRemoteRole()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetRemoteRole");

	struct
	{
		TEnumAsByte<ENetRole>          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetParentComponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UChildActorComponent*    ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_InstancedReference, CPF_IsPlainOldData)

class UChildActorComponent* AActor::GetParentComponent()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetParentComponent");

	struct
	{
		class UChildActorComponent*    ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetParentActor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AActor*                  ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class AActor* AActor::GetParentActor()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetParentActor");

	struct
	{
		class AActor*                  ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetOwner
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AActor*                  ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class AActor* AActor::GetOwner()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetOwner");

	struct
	{
		class AActor*                  ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetOverlappingComponents
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TArray<class UPrimitiveComponent*> OverlappingComponents          (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor)

void AActor::GetOverlappingComponents(TArray<class UPrimitiveComponent*>* OverlappingComponents)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetOverlappingComponents");

	struct
	{
		TArray<class UPrimitiveComponent*> OverlappingComponents;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (OverlappingComponents != nullptr)
		*OverlappingComponents = params.OverlappingComponents;
}


// Function Engine.Actor.GetOverlappingActors
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TArray<class AActor*>          OverlappingActors              (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor)
// class UClass*                  ClassFilter                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::GetOverlappingActors(class UClass* ClassFilter, TArray<class AActor*>* OverlappingActors)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetOverlappingActors");

	struct
	{
		TArray<class AActor*>          OverlappingActors;
		class UClass*                  ClassFilter;
	} params;

	params.ClassFilter = ClassFilter;

	UObject::ProcessEvent(fn, &params);

	if (OverlappingActors != nullptr)
		*OverlappingActors = params.OverlappingActors;
}


// Function Engine.Actor.GetLifeSpan
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float AActor::GetLifeSpan()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetLifeSpan");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetInstigatorController
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AController*             ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class AController* AActor::GetInstigatorController()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetInstigatorController");

	struct
	{
		class AController*             ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetInstigator
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class APawn*                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class APawn* AActor::GetInstigator()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetInstigator");

	struct
	{
		class APawn*                   ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetInputVectorAxisValue
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FKey                    InputAxisKey                   (CPF_ConstParm, CPF_Parm)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector AActor::GetInputVectorAxisValue(const struct FKey& InputAxisKey)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetInputVectorAxisValue");

	struct
	{
		struct FKey                    InputAxisKey;
		struct FVector                 ReturnValue;
	} params;

	params.InputAxisKey = InputAxisKey;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetInputAxisValue
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   InputAxisName                  (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float AActor::GetInputAxisValue(const struct FName& InputAxisName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetInputAxisValue");

	struct
	{
		struct FName                   InputAxisName;
		float                          ReturnValue;
	} params;

	params.InputAxisName = InputAxisName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetInputAxisKeyValue
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FKey                    InputAxisKey                   (CPF_ConstParm, CPF_Parm)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float AActor::GetInputAxisKeyValue(const struct FKey& InputAxisKey)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetInputAxisKeyValue");

	struct
	{
		struct FKey                    InputAxisKey;
		float                          ReturnValue;
	} params;

	params.InputAxisKey = InputAxisKey;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetHorizontalDotProductTo
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AActor*                  OtherActor                     (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float AActor::GetHorizontalDotProductTo(class AActor* OtherActor)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetHorizontalDotProductTo");

	struct
	{
		class AActor*                  OtherActor;
		float                          ReturnValue;
	} params;

	params.OtherActor = OtherActor;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetHorizontalDistanceTo
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AActor*                  OtherActor                     (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float AActor::GetHorizontalDistanceTo(class AActor* OtherActor)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetHorizontalDistanceTo");

	struct
	{
		class AActor*                  OtherActor;
		float                          ReturnValue;
	} params;

	params.OtherActor = OtherActor;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetGameTimeSinceCreation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float AActor::GetGameTimeSinceCreation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetGameTimeSinceCreation");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetDotProductTo
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AActor*                  OtherActor                     (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float AActor::GetDotProductTo(class AActor* OtherActor)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetDotProductTo");

	struct
	{
		class AActor*                  OtherActor;
		float                          ReturnValue;
	} params;

	params.OtherActor = OtherActor;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetDistanceTo
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AActor*                  OtherActor                     (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float AActor::GetDistanceTo(class AActor* OtherActor)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetDistanceTo");

	struct
	{
		class AActor*                  OtherActor;
		float                          ReturnValue;
	} params;

	params.OtherActor = OtherActor;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetComponentsByTag
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UClass*                  ComponentClass                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   Tag                            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TArray<class UActorComponent*> ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm)

TArray<class UActorComponent*> AActor::GetComponentsByTag(class UClass* ComponentClass, const struct FName& Tag)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetComponentsByTag");

	struct
	{
		class UClass*                  ComponentClass;
		struct FName                   Tag;
		TArray<class UActorComponent*> ReturnValue;
	} params;

	params.ComponentClass = ComponentClass;
	params.Tag = Tag;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetComponentsByClass
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UClass*                  ComponentClass                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TArray<class UActorComponent*> ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm)

TArray<class UActorComponent*> AActor::GetComponentsByClass(class UClass* ComponentClass)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetComponentsByClass");

	struct
	{
		class UClass*                  ComponentClass;
		TArray<class UActorComponent*> ReturnValue;
	} params;

	params.ComponentClass = ComponentClass;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetComponentByClass
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UClass*                  ComponentClass                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UActorComponent*         ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_InstancedReference, CPF_IsPlainOldData)

class UActorComponent* AActor::GetComponentByClass(class UClass* ComponentClass)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetComponentByClass");

	struct
	{
		class UClass*                  ComponentClass;
		class UActorComponent*         ReturnValue;
	} params;

	params.ComponentClass = ComponentClass;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetAttachParentSocketName
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

struct FName AActor::GetAttachParentSocketName()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetAttachParentSocketName");

	struct
	{
		struct FName                   ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetAttachParentActor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AActor*                  ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class AActor* AActor::GetAttachParentActor()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetAttachParentActor");

	struct
	{
		class AActor*                  ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetAttachedActors
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TArray<class AActor*>          OutActors                      (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor)

void AActor::GetAttachedActors(TArray<class AActor*>* OutActors)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetAttachedActors");

	struct
	{
		TArray<class AActor*>          OutActors;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (OutActors != nullptr)
		*OutActors = params.OutActors;
}


// Function Engine.Actor.GetAllChildActors
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TArray<class AActor*>          ChildActors                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor)
// bool                           bIncludeDescendants            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::GetAllChildActors(bool bIncludeDescendants, TArray<class AActor*>* ChildActors)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetAllChildActors");

	struct
	{
		TArray<class AActor*>          ChildActors;
		bool                           bIncludeDescendants;
	} params;

	params.bIncludeDescendants = bIncludeDescendants;

	UObject::ProcessEvent(fn, &params);

	if (ChildActors != nullptr)
		*ChildActors = params.ChildActors;
}


// Function Engine.Actor.GetActorUpVector
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector AActor::GetActorUpVector()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetActorUpVector");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetActorTimeDilation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float AActor::GetActorTimeDilation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetActorTimeDilation");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetActorTickInterval
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float AActor::GetActorTickInterval()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetActorTickInterval");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetActorScale3D
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector AActor::GetActorScale3D()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetActorScale3D");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetActorRightVector
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector AActor::GetActorRightVector()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetActorRightVector");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetActorRelativeScale3D
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector AActor::GetActorRelativeScale3D()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetActorRelativeScale3D");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetActorForwardVector
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector AActor::GetActorForwardVector()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetActorForwardVector");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetActorEyesViewPoint
// (FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 OutLocation                    (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FRotator                OutRotation                    (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)

void AActor::GetActorEyesViewPoint(struct FVector* OutLocation, struct FRotator* OutRotation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetActorEyesViewPoint");

	struct
	{
		struct FVector                 OutLocation;
		struct FRotator                OutRotation;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (OutLocation != nullptr)
		*OutLocation = params.OutLocation;
	if (OutRotation != nullptr)
		*OutRotation = params.OutRotation;
}


// Function Engine.Actor.GetActorEnableCollision
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AActor::GetActorEnableCollision()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetActorEnableCollision");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.GetActorBounds
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           bOnlyCollidingComponents       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 Origin                         (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FVector                 BoxExtent                      (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)

void AActor::GetActorBounds(bool bOnlyCollidingComponents, struct FVector* Origin, struct FVector* BoxExtent)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.GetActorBounds");

	struct
	{
		bool                           bOnlyCollidingComponents;
		struct FVector                 Origin;
		struct FVector                 BoxExtent;
	} params;

	params.bOnlyCollidingComponents = bOnlyCollidingComponents;

	UObject::ProcessEvent(fn, &params);

	if (Origin != nullptr)
		*Origin = params.Origin;
	if (BoxExtent != nullptr)
		*BoxExtent = params.BoxExtent;
}


// Function Engine.Actor.ForceNetUpdate
// (FUNC_BlueprintAuthorityOnly, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AActor::ForceNetUpdate()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ForceNetUpdate");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.FlushNetDormancy
// (FUNC_Final, FUNC_BlueprintAuthorityOnly, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AActor::FlushNetDormancy()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.FlushNetDormancy");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.EnableInput
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class APlayerController*       PlayerController               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::EnableInput(class APlayerController* PlayerController)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.EnableInput");

	struct
	{
		class APlayerController*       PlayerController;
	} params;

	params.PlayerController = PlayerController;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.DisableInput
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class APlayerController*       PlayerController               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::DisableInput(class APlayerController* PlayerController)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.DisableInput");

	struct
	{
		class APlayerController*       PlayerController;
	} params;

	params.PlayerController = PlayerController;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.DetachRootComponentFromParent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bMaintainWorldPosition         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::DetachRootComponentFromParent(bool bMaintainWorldPosition)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.DetachRootComponentFromParent");

	struct
	{
		bool                           bMaintainWorldPosition;
	} params;

	params.bMaintainWorldPosition = bMaintainWorldPosition;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.AddTickPrerequisiteComponent
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UActorComponent*         PrerequisiteComponent          (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)

void AActor::AddTickPrerequisiteComponent(class UActorComponent* PrerequisiteComponent)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.AddTickPrerequisiteComponent");

	struct
	{
		class UActorComponent*         PrerequisiteComponent;
	} params;

	params.PrerequisiteComponent = PrerequisiteComponent;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.AddTickPrerequisiteActor
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class AActor*                  PrerequisiteActor              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AActor::AddTickPrerequisiteActor(class AActor* PrerequisiteActor)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.AddTickPrerequisiteActor");

	struct
	{
		class AActor*                  PrerequisiteActor;
	} params;

	params.PrerequisiteActor = PrerequisiteActor;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Actor.AddComponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   TemplateName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bManualAttachment              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FTransform              RelativeTransform              (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// class UObject*                 ComponentTemplateContext       (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UActorComponent*         ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_InstancedReference, CPF_IsPlainOldData)

class UActorComponent* AActor::AddComponent(const struct FName& TemplateName, bool bManualAttachment, const struct FTransform& RelativeTransform, class UObject* ComponentTemplateContext)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.AddComponent");

	struct
	{
		struct FName                   TemplateName;
		bool                           bManualAttachment;
		struct FTransform              RelativeTransform;
		class UObject*                 ComponentTemplateContext;
		class UActorComponent*         ReturnValue;
	} params;

	params.TemplateName = TemplateName;
	params.bManualAttachment = bManualAttachment;
	params.RelativeTransform = RelativeTransform;
	params.ComponentTemplateContext = ComponentTemplateContext;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Actor.ActorHasTag
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   Tag                            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AActor::ActorHasTag(const struct FName& Tag)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Actor.ActorHasTag");

	struct
	{
		struct FName                   Tag;
		bool                           ReturnValue;
	} params;

	params.Tag = Tag;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Pawn.SpawnDefaultController
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void APawn::SpawnDefaultController()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.SpawnDefaultController");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Pawn.SetCanAffectNavigationGeneration
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewValue                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bForceUpdate                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APawn::SetCanAffectNavigationGeneration(bool bNewValue, bool bForceUpdate)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.SetCanAffectNavigationGeneration");

	struct
	{
		bool                           bNewValue;
		bool                           bForceUpdate;
	} params;

	params.bNewValue = bNewValue;
	params.bForceUpdate = bForceUpdate;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Pawn.ReceiveUnpossessed
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class AController*             OldController                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APawn::ReceiveUnpossessed(class AController* OldController)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.ReceiveUnpossessed");

	struct
	{
		class AController*             OldController;
	} params;

	params.OldController = OldController;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Pawn.ReceivePossessed
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class AController*             NewController                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APawn::ReceivePossessed(class AController* NewController)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.ReceivePossessed");

	struct
	{
		class AController*             NewController;
	} params;

	params.NewController = NewController;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Pawn.PawnMakeNoise
// (FUNC_Final, FUNC_BlueprintAuthorityOnly, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// float                          Loudness                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 NoiseLocation                  (CPF_Parm, CPF_IsPlainOldData)
// bool                           bUseNoiseMakerLocation         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class AActor*                  NoiseMaker                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APawn::PawnMakeNoise(float Loudness, const struct FVector& NoiseLocation, bool bUseNoiseMakerLocation, class AActor* NoiseMaker)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.PawnMakeNoise");

	struct
	{
		float                          Loudness;
		struct FVector                 NoiseLocation;
		bool                           bUseNoiseMakerLocation;
		class AActor*                  NoiseMaker;
	} params;

	params.Loudness = Loudness;
	params.NoiseLocation = NoiseLocation;
	params.bUseNoiseMakerLocation = bUseNoiseMakerLocation;
	params.NoiseMaker = NoiseMaker;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Pawn.OnRep_PlayerState
// (FUNC_Native, FUNC_Public)

void APawn::OnRep_PlayerState()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.OnRep_PlayerState");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Pawn.OnRep_Controller
// (FUNC_Native, FUNC_Public)

void APawn::OnRep_Controller()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.OnRep_Controller");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Pawn.LaunchPawn
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 LaunchVelocity                 (CPF_Parm, CPF_IsPlainOldData)
// bool                           bXYOverride                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bZOverride                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APawn::LaunchPawn(const struct FVector& LaunchVelocity, bool bXYOverride, bool bZOverride)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.LaunchPawn");

	struct
	{
		struct FVector                 LaunchVelocity;
		bool                           bXYOverride;
		bool                           bZOverride;
	} params;

	params.LaunchVelocity = LaunchVelocity;
	params.bXYOverride = bXYOverride;
	params.bZOverride = bZOverride;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Pawn.K2_GetMovementInputVector
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector APawn::K2_GetMovementInputVector()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.K2_GetMovementInputVector");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Pawn.IsPlayerControlled
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool APawn::IsPlayerControlled()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.IsPlayerControlled");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Pawn.IsMoveInputIgnored
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool APawn::IsMoveInputIgnored()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.IsMoveInputIgnored");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Pawn.IsLocallyControlled
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool APawn::IsLocallyControlled()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.IsLocallyControlled");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Pawn.IsControlled
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool APawn::IsControlled()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.IsControlled");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Pawn.GetPendingMovementInputVector
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector APawn::GetPendingMovementInputVector()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.GetPendingMovementInputVector");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Pawn.GetNavAgentLocation
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector APawn::GetNavAgentLocation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.GetNavAgentLocation");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Pawn.GetMovementComponent
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UPawnMovementComponent*  ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_InstancedReference, CPF_IsPlainOldData)

class UPawnMovementComponent* APawn::GetMovementComponent()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.GetMovementComponent");

	struct
	{
		class UPawnMovementComponent*  ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Pawn.GetMovementBaseActor
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// class APawn*                   Pawn                           (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class AActor*                  ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class AActor* APawn::GetMovementBaseActor(class APawn* Pawn)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.GetMovementBaseActor");

	struct
	{
		class APawn*                   Pawn;
		class AActor*                  ReturnValue;
	} params;

	params.Pawn = Pawn;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Pawn.GetLastMovementInputVector
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector APawn::GetLastMovementInputVector()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.GetLastMovementInputVector");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Pawn.GetControlRotation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FRotator                ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FRotator APawn::GetControlRotation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.GetControlRotation");

	struct
	{
		struct FRotator                ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Pawn.GetController
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AController*             ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class AController* APawn::GetController()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.GetController");

	struct
	{
		class AController*             ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Pawn.GetBaseAimRotation
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FRotator                ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FRotator APawn::GetBaseAimRotation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.GetBaseAimRotation");

	struct
	{
		struct FRotator                ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Pawn.DetachFromControllerPendingDestroy
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void APawn::DetachFromControllerPendingDestroy()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.DetachFromControllerPendingDestroy");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Pawn.ConsumeMovementInputVector
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector APawn::ConsumeMovementInputVector()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.ConsumeMovementInputVector");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Pawn.AddMovementInput
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 WorldDirection                 (CPF_Parm, CPF_IsPlainOldData)
// float                          ScaleValue                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bForce                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APawn::AddMovementInput(const struct FVector& WorldDirection, float ScaleValue, bool bForce)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.AddMovementInput");

	struct
	{
		struct FVector                 WorldDirection;
		float                          ScaleValue;
		bool                           bForce;
	} params;

	params.WorldDirection = WorldDirection;
	params.ScaleValue = ScaleValue;
	params.bForce = bForce;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Pawn.AddControllerYawInput
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Val                            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APawn::AddControllerYawInput(float Val)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.AddControllerYawInput");

	struct
	{
		float                          Val;
	} params;

	params.Val = Val;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Pawn.AddControllerRollInput
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Val                            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APawn::AddControllerRollInput(float Val)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.AddControllerRollInput");

	struct
	{
		float                          Val;
	} params;

	params.Val = Val;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Pawn.AddControllerPitchInput
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Val                            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APawn::AddControllerPitchInput(float Val)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Pawn.AddControllerPitchInput");

	struct
	{
		float                          Val;
	} params;

	params.Val = Val;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.UnCrouch
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bClientSimulation              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::UnCrouch(bool bClientSimulation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.UnCrouch");

	struct
	{
		bool                           bClientSimulation;
	} params;

	params.bClientSimulation = bClientSimulation;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.StopJumping
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void ACharacter::StopJumping()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.StopJumping");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.StopAnimMontage
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UAnimMontage*            AnimMontage                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::StopAnimMontage(class UAnimMontage* AnimMontage)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.StopAnimMontage");

	struct
	{
		class UAnimMontage*            AnimMontage;
	} params;

	params.AnimMontage = AnimMontage;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.SetReplicateMovement
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bInReplicateMovement           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::SetReplicateMovement(bool bInReplicateMovement)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.SetReplicateMovement");

	struct
	{
		bool                           bInReplicateMovement;
	} params;

	params.bInReplicateMovement = bInReplicateMovement;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.ServerMoveOld
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)
// Parameters:
// float                          OldTimeStamp                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector_NetQuantize10   OldAccel                       (CPF_Parm)
// unsigned char                  OldMoveFlags                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InCrouchedHalfHeight           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::ServerMoveOld(float OldTimeStamp, const struct FVector_NetQuantize10& OldAccel, unsigned char OldMoveFlags, float InCrouchedHalfHeight)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.ServerMoveOld");

	struct
	{
		float                          OldTimeStamp;
		struct FVector_NetQuantize10   OldAccel;
		unsigned char                  OldMoveFlags;
		float                          InCrouchedHalfHeight;
	} params;

	params.OldTimeStamp = OldTimeStamp;
	params.OldAccel = OldAccel;
	params.OldMoveFlags = OldMoveFlags;
	params.InCrouchedHalfHeight = InCrouchedHalfHeight;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.ServerMoveNoBase
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)
// Parameters:
// float                          Timestamp                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector_NetQuantize10   InAccel                        (CPF_Parm)
// struct FVector_NetQuantize100  ClientLoc                      (CPF_Parm)
// unsigned char                  CompressedMoveFlags            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// unsigned char                  ClientRoll                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// uint32_t                       View                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// unsigned char                  ClientMovementMode             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InCrouchedHalfHeight           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::ServerMoveNoBase(float Timestamp, const struct FVector_NetQuantize10& InAccel, const struct FVector_NetQuantize100& ClientLoc, unsigned char CompressedMoveFlags, unsigned char ClientRoll, uint32_t View, unsigned char ClientMovementMode, float InCrouchedHalfHeight)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.ServerMoveNoBase");

	struct
	{
		float                          Timestamp;
		struct FVector_NetQuantize10   InAccel;
		struct FVector_NetQuantize100  ClientLoc;
		unsigned char                  CompressedMoveFlags;
		unsigned char                  ClientRoll;
		uint32_t                       View;
		unsigned char                  ClientMovementMode;
		float                          InCrouchedHalfHeight;
	} params;

	params.Timestamp = Timestamp;
	params.InAccel = InAccel;
	params.ClientLoc = ClientLoc;
	params.CompressedMoveFlags = CompressedMoveFlags;
	params.ClientRoll = ClientRoll;
	params.View = View;
	params.ClientMovementMode = ClientMovementMode;
	params.InCrouchedHalfHeight = InCrouchedHalfHeight;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.ServerMoveDualNoBase
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)
// Parameters:
// float                          TimeStamp0                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector_NetQuantize10   InAccel0                       (CPF_Parm)
// unsigned char                  PendingFlags                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// uint32_t                       View0                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Timestamp                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector_NetQuantize10   InAccel                        (CPF_Parm)
// struct FVector_NetQuantize100  ClientLoc                      (CPF_Parm)
// unsigned char                  NewFlags                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// unsigned char                  ClientRoll                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// uint32_t                       View                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// unsigned char                  ClientMovementMode             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InCrouchedHalfHeight           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::ServerMoveDualNoBase(float TimeStamp0, const struct FVector_NetQuantize10& InAccel0, unsigned char PendingFlags, uint32_t View0, float Timestamp, const struct FVector_NetQuantize10& InAccel, const struct FVector_NetQuantize100& ClientLoc, unsigned char NewFlags, unsigned char ClientRoll, uint32_t View, unsigned char ClientMovementMode, float InCrouchedHalfHeight)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.ServerMoveDualNoBase");

	struct
	{
		float                          TimeStamp0;
		struct FVector_NetQuantize10   InAccel0;
		unsigned char                  PendingFlags;
		uint32_t                       View0;
		float                          Timestamp;
		struct FVector_NetQuantize10   InAccel;
		struct FVector_NetQuantize100  ClientLoc;
		unsigned char                  NewFlags;
		unsigned char                  ClientRoll;
		uint32_t                       View;
		unsigned char                  ClientMovementMode;
		float                          InCrouchedHalfHeight;
	} params;

	params.TimeStamp0 = TimeStamp0;
	params.InAccel0 = InAccel0;
	params.PendingFlags = PendingFlags;
	params.View0 = View0;
	params.Timestamp = Timestamp;
	params.InAccel = InAccel;
	params.ClientLoc = ClientLoc;
	params.NewFlags = NewFlags;
	params.ClientRoll = ClientRoll;
	params.View = View;
	params.ClientMovementMode = ClientMovementMode;
	params.InCrouchedHalfHeight = InCrouchedHalfHeight;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.ServerMoveDualHybridRootMotion
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)
// Parameters:
// float                          TimeStamp0                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector_NetQuantize10   InAccel0                       (CPF_Parm)
// unsigned char                  PendingFlags                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// uint32_t                       View0                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Timestamp                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector_NetQuantize10   InAccel                        (CPF_Parm)
// struct FVector_NetQuantize100  ClientLoc                      (CPF_Parm)
// unsigned char                  NewFlags                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// unsigned char                  ClientRoll                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// uint32_t                       View                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UPrimitiveComponent*     ClientMovementBase             (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FName                   ClientBaseBoneName             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// unsigned char                  ClientMovementMode             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InCrouchedHalfHeight           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::ServerMoveDualHybridRootMotion(float TimeStamp0, const struct FVector_NetQuantize10& InAccel0, unsigned char PendingFlags, uint32_t View0, float Timestamp, const struct FVector_NetQuantize10& InAccel, const struct FVector_NetQuantize100& ClientLoc, unsigned char NewFlags, unsigned char ClientRoll, uint32_t View, class UPrimitiveComponent* ClientMovementBase, const struct FName& ClientBaseBoneName, unsigned char ClientMovementMode, float InCrouchedHalfHeight)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.ServerMoveDualHybridRootMotion");

	struct
	{
		float                          TimeStamp0;
		struct FVector_NetQuantize10   InAccel0;
		unsigned char                  PendingFlags;
		uint32_t                       View0;
		float                          Timestamp;
		struct FVector_NetQuantize10   InAccel;
		struct FVector_NetQuantize100  ClientLoc;
		unsigned char                  NewFlags;
		unsigned char                  ClientRoll;
		uint32_t                       View;
		class UPrimitiveComponent*     ClientMovementBase;
		struct FName                   ClientBaseBoneName;
		unsigned char                  ClientMovementMode;
		float                          InCrouchedHalfHeight;
	} params;

	params.TimeStamp0 = TimeStamp0;
	params.InAccel0 = InAccel0;
	params.PendingFlags = PendingFlags;
	params.View0 = View0;
	params.Timestamp = Timestamp;
	params.InAccel = InAccel;
	params.ClientLoc = ClientLoc;
	params.NewFlags = NewFlags;
	params.ClientRoll = ClientRoll;
	params.View = View;
	params.ClientMovementBase = ClientMovementBase;
	params.ClientBaseBoneName = ClientBaseBoneName;
	params.ClientMovementMode = ClientMovementMode;
	params.InCrouchedHalfHeight = InCrouchedHalfHeight;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.ServerMoveDual
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)
// Parameters:
// float                          TimeStamp0                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector_NetQuantize10   InAccel0                       (CPF_Parm)
// unsigned char                  PendingFlags                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// uint32_t                       View0                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Timestamp                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector_NetQuantize10   InAccel                        (CPF_Parm)
// struct FVector_NetQuantize100  ClientLoc                      (CPF_Parm)
// unsigned char                  NewFlags                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// unsigned char                  ClientRoll                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// uint32_t                       View                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UPrimitiveComponent*     ClientMovementBase             (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FName                   ClientBaseBoneName             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// unsigned char                  ClientMovementMode             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InCrouchedHalfHeight           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::ServerMoveDual(float TimeStamp0, const struct FVector_NetQuantize10& InAccel0, unsigned char PendingFlags, uint32_t View0, float Timestamp, const struct FVector_NetQuantize10& InAccel, const struct FVector_NetQuantize100& ClientLoc, unsigned char NewFlags, unsigned char ClientRoll, uint32_t View, class UPrimitiveComponent* ClientMovementBase, const struct FName& ClientBaseBoneName, unsigned char ClientMovementMode, float InCrouchedHalfHeight)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.ServerMoveDual");

	struct
	{
		float                          TimeStamp0;
		struct FVector_NetQuantize10   InAccel0;
		unsigned char                  PendingFlags;
		uint32_t                       View0;
		float                          Timestamp;
		struct FVector_NetQuantize10   InAccel;
		struct FVector_NetQuantize100  ClientLoc;
		unsigned char                  NewFlags;
		unsigned char                  ClientRoll;
		uint32_t                       View;
		class UPrimitiveComponent*     ClientMovementBase;
		struct FName                   ClientBaseBoneName;
		unsigned char                  ClientMovementMode;
		float                          InCrouchedHalfHeight;
	} params;

	params.TimeStamp0 = TimeStamp0;
	params.InAccel0 = InAccel0;
	params.PendingFlags = PendingFlags;
	params.View0 = View0;
	params.Timestamp = Timestamp;
	params.InAccel = InAccel;
	params.ClientLoc = ClientLoc;
	params.NewFlags = NewFlags;
	params.ClientRoll = ClientRoll;
	params.View = View;
	params.ClientMovementBase = ClientMovementBase;
	params.ClientBaseBoneName = ClientBaseBoneName;
	params.ClientMovementMode = ClientMovementMode;
	params.InCrouchedHalfHeight = InCrouchedHalfHeight;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.ServerMove
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)
// Parameters:
// float                          Timestamp                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector_NetQuantize10   InAccel                        (CPF_Parm)
// struct FVector_NetQuantize100  ClientLoc                      (CPF_Parm)
// unsigned char                  CompressedMoveFlags            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// unsigned char                  ClientRoll                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// uint32_t                       View                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UPrimitiveComponent*     ClientMovementBase             (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FName                   ClientBaseBoneName             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// unsigned char                  ClientMovementMode             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InCrouchedHalfHeight           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::ServerMove(float Timestamp, const struct FVector_NetQuantize10& InAccel, const struct FVector_NetQuantize100& ClientLoc, unsigned char CompressedMoveFlags, unsigned char ClientRoll, uint32_t View, class UPrimitiveComponent* ClientMovementBase, const struct FName& ClientBaseBoneName, unsigned char ClientMovementMode, float InCrouchedHalfHeight)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.ServerMove");

	struct
	{
		float                          Timestamp;
		struct FVector_NetQuantize10   InAccel;
		struct FVector_NetQuantize100  ClientLoc;
		unsigned char                  CompressedMoveFlags;
		unsigned char                  ClientRoll;
		uint32_t                       View;
		class UPrimitiveComponent*     ClientMovementBase;
		struct FName                   ClientBaseBoneName;
		unsigned char                  ClientMovementMode;
		float                          InCrouchedHalfHeight;
	} params;

	params.Timestamp = Timestamp;
	params.InAccel = InAccel;
	params.ClientLoc = ClientLoc;
	params.CompressedMoveFlags = CompressedMoveFlags;
	params.ClientRoll = ClientRoll;
	params.View = View;
	params.ClientMovementBase = ClientMovementBase;
	params.ClientBaseBoneName = ClientBaseBoneName;
	params.ClientMovementMode = ClientMovementMode;
	params.InCrouchedHalfHeight = InCrouchedHalfHeight;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.RootMotionDebugClientPrintOnScreen
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// struct FString                 inString                       (CPF_Parm, CPF_ZeroConstructor)

void ACharacter::RootMotionDebugClientPrintOnScreen(const struct FString& inString)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.RootMotionDebugClientPrintOnScreen");

	struct
	{
		struct FString                 inString;
	} params;

	params.inString = inString;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.PlayAnimMontage
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UAnimMontage*            AnimMontage                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InPlayRate                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   StartSectionName               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float ACharacter::PlayAnimMontage(class UAnimMontage* AnimMontage, float InPlayRate, const struct FName& StartSectionName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.PlayAnimMontage");

	struct
	{
		class UAnimMontage*            AnimMontage;
		float                          InPlayRate;
		struct FName                   StartSectionName;
		float                          ReturnValue;
	} params;

	params.AnimMontage = AnimMontage;
	params.InPlayRate = InPlayRate;
	params.StartSectionName = StartSectionName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Character.OnWalkingOffLedge
// (FUNC_Native, FUNC_Event, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintEvent)
// Parameters:
// struct FVector                 PreviousFloorImpactNormal      (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// struct FVector                 PreviousFloorContactNormal     (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// struct FVector                 PreviousLocation               (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// float                          TimeDelta                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::OnWalkingOffLedge(const struct FVector& PreviousFloorImpactNormal, const struct FVector& PreviousFloorContactNormal, const struct FVector& PreviousLocation, float TimeDelta)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.OnWalkingOffLedge");

	struct
	{
		struct FVector                 PreviousFloorImpactNormal;
		struct FVector                 PreviousFloorContactNormal;
		struct FVector                 PreviousLocation;
		float                          TimeDelta;
	} params;

	params.PreviousFloorImpactNormal = PreviousFloorImpactNormal;
	params.PreviousFloorContactNormal = PreviousFloorContactNormal;
	params.PreviousLocation = PreviousLocation;
	params.TimeDelta = TimeDelta;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.OnRep_RootMotion
// (FUNC_Final, FUNC_Native, FUNC_Public)

void ACharacter::OnRep_RootMotion()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.OnRep_RootMotion");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.OnRep_ReplicatedCrouchedStateAndCapsuleHalfHeight
// (FUNC_Native, FUNC_Public)

void ACharacter::OnRep_ReplicatedCrouchedStateAndCapsuleHalfHeight()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.OnRep_ReplicatedCrouchedStateAndCapsuleHalfHeight");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.OnRep_ReplicatedBasedMovement
// (FUNC_Native, FUNC_Public)

void ACharacter::OnRep_ReplicatedBasedMovement()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.OnRep_ReplicatedBasedMovement");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.OnLaunched
// (FUNC_Event, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintEvent)
// Parameters:
// struct FVector                 LaunchVelocity                 (CPF_Parm, CPF_IsPlainOldData)
// bool                           bXYOverride                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bZOverride                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::OnLaunched(const struct FVector& LaunchVelocity, bool bXYOverride, bool bZOverride)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.OnLaunched");

	struct
	{
		struct FVector                 LaunchVelocity;
		bool                           bXYOverride;
		bool                           bZOverride;
	} params;

	params.LaunchVelocity = LaunchVelocity;
	params.bXYOverride = bXYOverride;
	params.bZOverride = bZOverride;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.OnLanded
// (FUNC_Event, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintEvent)
// Parameters:
// struct FHitResult              Hit                            (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)

void ACharacter::OnLanded(const struct FHitResult& Hit)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.OnLanded");

	struct
	{
		struct FHitResult              Hit;
	} params;

	params.Hit = Hit;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.OnJumped
// (FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)

void ACharacter::OnJumped()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.OnJumped");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.LaunchCharacter
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 LaunchVelocity                 (CPF_Parm, CPF_IsPlainOldData)
// bool                           bXYOverride                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bZOverride                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::LaunchCharacter(const struct FVector& LaunchVelocity, bool bXYOverride, bool bZOverride)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.LaunchCharacter");

	struct
	{
		struct FVector                 LaunchVelocity;
		bool                           bXYOverride;
		bool                           bZOverride;
	} params;

	params.LaunchVelocity = LaunchVelocity;
	params.bXYOverride = bXYOverride;
	params.bZOverride = bZOverride;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.K2_UpdateCustomMovement
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// float                          DeltaTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::K2_UpdateCustomMovement(float DeltaTime)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.K2_UpdateCustomMovement");

	struct
	{
		float                          DeltaTime;
	} params;

	params.DeltaTime = DeltaTime;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.K2_OnStartCrouch
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// float                          HalfHeightAdjust               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScaledHalfHeightAdjust         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::K2_OnStartCrouch(float HalfHeightAdjust, float ScaledHalfHeightAdjust)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.K2_OnStartCrouch");

	struct
	{
		float                          HalfHeightAdjust;
		float                          ScaledHalfHeightAdjust;
	} params;

	params.HalfHeightAdjust = HalfHeightAdjust;
	params.ScaledHalfHeightAdjust = ScaledHalfHeightAdjust;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.K2_OnMovementModeChanged
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// TEnumAsByte<EMovementMode>     PrevMovementMode               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TEnumAsByte<EMovementMode>     NewMovementMode                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// unsigned char                  PrevCustomMode                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// unsigned char                  NewCustomMode                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::K2_OnMovementModeChanged(TEnumAsByte<EMovementMode> PrevMovementMode, TEnumAsByte<EMovementMode> NewMovementMode, unsigned char PrevCustomMode, unsigned char NewCustomMode)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.K2_OnMovementModeChanged");

	struct
	{
		TEnumAsByte<EMovementMode>     PrevMovementMode;
		TEnumAsByte<EMovementMode>     NewMovementMode;
		unsigned char                  PrevCustomMode;
		unsigned char                  NewCustomMode;
	} params;

	params.PrevMovementMode = PrevMovementMode;
	params.NewMovementMode = NewMovementMode;
	params.PrevCustomMode = PrevCustomMode;
	params.NewCustomMode = NewCustomMode;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.K2_OnEndCrouch
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// float                          HalfHeightAdjust               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScaledHalfHeightAdjust         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::K2_OnEndCrouch(float HalfHeightAdjust, float ScaledHalfHeightAdjust)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.K2_OnEndCrouch");

	struct
	{
		float                          HalfHeightAdjust;
		float                          ScaledHalfHeightAdjust;
	} params;

	params.HalfHeightAdjust = HalfHeightAdjust;
	params.ScaledHalfHeightAdjust = ScaledHalfHeightAdjust;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.Jump
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void ACharacter::Jump()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.Jump");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.IsPlayingRootMotion
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool ACharacter::IsPlayingRootMotion()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.IsPlayingRootMotion");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Character.IsPlayingNetworkedRootMotionMontage
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool ACharacter::IsPlayingNetworkedRootMotionMontage()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.IsPlayingNetworkedRootMotionMontage");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Character.IsJumpProvidingForce
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool ACharacter::IsJumpProvidingForce()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.IsJumpProvidingForce");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Character.GetCurrentMontage
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UAnimMontage*            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UAnimMontage* ACharacter::GetCurrentMontage()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.GetCurrentMontage");

	struct
	{
		class UAnimMontage*            ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Character.GetBaseTranslationOffset
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector ACharacter::GetBaseTranslationOffset()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.GetBaseTranslationOffset");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Character.GetBaseRotationOffsetRotator
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FRotator                ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FRotator ACharacter::GetBaseRotationOffsetRotator()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.GetBaseRotationOffsetRotator");

	struct
	{
		struct FRotator                ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Character.GetAnimRootMotionTranslationScale
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float ACharacter::GetAnimRootMotionTranslationScale()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.GetAnimRootMotionTranslationScale");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Character.Crouch
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bClientSimulation              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::Crouch(bool bClientSimulation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.Crouch");

	struct
	{
		bool                           bClientSimulation;
	} params;

	params.bClientSimulation = bClientSimulation;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.ClientVeryShortAdjustPosition
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_HasDefaults, FUNC_NetClient)
// Parameters:
// float                          Timestamp                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 NewLoc                         (CPF_Parm, CPF_IsPlainOldData)
// class UPrimitiveComponent*     NewBase                        (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FName                   NewBaseBoneName                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bHasBase                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bBaseRelativePosition          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// unsigned char                  ServerMovementMode             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::ClientVeryShortAdjustPosition(float Timestamp, const struct FVector& NewLoc, class UPrimitiveComponent* NewBase, const struct FName& NewBaseBoneName, bool bHasBase, bool bBaseRelativePosition, unsigned char ServerMovementMode)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.ClientVeryShortAdjustPosition");

	struct
	{
		float                          Timestamp;
		struct FVector                 NewLoc;
		class UPrimitiveComponent*     NewBase;
		struct FName                   NewBaseBoneName;
		bool                           bHasBase;
		bool                           bBaseRelativePosition;
		unsigned char                  ServerMovementMode;
	} params;

	params.Timestamp = Timestamp;
	params.NewLoc = NewLoc;
	params.NewBase = NewBase;
	params.NewBaseBoneName = NewBaseBoneName;
	params.bHasBase = bHasBase;
	params.bBaseRelativePosition = bBaseRelativePosition;
	params.ServerMovementMode = ServerMovementMode;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.ClientCheatWalk
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)

void ACharacter::ClientCheatWalk()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.ClientCheatWalk");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.ClientCheatGhost
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)

void ACharacter::ClientCheatGhost()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.ClientCheatGhost");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.ClientCheatFly
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)

void ACharacter::ClientCheatFly()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.ClientCheatFly");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.ClientAdjustRootMotionSourcePosition
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_HasDefaults, FUNC_NetClient)
// Parameters:
// float                          Timestamp                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FRootMotionSourceGroup  ServerRootMotion               (CPF_Parm)
// bool                           bHasAnimRootMotion             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ServerMontageTrackPosition     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 ServerLoc                      (CPF_Parm, CPF_IsPlainOldData)
// struct FVector_NetQuantizeNormal ServerRotation                 (CPF_Parm)
// float                          ServerVelZ                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UPrimitiveComponent*     ServerBase                     (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FName                   ServerBoneName                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bHasBase                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bBaseRelativePosition          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// unsigned char                  ServerMovementMode             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::ClientAdjustRootMotionSourcePosition(float Timestamp, const struct FRootMotionSourceGroup& ServerRootMotion, bool bHasAnimRootMotion, float ServerMontageTrackPosition, const struct FVector& ServerLoc, const struct FVector_NetQuantizeNormal& ServerRotation, float ServerVelZ, class UPrimitiveComponent* ServerBase, const struct FName& ServerBoneName, bool bHasBase, bool bBaseRelativePosition, unsigned char ServerMovementMode)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.ClientAdjustRootMotionSourcePosition");

	struct
	{
		float                          Timestamp;
		struct FRootMotionSourceGroup  ServerRootMotion;
		bool                           bHasAnimRootMotion;
		float                          ServerMontageTrackPosition;
		struct FVector                 ServerLoc;
		struct FVector_NetQuantizeNormal ServerRotation;
		float                          ServerVelZ;
		class UPrimitiveComponent*     ServerBase;
		struct FName                   ServerBoneName;
		bool                           bHasBase;
		bool                           bBaseRelativePosition;
		unsigned char                  ServerMovementMode;
	} params;

	params.Timestamp = Timestamp;
	params.ServerRootMotion = ServerRootMotion;
	params.bHasAnimRootMotion = bHasAnimRootMotion;
	params.ServerMontageTrackPosition = ServerMontageTrackPosition;
	params.ServerLoc = ServerLoc;
	params.ServerRotation = ServerRotation;
	params.ServerVelZ = ServerVelZ;
	params.ServerBase = ServerBase;
	params.ServerBoneName = ServerBoneName;
	params.bHasBase = bHasBase;
	params.bBaseRelativePosition = bBaseRelativePosition;
	params.ServerMovementMode = ServerMovementMode;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.ClientAdjustRootMotionPosition
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_HasDefaults, FUNC_NetClient)
// Parameters:
// float                          Timestamp                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ServerMontageTrackPosition     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 ServerLoc                      (CPF_Parm, CPF_IsPlainOldData)
// struct FVector_NetQuantizeNormal ServerRotation                 (CPF_Parm)
// float                          ServerVelZ                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UPrimitiveComponent*     ServerBase                     (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FName                   ServerBoneName                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bHasBase                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bBaseRelativePosition          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// unsigned char                  ServerMovementMode             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::ClientAdjustRootMotionPosition(float Timestamp, float ServerMontageTrackPosition, const struct FVector& ServerLoc, const struct FVector_NetQuantizeNormal& ServerRotation, float ServerVelZ, class UPrimitiveComponent* ServerBase, const struct FName& ServerBoneName, bool bHasBase, bool bBaseRelativePosition, unsigned char ServerMovementMode)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.ClientAdjustRootMotionPosition");

	struct
	{
		float                          Timestamp;
		float                          ServerMontageTrackPosition;
		struct FVector                 ServerLoc;
		struct FVector_NetQuantizeNormal ServerRotation;
		float                          ServerVelZ;
		class UPrimitiveComponent*     ServerBase;
		struct FName                   ServerBoneName;
		bool                           bHasBase;
		bool                           bBaseRelativePosition;
		unsigned char                  ServerMovementMode;
	} params;

	params.Timestamp = Timestamp;
	params.ServerMontageTrackPosition = ServerMontageTrackPosition;
	params.ServerLoc = ServerLoc;
	params.ServerRotation = ServerRotation;
	params.ServerVelZ = ServerVelZ;
	params.ServerBase = ServerBase;
	params.ServerBoneName = ServerBoneName;
	params.bHasBase = bHasBase;
	params.bBaseRelativePosition = bBaseRelativePosition;
	params.ServerMovementMode = ServerMovementMode;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.ClientAdjustPosition
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_HasDefaults, FUNC_NetClient)
// Parameters:
// float                          Timestamp                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 NewLoc                         (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 NewVel                         (CPF_Parm, CPF_IsPlainOldData)
// class UPrimitiveComponent*     NewBase                        (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FName                   NewBaseBoneName                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bHasBase                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bBaseRelativePosition          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// unsigned char                  ServerMovementMode             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::ClientAdjustPosition(float Timestamp, const struct FVector& NewLoc, const struct FVector& NewVel, class UPrimitiveComponent* NewBase, const struct FName& NewBaseBoneName, bool bHasBase, bool bBaseRelativePosition, unsigned char ServerMovementMode)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.ClientAdjustPosition");

	struct
	{
		float                          Timestamp;
		struct FVector                 NewLoc;
		struct FVector                 NewVel;
		class UPrimitiveComponent*     NewBase;
		struct FName                   NewBaseBoneName;
		bool                           bHasBase;
		bool                           bBaseRelativePosition;
		unsigned char                  ServerMovementMode;
	} params;

	params.Timestamp = Timestamp;
	params.NewLoc = NewLoc;
	params.NewVel = NewVel;
	params.NewBase = NewBase;
	params.NewBaseBoneName = NewBaseBoneName;
	params.bHasBase = bHasBase;
	params.bBaseRelativePosition = bBaseRelativePosition;
	params.ServerMovementMode = ServerMovementMode;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.ClientAckGoodMove
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// float                          Timestamp                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ACharacter::ClientAckGoodMove(float Timestamp)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.ClientAckGoodMove");

	struct
	{
		float                          Timestamp;
	} params;

	params.Timestamp = Timestamp;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Character.CanJumpInternal
// (FUNC_Native, FUNC_Event, FUNC_Protected, FUNC_BlueprintEvent, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool ACharacter::CanJumpInternal()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.CanJumpInternal");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Character.CanJump
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool ACharacter::CanJump()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.CanJump");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Character.CacheInitialMeshOffset
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 MeshRelativeLocation           (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                MeshRelativeRotation           (CPF_Parm, CPF_IsPlainOldData)

void ACharacter::CacheInitialMeshOffset(const struct FVector& MeshRelativeLocation, const struct FRotator& MeshRelativeRotation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Character.CacheInitialMeshOffset");

	struct
	{
		struct FVector                 MeshRelativeLocation;
		struct FRotator                MeshRelativeRotation;
	} params;

	params.MeshRelativeLocation = MeshRelativeLocation;
	params.MeshRelativeRotation = MeshRelativeRotation;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ActorComponent.ToggleActive
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UActorComponent::ToggleActive()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.ToggleActive");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ActorComponent.SetTickGroup
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// TEnumAsByte<ETickingGroup>     NewTickGroup                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UActorComponent::SetTickGroup(TEnumAsByte<ETickingGroup> NewTickGroup)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.SetTickGroup");

	struct
	{
		TEnumAsByte<ETickingGroup>     NewTickGroup;
	} params;

	params.NewTickGroup = NewTickGroup;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ActorComponent.SetTickableWhenPaused
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bTickableWhenPaused            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UActorComponent::SetTickableWhenPaused(bool bTickableWhenPaused)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.SetTickableWhenPaused");

	struct
	{
		bool                           bTickableWhenPaused;
	} params;

	params.bTickableWhenPaused = bTickableWhenPaused;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ActorComponent.SetIsReplicated
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           ShouldReplicate                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UActorComponent::SetIsReplicated(bool ShouldReplicate)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.SetIsReplicated");

	struct
	{
		bool                           ShouldReplicate;
	} params;

	params.ShouldReplicate = ShouldReplicate;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ActorComponent.SetComponentTickInterval
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          TickInterval                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UActorComponent::SetComponentTickInterval(float TickInterval)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.SetComponentTickInterval");

	struct
	{
		float                          TickInterval;
	} params;

	params.TickInterval = TickInterval;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ActorComponent.SetComponentTickEnabled
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bEnabled                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UActorComponent::SetComponentTickEnabled(bool bEnabled)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.SetComponentTickEnabled");

	struct
	{
		bool                           bEnabled;
	} params;

	params.bEnabled = bEnabled;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ActorComponent.SetAutoActivate
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewAutoActivate               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UActorComponent::SetAutoActivate(bool bNewAutoActivate)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.SetAutoActivate");

	struct
	{
		bool                           bNewAutoActivate;
	} params;

	params.bNewAutoActivate = bNewAutoActivate;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ActorComponent.SetActive
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewActive                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bReset                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UActorComponent::SetActive(bool bNewActive, bool bReset)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.SetActive");

	struct
	{
		bool                           bNewActive;
		bool                           bReset;
	} params;

	params.bNewActive = bNewActive;
	params.bReset = bReset;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ActorComponent.RemoveTickPrerequisiteComponent
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UActorComponent*         PrerequisiteComponent          (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)

void UActorComponent::RemoveTickPrerequisiteComponent(class UActorComponent* PrerequisiteComponent)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.RemoveTickPrerequisiteComponent");

	struct
	{
		class UActorComponent*         PrerequisiteComponent;
	} params;

	params.PrerequisiteComponent = PrerequisiteComponent;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ActorComponent.RemoveTickPrerequisiteActor
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class AActor*                  PrerequisiteActor              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UActorComponent::RemoveTickPrerequisiteActor(class AActor* PrerequisiteActor)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.RemoveTickPrerequisiteActor");

	struct
	{
		class AActor*                  PrerequisiteActor;
	} params;

	params.PrerequisiteActor = PrerequisiteActor;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ActorComponent.ReceiveTick
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// float                          DeltaSeconds                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UActorComponent::ReceiveTick(float DeltaSeconds)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.ReceiveTick");

	struct
	{
		float                          DeltaSeconds;
	} params;

	params.DeltaSeconds = DeltaSeconds;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ActorComponent.ReceiveEndPlay
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// TEnumAsByte<EEndPlayReason>    EndPlayReason                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UActorComponent::ReceiveEndPlay(TEnumAsByte<EEndPlayReason> EndPlayReason)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.ReceiveEndPlay");

	struct
	{
		TEnumAsByte<EEndPlayReason>    EndPlayReason;
	} params;

	params.EndPlayReason = EndPlayReason;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ActorComponent.ReceiveBeginPlay
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)

void UActorComponent::ReceiveBeginPlay()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.ReceiveBeginPlay");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ActorComponent.OnRep_IsActive
// (FUNC_Final, FUNC_Native, FUNC_Public)

void UActorComponent::OnRep_IsActive()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.OnRep_IsActive");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ActorComponent.K2_DestroyComponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UObject*                 Object                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UActorComponent::K2_DestroyComponent(class UObject* Object)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.K2_DestroyComponent");

	struct
	{
		class UObject*                 Object;
	} params;

	params.Object = Object;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ActorComponent.IsComponentTickEnabled
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UActorComponent::IsComponentTickEnabled()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.IsComponentTickEnabled");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.ActorComponent.IsBeingDestroyed
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UActorComponent::IsBeingDestroyed()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.IsBeingDestroyed");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.ActorComponent.IsActive
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UActorComponent::IsActive()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.IsActive");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.ActorComponent.GetOwner
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AActor*                  ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class AActor* UActorComponent::GetOwner()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.GetOwner");

	struct
	{
		class AActor*                  ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.ActorComponent.GetComponentTickInterval
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UActorComponent::GetComponentTickInterval()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.GetComponentTickInterval");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.ActorComponent.Deactivate
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UActorComponent::Deactivate()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.Deactivate");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ActorComponent.ComponentHasTag
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   Tag                            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UActorComponent::ComponentHasTag(const struct FName& Tag)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.ComponentHasTag");

	struct
	{
		struct FName                   Tag;
		bool                           ReturnValue;
	} params;

	params.Tag = Tag;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.ActorComponent.AddTickPrerequisiteComponent
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UActorComponent*         PrerequisiteComponent          (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)

void UActorComponent::AddTickPrerequisiteComponent(class UActorComponent* PrerequisiteComponent)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.AddTickPrerequisiteComponent");

	struct
	{
		class UActorComponent*         PrerequisiteComponent;
	} params;

	params.PrerequisiteComponent = PrerequisiteComponent;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ActorComponent.AddTickPrerequisiteActor
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class AActor*                  PrerequisiteActor              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UActorComponent::AddTickPrerequisiteActor(class AActor* PrerequisiteActor)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.AddTickPrerequisiteActor");

	struct
	{
		class AActor*                  PrerequisiteActor;
	} params;

	params.PrerequisiteActor = PrerequisiteActor;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ActorComponent.Activate
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bReset                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UActorComponent::Activate(bool bReset)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ActorComponent.Activate");

	struct
	{
		bool                           bReset;
	} params;

	params.bReset = bReset;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.MovementComponent.StopMovementImmediately
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UMovementComponent::StopMovementImmediately()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.StopMovementImmediately");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.MovementComponent.SnapUpdatedComponentToPlane
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UMovementComponent::SnapUpdatedComponentToPlane()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.SnapUpdatedComponentToPlane");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.MovementComponent.SetUpdatedComponent
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class USceneComponent*         NewUpdatedComponent            (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)

void UMovementComponent::SetUpdatedComponent(class USceneComponent* NewUpdatedComponent)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.SetUpdatedComponent");

	struct
	{
		class USceneComponent*         NewUpdatedComponent;
	} params;

	params.NewUpdatedComponent = NewUpdatedComponent;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.MovementComponent.SetPlaneConstraintOrigin
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 PlaneOrigin                    (CPF_Parm, CPF_IsPlainOldData)

void UMovementComponent::SetPlaneConstraintOrigin(const struct FVector& PlaneOrigin)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.SetPlaneConstraintOrigin");

	struct
	{
		struct FVector                 PlaneOrigin;
	} params;

	params.PlaneOrigin = PlaneOrigin;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.MovementComponent.SetPlaneConstraintNormal
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 PlaneNormal                    (CPF_Parm, CPF_IsPlainOldData)

void UMovementComponent::SetPlaneConstraintNormal(const struct FVector& PlaneNormal)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.SetPlaneConstraintNormal");

	struct
	{
		struct FVector                 PlaneNormal;
	} params;

	params.PlaneNormal = PlaneNormal;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.MovementComponent.SetPlaneConstraintFromVectors
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Forward                        (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 Up                             (CPF_Parm, CPF_IsPlainOldData)

void UMovementComponent::SetPlaneConstraintFromVectors(const struct FVector& Forward, const struct FVector& Up)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.SetPlaneConstraintFromVectors");

	struct
	{
		struct FVector                 Forward;
		struct FVector                 Up;
	} params;

	params.Forward = Forward;
	params.Up = Up;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.MovementComponent.SetPlaneConstraintEnabled
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bEnabled                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UMovementComponent::SetPlaneConstraintEnabled(bool bEnabled)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.SetPlaneConstraintEnabled");

	struct
	{
		bool                           bEnabled;
	} params;

	params.bEnabled = bEnabled;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.MovementComponent.SetPlaneConstraintAxisSetting
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// EPlaneConstraintAxisSetting    NewAxisSetting                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UMovementComponent::SetPlaneConstraintAxisSetting(EPlaneConstraintAxisSetting NewAxisSetting)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.SetPlaneConstraintAxisSetting");

	struct
	{
		EPlaneConstraintAxisSetting    NewAxisSetting;
	} params;

	params.NewAxisSetting = NewAxisSetting;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.MovementComponent.PhysicsVolumeChanged
// (FUNC_Native, FUNC_Public)
// Parameters:
// class APhysicsVolume*          NewVolume                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UMovementComponent::PhysicsVolumeChanged(class APhysicsVolume* NewVolume)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.PhysicsVolumeChanged");

	struct
	{
		class APhysicsVolume*          NewVolume;
	} params;

	params.NewVolume = NewVolume;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.MovementComponent.K2_MoveUpdatedComponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Delta                          (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                NewRotation                    (CPF_Parm, CPF_IsPlainOldData)
// struct FHitResult              OutHit                         (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UMovementComponent::K2_MoveUpdatedComponent(const struct FVector& Delta, const struct FRotator& NewRotation, bool bSweep, bool bTeleport, struct FHitResult* OutHit)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.K2_MoveUpdatedComponent");

	struct
	{
		struct FVector                 Delta;
		struct FRotator                NewRotation;
		struct FHitResult              OutHit;
		bool                           bSweep;
		bool                           bTeleport;
		bool                           ReturnValue;
	} params;

	params.Delta = Delta;
	params.NewRotation = NewRotation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (OutHit != nullptr)
		*OutHit = params.OutHit;

	return params.ReturnValue;
}


// Function Engine.MovementComponent.K2_GetModifiedMaxSpeed
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UMovementComponent::K2_GetModifiedMaxSpeed()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.K2_GetModifiedMaxSpeed");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.MovementComponent.K2_GetMaxSpeedModifier
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UMovementComponent::K2_GetMaxSpeedModifier()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.K2_GetMaxSpeedModifier");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.MovementComponent.IsExceedingMaxSpeed
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          MaxSpeed                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UMovementComponent::IsExceedingMaxSpeed(float MaxSpeed)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.IsExceedingMaxSpeed");

	struct
	{
		float                          MaxSpeed;
		bool                           ReturnValue;
	} params;

	params.MaxSpeed = MaxSpeed;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.MovementComponent.GetPlaneConstraintOrigin
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_ReferenceParm, CPF_IsPlainOldData)

struct FVector UMovementComponent::GetPlaneConstraintOrigin()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.GetPlaneConstraintOrigin");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.MovementComponent.GetPlaneConstraintNormal
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_ReferenceParm, CPF_IsPlainOldData)

struct FVector UMovementComponent::GetPlaneConstraintNormal()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.GetPlaneConstraintNormal");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.MovementComponent.GetPlaneConstraintAxisSetting
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// EPlaneConstraintAxisSetting    ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

EPlaneConstraintAxisSetting UMovementComponent::GetPlaneConstraintAxisSetting()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.GetPlaneConstraintAxisSetting");

	struct
	{
		EPlaneConstraintAxisSetting    ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.MovementComponent.GetPhysicsVolume
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class APhysicsVolume*          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class APhysicsVolume* UMovementComponent::GetPhysicsVolume()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.GetPhysicsVolume");

	struct
	{
		class APhysicsVolume*          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.MovementComponent.GetMaxSpeed
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UMovementComponent::GetMaxSpeed()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.GetMaxSpeed");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.MovementComponent.GetGravityZ
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UMovementComponent::GetGravityZ()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.GetGravityZ");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.MovementComponent.ConstrainNormalToPlane
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 Normal                         (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UMovementComponent::ConstrainNormalToPlane(const struct FVector& Normal)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.ConstrainNormalToPlane");

	struct
	{
		struct FVector                 Normal;
		struct FVector                 ReturnValue;
	} params;

	params.Normal = Normal;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.MovementComponent.ConstrainLocationToPlane
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 Location                       (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UMovementComponent::ConstrainLocationToPlane(const struct FVector& Location)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.ConstrainLocationToPlane");

	struct
	{
		struct FVector                 Location;
		struct FVector                 ReturnValue;
	} params;

	params.Location = Location;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.MovementComponent.ConstrainDirectionToPlane
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 Direction                      (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UMovementComponent::ConstrainDirectionToPlane(const struct FVector& Direction)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MovementComponent.ConstrainDirectionToPlane");

	struct
	{
		struct FVector                 Direction;
		struct FVector                 ReturnValue;
	} params;

	params.Direction = Direction;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.NavMovementComponent.StopMovementKeepPathing
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UNavMovementComponent::StopMovementKeepPathing()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.NavMovementComponent.StopMovementKeepPathing");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.NavMovementComponent.StopActiveMovement
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UNavMovementComponent::StopActiveMovement()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.NavMovementComponent.StopActiveMovement");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.NavMovementComponent.IsSwimming
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UNavMovementComponent::IsSwimming()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.NavMovementComponent.IsSwimming");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.NavMovementComponent.IsMovingOnGround
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UNavMovementComponent::IsMovingOnGround()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.NavMovementComponent.IsMovingOnGround");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.NavMovementComponent.IsFlying
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UNavMovementComponent::IsFlying()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.NavMovementComponent.IsFlying");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.NavMovementComponent.IsFalling
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UNavMovementComponent::IsFalling()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.NavMovementComponent.IsFalling");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.NavMovementComponent.IsCrouching
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UNavMovementComponent::IsCrouching()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.NavMovementComponent.IsCrouching");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PawnMovementComponent.K2_GetInputVector
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UPawnMovementComponent::K2_GetInputVector()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PawnMovementComponent.K2_GetInputVector");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PawnMovementComponent.IsMoveInputIgnored
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UPawnMovementComponent::IsMoveInputIgnored()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PawnMovementComponent.IsMoveInputIgnored");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PawnMovementComponent.GetPendingInputVector
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UPawnMovementComponent::GetPendingInputVector()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PawnMovementComponent.GetPendingInputVector");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PawnMovementComponent.GetPawnOwner
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class APawn*                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class APawn* UPawnMovementComponent::GetPawnOwner()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PawnMovementComponent.GetPawnOwner");

	struct
	{
		class APawn*                   ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PawnMovementComponent.GetLastInputVector
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UPawnMovementComponent::GetLastInputVector()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PawnMovementComponent.GetLastInputVector");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PawnMovementComponent.ConsumeInputVector
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UPawnMovementComponent::ConsumeInputVector()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PawnMovementComponent.ConsumeInputVector");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PawnMovementComponent.AddInputVector
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 WorldVector                    (CPF_Parm, CPF_IsPlainOldData)
// bool                           bForce                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPawnMovementComponent::AddInputVector(const struct FVector& WorldVector, bool bForce)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PawnMovementComponent.AddInputVector");

	struct
	{
		struct FVector                 WorldVector;
		bool                           bForce;
	} params;

	params.WorldVector = WorldVector;
	params.bForce = bForce;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CharacterMovementComponent.SetWalkableFloorZ
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InWalkableFloorZ               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCharacterMovementComponent::SetWalkableFloorZ(float InWalkableFloorZ)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.SetWalkableFloorZ");

	struct
	{
		float                          InWalkableFloorZ;
	} params;

	params.InWalkableFloorZ = InWalkableFloorZ;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CharacterMovementComponent.SetWalkableFloorAngle
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InWalkableFloorAngle           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCharacterMovementComponent::SetWalkableFloorAngle(float InWalkableFloorAngle)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.SetWalkableFloorAngle");

	struct
	{
		float                          InWalkableFloorAngle;
	} params;

	params.InWalkableFloorAngle = InWalkableFloorAngle;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CharacterMovementComponent.SetMovementMode
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// TEnumAsByte<EMovementMode>     NewMovementMode                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// unsigned char                  NewCustomMode                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCharacterMovementComponent::SetMovementMode(TEnumAsByte<EMovementMode> NewMovementMode, unsigned char NewCustomMode)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.SetMovementMode");

	struct
	{
		TEnumAsByte<EMovementMode>     NewMovementMode;
		unsigned char                  NewCustomMode;
	} params;

	params.NewMovementMode = NewMovementMode;
	params.NewCustomMode = NewCustomMode;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CharacterMovementComponent.SetGroupsToIgnoreMask
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// struct FNavAvoidanceMask       GroupMask                      (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)

void UCharacterMovementComponent::SetGroupsToIgnoreMask(const struct FNavAvoidanceMask& GroupMask)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.SetGroupsToIgnoreMask");

	struct
	{
		struct FNavAvoidanceMask       GroupMask;
	} params;

	params.GroupMask = GroupMask;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CharacterMovementComponent.SetGroupsToIgnore
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            GroupFlags                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCharacterMovementComponent::SetGroupsToIgnore(int GroupFlags)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.SetGroupsToIgnore");

	struct
	{
		int                            GroupFlags;
	} params;

	params.GroupFlags = GroupFlags;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CharacterMovementComponent.SetGroupsToAvoidMask
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// struct FNavAvoidanceMask       GroupMask                      (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)

void UCharacterMovementComponent::SetGroupsToAvoidMask(const struct FNavAvoidanceMask& GroupMask)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.SetGroupsToAvoidMask");

	struct
	{
		struct FNavAvoidanceMask       GroupMask;
	} params;

	params.GroupMask = GroupMask;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CharacterMovementComponent.SetGroupsToAvoid
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            GroupFlags                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCharacterMovementComponent::SetGroupsToAvoid(int GroupFlags)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.SetGroupsToAvoid");

	struct
	{
		int                            GroupFlags;
	} params;

	params.GroupFlags = GroupFlags;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CharacterMovementComponent.SetAvoidanceGroupMask
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// struct FNavAvoidanceMask       GroupMask                      (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)

void UCharacterMovementComponent::SetAvoidanceGroupMask(const struct FNavAvoidanceMask& GroupMask)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.SetAvoidanceGroupMask");

	struct
	{
		struct FNavAvoidanceMask       GroupMask;
	} params;

	params.GroupMask = GroupMask;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CharacterMovementComponent.SetAvoidanceGroup
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            GroupFlags                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCharacterMovementComponent::SetAvoidanceGroup(int GroupFlags)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.SetAvoidanceGroup");

	struct
	{
		int                            GroupFlags;
	} params;

	params.GroupFlags = GroupFlags;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CharacterMovementComponent.SetAvoidanceEnabled
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bEnable                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCharacterMovementComponent::SetAvoidanceEnabled(bool bEnable)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.SetAvoidanceEnabled");

	struct
	{
		bool                           bEnable;
	} params;

	params.bEnable = bEnable;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CharacterMovementComponent.K2_GetWalkableFloorZ
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCharacterMovementComponent::K2_GetWalkableFloorZ()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.K2_GetWalkableFloorZ");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CharacterMovementComponent.K2_GetWalkableFloorAngle
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCharacterMovementComponent::K2_GetWalkableFloorAngle()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.K2_GetWalkableFloorAngle");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CharacterMovementComponent.K2_GetModifiedMaxAcceleration
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCharacterMovementComponent::K2_GetModifiedMaxAcceleration()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.K2_GetModifiedMaxAcceleration");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CharacterMovementComponent.K2_FindFloor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 CapsuleLocation                (CPF_Parm, CPF_IsPlainOldData)
// struct FFindFloorResult        FloorResult                    (CPF_Parm, CPF_OutParm)

void UCharacterMovementComponent::K2_FindFloor(const struct FVector& CapsuleLocation, struct FFindFloorResult* FloorResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.K2_FindFloor");

	struct
	{
		struct FVector                 CapsuleLocation;
		struct FFindFloorResult        FloorResult;
	} params;

	params.CapsuleLocation = CapsuleLocation;

	UObject::ProcessEvent(fn, &params);

	if (FloorResult != nullptr)
		*FloorResult = params.FloorResult;
}


// Function Engine.CharacterMovementComponent.K2_ComputeFloorDist
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 CapsuleLocation                (CPF_Parm, CPF_IsPlainOldData)
// float                          LineDistance                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          SweepDistance                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          SweepRadius                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FFindFloorResult        FloorResult                    (CPF_Parm, CPF_OutParm)

void UCharacterMovementComponent::K2_ComputeFloorDist(const struct FVector& CapsuleLocation, float LineDistance, float SweepDistance, float SweepRadius, struct FFindFloorResult* FloorResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.K2_ComputeFloorDist");

	struct
	{
		struct FVector                 CapsuleLocation;
		float                          LineDistance;
		float                          SweepDistance;
		float                          SweepRadius;
		struct FFindFloorResult        FloorResult;
	} params;

	params.CapsuleLocation = CapsuleLocation;
	params.LineDistance = LineDistance;
	params.SweepDistance = SweepDistance;
	params.SweepRadius = SweepRadius;

	UObject::ProcessEvent(fn, &params);

	if (FloorResult != nullptr)
		*FloorResult = params.FloorResult;
}


// Function Engine.CharacterMovementComponent.IsWalking
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UCharacterMovementComponent::IsWalking()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.IsWalking");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CharacterMovementComponent.IsWalkable
// (FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FHitResult              Hit                            (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UCharacterMovementComponent::IsWalkable(const struct FHitResult& Hit)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.IsWalkable");

	struct
	{
		struct FHitResult              Hit;
		bool                           ReturnValue;
	} params;

	params.Hit = Hit;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CharacterMovementComponent.GetValidPerchRadius
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCharacterMovementComponent::GetValidPerchRadius()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.GetValidPerchRadius");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CharacterMovementComponent.GetPerchRadiusThreshold
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCharacterMovementComponent::GetPerchRadiusThreshold()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.GetPerchRadiusThreshold");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CharacterMovementComponent.GetMovementBase
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UPrimitiveComponent*     ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_InstancedReference, CPF_IsPlainOldData)

class UPrimitiveComponent* UCharacterMovementComponent::GetMovementBase()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.GetMovementBase");

	struct
	{
		class UPrimitiveComponent*     ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CharacterMovementComponent.GetMinAnalogSpeed
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCharacterMovementComponent::GetMinAnalogSpeed()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.GetMinAnalogSpeed");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CharacterMovementComponent.GetMaxJumpHeightWithJumpTime
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCharacterMovementComponent::GetMaxJumpHeightWithJumpTime()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.GetMaxJumpHeightWithJumpTime");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CharacterMovementComponent.GetMaxJumpHeight
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCharacterMovementComponent::GetMaxJumpHeight()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.GetMaxJumpHeight");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CharacterMovementComponent.GetMaxBrakingDeceleration
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCharacterMovementComponent::GetMaxBrakingDeceleration()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.GetMaxBrakingDeceleration");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CharacterMovementComponent.GetMaxAcceleration
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCharacterMovementComponent::GetMaxAcceleration()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.GetMaxAcceleration");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CharacterMovementComponent.GetImpartedMovementBaseVelocity
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UCharacterMovementComponent::GetImpartedMovementBaseVelocity()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.GetImpartedMovementBaseVelocity");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CharacterMovementComponent.GetCurrentAcceleration
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UCharacterMovementComponent::GetCurrentAcceleration()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.GetCurrentAcceleration");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CharacterMovementComponent.GetCharacterOwner
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class ACharacter*              ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class ACharacter* UCharacterMovementComponent::GetCharacterOwner()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.GetCharacterOwner");

	struct
	{
		class ACharacter*              ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CharacterMovementComponent.GetAnalogInputModifier
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCharacterMovementComponent::GetAnalogInputModifier()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.GetAnalogInputModifier");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CharacterMovementComponent.DisableMovement
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UCharacterMovementComponent::DisableMovement()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.DisableMovement");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CharacterMovementComponent.ClearAccumulatedForces
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UCharacterMovementComponent::ClearAccumulatedForces()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.ClearAccumulatedForces");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CharacterMovementComponent.CapsuleTouched
// (FUNC_Native, FUNC_Protected, FUNC_HasOutParms)
// Parameters:
// class UPrimitiveComponent*     OverlappedComp                 (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// class AActor*                  Other                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UPrimitiveComponent*     OtherComp                      (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// int                            OtherBodyIndex                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bFromSweep                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepResult                    (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)

void UCharacterMovementComponent::CapsuleTouched(class UPrimitiveComponent* OverlappedComp, class AActor* Other, class UPrimitiveComponent* OtherComp, int OtherBodyIndex, bool bFromSweep, const struct FHitResult& SweepResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.CapsuleTouched");

	struct
	{
		class UPrimitiveComponent*     OverlappedComp;
		class AActor*                  Other;
		class UPrimitiveComponent*     OtherComp;
		int                            OtherBodyIndex;
		bool                           bFromSweep;
		struct FHitResult              SweepResult;
	} params;

	params.OverlappedComp = OverlappedComp;
	params.Other = Other;
	params.OtherComp = OtherComp;
	params.OtherBodyIndex = OtherBodyIndex;
	params.bFromSweep = bFromSweep;
	params.SweepResult = SweepResult;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CharacterMovementComponent.CalcVelocity
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          DeltaTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Friction                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bFluid                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          BrakingDeceleration            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCharacterMovementComponent::CalcVelocity(float DeltaTime, float Friction, bool bFluid, float BrakingDeceleration)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.CalcVelocity");

	struct
	{
		float                          DeltaTime;
		float                          Friction;
		bool                           bFluid;
		float                          BrakingDeceleration;
	} params;

	params.DeltaTime = DeltaTime;
	params.Friction = Friction;
	params.bFluid = bFluid;
	params.BrakingDeceleration = BrakingDeceleration;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CharacterMovementComponent.AddImpulse
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Impulse                        (CPF_Parm, CPF_IsPlainOldData)
// bool                           bVelocityChange                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCharacterMovementComponent::AddImpulse(const struct FVector& Impulse, bool bVelocityChange)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.AddImpulse");

	struct
	{
		struct FVector                 Impulse;
		bool                           bVelocityChange;
	} params;

	params.Impulse = Impulse;
	params.bVelocityChange = bVelocityChange;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CharacterMovementComponent.AddForce
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Force                          (CPF_Parm, CPF_IsPlainOldData)

void UCharacterMovementComponent::AddForce(const struct FVector& Force)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CharacterMovementComponent.AddForce");

	struct
	{
		struct FVector                 Force;
	} params;

	params.Force = Force;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Controller.UnPossess
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AController::UnPossess()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.UnPossess");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Controller.StopMovement
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AController::StopMovement()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.StopMovement");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Controller.SetInitialLocationAndRotation
// (FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewLocation                    (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// struct FRotator                NewRotation                    (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)

void AController::SetInitialLocationAndRotation(const struct FVector& NewLocation, const struct FRotator& NewRotation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.SetInitialLocationAndRotation");

	struct
	{
		struct FVector                 NewLocation;
		struct FRotator                NewRotation;
	} params;

	params.NewLocation = NewLocation;
	params.NewRotation = NewRotation;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Controller.SetIgnoreMoveInput
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewMoveInput                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AController::SetIgnoreMoveInput(bool bNewMoveInput)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.SetIgnoreMoveInput");

	struct
	{
		bool                           bNewMoveInput;
	} params;

	params.bNewMoveInput = bNewMoveInput;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Controller.SetIgnoreLookInput
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewLookInput                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AController::SetIgnoreLookInput(bool bNewLookInput)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.SetIgnoreLookInput");

	struct
	{
		bool                           bNewLookInput;
	} params;

	params.bNewLookInput = bNewLookInput;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Controller.SetControlRotation
// (FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FRotator                NewRotation                    (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)

void AController::SetControlRotation(const struct FRotator& NewRotation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.SetControlRotation");

	struct
	{
		struct FRotator                NewRotation;
	} params;

	params.NewRotation = NewRotation;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Controller.ResetIgnoreMoveInput
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AController::ResetIgnoreMoveInput()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.ResetIgnoreMoveInput");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Controller.ResetIgnoreLookInput
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AController::ResetIgnoreLookInput()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.ResetIgnoreLookInput");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Controller.ResetIgnoreInputFlags
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AController::ResetIgnoreInputFlags()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.ResetIgnoreInputFlags");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Controller.ReceiveInstigatedAnyDamage
// (FUNC_BlueprintAuthorityOnly, FUNC_Event, FUNC_Protected, FUNC_BlueprintEvent)
// Parameters:
// float                          Damage                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UDamageType*             DamageType                     (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class AActor*                  DamagedActor                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class AActor*                  DamageCauser                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AController::ReceiveInstigatedAnyDamage(float Damage, class UDamageType* DamageType, class AActor* DamagedActor, class AActor* DamageCauser)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.ReceiveInstigatedAnyDamage");

	struct
	{
		float                          Damage;
		class UDamageType*             DamageType;
		class AActor*                  DamagedActor;
		class AActor*                  DamageCauser;
	} params;

	params.Damage = Damage;
	params.DamageType = DamageType;
	params.DamagedActor = DamagedActor;
	params.DamageCauser = DamageCauser;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Controller.Possess
// (FUNC_BlueprintAuthorityOnly, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class APawn*                   InPawn                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AController::Possess(class APawn* InPawn)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.Possess");

	struct
	{
		class APawn*                   InPawn;
	} params;

	params.InPawn = InPawn;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Controller.OnRep_PlayerState
// (FUNC_Native, FUNC_Public)

void AController::OnRep_PlayerState()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.OnRep_PlayerState");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Controller.OnRep_Pawn
// (FUNC_Native, FUNC_Public)

void AController::OnRep_Pawn()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.OnRep_Pawn");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Controller.LineOfSightTo
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AActor*                  Other                          (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 ViewPoint                      (CPF_Parm, CPF_IsPlainOldData)
// bool                           bAlternateChecks               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AController::LineOfSightTo(class AActor* Other, const struct FVector& ViewPoint, bool bAlternateChecks)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.LineOfSightTo");

	struct
	{
		class AActor*                  Other;
		struct FVector                 ViewPoint;
		bool                           bAlternateChecks;
		bool                           ReturnValue;
	} params;

	params.Other = Other;
	params.ViewPoint = ViewPoint;
	params.bAlternateChecks = bAlternateChecks;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Controller.K2_GetPawn
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class APawn*                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class APawn* AController::K2_GetPawn()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.K2_GetPawn");

	struct
	{
		class APawn*                   ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Controller.IsPlayerController
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AController::IsPlayerController()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.IsPlayerController");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Controller.IsMoveInputIgnored
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AController::IsMoveInputIgnored()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.IsMoveInputIgnored");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Controller.IsLookInputIgnored
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AController::IsLookInputIgnored()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.IsLookInputIgnored");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Controller.IsLocalPlayerController
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AController::IsLocalPlayerController()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.IsLocalPlayerController");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Controller.IsLocalController
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AController::IsLocalController()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.IsLocalController");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Controller.GetViewTarget
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AActor*                  ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class AActor* AController::GetViewTarget()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.GetViewTarget");

	struct
	{
		class AActor*                  ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Controller.GetDesiredRotation
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FRotator                ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FRotator AController::GetDesiredRotation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.GetDesiredRotation");

	struct
	{
		struct FRotator                ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Controller.GetControlRotation
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FRotator                ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FRotator AController::GetControlRotation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.GetControlRotation");

	struct
	{
		struct FRotator                ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Controller.ClientSetRotation
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_HasDefaults, FUNC_NetClient)
// Parameters:
// struct FRotator                NewRotation                    (CPF_Parm, CPF_IsPlainOldData)
// bool                           bResetCamera                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AController::ClientSetRotation(const struct FRotator& NewRotation, bool bResetCamera)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.ClientSetRotation");

	struct
	{
		struct FRotator                NewRotation;
		bool                           bResetCamera;
	} params;

	params.NewRotation = NewRotation;
	params.bResetCamera = bResetCamera;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Controller.ClientSetLocation
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_HasDefaults, FUNC_NetClient)
// Parameters:
// struct FVector                 NewLocation                    (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                NewRotation                    (CPF_Parm, CPF_IsPlainOldData)

void AController::ClientSetLocation(const struct FVector& NewLocation, const struct FRotator& NewRotation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.ClientSetLocation");

	struct
	{
		struct FVector                 NewLocation;
		struct FRotator                NewRotation;
	} params;

	params.NewLocation = NewLocation;
	params.NewRotation = NewRotation;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Controller.CastToPlayerController
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class APlayerController*       ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class APlayerController* AController::CastToPlayerController()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Controller.CastToPlayerController");

	struct
	{
		class APlayerController*       ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.ToggleVisibility
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bPropagateToChildren           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::ToggleVisibility(bool bPropagateToChildren)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.ToggleVisibility");

	struct
	{
		bool                           bPropagateToChildren;
	} params;

	params.bPropagateToChildren = bPropagateToChildren;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SceneComponent.SnapTo
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class USceneComponent*         InParent                       (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FName                   InSocketName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool USceneComponent::SnapTo(class USceneComponent* InParent, const struct FName& InSocketName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.SnapTo");

	struct
	{
		class USceneComponent*         InParent;
		struct FName                   InSocketName;
		bool                           ReturnValue;
	} params;

	params.InParent = InParent;
	params.InSocketName = InSocketName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.SetWorldScale3D
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewScale                       (CPF_Parm, CPF_IsPlainOldData)

void USceneComponent::SetWorldScale3D(const struct FVector& NewScale)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.SetWorldScale3D");

	struct
	{
		struct FVector                 NewScale;
	} params;

	params.NewScale = NewScale;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SceneComponent.SetVisibility
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewVisibility                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bPropagateToChildren           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::SetVisibility(bool bNewVisibility, bool bPropagateToChildren)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.SetVisibility");

	struct
	{
		bool                           bNewVisibility;
		bool                           bPropagateToChildren;
	} params;

	params.bNewVisibility = bNewVisibility;
	params.bPropagateToChildren = bPropagateToChildren;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SceneComponent.SetRelativeScale3D
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewScale3D                     (CPF_Parm, CPF_IsPlainOldData)

void USceneComponent::SetRelativeScale3D(const struct FVector& NewScale3D)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.SetRelativeScale3D");

	struct
	{
		struct FVector                 NewScale3D;
	} params;

	params.NewScale3D = NewScale3D;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SceneComponent.SetHiddenInGame
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           NewHidden                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bPropagateToChildren           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::SetHiddenInGame(bool NewHidden, bool bPropagateToChildren)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.SetHiddenInGame");

	struct
	{
		bool                           NewHidden;
		bool                           bPropagateToChildren;
	} params;

	params.NewHidden = NewHidden;
	params.bPropagateToChildren = bPropagateToChildren;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SceneComponent.SetAbsolute
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewAbsoluteLocation           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bNewAbsoluteRotation           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bNewAbsoluteScale              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::SetAbsolute(bool bNewAbsoluteLocation, bool bNewAbsoluteRotation, bool bNewAbsoluteScale)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.SetAbsolute");

	struct
	{
		bool                           bNewAbsoluteLocation;
		bool                           bNewAbsoluteRotation;
		bool                           bNewAbsoluteScale;
	} params;

	params.bNewAbsoluteLocation = bNewAbsoluteLocation;
	params.bNewAbsoluteRotation = bNewAbsoluteRotation;
	params.bNewAbsoluteScale = bNewAbsoluteScale;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SceneComponent.ResetRelativeTransform
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void USceneComponent::ResetRelativeTransform()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.ResetRelativeTransform");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SceneComponent.OnRep_Visibility
// (FUNC_Final, FUNC_Native, FUNC_Private)
// Parameters:
// bool                           OldValue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::OnRep_Visibility(bool OldValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.OnRep_Visibility");

	struct
	{
		bool                           OldValue;
	} params;

	params.OldValue = OldValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SceneComponent.OnRep_Transform
// (FUNC_Final, FUNC_Native, FUNC_Private)

void USceneComponent::OnRep_Transform()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.OnRep_Transform");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SceneComponent.OnRep_AttachSocketName
// (FUNC_Final, FUNC_Native, FUNC_Private)

void USceneComponent::OnRep_AttachSocketName()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.OnRep_AttachSocketName");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SceneComponent.OnRep_AttachParent
// (FUNC_Final, FUNC_Native, FUNC_Private)

void USceneComponent::OnRep_AttachParent()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.OnRep_AttachParent");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SceneComponent.OnRep_AttachChildren
// (FUNC_Final, FUNC_Native, FUNC_Private)

void USceneComponent::OnRep_AttachChildren()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.OnRep_AttachChildren");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SceneComponent.K2_SetWorldTransform
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FTransform              NewTransform                   (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::K2_SetWorldTransform(const struct FTransform& NewTransform, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_SetWorldTransform");

	struct
	{
		struct FTransform              NewTransform;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.NewTransform = NewTransform;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.SceneComponent.K2_SetWorldRotation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FRotator                NewRotation                    (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::K2_SetWorldRotation(const struct FRotator& NewRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_SetWorldRotation");

	struct
	{
		struct FRotator                NewRotation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.NewRotation = NewRotation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.SceneComponent.K2_SetWorldLocationAndRotation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewLocation                    (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                NewRotation                    (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::K2_SetWorldLocationAndRotation(const struct FVector& NewLocation, const struct FRotator& NewRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_SetWorldLocationAndRotation");

	struct
	{
		struct FVector                 NewLocation;
		struct FRotator                NewRotation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.NewLocation = NewLocation;
	params.NewRotation = NewRotation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.SceneComponent.K2_SetWorldLocation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewLocation                    (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::K2_SetWorldLocation(const struct FVector& NewLocation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_SetWorldLocation");

	struct
	{
		struct FVector                 NewLocation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.NewLocation = NewLocation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.SceneComponent.K2_SetRelativeTransform
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FTransform              NewTransform                   (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::K2_SetRelativeTransform(const struct FTransform& NewTransform, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_SetRelativeTransform");

	struct
	{
		struct FTransform              NewTransform;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.NewTransform = NewTransform;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.SceneComponent.K2_SetRelativeRotation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FRotator                NewRotation                    (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::K2_SetRelativeRotation(const struct FRotator& NewRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_SetRelativeRotation");

	struct
	{
		struct FRotator                NewRotation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.NewRotation = NewRotation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.SceneComponent.K2_SetRelativeLocationAndRotation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewLocation                    (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                NewRotation                    (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::K2_SetRelativeLocationAndRotation(const struct FVector& NewLocation, const struct FRotator& NewRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_SetRelativeLocationAndRotation");

	struct
	{
		struct FVector                 NewLocation;
		struct FRotator                NewRotation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.NewLocation = NewLocation;
	params.NewRotation = NewRotation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.SceneComponent.K2_SetRelativeLocation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewLocation                    (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::K2_SetRelativeLocation(const struct FVector& NewLocation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_SetRelativeLocation");

	struct
	{
		struct FVector                 NewLocation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.NewLocation = NewLocation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.SceneComponent.K2_GetComponentToWorld
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FTransform              ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FTransform USceneComponent::K2_GetComponentToWorld()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_GetComponentToWorld");

	struct
	{
		struct FTransform              ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.K2_GetComponentScale
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector USceneComponent::K2_GetComponentScale()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_GetComponentScale");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.K2_GetComponentRotation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FRotator                ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FRotator USceneComponent::K2_GetComponentRotation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_GetComponentRotation");

	struct
	{
		struct FRotator                ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.K2_GetComponentLocation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector USceneComponent::K2_GetComponentLocation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_GetComponentLocation");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.K2_DetachFromComponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// EDetachmentRule                LocationRule                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// EDetachmentRule                RotationRule                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// EDetachmentRule                ScaleRule                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bCallModify                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::K2_DetachFromComponent(EDetachmentRule LocationRule, EDetachmentRule RotationRule, EDetachmentRule ScaleRule, bool bCallModify)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_DetachFromComponent");

	struct
	{
		EDetachmentRule                LocationRule;
		EDetachmentRule                RotationRule;
		EDetachmentRule                ScaleRule;
		bool                           bCallModify;
	} params;

	params.LocationRule = LocationRule;
	params.RotationRule = RotationRule;
	params.ScaleRule = ScaleRule;
	params.bCallModify = bCallModify;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SceneComponent.K2_AttachToComponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class USceneComponent*         Parent                         (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FName                   SocketName                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// EAttachmentRule                LocationRule                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// EAttachmentRule                RotationRule                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// EAttachmentRule                ScaleRule                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bWeldSimulatedBodies           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool USceneComponent::K2_AttachToComponent(class USceneComponent* Parent, const struct FName& SocketName, EAttachmentRule LocationRule, EAttachmentRule RotationRule, EAttachmentRule ScaleRule, bool bWeldSimulatedBodies)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_AttachToComponent");

	struct
	{
		class USceneComponent*         Parent;
		struct FName                   SocketName;
		EAttachmentRule                LocationRule;
		EAttachmentRule                RotationRule;
		EAttachmentRule                ScaleRule;
		bool                           bWeldSimulatedBodies;
		bool                           ReturnValue;
	} params;

	params.Parent = Parent;
	params.SocketName = SocketName;
	params.LocationRule = LocationRule;
	params.RotationRule = RotationRule;
	params.ScaleRule = ScaleRule;
	params.bWeldSimulatedBodies = bWeldSimulatedBodies;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.K2_AttachTo
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class USceneComponent*         InParent                       (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FName                   InSocketName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TEnumAsByte<EAttachLocation>   AttachType                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bWeldSimulatedBodies           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool USceneComponent::K2_AttachTo(class USceneComponent* InParent, const struct FName& InSocketName, TEnumAsByte<EAttachLocation> AttachType, bool bWeldSimulatedBodies)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_AttachTo");

	struct
	{
		class USceneComponent*         InParent;
		struct FName                   InSocketName;
		TEnumAsByte<EAttachLocation>   AttachType;
		bool                           bWeldSimulatedBodies;
		bool                           ReturnValue;
	} params;

	params.InParent = InParent;
	params.InSocketName = InSocketName;
	params.AttachType = AttachType;
	params.bWeldSimulatedBodies = bWeldSimulatedBodies;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.K2_AddWorldTransform
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FTransform              DeltaTransform                 (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::K2_AddWorldTransform(const struct FTransform& DeltaTransform, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_AddWorldTransform");

	struct
	{
		struct FTransform              DeltaTransform;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.DeltaTransform = DeltaTransform;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.SceneComponent.K2_AddWorldRotation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FRotator                DeltaRotation                  (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::K2_AddWorldRotation(const struct FRotator& DeltaRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_AddWorldRotation");

	struct
	{
		struct FRotator                DeltaRotation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.DeltaRotation = DeltaRotation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.SceneComponent.K2_AddWorldOffset
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 DeltaLocation                  (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::K2_AddWorldOffset(const struct FVector& DeltaLocation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_AddWorldOffset");

	struct
	{
		struct FVector                 DeltaLocation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.DeltaLocation = DeltaLocation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.SceneComponent.K2_AddRelativeRotation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FRotator                DeltaRotation                  (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::K2_AddRelativeRotation(const struct FRotator& DeltaRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_AddRelativeRotation");

	struct
	{
		struct FRotator                DeltaRotation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.DeltaRotation = DeltaRotation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.SceneComponent.K2_AddRelativeLocation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 DeltaLocation                  (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::K2_AddRelativeLocation(const struct FVector& DeltaLocation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_AddRelativeLocation");

	struct
	{
		struct FVector                 DeltaLocation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.DeltaLocation = DeltaLocation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.SceneComponent.K2_AddLocalTransform
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FTransform              DeltaTransform                 (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::K2_AddLocalTransform(const struct FTransform& DeltaTransform, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_AddLocalTransform");

	struct
	{
		struct FTransform              DeltaTransform;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.DeltaTransform = DeltaTransform;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.SceneComponent.K2_AddLocalRotation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FRotator                DeltaRotation                  (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::K2_AddLocalRotation(const struct FRotator& DeltaRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_AddLocalRotation");

	struct
	{
		struct FRotator                DeltaRotation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.DeltaRotation = DeltaRotation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.SceneComponent.K2_AddLocalOffset
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 DeltaLocation                  (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSweep                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              SweepHitResult                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::K2_AddLocalOffset(const struct FVector& DeltaLocation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.K2_AddLocalOffset");

	struct
	{
		struct FVector                 DeltaLocation;
		bool                           bSweep;
		struct FHitResult              SweepHitResult;
		bool                           bTeleport;
	} params;

	params.DeltaLocation = DeltaLocation;
	params.bSweep = bSweep;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	if (SweepHitResult != nullptr)
		*SweepHitResult = params.SweepHitResult;
}


// Function Engine.SceneComponent.IsVisible
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool USceneComponent::IsVisible()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.IsVisible");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.IsSimulatingPhysics
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool USceneComponent::IsSimulatingPhysics(const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.IsSimulatingPhysics");

	struct
	{
		struct FName                   BoneName;
		bool                           ReturnValue;
	} params;

	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.IsAnySimulatingPhysics
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool USceneComponent::IsAnySimulatingPhysics()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.IsAnySimulatingPhysics");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.GetUpVector
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector USceneComponent::GetUpVector()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.GetUpVector");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.GetSocketTransform
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   InSocketName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TEnumAsByte<ERelativeTransformSpace> TransformSpace                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FTransform              ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FTransform USceneComponent::GetSocketTransform(const struct FName& InSocketName, TEnumAsByte<ERelativeTransformSpace> TransformSpace)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.GetSocketTransform");

	struct
	{
		struct FName                   InSocketName;
		TEnumAsByte<ERelativeTransformSpace> TransformSpace;
		struct FTransform              ReturnValue;
	} params;

	params.InSocketName = InSocketName;
	params.TransformSpace = TransformSpace;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.GetSocketRotation
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   InSocketName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FRotator                ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FRotator USceneComponent::GetSocketRotation(const struct FName& InSocketName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.GetSocketRotation");

	struct
	{
		struct FName                   InSocketName;
		struct FRotator                ReturnValue;
	} params;

	params.InSocketName = InSocketName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.GetSocketQuaternion
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   InSocketName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FQuat                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FQuat USceneComponent::GetSocketQuaternion(const struct FName& InSocketName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.GetSocketQuaternion");

	struct
	{
		struct FName                   InSocketName;
		struct FQuat                   ReturnValue;
	} params;

	params.InSocketName = InSocketName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.GetSocketLocation
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   InSocketName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector USceneComponent::GetSocketLocation(const struct FName& InSocketName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.GetSocketLocation");

	struct
	{
		struct FName                   InSocketName;
		struct FVector                 ReturnValue;
	} params;

	params.InSocketName = InSocketName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.GetRightVector
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector USceneComponent::GetRightVector()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.GetRightVector");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.GetRelativeTransform
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FTransform              ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FTransform USceneComponent::GetRelativeTransform()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.GetRelativeTransform");

	struct
	{
		struct FTransform              ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.GetPhysicsVolume
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class APhysicsVolume*          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class APhysicsVolume* USceneComponent::GetPhysicsVolume()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.GetPhysicsVolume");

	struct
	{
		class APhysicsVolume*          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.GetParentComponents
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TArray<class USceneComponent*> Parents                        (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor)

void USceneComponent::GetParentComponents(TArray<class USceneComponent*>* Parents)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.GetParentComponents");

	struct
	{
		TArray<class USceneComponent*> Parents;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (Parents != nullptr)
		*Parents = params.Parents;
}


// Function Engine.SceneComponent.GetNumChildrenComponents
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// int                            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

int USceneComponent::GetNumChildrenComponents()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.GetNumChildrenComponents");

	struct
	{
		int                            ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.GetForwardVector
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector USceneComponent::GetForwardVector()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.GetForwardVector");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.GetComponentVelocity
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector USceneComponent::GetComponentVelocity()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.GetComponentVelocity");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.GetChildrenComponents
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           bIncludeAllDescendants         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TArray<class USceneComponent*> Children                       (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor)

void USceneComponent::GetChildrenComponents(bool bIncludeAllDescendants, TArray<class USceneComponent*>* Children)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.GetChildrenComponents");

	struct
	{
		bool                           bIncludeAllDescendants;
		TArray<class USceneComponent*> Children;
	} params;

	params.bIncludeAllDescendants = bIncludeAllDescendants;

	UObject::ProcessEvent(fn, &params);

	if (Children != nullptr)
		*Children = params.Children;
}


// Function Engine.SceneComponent.GetChildComponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// int                            ChildIndex                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class USceneComponent*         ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_InstancedReference, CPF_IsPlainOldData)

class USceneComponent* USceneComponent::GetChildComponent(int ChildIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.GetChildComponent");

	struct
	{
		int                            ChildIndex;
		class USceneComponent*         ReturnValue;
	} params;

	params.ChildIndex = ChildIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.GetAttachSocketName
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

struct FName USceneComponent::GetAttachSocketName()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.GetAttachSocketName");

	struct
	{
		struct FName                   ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.GetAttachParent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class USceneComponent*         ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_InstancedReference, CPF_IsPlainOldData)

class USceneComponent* USceneComponent::GetAttachParent()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.GetAttachParent");

	struct
	{
		class USceneComponent*         ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.GetAllSocketNames
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TArray<struct FName>           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm)

TArray<struct FName> USceneComponent::GetAllSocketNames()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.GetAllSocketNames");

	struct
	{
		TArray<struct FName>           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.DoesSocketExist
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   InSocketName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool USceneComponent::DoesSocketExist(const struct FName& InSocketName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.DoesSocketExist");

	struct
	{
		struct FName                   InSocketName;
		bool                           ReturnValue;
	} params;

	params.InSocketName = InSocketName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SceneComponent.DetachFromParent
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bMaintainWorldPosition         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bCallModify                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USceneComponent::DetachFromParent(bool bMaintainWorldPosition, bool bCallModify)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneComponent.DetachFromParent");

	struct
	{
		bool                           bMaintainWorldPosition;
		bool                           bCallModify;
	} params;

	params.bMaintainWorldPosition = bMaintainWorldPosition;
	params.bCallModify = bCallModify;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.WakeRigidBody
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::WakeRigidBody(const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.WakeRigidBody");

	struct
	{
		struct FName                   BoneName;
	} params;

	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.WakeAllRigidBodies
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UPrimitiveComponent::WakeAllRigidBodies()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.WakeAllRigidBodies");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetWalkableSlopeOverride
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// struct FWalkableSlopeOverride  NewOverride                    (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)

void UPrimitiveComponent::SetWalkableSlopeOverride(const struct FWalkableSlopeOverride& NewOverride)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetWalkableSlopeOverride");

	struct
	{
		struct FWalkableSlopeOverride  NewOverride;
	} params;

	params.NewOverride = NewOverride;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetUseCCD
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           InUseCCD                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetUseCCD(bool InUseCCD, const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetUseCCD");

	struct
	{
		bool                           InUseCCD;
		struct FName                   BoneName;
	} params;

	params.InUseCCD = InUseCCD;
	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetTranslucentSortPriority
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            NewTranslucentSortPriority     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetTranslucentSortPriority(int NewTranslucentSortPriority)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetTranslucentSortPriority");

	struct
	{
		int                            NewTranslucentSortPriority;
	} params;

	params.NewTranslucentSortPriority = NewTranslucentSortPriority;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetSingleSampleShadowFromStationaryLights
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewSingleSampleShadowFromStationaryLights (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetSingleSampleShadowFromStationaryLights(bool bNewSingleSampleShadowFromStationaryLights)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetSingleSampleShadowFromStationaryLights");

	struct
	{
		bool                           bNewSingleSampleShadowFromStationaryLights;
	} params;

	params.bNewSingleSampleShadowFromStationaryLights = bNewSingleSampleShadowFromStationaryLights;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetSimulatePhysics
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bSimulate                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetSimulatePhysics(bool bSimulate)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetSimulatePhysics");

	struct
	{
		bool                           bSimulate;
	} params;

	params.bSimulate = bSimulate;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetRenderInMono
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bValue                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetRenderInMono(bool bValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetRenderInMono");

	struct
	{
		bool                           bValue;
	} params;

	params.bValue = bValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetRenderInMainPass
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bValue                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetRenderInMainPass(bool bValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetRenderInMainPass");

	struct
	{
		bool                           bValue;
	} params;

	params.bValue = bValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetRenderCustomDepth
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bValue                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetRenderCustomDepth(bool bValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetRenderCustomDepth");

	struct
	{
		bool                           bValue;
	} params;

	params.bValue = bValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetReceivesDecals
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewReceivesDecals             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetReceivesDecals(bool bNewReceivesDecals)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetReceivesDecals");

	struct
	{
		bool                           bNewReceivesDecals;
	} params;

	params.bNewReceivesDecals = bNewReceivesDecals;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetPhysMaterialOverride
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UPhysicalMaterial*       NewPhysMaterial                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetPhysMaterialOverride(class UPhysicalMaterial* NewPhysMaterial)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetPhysMaterialOverride");

	struct
	{
		class UPhysicalMaterial*       NewPhysMaterial;
	} params;

	params.NewPhysMaterial = NewPhysMaterial;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetPhysicsMaxAngularVelocityInRadians
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewMaxAngVel                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAddToCurrent                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetPhysicsMaxAngularVelocityInRadians(float NewMaxAngVel, bool bAddToCurrent, const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetPhysicsMaxAngularVelocityInRadians");

	struct
	{
		float                          NewMaxAngVel;
		bool                           bAddToCurrent;
		struct FName                   BoneName;
	} params;

	params.NewMaxAngVel = NewMaxAngVel;
	params.bAddToCurrent = bAddToCurrent;
	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetPhysicsMaxAngularVelocityInDegrees
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewMaxAngVel                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAddToCurrent                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetPhysicsMaxAngularVelocityInDegrees(float NewMaxAngVel, bool bAddToCurrent, const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetPhysicsMaxAngularVelocityInDegrees");

	struct
	{
		float                          NewMaxAngVel;
		bool                           bAddToCurrent;
		struct FName                   BoneName;
	} params;

	params.NewMaxAngVel = NewMaxAngVel;
	params.bAddToCurrent = bAddToCurrent;
	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetPhysicsMaxAngularVelocity
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewMaxAngVel                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAddToCurrent                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetPhysicsMaxAngularVelocity(float NewMaxAngVel, bool bAddToCurrent, const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetPhysicsMaxAngularVelocity");

	struct
	{
		float                          NewMaxAngVel;
		bool                           bAddToCurrent;
		struct FName                   BoneName;
	} params;

	params.NewMaxAngVel = NewMaxAngVel;
	params.bAddToCurrent = bAddToCurrent;
	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetPhysicsLinearVelocity
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewVel                         (CPF_Parm, CPF_IsPlainOldData)
// bool                           bAddToCurrent                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetPhysicsLinearVelocity(const struct FVector& NewVel, bool bAddToCurrent, const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetPhysicsLinearVelocity");

	struct
	{
		struct FVector                 NewVel;
		bool                           bAddToCurrent;
		struct FName                   BoneName;
	} params;

	params.NewVel = NewVel;
	params.bAddToCurrent = bAddToCurrent;
	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetPhysicsAngularVelocityInRadians
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewAngVel                      (CPF_Parm, CPF_IsPlainOldData)
// bool                           bAddToCurrent                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetPhysicsAngularVelocityInRadians(const struct FVector& NewAngVel, bool bAddToCurrent, const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetPhysicsAngularVelocityInRadians");

	struct
	{
		struct FVector                 NewAngVel;
		bool                           bAddToCurrent;
		struct FName                   BoneName;
	} params;

	params.NewAngVel = NewAngVel;
	params.bAddToCurrent = bAddToCurrent;
	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetPhysicsAngularVelocityInDegrees
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewAngVel                      (CPF_Parm, CPF_IsPlainOldData)
// bool                           bAddToCurrent                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetPhysicsAngularVelocityInDegrees(const struct FVector& NewAngVel, bool bAddToCurrent, const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetPhysicsAngularVelocityInDegrees");

	struct
	{
		struct FVector                 NewAngVel;
		bool                           bAddToCurrent;
		struct FName                   BoneName;
	} params;

	params.NewAngVel = NewAngVel;
	params.bAddToCurrent = bAddToCurrent;
	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetPhysicsAngularVelocity
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewAngVel                      (CPF_Parm, CPF_IsPlainOldData)
// bool                           bAddToCurrent                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetPhysicsAngularVelocity(const struct FVector& NewAngVel, bool bAddToCurrent, const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetPhysicsAngularVelocity");

	struct
	{
		struct FVector                 NewAngVel;
		bool                           bAddToCurrent;
		struct FName                   BoneName;
	} params;

	params.NewAngVel = NewAngVel;
	params.bAddToCurrent = bAddToCurrent;
	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetOwnerNoSee
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewOwnerNoSee                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetOwnerNoSee(bool bNewOwnerNoSee)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetOwnerNoSee");

	struct
	{
		bool                           bNewOwnerNoSee;
	} params;

	params.bNewOwnerNoSee = bNewOwnerNoSee;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetOnlyOwnerSee
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewOnlyOwnerSee               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetOnlyOwnerSee(bool bNewOnlyOwnerSee)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetOnlyOwnerSee");

	struct
	{
		bool                           bNewOnlyOwnerSee;
	} params;

	params.bNewOnlyOwnerSee = bNewOnlyOwnerSee;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetNotifyRigidBodyCollision
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewNotifyRigidBodyCollision   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetNotifyRigidBodyCollision(bool bNewNotifyRigidBodyCollision)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetNotifyRigidBodyCollision");

	struct
	{
		bool                           bNewNotifyRigidBodyCollision;
	} params;

	params.bNewNotifyRigidBodyCollision = bNewNotifyRigidBodyCollision;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetMaterialByName
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   MaterialSlotName               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UMaterialInterface*      Material                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetMaterialByName(const struct FName& MaterialSlotName, class UMaterialInterface* Material)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetMaterialByName");

	struct
	{
		struct FName                   MaterialSlotName;
		class UMaterialInterface*      Material;
	} params;

	params.MaterialSlotName = MaterialSlotName;
	params.Material = Material;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetMaterial
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            ElementIndex                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UMaterialInterface*      Material                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetMaterial(int ElementIndex, class UMaterialInterface* Material)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetMaterial");

	struct
	{
		int                            ElementIndex;
		class UMaterialInterface*      Material;
	} params;

	params.ElementIndex = ElementIndex;
	params.Material = Material;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetMassScale
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InMassScale                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetMassScale(const struct FName& BoneName, float InMassScale)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetMassScale");

	struct
	{
		struct FName                   BoneName;
		float                          InMassScale;
	} params;

	params.BoneName = BoneName;
	params.InMassScale = InMassScale;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetMassOverrideInKg
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          MassInKg                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bOverrideMass                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetMassOverrideInKg(const struct FName& BoneName, float MassInKg, bool bOverrideMass)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetMassOverrideInKg");

	struct
	{
		struct FName                   BoneName;
		float                          MassInKg;
		bool                           bOverrideMass;
	} params;

	params.BoneName = BoneName;
	params.MassInKg = MassInKg;
	params.bOverrideMass = bOverrideMass;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetLockedAxis
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// TEnumAsByte<EDOFMode>          LockedAxis                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetLockedAxis(TEnumAsByte<EDOFMode> LockedAxis)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetLockedAxis");

	struct
	{
		TEnumAsByte<EDOFMode>          LockedAxis;
	} params;

	params.LockedAxis = LockedAxis;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetLinearDamping
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InDamping                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetLinearDamping(float InDamping)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetLinearDamping");

	struct
	{
		float                          InDamping;
	} params;

	params.InDamping = InDamping;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetEnableGravity
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bGravityEnabled                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetEnableGravity(bool bGravityEnabled)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetEnableGravity");

	struct
	{
		bool                           bGravityEnabled;
	} params;

	params.bGravityEnabled = bGravityEnabled;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetCustomDepthStencilWriteMask
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// ERendererStencilMask           WriteMaskBit                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetCustomDepthStencilWriteMask(ERendererStencilMask WriteMaskBit)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetCustomDepthStencilWriteMask");

	struct
	{
		ERendererStencilMask           WriteMaskBit;
	} params;

	params.WriteMaskBit = WriteMaskBit;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetCustomDepthStencilValue
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            Value                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetCustomDepthStencilValue(int Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetCustomDepthStencilValue");

	struct
	{
		int                            Value;
	} params;

	params.Value = Value;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetCullDistance
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewCullDistance                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetCullDistance(float NewCullDistance)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetCullDistance");

	struct
	{
		float                          NewCullDistance;
	} params;

	params.NewCullDistance = NewCullDistance;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetConstraintMode
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// TEnumAsByte<EDOFMode>          ConstraintMode                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetConstraintMode(TEnumAsByte<EDOFMode> ConstraintMode)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetConstraintMode");

	struct
	{
		TEnumAsByte<EDOFMode>          ConstraintMode;
	} params;

	params.ConstraintMode = ConstraintMode;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetCollisionResponseToChannel
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// TEnumAsByte<ECollisionChannel> Channel                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TEnumAsByte<ECollisionResponse> NewResponse                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetCollisionResponseToChannel(TEnumAsByte<ECollisionChannel> Channel, TEnumAsByte<ECollisionResponse> NewResponse)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetCollisionResponseToChannel");

	struct
	{
		TEnumAsByte<ECollisionChannel> Channel;
		TEnumAsByte<ECollisionResponse> NewResponse;
	} params;

	params.Channel = Channel;
	params.NewResponse = NewResponse;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetCollisionResponseToAllChannels
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// TEnumAsByte<ECollisionResponse> NewResponse                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetCollisionResponseToAllChannels(TEnumAsByte<ECollisionResponse> NewResponse)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetCollisionResponseToAllChannels");

	struct
	{
		TEnumAsByte<ECollisionResponse> NewResponse;
	} params;

	params.NewResponse = NewResponse;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetCollisionProfileName
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   InCollisionProfileName         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetCollisionProfileName(const struct FName& InCollisionProfileName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetCollisionProfileName");

	struct
	{
		struct FName                   InCollisionProfileName;
	} params;

	params.InCollisionProfileName = InCollisionProfileName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetCollisionObjectType
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// TEnumAsByte<ECollisionChannel> Channel                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetCollisionObjectType(TEnumAsByte<ECollisionChannel> Channel)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetCollisionObjectType");

	struct
	{
		TEnumAsByte<ECollisionChannel> Channel;
	} params;

	params.Channel = Channel;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetCollisionEnabled
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// TEnumAsByte<ECollisionEnabled> NewType                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetCollisionEnabled(TEnumAsByte<ECollisionEnabled> NewType)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetCollisionEnabled");

	struct
	{
		TEnumAsByte<ECollisionEnabled> NewType;
	} params;

	params.NewType = NewType;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetCenterOfMass
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 CenterOfMassOffset             (CPF_Parm, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetCenterOfMass(const struct FVector& CenterOfMassOffset, const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetCenterOfMass");

	struct
	{
		struct FVector                 CenterOfMassOffset;
		struct FName                   BoneName;
	} params;

	params.CenterOfMassOffset = CenterOfMassOffset;
	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetCastShadow
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           NewCastShadow                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetCastShadow(bool NewCastShadow)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetCastShadow");

	struct
	{
		bool                           NewCastShadow;
	} params;

	params.NewCastShadow = NewCastShadow;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetBoundsScale
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewBoundsScale                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetBoundsScale(float NewBoundsScale)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetBoundsScale");

	struct
	{
		float                          NewBoundsScale;
	} params;

	params.NewBoundsScale = NewBoundsScale;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetAngularDamping
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InDamping                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetAngularDamping(float InDamping)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetAngularDamping");

	struct
	{
		float                          InDamping;
	} params;

	params.InDamping = InDamping;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetAllUseCCD
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           InUseCCD                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetAllUseCCD(bool InUseCCD)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetAllUseCCD");

	struct
	{
		bool                           InUseCCD;
	} params;

	params.InUseCCD = InUseCCD;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetAllPhysicsLinearVelocity
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewVel                         (CPF_Parm, CPF_IsPlainOldData)
// bool                           bAddToCurrent                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetAllPhysicsLinearVelocity(const struct FVector& NewVel, bool bAddToCurrent)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetAllPhysicsLinearVelocity");

	struct
	{
		struct FVector                 NewVel;
		bool                           bAddToCurrent;
	} params;

	params.NewVel = NewVel;
	params.bAddToCurrent = bAddToCurrent;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetAllPhysicsAngularVelocityInRadians
// (FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewAngVel                      (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// bool                           bAddToCurrent                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetAllPhysicsAngularVelocityInRadians(const struct FVector& NewAngVel, bool bAddToCurrent)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetAllPhysicsAngularVelocityInRadians");

	struct
	{
		struct FVector                 NewAngVel;
		bool                           bAddToCurrent;
	} params;

	params.NewAngVel = NewAngVel;
	params.bAddToCurrent = bAddToCurrent;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetAllPhysicsAngularVelocityInDegrees
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewAngVel                      (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// bool                           bAddToCurrent                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetAllPhysicsAngularVelocityInDegrees(const struct FVector& NewAngVel, bool bAddToCurrent)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetAllPhysicsAngularVelocityInDegrees");

	struct
	{
		struct FVector                 NewAngVel;
		bool                           bAddToCurrent;
	} params;

	params.NewAngVel = NewAngVel;
	params.bAddToCurrent = bAddToCurrent;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetAllPhysicsAngularVelocity
// (FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewAngVel                      (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// bool                           bAddToCurrent                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetAllPhysicsAngularVelocity(const struct FVector& NewAngVel, bool bAddToCurrent)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetAllPhysicsAngularVelocity");

	struct
	{
		struct FVector                 NewAngVel;
		bool                           bAddToCurrent;
	} params;

	params.NewAngVel = NewAngVel;
	params.bAddToCurrent = bAddToCurrent;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.SetAllMassScale
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InMassScale                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::SetAllMassScale(float InMassScale)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.SetAllMassScale");

	struct
	{
		float                          InMassScale;
	} params;

	params.InMassScale = InMassScale;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.ScaleByMomentOfInertia
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 InputVector                    (CPF_Parm, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UPrimitiveComponent::ScaleByMomentOfInertia(const struct FVector& InputVector, const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.ScaleByMomentOfInertia");

	struct
	{
		struct FVector                 InputVector;
		struct FName                   BoneName;
		struct FVector                 ReturnValue;
	} params;

	params.InputVector = InputVector;
	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.PutRigidBodyToSleep
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::PutRigidBodyToSleep(const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.PutRigidBodyToSleep");

	struct
	{
		struct FName                   BoneName;
	} params;

	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.K2_LineTraceComponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 TraceStart                     (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 TraceEnd                       (CPF_Parm, CPF_IsPlainOldData)
// bool                           bTraceComplex                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bShowTrace                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 HitLocation                    (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FVector                 HitNormal                      (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              OutHit                         (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UPrimitiveComponent::K2_LineTraceComponent(const struct FVector& TraceStart, const struct FVector& TraceEnd, bool bTraceComplex, bool bShowTrace, struct FVector* HitLocation, struct FVector* HitNormal, struct FName* BoneName, struct FHitResult* OutHit)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.K2_LineTraceComponent");

	struct
	{
		struct FVector                 TraceStart;
		struct FVector                 TraceEnd;
		bool                           bTraceComplex;
		bool                           bShowTrace;
		struct FVector                 HitLocation;
		struct FVector                 HitNormal;
		struct FName                   BoneName;
		struct FHitResult              OutHit;
		bool                           ReturnValue;
	} params;

	params.TraceStart = TraceStart;
	params.TraceEnd = TraceEnd;
	params.bTraceComplex = bTraceComplex;
	params.bShowTrace = bShowTrace;

	UObject::ProcessEvent(fn, &params);

	if (HitLocation != nullptr)
		*HitLocation = params.HitLocation;
	if (HitNormal != nullptr)
		*HitNormal = params.HitNormal;
	if (BoneName != nullptr)
		*BoneName = params.BoneName;
	if (OutHit != nullptr)
		*OutHit = params.OutHit;

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.K2_IsQueryCollisionEnabled
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UPrimitiveComponent::K2_IsQueryCollisionEnabled()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.K2_IsQueryCollisionEnabled");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.K2_IsPhysicsCollisionEnabled
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UPrimitiveComponent::K2_IsPhysicsCollisionEnabled()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.K2_IsPhysicsCollisionEnabled");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.K2_IsCollisionEnabled
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UPrimitiveComponent::K2_IsCollisionEnabled()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.K2_IsCollisionEnabled");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.IsOverlappingComponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UPrimitiveComponent*     OtherComp                      (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UPrimitiveComponent::IsOverlappingComponent(class UPrimitiveComponent* OtherComp)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.IsOverlappingComponent");

	struct
	{
		class UPrimitiveComponent*     OtherComp;
		bool                           ReturnValue;
	} params;

	params.OtherComp = OtherComp;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.IsOverlappingActor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AActor*                  Other                          (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UPrimitiveComponent::IsOverlappingActor(class AActor* Other)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.IsOverlappingActor");

	struct
	{
		class AActor*                  Other;
		bool                           ReturnValue;
	} params;

	params.Other = Other;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.IsGravityEnabled
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UPrimitiveComponent::IsGravityEnabled()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.IsGravityEnabled");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.IsAnyRigidBodyAwake
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UPrimitiveComponent::IsAnyRigidBodyAwake()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.IsAnyRigidBodyAwake");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.IgnoreComponentWhenMoving
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UPrimitiveComponent*     Component                      (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// bool                           bShouldIgnore                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::IgnoreComponentWhenMoving(class UPrimitiveComponent* Component, bool bShouldIgnore)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.IgnoreComponentWhenMoving");

	struct
	{
		class UPrimitiveComponent*     Component;
		bool                           bShouldIgnore;
	} params;

	params.Component = Component;
	params.bShouldIgnore = bShouldIgnore;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.IgnoreActorWhenMoving
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class AActor*                  Actor                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bShouldIgnore                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::IgnoreActorWhenMoving(class AActor* Actor, bool bShouldIgnore)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.IgnoreActorWhenMoving");

	struct
	{
		class AActor*                  Actor;
		bool                           bShouldIgnore;
	} params;

	params.Actor = Actor;
	params.bShouldIgnore = bShouldIgnore;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.GetWalkableSlopeOverride
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FWalkableSlopeOverride  ReturnValue                    (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_ReferenceParm, CPF_IsPlainOldData)

struct FWalkableSlopeOverride UPrimitiveComponent::GetWalkableSlopeOverride()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetWalkableSlopeOverride");

	struct
	{
		struct FWalkableSlopeOverride  ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.GetPhysicsLinearVelocityAtPoint
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Point                          (CPF_Parm, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UPrimitiveComponent::GetPhysicsLinearVelocityAtPoint(const struct FVector& Point, const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetPhysicsLinearVelocityAtPoint");

	struct
	{
		struct FVector                 Point;
		struct FName                   BoneName;
		struct FVector                 ReturnValue;
	} params;

	params.Point = Point;
	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.GetPhysicsLinearVelocity
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UPrimitiveComponent::GetPhysicsLinearVelocity(const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetPhysicsLinearVelocity");

	struct
	{
		struct FName                   BoneName;
		struct FVector                 ReturnValue;
	} params;

	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.GetPhysicsAngularVelocityInRadians
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UPrimitiveComponent::GetPhysicsAngularVelocityInRadians(const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetPhysicsAngularVelocityInRadians");

	struct
	{
		struct FName                   BoneName;
		struct FVector                 ReturnValue;
	} params;

	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.GetPhysicsAngularVelocityInDegrees
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UPrimitiveComponent::GetPhysicsAngularVelocityInDegrees(const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetPhysicsAngularVelocityInDegrees");

	struct
	{
		struct FName                   BoneName;
		struct FVector                 ReturnValue;
	} params;

	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.GetPhysicsAngularVelocity
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UPrimitiveComponent::GetPhysicsAngularVelocity(const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetPhysicsAngularVelocity");

	struct
	{
		struct FName                   BoneName;
		struct FVector                 ReturnValue;
	} params;

	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.GetOverlappingComponents
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TArray<class UPrimitiveComponent*> InOverlappingComponents        (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor)

void UPrimitiveComponent::GetOverlappingComponents(TArray<class UPrimitiveComponent*>* InOverlappingComponents)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetOverlappingComponents");

	struct
	{
		TArray<class UPrimitiveComponent*> InOverlappingComponents;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (InOverlappingComponents != nullptr)
		*InOverlappingComponents = params.InOverlappingComponents;
}


// Function Engine.PrimitiveComponent.GetOverlappingActors
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TArray<class AActor*>          OverlappingActors              (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor)
// class UClass*                  ClassFilter                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::GetOverlappingActors(class UClass* ClassFilter, TArray<class AActor*>* OverlappingActors)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetOverlappingActors");

	struct
	{
		TArray<class AActor*>          OverlappingActors;
		class UClass*                  ClassFilter;
	} params;

	params.ClassFilter = ClassFilter;

	UObject::ProcessEvent(fn, &params);

	if (OverlappingActors != nullptr)
		*OverlappingActors = params.OverlappingActors;
}


// Function Engine.PrimitiveComponent.GetNumMaterials
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// int                            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

int UPrimitiveComponent::GetNumMaterials()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetNumMaterials");

	struct
	{
		int                            ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.GetMaterialFromCollisionFaceIndex
// (FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// int                            FaceIndex                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            SectionIndex                   (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UMaterialInterface*      ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UMaterialInterface* UPrimitiveComponent::GetMaterialFromCollisionFaceIndex(int FaceIndex, int* SectionIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetMaterialFromCollisionFaceIndex");

	struct
	{
		int                            FaceIndex;
		int                            SectionIndex;
		class UMaterialInterface*      ReturnValue;
	} params;

	params.FaceIndex = FaceIndex;

	UObject::ProcessEvent(fn, &params);

	if (SectionIndex != nullptr)
		*SectionIndex = params.SectionIndex;

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.GetMaterial
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// int                            ElementIndex                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UMaterialInterface*      ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UMaterialInterface* UPrimitiveComponent::GetMaterial(int ElementIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetMaterial");

	struct
	{
		int                            ElementIndex;
		class UMaterialInterface*      ReturnValue;
	} params;

	params.ElementIndex = ElementIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.GetMassScale
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UPrimitiveComponent::GetMassScale(const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetMassScale");

	struct
	{
		struct FName                   BoneName;
		float                          ReturnValue;
	} params;

	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.GetMass
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UPrimitiveComponent::GetMass()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetMass");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.GetLinearDamping
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UPrimitiveComponent::GetLinearDamping()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetLinearDamping");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.GetInertiaTensor
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UPrimitiveComponent::GetInertiaTensor(const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetInertiaTensor");

	struct
	{
		struct FName                   BoneName;
		struct FVector                 ReturnValue;
	} params;

	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.GetCollisionResponseToChannel
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TEnumAsByte<ECollisionChannel> Channel                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TEnumAsByte<ECollisionResponse> ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

TEnumAsByte<ECollisionResponse> UPrimitiveComponent::GetCollisionResponseToChannel(TEnumAsByte<ECollisionChannel> Channel)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetCollisionResponseToChannel");

	struct
	{
		TEnumAsByte<ECollisionChannel> Channel;
		TEnumAsByte<ECollisionResponse> ReturnValue;
	} params;

	params.Channel = Channel;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.GetCollisionProfileName
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

struct FName UPrimitiveComponent::GetCollisionProfileName()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetCollisionProfileName");

	struct
	{
		struct FName                   ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.GetCollisionObjectType
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TEnumAsByte<ECollisionChannel> ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

TEnumAsByte<ECollisionChannel> UPrimitiveComponent::GetCollisionObjectType()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetCollisionObjectType");

	struct
	{
		TEnumAsByte<ECollisionChannel> ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.GetCollisionEnabled
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TEnumAsByte<ECollisionEnabled> ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

TEnumAsByte<ECollisionEnabled> UPrimitiveComponent::GetCollisionEnabled()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetCollisionEnabled");

	struct
	{
		TEnumAsByte<ECollisionEnabled> ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.GetClosestPointOnCollision
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 Point                          (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// struct FVector                 OutPointOnBody                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UPrimitiveComponent::GetClosestPointOnCollision(const struct FVector& Point, const struct FName& BoneName, struct FVector* OutPointOnBody)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetClosestPointOnCollision");

	struct
	{
		struct FVector                 Point;
		struct FVector                 OutPointOnBody;
		struct FName                   BoneName;
		float                          ReturnValue;
	} params;

	params.Point = Point;
	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);

	if (OutPointOnBody != nullptr)
		*OutPointOnBody = params.OutPointOnBody;

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.GetCenterOfMass
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UPrimitiveComponent::GetCenterOfMass(const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetCenterOfMass");

	struct
	{
		struct FName                   BoneName;
		struct FVector                 ReturnValue;
	} params;

	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.GetAngularDamping
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UPrimitiveComponent::GetAngularDamping()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.GetAngularDamping");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.CreateDynamicMaterialInstance
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            ElementIndex                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UMaterialInterface*      SourceMaterial                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UMaterialInstanceDynamic* ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UMaterialInstanceDynamic* UPrimitiveComponent::CreateDynamicMaterialInstance(int ElementIndex, class UMaterialInterface* SourceMaterial)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.CreateDynamicMaterialInstance");

	struct
	{
		int                            ElementIndex;
		class UMaterialInterface*      SourceMaterial;
		class UMaterialInstanceDynamic* ReturnValue;
	} params;

	params.ElementIndex = ElementIndex;
	params.SourceMaterial = SourceMaterial;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.CreateAndSetMaterialInstanceDynamicFromMaterial
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            ElementIndex                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UMaterialInterface*      Parent                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UMaterialInstanceDynamic* ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UMaterialInstanceDynamic* UPrimitiveComponent::CreateAndSetMaterialInstanceDynamicFromMaterial(int ElementIndex, class UMaterialInterface* Parent)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.CreateAndSetMaterialInstanceDynamicFromMaterial");

	struct
	{
		int                            ElementIndex;
		class UMaterialInterface*      Parent;
		class UMaterialInstanceDynamic* ReturnValue;
	} params;

	params.ElementIndex = ElementIndex;
	params.Parent = Parent;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.CreateAndSetMaterialInstanceDynamic
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            ElementIndex                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UMaterialInstanceDynamic* ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UMaterialInstanceDynamic* UPrimitiveComponent::CreateAndSetMaterialInstanceDynamic(int ElementIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.CreateAndSetMaterialInstanceDynamic");

	struct
	{
		int                            ElementIndex;
		class UMaterialInstanceDynamic* ReturnValue;
	} params;

	params.ElementIndex = ElementIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.CopyArrayOfMoveIgnoreComponents
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// TArray<class UPrimitiveComponent*> ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm)

TArray<class UPrimitiveComponent*> UPrimitiveComponent::CopyArrayOfMoveIgnoreComponents()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.CopyArrayOfMoveIgnoreComponents");

	struct
	{
		TArray<class UPrimitiveComponent*> ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.CopyArrayOfMoveIgnoreActors
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// TArray<class AActor*>          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm)

TArray<class AActor*> UPrimitiveComponent::CopyArrayOfMoveIgnoreActors()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.CopyArrayOfMoveIgnoreActors");

	struct
	{
		TArray<class AActor*>          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.ClearMoveIgnoreComponents
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UPrimitiveComponent::ClearMoveIgnoreComponents()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.ClearMoveIgnoreComponents");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.ClearMoveIgnoreActors
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UPrimitiveComponent::ClearMoveIgnoreActors()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.ClearMoveIgnoreActors");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.CanCharacterStepUp
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class APawn*                   Pawn                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UPrimitiveComponent::CanCharacterStepUp(class APawn* Pawn)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.CanCharacterStepUp");

	struct
	{
		class APawn*                   Pawn;
		bool                           ReturnValue;
	} params;

	params.Pawn = Pawn;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PrimitiveComponent.AddTorqueInRadians
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Torque                         (CPF_Parm, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAccelChange                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::AddTorqueInRadians(const struct FVector& Torque, const struct FName& BoneName, bool bAccelChange)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.AddTorqueInRadians");

	struct
	{
		struct FVector                 Torque;
		struct FName                   BoneName;
		bool                           bAccelChange;
	} params;

	params.Torque = Torque;
	params.BoneName = BoneName;
	params.bAccelChange = bAccelChange;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.AddTorqueInDegrees
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Torque                         (CPF_Parm, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAccelChange                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::AddTorqueInDegrees(const struct FVector& Torque, const struct FName& BoneName, bool bAccelChange)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.AddTorqueInDegrees");

	struct
	{
		struct FVector                 Torque;
		struct FName                   BoneName;
		bool                           bAccelChange;
	} params;

	params.Torque = Torque;
	params.BoneName = BoneName;
	params.bAccelChange = bAccelChange;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.AddTorque
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Torque                         (CPF_Parm, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAccelChange                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::AddTorque(const struct FVector& Torque, const struct FName& BoneName, bool bAccelChange)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.AddTorque");

	struct
	{
		struct FVector                 Torque;
		struct FName                   BoneName;
		bool                           bAccelChange;
	} params;

	params.Torque = Torque;
	params.BoneName = BoneName;
	params.bAccelChange = bAccelChange;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.AddRadialImpulse
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Origin                         (CPF_Parm, CPF_IsPlainOldData)
// float                          Radius                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Strength                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TEnumAsByte<ERadialImpulseFalloff> Falloff                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bVelChange                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::AddRadialImpulse(const struct FVector& Origin, float Radius, float Strength, TEnumAsByte<ERadialImpulseFalloff> Falloff, bool bVelChange)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.AddRadialImpulse");

	struct
	{
		struct FVector                 Origin;
		float                          Radius;
		float                          Strength;
		TEnumAsByte<ERadialImpulseFalloff> Falloff;
		bool                           bVelChange;
	} params;

	params.Origin = Origin;
	params.Radius = Radius;
	params.Strength = Strength;
	params.Falloff = Falloff;
	params.bVelChange = bVelChange;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.AddRadialForce
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Origin                         (CPF_Parm, CPF_IsPlainOldData)
// float                          Radius                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Strength                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TEnumAsByte<ERadialImpulseFalloff> Falloff                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAccelChange                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::AddRadialForce(const struct FVector& Origin, float Radius, float Strength, TEnumAsByte<ERadialImpulseFalloff> Falloff, bool bAccelChange)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.AddRadialForce");

	struct
	{
		struct FVector                 Origin;
		float                          Radius;
		float                          Strength;
		TEnumAsByte<ERadialImpulseFalloff> Falloff;
		bool                           bAccelChange;
	} params;

	params.Origin = Origin;
	params.Radius = Radius;
	params.Strength = Strength;
	params.Falloff = Falloff;
	params.bAccelChange = bAccelChange;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.AddImpulseAtLocation
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Impulse                        (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 Location                       (CPF_Parm, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::AddImpulseAtLocation(const struct FVector& Impulse, const struct FVector& Location, const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.AddImpulseAtLocation");

	struct
	{
		struct FVector                 Impulse;
		struct FVector                 Location;
		struct FName                   BoneName;
	} params;

	params.Impulse = Impulse;
	params.Location = Location;
	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.AddImpulse
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Impulse                        (CPF_Parm, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bVelChange                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::AddImpulse(const struct FVector& Impulse, const struct FName& BoneName, bool bVelChange)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.AddImpulse");

	struct
	{
		struct FVector                 Impulse;
		struct FName                   BoneName;
		bool                           bVelChange;
	} params;

	params.Impulse = Impulse;
	params.BoneName = BoneName;
	params.bVelChange = bVelChange;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.AddForceAtLocationLocal
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Force                          (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 Location                       (CPF_Parm, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::AddForceAtLocationLocal(const struct FVector& Force, const struct FVector& Location, const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.AddForceAtLocationLocal");

	struct
	{
		struct FVector                 Force;
		struct FVector                 Location;
		struct FName                   BoneName;
	} params;

	params.Force = Force;
	params.Location = Location;
	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.AddForceAtLocation
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Force                          (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 Location                       (CPF_Parm, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::AddForceAtLocation(const struct FVector& Force, const struct FVector& Location, const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.AddForceAtLocation");

	struct
	{
		struct FVector                 Force;
		struct FVector                 Location;
		struct FName                   BoneName;
	} params;

	params.Force = Force;
	params.Location = Location;
	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.AddForce
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Force                          (CPF_Parm, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAccelChange                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::AddForce(const struct FVector& Force, const struct FName& BoneName, bool bAccelChange)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.AddForce");

	struct
	{
		struct FVector                 Force;
		struct FName                   BoneName;
		bool                           bAccelChange;
	} params;

	params.Force = Force;
	params.BoneName = BoneName;
	params.bAccelChange = bAccelChange;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.AddAngularImpulseInRadians
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Impulse                        (CPF_Parm, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bVelChange                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::AddAngularImpulseInRadians(const struct FVector& Impulse, const struct FName& BoneName, bool bVelChange)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.AddAngularImpulseInRadians");

	struct
	{
		struct FVector                 Impulse;
		struct FName                   BoneName;
		bool                           bVelChange;
	} params;

	params.Impulse = Impulse;
	params.BoneName = BoneName;
	params.bVelChange = bVelChange;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.AddAngularImpulseInDegrees
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Impulse                        (CPF_Parm, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bVelChange                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::AddAngularImpulseInDegrees(const struct FVector& Impulse, const struct FName& BoneName, bool bVelChange)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.AddAngularImpulseInDegrees");

	struct
	{
		struct FVector                 Impulse;
		struct FName                   BoneName;
		bool                           bVelChange;
	} params;

	params.Impulse = Impulse;
	params.BoneName = BoneName;
	params.bVelChange = bVelChange;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PrimitiveComponent.AddAngularImpulse
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Impulse                        (CPF_Parm, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bVelChange                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UPrimitiveComponent::AddAngularImpulse(const struct FVector& Impulse, const struct FName& BoneName, bool bVelChange)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PrimitiveComponent.AddAngularImpulse");

	struct
	{
		struct FVector                 Impulse;
		struct FName                   BoneName;
		bool                           bVelChange;
	} params;

	params.Impulse = Impulse;
	params.BoneName = BoneName;
	params.bVelChange = bVelChange;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.MeshComponent.SetVectorParameterValueOnMaterials
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   ParameterName                  (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 ParameterValue                 (CPF_ConstParm, CPF_Parm, CPF_IsPlainOldData)

void UMeshComponent::SetVectorParameterValueOnMaterials(const struct FName& ParameterName, const struct FVector& ParameterValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MeshComponent.SetVectorParameterValueOnMaterials");

	struct
	{
		struct FName                   ParameterName;
		struct FVector                 ParameterValue;
	} params;

	params.ParameterName = ParameterName;
	params.ParameterValue = ParameterValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.MeshComponent.SetScalarParameterValueOnMaterials
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   ParameterName                  (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ParameterValue                 (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UMeshComponent::SetScalarParameterValueOnMaterials(const struct FName& ParameterName, float ParameterValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MeshComponent.SetScalarParameterValueOnMaterials");

	struct
	{
		struct FName                   ParameterName;
		float                          ParameterValue;
	} params;

	params.ParameterName = ParameterName;
	params.ParameterValue = ParameterValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.MeshComponent.PrestreamTextures
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Seconds                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bPrioritizeCharacterTextures   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            CinematicTextureGroups         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UMeshComponent::PrestreamTextures(float Seconds, bool bPrioritizeCharacterTextures, int CinematicTextureGroups)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MeshComponent.PrestreamTextures");

	struct
	{
		float                          Seconds;
		bool                           bPrioritizeCharacterTextures;
		int                            CinematicTextureGroups;
	} params;

	params.Seconds = Seconds;
	params.bPrioritizeCharacterTextures = bPrioritizeCharacterTextures;
	params.CinematicTextureGroups = CinematicTextureGroups;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.MeshComponent.IsMaterialSlotNameValid
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   MaterialSlotName               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UMeshComponent::IsMaterialSlotNameValid(const struct FName& MaterialSlotName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MeshComponent.IsMaterialSlotNameValid");

	struct
	{
		struct FName                   MaterialSlotName;
		bool                           ReturnValue;
	} params;

	params.MaterialSlotName = MaterialSlotName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.MeshComponent.GetMaterialSlotNames
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TArray<struct FName>           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm)

TArray<struct FName> UMeshComponent::GetMaterialSlotNames()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MeshComponent.GetMaterialSlotNames");

	struct
	{
		TArray<struct FName>           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.MeshComponent.GetMaterials
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TArray<class UMaterialInterface*> ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm)

TArray<class UMaterialInterface*> UMeshComponent::GetMaterials()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MeshComponent.GetMaterials");

	struct
	{
		TArray<class UMaterialInterface*> ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.MeshComponent.GetMaterialIndex
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   MaterialSlotName               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

int UMeshComponent::GetMaterialIndex(const struct FName& MaterialSlotName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MeshComponent.GetMaterialIndex");

	struct
	{
		struct FName                   MaterialSlotName;
		int                            ReturnValue;
	} params;

	params.MaterialSlotName = MaterialSlotName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkinnedMeshComponent.UnHideBoneByName
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkinnedMeshComponent::UnHideBoneByName(const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.UnHideBoneByName");

	struct
	{
		struct FName                   BoneName;
	} params;

	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkinnedMeshComponent.TransformToBoneSpace
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 InPosition                     (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                InRotation                     (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 OutPosition                    (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FRotator                OutRotation                    (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)

void USkinnedMeshComponent::TransformToBoneSpace(const struct FName& BoneName, const struct FVector& InPosition, const struct FRotator& InRotation, struct FVector* OutPosition, struct FRotator* OutRotation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.TransformToBoneSpace");

	struct
	{
		struct FName                   BoneName;
		struct FVector                 InPosition;
		struct FRotator                InRotation;
		struct FVector                 OutPosition;
		struct FRotator                OutRotation;
	} params;

	params.BoneName = BoneName;
	params.InPosition = InPosition;
	params.InRotation = InRotation;

	UObject::ProcessEvent(fn, &params);

	if (OutPosition != nullptr)
		*OutPosition = params.OutPosition;
	if (OutRotation != nullptr)
		*OutRotation = params.OutRotation;
}


// Function Engine.SkinnedMeshComponent.TransformFromBoneSpace
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 InPosition                     (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                InRotation                     (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 OutPosition                    (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FRotator                OutRotation                    (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)

void USkinnedMeshComponent::TransformFromBoneSpace(const struct FName& BoneName, const struct FVector& InPosition, const struct FRotator& InRotation, struct FVector* OutPosition, struct FRotator* OutRotation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.TransformFromBoneSpace");

	struct
	{
		struct FName                   BoneName;
		struct FVector                 InPosition;
		struct FRotator                InRotation;
		struct FVector                 OutPosition;
		struct FRotator                OutRotation;
	} params;

	params.BoneName = BoneName;
	params.InPosition = InPosition;
	params.InRotation = InRotation;

	UObject::ProcessEvent(fn, &params);

	if (OutPosition != nullptr)
		*OutPosition = params.OutPosition;
	if (OutRotation != nullptr)
		*OutRotation = params.OutRotation;
}


// Function Engine.SkinnedMeshComponent.ShowMaterialSection
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            MaterialID                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bShow                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            LODIndex                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkinnedMeshComponent::ShowMaterialSection(int MaterialID, bool bShow, int LODIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.ShowMaterialSection");

	struct
	{
		int                            MaterialID;
		bool                           bShow;
		int                            LODIndex;
	} params;

	params.MaterialID = MaterialID;
	params.bShow = bShow;
	params.LODIndex = LODIndex;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkinnedMeshComponent.ShowAllMaterialSections
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            LODIndex                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkinnedMeshComponent::ShowAllMaterialSections(int LODIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.ShowAllMaterialSections");

	struct
	{
		int                            LODIndex;
	} params;

	params.LODIndex = LODIndex;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkinnedMeshComponent.SetVertexColorOverride_LinearColor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// int                            LODIndex                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TArray<struct FLinearColor>    VertexColors                   (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)

void USkinnedMeshComponent::SetVertexColorOverride_LinearColor(int LODIndex, TArray<struct FLinearColor> VertexColors)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.SetVertexColorOverride_LinearColor");

	struct
	{
		int                            LODIndex;
		TArray<struct FLinearColor>    VertexColors;
	} params;

	params.LODIndex = LODIndex;
	params.VertexColors = VertexColors;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkinnedMeshComponent.SetSkinWeightOverride
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// int                            LODIndex                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TArray<struct FSkelMeshSkinWeightInfo> SkinWeights                    (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)

void USkinnedMeshComponent::SetSkinWeightOverride(int LODIndex, TArray<struct FSkelMeshSkinWeightInfo> SkinWeights)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.SetSkinWeightOverride");

	struct
	{
		int                            LODIndex;
		TArray<struct FSkelMeshSkinWeightInfo> SkinWeights;
	} params;

	params.LODIndex = LODIndex;
	params.SkinWeights = SkinWeights;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkinnedMeshComponent.SetSkeletalMesh
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class USkeletalMesh*           NewMesh                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bReinitPose                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkinnedMeshComponent::SetSkeletalMesh(class USkeletalMesh* NewMesh, bool bReinitPose)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.SetSkeletalMesh");

	struct
	{
		class USkeletalMesh*           NewMesh;
		bool                           bReinitPose;
	} params;

	params.NewMesh = NewMesh;
	params.bReinitPose = bReinitPose;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkinnedMeshComponent.SetPhysicsAsset
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UPhysicsAsset*           NewPhysicsAsset                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bForceReInit                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkinnedMeshComponent::SetPhysicsAsset(class UPhysicsAsset* NewPhysicsAsset, bool bForceReInit)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.SetPhysicsAsset");

	struct
	{
		class UPhysicsAsset*           NewPhysicsAsset;
		bool                           bForceReInit;
	} params;

	params.NewPhysicsAsset = NewPhysicsAsset;
	params.bForceReInit = bForceReInit;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkinnedMeshComponent.SetMinLOD
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            InNewMinLOD                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkinnedMeshComponent::SetMinLOD(int InNewMinLOD)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.SetMinLOD");

	struct
	{
		int                            InNewMinLOD;
	} params;

	params.InNewMinLOD = InNewMinLOD;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkinnedMeshComponent.SetMasterPoseComponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class USkinnedMeshComponent*   NewMasterBoneComponent         (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)

void USkinnedMeshComponent::SetMasterPoseComponent(class USkinnedMeshComponent* NewMasterBoneComponent)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.SetMasterPoseComponent");

	struct
	{
		class USkinnedMeshComponent*   NewMasterBoneComponent;
	} params;

	params.NewMasterBoneComponent = NewMasterBoneComponent;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkinnedMeshComponent.SetForcedLOD
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            InNewForcedLOD                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkinnedMeshComponent::SetForcedLOD(int InNewForcedLOD)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.SetForcedLOD");

	struct
	{
		int                            InNewForcedLOD;
	} params;

	params.InNewForcedLOD = InNewForcedLOD;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkinnedMeshComponent.SetCastCapsuleIndirectShadow
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewValue                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkinnedMeshComponent::SetCastCapsuleIndirectShadow(bool bNewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.SetCastCapsuleIndirectShadow");

	struct
	{
		bool                           bNewValue;
	} params;

	params.bNewValue = bNewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkinnedMeshComponent.SetCastCapsuleDirectShadow
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewValue                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkinnedMeshComponent::SetCastCapsuleDirectShadow(bool bNewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.SetCastCapsuleDirectShadow");

	struct
	{
		bool                           bNewValue;
	} params;

	params.bNewValue = bNewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkinnedMeshComponent.SetCapsuleIndirectShadowMinVisibility
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewValue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkinnedMeshComponent::SetCapsuleIndirectShadowMinVisibility(float NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.SetCapsuleIndirectShadowMinVisibility");

	struct
	{
		float                          NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkinnedMeshComponent.IsMaterialSectionShown
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            MaterialID                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            LODIndex                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool USkinnedMeshComponent::IsMaterialSectionShown(int MaterialID, int LODIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.IsMaterialSectionShown");

	struct
	{
		int                            MaterialID;
		int                            LODIndex;
		bool                           ReturnValue;
	} params;

	params.MaterialID = MaterialID;
	params.LODIndex = LODIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkinnedMeshComponent.IsBoneHiddenByName
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool USkinnedMeshComponent::IsBoneHiddenByName(const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.IsBoneHiddenByName");

	struct
	{
		struct FName                   BoneName;
		bool                           ReturnValue;
	} params;

	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkinnedMeshComponent.HideBoneByName
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TEnumAsByte<EPhysBodyOp>       PhysBodyOption                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkinnedMeshComponent::HideBoneByName(const struct FName& BoneName, TEnumAsByte<EPhysBodyOp> PhysBodyOption)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.HideBoneByName");

	struct
	{
		struct FName                   BoneName;
		TEnumAsByte<EPhysBodyOp>       PhysBodyOption;
	} params;

	params.BoneName = BoneName;
	params.PhysBodyOption = PhysBodyOption;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkinnedMeshComponent.GetSocketBoneName
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   InSocketName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

struct FName USkinnedMeshComponent::GetSocketBoneName(const struct FName& InSocketName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.GetSocketBoneName");

	struct
	{
		struct FName                   InSocketName;
		struct FName                   ReturnValue;
	} params;

	params.InSocketName = InSocketName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkinnedMeshComponent.GetRefPosePosition
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// int                            BoneIndex                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector USkinnedMeshComponent::GetRefPosePosition(int BoneIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.GetRefPosePosition");

	struct
	{
		int                            BoneIndex;
		struct FVector                 ReturnValue;
	} params;

	params.BoneIndex = BoneIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkinnedMeshComponent.GetParentBone
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

struct FName USkinnedMeshComponent::GetParentBone(const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.GetParentBone");

	struct
	{
		struct FName                   BoneName;
		struct FName                   ReturnValue;
	} params;

	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkinnedMeshComponent.GetNumLODs
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// int                            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

int USkinnedMeshComponent::GetNumLODs()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.GetNumLODs");

	struct
	{
		int                            ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkinnedMeshComponent.GetNumBones
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// int                            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

int USkinnedMeshComponent::GetNumBones()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.GetNumBones");

	struct
	{
		int                            ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkinnedMeshComponent.GetBoneName
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// int                            BoneIndex                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

struct FName USkinnedMeshComponent::GetBoneName(int BoneIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.GetBoneName");

	struct
	{
		int                            BoneIndex;
		struct FName                   ReturnValue;
	} params;

	params.BoneIndex = BoneIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkinnedMeshComponent.GetBoneIndex
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

int USkinnedMeshComponent::GetBoneIndex(const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.GetBoneIndex");

	struct
	{
		struct FName                   BoneName;
		int                            ReturnValue;
	} params;

	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkinnedMeshComponent.FindClosestBone_K2
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 TestLocation                   (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 BoneLocation                   (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// float                          IgnoreScale                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bRequirePhysicsAsset           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

struct FName USkinnedMeshComponent::FindClosestBone_K2(const struct FVector& TestLocation, float IgnoreScale, bool bRequirePhysicsAsset, struct FVector* BoneLocation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.FindClosestBone_K2");

	struct
	{
		struct FVector                 TestLocation;
		struct FVector                 BoneLocation;
		float                          IgnoreScale;
		bool                           bRequirePhysicsAsset;
		struct FName                   ReturnValue;
	} params;

	params.TestLocation = TestLocation;
	params.IgnoreScale = IgnoreScale;
	params.bRequirePhysicsAsset = bRequirePhysicsAsset;

	UObject::ProcessEvent(fn, &params);

	if (BoneLocation != nullptr)
		*BoneLocation = params.BoneLocation;

	return params.ReturnValue;
}


// Function Engine.SkinnedMeshComponent.ClearVertexColorOverride
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            LODIndex                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkinnedMeshComponent::ClearVertexColorOverride(int LODIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.ClearVertexColorOverride");

	struct
	{
		int                            LODIndex;
	} params;

	params.LODIndex = LODIndex;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkinnedMeshComponent.ClearSkinWeightOverride
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            LODIndex                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkinnedMeshComponent::ClearSkinWeightOverride(int LODIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.ClearSkinWeightOverride");

	struct
	{
		int                            LODIndex;
	} params;

	params.LODIndex = LODIndex;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkinnedMeshComponent.BoneIsChildOf
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   ParentBoneName                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool USkinnedMeshComponent::BoneIsChildOf(const struct FName& BoneName, const struct FName& ParentBoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkinnedMeshComponent.BoneIsChildOf");

	struct
	{
		struct FName                   BoneName;
		struct FName                   ParentBoneName;
		bool                           ReturnValue;
	} params;

	params.BoneName = BoneName;
	params.ParentBoneName = ParentBoneName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.UnbindClothFromMasterPoseComponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bRestoreSimulationSpace        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::UnbindClothFromMasterPoseComponent(bool bRestoreSimulationSpace)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.UnbindClothFromMasterPoseComponent");

	struct
	{
		bool                           bRestoreSimulationSpace;
	} params;

	params.bRestoreSimulationSpace = bRestoreSimulationSpace;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.ToggleDisablePostProcessBlueprint
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void USkeletalMeshComponent::ToggleDisablePostProcessBlueprint()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.ToggleDisablePostProcessBlueprint");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SuspendClothingSimulation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void USkeletalMeshComponent::SuspendClothingSimulation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SuspendClothingSimulation");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.Stop
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void USkeletalMeshComponent::Stop()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.Stop");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SnapshotPose
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// struct FPoseSnapshot           Snapshot                       (CPF_Parm, CPF_OutParm, CPF_ReferenceParm)

void USkeletalMeshComponent::SnapshotPose(struct FPoseSnapshot* Snapshot)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SnapshotPose");

	struct
	{
		struct FPoseSnapshot           Snapshot;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (Snapshot != nullptr)
		*Snapshot = params.Snapshot;
}


// Function Engine.SkeletalMeshComponent.SetUpdateAnimationInEditor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           NewUpdateState                 (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetUpdateAnimationInEditor(bool NewUpdateState)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetUpdateAnimationInEditor");

	struct
	{
		bool                           NewUpdateState;
	} params;

	params.NewUpdateState = NewUpdateState;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetTeleportRotationThreshold
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Threshold                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetTeleportRotationThreshold(float Threshold)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetTeleportRotationThreshold");

	struct
	{
		float                          Threshold;
	} params;

	params.Threshold = Threshold;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetTeleportDistanceThreshold
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Threshold                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetTeleportDistanceThreshold(float Threshold)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetTeleportDistanceThreshold");

	struct
	{
		float                          Threshold;
	} params;

	params.Threshold = Threshold;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetPosition
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InPos                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bFireNotifies                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetPosition(float InPos, bool bFireNotifies)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetPosition");

	struct
	{
		float                          InPos;
		bool                           bFireNotifies;
	} params;

	params.InPos = InPos;
	params.bFireNotifies = bFireNotifies;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetPlayRate
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Rate                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetPlayRate(float Rate)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetPlayRate");

	struct
	{
		float                          Rate;
	} params;

	params.Rate = Rate;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetPhysicsBlendWeight
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          PhysicsBlendWeight             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetPhysicsBlendWeight(float PhysicsBlendWeight)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetPhysicsBlendWeight");

	struct
	{
		float                          PhysicsBlendWeight;
	} params;

	params.PhysicsBlendWeight = PhysicsBlendWeight;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetNotifyRigidBodyCollisionBelow
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewNotifyRigidBodyCollision   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bIncludeSelf                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetNotifyRigidBodyCollisionBelow(bool bNewNotifyRigidBodyCollision, const struct FName& BoneName, bool bIncludeSelf)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetNotifyRigidBodyCollisionBelow");

	struct
	{
		bool                           bNewNotifyRigidBodyCollision;
		struct FName                   BoneName;
		bool                           bIncludeSelf;
	} params;

	params.bNewNotifyRigidBodyCollision = bNewNotifyRigidBodyCollision;
	params.BoneName = BoneName;
	params.bIncludeSelf = bIncludeSelf;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetMorphTarget
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   MorphTargetName                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Value                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bRemoveZeroWeight              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetMorphTarget(const struct FName& MorphTargetName, float Value, bool bRemoveZeroWeight)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetMorphTarget");

	struct
	{
		struct FName                   MorphTargetName;
		float                          Value;
		bool                           bRemoveZeroWeight;
	} params;

	params.MorphTargetName = MorphTargetName;
	params.Value = Value;
	params.bRemoveZeroWeight = bRemoveZeroWeight;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetEnablePhysicsBlending
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewBlendPhysics               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetEnablePhysicsBlending(bool bNewBlendPhysics)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetEnablePhysicsBlending");

	struct
	{
		bool                           bNewBlendPhysics;
	} params;

	params.bNewBlendPhysics = bNewBlendPhysics;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetEnableGravityOnAllBodiesBelow
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bEnableGravity                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bIncludeSelf                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetEnableGravityOnAllBodiesBelow(bool bEnableGravity, const struct FName& BoneName, bool bIncludeSelf)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetEnableGravityOnAllBodiesBelow");

	struct
	{
		bool                           bEnableGravity;
		struct FName                   BoneName;
		bool                           bIncludeSelf;
	} params;

	params.bEnableGravity = bEnableGravity;
	params.BoneName = BoneName;
	params.bIncludeSelf = bIncludeSelf;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetEnableBodyGravity
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bEnableGravity                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetEnableBodyGravity(bool bEnableGravity, const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetEnableBodyGravity");

	struct
	{
		bool                           bEnableGravity;
		struct FName                   BoneName;
	} params;

	params.bEnableGravity = bEnableGravity;
	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetDisablePostProcessBlueprint
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bInDisablePostProcess          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetDisablePostProcessBlueprint(bool bInDisablePostProcess)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetDisablePostProcessBlueprint");

	struct
	{
		bool                           bInDisablePostProcess;
	} params;

	params.bInDisablePostProcess = bInDisablePostProcess;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetDisableAnimCurves
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bInDisableAnimCurves           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetDisableAnimCurves(bool bInDisableAnimCurves)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetDisableAnimCurves");

	struct
	{
		bool                           bInDisableAnimCurves;
	} params;

	params.bInDisableAnimCurves = bInDisableAnimCurves;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetConstraintProfileForAll
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   ProfileName                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bDefaultIfNotFound             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetConstraintProfileForAll(const struct FName& ProfileName, bool bDefaultIfNotFound)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetConstraintProfileForAll");

	struct
	{
		struct FName                   ProfileName;
		bool                           bDefaultIfNotFound;
	} params;

	params.ProfileName = ProfileName;
	params.bDefaultIfNotFound = bDefaultIfNotFound;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetConstraintProfile
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   JointName                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   ProfileName                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bDefaultIfNotFound             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetConstraintProfile(const struct FName& JointName, const struct FName& ProfileName, bool bDefaultIfNotFound)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetConstraintProfile");

	struct
	{
		struct FName                   JointName;
		struct FName                   ProfileName;
		bool                           bDefaultIfNotFound;
	} params;

	params.JointName = JointName;
	params.ProfileName = ProfileName;
	params.bDefaultIfNotFound = bDefaultIfNotFound;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetClothMaxDistanceScale
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Scale                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetClothMaxDistanceScale(float Scale)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetClothMaxDistanceScale");

	struct
	{
		float                          Scale;
	} params;

	params.Scale = Scale;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetBodyNotifyRigidBodyCollision
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewNotifyRigidBodyCollision   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetBodyNotifyRigidBodyCollision(bool bNewNotifyRigidBodyCollision, const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetBodyNotifyRigidBodyCollision");

	struct
	{
		bool                           bNewNotifyRigidBodyCollision;
		struct FName                   BoneName;
	} params;

	params.bNewNotifyRigidBodyCollision = bNewNotifyRigidBodyCollision;
	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetAnimInstanceClass
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UClass*                  NewClass                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetAnimInstanceClass(class UClass* NewClass)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetAnimInstanceClass");

	struct
	{
		class UClass*                  NewClass;
	} params;

	params.NewClass = NewClass;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetAnimationMode
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// TEnumAsByte<EAnimationMode>    InAnimationMode                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetAnimationMode(TEnumAsByte<EAnimationMode> InAnimationMode)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetAnimationMode");

	struct
	{
		TEnumAsByte<EAnimationMode>    InAnimationMode;
	} params;

	params.InAnimationMode = InAnimationMode;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetAnimation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UAnimationAsset*         NewAnimToPlay                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetAnimation(class UAnimationAsset* NewAnimToPlay)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetAnimation");

	struct
	{
		class UAnimationAsset*         NewAnimToPlay;
	} params;

	params.NewAnimToPlay = NewAnimToPlay;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetAngularLimits
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   InBoneName                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Swing1LimitAngle               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          TwistLimitAngle                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Swing2LimitAngle               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetAngularLimits(const struct FName& InBoneName, float Swing1LimitAngle, float TwistLimitAngle, float Swing2LimitAngle)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetAngularLimits");

	struct
	{
		struct FName                   InBoneName;
		float                          Swing1LimitAngle;
		float                          TwistLimitAngle;
		float                          Swing2LimitAngle;
	} params;

	params.InBoneName = InBoneName;
	params.Swing1LimitAngle = Swing1LimitAngle;
	params.TwistLimitAngle = TwistLimitAngle;
	params.Swing2LimitAngle = Swing2LimitAngle;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetAllowedAnimCurvesEvaluation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// TArray<struct FName>           List                           (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// bool                           bAllow                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetAllowedAnimCurvesEvaluation(TArray<struct FName> List, bool bAllow)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetAllowedAnimCurvesEvaluation");

	struct
	{
		TArray<struct FName>           List;
		bool                           bAllow;
	} params;

	params.List = List;
	params.bAllow = bAllow;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetAllowAnimCurveEvaluation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bInAllow                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetAllowAnimCurveEvaluation(bool bInAllow)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetAllowAnimCurveEvaluation");

	struct
	{
		bool                           bInAllow;
	} params;

	params.bInAllow = bInAllow;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetAllMotorsAngularVelocityDrive
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bEnableSwingDrive              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bEnableTwistDrive              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bSkipCustomPhysicsType         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetAllMotorsAngularVelocityDrive(bool bEnableSwingDrive, bool bEnableTwistDrive, bool bSkipCustomPhysicsType)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetAllMotorsAngularVelocityDrive");

	struct
	{
		bool                           bEnableSwingDrive;
		bool                           bEnableTwistDrive;
		bool                           bSkipCustomPhysicsType;
	} params;

	params.bEnableSwingDrive = bEnableSwingDrive;
	params.bEnableTwistDrive = bEnableTwistDrive;
	params.bSkipCustomPhysicsType = bSkipCustomPhysicsType;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetAllMotorsAngularPositionDrive
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bEnableSwingDrive              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bEnableTwistDrive              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bSkipCustomPhysicsType         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetAllMotorsAngularPositionDrive(bool bEnableSwingDrive, bool bEnableTwistDrive, bool bSkipCustomPhysicsType)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetAllMotorsAngularPositionDrive");

	struct
	{
		bool                           bEnableSwingDrive;
		bool                           bEnableTwistDrive;
		bool                           bSkipCustomPhysicsType;
	} params;

	params.bEnableSwingDrive = bEnableSwingDrive;
	params.bEnableTwistDrive = bEnableTwistDrive;
	params.bSkipCustomPhysicsType = bSkipCustomPhysicsType;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetAllMotorsAngularDriveParams
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InSpring                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InDamping                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InForceLimit                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bSkipCustomPhysicsType         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetAllMotorsAngularDriveParams(float InSpring, float InDamping, float InForceLimit, bool bSkipCustomPhysicsType)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetAllMotorsAngularDriveParams");

	struct
	{
		float                          InSpring;
		float                          InDamping;
		float                          InForceLimit;
		bool                           bSkipCustomPhysicsType;
	} params;

	params.InSpring = InSpring;
	params.InDamping = InDamping;
	params.InForceLimit = InForceLimit;
	params.bSkipCustomPhysicsType = bSkipCustomPhysicsType;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetAllBodiesSimulatePhysics
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewSimulate                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetAllBodiesSimulatePhysics(bool bNewSimulate)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetAllBodiesSimulatePhysics");

	struct
	{
		bool                           bNewSimulate;
	} params;

	params.bNewSimulate = bNewSimulate;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetAllBodiesPhysicsBlendWeight
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          PhysicsBlendWeight             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bSkipCustomPhysicsType         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetAllBodiesPhysicsBlendWeight(float PhysicsBlendWeight, bool bSkipCustomPhysicsType)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetAllBodiesPhysicsBlendWeight");

	struct
	{
		float                          PhysicsBlendWeight;
		bool                           bSkipCustomPhysicsType;
	} params;

	params.PhysicsBlendWeight = PhysicsBlendWeight;
	params.bSkipCustomPhysicsType = bSkipCustomPhysicsType;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetAllBodiesBelowSimulatePhysics
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   InBoneName                     (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm, CPF_IsPlainOldData)
// bool                           bNewSimulate                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bIncludeSelf                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetAllBodiesBelowSimulatePhysics(const struct FName& InBoneName, bool bNewSimulate, bool bIncludeSelf)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetAllBodiesBelowSimulatePhysics");

	struct
	{
		struct FName                   InBoneName;
		bool                           bNewSimulate;
		bool                           bIncludeSelf;
	} params;

	params.InBoneName = InBoneName;
	params.bNewSimulate = bNewSimulate;
	params.bIncludeSelf = bIncludeSelf;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.SetAllBodiesBelowPhysicsBlendWeight
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   InBoneName                     (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm, CPF_IsPlainOldData)
// float                          PhysicsBlendWeight             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bSkipCustomPhysicsType         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bIncludeSelf                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::SetAllBodiesBelowPhysicsBlendWeight(const struct FName& InBoneName, float PhysicsBlendWeight, bool bSkipCustomPhysicsType, bool bIncludeSelf)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.SetAllBodiesBelowPhysicsBlendWeight");

	struct
	{
		struct FName                   InBoneName;
		float                          PhysicsBlendWeight;
		bool                           bSkipCustomPhysicsType;
		bool                           bIncludeSelf;
	} params;

	params.InBoneName = InBoneName;
	params.PhysicsBlendWeight = PhysicsBlendWeight;
	params.bSkipCustomPhysicsType = bSkipCustomPhysicsType;
	params.bIncludeSelf = bIncludeSelf;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.ResumeClothingSimulation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void USkeletalMeshComponent::ResumeClothingSimulation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.ResumeClothingSimulation");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.ResetClothTeleportMode
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void USkeletalMeshComponent::ResetClothTeleportMode()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.ResetClothTeleportMode");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.ResetAllowedAnimCurveEvaluation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void USkeletalMeshComponent::ResetAllowedAnimCurveEvaluation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.ResetAllowedAnimCurveEvaluation");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.ResetAllBodiesSimulatePhysics
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void USkeletalMeshComponent::ResetAllBodiesSimulatePhysics()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.ResetAllBodiesSimulatePhysics");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.PlayAnimation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UAnimationAsset*         NewAnimToPlay                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bLooping                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::PlayAnimation(class UAnimationAsset* NewAnimToPlay, bool bLooping)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.PlayAnimation");

	struct
	{
		class UAnimationAsset*         NewAnimToPlay;
		bool                           bLooping;
	} params;

	params.NewAnimToPlay = NewAnimToPlay;
	params.bLooping = bLooping;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.Play
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bLooping                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::Play(bool bLooping)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.Play");

	struct
	{
		bool                           bLooping;
	} params;

	params.bLooping = bLooping;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.OverrideAnimationData
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UAnimationAsset*         InAnimToPlay                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bIsLooping                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bIsPlaying                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Position                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          PlayRate                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::OverrideAnimationData(class UAnimationAsset* InAnimToPlay, bool bIsLooping, bool bIsPlaying, float Position, float PlayRate)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.OverrideAnimationData");

	struct
	{
		class UAnimationAsset*         InAnimToPlay;
		bool                           bIsLooping;
		bool                           bIsPlaying;
		float                          Position;
		float                          PlayRate;
	} params;

	params.InAnimToPlay = InAnimToPlay;
	params.bIsLooping = bIsLooping;
	params.bIsPlaying = bIsPlaying;
	params.Position = Position;
	params.PlayRate = PlayRate;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.K2_GetClosestPointOnPhysicsAsset
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 WorldPosition                  (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// struct FVector                 ClosestWorldPosition           (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FVector                 Normal                         (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Distance                       (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool USkeletalMeshComponent::K2_GetClosestPointOnPhysicsAsset(const struct FVector& WorldPosition, struct FVector* ClosestWorldPosition, struct FVector* Normal, struct FName* BoneName, float* Distance)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.K2_GetClosestPointOnPhysicsAsset");

	struct
	{
		struct FVector                 WorldPosition;
		struct FVector                 ClosestWorldPosition;
		struct FVector                 Normal;
		struct FName                   BoneName;
		float                          Distance;
		bool                           ReturnValue;
	} params;

	params.WorldPosition = WorldPosition;

	UObject::ProcessEvent(fn, &params);

	if (ClosestWorldPosition != nullptr)
		*ClosestWorldPosition = params.ClosestWorldPosition;
	if (Normal != nullptr)
		*Normal = params.Normal;
	if (BoneName != nullptr)
		*BoneName = params.BoneName;
	if (Distance != nullptr)
		*Distance = params.Distance;

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.IsPlaying
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool USkeletalMeshComponent::IsPlaying()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.IsPlaying");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.IsClothingSimulationSuspended
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool USkeletalMeshComponent::IsClothingSimulationSuspended()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.IsClothingSimulationSuspended");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.IsBodyGravityEnabled
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool USkeletalMeshComponent::IsBodyGravityEnabled(const struct FName& BoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.IsBodyGravityEnabled");

	struct
	{
		struct FName                   BoneName;
		bool                           ReturnValue;
	} params;

	params.BoneName = BoneName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.GetTeleportRotationThreshold
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float USkeletalMeshComponent::GetTeleportRotationThreshold()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.GetTeleportRotationThreshold");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.GetTeleportDistanceThreshold
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float USkeletalMeshComponent::GetTeleportDistanceThreshold()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.GetTeleportDistanceThreshold");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.GetSkeletalCenterOfMass
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector USkeletalMeshComponent::GetSkeletalCenterOfMass()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.GetSkeletalCenterOfMass");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.GetPostProcessInstance
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UAnimInstance*           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UAnimInstance* USkeletalMeshComponent::GetPostProcessInstance()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.GetPostProcessInstance");

	struct
	{
		class UAnimInstance*           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.GetPosition
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float USkeletalMeshComponent::GetPosition()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.GetPosition");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.GetPlayRate
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float USkeletalMeshComponent::GetPlayRate()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.GetPlayRate");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.GetMorphTarget
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   MorphTargetName                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float USkeletalMeshComponent::GetMorphTarget(const struct FName& MorphTargetName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.GetMorphTarget");

	struct
	{
		struct FName                   MorphTargetName;
		float                          ReturnValue;
	} params;

	params.MorphTargetName = MorphTargetName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.GetDisablePostProcessBlueprint
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool USkeletalMeshComponent::GetDisablePostProcessBlueprint()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.GetDisablePostProcessBlueprint");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.GetDisableAnimCurves
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool USkeletalMeshComponent::GetDisableAnimCurves()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.GetDisableAnimCurves");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.GetCurrentJointAngles
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   InBoneName                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Swing1Angle                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          TwistAngle                     (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Swing2Angle                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::GetCurrentJointAngles(const struct FName& InBoneName, float* Swing1Angle, float* TwistAngle, float* Swing2Angle)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.GetCurrentJointAngles");

	struct
	{
		struct FName                   InBoneName;
		float                          Swing1Angle;
		float                          TwistAngle;
		float                          Swing2Angle;
	} params;

	params.InBoneName = InBoneName;

	UObject::ProcessEvent(fn, &params);

	if (Swing1Angle != nullptr)
		*Swing1Angle = params.Swing1Angle;
	if (TwistAngle != nullptr)
		*TwistAngle = params.TwistAngle;
	if (Swing2Angle != nullptr)
		*Swing2Angle = params.Swing2Angle;
}


// Function Engine.SkeletalMeshComponent.GetClothMaxDistanceScale
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float USkeletalMeshComponent::GetClothMaxDistanceScale()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.GetClothMaxDistanceScale");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.GetClothingSimulationInteractor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UClothingSimulationInteractor* ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UClothingSimulationInteractor* USkeletalMeshComponent::GetClothingSimulationInteractor()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.GetClothingSimulationInteractor");

	struct
	{
		class UClothingSimulationInteractor* ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.GetBoneMass
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bScaleMass                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float USkeletalMeshComponent::GetBoneMass(const struct FName& BoneName, bool bScaleMass)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.GetBoneMass");

	struct
	{
		struct FName                   BoneName;
		bool                           bScaleMass;
		float                          ReturnValue;
	} params;

	params.BoneName = BoneName;
	params.bScaleMass = bScaleMass;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.GetAnimInstance
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UAnimInstance*           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UAnimInstance* USkeletalMeshComponent::GetAnimInstance()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.GetAnimInstance");

	struct
	{
		class UAnimInstance*           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.GetAnimationMode
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TEnumAsByte<EAnimationMode>    ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

TEnumAsByte<EAnimationMode> USkeletalMeshComponent::GetAnimationMode()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.GetAnimationMode");

	struct
	{
		TEnumAsByte<EAnimationMode>    ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.GetAllowedAnimCurveEvaluate
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool USkeletalMeshComponent::GetAllowedAnimCurveEvaluate()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.GetAllowedAnimCurveEvaluate");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.ForceClothNextUpdateTeleportAndReset
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void USkeletalMeshComponent::ForceClothNextUpdateTeleportAndReset()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.ForceClothNextUpdateTeleportAndReset");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.ForceClothNextUpdateTeleport
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void USkeletalMeshComponent::ForceClothNextUpdateTeleport()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.ForceClothNextUpdateTeleport");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.FindConstraintBoneName
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            ConstraintIndex                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

struct FName USkeletalMeshComponent::FindConstraintBoneName(int ConstraintIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.FindConstraintBoneName");

	struct
	{
		int                            ConstraintIndex;
		struct FName                   ReturnValue;
	} params;

	params.ConstraintIndex = ConstraintIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SkeletalMeshComponent.ClearMorphTargets
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void USkeletalMeshComponent::ClearMorphTargets()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.ClearMorphTargets");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.BreakConstraint
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Impulse                        (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 HitLocation                    (CPF_Parm, CPF_IsPlainOldData)
// struct FName                   InBoneName                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::BreakConstraint(const struct FVector& Impulse, const struct FVector& HitLocation, const struct FName& InBoneName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.BreakConstraint");

	struct
	{
		struct FVector                 Impulse;
		struct FVector                 HitLocation;
		struct FName                   InBoneName;
	} params;

	params.Impulse = Impulse;
	params.HitLocation = HitLocation;
	params.InBoneName = InBoneName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.BindClothToMasterPoseComponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void USkeletalMeshComponent::BindClothToMasterPoseComponent()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.BindClothToMasterPoseComponent");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.AllowAnimCurveEvaluation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   NameOfCurve                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAllow                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::AllowAnimCurveEvaluation(const struct FName& NameOfCurve, bool bAllow)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.AllowAnimCurveEvaluation");

	struct
	{
		struct FName                   NameOfCurve;
		bool                           bAllow;
	} params;

	params.NameOfCurve = NameOfCurve;
	params.bAllow = bAllow;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.AddImpulseToAllBodiesBelow
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Impulse                        (CPF_Parm, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bVelChange                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bIncludeSelf                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::AddImpulseToAllBodiesBelow(const struct FVector& Impulse, const struct FName& BoneName, bool bVelChange, bool bIncludeSelf)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.AddImpulseToAllBodiesBelow");

	struct
	{
		struct FVector                 Impulse;
		struct FName                   BoneName;
		bool                           bVelChange;
		bool                           bIncludeSelf;
	} params;

	params.Impulse = Impulse;
	params.BoneName = BoneName;
	params.bVelChange = bVelChange;
	params.bIncludeSelf = bIncludeSelf;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.AddForceToAllBodiesBelow
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Force                          (CPF_Parm, CPF_IsPlainOldData)
// struct FName                   BoneName                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAccelChange                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bIncludeSelf                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::AddForceToAllBodiesBelow(const struct FVector& Force, const struct FName& BoneName, bool bAccelChange, bool bIncludeSelf)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.AddForceToAllBodiesBelow");

	struct
	{
		struct FVector                 Force;
		struct FName                   BoneName;
		bool                           bAccelChange;
		bool                           bIncludeSelf;
	} params;

	params.Force = Force;
	params.BoneName = BoneName;
	params.bAccelChange = bAccelChange;
	params.bIncludeSelf = bIncludeSelf;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SkeletalMeshComponent.AccumulateAllBodiesBelowPhysicsBlendWeight
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   InBoneName                     (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm, CPF_IsPlainOldData)
// float                          AddPhysicsBlendWeight          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bSkipCustomPhysicsType         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USkeletalMeshComponent::AccumulateAllBodiesBelowPhysicsBlendWeight(const struct FName& InBoneName, float AddPhysicsBlendWeight, bool bSkipCustomPhysicsType)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SkeletalMeshComponent.AccumulateAllBodiesBelowPhysicsBlendWeight");

	struct
	{
		struct FName                   InBoneName;
		float                          AddPhysicsBlendWeight;
		bool                           bSkipCustomPhysicsType;
	} params;

	params.InBoneName = InBoneName;
	params.AddPhysicsBlendWeight = AddPhysicsBlendWeight;
	params.bSkipCustomPhysicsType = bSkipCustomPhysicsType;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimInstance.UnlockAIResources
// (FUNC_Final, FUNC_BlueprintAuthorityOnly, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bUnlockMovement                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           UnlockAILogic                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimInstance::UnlockAIResources(bool bUnlockMovement, bool UnlockAILogic)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.UnlockAIResources");

	struct
	{
		bool                           bUnlockMovement;
		bool                           UnlockAILogic;
	} params;

	params.bUnlockMovement = bUnlockMovement;
	params.UnlockAILogic = UnlockAILogic;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimInstance.TryGetPawnOwner
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class APawn*                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class APawn* UAnimInstance::TryGetPawnOwner()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.TryGetPawnOwner");

	struct
	{
		class APawn*                   ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.StopSlotAnimation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InBlendOutTime                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   SlotNodeName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimInstance::StopSlotAnimation(float InBlendOutTime, const struct FName& SlotNodeName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.StopSlotAnimation");

	struct
	{
		float                          InBlendOutTime;
		struct FName                   SlotNodeName;
	} params;

	params.InBlendOutTime = InBlendOutTime;
	params.SlotNodeName = SlotNodeName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimInstance.SnapshotPose
// (FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// struct FPoseSnapshot           Snapshot                       (CPF_Parm, CPF_OutParm, CPF_ReferenceParm)

void UAnimInstance::SnapshotPose(struct FPoseSnapshot* Snapshot)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.SnapshotPose");

	struct
	{
		struct FPoseSnapshot           Snapshot;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (Snapshot != nullptr)
		*Snapshot = params.Snapshot;
}


// Function Engine.AnimInstance.SetRootMotionMode
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// TEnumAsByte<ERootMotionMode>   Value                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimInstance::SetRootMotionMode(TEnumAsByte<ERootMotionMode> Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.SetRootMotionMode");

	struct
	{
		TEnumAsByte<ERootMotionMode>   Value;
	} params;

	params.Value = Value;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimInstance.SetMorphTarget
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   MorphTargetName                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Value                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimInstance::SetMorphTarget(const struct FName& MorphTargetName, float Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.SetMorphTarget");

	struct
	{
		struct FName                   MorphTargetName;
		float                          Value;
	} params;

	params.MorphTargetName = MorphTargetName;
	params.Value = Value;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimInstance.SavePoseSnapshot
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   SnapshotName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimInstance::SavePoseSnapshot(const struct FName& SnapshotName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.SavePoseSnapshot");

	struct
	{
		struct FName                   SnapshotName;
	} params;

	params.SnapshotName = SnapshotName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimInstance.PlaySlotAnimationAsDynamicMontage
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UAnimSequenceBase*       Asset                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   SlotNodeName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          BlendInTime                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          BlendOutTime                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InPlayRate                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            LoopCount                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          BlendOutTriggerTime            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InTimeToStartMontageAt         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UAnimMontage*            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UAnimMontage* UAnimInstance::PlaySlotAnimationAsDynamicMontage(class UAnimSequenceBase* Asset, const struct FName& SlotNodeName, float BlendInTime, float BlendOutTime, float InPlayRate, int LoopCount, float BlendOutTriggerTime, float InTimeToStartMontageAt)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.PlaySlotAnimationAsDynamicMontage");

	struct
	{
		class UAnimSequenceBase*       Asset;
		struct FName                   SlotNodeName;
		float                          BlendInTime;
		float                          BlendOutTime;
		float                          InPlayRate;
		int                            LoopCount;
		float                          BlendOutTriggerTime;
		float                          InTimeToStartMontageAt;
		class UAnimMontage*            ReturnValue;
	} params;

	params.Asset = Asset;
	params.SlotNodeName = SlotNodeName;
	params.BlendInTime = BlendInTime;
	params.BlendOutTime = BlendOutTime;
	params.InPlayRate = InPlayRate;
	params.LoopCount = LoopCount;
	params.BlendOutTriggerTime = BlendOutTriggerTime;
	params.InTimeToStartMontageAt = InTimeToStartMontageAt;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.PlaySlotAnimation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UAnimSequenceBase*       Asset                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   SlotNodeName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          BlendInTime                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          BlendOutTime                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InPlayRate                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            LoopCount                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::PlaySlotAnimation(class UAnimSequenceBase* Asset, const struct FName& SlotNodeName, float BlendInTime, float BlendOutTime, float InPlayRate, int LoopCount)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.PlaySlotAnimation");

	struct
	{
		class UAnimSequenceBase*       Asset;
		struct FName                   SlotNodeName;
		float                          BlendInTime;
		float                          BlendOutTime;
		float                          InPlayRate;
		int                            LoopCount;
		float                          ReturnValue;
	} params;

	params.Asset = Asset;
	params.SlotNodeName = SlotNodeName;
	params.BlendInTime = BlendInTime;
	params.BlendOutTime = BlendOutTime;
	params.InPlayRate = InPlayRate;
	params.LoopCount = LoopCount;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.Montage_Stop
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InBlendOutTime                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UAnimMontage*            Montage                        (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimInstance::Montage_Stop(float InBlendOutTime, class UAnimMontage* Montage)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.Montage_Stop");

	struct
	{
		float                          InBlendOutTime;
		class UAnimMontage*            Montage;
	} params;

	params.InBlendOutTime = InBlendOutTime;
	params.Montage = Montage;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimInstance.Montage_SetPosition
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UAnimMontage*            Montage                        (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          NewPosition                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimInstance::Montage_SetPosition(class UAnimMontage* Montage, float NewPosition)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.Montage_SetPosition");

	struct
	{
		class UAnimMontage*            Montage;
		float                          NewPosition;
	} params;

	params.Montage = Montage;
	params.NewPosition = NewPosition;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimInstance.Montage_SetPlayRate
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UAnimMontage*            Montage                        (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          NewPlayRate                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimInstance::Montage_SetPlayRate(class UAnimMontage* Montage, float NewPlayRate)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.Montage_SetPlayRate");

	struct
	{
		class UAnimMontage*            Montage;
		float                          NewPlayRate;
	} params;

	params.Montage = Montage;
	params.NewPlayRate = NewPlayRate;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimInstance.Montage_SetNextSection
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   SectionNameToChange            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   NextSection                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UAnimMontage*            Montage                        (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimInstance::Montage_SetNextSection(const struct FName& SectionNameToChange, const struct FName& NextSection, class UAnimMontage* Montage)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.Montage_SetNextSection");

	struct
	{
		struct FName                   SectionNameToChange;
		struct FName                   NextSection;
		class UAnimMontage*            Montage;
	} params;

	params.SectionNameToChange = SectionNameToChange;
	params.NextSection = NextSection;
	params.Montage = Montage;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimInstance.Montage_Resume
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UAnimMontage*            Montage                        (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimInstance::Montage_Resume(class UAnimMontage* Montage)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.Montage_Resume");

	struct
	{
		class UAnimMontage*            Montage;
	} params;

	params.Montage = Montage;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimInstance.Montage_Play
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UAnimMontage*            MontageToPlay                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InPlayRate                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// EMontagePlayReturnType         ReturnValueType                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InTimeToStartMontageAt         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bStopAllMontages               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::Montage_Play(class UAnimMontage* MontageToPlay, float InPlayRate, EMontagePlayReturnType ReturnValueType, float InTimeToStartMontageAt, bool bStopAllMontages)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.Montage_Play");

	struct
	{
		class UAnimMontage*            MontageToPlay;
		float                          InPlayRate;
		EMontagePlayReturnType         ReturnValueType;
		float                          InTimeToStartMontageAt;
		bool                           bStopAllMontages;
		float                          ReturnValue;
	} params;

	params.MontageToPlay = MontageToPlay;
	params.InPlayRate = InPlayRate;
	params.ReturnValueType = ReturnValueType;
	params.InTimeToStartMontageAt = InTimeToStartMontageAt;
	params.bStopAllMontages = bStopAllMontages;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.Montage_Pause
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UAnimMontage*            Montage                        (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimInstance::Montage_Pause(class UAnimMontage* Montage)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.Montage_Pause");

	struct
	{
		class UAnimMontage*            Montage;
	} params;

	params.Montage = Montage;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimInstance.Montage_JumpToSectionsEnd
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   SectionName                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UAnimMontage*            Montage                        (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimInstance::Montage_JumpToSectionsEnd(const struct FName& SectionName, class UAnimMontage* Montage)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.Montage_JumpToSectionsEnd");

	struct
	{
		struct FName                   SectionName;
		class UAnimMontage*            Montage;
	} params;

	params.SectionName = SectionName;
	params.Montage = Montage;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimInstance.Montage_JumpToSection
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   SectionName                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UAnimMontage*            Montage                        (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimInstance::Montage_JumpToSection(const struct FName& SectionName, class UAnimMontage* Montage)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.Montage_JumpToSection");

	struct
	{
		struct FName                   SectionName;
		class UAnimMontage*            Montage;
	} params;

	params.SectionName = SectionName;
	params.Montage = Montage;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimInstance.Montage_IsPlaying
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UAnimMontage*            Montage                        (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UAnimInstance::Montage_IsPlaying(class UAnimMontage* Montage)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.Montage_IsPlaying");

	struct
	{
		class UAnimMontage*            Montage;
		bool                           ReturnValue;
	} params;

	params.Montage = Montage;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.Montage_IsActive
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UAnimMontage*            Montage                        (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UAnimInstance::Montage_IsActive(class UAnimMontage* Montage)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.Montage_IsActive");

	struct
	{
		class UAnimMontage*            Montage;
		bool                           ReturnValue;
	} params;

	params.Montage = Montage;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.Montage_GetPosition
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UAnimMontage*            Montage                        (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::Montage_GetPosition(class UAnimMontage* Montage)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.Montage_GetPosition");

	struct
	{
		class UAnimMontage*            Montage;
		float                          ReturnValue;
	} params;

	params.Montage = Montage;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.Montage_GetPlayRate
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UAnimMontage*            Montage                        (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::Montage_GetPlayRate(class UAnimMontage* Montage)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.Montage_GetPlayRate");

	struct
	{
		class UAnimMontage*            Montage;
		float                          ReturnValue;
	} params;

	params.Montage = Montage;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.Montage_GetIsStopped
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UAnimMontage*            Montage                        (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UAnimInstance::Montage_GetIsStopped(class UAnimMontage* Montage)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.Montage_GetIsStopped");

	struct
	{
		class UAnimMontage*            Montage;
		bool                           ReturnValue;
	} params;

	params.Montage = Montage;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.Montage_GetCurrentSection
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UAnimMontage*            Montage                        (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

struct FName UAnimInstance::Montage_GetCurrentSection(class UAnimMontage* Montage)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.Montage_GetCurrentSection");

	struct
	{
		class UAnimMontage*            Montage;
		struct FName                   ReturnValue;
	} params;

	params.Montage = Montage;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.Montage_GetBlendTime
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UAnimMontage*            Montage                        (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::Montage_GetBlendTime(class UAnimMontage* Montage)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.Montage_GetBlendTime");

	struct
	{
		class UAnimMontage*            Montage;
		float                          ReturnValue;
	} params;

	params.Montage = Montage;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.LockAIResources
// (FUNC_Final, FUNC_BlueprintAuthorityOnly, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bLockMovement                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           LockAILogic                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimInstance::LockAIResources(bool bLockMovement, bool LockAILogic)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.LockAIResources");

	struct
	{
		bool                           bLockMovement;
		bool                           LockAILogic;
	} params;

	params.bLockMovement = bLockMovement;
	params.LockAILogic = LockAILogic;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimInstance.IsSyncGroupBetweenMarkers
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   InSyncGroupName                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   PreviousMarker                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   NextMarker                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bRespectMarkerOrder            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UAnimInstance::IsSyncGroupBetweenMarkers(const struct FName& InSyncGroupName, const struct FName& PreviousMarker, const struct FName& NextMarker, bool bRespectMarkerOrder)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.IsSyncGroupBetweenMarkers");

	struct
	{
		struct FName                   InSyncGroupName;
		struct FName                   PreviousMarker;
		struct FName                   NextMarker;
		bool                           bRespectMarkerOrder;
		bool                           ReturnValue;
	} params;

	params.InSyncGroupName = InSyncGroupName;
	params.PreviousMarker = PreviousMarker;
	params.NextMarker = NextMarker;
	params.bRespectMarkerOrder = bRespectMarkerOrder;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.IsPlayingSlotAnimation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UAnimSequenceBase*       Asset                          (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   SlotNodeName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UAnimInstance::IsPlayingSlotAnimation(class UAnimSequenceBase* Asset, const struct FName& SlotNodeName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.IsPlayingSlotAnimation");

	struct
	{
		class UAnimSequenceBase*       Asset;
		struct FName                   SlotNodeName;
		bool                           ReturnValue;
	} params;

	params.Asset = Asset;
	params.SlotNodeName = SlotNodeName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.IsAnyMontagePlaying
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UAnimInstance::IsAnyMontagePlaying()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.IsAnyMontagePlaying");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.HasMarkerBeenHitThisFrame
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   SyncGroup                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   MarkerName                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UAnimInstance::HasMarkerBeenHitThisFrame(const struct FName& SyncGroup, const struct FName& MarkerName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.HasMarkerBeenHitThisFrame");

	struct
	{
		struct FName                   SyncGroup;
		struct FName                   MarkerName;
		bool                           ReturnValue;
	} params;

	params.SyncGroup = SyncGroup;
	params.MarkerName = MarkerName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetTimeToClosestMarker
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   SyncGroup                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   MarkerName                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          OutMarkerTime                  (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UAnimInstance::GetTimeToClosestMarker(const struct FName& SyncGroup, const struct FName& MarkerName, float* OutMarkerTime)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetTimeToClosestMarker");

	struct
	{
		struct FName                   SyncGroup;
		struct FName                   MarkerName;
		float                          OutMarkerTime;
		bool                           ReturnValue;
	} params;

	params.SyncGroup = SyncGroup;
	params.MarkerName = MarkerName;

	UObject::ProcessEvent(fn, &params);

	if (OutMarkerTime != nullptr)
		*OutMarkerTime = params.OutMarkerTime;

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetSyncGroupPosition
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   InSyncGroupName                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FMarkerSyncAnimPosition ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm)

struct FMarkerSyncAnimPosition UAnimInstance::GetSyncGroupPosition(const struct FName& InSyncGroupName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetSyncGroupPosition");

	struct
	{
		struct FName                   InSyncGroupName;
		struct FMarkerSyncAnimPosition ReturnValue;
	} params;

	params.InSyncGroupName = InSyncGroupName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetRelevantAnimTimeRemainingFraction
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            MachineIndex                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            StateIndex                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::GetRelevantAnimTimeRemainingFraction(int MachineIndex, int StateIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetRelevantAnimTimeRemainingFraction");

	struct
	{
		int                            MachineIndex;
		int                            StateIndex;
		float                          ReturnValue;
	} params;

	params.MachineIndex = MachineIndex;
	params.StateIndex = StateIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetRelevantAnimTimeRemaining
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            MachineIndex                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            StateIndex                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::GetRelevantAnimTimeRemaining(int MachineIndex, int StateIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetRelevantAnimTimeRemaining");

	struct
	{
		int                            MachineIndex;
		int                            StateIndex;
		float                          ReturnValue;
	} params;

	params.MachineIndex = MachineIndex;
	params.StateIndex = StateIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetRelevantAnimTimeFraction
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            MachineIndex                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            StateIndex                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::GetRelevantAnimTimeFraction(int MachineIndex, int StateIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetRelevantAnimTimeFraction");

	struct
	{
		int                            MachineIndex;
		int                            StateIndex;
		float                          ReturnValue;
	} params;

	params.MachineIndex = MachineIndex;
	params.StateIndex = StateIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetRelevantAnimTime
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            MachineIndex                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            StateIndex                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::GetRelevantAnimTime(int MachineIndex, int StateIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetRelevantAnimTime");

	struct
	{
		int                            MachineIndex;
		int                            StateIndex;
		float                          ReturnValue;
	} params;

	params.MachineIndex = MachineIndex;
	params.StateIndex = StateIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetRelevantAnimLength
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            MachineIndex                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            StateIndex                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::GetRelevantAnimLength(int MachineIndex, int StateIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetRelevantAnimLength");

	struct
	{
		int                            MachineIndex;
		int                            StateIndex;
		float                          ReturnValue;
	} params;

	params.MachineIndex = MachineIndex;
	params.StateIndex = StateIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetOwningComponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class USkeletalMeshComponent*  ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_InstancedReference, CPF_IsPlainOldData)

class USkeletalMeshComponent* UAnimInstance::GetOwningComponent()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetOwningComponent");

	struct
	{
		class USkeletalMeshComponent*  ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetOwningActor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AActor*                  ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class AActor* UAnimInstance::GetOwningActor()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetOwningActor");

	struct
	{
		class AActor*                  ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetInstanceTransitionTimeElapsedFraction
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            MachineIndex                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            TransitionIndex                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::GetInstanceTransitionTimeElapsedFraction(int MachineIndex, int TransitionIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetInstanceTransitionTimeElapsedFraction");

	struct
	{
		int                            MachineIndex;
		int                            TransitionIndex;
		float                          ReturnValue;
	} params;

	params.MachineIndex = MachineIndex;
	params.TransitionIndex = TransitionIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetInstanceTransitionTimeElapsed
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            MachineIndex                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            TransitionIndex                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::GetInstanceTransitionTimeElapsed(int MachineIndex, int TransitionIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetInstanceTransitionTimeElapsed");

	struct
	{
		int                            MachineIndex;
		int                            TransitionIndex;
		float                          ReturnValue;
	} params;

	params.MachineIndex = MachineIndex;
	params.TransitionIndex = TransitionIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetInstanceTransitionCrossfadeDuration
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            MachineIndex                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            TransitionIndex                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::GetInstanceTransitionCrossfadeDuration(int MachineIndex, int TransitionIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetInstanceTransitionCrossfadeDuration");

	struct
	{
		int                            MachineIndex;
		int                            TransitionIndex;
		float                          ReturnValue;
	} params;

	params.MachineIndex = MachineIndex;
	params.TransitionIndex = TransitionIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetInstanceStateWeight
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            MachineIndex                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            StateIndex                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::GetInstanceStateWeight(int MachineIndex, int StateIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetInstanceStateWeight");

	struct
	{
		int                            MachineIndex;
		int                            StateIndex;
		float                          ReturnValue;
	} params;

	params.MachineIndex = MachineIndex;
	params.StateIndex = StateIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetInstanceMachineWeight
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            MachineIndex                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::GetInstanceMachineWeight(int MachineIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetInstanceMachineWeight");

	struct
	{
		int                            MachineIndex;
		float                          ReturnValue;
	} params;

	params.MachineIndex = MachineIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetInstanceCurrentStateElapsedTime
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            MachineIndex                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::GetInstanceCurrentStateElapsedTime(int MachineIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetInstanceCurrentStateElapsedTime");

	struct
	{
		int                            MachineIndex;
		float                          ReturnValue;
	} params;

	params.MachineIndex = MachineIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetInstanceAssetPlayerTimeFromEndFraction
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            AssetPlayerIndex               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::GetInstanceAssetPlayerTimeFromEndFraction(int AssetPlayerIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetInstanceAssetPlayerTimeFromEndFraction");

	struct
	{
		int                            AssetPlayerIndex;
		float                          ReturnValue;
	} params;

	params.AssetPlayerIndex = AssetPlayerIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetInstanceAssetPlayerTimeFromEnd
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            AssetPlayerIndex               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::GetInstanceAssetPlayerTimeFromEnd(int AssetPlayerIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetInstanceAssetPlayerTimeFromEnd");

	struct
	{
		int                            AssetPlayerIndex;
		float                          ReturnValue;
	} params;

	params.AssetPlayerIndex = AssetPlayerIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetInstanceAssetPlayerTimeFraction
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            AssetPlayerIndex               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::GetInstanceAssetPlayerTimeFraction(int AssetPlayerIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetInstanceAssetPlayerTimeFraction");

	struct
	{
		int                            AssetPlayerIndex;
		float                          ReturnValue;
	} params;

	params.AssetPlayerIndex = AssetPlayerIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetInstanceAssetPlayerTime
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            AssetPlayerIndex               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::GetInstanceAssetPlayerTime(int AssetPlayerIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetInstanceAssetPlayerTime");

	struct
	{
		int                            AssetPlayerIndex;
		float                          ReturnValue;
	} params;

	params.AssetPlayerIndex = AssetPlayerIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetInstanceAssetPlayerLength
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            AssetPlayerIndex               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::GetInstanceAssetPlayerLength(int AssetPlayerIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetInstanceAssetPlayerLength");

	struct
	{
		int                            AssetPlayerIndex;
		float                          ReturnValue;
	} params;

	params.AssetPlayerIndex = AssetPlayerIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetCurveValue
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// struct FName                   CurveName                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::GetCurveValue(const struct FName& CurveName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetCurveValue");

	struct
	{
		struct FName                   CurveName;
		float                          ReturnValue;
	} params;

	params.CurveName = CurveName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetCurrentStateName
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            MachineIndex                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

struct FName UAnimInstance::GetCurrentStateName(int MachineIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetCurrentStateName");

	struct
	{
		int                            MachineIndex;
		struct FName                   ReturnValue;
	} params;

	params.MachineIndex = MachineIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.GetCurrentActiveMontage
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UAnimMontage*            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UAnimMontage* UAnimInstance::GetCurrentActiveMontage()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.GetCurrentActiveMontage");

	struct
	{
		class UAnimMontage*            ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.ClearMorphTargets
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UAnimInstance::ClearMorphTargets()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.ClearMorphTargets");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimInstance.CalculateDirection
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 Velocity                       (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// struct FRotator                BaseRotation                   (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimInstance::CalculateDirection(const struct FVector& Velocity, const struct FRotator& BaseRotation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.CalculateDirection");

	struct
	{
		struct FVector                 Velocity;
		struct FRotator                BaseRotation;
		float                          ReturnValue;
	} params;

	params.Velocity = Velocity;
	params.BaseRotation = BaseRotation;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimInstance.BlueprintUpdateAnimation
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// float                          DeltaTimeX                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimInstance::BlueprintUpdateAnimation(float DeltaTimeX)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.BlueprintUpdateAnimation");

	struct
	{
		float                          DeltaTimeX;
	} params;

	params.DeltaTimeX = DeltaTimeX;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimInstance.BlueprintPostEvaluateAnimation
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)

void UAnimInstance::BlueprintPostEvaluateAnimation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.BlueprintPostEvaluateAnimation");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimInstance.BlueprintInitializeAnimation
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)

void UAnimInstance::BlueprintInitializeAnimation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.BlueprintInitializeAnimation");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimInstance.BlueprintBeginPlay
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)

void UAnimInstance::BlueprintBeginPlay()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimInstance.BlueprintBeginPlay");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimNotify.Received_Notify
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent, FUNC_Const)
// Parameters:
// class USkeletalMeshComponent*  MeshComp                       (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// class UAnimSequenceBase*       Animation                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UAnimNotify::Received_Notify(class USkeletalMeshComponent* MeshComp, class UAnimSequenceBase* Animation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimNotify.Received_Notify");

	struct
	{
		class USkeletalMeshComponent*  MeshComp;
		class UAnimSequenceBase*       Animation;
		bool                           ReturnValue;
	} params;

	params.MeshComp = MeshComp;
	params.Animation = Animation;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimNotify.GetNotifyName
// (FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent, FUNC_Const)
// Parameters:
// struct FString                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm)

struct FString UAnimNotify::GetNotifyName()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimNotify.GetNotifyName");

	struct
	{
		struct FString                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimNotifyState.Received_NotifyTick
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent, FUNC_Const)
// Parameters:
// class USkeletalMeshComponent*  MeshComp                       (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// class UAnimSequenceBase*       Animation                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          FrameDeltaTime                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UAnimNotifyState::Received_NotifyTick(class USkeletalMeshComponent* MeshComp, class UAnimSequenceBase* Animation, float FrameDeltaTime)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimNotifyState.Received_NotifyTick");

	struct
	{
		class USkeletalMeshComponent*  MeshComp;
		class UAnimSequenceBase*       Animation;
		float                          FrameDeltaTime;
		bool                           ReturnValue;
	} params;

	params.MeshComp = MeshComp;
	params.Animation = Animation;
	params.FrameDeltaTime = FrameDeltaTime;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimNotifyState.Received_NotifyEnd
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent, FUNC_Const)
// Parameters:
// class USkeletalMeshComponent*  MeshComp                       (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// class UAnimSequenceBase*       Animation                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UAnimNotifyState::Received_NotifyEnd(class USkeletalMeshComponent* MeshComp, class UAnimSequenceBase* Animation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimNotifyState.Received_NotifyEnd");

	struct
	{
		class USkeletalMeshComponent*  MeshComp;
		class UAnimSequenceBase*       Animation;
		bool                           ReturnValue;
	} params;

	params.MeshComp = MeshComp;
	params.Animation = Animation;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimNotifyState.Received_NotifyBegin
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent, FUNC_Const)
// Parameters:
// class USkeletalMeshComponent*  MeshComp                       (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// class UAnimSequenceBase*       Animation                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          TotalDuration                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UAnimNotifyState::Received_NotifyBegin(class USkeletalMeshComponent* MeshComp, class UAnimSequenceBase* Animation, float TotalDuration)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimNotifyState.Received_NotifyBegin");

	struct
	{
		class USkeletalMeshComponent*  MeshComp;
		class UAnimSequenceBase*       Animation;
		float                          TotalDuration;
		bool                           ReturnValue;
	} params;

	params.MeshComp = MeshComp;
	params.Animation = Animation;
	params.TotalDuration = TotalDuration;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimNotifyState.GetNotifyName
// (FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent, FUNC_Const)
// Parameters:
// struct FString                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm)

struct FString UAnimNotifyState::GetNotifyName()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimNotifyState.GetNotifyName");

	struct
	{
		struct FString                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameInstance.ReceiveShutdown
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)

void UGameInstance::ReceiveShutdown()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameInstance.ReceiveShutdown");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameInstance.ReceiveInit
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)

void UGameInstance::ReceiveInit()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameInstance.ReceiveInit");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameInstance.HandleTravelError
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// TEnumAsByte<ETravelFailure>    FailureType                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UGameInstance::HandleTravelError(TEnumAsByte<ETravelFailure> FailureType)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameInstance.HandleTravelError");

	struct
	{
		TEnumAsByte<ETravelFailure>    FailureType;
	} params;

	params.FailureType = FailureType;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameInstance.HandleNetworkError
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// TEnumAsByte<ENetworkFailure>   FailureType                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bIsServer                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UGameInstance::HandleNetworkError(TEnumAsByte<ENetworkFailure> FailureType, bool bIsServer)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameInstance.HandleNetworkError");

	struct
	{
		TEnumAsByte<ENetworkFailure>   FailureType;
		bool                           bIsServer;
	} params;

	params.FailureType = FailureType;
	params.bIsServer = bIsServer;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameInstance.DebugRemovePlayer
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// int                            ControllerId                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UGameInstance::DebugRemovePlayer(int ControllerId)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameInstance.DebugRemovePlayer");

	struct
	{
		int                            ControllerId;
	} params;

	params.ControllerId = ControllerId;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameInstance.DebugCreatePlayer
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// int                            ControllerId                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UGameInstance::DebugCreatePlayer(int ControllerId)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameInstance.DebugCreatePlayer");

	struct
	{
		int                            ControllerId;
	} params;

	params.ControllerId = ControllerId;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameModeBase.StartPlay
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AGameModeBase::StartPlay()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.StartPlay");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameModeBase.SpawnDefaultPawnFor
// (FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class AController*             NewPlayer                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class AActor*                  StartSpot                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class APawn*                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class APawn* AGameModeBase::SpawnDefaultPawnFor(class AController* NewPlayer, class AActor* StartSpot)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.SpawnDefaultPawnFor");

	struct
	{
		class AController*             NewPlayer;
		class AActor*                  StartSpot;
		class APawn*                   ReturnValue;
	} params;

	params.NewPlayer = NewPlayer;
	params.StartSpot = StartSpot;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameModeBase.SpawnDefaultPawnAtTransform
// (FUNC_Native, FUNC_Event, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintEvent)
// Parameters:
// class AController*             NewPlayer                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FTransform              SpawnTransform                 (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// class APawn*                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class APawn* AGameModeBase::SpawnDefaultPawnAtTransform(class AController* NewPlayer, const struct FTransform& SpawnTransform)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.SpawnDefaultPawnAtTransform");

	struct
	{
		class AController*             NewPlayer;
		struct FTransform              SpawnTransform;
		class APawn*                   ReturnValue;
	} params;

	params.NewPlayer = NewPlayer;
	params.SpawnTransform = SpawnTransform;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameModeBase.ShouldReset
// (FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class AActor*                  ActorToReset                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AGameModeBase::ShouldReset(class AActor* ActorToReset)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.ShouldReset");

	struct
	{
		class AActor*                  ActorToReset;
		bool                           ReturnValue;
	} params;

	params.ActorToReset = ActorToReset;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameModeBase.ReturnToMainMenuHost
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AGameModeBase::ReturnToMainMenuHost()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.ReturnToMainMenuHost");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameModeBase.RestartPlayerAtTransform
// (FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class AController*             NewPlayer                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FTransform              SpawnTransform                 (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)

void AGameModeBase::RestartPlayerAtTransform(class AController* NewPlayer, const struct FTransform& SpawnTransform)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.RestartPlayerAtTransform");

	struct
	{
		class AController*             NewPlayer;
		struct FTransform              SpawnTransform;
	} params;

	params.NewPlayer = NewPlayer;
	params.SpawnTransform = SpawnTransform;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameModeBase.RestartPlayerAtPlayerStart
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class AController*             NewPlayer                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class AActor*                  StartSpot                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AGameModeBase::RestartPlayerAtPlayerStart(class AController* NewPlayer, class AActor* StartSpot)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.RestartPlayerAtPlayerStart");

	struct
	{
		class AController*             NewPlayer;
		class AActor*                  StartSpot;
	} params;

	params.NewPlayer = NewPlayer;
	params.StartSpot = StartSpot;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameModeBase.RestartPlayer
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class AController*             NewPlayer                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AGameModeBase::RestartPlayer(class AController* NewPlayer)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.RestartPlayer");

	struct
	{
		class AController*             NewPlayer;
	} params;

	params.NewPlayer = NewPlayer;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameModeBase.ResetLevel
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AGameModeBase::ResetLevel()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.ResetLevel");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameModeBase.PlayerCanRestart
// (FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class APlayerController*       Player                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AGameModeBase::PlayerCanRestart(class APlayerController* Player)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.PlayerCanRestart");

	struct
	{
		class APlayerController*       Player;
		bool                           ReturnValue;
	} params;

	params.Player = Player;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameModeBase.MustSpectate
// (FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent, FUNC_Const)
// Parameters:
// class APlayerController*       NewPlayerController            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AGameModeBase::MustSpectate(class APlayerController* NewPlayerController)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.MustSpectate");

	struct
	{
		class APlayerController*       NewPlayerController;
		bool                           ReturnValue;
	} params;

	params.NewPlayerController = NewPlayerController;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameModeBase.K2_PostLogin
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class APlayerController*       NewPlayer                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AGameModeBase::K2_PostLogin(class APlayerController* NewPlayer)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.K2_PostLogin");

	struct
	{
		class APlayerController*       NewPlayer;
	} params;

	params.NewPlayer = NewPlayer;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameModeBase.K2_OnSwapPlayerControllers
// (FUNC_Event, FUNC_Protected, FUNC_BlueprintEvent)
// Parameters:
// class APlayerController*       OldPC                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class APlayerController*       NewPC                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AGameModeBase::K2_OnSwapPlayerControllers(class APlayerController* OldPC, class APlayerController* NewPC)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.K2_OnSwapPlayerControllers");

	struct
	{
		class APlayerController*       OldPC;
		class APlayerController*       NewPC;
	} params;

	params.OldPC = OldPC;
	params.NewPC = NewPC;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameModeBase.K2_OnRestartPlayer
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class AController*             NewPlayer                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AGameModeBase::K2_OnRestartPlayer(class AController* NewPlayer)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.K2_OnRestartPlayer");

	struct
	{
		class AController*             NewPlayer;
	} params;

	params.NewPlayer = NewPlayer;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameModeBase.K2_OnLogout
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class AController*             ExitingController              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AGameModeBase::K2_OnLogout(class AController* ExitingController)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.K2_OnLogout");

	struct
	{
		class AController*             ExitingController;
	} params;

	params.ExitingController = ExitingController;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameModeBase.K2_OnChangeName
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class AController*             Other                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FString                 NewName                        (CPF_Parm, CPF_ZeroConstructor)
// bool                           bNameChange                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AGameModeBase::K2_OnChangeName(class AController* Other, const struct FString& NewName, bool bNameChange)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.K2_OnChangeName");

	struct
	{
		class AController*             Other;
		struct FString                 NewName;
		bool                           bNameChange;
	} params;

	params.Other = Other;
	params.NewName = NewName;
	params.bNameChange = bNameChange;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameModeBase.K2_FindPlayerStart
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// class AController*             Player                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FString                 IncomingName                   (CPF_Parm, CPF_ZeroConstructor)
// class AActor*                  ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class AActor* AGameModeBase::K2_FindPlayerStart(class AController* Player, const struct FString& IncomingName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.K2_FindPlayerStart");

	struct
	{
		class AController*             Player;
		struct FString                 IncomingName;
		class AActor*                  ReturnValue;
	} params;

	params.Player = Player;
	params.IncomingName = IncomingName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameModeBase.InitStartSpot
// (FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class AActor*                  StartSpot                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class AController*             NewPlayer                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AGameModeBase::InitStartSpot(class AActor* StartSpot, class AController* NewPlayer)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.InitStartSpot");

	struct
	{
		class AActor*                  StartSpot;
		class AController*             NewPlayer;
	} params;

	params.StartSpot = StartSpot;
	params.NewPlayer = NewPlayer;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameModeBase.InitializeHUDForPlayer
// (FUNC_Native, FUNC_Event, FUNC_Protected, FUNC_BlueprintEvent)
// Parameters:
// class APlayerController*       NewPlayer                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AGameModeBase::InitializeHUDForPlayer(class APlayerController* NewPlayer)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.InitializeHUDForPlayer");

	struct
	{
		class APlayerController*       NewPlayer;
	} params;

	params.NewPlayer = NewPlayer;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameModeBase.HasMatchStarted
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AGameModeBase::HasMatchStarted()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.HasMatchStarted");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameModeBase.HandleStartingNewPlayer
// (FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class APlayerController*       NewPlayer                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AGameModeBase::HandleStartingNewPlayer(class APlayerController* NewPlayer)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.HandleStartingNewPlayer");

	struct
	{
		class APlayerController*       NewPlayer;
	} params;

	params.NewPlayer = NewPlayer;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameModeBase.GetNumSpectators
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

int AGameModeBase::GetNumSpectators()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.GetNumSpectators");

	struct
	{
		int                            ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameModeBase.GetNumPlayers
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

int AGameModeBase::GetNumPlayers()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.GetNumPlayers");

	struct
	{
		int                            ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameModeBase.GetDefaultPawnClassForController
// (FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintEvent)
// Parameters:
// class AController*             InController                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UClass*                  ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UClass* AGameModeBase::GetDefaultPawnClassForController(class AController* InController)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.GetDefaultPawnClassForController");

	struct
	{
		class AController*             InController;
		class UClass*                  ReturnValue;
	} params;

	params.InController = InController;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameModeBase.FindPlayerStart
// (FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class AController*             Player                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FString                 IncomingName                   (CPF_Parm, CPF_ZeroConstructor)
// class AActor*                  ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class AActor* AGameModeBase::FindPlayerStart(class AController* Player, const struct FString& IncomingName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.FindPlayerStart");

	struct
	{
		class AController*             Player;
		struct FString                 IncomingName;
		class AActor*                  ReturnValue;
	} params;

	params.Player = Player;
	params.IncomingName = IncomingName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameModeBase.ChoosePlayerStart
// (FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class AController*             Player                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class AActor*                  ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class AActor* AGameModeBase::ChoosePlayerStart(class AController* Player)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.ChoosePlayerStart");

	struct
	{
		class AController*             Player;
		class AActor*                  ReturnValue;
	} params;

	params.Player = Player;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameModeBase.ChangeName
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class AController*             Controller                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FString                 NewName                        (CPF_Parm, CPF_ZeroConstructor)
// bool                           bNameChange                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AGameModeBase::ChangeName(class AController* Controller, const struct FString& NewName, bool bNameChange)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.ChangeName");

	struct
	{
		class AController*             Controller;
		struct FString                 NewName;
		bool                           bNameChange;
	} params;

	params.Controller = Controller;
	params.NewName = NewName;
	params.bNameChange = bNameChange;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameModeBase.CanSpectate
// (FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class APlayerController*       Viewer                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class APlayerState*            ViewTarget                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AGameModeBase::CanSpectate(class APlayerController* Viewer, class APlayerState* ViewTarget)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameModeBase.CanSpectate");

	struct
	{
		class APlayerController*       Viewer;
		class APlayerState*            ViewTarget;
		bool                           ReturnValue;
	} params;

	params.Viewer = Viewer;
	params.ViewTarget = ViewTarget;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameMode.StartMatch
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AGameMode::StartMatch()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameMode.StartMatch");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameMode.SetBandwidthLimit
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// float                          AsyncIOBandwidthLimit          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AGameMode::SetBandwidthLimit(float AsyncIOBandwidthLimit)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameMode.SetBandwidthLimit");

	struct
	{
		float                          AsyncIOBandwidthLimit;
	} params;

	params.AsyncIOBandwidthLimit = AsyncIOBandwidthLimit;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameMode.Say
// (FUNC_Exec, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FString                 Msg                            (CPF_Parm, CPF_ZeroConstructor)

void AGameMode::Say(const struct FString& Msg)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameMode.Say");

	struct
	{
		struct FString                 Msg;
	} params;

	params.Msg = Msg;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameMode.RestartGame
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AGameMode::RestartGame()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameMode.RestartGame");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameMode.ReadyToStartMatch
// (FUNC_Native, FUNC_Event, FUNC_Protected, FUNC_BlueprintEvent)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AGameMode::ReadyToStartMatch()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameMode.ReadyToStartMatch");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameMode.ReadyToEndMatch
// (FUNC_Native, FUNC_Event, FUNC_Protected, FUNC_BlueprintEvent)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AGameMode::ReadyToEndMatch()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameMode.ReadyToEndMatch");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameMode.K2_OnSetMatchState
// (FUNC_Event, FUNC_Protected, FUNC_BlueprintEvent)
// Parameters:
// struct FName                   NewState                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AGameMode::K2_OnSetMatchState(const struct FName& NewState)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameMode.K2_OnSetMatchState");

	struct
	{
		struct FName                   NewState;
	} params;

	params.NewState = NewState;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameMode.IsMatchInProgress
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AGameMode::IsMatchInProgress()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameMode.IsMatchInProgress");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameMode.HasMatchEnded
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AGameMode::HasMatchEnded()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameMode.HasMatchEnded");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameMode.GetMatchState
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FName                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

struct FName AGameMode::GetMatchState()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameMode.GetMatchState");

	struct
	{
		struct FName                   ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameMode.EndMatch
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AGameMode::EndMatch()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameMode.EndMatch");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameMode.AbortMatch
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AGameMode::AbortMatch()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameMode.AbortMatch");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameStateBase.OnRep_SpectatorClass
// (FUNC_Native, FUNC_Protected)

void AGameStateBase::OnRep_SpectatorClass()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameStateBase.OnRep_SpectatorClass");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameStateBase.OnRep_ReplicatedWorldTimeSeconds
// (FUNC_Native, FUNC_Protected)

void AGameStateBase::OnRep_ReplicatedWorldTimeSeconds()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameStateBase.OnRep_ReplicatedWorldTimeSeconds");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameStateBase.OnRep_ReplicatedHasBegunPlay
// (FUNC_Native, FUNC_Protected)

void AGameStateBase::OnRep_ReplicatedHasBegunPlay()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameStateBase.OnRep_ReplicatedHasBegunPlay");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameStateBase.OnRep_GameModeClass
// (FUNC_Native, FUNC_Protected)

void AGameStateBase::OnRep_GameModeClass()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameStateBase.OnRep_GameModeClass");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameStateBase.HasMatchStarted
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AGameStateBase::HasMatchStarted()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameStateBase.HasMatchStarted");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameStateBase.HasBegunPlay
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AGameStateBase::HasBegunPlay()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameStateBase.HasBegunPlay");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameStateBase.GetServerWorldTimeSeconds
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float AGameStateBase::GetServerWorldTimeSeconds()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameStateBase.GetServerWorldTimeSeconds");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameStateBase.GetPlayerStartTime
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AController*             Controller                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float AGameStateBase::GetPlayerStartTime(class AController* Controller)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameStateBase.GetPlayerStartTime");

	struct
	{
		class AController*             Controller;
		float                          ReturnValue;
	} params;

	params.Controller = Controller;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameStateBase.GetPlayerRespawnDelay
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AController*             Controller                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float AGameStateBase::GetPlayerRespawnDelay(class AController* Controller)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameStateBase.GetPlayerRespawnDelay");

	struct
	{
		class AController*             Controller;
		float                          ReturnValue;
	} params;

	params.Controller = Controller;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameState.OnRep_MatchState
// (FUNC_Native, FUNC_Public)

void AGameState::OnRep_MatchState()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameState.OnRep_MatchState");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameState.OnRep_ElapsedTime
// (FUNC_Native, FUNC_Public)

void AGameState::OnRep_ElapsedTime()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameState.OnRep_ElapsedTime");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DefaultPawn.TurnAtRate
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Rate                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ADefaultPawn::TurnAtRate(float Rate)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DefaultPawn.TurnAtRate");

	struct
	{
		float                          Rate;
	} params;

	params.Rate = Rate;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DefaultPawn.MoveUp_World
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Val                            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ADefaultPawn::MoveUp_World(float Val)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DefaultPawn.MoveUp_World");

	struct
	{
		float                          Val;
	} params;

	params.Val = Val;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DefaultPawn.MoveRight
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Val                            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ADefaultPawn::MoveRight(float Val)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DefaultPawn.MoveRight");

	struct
	{
		float                          Val;
	} params;

	params.Val = Val;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DefaultPawn.MoveForward
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Val                            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ADefaultPawn::MoveForward(float Val)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DefaultPawn.MoveForward");

	struct
	{
		float                          Val;
	} params;

	params.Val = Val;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DefaultPawn.LookUpAtRate
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Rate                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ADefaultPawn::LookUpAtRate(float Rate)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DefaultPawn.LookUpAtRate");

	struct
	{
		float                          Rate;
	} params;

	params.Rate = Rate;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.WorldSettings.OnRep_WorldGravityZ
// (FUNC_Native, FUNC_Public)

void AWorldSettings::OnRep_WorldGravityZ()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.WorldSettings.OnRep_WorldGravityZ");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CameraActor.GetAutoActivatePlayerIndex
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// int                            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

int ACameraActor::GetAutoActivatePlayerIndex()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraActor.GetAutoActivatePlayerIndex");

	struct
	{
		int                            ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.StaticMeshComponent.SetStaticMesh
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UStaticMesh*             NewMesh                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UStaticMeshComponent::SetStaticMesh(class UStaticMesh* NewMesh)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.StaticMeshComponent.SetStaticMesh");

	struct
	{
		class UStaticMesh*             NewMesh;
		bool                           ReturnValue;
	} params;

	params.NewMesh = NewMesh;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.StaticMeshComponent.SetForcedLodModel
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            NewForcedLodModel              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UStaticMeshComponent::SetForcedLodModel(int NewForcedLodModel)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.StaticMeshComponent.SetForcedLodModel");

	struct
	{
		int                            NewForcedLodModel;
	} params;

	params.NewForcedLodModel = NewForcedLodModel;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.StaticMeshComponent.SetDistanceFieldSelfShadowBias
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewValue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UStaticMeshComponent::SetDistanceFieldSelfShadowBias(float NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.StaticMeshComponent.SetDistanceFieldSelfShadowBias");

	struct
	{
		float                          NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.StaticMeshComponent.OnRep_StaticMesh
// (FUNC_Final, FUNC_Native, FUNC_Public)
// Parameters:
// class UStaticMesh*             OldStaticMesh                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UStaticMeshComponent::OnRep_StaticMesh(class UStaticMesh* OldStaticMesh)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.StaticMeshComponent.OnRep_StaticMesh");

	struct
	{
		class UStaticMesh*             OldStaticMesh;
	} params;

	params.OldStaticMesh = OldStaticMesh;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.StaticMeshComponent.GetLocalBounds
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 Min                            (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FVector                 Max                            (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)

void UStaticMeshComponent::GetLocalBounds(struct FVector* Min, struct FVector* Max)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.StaticMeshComponent.GetLocalBounds");

	struct
	{
		struct FVector                 Min;
		struct FVector                 Max;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (Min != nullptr)
		*Min = params.Min;
	if (Max != nullptr)
		*Max = params.Max;
}


// Function Engine.InstancedStaticMeshComponent.UpdateInstanceTransform
// (FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// int                            InstanceIndex                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FTransform              NewInstanceTransform           (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// bool                           bWorldSpace                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bMarkRenderStateDirty          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bTeleport                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UInstancedStaticMeshComponent::UpdateInstanceTransform(int InstanceIndex, const struct FTransform& NewInstanceTransform, bool bWorldSpace, bool bMarkRenderStateDirty, bool bTeleport)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.InstancedStaticMeshComponent.UpdateInstanceTransform");

	struct
	{
		int                            InstanceIndex;
		struct FTransform              NewInstanceTransform;
		bool                           bWorldSpace;
		bool                           bMarkRenderStateDirty;
		bool                           bTeleport;
		bool                           ReturnValue;
	} params;

	params.InstanceIndex = InstanceIndex;
	params.NewInstanceTransform = NewInstanceTransform;
	params.bWorldSpace = bWorldSpace;
	params.bMarkRenderStateDirty = bMarkRenderStateDirty;
	params.bTeleport = bTeleport;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.InstancedStaticMeshComponent.SetCullDistances
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            StartCullDistance              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            EndCullDistance                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UInstancedStaticMeshComponent::SetCullDistances(int StartCullDistance, int EndCullDistance)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.InstancedStaticMeshComponent.SetCullDistances");

	struct
	{
		int                            StartCullDistance;
		int                            EndCullDistance;
	} params;

	params.StartCullDistance = StartCullDistance;
	params.EndCullDistance = EndCullDistance;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.InstancedStaticMeshComponent.RemoveInstance
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            InstanceIndex                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UInstancedStaticMeshComponent::RemoveInstance(int InstanceIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.InstancedStaticMeshComponent.RemoveInstance");

	struct
	{
		int                            InstanceIndex;
		bool                           ReturnValue;
	} params;

	params.InstanceIndex = InstanceIndex;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.InstancedStaticMeshComponent.GetInstanceTransform
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// int                            InstanceIndex                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FTransform              OutInstanceTransform           (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bWorldSpace                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UInstancedStaticMeshComponent::GetInstanceTransform(int InstanceIndex, bool bWorldSpace, struct FTransform* OutInstanceTransform)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.InstancedStaticMeshComponent.GetInstanceTransform");

	struct
	{
		int                            InstanceIndex;
		struct FTransform              OutInstanceTransform;
		bool                           bWorldSpace;
		bool                           ReturnValue;
	} params;

	params.InstanceIndex = InstanceIndex;
	params.bWorldSpace = bWorldSpace;

	UObject::ProcessEvent(fn, &params);

	if (OutInstanceTransform != nullptr)
		*OutInstanceTransform = params.OutInstanceTransform;

	return params.ReturnValue;
}


// Function Engine.InstancedStaticMeshComponent.GetInstancesOverlappingSphere
// (FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 Center                         (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// float                          Radius                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bSphereInWorldSpace            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TArray<int>                    ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm)

TArray<int> UInstancedStaticMeshComponent::GetInstancesOverlappingSphere(const struct FVector& Center, float Radius, bool bSphereInWorldSpace)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.InstancedStaticMeshComponent.GetInstancesOverlappingSphere");

	struct
	{
		struct FVector                 Center;
		float                          Radius;
		bool                           bSphereInWorldSpace;
		TArray<int>                    ReturnValue;
	} params;

	params.Center = Center;
	params.Radius = Radius;
	params.bSphereInWorldSpace = bSphereInWorldSpace;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.InstancedStaticMeshComponent.GetInstancesOverlappingBox
// (FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FBox                    Box                            (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// bool                           bBoxInWorldSpace               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TArray<int>                    ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm)

TArray<int> UInstancedStaticMeshComponent::GetInstancesOverlappingBox(const struct FBox& Box, bool bBoxInWorldSpace)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.InstancedStaticMeshComponent.GetInstancesOverlappingBox");

	struct
	{
		struct FBox                    Box;
		bool                           bBoxInWorldSpace;
		TArray<int>                    ReturnValue;
	} params;

	params.Box = Box;
	params.bBoxInWorldSpace = bBoxInWorldSpace;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.InstancedStaticMeshComponent.GetInstanceCount
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// int                            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

int UInstancedStaticMeshComponent::GetInstanceCount()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.InstancedStaticMeshComponent.GetInstanceCount");

	struct
	{
		int                            ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.InstancedStaticMeshComponent.ClearInstances
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UInstancedStaticMeshComponent::ClearInstances()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.InstancedStaticMeshComponent.ClearInstances");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.InstancedStaticMeshComponent.AddInstanceWorldSpace
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FTransform              WorldTransform                 (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// int                            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

int UInstancedStaticMeshComponent::AddInstanceWorldSpace(const struct FTransform& WorldTransform)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.InstancedStaticMeshComponent.AddInstanceWorldSpace");

	struct
	{
		struct FTransform              WorldTransform;
		int                            ReturnValue;
	} params;

	params.WorldTransform = WorldTransform;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.InstancedStaticMeshComponent.AddInstance
// (FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FTransform              InstanceTransform              (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// int                            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

int UInstancedStaticMeshComponent::AddInstance(const struct FTransform& InstanceTransform)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.InstancedStaticMeshComponent.AddInstance");

	struct
	{
		struct FTransform              InstanceTransform;
		int                            ReturnValue;
	} params;

	params.InstanceTransform = InstanceTransform;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.HierarchicalInstancedStaticMeshComponent.RemoveInstances
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// TArray<int>                    InstancesToRemove              (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UHierarchicalInstancedStaticMeshComponent::RemoveInstances(TArray<int> InstancesToRemove)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HierarchicalInstancedStaticMeshComponent.RemoveInstances");

	struct
	{
		TArray<int>                    InstancesToRemove;
		bool                           ReturnValue;
	} params;

	params.InstancesToRemove = InstancesToRemove;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.HUD.ShowHUD
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void AHUD::ShowHUD()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.ShowHUD");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.ShowDebugToggleSubCategory
// (FUNC_Final, FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// struct FName                   Category                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AHUD::ShowDebugToggleSubCategory(const struct FName& Category)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.ShowDebugToggleSubCategory");

	struct
	{
		struct FName                   Category;
	} params;

	params.Category = Category;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.ShowDebugForReticleTargetToggle
// (FUNC_Final, FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// class UClass*                  DesiredClass                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AHUD::ShowDebugForReticleTargetToggle(class UClass* DesiredClass)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.ShowDebugForReticleTargetToggle");

	struct
	{
		class UClass*                  DesiredClass;
	} params;

	params.DesiredClass = DesiredClass;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.ShowDebug
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// struct FName                   DebugType                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AHUD::ShowDebug(const struct FName& DebugType)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.ShowDebug");

	struct
	{
		struct FName                   DebugType;
	} params;

	params.DebugType = DebugType;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.RemoveDebugText
// (FUNC_Final, FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// class AActor*                  SrcActor                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bLeaveDurationText             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AHUD::RemoveDebugText(class AActor* SrcActor, bool bLeaveDurationText)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.RemoveDebugText");

	struct
	{
		class AActor*                  SrcActor;
		bool                           bLeaveDurationText;
	} params;

	params.SrcActor = SrcActor;
	params.bLeaveDurationText = bLeaveDurationText;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.RemoveAllDebugStrings
// (FUNC_Final, FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)

void AHUD::RemoveAllDebugStrings()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.RemoveAllDebugStrings");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.ReceiveHitBoxRelease
// (FUNC_BlueprintCosmetic, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// struct FName                   BoxName                        (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AHUD::ReceiveHitBoxRelease(const struct FName& BoxName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.ReceiveHitBoxRelease");

	struct
	{
		struct FName                   BoxName;
	} params;

	params.BoxName = BoxName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.ReceiveHitBoxEndCursorOver
// (FUNC_BlueprintCosmetic, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// struct FName                   BoxName                        (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AHUD::ReceiveHitBoxEndCursorOver(const struct FName& BoxName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.ReceiveHitBoxEndCursorOver");

	struct
	{
		struct FName                   BoxName;
	} params;

	params.BoxName = BoxName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.ReceiveHitBoxClick
// (FUNC_BlueprintCosmetic, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// struct FName                   BoxName                        (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AHUD::ReceiveHitBoxClick(const struct FName& BoxName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.ReceiveHitBoxClick");

	struct
	{
		struct FName                   BoxName;
	} params;

	params.BoxName = BoxName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.ReceiveHitBoxBeginCursorOver
// (FUNC_BlueprintCosmetic, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// struct FName                   BoxName                        (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AHUD::ReceiveHitBoxBeginCursorOver(const struct FName& BoxName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.ReceiveHitBoxBeginCursorOver");

	struct
	{
		struct FName                   BoxName;
	} params;

	params.BoxName = BoxName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.ReceiveDrawHUD
// (FUNC_BlueprintCosmetic, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// int                            SizeX                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            SizeY                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AHUD::ReceiveDrawHUD(int SizeX, int SizeY)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.ReceiveDrawHUD");

	struct
	{
		int                            SizeX;
		int                            SizeY;
	} params;

	params.SizeX = SizeX;
	params.SizeY = SizeY;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.Project
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 Location                       (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector AHUD::Project(const struct FVector& Location)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.Project");

	struct
	{
		struct FVector                 Location;
		struct FVector                 ReturnValue;
	} params;

	params.Location = Location;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.HUD.PreviousDebugTarget
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void AHUD::PreviousDebugTarget()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.PreviousDebugTarget");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.NextDebugTarget
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void AHUD::NextDebugTarget()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.NextDebugTarget");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.GetTextSize
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FString                 Text                           (CPF_Parm, CPF_ZeroConstructor)
// float                          OutWidth                       (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          OutHeight                      (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UFont*                   Font                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Scale                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AHUD::GetTextSize(const struct FString& Text, class UFont* Font, float Scale, float* OutWidth, float* OutHeight)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.GetTextSize");

	struct
	{
		struct FString                 Text;
		float                          OutWidth;
		float                          OutHeight;
		class UFont*                   Font;
		float                          Scale;
	} params;

	params.Text = Text;
	params.Font = Font;
	params.Scale = Scale;

	UObject::ProcessEvent(fn, &params);

	if (OutWidth != nullptr)
		*OutWidth = params.OutWidth;
	if (OutHeight != nullptr)
		*OutHeight = params.OutHeight;
}


// Function Engine.HUD.GetOwningPlayerController
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class APlayerController*       ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class APlayerController* AHUD::GetOwningPlayerController()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.GetOwningPlayerController");

	struct
	{
		class APlayerController*       ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.HUD.GetOwningPawn
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class APawn*                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class APawn* AHUD::GetOwningPawn()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.GetOwningPawn");

	struct
	{
		class APawn*                   ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.HUD.GetActorsInSelectionRectangle
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// class UClass*                  ClassFilter                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector2D               FirstPoint                     (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// struct FVector2D               SecondPoint                    (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// TArray<class AActor*>          OutActors                      (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor)
// bool                           bIncludeNonCollidingComponents (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bActorMustBeFullyEnclosed      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AHUD::GetActorsInSelectionRectangle(class UClass* ClassFilter, const struct FVector2D& FirstPoint, const struct FVector2D& SecondPoint, bool bIncludeNonCollidingComponents, bool bActorMustBeFullyEnclosed, TArray<class AActor*>* OutActors)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.GetActorsInSelectionRectangle");

	struct
	{
		class UClass*                  ClassFilter;
		struct FVector2D               FirstPoint;
		struct FVector2D               SecondPoint;
		TArray<class AActor*>          OutActors;
		bool                           bIncludeNonCollidingComponents;
		bool                           bActorMustBeFullyEnclosed;
	} params;

	params.ClassFilter = ClassFilter;
	params.FirstPoint = FirstPoint;
	params.SecondPoint = SecondPoint;
	params.bIncludeNonCollidingComponents = bIncludeNonCollidingComponents;
	params.bActorMustBeFullyEnclosed = bActorMustBeFullyEnclosed;

	UObject::ProcessEvent(fn, &params);

	if (OutActors != nullptr)
		*OutActors = params.OutActors;
}


// Function Engine.HUD.DrawTextureSimple
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UTexture*                Texture                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenX                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenY                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Scale                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bScalePosition                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AHUD::DrawTextureSimple(class UTexture* Texture, float ScreenX, float ScreenY, float Scale, bool bScalePosition)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.DrawTextureSimple");

	struct
	{
		class UTexture*                Texture;
		float                          ScreenX;
		float                          ScreenY;
		float                          Scale;
		bool                           bScalePosition;
	} params;

	params.Texture = Texture;
	params.ScreenX = ScreenX;
	params.ScreenY = ScreenY;
	params.Scale = Scale;
	params.bScalePosition = bScalePosition;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.DrawTexture
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UTexture*                Texture                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenX                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenY                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenW                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenH                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          TextureU                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          TextureV                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          TextureUWidth                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          TextureVHeight                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FLinearColor            TintColor                      (CPF_Parm, CPF_IsPlainOldData)
// TEnumAsByte<EBlendMode>        BlendMode                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Scale                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bScalePosition                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Rotation                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector2D               RotPivot                       (CPF_Parm, CPF_IsPlainOldData)

void AHUD::DrawTexture(class UTexture* Texture, float ScreenX, float ScreenY, float ScreenW, float ScreenH, float TextureU, float TextureV, float TextureUWidth, float TextureVHeight, const struct FLinearColor& TintColor, TEnumAsByte<EBlendMode> BlendMode, float Scale, bool bScalePosition, float Rotation, const struct FVector2D& RotPivot)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.DrawTexture");

	struct
	{
		class UTexture*                Texture;
		float                          ScreenX;
		float                          ScreenY;
		float                          ScreenW;
		float                          ScreenH;
		float                          TextureU;
		float                          TextureV;
		float                          TextureUWidth;
		float                          TextureVHeight;
		struct FLinearColor            TintColor;
		TEnumAsByte<EBlendMode>        BlendMode;
		float                          Scale;
		bool                           bScalePosition;
		float                          Rotation;
		struct FVector2D               RotPivot;
	} params;

	params.Texture = Texture;
	params.ScreenX = ScreenX;
	params.ScreenY = ScreenY;
	params.ScreenW = ScreenW;
	params.ScreenH = ScreenH;
	params.TextureU = TextureU;
	params.TextureV = TextureV;
	params.TextureUWidth = TextureUWidth;
	params.TextureVHeight = TextureVHeight;
	params.TintColor = TintColor;
	params.BlendMode = BlendMode;
	params.Scale = Scale;
	params.bScalePosition = bScalePosition;
	params.Rotation = Rotation;
	params.RotPivot = RotPivot;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.DrawText
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FString                 Text                           (CPF_Parm, CPF_ZeroConstructor)
// struct FLinearColor            TextColor                      (CPF_Parm, CPF_IsPlainOldData)
// float                          ScreenX                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenY                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UFont*                   Font                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Scale                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bScalePosition                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AHUD::DrawText(const struct FString& Text, const struct FLinearColor& TextColor, float ScreenX, float ScreenY, class UFont* Font, float Scale, bool bScalePosition)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.DrawText");

	struct
	{
		struct FString                 Text;
		struct FLinearColor            TextColor;
		float                          ScreenX;
		float                          ScreenY;
		class UFont*                   Font;
		float                          Scale;
		bool                           bScalePosition;
	} params;

	params.Text = Text;
	params.TextColor = TextColor;
	params.ScreenX = ScreenX;
	params.ScreenY = ScreenY;
	params.Font = Font;
	params.Scale = Scale;
	params.bScalePosition = bScalePosition;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.DrawRect
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FLinearColor            RectColor                      (CPF_Parm, CPF_IsPlainOldData)
// float                          ScreenX                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenY                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenW                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenH                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AHUD::DrawRect(const struct FLinearColor& RectColor, float ScreenX, float ScreenY, float ScreenW, float ScreenH)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.DrawRect");

	struct
	{
		struct FLinearColor            RectColor;
		float                          ScreenX;
		float                          ScreenY;
		float                          ScreenW;
		float                          ScreenH;
	} params;

	params.RectColor = RectColor;
	params.ScreenX = ScreenX;
	params.ScreenY = ScreenY;
	params.ScreenW = ScreenW;
	params.ScreenH = ScreenH;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.DrawMaterialTriangle
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UMaterialInterface*      Material                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector2D               V0_Pos                         (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               V1_Pos                         (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               V2_Pos                         (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               V0_UV                          (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               V1_UV                          (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               V2_UV                          (CPF_Parm, CPF_IsPlainOldData)
// struct FLinearColor            V0_Color                       (CPF_Parm, CPF_IsPlainOldData)
// struct FLinearColor            V1_Color                       (CPF_Parm, CPF_IsPlainOldData)
// struct FLinearColor            V2_Color                       (CPF_Parm, CPF_IsPlainOldData)

void AHUD::DrawMaterialTriangle(class UMaterialInterface* Material, const struct FVector2D& V0_Pos, const struct FVector2D& V1_Pos, const struct FVector2D& V2_Pos, const struct FVector2D& V0_UV, const struct FVector2D& V1_UV, const struct FVector2D& V2_UV, const struct FLinearColor& V0_Color, const struct FLinearColor& V1_Color, const struct FLinearColor& V2_Color)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.DrawMaterialTriangle");

	struct
	{
		class UMaterialInterface*      Material;
		struct FVector2D               V0_Pos;
		struct FVector2D               V1_Pos;
		struct FVector2D               V2_Pos;
		struct FVector2D               V0_UV;
		struct FVector2D               V1_UV;
		struct FVector2D               V2_UV;
		struct FLinearColor            V0_Color;
		struct FLinearColor            V1_Color;
		struct FLinearColor            V2_Color;
	} params;

	params.Material = Material;
	params.V0_Pos = V0_Pos;
	params.V1_Pos = V1_Pos;
	params.V2_Pos = V2_Pos;
	params.V0_UV = V0_UV;
	params.V1_UV = V1_UV;
	params.V2_UV = V2_UV;
	params.V0_Color = V0_Color;
	params.V1_Color = V1_Color;
	params.V2_Color = V2_Color;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.DrawMaterialSimple
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UMaterialInterface*      Material                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenX                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenY                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenW                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenH                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Scale                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bScalePosition                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AHUD::DrawMaterialSimple(class UMaterialInterface* Material, float ScreenX, float ScreenY, float ScreenW, float ScreenH, float Scale, bool bScalePosition)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.DrawMaterialSimple");

	struct
	{
		class UMaterialInterface*      Material;
		float                          ScreenX;
		float                          ScreenY;
		float                          ScreenW;
		float                          ScreenH;
		float                          Scale;
		bool                           bScalePosition;
	} params;

	params.Material = Material;
	params.ScreenX = ScreenX;
	params.ScreenY = ScreenY;
	params.ScreenW = ScreenW;
	params.ScreenH = ScreenH;
	params.Scale = Scale;
	params.bScalePosition = bScalePosition;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.DrawMaterial
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UMaterialInterface*      Material                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenX                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenY                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenW                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenH                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          MaterialU                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          MaterialV                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          MaterialUWidth                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          MaterialVHeight                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Scale                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bScalePosition                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Rotation                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector2D               RotPivot                       (CPF_Parm, CPF_IsPlainOldData)

void AHUD::DrawMaterial(class UMaterialInterface* Material, float ScreenX, float ScreenY, float ScreenW, float ScreenH, float MaterialU, float MaterialV, float MaterialUWidth, float MaterialVHeight, float Scale, bool bScalePosition, float Rotation, const struct FVector2D& RotPivot)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.DrawMaterial");

	struct
	{
		class UMaterialInterface*      Material;
		float                          ScreenX;
		float                          ScreenY;
		float                          ScreenW;
		float                          ScreenH;
		float                          MaterialU;
		float                          MaterialV;
		float                          MaterialUWidth;
		float                          MaterialVHeight;
		float                          Scale;
		bool                           bScalePosition;
		float                          Rotation;
		struct FVector2D               RotPivot;
	} params;

	params.Material = Material;
	params.ScreenX = ScreenX;
	params.ScreenY = ScreenY;
	params.ScreenW = ScreenW;
	params.ScreenH = ScreenH;
	params.MaterialU = MaterialU;
	params.MaterialV = MaterialV;
	params.MaterialUWidth = MaterialUWidth;
	params.MaterialVHeight = MaterialVHeight;
	params.Scale = Scale;
	params.bScalePosition = bScalePosition;
	params.Rotation = Rotation;
	params.RotPivot = RotPivot;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.DrawLine
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// float                          StartScreenX                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          StartScreenY                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          EndScreenX                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          EndScreenY                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FLinearColor            LineColor                      (CPF_Parm, CPF_IsPlainOldData)
// float                          LineThickness                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AHUD::DrawLine(float StartScreenX, float StartScreenY, float EndScreenX, float EndScreenY, const struct FLinearColor& LineColor, float LineThickness)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.DrawLine");

	struct
	{
		float                          StartScreenX;
		float                          StartScreenY;
		float                          EndScreenX;
		float                          EndScreenY;
		struct FLinearColor            LineColor;
		float                          LineThickness;
	} params;

	params.StartScreenX = StartScreenX;
	params.StartScreenY = StartScreenY;
	params.EndScreenX = EndScreenX;
	params.EndScreenY = EndScreenY;
	params.LineColor = LineColor;
	params.LineThickness = LineThickness;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.Deproject
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ScreenX                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenY                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 WorldPosition                  (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FVector                 WorldDirection                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)

void AHUD::Deproject(float ScreenX, float ScreenY, struct FVector* WorldPosition, struct FVector* WorldDirection)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.Deproject");

	struct
	{
		float                          ScreenX;
		float                          ScreenY;
		struct FVector                 WorldPosition;
		struct FVector                 WorldDirection;
	} params;

	params.ScreenX = ScreenX;
	params.ScreenY = ScreenY;

	UObject::ProcessEvent(fn, &params);

	if (WorldPosition != nullptr)
		*WorldPosition = params.WorldPosition;
	if (WorldDirection != nullptr)
		*WorldDirection = params.WorldDirection;
}


// Function Engine.HUD.AddHitBox
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector2D               Position                       (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               Size                           (CPF_Parm, CPF_IsPlainOldData)
// struct FName                   InName                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bConsumesInput                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            Priority                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AHUD::AddHitBox(const struct FVector2D& Position, const struct FVector2D& Size, const struct FName& InName, bool bConsumesInput, int Priority)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.AddHitBox");

	struct
	{
		struct FVector2D               Position;
		struct FVector2D               Size;
		struct FName                   InName;
		bool                           bConsumesInput;
		int                            Priority;
	} params;

	params.Position = Position;
	params.Size = Size;
	params.InName = InName;
	params.bConsumesInput = bConsumesInput;
	params.Priority = Priority;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.HUD.AddDebugText
// (FUNC_Final, FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_HasDefaults, FUNC_NetClient)
// Parameters:
// struct FString                 DebugText                      (CPF_Parm, CPF_ZeroConstructor)
// class AActor*                  SrcActor                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Duration                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 Offset                         (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 DesiredOffset                  (CPF_Parm, CPF_IsPlainOldData)
// struct FColor                  TextColor                      (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSkipOverwriteCheck            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAbsoluteLocation              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bKeepAttachedToActor           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UFont*                   InFont                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          FontScale                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bDrawShadow                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AHUD::AddDebugText(const struct FString& DebugText, class AActor* SrcActor, float Duration, const struct FVector& Offset, const struct FVector& DesiredOffset, const struct FColor& TextColor, bool bSkipOverwriteCheck, bool bAbsoluteLocation, bool bKeepAttachedToActor, class UFont* InFont, float FontScale, bool bDrawShadow)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.HUD.AddDebugText");

	struct
	{
		struct FString                 DebugText;
		class AActor*                  SrcActor;
		float                          Duration;
		struct FVector                 Offset;
		struct FVector                 DesiredOffset;
		struct FColor                  TextColor;
		bool                           bSkipOverwriteCheck;
		bool                           bAbsoluteLocation;
		bool                           bKeepAttachedToActor;
		class UFont*                   InFont;
		float                          FontScale;
		bool                           bDrawShadow;
	} params;

	params.DebugText = DebugText;
	params.SrcActor = SrcActor;
	params.Duration = Duration;
	params.Offset = Offset;
	params.DesiredOffset = DesiredOffset;
	params.TextColor = TextColor;
	params.bSkipOverwriteCheck = bSkipOverwriteCheck;
	params.bAbsoluteLocation = bAbsoluteLocation;
	params.bKeepAttachedToActor = bKeepAttachedToActor;
	params.InFont = InFont;
	params.FontScale = FontScale;
	params.bDrawShadow = bDrawShadow;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CapsuleComponent.SetCapsuleSize
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InRadius                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InHalfHeight                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bUpdateOverlaps                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCapsuleComponent::SetCapsuleSize(float InRadius, float InHalfHeight, bool bUpdateOverlaps)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CapsuleComponent.SetCapsuleSize");

	struct
	{
		float                          InRadius;
		float                          InHalfHeight;
		bool                           bUpdateOverlaps;
	} params;

	params.InRadius = InRadius;
	params.InHalfHeight = InHalfHeight;
	params.bUpdateOverlaps = bUpdateOverlaps;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CapsuleComponent.SetCapsuleRadius
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Radius                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bUpdateOverlaps                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCapsuleComponent::SetCapsuleRadius(float Radius, bool bUpdateOverlaps)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CapsuleComponent.SetCapsuleRadius");

	struct
	{
		float                          Radius;
		bool                           bUpdateOverlaps;
	} params;

	params.Radius = Radius;
	params.bUpdateOverlaps = bUpdateOverlaps;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CapsuleComponent.SetCapsuleHalfHeight
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          HalfHeight                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bUpdateOverlaps                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCapsuleComponent::SetCapsuleHalfHeight(float HalfHeight, bool bUpdateOverlaps)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CapsuleComponent.SetCapsuleHalfHeight");

	struct
	{
		float                          HalfHeight;
		bool                           bUpdateOverlaps;
	} params;

	params.HalfHeight = HalfHeight;
	params.bUpdateOverlaps = bUpdateOverlaps;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CapsuleComponent.GetUnscaledCapsuleSize_WithoutHemisphere
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          OutRadius                      (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          OutHalfHeightWithoutHemisphere (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCapsuleComponent::GetUnscaledCapsuleSize_WithoutHemisphere(float* OutRadius, float* OutHalfHeightWithoutHemisphere)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CapsuleComponent.GetUnscaledCapsuleSize_WithoutHemisphere");

	struct
	{
		float                          OutRadius;
		float                          OutHalfHeightWithoutHemisphere;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (OutRadius != nullptr)
		*OutRadius = params.OutRadius;
	if (OutHalfHeightWithoutHemisphere != nullptr)
		*OutHalfHeightWithoutHemisphere = params.OutHalfHeightWithoutHemisphere;
}


// Function Engine.CapsuleComponent.GetUnscaledCapsuleSize
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          OutRadius                      (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          OutHalfHeight                  (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCapsuleComponent::GetUnscaledCapsuleSize(float* OutRadius, float* OutHalfHeight)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CapsuleComponent.GetUnscaledCapsuleSize");

	struct
	{
		float                          OutRadius;
		float                          OutHalfHeight;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (OutRadius != nullptr)
		*OutRadius = params.OutRadius;
	if (OutHalfHeight != nullptr)
		*OutHalfHeight = params.OutHalfHeight;
}


// Function Engine.CapsuleComponent.GetUnscaledCapsuleRadius
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCapsuleComponent::GetUnscaledCapsuleRadius()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CapsuleComponent.GetUnscaledCapsuleRadius");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CapsuleComponent.GetUnscaledCapsuleHalfHeight_WithoutHemisphere
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCapsuleComponent::GetUnscaledCapsuleHalfHeight_WithoutHemisphere()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CapsuleComponent.GetUnscaledCapsuleHalfHeight_WithoutHemisphere");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CapsuleComponent.GetUnscaledCapsuleHalfHeight
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCapsuleComponent::GetUnscaledCapsuleHalfHeight()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CapsuleComponent.GetUnscaledCapsuleHalfHeight");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CapsuleComponent.GetShapeScale
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCapsuleComponent::GetShapeScale()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CapsuleComponent.GetShapeScale");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CapsuleComponent.GetScaledCapsuleSize_WithoutHemisphere
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          OutRadius                      (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          OutHalfHeightWithoutHemisphere (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCapsuleComponent::GetScaledCapsuleSize_WithoutHemisphere(float* OutRadius, float* OutHalfHeightWithoutHemisphere)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CapsuleComponent.GetScaledCapsuleSize_WithoutHemisphere");

	struct
	{
		float                          OutRadius;
		float                          OutHalfHeightWithoutHemisphere;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (OutRadius != nullptr)
		*OutRadius = params.OutRadius;
	if (OutHalfHeightWithoutHemisphere != nullptr)
		*OutHalfHeightWithoutHemisphere = params.OutHalfHeightWithoutHemisphere;
}


// Function Engine.CapsuleComponent.GetScaledCapsuleSize
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          OutRadius                      (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          OutHalfHeight                  (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCapsuleComponent::GetScaledCapsuleSize(float* OutRadius, float* OutHalfHeight)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CapsuleComponent.GetScaledCapsuleSize");

	struct
	{
		float                          OutRadius;
		float                          OutHalfHeight;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (OutRadius != nullptr)
		*OutRadius = params.OutRadius;
	if (OutHalfHeight != nullptr)
		*OutHalfHeight = params.OutHalfHeight;
}


// Function Engine.CapsuleComponent.GetScaledCapsuleRadius
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCapsuleComponent::GetScaledCapsuleRadius()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CapsuleComponent.GetScaledCapsuleRadius");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CapsuleComponent.GetScaledCapsuleHalfHeight_WithoutHemisphere
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCapsuleComponent::GetScaledCapsuleHalfHeight_WithoutHemisphere()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CapsuleComponent.GetScaledCapsuleHalfHeight_WithoutHemisphere");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CapsuleComponent.GetScaledCapsuleHalfHeight
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCapsuleComponent::GetScaledCapsuleHalfHeight()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CapsuleComponent.GetScaledCapsuleHalfHeight");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PlayerController.WasInputKeyJustReleased
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FKey                    Key                            (CPF_Parm)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool APlayerController::WasInputKeyJustReleased(const struct FKey& Key)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.WasInputKeyJustReleased");

	struct
	{
		struct FKey                    Key;
		bool                           ReturnValue;
	} params;

	params.Key = Key;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PlayerController.WasInputKeyJustPressed
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FKey                    Key                            (CPF_Parm)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool APlayerController::WasInputKeyJustPressed(const struct FKey& Key)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.WasInputKeyJustPressed");

	struct
	{
		struct FKey                    Key;
		bool                           ReturnValue;
	} params;

	params.Key = Key;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PlayerController.ToggleSpeaking
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// bool                           bInSpeaking                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ToggleSpeaking(bool bInSpeaking)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ToggleSpeaking");

	struct
	{
		bool                           bInSpeaking;
	} params;

	params.bInSpeaking = bInSpeaking;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.SwitchLevel
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// struct FString                 URL                            (CPF_Parm, CPF_ZeroConstructor)

void APlayerController::SwitchLevel(const struct FString& URL)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.SwitchLevel");

	struct
	{
		struct FString                 URL;
	} params;

	params.URL = URL;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.StopHapticEffect
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// EControllerHand                Hand                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::StopHapticEffect(EControllerHand Hand)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.StopHapticEffect");

	struct
	{
		EControllerHand                Hand;
	} params;

	params.Hand = Hand;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.StartFire
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// unsigned char                  FireModeNum                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::StartFire(unsigned char FireModeNum)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.StartFire");

	struct
	{
		unsigned char                  FireModeNum;
	} params;

	params.FireModeNum = FireModeNum;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.SetVirtualJoystickVisibility
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bVisible                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::SetVirtualJoystickVisibility(bool bVisible)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.SetVirtualJoystickVisibility");

	struct
	{
		bool                           bVisible;
	} params;

	params.bVisible = bVisible;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.SetViewTargetWithBlend
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class AActor*                  NewViewTarget                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          BlendTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TEnumAsByte<EViewTargetBlendFunction> BlendFunc                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          BlendExp                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bLockOutgoing                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::SetViewTargetWithBlend(class AActor* NewViewTarget, float BlendTime, TEnumAsByte<EViewTargetBlendFunction> BlendFunc, float BlendExp, bool bLockOutgoing)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.SetViewTargetWithBlend");

	struct
	{
		class AActor*                  NewViewTarget;
		float                          BlendTime;
		TEnumAsByte<EViewTargetBlendFunction> BlendFunc;
		float                          BlendExp;
		bool                           bLockOutgoing;
	} params;

	params.NewViewTarget = NewViewTarget;
	params.BlendTime = BlendTime;
	params.BlendFunc = BlendFunc;
	params.BlendExp = BlendExp;
	params.bLockOutgoing = bLockOutgoing;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.SetName
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// struct FString                 S                              (CPF_Parm, CPF_ZeroConstructor)

void APlayerController::SetName(const struct FString& S)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.SetName");

	struct
	{
		struct FString                 S;
	} params;

	params.S = S;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.SetMouseLocation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            X                              (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            Y                              (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::SetMouseLocation(int X, int Y)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.SetMouseLocation");

	struct
	{
		int                            X;
		int                            Y;
	} params;

	params.X = X;
	params.Y = Y;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.SetMouseCursorWidget
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// TEnumAsByte<EMouseCursor>      Cursor                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UUserWidget*             CursorWidget                   (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)

void APlayerController::SetMouseCursorWidget(TEnumAsByte<EMouseCursor> Cursor, class UUserWidget* CursorWidget)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.SetMouseCursorWidget");

	struct
	{
		TEnumAsByte<EMouseCursor>      Cursor;
		class UUserWidget*             CursorWidget;
	} params;

	params.Cursor = Cursor;
	params.CursorWidget = CursorWidget;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.SetHapticsByValue
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Frequency                      (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Amplitude                      (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// EControllerHand                Hand                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::SetHapticsByValue(float Frequency, float Amplitude, EControllerHand Hand)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.SetHapticsByValue");

	struct
	{
		float                          Frequency;
		float                          Amplitude;
		EControllerHand                Hand;
	} params;

	params.Frequency = Frequency;
	params.Amplitude = Amplitude;
	params.Hand = Hand;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.SetControllerLightColor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FColor                  Color                          (CPF_Parm, CPF_IsPlainOldData)

void APlayerController::SetControllerLightColor(const struct FColor& Color)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.SetControllerLightColor");

	struct
	{
		struct FColor                  Color;
	} params;

	params.Color = Color;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.SetCinematicMode
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bInCinematicMode               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bHidePlayer                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAffectsHUD                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAffectsMovement               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAffectsTurning                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::SetCinematicMode(bool bInCinematicMode, bool bHidePlayer, bool bAffectsHUD, bool bAffectsMovement, bool bAffectsTurning)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.SetCinematicMode");

	struct
	{
		bool                           bInCinematicMode;
		bool                           bHidePlayer;
		bool                           bAffectsHUD;
		bool                           bAffectsMovement;
		bool                           bAffectsTurning;
	} params;

	params.bInCinematicMode = bInCinematicMode;
	params.bHidePlayer = bHidePlayer;
	params.bAffectsHUD = bAffectsHUD;
	params.bAffectsMovement = bAffectsMovement;
	params.bAffectsTurning = bAffectsTurning;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.SetAudioListenerOverride
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class USceneComponent*         AttachToComponent              (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FVector                 Location                       (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                Rotation                       (CPF_Parm, CPF_IsPlainOldData)

void APlayerController::SetAudioListenerOverride(class USceneComponent* AttachToComponent, const struct FVector& Location, const struct FRotator& Rotation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.SetAudioListenerOverride");

	struct
	{
		class USceneComponent*         AttachToComponent;
		struct FVector                 Location;
		struct FRotator                Rotation;
	} params;

	params.AttachToComponent = AttachToComponent;
	params.Location = Location;
	params.Rotation = Rotation;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerViewSelf
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)
// Parameters:
// struct FViewTargetTransitionParams TransitionParams               (CPF_Parm)

void APlayerController::ServerViewSelf(const struct FViewTargetTransitionParams& TransitionParams)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerViewSelf");

	struct
	{
		struct FViewTargetTransitionParams TransitionParams;
	} params;

	params.TransitionParams = TransitionParams;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerViewPrevPlayer
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)

void APlayerController::ServerViewPrevPlayer()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerViewPrevPlayer");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerViewNextPlayer
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)

void APlayerController::ServerViewNextPlayer()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerViewNextPlayer");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerVerifyViewTarget
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)

void APlayerController::ServerVerifyViewTarget()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerVerifyViewTarget");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerUpdateMultipleLevelsVisibility
// (FUNC_Final, FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)
// Parameters:
// TArray<struct FUpdateLevelVisibilityLevelInfo> LevelVisibilities              (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_ReferenceParm)

void APlayerController::ServerUpdateMultipleLevelsVisibility(TArray<struct FUpdateLevelVisibilityLevelInfo> LevelVisibilities)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerUpdateMultipleLevelsVisibility");

	struct
	{
		TArray<struct FUpdateLevelVisibilityLevelInfo> LevelVisibilities;
	} params;

	params.LevelVisibilities = LevelVisibilities;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerUpdateLevelVisibility
// (FUNC_Final, FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)
// Parameters:
// struct FName                   PackageName                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bIsVisible                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ServerUpdateLevelVisibility(const struct FName& PackageName, bool bIsVisible)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerUpdateLevelVisibility");

	struct
	{
		struct FName                   PackageName;
		bool                           bIsVisible;
	} params;

	params.PackageName = PackageName;
	params.bIsVisible = bIsVisible;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerUpdateCamera
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)
// Parameters:
// struct FVector_NetQuantize     CamLoc                         (CPF_Parm)
// int                            CamPitchAndYaw                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ServerUpdateCamera(const struct FVector_NetQuantize& CamLoc, int CamPitchAndYaw)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerUpdateCamera");

	struct
	{
		struct FVector_NetQuantize     CamLoc;
		int                            CamPitchAndYaw;
	} params;

	params.CamLoc = CamLoc;
	params.CamPitchAndYaw = CamPitchAndYaw;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerUnmutePlayer
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)
// Parameters:
// struct FUniqueNetIdRepl        PlayerId                       (CPF_Parm)

void APlayerController::ServerUnmutePlayer(const struct FUniqueNetIdRepl& PlayerId)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerUnmutePlayer");

	struct
	{
		struct FUniqueNetIdRepl        PlayerId;
	} params;

	params.PlayerId = PlayerId;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerToggleAILogging
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)

void APlayerController::ServerToggleAILogging()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerToggleAILogging");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerShortTimeout
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)

void APlayerController::ServerShortTimeout()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerShortTimeout");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerSetSpectatorWaiting
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)
// Parameters:
// bool                           bWaiting                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ServerSetSpectatorWaiting(bool bWaiting)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerSetSpectatorWaiting");

	struct
	{
		bool                           bWaiting;
	} params;

	params.bWaiting = bWaiting;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerSetSpectatorLocation
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_HasDefaults, FUNC_NetValidate)
// Parameters:
// struct FVector                 NewLoc                         (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                NewRot                         (CPF_Parm, CPF_IsPlainOldData)

void APlayerController::ServerSetSpectatorLocation(const struct FVector& NewLoc, const struct FRotator& NewRot)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerSetSpectatorLocation");

	struct
	{
		struct FVector                 NewLoc;
		struct FRotator                NewRot;
	} params;

	params.NewLoc = NewLoc;
	params.NewRot = NewRot;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerRestartPlayer
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)

void APlayerController::ServerRestartPlayer()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerRestartPlayer");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerPause
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)

void APlayerController::ServerPause()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerPause");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerNotifyLoadedWorld
// (FUNC_Final, FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)
// Parameters:
// struct FName                   WorldPackageName               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ServerNotifyLoadedWorld(const struct FName& WorldPackageName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerNotifyLoadedWorld");

	struct
	{
		struct FName                   WorldPackageName;
	} params;

	params.WorldPackageName = WorldPackageName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerMutePlayer
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)
// Parameters:
// struct FUniqueNetIdRepl        PlayerId                       (CPF_Parm)

void APlayerController::ServerMutePlayer(const struct FUniqueNetIdRepl& PlayerId)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerMutePlayer");

	struct
	{
		struct FUniqueNetIdRepl        PlayerId;
	} params;

	params.PlayerId = PlayerId;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerCheckClientPossessionReliable
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)

void APlayerController::ServerCheckClientPossessionReliable()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerCheckClientPossessionReliable");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerCheckClientPossession
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)

void APlayerController::ServerCheckClientPossession()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerCheckClientPossession");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerChangeName
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)
// Parameters:
// struct FString                 S                              (CPF_Parm, CPF_ZeroConstructor)

void APlayerController::ServerChangeName(const struct FString& S)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerChangeName");

	struct
	{
		struct FString                 S;
	} params;

	params.S = S;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerCamera
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)
// Parameters:
// struct FName                   NewMode                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ServerCamera(const struct FName& NewMode)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerCamera");

	struct
	{
		struct FName                   NewMode;
	} params;

	params.NewMode = NewMode;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ServerAcknowledgePossession
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)
// Parameters:
// class APawn*                   P                              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ServerAcknowledgePossession(class APawn* P)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ServerAcknowledgePossession");

	struct
	{
		class APawn*                   P;
	} params;

	params.P = P;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.SendToConsole
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// struct FString                 Command                        (CPF_Parm, CPF_ZeroConstructor)

void APlayerController::SendToConsole(const struct FString& Command)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.SendToConsole");

	struct
	{
		struct FString                 Command;
	} params;

	params.Command = Command;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.RestartLevel
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void APlayerController::RestartLevel()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.RestartLevel");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ProjectWorldLocationToScreen
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 WorldLocation                  (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               ScreenLocation                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           bPlayerViewportRelative        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool APlayerController::ProjectWorldLocationToScreen(const struct FVector& WorldLocation, bool bPlayerViewportRelative, struct FVector2D* ScreenLocation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ProjectWorldLocationToScreen");

	struct
	{
		struct FVector                 WorldLocation;
		struct FVector2D               ScreenLocation;
		bool                           bPlayerViewportRelative;
		bool                           ReturnValue;
	} params;

	params.WorldLocation = WorldLocation;
	params.bPlayerViewportRelative = bPlayerViewportRelative;

	UObject::ProcessEvent(fn, &params);

	if (ScreenLocation != nullptr)
		*ScreenLocation = params.ScreenLocation;

	return params.ReturnValue;
}


// Function Engine.PlayerController.PlayHapticEffect
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UHapticFeedbackEffect_Base* HapticEffect                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// EControllerHand                Hand                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Scale                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bLoop                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::PlayHapticEffect(class UHapticFeedbackEffect_Base* HapticEffect, EControllerHand Hand, float Scale, bool bLoop)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.PlayHapticEffect");

	struct
	{
		class UHapticFeedbackEffect_Base* HapticEffect;
		EControllerHand                Hand;
		float                          Scale;
		bool                           bLoop;
	} params;

	params.HapticEffect = HapticEffect;
	params.Hand = Hand;
	params.Scale = Scale;
	params.bLoop = bLoop;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.PlayDynamicForceFeedback
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Intensity                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Duration                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAffectsLeftLarge              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAffectsLeftSmall              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAffectsRightLarge             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAffectsRightSmall             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TEnumAsByte<EDynamicForceFeedbackAction> action                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FLatentActionInfo       LatentInfo                     (CPF_Parm)

void APlayerController::PlayDynamicForceFeedback(float Intensity, float Duration, bool bAffectsLeftLarge, bool bAffectsLeftSmall, bool bAffectsRightLarge, bool bAffectsRightSmall, TEnumAsByte<EDynamicForceFeedbackAction> action, const struct FLatentActionInfo& LatentInfo)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.PlayDynamicForceFeedback");

	struct
	{
		float                          Intensity;
		float                          Duration;
		bool                           bAffectsLeftLarge;
		bool                           bAffectsLeftSmall;
		bool                           bAffectsRightLarge;
		bool                           bAffectsRightSmall;
		TEnumAsByte<EDynamicForceFeedbackAction> action;
		struct FLatentActionInfo       LatentInfo;
	} params;

	params.Intensity = Intensity;
	params.Duration = Duration;
	params.bAffectsLeftLarge = bAffectsLeftLarge;
	params.bAffectsLeftSmall = bAffectsLeftSmall;
	params.bAffectsRightLarge = bAffectsRightLarge;
	params.bAffectsRightSmall = bAffectsRightSmall;
	params.action = action;
	params.LatentInfo = LatentInfo;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.Pause
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void APlayerController::Pause()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.Pause");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.OnServerStartedVisualLogger
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// bool                           bIsLogging                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::OnServerStartedVisualLogger(bool bIsLogging)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.OnServerStartedVisualLogger");

	struct
	{
		bool                           bIsLogging;
	} params;

	params.bIsLogging = bIsLogging;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.LocalTravel
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// struct FString                 URL                            (CPF_Parm, CPF_ZeroConstructor)

void APlayerController::LocalTravel(const struct FString& URL)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.LocalTravel");

	struct
	{
		struct FString                 URL;
	} params;

	params.URL = URL;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.IsInputKeyDown
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FKey                    Key                            (CPF_Parm)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool APlayerController::IsInputKeyDown(const struct FKey& Key)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.IsInputKeyDown");

	struct
	{
		struct FKey                    Key;
		bool                           ReturnValue;
	} params;

	params.Key = Key;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PlayerController.GetViewportSize
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// int                            SizeX                          (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            SizeY                          (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::GetViewportSize(int* SizeX, int* SizeY)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.GetViewportSize");

	struct
	{
		int                            SizeX;
		int                            SizeY;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (SizeX != nullptr)
		*SizeX = params.SizeX;
	if (SizeY != nullptr)
		*SizeY = params.SizeY;
}


// Function Engine.PlayerController.GetSpectatorPawn
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class ASpectatorPawn*          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class ASpectatorPawn* APlayerController::GetSpectatorPawn()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.GetSpectatorPawn");

	struct
	{
		class ASpectatorPawn*          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PlayerController.GetMousePosition
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          LocationX                      (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          LocationY                      (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool APlayerController::GetMousePosition(float* LocationX, float* LocationY)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.GetMousePosition");

	struct
	{
		float                          LocationX;
		float                          LocationY;
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (LocationX != nullptr)
		*LocationX = params.LocationX;
	if (LocationY != nullptr)
		*LocationY = params.LocationY;

	return params.ReturnValue;
}


// Function Engine.PlayerController.GetInputVectorKeyState
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FKey                    Key                            (CPF_Parm)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector APlayerController::GetInputVectorKeyState(const struct FKey& Key)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.GetInputVectorKeyState");

	struct
	{
		struct FKey                    Key;
		struct FVector                 ReturnValue;
	} params;

	params.Key = Key;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PlayerController.GetInputTouchState
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TEnumAsByte<ETouchIndex>       FingerIndex                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          LocationX                      (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          LocationY                      (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bIsCurrentlyPressed            (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::GetInputTouchState(TEnumAsByte<ETouchIndex> FingerIndex, float* LocationX, float* LocationY, bool* bIsCurrentlyPressed)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.GetInputTouchState");

	struct
	{
		TEnumAsByte<ETouchIndex>       FingerIndex;
		float                          LocationX;
		float                          LocationY;
		bool                           bIsCurrentlyPressed;
	} params;

	params.FingerIndex = FingerIndex;

	UObject::ProcessEvent(fn, &params);

	if (LocationX != nullptr)
		*LocationX = params.LocationX;
	if (LocationY != nullptr)
		*LocationY = params.LocationY;
	if (bIsCurrentlyPressed != nullptr)
		*bIsCurrentlyPressed = params.bIsCurrentlyPressed;
}


// Function Engine.PlayerController.GetInputMouseDelta
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          DeltaX                         (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          DeltaY                         (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::GetInputMouseDelta(float* DeltaX, float* DeltaY)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.GetInputMouseDelta");

	struct
	{
		float                          DeltaX;
		float                          DeltaY;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (DeltaX != nullptr)
		*DeltaX = params.DeltaX;
	if (DeltaY != nullptr)
		*DeltaY = params.DeltaY;
}


// Function Engine.PlayerController.GetInputMotionState
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 Tilt                           (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FVector                 RotationRate                   (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FVector                 Gravity                        (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FVector                 Acceleration                   (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)

void APlayerController::GetInputMotionState(struct FVector* Tilt, struct FVector* RotationRate, struct FVector* Gravity, struct FVector* Acceleration)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.GetInputMotionState");

	struct
	{
		struct FVector                 Tilt;
		struct FVector                 RotationRate;
		struct FVector                 Gravity;
		struct FVector                 Acceleration;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (Tilt != nullptr)
		*Tilt = params.Tilt;
	if (RotationRate != nullptr)
		*RotationRate = params.RotationRate;
	if (Gravity != nullptr)
		*Gravity = params.Gravity;
	if (Acceleration != nullptr)
		*Acceleration = params.Acceleration;
}


// Function Engine.PlayerController.GetInputKeyTimeDown
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FKey                    Key                            (CPF_Parm)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float APlayerController::GetInputKeyTimeDown(const struct FKey& Key)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.GetInputKeyTimeDown");

	struct
	{
		struct FKey                    Key;
		float                          ReturnValue;
	} params;

	params.Key = Key;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PlayerController.GetInputAnalogStickState
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TEnumAsByte<EControllerAnalogStick> WhichStick                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          StickX                         (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          StickY                         (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::GetInputAnalogStickState(TEnumAsByte<EControllerAnalogStick> WhichStick, float* StickX, float* StickY)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.GetInputAnalogStickState");

	struct
	{
		TEnumAsByte<EControllerAnalogStick> WhichStick;
		float                          StickX;
		float                          StickY;
	} params;

	params.WhichStick = WhichStick;

	UObject::ProcessEvent(fn, &params);

	if (StickX != nullptr)
		*StickX = params.StickX;
	if (StickY != nullptr)
		*StickY = params.StickY;
}


// Function Engine.PlayerController.GetInputAnalogKeyState
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FKey                    Key                            (CPF_Parm)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float APlayerController::GetInputAnalogKeyState(const struct FKey& Key)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.GetInputAnalogKeyState");

	struct
	{
		struct FKey                    Key;
		float                          ReturnValue;
	} params;

	params.Key = Key;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PlayerController.GetHUD
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AHUD*                    ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class AHUD* APlayerController::GetHUD()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.GetHUD");

	struct
	{
		class AHUD*                    ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PlayerController.GetHitResultUnderFingerForObjects
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TEnumAsByte<ETouchIndex>       FingerIndex                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes                    (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// bool                           bTraceComplex                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              HitResult                      (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool APlayerController::GetHitResultUnderFingerForObjects(TEnumAsByte<ETouchIndex> FingerIndex, TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, bool bTraceComplex, struct FHitResult* HitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.GetHitResultUnderFingerForObjects");

	struct
	{
		TEnumAsByte<ETouchIndex>       FingerIndex;
		TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes;
		bool                           bTraceComplex;
		struct FHitResult              HitResult;
		bool                           ReturnValue;
	} params;

	params.FingerIndex = FingerIndex;
	params.ObjectTypes = ObjectTypes;
	params.bTraceComplex = bTraceComplex;

	UObject::ProcessEvent(fn, &params);

	if (HitResult != nullptr)
		*HitResult = params.HitResult;

	return params.ReturnValue;
}


// Function Engine.PlayerController.GetHitResultUnderFingerByChannel
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TEnumAsByte<ETouchIndex>       FingerIndex                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TEnumAsByte<ETraceTypeQuery>   TraceChannel                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bTraceComplex                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              HitResult                      (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool APlayerController::GetHitResultUnderFingerByChannel(TEnumAsByte<ETouchIndex> FingerIndex, TEnumAsByte<ETraceTypeQuery> TraceChannel, bool bTraceComplex, struct FHitResult* HitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.GetHitResultUnderFingerByChannel");

	struct
	{
		TEnumAsByte<ETouchIndex>       FingerIndex;
		TEnumAsByte<ETraceTypeQuery>   TraceChannel;
		bool                           bTraceComplex;
		struct FHitResult              HitResult;
		bool                           ReturnValue;
	} params;

	params.FingerIndex = FingerIndex;
	params.TraceChannel = TraceChannel;
	params.bTraceComplex = bTraceComplex;

	UObject::ProcessEvent(fn, &params);

	if (HitResult != nullptr)
		*HitResult = params.HitResult;

	return params.ReturnValue;
}


// Function Engine.PlayerController.GetHitResultUnderFinger
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TEnumAsByte<ETouchIndex>       FingerIndex                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TEnumAsByte<ECollisionChannel> TraceChannel                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bTraceComplex                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              HitResult                      (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool APlayerController::GetHitResultUnderFinger(TEnumAsByte<ETouchIndex> FingerIndex, TEnumAsByte<ECollisionChannel> TraceChannel, bool bTraceComplex, struct FHitResult* HitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.GetHitResultUnderFinger");

	struct
	{
		TEnumAsByte<ETouchIndex>       FingerIndex;
		TEnumAsByte<ECollisionChannel> TraceChannel;
		bool                           bTraceComplex;
		struct FHitResult              HitResult;
		bool                           ReturnValue;
	} params;

	params.FingerIndex = FingerIndex;
	params.TraceChannel = TraceChannel;
	params.bTraceComplex = bTraceComplex;

	UObject::ProcessEvent(fn, &params);

	if (HitResult != nullptr)
		*HitResult = params.HitResult;

	return params.ReturnValue;
}


// Function Engine.PlayerController.GetHitResultUnderCursorForObjects
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes                    (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// bool                           bTraceComplex                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              HitResult                      (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool APlayerController::GetHitResultUnderCursorForObjects(TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, bool bTraceComplex, struct FHitResult* HitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.GetHitResultUnderCursorForObjects");

	struct
	{
		TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes;
		bool                           bTraceComplex;
		struct FHitResult              HitResult;
		bool                           ReturnValue;
	} params;

	params.ObjectTypes = ObjectTypes;
	params.bTraceComplex = bTraceComplex;

	UObject::ProcessEvent(fn, &params);

	if (HitResult != nullptr)
		*HitResult = params.HitResult;

	return params.ReturnValue;
}


// Function Engine.PlayerController.GetHitResultUnderCursorByChannel
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TEnumAsByte<ETraceTypeQuery>   TraceChannel                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bTraceComplex                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              HitResult                      (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool APlayerController::GetHitResultUnderCursorByChannel(TEnumAsByte<ETraceTypeQuery> TraceChannel, bool bTraceComplex, struct FHitResult* HitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.GetHitResultUnderCursorByChannel");

	struct
	{
		TEnumAsByte<ETraceTypeQuery>   TraceChannel;
		bool                           bTraceComplex;
		struct FHitResult              HitResult;
		bool                           ReturnValue;
	} params;

	params.TraceChannel = TraceChannel;
	params.bTraceComplex = bTraceComplex;

	UObject::ProcessEvent(fn, &params);

	if (HitResult != nullptr)
		*HitResult = params.HitResult;

	return params.ReturnValue;
}


// Function Engine.PlayerController.GetHitResultUnderCursor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// TEnumAsByte<ECollisionChannel> TraceChannel                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bTraceComplex                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FHitResult              HitResult                      (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool APlayerController::GetHitResultUnderCursor(TEnumAsByte<ECollisionChannel> TraceChannel, bool bTraceComplex, struct FHitResult* HitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.GetHitResultUnderCursor");

	struct
	{
		TEnumAsByte<ECollisionChannel> TraceChannel;
		bool                           bTraceComplex;
		struct FHitResult              HitResult;
		bool                           ReturnValue;
	} params;

	params.TraceChannel = TraceChannel;
	params.bTraceComplex = bTraceComplex;

	UObject::ProcessEvent(fn, &params);

	if (HitResult != nullptr)
		*HitResult = params.HitResult;

	return params.ReturnValue;
}


// Function Engine.PlayerController.GetFocalLocation
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector APlayerController::GetFocalLocation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.GetFocalLocation");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PlayerController.FOV
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// float                          NewFOV                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::FOV(float NewFOV)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.FOV");

	struct
	{
		float                          NewFOV;
	} params;

	params.NewFOV = NewFOV;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.EnableCheats
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void APlayerController::EnableCheats()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.EnableCheats");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.DeprojectScreenPositionToWorld
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ScreenX                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ScreenY                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 WorldLocation                  (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FVector                 WorldDirection                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool APlayerController::DeprojectScreenPositionToWorld(float ScreenX, float ScreenY, struct FVector* WorldLocation, struct FVector* WorldDirection)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.DeprojectScreenPositionToWorld");

	struct
	{
		float                          ScreenX;
		float                          ScreenY;
		struct FVector                 WorldLocation;
		struct FVector                 WorldDirection;
		bool                           ReturnValue;
	} params;

	params.ScreenX = ScreenX;
	params.ScreenY = ScreenY;

	UObject::ProcessEvent(fn, &params);

	if (WorldLocation != nullptr)
		*WorldLocation = params.WorldLocation;
	if (WorldDirection != nullptr)
		*WorldDirection = params.WorldDirection;

	return params.ReturnValue;
}


// Function Engine.PlayerController.DeprojectMousePositionToWorld
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 WorldLocation                  (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FVector                 WorldDirection                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool APlayerController::DeprojectMousePositionToWorld(struct FVector* WorldLocation, struct FVector* WorldDirection)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.DeprojectMousePositionToWorld");

	struct
	{
		struct FVector                 WorldLocation;
		struct FVector                 WorldDirection;
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (WorldLocation != nullptr)
		*WorldLocation = params.WorldLocation;
	if (WorldDirection != nullptr)
		*WorldDirection = params.WorldDirection;

	return params.ReturnValue;
}


// Function Engine.PlayerController.ConsoleKey
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// struct FKey                    Key                            (CPF_Parm)

void APlayerController::ConsoleKey(const struct FKey& Key)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ConsoleKey");

	struct
	{
		struct FKey                    Key;
	} params;

	params.Key = Key;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientWasKicked
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// struct FText                   KickReason                     (CPF_ConstParm, CPF_Parm, CPF_ReferenceParm)

void APlayerController::ClientWasKicked(const struct FText& KickReason)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientWasKicked");

	struct
	{
		struct FText                   KickReason;
	} params;

	params.KickReason = KickReason;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientVoiceHandshakeComplete
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)

void APlayerController::ClientVoiceHandshakeComplete()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientVoiceHandshakeComplete");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientUpdateMultipleLevelsStreamingStatus
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// TArray<struct FUpdateLevelStreamingLevelStatus> LevelStatuses                  (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_ReferenceParm)

void APlayerController::ClientUpdateMultipleLevelsStreamingStatus(TArray<struct FUpdateLevelStreamingLevelStatus> LevelStatuses)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientUpdateMultipleLevelsStreamingStatus");

	struct
	{
		TArray<struct FUpdateLevelStreamingLevelStatus> LevelStatuses;
	} params;

	params.LevelStatuses = LevelStatuses;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientUpdateLevelStreamingStatus
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// struct FName                   PackageName                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bNewShouldBeLoaded             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bNewShouldBeVisible            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bNewShouldBlockOnLoad          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            LODIndex                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientUpdateLevelStreamingStatus(const struct FName& PackageName, bool bNewShouldBeLoaded, bool bNewShouldBeVisible, bool bNewShouldBlockOnLoad, int LODIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientUpdateLevelStreamingStatus");

	struct
	{
		struct FName                   PackageName;
		bool                           bNewShouldBeLoaded;
		bool                           bNewShouldBeVisible;
		bool                           bNewShouldBlockOnLoad;
		int                            LODIndex;
	} params;

	params.PackageName = PackageName;
	params.bNewShouldBeLoaded = bNewShouldBeLoaded;
	params.bNewShouldBeVisible = bNewShouldBeVisible;
	params.bNewShouldBlockOnLoad = bNewShouldBlockOnLoad;
	params.LODIndex = LODIndex;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientUnmutePlayer
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// struct FUniqueNetIdRepl        PlayerId                       (CPF_Parm)

void APlayerController::ClientUnmutePlayer(const struct FUniqueNetIdRepl& PlayerId)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientUnmutePlayer");

	struct
	{
		struct FUniqueNetIdRepl        PlayerId;
	} params;

	params.PlayerId = PlayerId;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientTravelInternal
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_HasDefaults, FUNC_NetClient)
// Parameters:
// struct FString                 URL                            (CPF_Parm, CPF_ZeroConstructor)
// TEnumAsByte<ETravelType>       TravelType                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bSeamless                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FGuid                   MapPackageGuid                 (CPF_Parm, CPF_IsPlainOldData)

void APlayerController::ClientTravelInternal(const struct FString& URL, TEnumAsByte<ETravelType> TravelType, bool bSeamless, const struct FGuid& MapPackageGuid)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientTravelInternal");

	struct
	{
		struct FString                 URL;
		TEnumAsByte<ETravelType>       TravelType;
		bool                           bSeamless;
		struct FGuid                   MapPackageGuid;
	} params;

	params.URL = URL;
	params.TravelType = TravelType;
	params.bSeamless = bSeamless;
	params.MapPackageGuid = MapPackageGuid;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientTravel
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults)
// Parameters:
// struct FString                 URL                            (CPF_Parm, CPF_ZeroConstructor)
// TEnumAsByte<ETravelType>       TravelType                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bSeamless                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FGuid                   MapPackageGuid                 (CPF_Parm, CPF_IsPlainOldData)

void APlayerController::ClientTravel(const struct FString& URL, TEnumAsByte<ETravelType> TravelType, bool bSeamless, const struct FGuid& MapPackageGuid)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientTravel");

	struct
	{
		struct FString                 URL;
		TEnumAsByte<ETravelType>       TravelType;
		bool                           bSeamless;
		struct FGuid                   MapPackageGuid;
	} params;

	params.URL = URL;
	params.TravelType = TravelType;
	params.bSeamless = bSeamless;
	params.MapPackageGuid = MapPackageGuid;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientTeamMessage
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// class APlayerState*            SenderPlayerState              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FString                 S                              (CPF_Parm, CPF_ZeroConstructor)
// struct FName                   Type                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          MsgLifeTime                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientTeamMessage(class APlayerState* SenderPlayerState, const struct FString& S, const struct FName& Type, float MsgLifeTime)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientTeamMessage");

	struct
	{
		class APlayerState*            SenderPlayerState;
		struct FString                 S;
		struct FName                   Type;
		float                          MsgLifeTime;
	} params;

	params.SenderPlayerState = SenderPlayerState;
	params.S = S;
	params.Type = Type;
	params.MsgLifeTime = MsgLifeTime;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientStopForceFeedback
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient, FUNC_BlueprintCallable)
// Parameters:
// class UForceFeedbackEffect*    ForceFeedbackEffect            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   Tag                            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientStopForceFeedback(class UForceFeedbackEffect* ForceFeedbackEffect, const struct FName& Tag)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientStopForceFeedback");

	struct
	{
		class UForceFeedbackEffect*    ForceFeedbackEffect;
		struct FName                   Tag;
	} params;

	params.ForceFeedbackEffect = ForceFeedbackEffect;
	params.Tag = Tag;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientStopCameraShake
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient, FUNC_BlueprintCallable)
// Parameters:
// class UClass*                  Shake                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bImmediately                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientStopCameraShake(class UClass* Shake, bool bImmediately)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientStopCameraShake");

	struct
	{
		class UClass*                  Shake;
		bool                           bImmediately;
	} params;

	params.Shake = Shake;
	params.bImmediately = bImmediately;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientStopCameraAnim
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// class UCameraAnim*             AnimToStop                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientStopCameraAnim(class UCameraAnim* AnimToStop)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientStopCameraAnim");

	struct
	{
		class UCameraAnim*             AnimToStop;
	} params;

	params.AnimToStop = AnimToStop;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientStartOnlineSession
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)

void APlayerController::ClientStartOnlineSession()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientStartOnlineSession");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientSpawnCameraLensEffect
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient, FUNC_BlueprintCallable)
// Parameters:
// class UClass*                  LensEffectEmitterClass         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientSpawnCameraLensEffect(class UClass* LensEffectEmitterClass)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientSpawnCameraLensEffect");

	struct
	{
		class UClass*                  LensEffectEmitterClass;
	} params;

	params.LensEffectEmitterClass = LensEffectEmitterClass;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientSetViewTarget
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// class AActor*                  A                              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FViewTargetTransitionParams TransitionParams               (CPF_Parm)

void APlayerController::ClientSetViewTarget(class AActor* A, const struct FViewTargetTransitionParams& TransitionParams)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientSetViewTarget");

	struct
	{
		class AActor*                  A;
		struct FViewTargetTransitionParams TransitionParams;
	} params;

	params.A = A;
	params.TransitionParams = TransitionParams;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientSetSpectatorWaiting
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// bool                           bWaiting                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientSetSpectatorWaiting(bool bWaiting)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientSetSpectatorWaiting");

	struct
	{
		bool                           bWaiting;
	} params;

	params.bWaiting = bWaiting;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientSetHUD
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient, FUNC_BlueprintCallable)
// Parameters:
// class UClass*                  NewHUDClass                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientSetHUD(class UClass* NewHUDClass)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientSetHUD");

	struct
	{
		class UClass*                  NewHUDClass;
	} params;

	params.NewHUDClass = NewHUDClass;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientSetForceMipLevelsToBeResident
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// class UMaterialInterface*      Material                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ForceDuration                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            CinematicTextureGroups         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientSetForceMipLevelsToBeResident(class UMaterialInterface* Material, float ForceDuration, int CinematicTextureGroups)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientSetForceMipLevelsToBeResident");

	struct
	{
		class UMaterialInterface*      Material;
		float                          ForceDuration;
		int                            CinematicTextureGroups;
	} params;

	params.Material = Material;
	params.ForceDuration = ForceDuration;
	params.CinematicTextureGroups = CinematicTextureGroups;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientSetCinematicMode
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// bool                           bInCinematicMode               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAffectsMovement               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAffectsTurning                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAffectsHUD                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientSetCinematicMode(bool bInCinematicMode, bool bAffectsMovement, bool bAffectsTurning, bool bAffectsHUD)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientSetCinematicMode");

	struct
	{
		bool                           bInCinematicMode;
		bool                           bAffectsMovement;
		bool                           bAffectsTurning;
		bool                           bAffectsHUD;
	} params;

	params.bInCinematicMode = bInCinematicMode;
	params.bAffectsMovement = bAffectsMovement;
	params.bAffectsTurning = bAffectsTurning;
	params.bAffectsHUD = bAffectsHUD;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientSetCameraMode
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// struct FName                   NewCamMode                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientSetCameraMode(const struct FName& NewCamMode)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientSetCameraMode");

	struct
	{
		struct FName                   NewCamMode;
	} params;

	params.NewCamMode = NewCamMode;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientSetCameraFade
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_HasDefaults, FUNC_NetClient)
// Parameters:
// bool                           bEnableFading                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FColor                  FadeColor                      (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               FadeAlpha                      (CPF_Parm, CPF_IsPlainOldData)
// float                          FadeTime                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bFadeAudio                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientSetCameraFade(bool bEnableFading, const struct FColor& FadeColor, const struct FVector2D& FadeAlpha, float FadeTime, bool bFadeAudio)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientSetCameraFade");

	struct
	{
		bool                           bEnableFading;
		struct FColor                  FadeColor;
		struct FVector2D               FadeAlpha;
		float                          FadeTime;
		bool                           bFadeAudio;
	} params;

	params.bEnableFading = bEnableFading;
	params.FadeColor = FadeColor;
	params.FadeAlpha = FadeAlpha;
	params.FadeTime = FadeTime;
	params.bFadeAudio = bFadeAudio;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientSetBlockOnAsyncLoading
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)

void APlayerController::ClientSetBlockOnAsyncLoading()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientSetBlockOnAsyncLoading");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientReturnToMainMenuWithTextReason
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// struct FText                   ReturnReason                   (CPF_ConstParm, CPF_Parm, CPF_ReferenceParm)

void APlayerController::ClientReturnToMainMenuWithTextReason(const struct FText& ReturnReason)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientReturnToMainMenuWithTextReason");

	struct
	{
		struct FText                   ReturnReason;
	} params;

	params.ReturnReason = ReturnReason;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientReturnToMainMenu
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// struct FString                 ReturnReason                   (CPF_Parm, CPF_ZeroConstructor)

void APlayerController::ClientReturnToMainMenu(const struct FString& ReturnReason)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientReturnToMainMenu");

	struct
	{
		struct FString                 ReturnReason;
	} params;

	params.ReturnReason = ReturnReason;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientRetryClientRestart
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// class APawn*                   NewPawn                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientRetryClientRestart(class APawn* NewPawn)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientRetryClientRestart");

	struct
	{
		class APawn*                   NewPawn;
	} params;

	params.NewPawn = NewPawn;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientRestart
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// class APawn*                   NewPawn                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientRestart(class APawn* NewPawn)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientRestart");

	struct
	{
		class APawn*                   NewPawn;
	} params;

	params.NewPawn = NewPawn;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientReset
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)

void APlayerController::ClientReset()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientReset");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientRepObjRef
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// class UObject*                 Object                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientRepObjRef(class UObject* Object)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientRepObjRef");

	struct
	{
		class UObject*                 Object;
	} params;

	params.Object = Object;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientReceiveLocalizedMessage
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// class UClass*                  Message                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            Switch                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class APlayerState*            RelatedPlayerState_2           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class APlayerState*            RelatedPlayerState_3           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UObject*                 OptionalObject                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientReceiveLocalizedMessage(class UClass* Message, int Switch, class APlayerState* RelatedPlayerState_2, class APlayerState* RelatedPlayerState_3, class UObject* OptionalObject)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientReceiveLocalizedMessage");

	struct
	{
		class UClass*                  Message;
		int                            Switch;
		class APlayerState*            RelatedPlayerState_2;
		class APlayerState*            RelatedPlayerState_3;
		class UObject*                 OptionalObject;
	} params;

	params.Message = Message;
	params.Switch = Switch;
	params.RelatedPlayerState_2 = RelatedPlayerState_2;
	params.RelatedPlayerState_3 = RelatedPlayerState_3;
	params.OptionalObject = OptionalObject;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientPrestreamTextures
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// class AActor*                  ForcedActor                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ForceDuration                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bEnableStreaming               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            CinematicTextureGroups         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientPrestreamTextures(class AActor* ForcedActor, float ForceDuration, bool bEnableStreaming, int CinematicTextureGroups)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientPrestreamTextures");

	struct
	{
		class AActor*                  ForcedActor;
		float                          ForceDuration;
		bool                           bEnableStreaming;
		int                            CinematicTextureGroups;
	} params;

	params.ForcedActor = ForcedActor;
	params.ForceDuration = ForceDuration;
	params.bEnableStreaming = bEnableStreaming;
	params.CinematicTextureGroups = CinematicTextureGroups;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientPrepareMapChange
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// struct FName                   LevelName                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bFirst                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bLast                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientPrepareMapChange(const struct FName& LevelName, bool bFirst, bool bLast)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientPrepareMapChange");

	struct
	{
		struct FName                   LevelName;
		bool                           bFirst;
		bool                           bLast;
	} params;

	params.LevelName = LevelName;
	params.bFirst = bFirst;
	params.bLast = bLast;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientPlaySoundAtLocation
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_HasDefaults, FUNC_NetClient)
// Parameters:
// class USoundBase*              Sound                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 Location                       (CPF_Parm, CPF_IsPlainOldData)
// float                          VolumeMultiplier               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          PitchMultiplier                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientPlaySoundAtLocation(class USoundBase* Sound, const struct FVector& Location, float VolumeMultiplier, float PitchMultiplier)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientPlaySoundAtLocation");

	struct
	{
		class USoundBase*              Sound;
		struct FVector                 Location;
		float                          VolumeMultiplier;
		float                          PitchMultiplier;
	} params;

	params.Sound = Sound;
	params.Location = Location;
	params.VolumeMultiplier = VolumeMultiplier;
	params.PitchMultiplier = PitchMultiplier;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientPlaySound
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// class USoundBase*              Sound                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          VolumeMultiplier               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          PitchMultiplier                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientPlaySound(class USoundBase* Sound, float VolumeMultiplier, float PitchMultiplier)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientPlaySound");

	struct
	{
		class USoundBase*              Sound;
		float                          VolumeMultiplier;
		float                          PitchMultiplier;
	} params;

	params.Sound = Sound;
	params.VolumeMultiplier = VolumeMultiplier;
	params.PitchMultiplier = PitchMultiplier;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientPlayForceFeedback
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient, FUNC_BlueprintCallable)
// Parameters:
// class UForceFeedbackEffect*    ForceFeedbackEffect            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bLooping                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bIgnoreTimeDilation            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   Tag                            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientPlayForceFeedback(class UForceFeedbackEffect* ForceFeedbackEffect, bool bLooping, bool bIgnoreTimeDilation, const struct FName& Tag)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientPlayForceFeedback");

	struct
	{
		class UForceFeedbackEffect*    ForceFeedbackEffect;
		bool                           bLooping;
		bool                           bIgnoreTimeDilation;
		struct FName                   Tag;
	} params;

	params.ForceFeedbackEffect = ForceFeedbackEffect;
	params.bLooping = bLooping;
	params.bIgnoreTimeDilation = bIgnoreTimeDilation;
	params.Tag = Tag;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientPlayCameraShake
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_HasDefaults, FUNC_NetClient, FUNC_BlueprintCallable)
// Parameters:
// class UClass*                  Shake                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Scale                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TEnumAsByte<ECameraAnimPlaySpace> PlaySpace                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FRotator                UserPlaySpaceRot               (CPF_Parm, CPF_IsPlainOldData)

void APlayerController::ClientPlayCameraShake(class UClass* Shake, float Scale, TEnumAsByte<ECameraAnimPlaySpace> PlaySpace, const struct FRotator& UserPlaySpaceRot)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientPlayCameraShake");

	struct
	{
		class UClass*                  Shake;
		float                          Scale;
		TEnumAsByte<ECameraAnimPlaySpace> PlaySpace;
		struct FRotator                UserPlaySpaceRot;
	} params;

	params.Shake = Shake;
	params.Scale = Scale;
	params.PlaySpace = PlaySpace;
	params.UserPlaySpaceRot = UserPlaySpaceRot;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientPlayCameraAnim
// (FUNC_Net, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_HasDefaults, FUNC_NetClient, FUNC_BlueprintCallable)
// Parameters:
// class UCameraAnim*             AnimToPlay                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Scale                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Rate                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          BlendInTime                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          BlendOutTime                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bLoop                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bRandomStartTime               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TEnumAsByte<ECameraAnimPlaySpace> Space                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FRotator                CustomPlaySpace                (CPF_Parm, CPF_IsPlainOldData)

void APlayerController::ClientPlayCameraAnim(class UCameraAnim* AnimToPlay, float Scale, float Rate, float BlendInTime, float BlendOutTime, bool bLoop, bool bRandomStartTime, TEnumAsByte<ECameraAnimPlaySpace> Space, const struct FRotator& CustomPlaySpace)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientPlayCameraAnim");

	struct
	{
		class UCameraAnim*             AnimToPlay;
		float                          Scale;
		float                          Rate;
		float                          BlendInTime;
		float                          BlendOutTime;
		bool                           bLoop;
		bool                           bRandomStartTime;
		TEnumAsByte<ECameraAnimPlaySpace> Space;
		struct FRotator                CustomPlaySpace;
	} params;

	params.AnimToPlay = AnimToPlay;
	params.Scale = Scale;
	params.Rate = Rate;
	params.BlendInTime = BlendInTime;
	params.BlendOutTime = BlendOutTime;
	params.bLoop = bLoop;
	params.bRandomStartTime = bRandomStartTime;
	params.Space = Space;
	params.CustomPlaySpace = CustomPlaySpace;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientMutePlayer
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// struct FUniqueNetIdRepl        PlayerId                       (CPF_Parm)

void APlayerController::ClientMutePlayer(const struct FUniqueNetIdRepl& PlayerId)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientMutePlayer");

	struct
	{
		struct FUniqueNetIdRepl        PlayerId;
	} params;

	params.PlayerId = PlayerId;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientMessage
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// struct FString                 S                              (CPF_Parm, CPF_ZeroConstructor)
// struct FName                   Type                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          MsgLifeTime                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientMessage(const struct FString& S, const struct FName& Type, float MsgLifeTime)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientMessage");

	struct
	{
		struct FString                 S;
		struct FName                   Type;
		float                          MsgLifeTime;
	} params;

	params.S = S;
	params.Type = Type;
	params.MsgLifeTime = MsgLifeTime;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientIgnoreMoveInput
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// bool                           bIgnore                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientIgnoreMoveInput(bool bIgnore)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientIgnoreMoveInput");

	struct
	{
		bool                           bIgnore;
	} params;

	params.bIgnore = bIgnore;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientIgnoreLookInput
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// bool                           bIgnore                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientIgnoreLookInput(bool bIgnore)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientIgnoreLookInput");

	struct
	{
		bool                           bIgnore;
	} params;

	params.bIgnore = bIgnore;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientGotoState
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// struct FName                   NewState                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientGotoState(const struct FName& NewState)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientGotoState");

	struct
	{
		struct FName                   NewState;
	} params;

	params.NewState = NewState;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientGameEnded
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// class AActor*                  EndGameFocus                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bIsWinner                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientGameEnded(class AActor* EndGameFocus, bool bIsWinner)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientGameEnded");

	struct
	{
		class AActor*                  EndGameFocus;
		bool                           bIsWinner;
	} params;

	params.EndGameFocus = EndGameFocus;
	params.bIsWinner = bIsWinner;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientForceGarbageCollection
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)

void APlayerController::ClientForceGarbageCollection()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientForceGarbageCollection");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientFlushLevelStreaming
// (FUNC_Final, FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)

void APlayerController::ClientFlushLevelStreaming()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientFlushLevelStreaming");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientEndOnlineSession
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)

void APlayerController::ClientEndOnlineSession()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientEndOnlineSession");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientEnableNetworkVoice
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// bool                           bEnable                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientEnableNetworkVoice(bool bEnable)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientEnableNetworkVoice");

	struct
	{
		bool                           bEnable;
	} params;

	params.bEnable = bEnable;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientCommitMapChange
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)

void APlayerController::ClientCommitMapChange()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientCommitMapChange");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientClearCameraLensEffects
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient, FUNC_BlueprintCallable)

void APlayerController::ClientClearCameraLensEffects()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientClearCameraLensEffects");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientCapBandwidth
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)
// Parameters:
// int                            Cap                            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientCapBandwidth(int Cap)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientCapBandwidth");

	struct
	{
		int                            Cap;
	} params;

	params.Cap = Cap;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientCancelPendingMapChange
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetClient)

void APlayerController::ClientCancelPendingMapChange()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientCancelPendingMapChange");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClientAddTextureStreamingLoc
// (FUNC_Final, FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_HasDefaults, FUNC_NetClient)
// Parameters:
// struct FVector                 InLoc                          (CPF_Parm, CPF_IsPlainOldData)
// float                          Duration                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bOverrideLocation              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ClientAddTextureStreamingLoc(const struct FVector& InLoc, float Duration, bool bOverrideLocation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClientAddTextureStreamingLoc");

	struct
	{
		struct FVector                 InLoc;
		float                          Duration;
		bool                           bOverrideLocation;
	} params;

	params.InLoc = InLoc;
	params.Duration = Duration;
	params.bOverrideLocation = bOverrideLocation;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ClearAudioListenerOverride
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void APlayerController::ClearAudioListenerOverride()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ClearAudioListenerOverride");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.Camera
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// struct FName                   NewMode                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::Camera(const struct FName& NewMode)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.Camera");

	struct
	{
		struct FName                   NewMode;
	} params;

	params.NewMode = NewMode;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.AddYawInput
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Val                            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::AddYawInput(float Val)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.AddYawInput");

	struct
	{
		float                          Val;
	} params;

	params.Val = Val;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.AddRollInput
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Val                            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::AddRollInput(float Val)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.AddRollInput");

	struct
	{
		float                          Val;
	} params;

	params.Val = Val;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.AddPitchInput
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Val                            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::AddPitchInput(float Val)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.AddPitchInput");

	struct
	{
		float                          Val;
	} params;

	params.Val = Val;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerController.ActivateTouchInterface
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UTouchInterface*         NewTouchInterface              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerController::ActivateTouchInterface(class UTouchInterface* NewTouchInterface)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerController.ActivateTouchInterface");

	struct
	{
		class UTouchInterface*         NewTouchInterface;
	} params;

	params.NewTouchInterface = NewTouchInterface;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerCameraManager.StopCameraShake
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UCameraShake*            ShakeInstance                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bImmediately                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerCameraManager::StopCameraShake(class UCameraShake* ShakeInstance, bool bImmediately)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.StopCameraShake");

	struct
	{
		class UCameraShake*            ShakeInstance;
		bool                           bImmediately;
	} params;

	params.ShakeInstance = ShakeInstance;
	params.bImmediately = bImmediately;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerCameraManager.StopCameraFade
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void APlayerCameraManager::StopCameraFade()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.StopCameraFade");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerCameraManager.StopCameraAnimInst
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UCameraAnimInst*         AnimInst                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bImmediate                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerCameraManager::StopCameraAnimInst(class UCameraAnimInst* AnimInst, bool bImmediate)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.StopCameraAnimInst");

	struct
	{
		class UCameraAnimInst*         AnimInst;
		bool                           bImmediate;
	} params;

	params.AnimInst = AnimInst;
	params.bImmediate = bImmediate;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerCameraManager.StopAllInstancesOfCameraShake
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UClass*                  Shake                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bImmediately                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerCameraManager::StopAllInstancesOfCameraShake(class UClass* Shake, bool bImmediately)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.StopAllInstancesOfCameraShake");

	struct
	{
		class UClass*                  Shake;
		bool                           bImmediately;
	} params;

	params.Shake = Shake;
	params.bImmediately = bImmediately;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerCameraManager.StopAllInstancesOfCameraAnim
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UCameraAnim*             Anim                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bImmediate                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerCameraManager::StopAllInstancesOfCameraAnim(class UCameraAnim* Anim, bool bImmediate)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.StopAllInstancesOfCameraAnim");

	struct
	{
		class UCameraAnim*             Anim;
		bool                           bImmediate;
	} params;

	params.Anim = Anim;
	params.bImmediate = bImmediate;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerCameraManager.StopAllCameraShakes
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bImmediately                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerCameraManager::StopAllCameraShakes(bool bImmediately)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.StopAllCameraShakes");

	struct
	{
		bool                           bImmediately;
	} params;

	params.bImmediately = bImmediately;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerCameraManager.StopAllCameraAnims
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bImmediate                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerCameraManager::StopAllCameraAnims(bool bImmediate)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.StopAllCameraAnims");

	struct
	{
		bool                           bImmediate;
	} params;

	params.bImmediate = bImmediate;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerCameraManager.StartCameraFade
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// float                          FromAlpha                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ToAlpha                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Duration                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FLinearColor            Color                          (CPF_Parm, CPF_IsPlainOldData)
// bool                           bShouldFadeAudio               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bHoldWhenFinished              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerCameraManager::StartCameraFade(float FromAlpha, float ToAlpha, float Duration, const struct FLinearColor& Color, bool bShouldFadeAudio, bool bHoldWhenFinished)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.StartCameraFade");

	struct
	{
		float                          FromAlpha;
		float                          ToAlpha;
		float                          Duration;
		struct FLinearColor            Color;
		bool                           bShouldFadeAudio;
		bool                           bHoldWhenFinished;
	} params;

	params.FromAlpha = FromAlpha;
	params.ToAlpha = ToAlpha;
	params.Duration = Duration;
	params.Color = Color;
	params.bShouldFadeAudio = bShouldFadeAudio;
	params.bHoldWhenFinished = bHoldWhenFinished;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerCameraManager.SetManualCameraFade
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// float                          InFadeAmount                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FLinearColor            Color                          (CPF_Parm, CPF_IsPlainOldData)
// bool                           bInFadeAudio                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerCameraManager::SetManualCameraFade(float InFadeAmount, const struct FLinearColor& Color, bool bInFadeAudio)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.SetManualCameraFade");

	struct
	{
		float                          InFadeAmount;
		struct FLinearColor            Color;
		bool                           bInFadeAudio;
	} params;

	params.InFadeAmount = InFadeAmount;
	params.Color = Color;
	params.bInFadeAudio = bInFadeAudio;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerCameraManager.RemoveCameraModifier
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UCameraModifier*         ModifierToRemove               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool APlayerCameraManager::RemoveCameraModifier(class UCameraModifier* ModifierToRemove)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.RemoveCameraModifier");

	struct
	{
		class UCameraModifier*         ModifierToRemove;
		bool                           ReturnValue;
	} params;

	params.ModifierToRemove = ModifierToRemove;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PlayerCameraManager.RemoveCameraLensEffect
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class AEmitterCameraLensEffectBase* Emitter                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void APlayerCameraManager::RemoveCameraLensEffect(class AEmitterCameraLensEffectBase* Emitter)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.RemoveCameraLensEffect");

	struct
	{
		class AEmitterCameraLensEffectBase* Emitter;
	} params;

	params.Emitter = Emitter;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerCameraManager.PlayCameraShake
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UClass*                  ShakeClass                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Scale                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TEnumAsByte<ECameraAnimPlaySpace> PlaySpace                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FRotator                UserPlaySpaceRot               (CPF_Parm, CPF_IsPlainOldData)
// class UCameraShake*            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UCameraShake* APlayerCameraManager::PlayCameraShake(class UClass* ShakeClass, float Scale, TEnumAsByte<ECameraAnimPlaySpace> PlaySpace, const struct FRotator& UserPlaySpaceRot)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.PlayCameraShake");

	struct
	{
		class UClass*                  ShakeClass;
		float                          Scale;
		TEnumAsByte<ECameraAnimPlaySpace> PlaySpace;
		struct FRotator                UserPlaySpaceRot;
		class UCameraShake*            ReturnValue;
	} params;

	params.ShakeClass = ShakeClass;
	params.Scale = Scale;
	params.PlaySpace = PlaySpace;
	params.UserPlaySpaceRot = UserPlaySpaceRot;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PlayerCameraManager.PlayCameraAnim
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UCameraAnim*             Anim                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Rate                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Scale                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          BlendInTime                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          BlendOutTime                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bLoop                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bRandomStartTime               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Duration                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TEnumAsByte<ECameraAnimPlaySpace> PlaySpace                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FRotator                UserPlaySpaceRot               (CPF_Parm, CPF_IsPlainOldData)
// class UCameraAnimInst*         ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UCameraAnimInst* APlayerCameraManager::PlayCameraAnim(class UCameraAnim* Anim, float Rate, float Scale, float BlendInTime, float BlendOutTime, bool bLoop, bool bRandomStartTime, float Duration, TEnumAsByte<ECameraAnimPlaySpace> PlaySpace, const struct FRotator& UserPlaySpaceRot)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.PlayCameraAnim");

	struct
	{
		class UCameraAnim*             Anim;
		float                          Rate;
		float                          Scale;
		float                          BlendInTime;
		float                          BlendOutTime;
		bool                           bLoop;
		bool                           bRandomStartTime;
		float                          Duration;
		TEnumAsByte<ECameraAnimPlaySpace> PlaySpace;
		struct FRotator                UserPlaySpaceRot;
		class UCameraAnimInst*         ReturnValue;
	} params;

	params.Anim = Anim;
	params.Rate = Rate;
	params.Scale = Scale;
	params.BlendInTime = BlendInTime;
	params.BlendOutTime = BlendOutTime;
	params.bLoop = bLoop;
	params.bRandomStartTime = bRandomStartTime;
	params.Duration = Duration;
	params.PlaySpace = PlaySpace;
	params.UserPlaySpaceRot = UserPlaySpaceRot;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PlayerCameraManager.PhotographyCameraModify
// (FUNC_BlueprintCosmetic, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintEvent)
// Parameters:
// struct FVector                 NewCameraLocation              (CPF_ConstParm, CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 PreviousCameraLocation         (CPF_ConstParm, CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 OriginalCameraLocation         (CPF_ConstParm, CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 ResultCameraLocation           (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)

void APlayerCameraManager::PhotographyCameraModify(const struct FVector& NewCameraLocation, const struct FVector& PreviousCameraLocation, const struct FVector& OriginalCameraLocation, struct FVector* ResultCameraLocation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.PhotographyCameraModify");

	struct
	{
		struct FVector                 NewCameraLocation;
		struct FVector                 PreviousCameraLocation;
		struct FVector                 OriginalCameraLocation;
		struct FVector                 ResultCameraLocation;
	} params;

	params.NewCameraLocation = NewCameraLocation;
	params.PreviousCameraLocation = PreviousCameraLocation;
	params.OriginalCameraLocation = OriginalCameraLocation;

	UObject::ProcessEvent(fn, &params);

	if (ResultCameraLocation != nullptr)
		*ResultCameraLocation = params.ResultCameraLocation;
}


// Function Engine.PlayerCameraManager.OnPhotographySessionStart
// (FUNC_BlueprintCosmetic, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)

void APlayerCameraManager::OnPhotographySessionStart()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.OnPhotographySessionStart");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerCameraManager.OnPhotographySessionEnd
// (FUNC_BlueprintCosmetic, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)

void APlayerCameraManager::OnPhotographySessionEnd()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.OnPhotographySessionEnd");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerCameraManager.OnPhotographyMultiPartCaptureStart
// (FUNC_BlueprintCosmetic, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)

void APlayerCameraManager::OnPhotographyMultiPartCaptureStart()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.OnPhotographyMultiPartCaptureStart");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerCameraManager.OnPhotographyMultiPartCaptureEnd
// (FUNC_BlueprintCosmetic, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)

void APlayerCameraManager::OnPhotographyMultiPartCaptureEnd()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.OnPhotographyMultiPartCaptureEnd");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerCameraManager.GetOwningPlayerController
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class APlayerController*       ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class APlayerController* APlayerCameraManager::GetOwningPlayerController()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.GetOwningPlayerController");

	struct
	{
		class APlayerController*       ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PlayerCameraManager.GetFOVAngle
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float APlayerCameraManager::GetFOVAngle()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.GetFOVAngle");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PlayerCameraManager.GetCameraRotation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FRotator                ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FRotator APlayerCameraManager::GetCameraRotation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.GetCameraRotation");

	struct
	{
		struct FRotator                ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PlayerCameraManager.GetCameraLocation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector APlayerCameraManager::GetCameraLocation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.GetCameraLocation");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PlayerCameraManager.FindCameraModifierByClass
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UClass*                  ModifierClass                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UCameraModifier*         ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UCameraModifier* APlayerCameraManager::FindCameraModifierByClass(class UClass* ModifierClass)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.FindCameraModifierByClass");

	struct
	{
		class UClass*                  ModifierClass;
		class UCameraModifier*         ReturnValue;
	} params;

	params.ModifierClass = ModifierClass;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PlayerCameraManager.ClearCameraLensEffects
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void APlayerCameraManager::ClearCameraLensEffects()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.ClearCameraLensEffects");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.PlayerCameraManager.BlueprintUpdateCamera
// (FUNC_BlueprintCosmetic, FUNC_Event, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintEvent)
// Parameters:
// class AActor*                  CameraTarget                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 NewCameraLocation              (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FRotator                NewCameraRotation              (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// float                          NewCameraFOV                   (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool APlayerCameraManager::BlueprintUpdateCamera(class AActor* CameraTarget, struct FVector* NewCameraLocation, struct FRotator* NewCameraRotation, float* NewCameraFOV)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.BlueprintUpdateCamera");

	struct
	{
		class AActor*                  CameraTarget;
		struct FVector                 NewCameraLocation;
		struct FRotator                NewCameraRotation;
		float                          NewCameraFOV;
		bool                           ReturnValue;
	} params;

	params.CameraTarget = CameraTarget;

	UObject::ProcessEvent(fn, &params);

	if (NewCameraLocation != nullptr)
		*NewCameraLocation = params.NewCameraLocation;
	if (NewCameraRotation != nullptr)
		*NewCameraRotation = params.NewCameraRotation;
	if (NewCameraFOV != nullptr)
		*NewCameraFOV = params.NewCameraFOV;

	return params.ReturnValue;
}


// Function Engine.PlayerCameraManager.AddNewCameraModifier
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UClass*                  ModifierClass                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UCameraModifier*         ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UCameraModifier* APlayerCameraManager::AddNewCameraModifier(class UClass* ModifierClass)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.AddNewCameraModifier");

	struct
	{
		class UClass*                  ModifierClass;
		class UCameraModifier*         ReturnValue;
	} params;

	params.ModifierClass = ModifierClass;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.PlayerCameraManager.AddCameraLensEffect
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UClass*                  LensEffectEmitterClass         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class AEmitterCameraLensEffectBase* ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class AEmitterCameraLensEffectBase* APlayerCameraManager::AddCameraLensEffect(class UClass* LensEffectEmitterClass)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.PlayerCameraManager.AddCameraLensEffect");

	struct
	{
		class UClass*                  LensEffectEmitterClass;
		class AEmitterCameraLensEffectBase* ReturnValue;
	} params;

	params.LensEffectEmitterClass = LensEffectEmitterClass;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CameraComponent.SetUseFieldOfViewForLOD
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bInUseFieldOfViewForLOD        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCameraComponent::SetUseFieldOfViewForLOD(bool bInUseFieldOfViewForLOD)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraComponent.SetUseFieldOfViewForLOD");

	struct
	{
		bool                           bInUseFieldOfViewForLOD;
	} params;

	params.bInUseFieldOfViewForLOD = bInUseFieldOfViewForLOD;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CameraComponent.SetProjectionMode
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// TEnumAsByte<ECameraProjectionMode> InProjectionMode               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCameraComponent::SetProjectionMode(TEnumAsByte<ECameraProjectionMode> InProjectionMode)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraComponent.SetProjectionMode");

	struct
	{
		TEnumAsByte<ECameraProjectionMode> InProjectionMode;
	} params;

	params.InProjectionMode = InProjectionMode;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CameraComponent.SetPostProcessBlendWeight
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InPostProcessBlendWeight       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCameraComponent::SetPostProcessBlendWeight(float InPostProcessBlendWeight)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraComponent.SetPostProcessBlendWeight");

	struct
	{
		float                          InPostProcessBlendWeight;
	} params;

	params.InPostProcessBlendWeight = InPostProcessBlendWeight;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CameraComponent.SetOrthoWidth
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InOrthoWidth                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCameraComponent::SetOrthoWidth(float InOrthoWidth)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraComponent.SetOrthoWidth");

	struct
	{
		float                          InOrthoWidth;
	} params;

	params.InOrthoWidth = InOrthoWidth;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CameraComponent.SetOrthoNearClipPlane
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InOrthoNearClipPlane           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCameraComponent::SetOrthoNearClipPlane(float InOrthoNearClipPlane)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraComponent.SetOrthoNearClipPlane");

	struct
	{
		float                          InOrthoNearClipPlane;
	} params;

	params.InOrthoNearClipPlane = InOrthoNearClipPlane;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CameraComponent.SetOrthoFarClipPlane
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InOrthoFarClipPlane            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCameraComponent::SetOrthoFarClipPlane(float InOrthoFarClipPlane)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraComponent.SetOrthoFarClipPlane");

	struct
	{
		float                          InOrthoFarClipPlane;
	} params;

	params.InOrthoFarClipPlane = InOrthoFarClipPlane;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CameraComponent.SetFieldOfView
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InFieldOfView                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCameraComponent::SetFieldOfView(float InFieldOfView)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraComponent.SetFieldOfView");

	struct
	{
		float                          InFieldOfView;
	} params;

	params.InFieldOfView = InFieldOfView;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CameraComponent.SetConstraintAspectRatio
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bInConstrainAspectRatio        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCameraComponent::SetConstraintAspectRatio(bool bInConstrainAspectRatio)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraComponent.SetConstraintAspectRatio");

	struct
	{
		bool                           bInConstrainAspectRatio;
	} params;

	params.bInConstrainAspectRatio = bInConstrainAspectRatio;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CameraComponent.SetAspectRatio
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InAspectRatio                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCameraComponent::SetAspectRatio(float InAspectRatio)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraComponent.SetAspectRatio");

	struct
	{
		float                          InAspectRatio;
	} params;

	params.InAspectRatio = InAspectRatio;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CameraComponent.RemoveBlendable
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// TScriptInterface<class UBlendableInterface> InBlendableObject              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCameraComponent::RemoveBlendable(const TScriptInterface<class UBlendableInterface>& InBlendableObject)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraComponent.RemoveBlendable");

	struct
	{
		TScriptInterface<class UBlendableInterface> InBlendableObject;
	} params;

	params.InBlendableObject = InBlendableObject;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CameraComponent.GetCameraView
// (FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// float                          DeltaTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FMinimalViewInfo        DesiredView                    (CPF_Parm, CPF_OutParm)

void UCameraComponent::GetCameraView(float DeltaTime, struct FMinimalViewInfo* DesiredView)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraComponent.GetCameraView");

	struct
	{
		float                          DeltaTime;
		struct FMinimalViewInfo        DesiredView;
	} params;

	params.DeltaTime = DeltaTime;

	UObject::ProcessEvent(fn, &params);

	if (DesiredView != nullptr)
		*DesiredView = params.DesiredView;
}


// Function Engine.CameraComponent.AddOrUpdateBlendable
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// TScriptInterface<class UBlendableInterface> InBlendableObject              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InWeight                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCameraComponent::AddOrUpdateBlendable(const TScriptInterface<class UBlendableInterface>& InBlendableObject, float InWeight)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraComponent.AddOrUpdateBlendable");

	struct
	{
		TScriptInterface<class UBlendableInterface> InBlendableObject;
		float                          InWeight;
	} params;

	params.InBlendableObject = InBlendableObject;
	params.InWeight = InWeight;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SpringArmComponent.IsCollisionFixApplied
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool USpringArmComponent::IsCollisionFixApplied()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SpringArmComponent.IsCollisionFixApplied");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SpringArmComponent.GetUnfixedCameraPosition
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector USpringArmComponent::GetUnfixedCameraPosition()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SpringArmComponent.GetUnfixedCameraPosition");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SpringArmComponent.GetTargetRotation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FRotator                ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FRotator USpringArmComponent::GetTargetRotation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SpringArmComponent.GetTargetRotation");

	struct
	{
		struct FRotator                ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.ProjectileMovementComponent.StopSimulating
// (FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// struct FHitResult              HitResult                      (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)

void UProjectileMovementComponent::StopSimulating(const struct FHitResult& HitResult)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ProjectileMovementComponent.StopSimulating");

	struct
	{
		struct FHitResult              HitResult;
	} params;

	params.HitResult = HitResult;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ProjectileMovementComponent.SetVelocityInLocalSpace
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewVelocity                    (CPF_Parm, CPF_IsPlainOldData)

void UProjectileMovementComponent::SetVelocityInLocalSpace(const struct FVector& NewVelocity)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ProjectileMovementComponent.SetVelocityInLocalSpace");

	struct
	{
		struct FVector                 NewVelocity;
	} params;

	params.NewVelocity = NewVelocity;

	UObject::ProcessEvent(fn, &params);
}


// DelegateFunction Engine.ProjectileMovementComponent.OnProjectileStopDelegate__DelegateSignature
// (FUNC_MulticastDelegate, FUNC_Public, FUNC_Delegate, FUNC_HasOutParms)
// Parameters:
// struct FHitResult              ImpactResult                   (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)

void UProjectileMovementComponent::OnProjectileStopDelegate__DelegateSignature(const struct FHitResult& ImpactResult)
{
	static auto fn = UObject::FindObject<UFunction>("DelegateFunction Engine.ProjectileMovementComponent.OnProjectileStopDelegate__DelegateSignature");

	struct
	{
		struct FHitResult              ImpactResult;
	} params;

	params.ImpactResult = ImpactResult;

	UObject::ProcessEvent(fn, &params);
}


// DelegateFunction Engine.ProjectileMovementComponent.OnProjectileBounceDelegate__DelegateSignature
// (FUNC_MulticastDelegate, FUNC_Public, FUNC_Delegate, FUNC_HasOutParms, FUNC_HasDefaults)
// Parameters:
// struct FHitResult              ImpactResult                   (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// struct FVector                 ImpactVelocity                 (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)

void UProjectileMovementComponent::OnProjectileBounceDelegate__DelegateSignature(const struct FHitResult& ImpactResult, const struct FVector& ImpactVelocity)
{
	static auto fn = UObject::FindObject<UFunction>("DelegateFunction Engine.ProjectileMovementComponent.OnProjectileBounceDelegate__DelegateSignature");

	struct
	{
		struct FHitResult              ImpactResult;
		struct FVector                 ImpactVelocity;
	} params;

	params.ImpactResult = ImpactResult;
	params.ImpactVelocity = ImpactVelocity;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ProjectileMovementComponent.LimitVelocity
// (FUNC_Final, FUNC_Native, FUNC_Protected, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 NewVelocity                    (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UProjectileMovementComponent::LimitVelocity(const struct FVector& NewVelocity)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ProjectileMovementComponent.LimitVelocity");

	struct
	{
		struct FVector                 NewVelocity;
		struct FVector                 ReturnValue;
	} params;

	params.NewVelocity = NewVelocity;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AudioComponent.Stop
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UAudioComponent::Stop()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.Stop");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioComponent.SetWaveParameter
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   InName                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class USoundWave*              InWave                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAudioComponent::SetWaveParameter(const struct FName& InName, class USoundWave* InWave)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.SetWaveParameter");

	struct
	{
		struct FName                   InName;
		class USoundWave*              InWave;
	} params;

	params.InName = InName;
	params.InWave = InWave;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioComponent.SetVolumeMultiplier
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewVolumeMultiplier            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAudioComponent::SetVolumeMultiplier(float NewVolumeMultiplier)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.SetVolumeMultiplier");

	struct
	{
		float                          NewVolumeMultiplier;
	} params;

	params.NewVolumeMultiplier = NewVolumeMultiplier;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioComponent.SetUISound
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bInUISound                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAudioComponent::SetUISound(bool bInUISound)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.SetUISound");

	struct
	{
		bool                           bInUISound;
	} params;

	params.bInUISound = bInUISound;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioComponent.SetSubmixSend
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class USoundSubmix*            Submix                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          SendLevel                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAudioComponent::SetSubmixSend(class USoundSubmix* Submix, float SendLevel)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.SetSubmixSend");

	struct
	{
		class USoundSubmix*            Submix;
		float                          SendLevel;
	} params;

	params.Submix = Submix;
	params.SendLevel = SendLevel;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioComponent.SetSound
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class USoundBase*              NewSound                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAudioComponent::SetSound(class USoundBase* NewSound)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.SetSound");

	struct
	{
		class USoundBase*              NewSound;
	} params;

	params.NewSound = NewSound;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioComponent.SetPitchMultiplier
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewPitchMultiplier             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAudioComponent::SetPitchMultiplier(float NewPitchMultiplier)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.SetPitchMultiplier");

	struct
	{
		float                          NewPitchMultiplier;
	} params;

	params.NewPitchMultiplier = NewPitchMultiplier;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioComponent.SetPaused
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bPause                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAudioComponent::SetPaused(bool bPause)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.SetPaused");

	struct
	{
		bool                           bPause;
	} params;

	params.bPause = bPause;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioComponent.SetLowPassFilterFrequency
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InLowPassFilterFrequency       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAudioComponent::SetLowPassFilterFrequency(float InLowPassFilterFrequency)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.SetLowPassFilterFrequency");

	struct
	{
		float                          InLowPassFilterFrequency;
	} params;

	params.InLowPassFilterFrequency = InLowPassFilterFrequency;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioComponent.SetLowPassFilterEnabled
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           InLowPassFilterEnabled         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAudioComponent::SetLowPassFilterEnabled(bool InLowPassFilterEnabled)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.SetLowPassFilterEnabled");

	struct
	{
		bool                           InLowPassFilterEnabled;
	} params;

	params.InLowPassFilterEnabled = InLowPassFilterEnabled;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioComponent.SetIntParameter
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   InName                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            inInt                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAudioComponent::SetIntParameter(const struct FName& InName, int inInt)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.SetIntParameter");

	struct
	{
		struct FName                   InName;
		int                            inInt;
	} params;

	params.InName = InName;
	params.inInt = inInt;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioComponent.SetFloatParameter
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   InName                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InFloat                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAudioComponent::SetFloatParameter(const struct FName& InName, float InFloat)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.SetFloatParameter");

	struct
	{
		struct FName                   InName;
		float                          InFloat;
	} params;

	params.InName = InName;
	params.InFloat = InFloat;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioComponent.SetBoolParameter
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   InName                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           InBool                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAudioComponent::SetBoolParameter(const struct FName& InName, bool InBool)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.SetBoolParameter");

	struct
	{
		struct FName                   InName;
		bool                           InBool;
	} params;

	params.InName = InName;
	params.InBool = InBool;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioComponent.Play
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          StartTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAudioComponent::Play(float StartTime)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.Play");

	struct
	{
		float                          StartTime;
	} params;

	params.StartTime = StartTime;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioComponent.IsPlaying
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UAudioComponent::IsPlaying()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.IsPlaying");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AudioComponent.FadeOut
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          FadeOutDuration                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          FadeVolumeLevel                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAudioComponent::FadeOut(float FadeOutDuration, float FadeVolumeLevel)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.FadeOut");

	struct
	{
		float                          FadeOutDuration;
		float                          FadeVolumeLevel;
	} params;

	params.FadeOutDuration = FadeOutDuration;
	params.FadeVolumeLevel = FadeVolumeLevel;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioComponent.FadeIn
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          FadeInDuration                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          FadeVolumeLevel                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          StartTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAudioComponent::FadeIn(float FadeInDuration, float FadeVolumeLevel, float StartTime)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.FadeIn");

	struct
	{
		float                          FadeInDuration;
		float                          FadeVolumeLevel;
		float                          StartTime;
	} params;

	params.FadeInDuration = FadeInDuration;
	params.FadeVolumeLevel = FadeVolumeLevel;
	params.StartTime = StartTime;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioComponent.BP_GetAttenuationSettingsToApply
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// struct FSoundAttenuationSettings OutAttenuationSettings         (CPF_Parm, CPF_OutParm)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UAudioComponent::BP_GetAttenuationSettingsToApply(struct FSoundAttenuationSettings* OutAttenuationSettings)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.BP_GetAttenuationSettingsToApply");

	struct
	{
		struct FSoundAttenuationSettings OutAttenuationSettings;
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (OutAttenuationSettings != nullptr)
		*OutAttenuationSettings = params.OutAttenuationSettings;

	return params.ReturnValue;
}


// Function Engine.AudioComponent.AdjustVolume
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          AdjustVolumeDuration           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          AdjustVolumeLevel              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAudioComponent::AdjustVolume(float AdjustVolumeDuration, float AdjustVolumeLevel)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.AdjustVolume");

	struct
	{
		float                          AdjustVolumeDuration;
		float                          AdjustVolumeLevel;
	} params;

	params.AdjustVolumeDuration = AdjustVolumeDuration;
	params.AdjustVolumeLevel = AdjustVolumeLevel;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioComponent.AdjustAttenuation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// struct FSoundAttenuationSettings InAttenuationSettings          (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm)

void UAudioComponent::AdjustAttenuation(const struct FSoundAttenuationSettings& InAttenuationSettings)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioComponent.AdjustAttenuation");

	struct
	{
		struct FSoundAttenuationSettings InAttenuationSettings;
	} params;

	params.InAttenuationSettings = InAttenuationSettings;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SceneCapture2D.OnInterpToggle
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bEnable                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ASceneCapture2D::OnInterpToggle(bool bEnable)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SceneCapture2D.OnInterpToggle");

	struct
	{
		bool                           bEnable;
	} params;

	params.bEnable = bEnable;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.MaterialInterface.SetForceMipLevelsToBeResident
// (FUNC_RequiredAPI, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           OverrideForceMiplevelsToBeResident (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bForceMiplevelsToBeResidentValue (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ForceDuration                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            CinematicTextureGroups         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UMaterialInterface::SetForceMipLevelsToBeResident(bool OverrideForceMiplevelsToBeResident, bool bForceMiplevelsToBeResidentValue, float ForceDuration, int CinematicTextureGroups)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MaterialInterface.SetForceMipLevelsToBeResident");

	struct
	{
		bool                           OverrideForceMiplevelsToBeResident;
		bool                           bForceMiplevelsToBeResidentValue;
		float                          ForceDuration;
		int                            CinematicTextureGroups;
	} params;

	params.OverrideForceMiplevelsToBeResident = OverrideForceMiplevelsToBeResident;
	params.bForceMiplevelsToBeResidentValue = bForceMiplevelsToBeResidentValue;
	params.ForceDuration = ForceDuration;
	params.CinematicTextureGroups = CinematicTextureGroups;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.MaterialInterface.GetPhysicalMaterial
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UPhysicalMaterial*       ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UPhysicalMaterial* UMaterialInterface::GetPhysicalMaterial()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MaterialInterface.GetPhysicalMaterial");

	struct
	{
		class UPhysicalMaterial*       ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.MaterialInterface.GetBaseMaterial
// (FUNC_Final, FUNC_RequiredAPI, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UMaterial*               ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UMaterial* UMaterialInterface::GetBaseMaterial()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MaterialInterface.GetBaseMaterial");

	struct
	{
		class UMaterial*               ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.MaterialInstanceConstant.K2_GetVectorParameterValue
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   ParameterName                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FLinearColor            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FLinearColor UMaterialInstanceConstant::K2_GetVectorParameterValue(const struct FName& ParameterName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MaterialInstanceConstant.K2_GetVectorParameterValue");

	struct
	{
		struct FName                   ParameterName;
		struct FLinearColor            ReturnValue;
	} params;

	params.ParameterName = ParameterName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.MaterialInstanceConstant.K2_GetTextureParameterValue
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   ParameterName                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UTexture*                ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UTexture* UMaterialInstanceConstant::K2_GetTextureParameterValue(const struct FName& ParameterName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MaterialInstanceConstant.K2_GetTextureParameterValue");

	struct
	{
		struct FName                   ParameterName;
		class UTexture*                ReturnValue;
	} params;

	params.ParameterName = ParameterName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.MaterialInstanceConstant.K2_GetScalarParameterValue
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   ParameterName                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UMaterialInstanceConstant::K2_GetScalarParameterValue(const struct FName& ParameterName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.MaterialInstanceConstant.K2_GetScalarParameterValue");

	struct
	{
		struct FName                   ParameterName;
		float                          ReturnValue;
	} params;

	params.ParameterName = ParameterName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.BlueprintAsyncActionBase.Activate
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UBlueprintAsyncActionBase::Activate()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintAsyncActionBase.Activate");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AmbientSound.Stop
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AAmbientSound::Stop()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AmbientSound.Stop");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AmbientSound.Play
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          StartTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AAmbientSound::Play(float StartTime)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AmbientSound.Play");

	struct
	{
		float                          StartTime;
	} params;

	params.StartTime = StartTime;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AmbientSound.FadeOut
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          FadeOutDuration                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          FadeVolumeLevel                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AAmbientSound::FadeOut(float FadeOutDuration, float FadeVolumeLevel)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AmbientSound.FadeOut");

	struct
	{
		float                          FadeOutDuration;
		float                          FadeVolumeLevel;
	} params;

	params.FadeOutDuration = FadeOutDuration;
	params.FadeVolumeLevel = FadeVolumeLevel;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AmbientSound.FadeIn
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          FadeInDuration                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          FadeVolumeLevel                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AAmbientSound::FadeIn(float FadeInDuration, float FadeVolumeLevel)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AmbientSound.FadeIn");

	struct
	{
		float                          FadeInDuration;
		float                          FadeVolumeLevel;
	} params;

	params.FadeInDuration = FadeInDuration;
	params.FadeVolumeLevel = FadeVolumeLevel;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AmbientSound.AdjustVolume
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          AdjustVolumeDuration           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          AdjustVolumeLevel              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AAmbientSound::AdjustVolume(float AdjustVolumeDuration, float AdjustVolumeLevel)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AmbientSound.AdjustVolume");

	struct
	{
		float                          AdjustVolumeDuration;
		float                          AdjustVolumeLevel;
	} params;

	params.AdjustVolumeDuration = AdjustVolumeDuration;
	params.AdjustVolumeLevel = AdjustVolumeLevel;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimSequenceBase.GetPlayLength
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimSequenceBase::GetPlayLength()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimSequenceBase.GetPlayLength");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimNotifyState_Trail.OverridePSTemplate
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent, FUNC_Const)
// Parameters:
// class USkeletalMeshComponent*  MeshComp                       (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// class UAnimSequenceBase*       Animation                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UParticleSystem*         ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UParticleSystem* UAnimNotifyState_Trail::OverridePSTemplate(class USkeletalMeshComponent* MeshComp, class UAnimSequenceBase* Animation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimNotifyState_Trail.OverridePSTemplate");

	struct
	{
		class USkeletalMeshComponent*  MeshComp;
		class UAnimSequenceBase*       Animation;
		class UParticleSystem*         ReturnValue;
	} params;

	params.MeshComp = MeshComp;
	params.Animation = Animation;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimSingleNodeInstance.StopAnim
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UAnimSingleNodeInstance::StopAnim()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimSingleNodeInstance.StopAnim");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimSingleNodeInstance.SetReverse
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bInReverse                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimSingleNodeInstance::SetReverse(bool bInReverse)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimSingleNodeInstance.SetReverse");

	struct
	{
		bool                           bInReverse;
	} params;

	params.bInReverse = bInReverse;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimSingleNodeInstance.SetPreviewCurveOverride
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   PoseName                       (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm, CPF_IsPlainOldData)
// float                          Value                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bRemoveIfZero                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimSingleNodeInstance::SetPreviewCurveOverride(const struct FName& PoseName, float Value, bool bRemoveIfZero)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimSingleNodeInstance.SetPreviewCurveOverride");

	struct
	{
		struct FName                   PoseName;
		float                          Value;
		bool                           bRemoveIfZero;
	} params;

	params.PoseName = PoseName;
	params.Value = Value;
	params.bRemoveIfZero = bRemoveIfZero;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimSingleNodeInstance.SetPositionWithPreviousTime
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InPosition                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InPreviousTime                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bFireNotifies                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimSingleNodeInstance::SetPositionWithPreviousTime(float InPosition, float InPreviousTime, bool bFireNotifies)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimSingleNodeInstance.SetPositionWithPreviousTime");

	struct
	{
		float                          InPosition;
		float                          InPreviousTime;
		bool                           bFireNotifies;
	} params;

	params.InPosition = InPosition;
	params.InPreviousTime = InPreviousTime;
	params.bFireNotifies = bFireNotifies;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimSingleNodeInstance.SetPosition
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InPosition                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bFireNotifies                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimSingleNodeInstance::SetPosition(float InPosition, bool bFireNotifies)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimSingleNodeInstance.SetPosition");

	struct
	{
		float                          InPosition;
		bool                           bFireNotifies;
	} params;

	params.InPosition = InPosition;
	params.bFireNotifies = bFireNotifies;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimSingleNodeInstance.SetPlayRate
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InPlayRate                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimSingleNodeInstance::SetPlayRate(float InPlayRate)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimSingleNodeInstance.SetPlayRate");

	struct
	{
		float                          InPlayRate;
	} params;

	params.InPlayRate = InPlayRate;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimSingleNodeInstance.SetPlaying
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bIsPlaying                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimSingleNodeInstance::SetPlaying(bool bIsPlaying)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimSingleNodeInstance.SetPlaying");

	struct
	{
		bool                           bIsPlaying;
	} params;

	params.bIsPlaying = bIsPlaying;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimSingleNodeInstance.SetLooping
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bIsLooping                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimSingleNodeInstance::SetLooping(bool bIsLooping)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimSingleNodeInstance.SetLooping");

	struct
	{
		bool                           bIsLooping;
	} params;

	params.bIsLooping = bIsLooping;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimSingleNodeInstance.SetBlendSpaceInput
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 InBlendInput                   (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)

void UAnimSingleNodeInstance::SetBlendSpaceInput(const struct FVector& InBlendInput)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimSingleNodeInstance.SetBlendSpaceInput");

	struct
	{
		struct FVector                 InBlendInput;
	} params;

	params.InBlendInput = InBlendInput;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimSingleNodeInstance.SetAnimationAsset
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UAnimationAsset*         NewAsset                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bIsLooping                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InPlayRate                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimSingleNodeInstance::SetAnimationAsset(class UAnimationAsset* NewAsset, bool bIsLooping, float InPlayRate)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimSingleNodeInstance.SetAnimationAsset");

	struct
	{
		class UAnimationAsset*         NewAsset;
		bool                           bIsLooping;
		float                          InPlayRate;
	} params;

	params.NewAsset = NewAsset;
	params.bIsLooping = bIsLooping;
	params.InPlayRate = InPlayRate;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimSingleNodeInstance.PlayAnim
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bIsLooping                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InPlayRate                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InStartPosition                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAnimSingleNodeInstance::PlayAnim(bool bIsLooping, float InPlayRate, float InStartPosition)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimSingleNodeInstance.PlayAnim");

	struct
	{
		bool                           bIsLooping;
		float                          InPlayRate;
		float                          InStartPosition;
	} params;

	params.bIsLooping = bIsLooping;
	params.InPlayRate = InPlayRate;
	params.InStartPosition = InStartPosition;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AnimSingleNodeInstance.GetLength
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UAnimSingleNodeInstance::GetLength()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimSingleNodeInstance.GetLength");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AnimSingleNodeInstance.GetAnimationAsset
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UAnimationAsset*         ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UAnimationAsset* UAnimSingleNodeInstance::GetAnimationAsset()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AnimSingleNodeInstance.GetAnimationAsset");

	struct
	{
		class UAnimationAsset*         ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.ArrowComponent.SetArrowColor
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FLinearColor            NewColor                       (CPF_Parm, CPF_IsPlainOldData)

void UArrowComponent::SetArrowColor(const struct FLinearColor& NewColor)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ArrowComponent.SetArrowColor");

	struct
	{
		struct FLinearColor            NewColor;
	} params;

	params.NewColor = NewColor;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AsyncActionLoadPrimaryAsset.AsyncLoadPrimaryAsset
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FPrimaryAssetId         PrimaryAsset                   (CPF_Parm)
// TArray<struct FName>           LoadBundles                    (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// class UAsyncActionLoadPrimaryAsset* ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UAsyncActionLoadPrimaryAsset* UAsyncActionLoadPrimaryAsset::AsyncLoadPrimaryAsset(const struct FPrimaryAssetId& PrimaryAsset, TArray<struct FName> LoadBundles)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AsyncActionLoadPrimaryAsset.AsyncLoadPrimaryAsset");

	struct
	{
		struct FPrimaryAssetId         PrimaryAsset;
		TArray<struct FName>           LoadBundles;
		class UAsyncActionLoadPrimaryAsset* ReturnValue;
	} params;

	params.PrimaryAsset = PrimaryAsset;
	params.LoadBundles = LoadBundles;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AsyncActionLoadPrimaryAssetClass.AsyncLoadPrimaryAssetClass
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FPrimaryAssetId         PrimaryAsset                   (CPF_Parm)
// TArray<struct FName>           LoadBundles                    (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// class UAsyncActionLoadPrimaryAssetClass* ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UAsyncActionLoadPrimaryAssetClass* UAsyncActionLoadPrimaryAssetClass::AsyncLoadPrimaryAssetClass(const struct FPrimaryAssetId& PrimaryAsset, TArray<struct FName> LoadBundles)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AsyncActionLoadPrimaryAssetClass.AsyncLoadPrimaryAssetClass");

	struct
	{
		struct FPrimaryAssetId         PrimaryAsset;
		TArray<struct FName>           LoadBundles;
		class UAsyncActionLoadPrimaryAssetClass* ReturnValue;
	} params;

	params.PrimaryAsset = PrimaryAsset;
	params.LoadBundles = LoadBundles;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AsyncActionLoadPrimaryAssetList.AsyncLoadPrimaryAssetList
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// TArray<struct FPrimaryAssetId> PrimaryAssetList               (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// TArray<struct FName>           LoadBundles                    (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// class UAsyncActionLoadPrimaryAssetList* ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UAsyncActionLoadPrimaryAssetList* UAsyncActionLoadPrimaryAssetList::AsyncLoadPrimaryAssetList(TArray<struct FPrimaryAssetId> PrimaryAssetList, TArray<struct FName> LoadBundles)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AsyncActionLoadPrimaryAssetList.AsyncLoadPrimaryAssetList");

	struct
	{
		TArray<struct FPrimaryAssetId> PrimaryAssetList;
		TArray<struct FName>           LoadBundles;
		class UAsyncActionLoadPrimaryAssetList* ReturnValue;
	} params;

	params.PrimaryAssetList = PrimaryAssetList;
	params.LoadBundles = LoadBundles;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AsyncActionLoadPrimaryAssetClassList.AsyncLoadPrimaryAssetClassList
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// TArray<struct FPrimaryAssetId> PrimaryAssetList               (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// TArray<struct FName>           LoadBundles                    (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// class UAsyncActionLoadPrimaryAssetClassList* ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UAsyncActionLoadPrimaryAssetClassList* UAsyncActionLoadPrimaryAssetClassList::AsyncLoadPrimaryAssetClassList(TArray<struct FPrimaryAssetId> PrimaryAssetList, TArray<struct FName> LoadBundles)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AsyncActionLoadPrimaryAssetClassList.AsyncLoadPrimaryAssetClassList");

	struct
	{
		TArray<struct FPrimaryAssetId> PrimaryAssetList;
		TArray<struct FName>           LoadBundles;
		class UAsyncActionLoadPrimaryAssetClassList* ReturnValue;
	} params;

	params.PrimaryAssetList = PrimaryAssetList;
	params.LoadBundles = LoadBundles;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AsyncActionChangePrimaryAssetBundles.AsyncChangeBundleStateForPrimaryAssetList
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// TArray<struct FPrimaryAssetId> PrimaryAssetList               (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// TArray<struct FName>           AddBundles                     (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// TArray<struct FName>           RemoveBundles                  (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// class UAsyncActionChangePrimaryAssetBundles* ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UAsyncActionChangePrimaryAssetBundles* UAsyncActionChangePrimaryAssetBundles::AsyncChangeBundleStateForPrimaryAssetList(TArray<struct FPrimaryAssetId> PrimaryAssetList, TArray<struct FName> AddBundles, TArray<struct FName> RemoveBundles)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AsyncActionChangePrimaryAssetBundles.AsyncChangeBundleStateForPrimaryAssetList");

	struct
	{
		TArray<struct FPrimaryAssetId> PrimaryAssetList;
		TArray<struct FName>           AddBundles;
		TArray<struct FName>           RemoveBundles;
		class UAsyncActionChangePrimaryAssetBundles* ReturnValue;
	} params;

	params.PrimaryAssetList = PrimaryAssetList;
	params.AddBundles = AddBundles;
	params.RemoveBundles = RemoveBundles;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AsyncActionChangePrimaryAssetBundles.AsyncChangeBundleStateForMatchingPrimaryAssets
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// TArray<struct FName>           NewBundles                     (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// TArray<struct FName>           OldBundles                     (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// class UAsyncActionChangePrimaryAssetBundles* ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UAsyncActionChangePrimaryAssetBundles* UAsyncActionChangePrimaryAssetBundles::AsyncChangeBundleStateForMatchingPrimaryAssets(TArray<struct FName> NewBundles, TArray<struct FName> OldBundles)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AsyncActionChangePrimaryAssetBundles.AsyncChangeBundleStateForMatchingPrimaryAssets");

	struct
	{
		TArray<struct FName>           NewBundles;
		TArray<struct FName>           OldBundles;
		class UAsyncActionChangePrimaryAssetBundles* ReturnValue;
	} params;

	params.NewBundles = NewBundles;
	params.OldBundles = OldBundles;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AtmosphericFogComponent.StartPrecompute
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UAtmosphericFogComponent::StartPrecompute()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AtmosphericFogComponent.StartPrecompute");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AtmosphericFogComponent.SetSunMultiplier
// (FUNC_Final, FUNC_RequiredAPI, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewSunMultiplier               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAtmosphericFogComponent::SetSunMultiplier(float NewSunMultiplier)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AtmosphericFogComponent.SetSunMultiplier");

	struct
	{
		float                          NewSunMultiplier;
	} params;

	params.NewSunMultiplier = NewSunMultiplier;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AtmosphericFogComponent.SetStartDistance
// (FUNC_Final, FUNC_RequiredAPI, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewStartDistance               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAtmosphericFogComponent::SetStartDistance(float NewStartDistance)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AtmosphericFogComponent.SetStartDistance");

	struct
	{
		float                          NewStartDistance;
	} params;

	params.NewStartDistance = NewStartDistance;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AtmosphericFogComponent.SetPrecomputeParams
// (FUNC_Final, FUNC_RequiredAPI, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          DensityHeight                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            MaxScatteringOrder             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            InscatterAltitudeSampleNum     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAtmosphericFogComponent::SetPrecomputeParams(float DensityHeight, int MaxScatteringOrder, int InscatterAltitudeSampleNum)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AtmosphericFogComponent.SetPrecomputeParams");

	struct
	{
		float                          DensityHeight;
		int                            MaxScatteringOrder;
		int                            InscatterAltitudeSampleNum;
	} params;

	params.DensityHeight = DensityHeight;
	params.MaxScatteringOrder = MaxScatteringOrder;
	params.InscatterAltitudeSampleNum = InscatterAltitudeSampleNum;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AtmosphericFogComponent.SetFogMultiplier
// (FUNC_Final, FUNC_RequiredAPI, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewFogMultiplier               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAtmosphericFogComponent::SetFogMultiplier(float NewFogMultiplier)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AtmosphericFogComponent.SetFogMultiplier");

	struct
	{
		float                          NewFogMultiplier;
	} params;

	params.NewFogMultiplier = NewFogMultiplier;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AtmosphericFogComponent.SetDistanceScale
// (FUNC_Final, FUNC_RequiredAPI, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewDistanceScale               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAtmosphericFogComponent::SetDistanceScale(float NewDistanceScale)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AtmosphericFogComponent.SetDistanceScale");

	struct
	{
		float                          NewDistanceScale;
	} params;

	params.NewDistanceScale = NewDistanceScale;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AtmosphericFogComponent.SetDistanceOffset
// (FUNC_Final, FUNC_RequiredAPI, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewDistanceOffset              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAtmosphericFogComponent::SetDistanceOffset(float NewDistanceOffset)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AtmosphericFogComponent.SetDistanceOffset");

	struct
	{
		float                          NewDistanceOffset;
	} params;

	params.NewDistanceOffset = NewDistanceOffset;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AtmosphericFogComponent.SetDensityOffset
// (FUNC_Final, FUNC_RequiredAPI, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewDensityOffset               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAtmosphericFogComponent::SetDensityOffset(float NewDensityOffset)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AtmosphericFogComponent.SetDensityOffset");

	struct
	{
		float                          NewDensityOffset;
	} params;

	params.NewDensityOffset = NewDensityOffset;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AtmosphericFogComponent.SetDensityMultiplier
// (FUNC_Final, FUNC_RequiredAPI, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewDensityMultiplier           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAtmosphericFogComponent::SetDensityMultiplier(float NewDensityMultiplier)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AtmosphericFogComponent.SetDensityMultiplier");

	struct
	{
		float                          NewDensityMultiplier;
	} params;

	params.NewDensityMultiplier = NewDensityMultiplier;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AtmosphericFogComponent.SetDefaultLightColor
// (FUNC_Final, FUNC_RequiredAPI, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FLinearColor            NewLightColor                  (CPF_Parm, CPF_IsPlainOldData)

void UAtmosphericFogComponent::SetDefaultLightColor(const struct FLinearColor& NewLightColor)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AtmosphericFogComponent.SetDefaultLightColor");

	struct
	{
		struct FLinearColor            NewLightColor;
	} params;

	params.NewLightColor = NewLightColor;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AtmosphericFogComponent.SetDefaultBrightness
// (FUNC_Final, FUNC_RequiredAPI, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewBrightness                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAtmosphericFogComponent::SetDefaultBrightness(float NewBrightness)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AtmosphericFogComponent.SetDefaultBrightness");

	struct
	{
		float                          NewBrightness;
	} params;

	params.NewBrightness = NewBrightness;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AtmosphericFogComponent.SetAltitudeScale
// (FUNC_Final, FUNC_RequiredAPI, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewAltitudeScale               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAtmosphericFogComponent::SetAltitudeScale(float NewAltitudeScale)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AtmosphericFogComponent.SetAltitudeScale");

	struct
	{
		float                          NewAltitudeScale;
	} params;

	params.NewAltitudeScale = NewAltitudeScale;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AtmosphericFogComponent.DisableSunDisk
// (FUNC_Final, FUNC_RequiredAPI, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           NewSunDisk                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAtmosphericFogComponent::DisableSunDisk(bool NewSunDisk)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AtmosphericFogComponent.DisableSunDisk");

	struct
	{
		bool                           NewSunDisk;
	} params;

	params.NewSunDisk = NewSunDisk;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AtmosphericFogComponent.DisableGroundScattering
// (FUNC_Final, FUNC_RequiredAPI, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           NewGroundScattering            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UAtmosphericFogComponent::DisableGroundScattering(bool NewGroundScattering)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AtmosphericFogComponent.DisableGroundScattering");

	struct
	{
		bool                           NewGroundScattering;
	} params;

	params.NewGroundScattering = NewGroundScattering;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioVolume.SetReverbSettings
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// struct FReverbSettings         NewReverbSettings              (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm)

void AAudioVolume::SetReverbSettings(const struct FReverbSettings& NewReverbSettings)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioVolume.SetReverbSettings");

	struct
	{
		struct FReverbSettings         NewReverbSettings;
	} params;

	params.NewReverbSettings = NewReverbSettings;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioVolume.SetPriority
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewPriority                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AAudioVolume::SetPriority(float NewPriority)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioVolume.SetPriority");

	struct
	{
		float                          NewPriority;
	} params;

	params.NewPriority = NewPriority;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioVolume.SetInteriorSettings
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// struct FInteriorSettings       NewInteriorSettings            (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm)

void AAudioVolume::SetInteriorSettings(const struct FInteriorSettings& NewInteriorSettings)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioVolume.SetInteriorSettings");

	struct
	{
		struct FInteriorSettings       NewInteriorSettings;
	} params;

	params.NewInteriorSettings = NewInteriorSettings;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioVolume.SetEnabled
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewEnabled                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AAudioVolume::SetEnabled(bool bNewEnabled)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioVolume.SetEnabled");

	struct
	{
		bool                           bNewEnabled;
	} params;

	params.bNewEnabled = bNewEnabled;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AudioVolume.OnRep_bEnabled
// (FUNC_Final, FUNC_Native, FUNC_Private)

void AAudioVolume::OnRep_bEnabled()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AudioVolume.OnRep_bEnabled");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.AvoidanceManager.RegisterMovementComponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UMovementComponent*      MovementComp                   (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// float                          AvoidanceWeight                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UAvoidanceManager::RegisterMovementComponent(class UMovementComponent* MovementComp, float AvoidanceWeight)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AvoidanceManager.RegisterMovementComponent");

	struct
	{
		class UMovementComponent*      MovementComp;
		float                          AvoidanceWeight;
		bool                           ReturnValue;
	} params;

	params.MovementComp = MovementComp;
	params.AvoidanceWeight = AvoidanceWeight;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AvoidanceManager.GetObjectCount
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

int UAvoidanceManager::GetObjectCount()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AvoidanceManager.GetObjectCount");

	struct
	{
		int                            ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AvoidanceManager.GetNewAvoidanceUID
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

int UAvoidanceManager::GetNewAvoidanceUID()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AvoidanceManager.GetNewAvoidanceUID");

	struct
	{
		int                            ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.AvoidanceManager.GetAvoidanceVelocityForComponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UMovementComponent*      MovementComp                   (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UAvoidanceManager::GetAvoidanceVelocityForComponent(class UMovementComponent* MovementComp)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.AvoidanceManager.GetAvoidanceVelocityForComponent");

	struct
	{
		class UMovementComponent*      MovementComp;
		struct FVector                 ReturnValue;
	} params;

	params.MovementComp = MovementComp;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.BillboardComponent.SetUV
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            NewU                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            NewUL                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            NewV                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            NewVL                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UBillboardComponent::SetUV(int NewU, int NewUL, int NewV, int NewVL)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BillboardComponent.SetUV");

	struct
	{
		int                            NewU;
		int                            NewUL;
		int                            NewV;
		int                            NewVL;
	} params;

	params.NewU = NewU;
	params.NewUL = NewUL;
	params.NewV = NewV;
	params.NewVL = NewVL;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.BillboardComponent.SetSpriteAndUV
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UTexture2D*              NewSprite                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            NewU                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            NewUL                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            NewV                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            NewVL                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UBillboardComponent::SetSpriteAndUV(class UTexture2D* NewSprite, int NewU, int NewUL, int NewV, int NewVL)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BillboardComponent.SetSpriteAndUV");

	struct
	{
		class UTexture2D*              NewSprite;
		int                            NewU;
		int                            NewUL;
		int                            NewV;
		int                            NewVL;
	} params;

	params.NewSprite = NewSprite;
	params.NewU = NewU;
	params.NewUL = NewUL;
	params.NewV = NewV;
	params.NewVL = NewVL;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.BillboardComponent.SetSprite
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UTexture2D*              NewSprite                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UBillboardComponent::SetSprite(class UTexture2D* NewSprite)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BillboardComponent.SetSprite");

	struct
	{
		class UTexture2D*              NewSprite;
	} params;

	params.NewSprite = NewSprite;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.BlueprintMapLibrary.SetMapPropertyByName
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// class UObject*                 Object                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   PropertyName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TMap<int, int>                 Value                          (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)

void UBlueprintMapLibrary::SetMapPropertyByName(class UObject* Object, const struct FName& PropertyName, TMap<int, int> Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintMapLibrary.SetMapPropertyByName");

	struct
	{
		class UObject*                 Object;
		struct FName                   PropertyName;
		TMap<int, int>                 Value;
	} params;

	params.Object = Object;
	params.PropertyName = PropertyName;
	params.Value = Value;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);
}


// Function Engine.BlueprintMapLibrary.Map_Values
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// TMap<int, int>                 TargetMap                      (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// TArray<int>                    Values                         (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor)

void UBlueprintMapLibrary::Map_Values(TMap<int, int> TargetMap, TArray<int>* Values)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintMapLibrary.Map_Values");

	struct
	{
		TMap<int, int>                 TargetMap;
		TArray<int>                    Values;
	} params;

	params.TargetMap = TargetMap;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	if (Values != nullptr)
		*Values = params.Values;
}


// Function Engine.BlueprintMapLibrary.Map_Remove
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// TMap<int, int>                 TargetMap                      (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// int                            Key                            (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UBlueprintMapLibrary::Map_Remove(TMap<int, int> TargetMap, int Key)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintMapLibrary.Map_Remove");

	struct
	{
		TMap<int, int>                 TargetMap;
		int                            Key;
		bool                           ReturnValue;
	} params;

	params.TargetMap = TargetMap;
	params.Key = Key;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.BlueprintMapLibrary.Map_Length
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// TMap<int, int>                 TargetMap                      (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// int                            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

int UBlueprintMapLibrary::Map_Length(TMap<int, int> TargetMap)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintMapLibrary.Map_Length");

	struct
	{
		TMap<int, int>                 TargetMap;
		int                            ReturnValue;
	} params;

	params.TargetMap = TargetMap;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.BlueprintMapLibrary.Map_Keys
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// TMap<int, int>                 TargetMap                      (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// TArray<int>                    Keys                           (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor)

void UBlueprintMapLibrary::Map_Keys(TMap<int, int> TargetMap, TArray<int>* Keys)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintMapLibrary.Map_Keys");

	struct
	{
		TMap<int, int>                 TargetMap;
		TArray<int>                    Keys;
	} params;

	params.TargetMap = TargetMap;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	if (Keys != nullptr)
		*Keys = params.Keys;
}


// Function Engine.BlueprintMapLibrary.Map_Find
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// TMap<int, int>                 TargetMap                      (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// int                            Key                            (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm, CPF_IsPlainOldData)
// int                            Value                          (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UBlueprintMapLibrary::Map_Find(TMap<int, int> TargetMap, int Key, int* Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintMapLibrary.Map_Find");

	struct
	{
		TMap<int, int>                 TargetMap;
		int                            Key;
		int                            Value;
		bool                           ReturnValue;
	} params;

	params.TargetMap = TargetMap;
	params.Key = Key;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	if (Value != nullptr)
		*Value = params.Value;

	return params.ReturnValue;
}


// Function Engine.BlueprintMapLibrary.Map_Contains
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// TMap<int, int>                 TargetMap                      (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// int                            Key                            (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UBlueprintMapLibrary::Map_Contains(TMap<int, int> TargetMap, int Key)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintMapLibrary.Map_Contains");

	struct
	{
		TMap<int, int>                 TargetMap;
		int                            Key;
		bool                           ReturnValue;
	} params;

	params.TargetMap = TargetMap;
	params.Key = Key;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.BlueprintMapLibrary.Map_Clear
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// TMap<int, int>                 TargetMap                      (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)

void UBlueprintMapLibrary::Map_Clear(TMap<int, int> TargetMap)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintMapLibrary.Map_Clear");

	struct
	{
		TMap<int, int>                 TargetMap;
	} params;

	params.TargetMap = TargetMap;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);
}


// Function Engine.BlueprintMapLibrary.Map_Add
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// TMap<int, int>                 TargetMap                      (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)
// int                            Key                            (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm, CPF_IsPlainOldData)
// int                            Value                          (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm, CPF_IsPlainOldData)

void UBlueprintMapLibrary::Map_Add(TMap<int, int> TargetMap, int Key, int Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintMapLibrary.Map_Add");

	struct
	{
		TMap<int, int>                 TargetMap;
		int                            Key;
		int                            Value;
	} params;

	params.TargetMap = TargetMap;
	params.Key = Key;
	params.Value = Value;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);
}


// Function Engine.BlueprintPlatformLibrary.ScheduleLocalNotificationFromNow
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// int                            inSecondsFromNow               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FText                   Title                          (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm)
// struct FText                   Body                           (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm)
// struct FText                   action                         (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm)
// struct FString                 ActivationEvent                (CPF_Parm, CPF_ZeroConstructor)

void UBlueprintPlatformLibrary::ScheduleLocalNotificationFromNow(int inSecondsFromNow, const struct FText& Title, const struct FText& Body, const struct FText& action, const struct FString& ActivationEvent)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintPlatformLibrary.ScheduleLocalNotificationFromNow");

	struct
	{
		int                            inSecondsFromNow;
		struct FText                   Title;
		struct FText                   Body;
		struct FText                   action;
		struct FString                 ActivationEvent;
	} params;

	params.inSecondsFromNow = inSecondsFromNow;
	params.Title = Title;
	params.Body = Body;
	params.action = action;
	params.ActivationEvent = ActivationEvent;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);
}


// Function Engine.BlueprintPlatformLibrary.ScheduleLocalNotificationBadgeFromNow
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            inSecondsFromNow               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FString                 ActivationEvent                (CPF_Parm, CPF_ZeroConstructor)

void UBlueprintPlatformLibrary::ScheduleLocalNotificationBadgeFromNow(int inSecondsFromNow, const struct FString& ActivationEvent)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintPlatformLibrary.ScheduleLocalNotificationBadgeFromNow");

	struct
	{
		int                            inSecondsFromNow;
		struct FString                 ActivationEvent;
	} params;

	params.inSecondsFromNow = inSecondsFromNow;
	params.ActivationEvent = ActivationEvent;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);
}


// Function Engine.BlueprintPlatformLibrary.ScheduleLocalNotificationBadgeAtTime
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FDateTime               FireDateTime                   (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm)
// bool                           LocalTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FString                 ActivationEvent                (CPF_Parm, CPF_ZeroConstructor)

void UBlueprintPlatformLibrary::ScheduleLocalNotificationBadgeAtTime(const struct FDateTime& FireDateTime, bool LocalTime, const struct FString& ActivationEvent)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintPlatformLibrary.ScheduleLocalNotificationBadgeAtTime");

	struct
	{
		struct FDateTime               FireDateTime;
		bool                           LocalTime;
		struct FString                 ActivationEvent;
	} params;

	params.FireDateTime = FireDateTime;
	params.LocalTime = LocalTime;
	params.ActivationEvent = ActivationEvent;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);
}


// Function Engine.BlueprintPlatformLibrary.ScheduleLocalNotificationAtTime
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FDateTime               FireDateTime                   (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm)
// bool                           LocalTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FText                   Title                          (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm)
// struct FText                   Body                           (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm)
// struct FText                   action                         (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm)
// struct FString                 ActivationEvent                (CPF_Parm, CPF_ZeroConstructor)

void UBlueprintPlatformLibrary::ScheduleLocalNotificationAtTime(const struct FDateTime& FireDateTime, bool LocalTime, const struct FText& Title, const struct FText& Body, const struct FText& action, const struct FString& ActivationEvent)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintPlatformLibrary.ScheduleLocalNotificationAtTime");

	struct
	{
		struct FDateTime               FireDateTime;
		bool                           LocalTime;
		struct FText                   Title;
		struct FText                   Body;
		struct FText                   action;
		struct FString                 ActivationEvent;
	} params;

	params.FireDateTime = FireDateTime;
	params.LocalTime = LocalTime;
	params.Title = Title;
	params.Body = Body;
	params.action = action;
	params.ActivationEvent = ActivationEvent;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);
}


// Function Engine.BlueprintPlatformLibrary.GetLaunchNotification
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// bool                           NotificationLaunchedApp        (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FString                 ActivationEvent                (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor)
// int                            FireDate                       (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UBlueprintPlatformLibrary::GetLaunchNotification(bool* NotificationLaunchedApp, struct FString* ActivationEvent, int* FireDate)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintPlatformLibrary.GetLaunchNotification");

	struct
	{
		bool                           NotificationLaunchedApp;
		struct FString                 ActivationEvent;
		int                            FireDate;
	} params;


	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	if (NotificationLaunchedApp != nullptr)
		*NotificationLaunchedApp = params.NotificationLaunchedApp;
	if (ActivationEvent != nullptr)
		*ActivationEvent = params.ActivationEvent;
	if (FireDate != nullptr)
		*FireDate = params.FireDate;
}


// Function Engine.BlueprintPlatformLibrary.ClearAllLocalNotifications
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_BlueprintCallable)

void UBlueprintPlatformLibrary::ClearAllLocalNotifications()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintPlatformLibrary.ClearAllLocalNotifications");

	struct
	{
	} params;


	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);
}


// Function Engine.BlueprintPlatformLibrary.CancelLocalNotification
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FString                 ActivationEvent                (CPF_Parm, CPF_ZeroConstructor)

void UBlueprintPlatformLibrary::CancelLocalNotification(const struct FString& ActivationEvent)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintPlatformLibrary.CancelLocalNotification");

	struct
	{
		struct FString                 ActivationEvent;
	} params;

	params.ActivationEvent = ActivationEvent;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);
}


// Function Engine.BlueprintSetLibrary.SetSetPropertyByName
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// class UObject*                 Object                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   PropertyName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UBlueprintSetLibrary::SetSetPropertyByName(class UObject* Object, const struct FName& PropertyName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintSetLibrary.SetSetPropertyByName");

	struct
	{
		class UObject*                 Object;
		struct FName                   PropertyName;
	} params;

	params.Object = Object;
	params.PropertyName = PropertyName;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);
}


// Function Engine.BlueprintSetLibrary.Set_Union
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)

void UBlueprintSetLibrary::Set_Union()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintSetLibrary.Set_Union");

	struct
	{
	} params;


	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);
}


// Function Engine.BlueprintSetLibrary.Set_ToArray
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// TArray<int>                    Result                         (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor)

void UBlueprintSetLibrary::Set_ToArray(TArray<int>* Result)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintSetLibrary.Set_ToArray");

	struct
	{
		TArray<int>                    Result;
	} params;


	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	if (Result != nullptr)
		*Result = params.Result;
}


// Function Engine.BlueprintSetLibrary.Set_RemoveItems
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// TArray<int>                    Items                          (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)

void UBlueprintSetLibrary::Set_RemoveItems(TArray<int> Items)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintSetLibrary.Set_RemoveItems");

	struct
	{
		TArray<int>                    Items;
	} params;

	params.Items = Items;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);
}


// Function Engine.BlueprintSetLibrary.Set_Remove
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// int                            Item                           (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UBlueprintSetLibrary::Set_Remove(int Item)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintSetLibrary.Set_Remove");

	struct
	{
		int                            Item;
		bool                           ReturnValue;
	} params;

	params.Item = Item;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.BlueprintSetLibrary.Set_Length
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

int UBlueprintSetLibrary::Set_Length()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintSetLibrary.Set_Length");

	struct
	{
		int                            ReturnValue;
	} params;


	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.BlueprintSetLibrary.Set_Intersection
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)

void UBlueprintSetLibrary::Set_Intersection()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintSetLibrary.Set_Intersection");

	struct
	{
	} params;


	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);
}


// Function Engine.BlueprintSetLibrary.Set_Difference
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)

void UBlueprintSetLibrary::Set_Difference()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintSetLibrary.Set_Difference");

	struct
	{
	} params;


	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);
}


// Function Engine.BlueprintSetLibrary.Set_Contains
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            ItemToFind                     (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UBlueprintSetLibrary::Set_Contains(int ItemToFind)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintSetLibrary.Set_Contains");

	struct
	{
		int                            ItemToFind;
		bool                           ReturnValue;
	} params;

	params.ItemToFind = ItemToFind;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.BlueprintSetLibrary.Set_Clear
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)

void UBlueprintSetLibrary::Set_Clear()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintSetLibrary.Set_Clear");

	struct
	{
	} params;


	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);
}


// Function Engine.BlueprintSetLibrary.Set_AddItems
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// TArray<int>                    NewItems                       (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm)

void UBlueprintSetLibrary::Set_AddItems(TArray<int> NewItems)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintSetLibrary.Set_AddItems");

	struct
	{
		TArray<int>                    NewItems;
	} params;

	params.NewItems = NewItems;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);
}


// Function Engine.BlueprintSetLibrary.Set_Add
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// int                            NewItem                        (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReferenceParm, CPF_IsPlainOldData)

void UBlueprintSetLibrary::Set_Add(int NewItem)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BlueprintSetLibrary.Set_Add");

	struct
	{
		int                            NewItem;
	} params;

	params.NewItem = NewItem;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);
}


// Function Engine.BoxComponent.SetBoxExtent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 InBoxExtent                    (CPF_Parm, CPF_IsPlainOldData)
// bool                           bUpdateOverlaps                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UBoxComponent::SetBoxExtent(const struct FVector& InBoxExtent, bool bUpdateOverlaps)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BoxComponent.SetBoxExtent");

	struct
	{
		struct FVector                 InBoxExtent;
		bool                           bUpdateOverlaps;
	} params;

	params.InBoxExtent = InBoxExtent;
	params.bUpdateOverlaps = bUpdateOverlaps;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.BoxComponent.GetUnscaledBoxExtent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UBoxComponent::GetUnscaledBoxExtent()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BoxComponent.GetUnscaledBoxExtent");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.BoxComponent.GetScaledBoxExtent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UBoxComponent::GetScaledBoxExtent()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.BoxComponent.GetScaledBoxExtent");

	struct
	{
		struct FVector                 ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CameraAnimInst.Stop
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bImmediate                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCameraAnimInst::Stop(bool bImmediate)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraAnimInst.Stop");

	struct
	{
		bool                           bImmediate;
	} params;

	params.bImmediate = bImmediate;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CameraAnimInst.SetScale
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewDuration                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCameraAnimInst::SetScale(float NewDuration)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraAnimInst.SetScale");

	struct
	{
		float                          NewDuration;
	} params;

	params.NewDuration = NewDuration;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CameraAnimInst.SetDuration
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewDuration                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCameraAnimInst::SetDuration(float NewDuration)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraAnimInst.SetDuration");

	struct
	{
		float                          NewDuration;
	} params;

	params.NewDuration = NewDuration;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CameraModifier.IsDisabled
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UCameraModifier::IsDisabled()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraModifier.IsDisabled");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CameraModifier.GetViewTarget
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AActor*                  ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class AActor* UCameraModifier::GetViewTarget()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraModifier.GetViewTarget");

	struct
	{
		class AActor*                  ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CameraModifier.EnableModifier
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UCameraModifier::EnableModifier()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraModifier.EnableModifier");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CameraModifier.DisableModifier
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bImmediate                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCameraModifier::DisableModifier(bool bImmediate)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraModifier.DisableModifier");

	struct
	{
		bool                           bImmediate;
	} params;

	params.bImmediate = bImmediate;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CameraModifier.BlueprintModifyPostProcess
// (FUNC_BlueprintCosmetic, FUNC_Event, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintEvent)
// Parameters:
// float                          DeltaTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          PostProcessBlendWeight         (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FPostProcessSettings    PostProcessSettings            (CPF_Parm, CPF_OutParm)

void UCameraModifier::BlueprintModifyPostProcess(float DeltaTime, float* PostProcessBlendWeight, struct FPostProcessSettings* PostProcessSettings)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraModifier.BlueprintModifyPostProcess");

	struct
	{
		float                          DeltaTime;
		float                          PostProcessBlendWeight;
		struct FPostProcessSettings    PostProcessSettings;
	} params;

	params.DeltaTime = DeltaTime;

	UObject::ProcessEvent(fn, &params);

	if (PostProcessBlendWeight != nullptr)
		*PostProcessBlendWeight = params.PostProcessBlendWeight;
	if (PostProcessSettings != nullptr)
		*PostProcessSettings = params.PostProcessSettings;
}


// Function Engine.CameraModifier.BlueprintModifyCamera
// (FUNC_BlueprintCosmetic, FUNC_Event, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintEvent)
// Parameters:
// float                          DeltaTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 ViewLocation                   (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                ViewRotation                   (CPF_Parm, CPF_IsPlainOldData)
// float                          FOV                            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 NewViewLocation                (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FRotator                NewViewRotation                (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// float                          NewFOV                         (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCameraModifier::BlueprintModifyCamera(float DeltaTime, const struct FVector& ViewLocation, const struct FRotator& ViewRotation, float FOV, struct FVector* NewViewLocation, struct FRotator* NewViewRotation, float* NewFOV)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraModifier.BlueprintModifyCamera");

	struct
	{
		float                          DeltaTime;
		struct FVector                 ViewLocation;
		struct FRotator                ViewRotation;
		float                          FOV;
		struct FVector                 NewViewLocation;
		struct FRotator                NewViewRotation;
		float                          NewFOV;
	} params;

	params.DeltaTime = DeltaTime;
	params.ViewLocation = ViewLocation;
	params.ViewRotation = ViewRotation;
	params.FOV = FOV;

	UObject::ProcessEvent(fn, &params);

	if (NewViewLocation != nullptr)
		*NewViewLocation = params.NewViewLocation;
	if (NewViewRotation != nullptr)
		*NewViewRotation = params.NewViewRotation;
	if (NewFOV != nullptr)
		*NewFOV = params.NewFOV;
}


// Function Engine.CameraShake.ReceiveStopShake
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// bool                           bImmediately                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCameraShake::ReceiveStopShake(bool bImmediately)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraShake.ReceiveStopShake");

	struct
	{
		bool                           bImmediately;
	} params;

	params.bImmediately = bImmediately;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CameraShake.ReceivePlayShake
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// float                          Scale                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCameraShake::ReceivePlayShake(float Scale)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraShake.ReceivePlayShake");

	struct
	{
		float                          Scale;
	} params;

	params.Scale = Scale;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CameraShake.ReceiveIsFinished
// (FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UCameraShake::ReceiveIsFinished()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraShake.ReceiveIsFinished");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CameraShake.BlueprintUpdateCameraShake
// (FUNC_Event, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintEvent)
// Parameters:
// float                          DeltaTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Alpha                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FMinimalViewInfo        POV                            (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm)
// struct FMinimalViewInfo        ModifiedPOV                    (CPF_Parm, CPF_OutParm)

void UCameraShake::BlueprintUpdateCameraShake(float DeltaTime, float Alpha, const struct FMinimalViewInfo& POV, struct FMinimalViewInfo* ModifiedPOV)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CameraShake.BlueprintUpdateCameraShake");

	struct
	{
		float                          DeltaTime;
		float                          Alpha;
		struct FMinimalViewInfo        POV;
		struct FMinimalViewInfo        ModifiedPOV;
	} params;

	params.DeltaTime = DeltaTime;
	params.Alpha = Alpha;
	params.POV = POV;

	UObject::ProcessEvent(fn, &params);

	if (ModifiedPOV != nullptr)
		*ModifiedPOV = params.ModifiedPOV;
}


// Function Engine.Canvas.K2_TextSize
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UFont*                   RenderFont                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FString                 RenderText                     (CPF_Parm, CPF_ZeroConstructor)
// struct FVector2D               Scale                          (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector2D UCanvas::K2_TextSize(class UFont* RenderFont, const struct FString& RenderText, const struct FVector2D& Scale)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Canvas.K2_TextSize");

	struct
	{
		class UFont*                   RenderFont;
		struct FString                 RenderText;
		struct FVector2D               Scale;
		struct FVector2D               ReturnValue;
	} params;

	params.RenderFont = RenderFont;
	params.RenderText = RenderText;
	params.Scale = Scale;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Canvas.K2_StrLen
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UFont*                   RenderFont                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FString                 RenderText                     (CPF_Parm, CPF_ZeroConstructor)
// struct FVector2D               ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector2D UCanvas::K2_StrLen(class UFont* RenderFont, const struct FString& RenderText)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Canvas.K2_StrLen");

	struct
	{
		class UFont*                   RenderFont;
		struct FString                 RenderText;
		struct FVector2D               ReturnValue;
	} params;

	params.RenderFont = RenderFont;
	params.RenderText = RenderText;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Canvas.K2_Project
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 WorldLocation                  (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UCanvas::K2_Project(const struct FVector& WorldLocation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Canvas.K2_Project");

	struct
	{
		struct FVector                 WorldLocation;
		struct FVector                 ReturnValue;
	} params;

	params.WorldLocation = WorldLocation;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Canvas.K2_DrawTriangle
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UTexture*                RenderTexture                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TArray<struct FCanvasUVTri>    Triangles                      (CPF_Parm, CPF_ZeroConstructor)

void UCanvas::K2_DrawTriangle(class UTexture* RenderTexture, TArray<struct FCanvasUVTri> Triangles)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Canvas.K2_DrawTriangle");

	struct
	{
		class UTexture*                RenderTexture;
		TArray<struct FCanvasUVTri>    Triangles;
	} params;

	params.RenderTexture = RenderTexture;
	params.Triangles = Triangles;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Canvas.K2_DrawTexture
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UTexture*                RenderTexture                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector2D               ScreenPosition                 (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               ScreenSize                     (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               CoordinatePosition             (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               CoordinateSize                 (CPF_Parm, CPF_IsPlainOldData)
// struct FLinearColor            RenderColor                    (CPF_Parm, CPF_IsPlainOldData)
// TEnumAsByte<EBlendMode>        BlendMode                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Rotation                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector2D               PivotPoint                     (CPF_Parm, CPF_IsPlainOldData)

void UCanvas::K2_DrawTexture(class UTexture* RenderTexture, const struct FVector2D& ScreenPosition, const struct FVector2D& ScreenSize, const struct FVector2D& CoordinatePosition, const struct FVector2D& CoordinateSize, const struct FLinearColor& RenderColor, TEnumAsByte<EBlendMode> BlendMode, float Rotation, const struct FVector2D& PivotPoint)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Canvas.K2_DrawTexture");

	struct
	{
		class UTexture*                RenderTexture;
		struct FVector2D               ScreenPosition;
		struct FVector2D               ScreenSize;
		struct FVector2D               CoordinatePosition;
		struct FVector2D               CoordinateSize;
		struct FLinearColor            RenderColor;
		TEnumAsByte<EBlendMode>        BlendMode;
		float                          Rotation;
		struct FVector2D               PivotPoint;
	} params;

	params.RenderTexture = RenderTexture;
	params.ScreenPosition = ScreenPosition;
	params.ScreenSize = ScreenSize;
	params.CoordinatePosition = CoordinatePosition;
	params.CoordinateSize = CoordinateSize;
	params.RenderColor = RenderColor;
	params.BlendMode = BlendMode;
	params.Rotation = Rotation;
	params.PivotPoint = PivotPoint;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Canvas.K2_DrawText
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UFont*                   RenderFont                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FString                 RenderText                     (CPF_Parm, CPF_ZeroConstructor)
// struct FVector2D               ScreenPosition                 (CPF_Parm, CPF_IsPlainOldData)
// struct FLinearColor            RenderColor                    (CPF_Parm, CPF_IsPlainOldData)
// float                          Kerning                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FLinearColor            ShadowColor                    (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               ShadowOffset                   (CPF_Parm, CPF_IsPlainOldData)
// bool                           bCentreX                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bCentreY                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bOutlined                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FLinearColor            OutlineColor                   (CPF_Parm, CPF_IsPlainOldData)

void UCanvas::K2_DrawText(class UFont* RenderFont, const struct FString& RenderText, const struct FVector2D& ScreenPosition, const struct FLinearColor& RenderColor, float Kerning, const struct FLinearColor& ShadowColor, const struct FVector2D& ShadowOffset, bool bCentreX, bool bCentreY, bool bOutlined, const struct FLinearColor& OutlineColor)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Canvas.K2_DrawText");

	struct
	{
		class UFont*                   RenderFont;
		struct FString                 RenderText;
		struct FVector2D               ScreenPosition;
		struct FLinearColor            RenderColor;
		float                          Kerning;
		struct FLinearColor            ShadowColor;
		struct FVector2D               ShadowOffset;
		bool                           bCentreX;
		bool                           bCentreY;
		bool                           bOutlined;
		struct FLinearColor            OutlineColor;
	} params;

	params.RenderFont = RenderFont;
	params.RenderText = RenderText;
	params.ScreenPosition = ScreenPosition;
	params.RenderColor = RenderColor;
	params.Kerning = Kerning;
	params.ShadowColor = ShadowColor;
	params.ShadowOffset = ShadowOffset;
	params.bCentreX = bCentreX;
	params.bCentreY = bCentreY;
	params.bOutlined = bOutlined;
	params.OutlineColor = OutlineColor;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Canvas.K2_DrawPolygon
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UTexture*                RenderTexture                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector2D               ScreenPosition                 (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               Radius                         (CPF_Parm, CPF_IsPlainOldData)
// int                            NumberOfSides                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FLinearColor            RenderColor                    (CPF_Parm, CPF_IsPlainOldData)

void UCanvas::K2_DrawPolygon(class UTexture* RenderTexture, const struct FVector2D& ScreenPosition, const struct FVector2D& Radius, int NumberOfSides, const struct FLinearColor& RenderColor)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Canvas.K2_DrawPolygon");

	struct
	{
		class UTexture*                RenderTexture;
		struct FVector2D               ScreenPosition;
		struct FVector2D               Radius;
		int                            NumberOfSides;
		struct FLinearColor            RenderColor;
	} params;

	params.RenderTexture = RenderTexture;
	params.ScreenPosition = ScreenPosition;
	params.Radius = Radius;
	params.NumberOfSides = NumberOfSides;
	params.RenderColor = RenderColor;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Canvas.K2_DrawMaterialTriangle
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UMaterialInterface*      RenderMaterial                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TArray<struct FCanvasUVTri>    Triangles                      (CPF_Parm, CPF_ZeroConstructor)

void UCanvas::K2_DrawMaterialTriangle(class UMaterialInterface* RenderMaterial, TArray<struct FCanvasUVTri> Triangles)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Canvas.K2_DrawMaterialTriangle");

	struct
	{
		class UMaterialInterface*      RenderMaterial;
		TArray<struct FCanvasUVTri>    Triangles;
	} params;

	params.RenderMaterial = RenderMaterial;
	params.Triangles = Triangles;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Canvas.K2_DrawMaterial
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UMaterialInterface*      RenderMaterial                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector2D               ScreenPosition                 (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               ScreenSize                     (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               CoordinatePosition             (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               CoordinateSize                 (CPF_Parm, CPF_IsPlainOldData)
// float                          Rotation                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector2D               PivotPoint                     (CPF_Parm, CPF_IsPlainOldData)

void UCanvas::K2_DrawMaterial(class UMaterialInterface* RenderMaterial, const struct FVector2D& ScreenPosition, const struct FVector2D& ScreenSize, const struct FVector2D& CoordinatePosition, const struct FVector2D& CoordinateSize, float Rotation, const struct FVector2D& PivotPoint)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Canvas.K2_DrawMaterial");

	struct
	{
		class UMaterialInterface*      RenderMaterial;
		struct FVector2D               ScreenPosition;
		struct FVector2D               ScreenSize;
		struct FVector2D               CoordinatePosition;
		struct FVector2D               CoordinateSize;
		float                          Rotation;
		struct FVector2D               PivotPoint;
	} params;

	params.RenderMaterial = RenderMaterial;
	params.ScreenPosition = ScreenPosition;
	params.ScreenSize = ScreenSize;
	params.CoordinatePosition = CoordinatePosition;
	params.CoordinateSize = CoordinateSize;
	params.Rotation = Rotation;
	params.PivotPoint = PivotPoint;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Canvas.K2_DrawLine
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector2D               ScreenPositionA                (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               ScreenPositionB                (CPF_Parm, CPF_IsPlainOldData)
// float                          Thickness                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FLinearColor            RenderColor                    (CPF_Parm, CPF_IsPlainOldData)

void UCanvas::K2_DrawLine(const struct FVector2D& ScreenPositionA, const struct FVector2D& ScreenPositionB, float Thickness, const struct FLinearColor& RenderColor)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Canvas.K2_DrawLine");

	struct
	{
		struct FVector2D               ScreenPositionA;
		struct FVector2D               ScreenPositionB;
		float                          Thickness;
		struct FLinearColor            RenderColor;
	} params;

	params.ScreenPositionA = ScreenPositionA;
	params.ScreenPositionB = ScreenPositionB;
	params.Thickness = Thickness;
	params.RenderColor = RenderColor;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Canvas.K2_DrawBox
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector2D               ScreenPosition                 (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               ScreenSize                     (CPF_Parm, CPF_IsPlainOldData)
// float                          Thickness                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCanvas::K2_DrawBox(const struct FVector2D& ScreenPosition, const struct FVector2D& ScreenSize, float Thickness)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Canvas.K2_DrawBox");

	struct
	{
		struct FVector2D               ScreenPosition;
		struct FVector2D               ScreenSize;
		float                          Thickness;
	} params;

	params.ScreenPosition = ScreenPosition;
	params.ScreenSize = ScreenSize;
	params.Thickness = Thickness;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Canvas.K2_DrawBorder
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UTexture*                BorderTexture                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UTexture*                BackgroundTexture              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UTexture*                LeftBorderTexture              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UTexture*                RightBorderTexture             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UTexture*                TopBorderTexture               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UTexture*                BottomBorderTexture            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector2D               ScreenPosition                 (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               ScreenSize                     (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               CoordinatePosition             (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               CoordinateSize                 (CPF_Parm, CPF_IsPlainOldData)
// struct FLinearColor            RenderColor                    (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               BorderScale                    (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               BackgroundScale                (CPF_Parm, CPF_IsPlainOldData)
// float                          Rotation                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector2D               PivotPoint                     (CPF_Parm, CPF_IsPlainOldData)
// struct FVector2D               CornerSize                     (CPF_Parm, CPF_IsPlainOldData)

void UCanvas::K2_DrawBorder(class UTexture* BorderTexture, class UTexture* BackgroundTexture, class UTexture* LeftBorderTexture, class UTexture* RightBorderTexture, class UTexture* TopBorderTexture, class UTexture* BottomBorderTexture, const struct FVector2D& ScreenPosition, const struct FVector2D& ScreenSize, const struct FVector2D& CoordinatePosition, const struct FVector2D& CoordinateSize, const struct FLinearColor& RenderColor, const struct FVector2D& BorderScale, const struct FVector2D& BackgroundScale, float Rotation, const struct FVector2D& PivotPoint, const struct FVector2D& CornerSize)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Canvas.K2_DrawBorder");

	struct
	{
		class UTexture*                BorderTexture;
		class UTexture*                BackgroundTexture;
		class UTexture*                LeftBorderTexture;
		class UTexture*                RightBorderTexture;
		class UTexture*                TopBorderTexture;
		class UTexture*                BottomBorderTexture;
		struct FVector2D               ScreenPosition;
		struct FVector2D               ScreenSize;
		struct FVector2D               CoordinatePosition;
		struct FVector2D               CoordinateSize;
		struct FLinearColor            RenderColor;
		struct FVector2D               BorderScale;
		struct FVector2D               BackgroundScale;
		float                          Rotation;
		struct FVector2D               PivotPoint;
		struct FVector2D               CornerSize;
	} params;

	params.BorderTexture = BorderTexture;
	params.BackgroundTexture = BackgroundTexture;
	params.LeftBorderTexture = LeftBorderTexture;
	params.RightBorderTexture = RightBorderTexture;
	params.TopBorderTexture = TopBorderTexture;
	params.BottomBorderTexture = BottomBorderTexture;
	params.ScreenPosition = ScreenPosition;
	params.ScreenSize = ScreenSize;
	params.CoordinatePosition = CoordinatePosition;
	params.CoordinateSize = CoordinateSize;
	params.RenderColor = RenderColor;
	params.BorderScale = BorderScale;
	params.BackgroundScale = BackgroundScale;
	params.Rotation = Rotation;
	params.PivotPoint = PivotPoint;
	params.CornerSize = CornerSize;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Canvas.K2_Deproject
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector2D               ScreenPosition                 (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 WorldOrigin                    (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FVector                 WorldDirection                 (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)

void UCanvas::K2_Deproject(const struct FVector2D& ScreenPosition, struct FVector* WorldOrigin, struct FVector* WorldDirection)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Canvas.K2_Deproject");

	struct
	{
		struct FVector2D               ScreenPosition;
		struct FVector                 WorldOrigin;
		struct FVector                 WorldDirection;
	} params;

	params.ScreenPosition = ScreenPosition;

	UObject::ProcessEvent(fn, &params);

	if (WorldOrigin != nullptr)
		*WorldOrigin = params.WorldOrigin;
	if (WorldDirection != nullptr)
		*WorldDirection = params.WorldDirection;
}


// Function Engine.CanvasRenderTarget2D.UpdateResource
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UCanvasRenderTarget2D::UpdateResource()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CanvasRenderTarget2D.UpdateResource");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CanvasRenderTarget2D.ReceiveUpdate
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class UCanvas*                 Canvas                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            Width                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            Height                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCanvasRenderTarget2D::ReceiveUpdate(class UCanvas* Canvas, int Width, int Height)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CanvasRenderTarget2D.ReceiveUpdate");

	struct
	{
		class UCanvas*                 Canvas;
		int                            Width;
		int                            Height;
	} params;

	params.Canvas = Canvas;
	params.Width = Width;
	params.Height = Height;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CanvasRenderTarget2D.GetSize
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure)
// Parameters:
// int                            Width                          (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            Height                         (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCanvasRenderTarget2D::GetSize(int* Width, int* Height)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CanvasRenderTarget2D.GetSize");

	struct
	{
		int                            Width;
		int                            Height;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (Width != nullptr)
		*Width = params.Width;
	if (Height != nullptr)
		*Height = params.Height;
}


// Function Engine.CanvasRenderTarget2D.CreateCanvasRenderTarget2D
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UObject*                 WorldContextObject             (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UClass*                  CanvasRenderTarget2DClass      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            Width                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// int                            Height                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UCanvasRenderTarget2D*   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UCanvasRenderTarget2D* UCanvasRenderTarget2D::CreateCanvasRenderTarget2D(class UObject* WorldContextObject, class UClass* CanvasRenderTarget2DClass, int Width, int Height)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CanvasRenderTarget2D.CreateCanvasRenderTarget2D");

	struct
	{
		class UObject*                 WorldContextObject;
		class UClass*                  CanvasRenderTarget2DClass;
		int                            Width;
		int                            Height;
		class UCanvasRenderTarget2D*   ReturnValue;
	} params;

	params.WorldContextObject = WorldContextObject;
	params.CanvasRenderTarget2DClass = CanvasRenderTarget2DClass;
	params.Width = Width;
	params.Height = Height;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CheatManager.Walk
// (FUNC_Exec, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UCheatManager::Walk()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.Walk");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.ViewSelf
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::ViewSelf()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.ViewSelf");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.ViewPlayer
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// struct FString                 S                              (CPF_Parm, CPF_ZeroConstructor)

void UCheatManager::ViewPlayer(const struct FString& S)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.ViewPlayer");

	struct
	{
		struct FString                 S;
	} params;

	params.S = S;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.ViewClass
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// class UClass*                  DesiredClass                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCheatManager::ViewClass(class UClass* DesiredClass)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.ViewClass");

	struct
	{
		class UClass*                  DesiredClass;
	} params;

	params.DesiredClass = DesiredClass;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.ViewActor
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// struct FName                   ActorName                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCheatManager::ViewActor(const struct FName& ActorName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.ViewActor");

	struct
	{
		struct FName                   ActorName;
	} params;

	params.ActorName = ActorName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.ToggleServerStatReplicatorUpdateStatNet
// (FUNC_Final, FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::ToggleServerStatReplicatorUpdateStatNet()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.ToggleServerStatReplicatorUpdateStatNet");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.ToggleServerStatReplicatorClientOverwrite
// (FUNC_Final, FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::ToggleServerStatReplicatorClientOverwrite()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.ToggleServerStatReplicatorClientOverwrite");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.ToggleDebugCamera
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::ToggleDebugCamera()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.ToggleDebugCamera");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.ToggleAILogging
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::ToggleAILogging()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.ToggleAILogging");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.TestCollisionDistance
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::TestCollisionDistance()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.TestCollisionDistance");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.Teleport
// (FUNC_Exec, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UCheatManager::Teleport()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.Teleport");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.Summon
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// struct FString                 ClassName                      (CPF_Parm, CPF_ZeroConstructor)

void UCheatManager::Summon(const struct FString& ClassName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.Summon");

	struct
	{
		struct FString                 ClassName;
	} params;

	params.ClassName = ClassName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.StreamLevelOut
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// struct FName                   PackageName                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCheatManager::StreamLevelOut(const struct FName& PackageName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.StreamLevelOut");

	struct
	{
		struct FName                   PackageName;
	} params;

	params.PackageName = PackageName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.StreamLevelIn
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// struct FName                   PackageName                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCheatManager::StreamLevelIn(const struct FName& PackageName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.StreamLevelIn");

	struct
	{
		struct FName                   PackageName;
	} params;

	params.PackageName = PackageName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.SpawnServerStatReplicator
// (FUNC_Final, FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::SpawnServerStatReplicator()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.SpawnServerStatReplicator");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.Slomo
// (FUNC_Exec, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewTimeDilation                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCheatManager::Slomo(float NewTimeDilation)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.Slomo");

	struct
	{
		float                          NewTimeDilation;
	} params;

	params.NewTimeDilation = NewTimeDilation;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.SetWorldOrigin
// (FUNC_Final, FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::SetWorldOrigin()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.SetWorldOrigin");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.SetNavDrawDistance
// (FUNC_Final, FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// float                          DrawDistance                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCheatManager::SetNavDrawDistance(float DrawDistance)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.SetNavDrawDistance");

	struct
	{
		float                          DrawDistance;
	} params;

	params.DrawDistance = DrawDistance;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.SetMouseSensitivityToDefault
// (FUNC_Final, FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::SetMouseSensitivityToDefault()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.SetMouseSensitivityToDefault");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.ServerToggleAILogging
// (FUNC_Net, FUNC_NetReliable, FUNC_Native, FUNC_Event, FUNC_Public, FUNC_NetServer, FUNC_NetValidate)

void UCheatManager::ServerToggleAILogging()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.ServerToggleAILogging");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.ReceiveInitCheatManager
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)

void UCheatManager::ReceiveInitCheatManager()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.ReceiveInitCheatManager");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.ReceiveEndPlay
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)

void UCheatManager::ReceiveEndPlay()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.ReceiveEndPlay");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.RebuildNavigation
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::RebuildNavigation()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.RebuildNavigation");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.PlayersOnly
// (FUNC_Exec, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UCheatManager::PlayersOnly()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.PlayersOnly");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.OnlyLoadLevel
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// struct FName                   PackageName                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCheatManager::OnlyLoadLevel(const struct FName& PackageName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.OnlyLoadLevel");

	struct
	{
		struct FName                   PackageName;
	} params;

	params.PackageName = PackageName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.LogLoc
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::LogLoc()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.LogLoc");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.InvertMouse
// (FUNC_Final, FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::InvertMouse()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.InvertMouse");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.God
// (FUNC_Exec, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UCheatManager::God()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.God");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.Ghost
// (FUNC_Exec, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UCheatManager::Ghost()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.Ghost");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.FreezeFrame
// (FUNC_Exec, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Delay                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCheatManager::FreezeFrame(float Delay)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.FreezeFrame");

	struct
	{
		float                          Delay;
	} params;

	params.Delay = Delay;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.Fly
// (FUNC_Exec, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UCheatManager::Fly()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.Fly");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.FlushLog
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::FlushLog()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.FlushLog");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.EnableDebugCamera
// (FUNC_Native, FUNC_Protected, FUNC_BlueprintCallable)

void UCheatManager::EnableDebugCamera()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.EnableDebugCamera");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.DumpVoiceMutingState
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::DumpVoiceMutingState()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.DumpVoiceMutingState");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.DumpPartyState
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::DumpPartyState()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.DumpPartyState");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.DumpOnlineSessionState
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::DumpOnlineSessionState()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.DumpOnlineSessionState");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.DumpChatState
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::DumpChatState()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.DumpChatState");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.DisableDebugCamera
// (FUNC_Native, FUNC_Protected, FUNC_BlueprintCallable)

void UCheatManager::DisableDebugCamera()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.DisableDebugCamera");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.DestroyTarget
// (FUNC_Exec, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UCheatManager::DestroyTarget()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.DestroyTarget");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.DestroyServerStatReplicator
// (FUNC_Final, FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::DestroyServerStatReplicator()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.DestroyServerStatReplicator");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.DestroyPawns
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// class UClass*                  aClass                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCheatManager::DestroyPawns(class UClass* aClass)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.DestroyPawns");

	struct
	{
		class UClass*                  aClass;
	} params;

	params.aClass = aClass;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.DestroyAllPawnsExceptTarget
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::DestroyAllPawnsExceptTarget()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.DestroyAllPawnsExceptTarget");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.DestroyAll
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// class UClass*                  aClass                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCheatManager::DestroyAll(class UClass* aClass)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.DestroyAll");

	struct
	{
		class UClass*                  aClass;
	} params;

	params.aClass = aClass;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.DebugCapsuleSweepSize
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// float                          HalfHeight                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Radius                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCheatManager::DebugCapsuleSweepSize(float HalfHeight, float Radius)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.DebugCapsuleSweepSize");

	struct
	{
		float                          HalfHeight;
		float                          Radius;
	} params;

	params.HalfHeight = HalfHeight;
	params.Radius = Radius;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.DebugCapsuleSweepPawn
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::DebugCapsuleSweepPawn()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.DebugCapsuleSweepPawn");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.DebugCapsuleSweepComplex
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// bool                           bTraceComplex                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCheatManager::DebugCapsuleSweepComplex(bool bTraceComplex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.DebugCapsuleSweepComplex");

	struct
	{
		bool                           bTraceComplex;
	} params;

	params.bTraceComplex = bTraceComplex;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.DebugCapsuleSweepClear
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::DebugCapsuleSweepClear()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.DebugCapsuleSweepClear");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.DebugCapsuleSweepChannel
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// TEnumAsByte<ECollisionChannel> Channel                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCheatManager::DebugCapsuleSweepChannel(TEnumAsByte<ECollisionChannel> Channel)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.DebugCapsuleSweepChannel");

	struct
	{
		TEnumAsByte<ECollisionChannel> Channel;
	} params;

	params.Channel = Channel;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.DebugCapsuleSweepCapture
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::DebugCapsuleSweepCapture()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.DebugCapsuleSweepCapture");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.DebugCapsuleSweep
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void UCheatManager::DebugCapsuleSweep()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.DebugCapsuleSweep");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.DamageTarget
// (FUNC_Exec, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          DamageAmount                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCheatManager::DamageTarget(float DamageAmount)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.DamageTarget");

	struct
	{
		float                          DamageAmount;
	} params;

	params.DamageAmount = DamageAmount;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.CheatScript
// (FUNC_Final, FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// struct FString                 ScriptName                     (CPF_Parm, CPF_ZeroConstructor)

void UCheatManager::CheatScript(const struct FString& ScriptName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.CheatScript");

	struct
	{
		struct FString                 ScriptName;
	} params;

	params.ScriptName = ScriptName;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.ChangeSize
// (FUNC_Exec, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          F                              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCheatManager::ChangeSize(float F)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.ChangeSize");

	struct
	{
		float                          F;
	} params;

	params.F = F;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.BugItStringCreator
// (FUNC_Exec, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults)
// Parameters:
// struct FVector                 ViewLocation                   (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                ViewRotation                   (CPF_Parm, CPF_IsPlainOldData)
// struct FString                 GoString                       (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor)
// struct FString                 LocString                      (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor)

void UCheatManager::BugItStringCreator(const struct FVector& ViewLocation, const struct FRotator& ViewRotation, struct FString* GoString, struct FString* LocString)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.BugItStringCreator");

	struct
	{
		struct FVector                 ViewLocation;
		struct FRotator                ViewRotation;
		struct FString                 GoString;
		struct FString                 LocString;
	} params;

	params.ViewLocation = ViewLocation;
	params.ViewRotation = ViewRotation;

	UObject::ProcessEvent(fn, &params);

	if (GoString != nullptr)
		*GoString = params.GoString;
	if (LocString != nullptr)
		*LocString = params.LocString;
}


// Function Engine.CheatManager.BugItGo
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// float                          X                              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Y                              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Z                              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Pitch                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Yaw                            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Roll                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCheatManager::BugItGo(float X, float Y, float Z, float Pitch, float Yaw, float Roll)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.BugItGo");

	struct
	{
		float                          X;
		float                          Y;
		float                          Z;
		float                          Pitch;
		float                          Yaw;
		float                          Roll;
	} params;

	params.X = X;
	params.Y = Y;
	params.Z = Z;
	params.Pitch = Pitch;
	params.Yaw = Yaw;
	params.Roll = Roll;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CheatManager.BugIt
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// struct FString                 ScreenShotDescription          (CPF_Parm, CPF_ZeroConstructor)

void UCheatManager::BugIt(const struct FString& ScreenShotDescription)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CheatManager.BugIt");

	struct
	{
		struct FString                 ScreenShotDescription;
	} params;

	params.ScreenShotDescription = ScreenShotDescription;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ChildActorComponent.SetChildActorClass
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UClass*                  InClass                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UChildActorComponent::SetChildActorClass(class UClass* InClass)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ChildActorComponent.SetChildActorClass");

	struct
	{
		class UClass*                  InClass;
	} params;

	params.InClass = InClass;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameViewportClient.SSSwapControllers
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void UGameViewportClient::SSSwapControllers()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameViewportClient.SSSwapControllers");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameViewportClient.ShowTitleSafeArea
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void UGameViewportClient::ShowTitleSafeArea()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameViewportClient.ShowTitleSafeArea");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameViewportClient.SetConsoleTarget
// (FUNC_Exec, FUNC_Native, FUNC_Public)
// Parameters:
// int                            PlayerIndex                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UGameViewportClient::SetConsoleTarget(int PlayerIndex)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameViewportClient.SetConsoleTarget");

	struct
	{
		int                            PlayerIndex;
	} params;

	params.PlayerIndex = PlayerIndex;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.CurveBase.GetValueRange
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          MinValue                       (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          MaxValue                       (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCurveBase::GetValueRange(float* MinValue, float* MaxValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CurveBase.GetValueRange");

	struct
	{
		float                          MinValue;
		float                          MaxValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (MinValue != nullptr)
		*MinValue = params.MinValue;
	if (MaxValue != nullptr)
		*MaxValue = params.MaxValue;
}


// Function Engine.CurveBase.GetTimeRange
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          MinTime                        (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          MaxTime                        (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UCurveBase::GetTimeRange(float* MinTime, float* MaxTime)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CurveBase.GetTimeRange");

	struct
	{
		float                          MinTime;
		float                          MaxTime;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (MinTime != nullptr)
		*MinTime = params.MinTime;
	if (MaxTime != nullptr)
		*MaxTime = params.MaxTime;
}


// Function Engine.CurveFloat.GetFloatValue
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          InTime                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCurveFloat::GetFloatValue(float InTime)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CurveFloat.GetFloatValue");

	struct
	{
		float                          InTime;
		float                          ReturnValue;
	} params;

	params.InTime = InTime;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CurveLinearColor.GetLinearColorValue
// (FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          InTime                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FLinearColor            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FLinearColor UCurveLinearColor::GetLinearColorValue(float InTime)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CurveLinearColor.GetLinearColorValue");

	struct
	{
		float                          InTime;
		struct FLinearColor            ReturnValue;
	} params;

	params.InTime = InTime;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CurveSourceInterface.GetCurveValue
// (FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent, FUNC_Const)
// Parameters:
// struct FName                   CurveName                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UCurveSourceInterface::GetCurveValue(const struct FName& CurveName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CurveSourceInterface.GetCurveValue");

	struct
	{
		struct FName                   CurveName;
		float                          ReturnValue;
	} params;

	params.CurveName = CurveName;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CurveSourceInterface.GetCurves
// (FUNC_Native, FUNC_Event, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintEvent, FUNC_Const)
// Parameters:
// TArray<struct FNamedCurveValue> OutValues                      (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor)

void UCurveSourceInterface::GetCurves(TArray<struct FNamedCurveValue>* OutValues)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CurveSourceInterface.GetCurves");

	struct
	{
		TArray<struct FNamedCurveValue> OutValues;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (OutValues != nullptr)
		*OutValues = params.OutValues;
}


// Function Engine.CurveSourceInterface.GetBindingName
// (FUNC_Native, FUNC_Event, FUNC_Public, FUNC_BlueprintEvent, FUNC_Const)
// Parameters:
// struct FName                   ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

struct FName UCurveSourceInterface::GetBindingName()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CurveSourceInterface.GetBindingName");

	struct
	{
		struct FName                   ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.CurveVector.GetVectorValue
// (FUNC_Final, FUNC_RequiredAPI, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          InTime                         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FVector UCurveVector::GetVectorValue(float InTime)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.CurveVector.GetVectorValue");

	struct
	{
		float                          InTime;
		struct FVector                 ReturnValue;
	} params;

	params.InTime = InTime;

	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.DataTableFunctionLibrary.GetDataTableRowNames
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// class UDataTable*              Table                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TArray<struct FName>           OutRowNames                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor)

void UDataTableFunctionLibrary::GetDataTableRowNames(class UDataTable* Table, TArray<struct FName>* OutRowNames)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DataTableFunctionLibrary.GetDataTableRowNames");

	struct
	{
		class UDataTable*              Table;
		TArray<struct FName>           OutRowNames;
	} params;

	params.Table = Table;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	if (OutRowNames != nullptr)
		*OutRowNames = params.OutRowNames;
}


// Function Engine.DataTableFunctionLibrary.GetDataTableRowFromName
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// class UDataTable*              Table                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   RowName                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FTableRowBase           OutRow                         (CPF_Parm, CPF_OutParm)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UDataTableFunctionLibrary::GetDataTableRowFromName(class UDataTable* Table, const struct FName& RowName, struct FTableRowBase* OutRow)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DataTableFunctionLibrary.GetDataTableRowFromName");

	struct
	{
		class UDataTable*              Table;
		struct FName                   RowName;
		struct FTableRowBase           OutRow;
		bool                           ReturnValue;
	} params;

	params.Table = Table;
	params.RowName = RowName;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	if (OutRow != nullptr)
		*OutRow = params.OutRow;

	return params.ReturnValue;
}


// Function Engine.DataTableFunctionLibrary.GetDataTableColumnAsString
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UDataTable*              DataTable                      (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   PropertyName                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TArray<struct FString>         ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm)

TArray<struct FString> UDataTableFunctionLibrary::GetDataTableColumnAsString(class UDataTable* DataTable, const struct FName& PropertyName)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DataTableFunctionLibrary.GetDataTableColumnAsString");

	struct
	{
		class UDataTable*              DataTable;
		struct FName                   PropertyName;
		TArray<struct FString>         ReturnValue;
	} params;

	params.DataTable = DataTable;
	params.PropertyName = PropertyName;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.DataTableFunctionLibrary.EvaluateCurveTableRow
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// class UCurveTable*             CurveTable                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   RowName                        (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          InXY                           (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// TEnumAsByte<EEvaluateCurveTableResult> OutResult                      (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          OutXY                          (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FString                 ContextString                  (CPF_Parm, CPF_ZeroConstructor)

void UDataTableFunctionLibrary::EvaluateCurveTableRow(class UCurveTable* CurveTable, const struct FName& RowName, float InXY, const struct FString& ContextString, TEnumAsByte<EEvaluateCurveTableResult>* OutResult, float* OutXY)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DataTableFunctionLibrary.EvaluateCurveTableRow");

	struct
	{
		class UCurveTable*             CurveTable;
		struct FName                   RowName;
		float                          InXY;
		TEnumAsByte<EEvaluateCurveTableResult> OutResult;
		float                          OutXY;
		struct FString                 ContextString;
	} params;

	params.CurveTable = CurveTable;
	params.RowName = RowName;
	params.InXY = InXY;
	params.ContextString = ContextString;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	if (OutResult != nullptr)
		*OutResult = params.OutResult;
	if (OutXY != nullptr)
		*OutXY = params.OutXY;
}


// Function Engine.DebugCameraController.ToggleDisplay
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void ADebugCameraController::ToggleDisplay()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DebugCameraController.ToggleDisplay");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DebugCameraController.ShowDebugSelectedInfo
// (FUNC_Exec, FUNC_Native, FUNC_Public)

void ADebugCameraController::ShowDebugSelectedInfo()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DebugCameraController.ShowDebugSelectedInfo");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DebugCameraController.SetPawnMovementSpeedScale
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewSpeedScale                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ADebugCameraController::SetPawnMovementSpeedScale(float NewSpeedScale)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DebugCameraController.SetPawnMovementSpeedScale");

	struct
	{
		float                          NewSpeedScale;
	} params;

	params.NewSpeedScale = NewSpeedScale;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DebugCameraController.ReceiveOnDeactivate
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class APlayerController*       RestoredPC                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ADebugCameraController::ReceiveOnDeactivate(class APlayerController* RestoredPC)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DebugCameraController.ReceiveOnDeactivate");

	struct
	{
		class APlayerController*       RestoredPC;
	} params;

	params.RestoredPC = RestoredPC;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DebugCameraController.ReceiveOnActorSelected
// (FUNC_Event, FUNC_Protected, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintEvent)
// Parameters:
// class AActor*                  NewSelectedActor               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 SelectHitLocation              (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// struct FVector                 SelectHitNormal                (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)
// struct FHitResult              Hit                            (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm, CPF_IsPlainOldData)

void ADebugCameraController::ReceiveOnActorSelected(class AActor* NewSelectedActor, const struct FVector& SelectHitLocation, const struct FVector& SelectHitNormal, const struct FHitResult& Hit)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DebugCameraController.ReceiveOnActorSelected");

	struct
	{
		class AActor*                  NewSelectedActor;
		struct FVector                 SelectHitLocation;
		struct FVector                 SelectHitNormal;
		struct FHitResult              Hit;
	} params;

	params.NewSelectedActor = NewSelectedActor;
	params.SelectHitLocation = SelectHitLocation;
	params.SelectHitNormal = SelectHitNormal;
	params.Hit = Hit;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DebugCameraController.ReceiveOnActivate
// (FUNC_Event, FUNC_Public, FUNC_BlueprintEvent)
// Parameters:
// class APlayerController*       OriginalPC                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ADebugCameraController::ReceiveOnActivate(class APlayerController* OriginalPC)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DebugCameraController.ReceiveOnActivate");

	struct
	{
		class APlayerController*       OriginalPC;
	} params;

	params.OriginalPC = OriginalPC;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DebugCameraController.GetSelectedActor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class AActor*                  ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class AActor* ADebugCameraController::GetSelectedActor()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DebugCameraController.GetSelectedActor");

	struct
	{
		class AActor*                  ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.DecalActor.SetDecalMaterial
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UMaterialInterface*      NewDecalMaterial               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ADecalActor::SetDecalMaterial(class UMaterialInterface* NewDecalMaterial)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DecalActor.SetDecalMaterial");

	struct
	{
		class UMaterialInterface*      NewDecalMaterial;
	} params;

	params.NewDecalMaterial = NewDecalMaterial;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DecalActor.GetDecalMaterial
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UMaterialInterface*      ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UMaterialInterface* ADecalActor::GetDecalMaterial()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DecalActor.GetDecalMaterial");

	struct
	{
		class UMaterialInterface*      ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.DecalActor.CreateDynamicMaterialInstance
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UMaterialInstanceDynamic* ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UMaterialInstanceDynamic* ADecalActor::CreateDynamicMaterialInstance()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DecalActor.CreateDynamicMaterialInstance");

	struct
	{
		class UMaterialInstanceDynamic* ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.DecalComponent.SetSortOrder
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            Value                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UDecalComponent::SetSortOrder(int Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DecalComponent.SetSortOrder");

	struct
	{
		int                            Value;
	} params;

	params.Value = Value;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DecalComponent.SetFadeScreenSize
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewFadeScreenSize              (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UDecalComponent::SetFadeScreenSize(float NewFadeScreenSize)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DecalComponent.SetFadeScreenSize");

	struct
	{
		float                          NewFadeScreenSize;
	} params;

	params.NewFadeScreenSize = NewFadeScreenSize;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DecalComponent.SetFadeOut
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          StartDelay                     (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Duration                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           DestroyOwnerAfterFade          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UDecalComponent::SetFadeOut(float StartDelay, float Duration, bool DestroyOwnerAfterFade)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DecalComponent.SetFadeOut");

	struct
	{
		float                          StartDelay;
		float                          Duration;
		bool                           DestroyOwnerAfterFade;
	} params;

	params.StartDelay = StartDelay;
	params.Duration = Duration;
	params.DestroyOwnerAfterFade = DestroyOwnerAfterFade;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DecalComponent.SetDecalMaterial
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UMaterialInterface*      NewDecalMaterial               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UDecalComponent::SetDecalMaterial(class UMaterialInterface* NewDecalMaterial)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DecalComponent.SetDecalMaterial");

	struct
	{
		class UMaterialInterface*      NewDecalMaterial;
	} params;

	params.NewDecalMaterial = NewDecalMaterial;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DecalComponent.GetFadeStartDelay
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UDecalComponent::GetFadeStartDelay()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DecalComponent.GetFadeStartDelay");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.DecalComponent.GetFadeDuration
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float UDecalComponent::GetFadeDuration()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DecalComponent.GetFadeDuration");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.DecalComponent.GetDecalMaterial
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// class UMaterialInterface*      ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UMaterialInterface* UDecalComponent::GetDecalMaterial()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DecalComponent.GetDecalMaterial");

	struct
	{
		class UMaterialInterface*      ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.DecalComponent.CreateDynamicMaterialInstance
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UMaterialInstanceDynamic* ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UMaterialInstanceDynamic* UDecalComponent::CreateDynamicMaterialInstance()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DecalComponent.CreateDynamicMaterialInstance");

	struct
	{
		class UMaterialInstanceDynamic* ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Light.ToggleEnabled
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void ALight::ToggleEnabled()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Light.ToggleEnabled");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Light.SetLightFunctionScale
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewLightFunctionScale          (CPF_Parm, CPF_IsPlainOldData)

void ALight::SetLightFunctionScale(const struct FVector& NewLightFunctionScale)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Light.SetLightFunctionScale");

	struct
	{
		struct FVector                 NewLightFunctionScale;
	} params;

	params.NewLightFunctionScale = NewLightFunctionScale;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Light.SetLightFunctionMaterial
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UMaterialInterface*      NewLightFunctionMaterial       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ALight::SetLightFunctionMaterial(class UMaterialInterface* NewLightFunctionMaterial)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Light.SetLightFunctionMaterial");

	struct
	{
		class UMaterialInterface*      NewLightFunctionMaterial;
	} params;

	params.NewLightFunctionMaterial = NewLightFunctionMaterial;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Light.SetLightFunctionFadeDistance
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewLightFunctionFadeDistance   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ALight::SetLightFunctionFadeDistance(float NewLightFunctionFadeDistance)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Light.SetLightFunctionFadeDistance");

	struct
	{
		float                          NewLightFunctionFadeDistance;
	} params;

	params.NewLightFunctionFadeDistance = NewLightFunctionFadeDistance;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Light.SetLightColor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FLinearColor            NewLightColor                  (CPF_Parm, CPF_IsPlainOldData)

void ALight::SetLightColor(const struct FLinearColor& NewLightColor)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Light.SetLightColor");

	struct
	{
		struct FLinearColor            NewLightColor;
	} params;

	params.NewLightColor = NewLightColor;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Light.SetEnabled
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bSetEnabled                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ALight::SetEnabled(bool bSetEnabled)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Light.SetEnabled");

	struct
	{
		bool                           bSetEnabled;
	} params;

	params.bSetEnabled = bSetEnabled;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Light.SetCastShadows
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewValue                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ALight::SetCastShadows(bool bNewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Light.SetCastShadows");

	struct
	{
		bool                           bNewValue;
	} params;

	params.bNewValue = bNewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Light.SetBrightness
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewBrightness                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ALight::SetBrightness(float NewBrightness)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Light.SetBrightness");

	struct
	{
		float                          NewBrightness;
	} params;

	params.NewBrightness = NewBrightness;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Light.SetAffectTranslucentLighting
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewValue                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ALight::SetAffectTranslucentLighting(bool bNewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Light.SetAffectTranslucentLighting");

	struct
	{
		bool                           bNewValue;
	} params;

	params.bNewValue = bNewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Light.OnRep_bEnabled
// (FUNC_Native, FUNC_Public)

void ALight::OnRep_bEnabled()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Light.OnRep_bEnabled");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Light.IsEnabled
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool ALight::IsEnabled()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Light.IsEnabled");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Light.GetLightColor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FLinearColor            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FLinearColor ALight::GetLightColor()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Light.GetLightColor");

	struct
	{
		struct FLinearColor            ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Light.GetBrightness
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float ALight::GetBrightness()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Light.GetBrightness");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.LightComponentBase.SetCastVolumetricShadow
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewValue                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ULightComponentBase::SetCastVolumetricShadow(bool bNewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponentBase.SetCastVolumetricShadow");

	struct
	{
		bool                           bNewValue;
	} params;

	params.bNewValue = bNewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.LightComponentBase.SetCastShadows
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewValue                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ULightComponentBase::SetCastShadows(bool bNewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponentBase.SetCastShadows");

	struct
	{
		bool                           bNewValue;
	} params;

	params.bNewValue = bNewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.LightComponentBase.GetLightColor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FLinearColor            ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ReturnParm, CPF_IsPlainOldData)

struct FLinearColor ULightComponentBase::GetLightColor()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponentBase.GetLightColor");

	struct
	{
		struct FLinearColor            ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.LightComponent.SetVolumetricScatteringIntensity
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewIntensity                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ULightComponent::SetVolumetricScatteringIntensity(float NewIntensity)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponent.SetVolumetricScatteringIntensity");

	struct
	{
		float                          NewIntensity;
	} params;

	params.NewIntensity = NewIntensity;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.LightComponent.SetTemperature
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewTemperature                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ULightComponent::SetTemperature(float NewTemperature)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponent.SetTemperature");

	struct
	{
		float                          NewTemperature;
	} params;

	params.NewTemperature = NewTemperature;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.LightComponent.SetShadowBias
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewValue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ULightComponent::SetShadowBias(float NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponent.SetShadowBias");

	struct
	{
		float                          NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.LightComponent.SetLightFunctionScale
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewLightFunctionScale          (CPF_Parm, CPF_IsPlainOldData)

void ULightComponent::SetLightFunctionScale(const struct FVector& NewLightFunctionScale)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponent.SetLightFunctionScale");

	struct
	{
		struct FVector                 NewLightFunctionScale;
	} params;

	params.NewLightFunctionScale = NewLightFunctionScale;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.LightComponent.SetLightFunctionMaterial
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UMaterialInterface*      NewLightFunctionMaterial       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ULightComponent::SetLightFunctionMaterial(class UMaterialInterface* NewLightFunctionMaterial)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponent.SetLightFunctionMaterial");

	struct
	{
		class UMaterialInterface*      NewLightFunctionMaterial;
	} params;

	params.NewLightFunctionMaterial = NewLightFunctionMaterial;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.LightComponent.SetLightFunctionFadeDistance
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewLightFunctionFadeDistance   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ULightComponent::SetLightFunctionFadeDistance(float NewLightFunctionFadeDistance)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponent.SetLightFunctionFadeDistance");

	struct
	{
		float                          NewLightFunctionFadeDistance;
	} params;

	params.NewLightFunctionFadeDistance = NewLightFunctionFadeDistance;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.LightComponent.SetLightFunctionDisabledBrightness
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewValue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ULightComponent::SetLightFunctionDisabledBrightness(float NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponent.SetLightFunctionDisabledBrightness");

	struct
	{
		float                          NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.LightComponent.SetLightColor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FLinearColor            NewLightColor                  (CPF_Parm, CPF_IsPlainOldData)
// bool                           bSRGB                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ULightComponent::SetLightColor(const struct FLinearColor& NewLightColor, bool bSRGB)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponent.SetLightColor");

	struct
	{
		struct FLinearColor            NewLightColor;
		bool                           bSRGB;
	} params;

	params.NewLightColor = NewLightColor;
	params.bSRGB = bSRGB;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.LightComponent.SetIntensity
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewIntensity                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ULightComponent::SetIntensity(float NewIntensity)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponent.SetIntensity");

	struct
	{
		float                          NewIntensity;
	} params;

	params.NewIntensity = NewIntensity;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.LightComponent.SetIndirectLightingIntensity
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewIntensity                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ULightComponent::SetIndirectLightingIntensity(float NewIntensity)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponent.SetIndirectLightingIntensity");

	struct
	{
		float                          NewIntensity;
	} params;

	params.NewIntensity = NewIntensity;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.LightComponent.SetIESTexture
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UTextureLightProfile*    NewValue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ULightComponent::SetIESTexture(class UTextureLightProfile* NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponent.SetIESTexture");

	struct
	{
		class UTextureLightProfile*    NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.LightComponent.SetForceCachedShadowsForMovablePrimitives
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewValue                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ULightComponent::SetForceCachedShadowsForMovablePrimitives(bool bNewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponent.SetForceCachedShadowsForMovablePrimitives");

	struct
	{
		bool                           bNewValue;
	} params;

	params.bNewValue = bNewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.LightComponent.SetEnableLightShaftBloom
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewValue                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ULightComponent::SetEnableLightShaftBloom(bool bNewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponent.SetEnableLightShaftBloom");

	struct
	{
		bool                           bNewValue;
	} params;

	params.bNewValue = bNewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.LightComponent.SetBloomTint
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FColor                  NewValue                       (CPF_Parm, CPF_IsPlainOldData)

void ULightComponent::SetBloomTint(const struct FColor& NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponent.SetBloomTint");

	struct
	{
		struct FColor                  NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.LightComponent.SetBloomThreshold
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewValue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ULightComponent::SetBloomThreshold(float NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponent.SetBloomThreshold");

	struct
	{
		float                          NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.LightComponent.SetBloomScale
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewValue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ULightComponent::SetBloomScale(float NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponent.SetBloomScale");

	struct
	{
		float                          NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.LightComponent.SetAffectTranslucentLighting
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewValue                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ULightComponent::SetAffectTranslucentLighting(bool bNewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponent.SetAffectTranslucentLighting");

	struct
	{
		bool                           bNewValue;
	} params;

	params.bNewValue = bNewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.LightComponent.SetAffectDynamicIndirectLighting
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewValue                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void ULightComponent::SetAffectDynamicIndirectLighting(bool bNewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.LightComponent.SetAffectDynamicIndirectLighting");

	struct
	{
		bool                           bNewValue;
	} params;

	params.bNewValue = bNewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DirectionalLightComponent.SetShadowDistanceFadeoutFraction
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewValue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UDirectionalLightComponent::SetShadowDistanceFadeoutFraction(float NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DirectionalLightComponent.SetShadowDistanceFadeoutFraction");

	struct
	{
		float                          NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DirectionalLightComponent.SetOcclusionMaskDarkness
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewValue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UDirectionalLightComponent::SetOcclusionMaskDarkness(float NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DirectionalLightComponent.SetOcclusionMaskDarkness");

	struct
	{
		float                          NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DirectionalLightComponent.SetLightShaftOverrideDirection
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FVector                 NewValue                       (CPF_Parm, CPF_IsPlainOldData)

void UDirectionalLightComponent::SetLightShaftOverrideDirection(const struct FVector& NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DirectionalLightComponent.SetLightShaftOverrideDirection");

	struct
	{
		struct FVector                 NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DirectionalLightComponent.SetEnableLightShaftOcclusion
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewValue                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UDirectionalLightComponent::SetEnableLightShaftOcclusion(bool bNewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DirectionalLightComponent.SetEnableLightShaftOcclusion");

	struct
	{
		bool                           bNewValue;
	} params;

	params.bNewValue = bNewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DirectionalLightComponent.SetDynamicShadowDistanceStationaryLight
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewValue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UDirectionalLightComponent::SetDynamicShadowDistanceStationaryLight(float NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DirectionalLightComponent.SetDynamicShadowDistanceStationaryLight");

	struct
	{
		float                          NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DirectionalLightComponent.SetDynamicShadowDistanceMovableLight
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewValue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UDirectionalLightComponent::SetDynamicShadowDistanceMovableLight(float NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DirectionalLightComponent.SetDynamicShadowDistanceMovableLight");

	struct
	{
		float                          NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DirectionalLightComponent.SetDynamicShadowCascades
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// int                            NewValue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UDirectionalLightComponent::SetDynamicShadowCascades(int NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DirectionalLightComponent.SetDynamicShadowCascades");

	struct
	{
		int                            NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DirectionalLightComponent.SetCascadeTransitionFraction
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewValue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UDirectionalLightComponent::SetCascadeTransitionFraction(float NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DirectionalLightComponent.SetCascadeTransitionFraction");

	struct
	{
		float                          NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.DirectionalLightComponent.SetCascadeDistributionExponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewValue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UDirectionalLightComponent::SetCascadeDistributionExponent(float NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.DirectionalLightComponent.SetCascadeDistributionExponent");

	struct
	{
		float                          NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SphereComponent.SetSphereRadius
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          InSphereRadius                 (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bUpdateOverlaps                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void USphereComponent::SetSphereRadius(float InSphereRadius, bool bUpdateOverlaps)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SphereComponent.SetSphereRadius");

	struct
	{
		float                          InSphereRadius;
		bool                           bUpdateOverlaps;
	} params;

	params.InSphereRadius = InSphereRadius;
	params.bUpdateOverlaps = bUpdateOverlaps;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.SphereComponent.GetUnscaledSphereRadius
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float USphereComponent::GetUnscaledSphereRadius()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SphereComponent.GetUnscaledSphereRadius");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SphereComponent.GetShapeScale
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float USphereComponent::GetShapeScale()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SphereComponent.GetShapeScale");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.SphereComponent.GetScaledSphereRadius
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// float                          ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

float USphereComponent::GetScaledSphereRadius()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.SphereComponent.GetScaledSphereRadius");

	struct
	{
		float                          ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Emitter.ToggleActive
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AEmitter::ToggleActive()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Emitter.ToggleActive");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Emitter.SetVectorParameter
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   ParameterName                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 Param                          (CPF_Parm, CPF_IsPlainOldData)

void AEmitter::SetVectorParameter(const struct FName& ParameterName, const struct FVector& Param)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Emitter.SetVectorParameter");

	struct
	{
		struct FName                   ParameterName;
		struct FVector                 Param;
	} params;

	params.ParameterName = ParameterName;
	params.Param = Param;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Emitter.SetTemplate
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UParticleSystem*         NewTemplate                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AEmitter::SetTemplate(class UParticleSystem* NewTemplate)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Emitter.SetTemplate");

	struct
	{
		class UParticleSystem*         NewTemplate;
	} params;

	params.NewTemplate = NewTemplate;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Emitter.SetMaterialParameter
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   ParameterName                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UMaterialInterface*      Param                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AEmitter::SetMaterialParameter(const struct FName& ParameterName, class UMaterialInterface* Param)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Emitter.SetMaterialParameter");

	struct
	{
		struct FName                   ParameterName;
		class UMaterialInterface*      Param;
	} params;

	params.ParameterName = ParameterName;
	params.Param = Param;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Emitter.SetFloatParameter
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   ParameterName                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          Param                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AEmitter::SetFloatParameter(const struct FName& ParameterName, float Param)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Emitter.SetFloatParameter");

	struct
	{
		struct FName                   ParameterName;
		float                          Param;
	} params;

	params.ParameterName = ParameterName;
	params.Param = Param;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Emitter.SetColorParameter
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   ParameterName                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FLinearColor            Param                          (CPF_Parm, CPF_IsPlainOldData)

void AEmitter::SetColorParameter(const struct FName& ParameterName, const struct FLinearColor& Param)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Emitter.SetColorParameter");

	struct
	{
		struct FName                   ParameterName;
		struct FLinearColor            Param;
	} params;

	params.ParameterName = ParameterName;
	params.Param = Param;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Emitter.SetActorParameter
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// struct FName                   ParameterName                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class AActor*                  Param                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void AEmitter::SetActorParameter(const struct FName& ParameterName, class AActor* Param)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Emitter.SetActorParameter");

	struct
	{
		struct FName                   ParameterName;
		class AActor*                  Param;
	} params;

	params.ParameterName = ParameterName;
	params.Param = Param;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Emitter.OnRep_bCurrentlyActive
// (FUNC_Native, FUNC_Public)

void AEmitter::OnRep_bCurrentlyActive()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Emitter.OnRep_bCurrentlyActive");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Emitter.OnParticleSystemFinished
// (FUNC_Native, FUNC_Public)
// Parameters:
// class UParticleSystemComponent* FinishedComponent              (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)

void AEmitter::OnParticleSystemFinished(class UParticleSystemComponent* FinishedComponent)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Emitter.OnParticleSystemFinished");

	struct
	{
		class UParticleSystemComponent* FinishedComponent;
	} params;

	params.FinishedComponent = FinishedComponent;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Emitter.IsActive
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool AEmitter::IsActive()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Emitter.IsActive");

	struct
	{
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.Emitter.Deactivate
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AEmitter::Deactivate()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Emitter.Deactivate");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.Emitter.Activate
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void AEmitter::Activate()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.Emitter.Activate");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFog.OnRep_bEnabled
// (FUNC_Native, FUNC_Public)

void AExponentialHeightFog::OnRep_bEnabled()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFog.OnRep_bEnabled");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetVolumetricFogScatteringDistribution
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewValue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetVolumetricFogScatteringDistribution(float NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetVolumetricFogScatteringDistribution");

	struct
	{
		float                          NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetVolumetricFogExtinctionScale
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewValue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetVolumetricFogExtinctionScale(float NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetVolumetricFogExtinctionScale");

	struct
	{
		float                          NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetVolumetricFogEmissive
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FLinearColor            NewValue                       (CPF_Parm, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetVolumetricFogEmissive(const struct FLinearColor& NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetVolumetricFogEmissive");

	struct
	{
		struct FLinearColor            NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetVolumetricFogDistance
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewValue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetVolumetricFogDistance(float NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetVolumetricFogDistance");

	struct
	{
		float                          NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetVolumetricFogAlbedo
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FColor                  NewValue                       (CPF_Parm, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetVolumetricFogAlbedo(const struct FColor& NewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetVolumetricFogAlbedo");

	struct
	{
		struct FColor                  NewValue;
	} params;

	params.NewValue = NewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetVolumetricFog
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// bool                           bNewValue                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetVolumetricFog(bool bNewValue)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetVolumetricFog");

	struct
	{
		bool                           bNewValue;
	} params;

	params.bNewValue = bNewValue;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetStartDistance
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Value                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetStartDistance(float Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetStartDistance");

	struct
	{
		float                          Value;
	} params;

	params.Value = Value;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetNonDirectionalInscatteringColorDistance
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Value                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetNonDirectionalInscatteringColorDistance(float Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetNonDirectionalInscatteringColorDistance");

	struct
	{
		float                          Value;
	} params;

	params.Value = Value;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetInscatteringTextureTint
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FLinearColor            Value                          (CPF_Parm, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetInscatteringTextureTint(const struct FLinearColor& Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetInscatteringTextureTint");

	struct
	{
		struct FLinearColor            Value;
	} params;

	params.Value = Value;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetInscatteringColorCubemapAngle
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Value                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetInscatteringColorCubemapAngle(float Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetInscatteringColorCubemapAngle");

	struct
	{
		float                          Value;
	} params;

	params.Value = Value;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetInscatteringColorCubemap
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UTextureCube*            Value                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetInscatteringColorCubemap(class UTextureCube* Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetInscatteringColorCubemap");

	struct
	{
		class UTextureCube*            Value;
	} params;

	params.Value = Value;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetFullyDirectionalInscatteringColorDistance
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Value                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetFullyDirectionalInscatteringColorDistance(float Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetFullyDirectionalInscatteringColorDistance");

	struct
	{
		float                          Value;
	} params;

	params.Value = Value;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetFogMaxOpacity
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Value                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetFogMaxOpacity(float Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetFogMaxOpacity");

	struct
	{
		float                          Value;
	} params;

	params.Value = Value;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetFogInscatteringColor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FLinearColor            Value                          (CPF_Parm, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetFogInscatteringColor(const struct FLinearColor& Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetFogInscatteringColor");

	struct
	{
		struct FLinearColor            Value;
	} params;

	params.Value = Value;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetFogHeightFalloff
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Value                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetFogHeightFalloff(float Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetFogHeightFalloff");

	struct
	{
		float                          Value;
	} params;

	params.Value = Value;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetFogDensity
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Value                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetFogDensity(float Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetFogDensity");

	struct
	{
		float                          Value;
	} params;

	params.Value = Value;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetFogCutoffDistance
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Value                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetFogCutoffDistance(float Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetFogCutoffDistance");

	struct
	{
		float                          Value;
	} params;

	params.Value = Value;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetDirectionalInscatteringStartDistance
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Value                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetDirectionalInscatteringStartDistance(float Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetDirectionalInscatteringStartDistance");

	struct
	{
		float                          Value;
	} params;

	params.Value = Value;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetDirectionalInscatteringExponent
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          Value                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetDirectionalInscatteringExponent(float Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetDirectionalInscatteringExponent");

	struct
	{
		float                          Value;
	} params;

	params.Value = Value;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ExponentialHeightFogComponent.SetDirectionalInscatteringColor
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// struct FLinearColor            Value                          (CPF_Parm, CPF_IsPlainOldData)

void UExponentialHeightFogComponent::SetDirectionalInscatteringColor(const struct FLinearColor& Value)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ExponentialHeightFogComponent.SetDirectionalInscatteringColor");

	struct
	{
		struct FLinearColor            Value;
	} params;

	params.Value = Value;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ForceFeedbackComponent.Stop
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)

void UForceFeedbackComponent::Stop()
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ForceFeedbackComponent.Stop");

	struct
	{
	} params;


	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ForceFeedbackComponent.SetIntensityMultiplier
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          NewIntensityMultiplier         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UForceFeedbackComponent::SetIntensityMultiplier(float NewIntensityMultiplier)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ForceFeedbackComponent.SetIntensityMultiplier");

	struct
	{
		float                          NewIntensityMultiplier;
	} params;

	params.NewIntensityMultiplier = NewIntensityMultiplier;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ForceFeedbackComponent.SetForceFeedbackEffect
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UForceFeedbackEffect*    NewForceFeedbackEffect         (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UForceFeedbackComponent::SetForceFeedbackEffect(class UForceFeedbackEffect* NewForceFeedbackEffect)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ForceFeedbackComponent.SetForceFeedbackEffect");

	struct
	{
		class UForceFeedbackEffect*    NewForceFeedbackEffect;
	} params;

	params.NewForceFeedbackEffect = NewForceFeedbackEffect;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ForceFeedbackComponent.Play
// (FUNC_Native, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// float                          StartTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)

void UForceFeedbackComponent::Play(float StartTime)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ForceFeedbackComponent.Play");

	struct
	{
		float                          StartTime;
	} params;

	params.StartTime = StartTime;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.ForceFeedbackComponent.BP_GetAttenuationSettingsToApply
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable, FUNC_BlueprintPure, FUNC_Const)
// Parameters:
// struct FForceFeedbackAttenuationSettings OutAttenuationSettings         (CPF_Parm, CPF_OutParm)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UForceFeedbackComponent::BP_GetAttenuationSettingsToApply(struct FForceFeedbackAttenuationSettings* OutAttenuationSettings)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ForceFeedbackComponent.BP_GetAttenuationSettingsToApply");

	struct
	{
		struct FForceFeedbackAttenuationSettings OutAttenuationSettings;
		bool                           ReturnValue;
	} params;


	UObject::ProcessEvent(fn, &params);

	if (OutAttenuationSettings != nullptr)
		*OutAttenuationSettings = params.OutAttenuationSettings;

	return params.ReturnValue;
}


// Function Engine.ForceFeedbackComponent.AdjustAttenuation
// (FUNC_Final, FUNC_Native, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// struct FForceFeedbackAttenuationSettings InAttenuationSettings          (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm)

void UForceFeedbackComponent::AdjustAttenuation(const struct FForceFeedbackAttenuationSettings& InAttenuationSettings)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.ForceFeedbackComponent.AdjustAttenuation");

	struct
	{
		struct FForceFeedbackAttenuationSettings InAttenuationSettings;
	} params;

	params.InAttenuationSettings = InAttenuationSettings;

	UObject::ProcessEvent(fn, &params);
}


// Function Engine.GameplayStatics.UnloadStreamLevel
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UObject*                 WorldContextObject             (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FName                   LevelName                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FLatentActionInfo       LatentInfo                     (CPF_Parm)

void UGameplayStatics::UnloadStreamLevel(class UObject* WorldContextObject, const struct FName& LevelName, const struct FLatentActionInfo& LatentInfo)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameplayStatics.UnloadStreamLevel");

	struct
	{
		class UObject*                 WorldContextObject;
		struct FName                   LevelName;
		struct FLatentActionInfo       LatentInfo;
	} params;

	params.WorldContextObject = WorldContextObject;
	params.LevelName = LevelName;
	params.LatentInfo = LatentInfo;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);
}


// Function Engine.GameplayStatics.SuggestProjectileVelocity_CustomArc
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UObject*                 WorldContextObject             (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 OutLaunchVelocity              (CPF_Parm, CPF_OutParm, CPF_IsPlainOldData)
// struct FVector                 StartPos                       (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 EndPos                         (CPF_Parm, CPF_IsPlainOldData)
// float                          OverrideGravityZ               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          ArcParam                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

bool UGameplayStatics::SuggestProjectileVelocity_CustomArc(class UObject* WorldContextObject, const struct FVector& StartPos, const struct FVector& EndPos, float OverrideGravityZ, float ArcParam, struct FVector* OutLaunchVelocity)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameplayStatics.SuggestProjectileVelocity_CustomArc");

	struct
	{
		class UObject*                 WorldContextObject;
		struct FVector                 OutLaunchVelocity;
		struct FVector                 StartPos;
		struct FVector                 EndPos;
		float                          OverrideGravityZ;
		float                          ArcParam;
		bool                           ReturnValue;
	} params;

	params.WorldContextObject = WorldContextObject;
	params.StartPos = StartPos;
	params.EndPos = EndPos;
	params.OverrideGravityZ = OverrideGravityZ;
	params.ArcParam = ArcParam;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	if (OutLaunchVelocity != nullptr)
		*OutLaunchVelocity = params.OutLaunchVelocity;

	return params.ReturnValue;
}


// Function Engine.GameplayStatics.SpawnSoundAttached
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class USoundBase*              Sound                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class USceneComponent*         AttachToComponent              (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FName                   AttachPointName                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 Location                       (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                Rotation                       (CPF_Parm, CPF_IsPlainOldData)
// TEnumAsByte<EAttachLocation>   LocationType                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bStopWhenAttachedToDestroyed   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          VolumeMultiplier               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          PitchMultiplier                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          StartTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class USoundAttenuation*       AttenuationSettings            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class USoundConcurrency*       ConcurrencySettings            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAutoDestroy                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UAudioComponent*         ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_InstancedReference, CPF_IsPlainOldData)

class UAudioComponent* UGameplayStatics::SpawnSoundAttached(class USoundBase* Sound, class USceneComponent* AttachToComponent, const struct FName& AttachPointName, const struct FVector& Location, const struct FRotator& Rotation, TEnumAsByte<EAttachLocation> LocationType, bool bStopWhenAttachedToDestroyed, float VolumeMultiplier, float PitchMultiplier, float StartTime, class USoundAttenuation* AttenuationSettings, class USoundConcurrency* ConcurrencySettings, bool bAutoDestroy)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameplayStatics.SpawnSoundAttached");

	struct
	{
		class USoundBase*              Sound;
		class USceneComponent*         AttachToComponent;
		struct FName                   AttachPointName;
		struct FVector                 Location;
		struct FRotator                Rotation;
		TEnumAsByte<EAttachLocation>   LocationType;
		bool                           bStopWhenAttachedToDestroyed;
		float                          VolumeMultiplier;
		float                          PitchMultiplier;
		float                          StartTime;
		class USoundAttenuation*       AttenuationSettings;
		class USoundConcurrency*       ConcurrencySettings;
		bool                           bAutoDestroy;
		class UAudioComponent*         ReturnValue;
	} params;

	params.Sound = Sound;
	params.AttachToComponent = AttachToComponent;
	params.AttachPointName = AttachPointName;
	params.Location = Location;
	params.Rotation = Rotation;
	params.LocationType = LocationType;
	params.bStopWhenAttachedToDestroyed = bStopWhenAttachedToDestroyed;
	params.VolumeMultiplier = VolumeMultiplier;
	params.PitchMultiplier = PitchMultiplier;
	params.StartTime = StartTime;
	params.AttenuationSettings = AttenuationSettings;
	params.ConcurrencySettings = ConcurrencySettings;
	params.bAutoDestroy = bAutoDestroy;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameplayStatics.SpawnSoundAtLocation
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UObject*                 WorldContextObject             (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class USoundBase*              Sound                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 Location                       (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                Rotation                       (CPF_Parm, CPF_IsPlainOldData)
// float                          VolumeMultiplier               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          PitchMultiplier                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          StartTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class USoundAttenuation*       AttenuationSettings            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class USoundConcurrency*       ConcurrencySettings            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAutoDestroy                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UAudioComponent*         ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_InstancedReference, CPF_IsPlainOldData)

class UAudioComponent* UGameplayStatics::SpawnSoundAtLocation(class UObject* WorldContextObject, class USoundBase* Sound, const struct FVector& Location, const struct FRotator& Rotation, float VolumeMultiplier, float PitchMultiplier, float StartTime, class USoundAttenuation* AttenuationSettings, class USoundConcurrency* ConcurrencySettings, bool bAutoDestroy)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameplayStatics.SpawnSoundAtLocation");

	struct
	{
		class UObject*                 WorldContextObject;
		class USoundBase*              Sound;
		struct FVector                 Location;
		struct FRotator                Rotation;
		float                          VolumeMultiplier;
		float                          PitchMultiplier;
		float                          StartTime;
		class USoundAttenuation*       AttenuationSettings;
		class USoundConcurrency*       ConcurrencySettings;
		bool                           bAutoDestroy;
		class UAudioComponent*         ReturnValue;
	} params;

	params.WorldContextObject = WorldContextObject;
	params.Sound = Sound;
	params.Location = Location;
	params.Rotation = Rotation;
	params.VolumeMultiplier = VolumeMultiplier;
	params.PitchMultiplier = PitchMultiplier;
	params.StartTime = StartTime;
	params.AttenuationSettings = AttenuationSettings;
	params.ConcurrencySettings = ConcurrencySettings;
	params.bAutoDestroy = bAutoDestroy;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameplayStatics.SpawnSound2D
// (FUNC_Final, FUNC_BlueprintCosmetic, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UObject*                 WorldContextObject             (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class USoundBase*              Sound                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          VolumeMultiplier               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          PitchMultiplier                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          StartTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class USoundConcurrency*       ConcurrencySettings            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bPersistAcrossLevelTransition  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAutoDestroy                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UAudioComponent*         ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_InstancedReference, CPF_IsPlainOldData)

class UAudioComponent* UGameplayStatics::SpawnSound2D(class UObject* WorldContextObject, class USoundBase* Sound, float VolumeMultiplier, float PitchMultiplier, float StartTime, class USoundConcurrency* ConcurrencySettings, bool bPersistAcrossLevelTransition, bool bAutoDestroy)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameplayStatics.SpawnSound2D");

	struct
	{
		class UObject*                 WorldContextObject;
		class USoundBase*              Sound;
		float                          VolumeMultiplier;
		float                          PitchMultiplier;
		float                          StartTime;
		class USoundConcurrency*       ConcurrencySettings;
		bool                           bPersistAcrossLevelTransition;
		bool                           bAutoDestroy;
		class UAudioComponent*         ReturnValue;
	} params;

	params.WorldContextObject = WorldContextObject;
	params.Sound = Sound;
	params.VolumeMultiplier = VolumeMultiplier;
	params.PitchMultiplier = PitchMultiplier;
	params.StartTime = StartTime;
	params.ConcurrencySettings = ConcurrencySettings;
	params.bPersistAcrossLevelTransition = bPersistAcrossLevelTransition;
	params.bAutoDestroy = bAutoDestroy;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameplayStatics.SpawnObject
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_BlueprintCallable)
// Parameters:
// class UClass*                  ObjectClass                    (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UObject*                 Outer                          (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UObject*                 ReturnValue                    (CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_IsPlainOldData)

class UObject* UGameplayStatics::SpawnObject(class UClass* ObjectClass, class UObject* Outer)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameplayStatics.SpawnObject");

	struct
	{
		class UClass*                  ObjectClass;
		class UObject*                 Outer;
		class UObject*                 ReturnValue;
	} params;

	params.ObjectClass = ObjectClass;
	params.Outer = Outer;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameplayStatics.SpawnForceFeedbackAttached
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UForceFeedbackEffect*    ForceFeedbackEffect            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class USceneComponent*         AttachToComponent              (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FName                   AttachPointName                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 Location                       (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                Rotation                       (CPF_Parm, CPF_IsPlainOldData)
// TEnumAsByte<EAttachLocation>   LocationType                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bStopWhenAttachedToDestroyed   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bLooping                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          IntensityMultiplier            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          StartTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UForceFeedbackAttenuation* AttenuationSettings            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAutoDestroy                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UForceFeedbackComponent* ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_InstancedReference, CPF_IsPlainOldData)

class UForceFeedbackComponent* UGameplayStatics::SpawnForceFeedbackAttached(class UForceFeedbackEffect* ForceFeedbackEffect, class USceneComponent* AttachToComponent, const struct FName& AttachPointName, const struct FVector& Location, const struct FRotator& Rotation, TEnumAsByte<EAttachLocation> LocationType, bool bStopWhenAttachedToDestroyed, bool bLooping, float IntensityMultiplier, float StartTime, class UForceFeedbackAttenuation* AttenuationSettings, bool bAutoDestroy)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameplayStatics.SpawnForceFeedbackAttached");

	struct
	{
		class UForceFeedbackEffect*    ForceFeedbackEffect;
		class USceneComponent*         AttachToComponent;
		struct FName                   AttachPointName;
		struct FVector                 Location;
		struct FRotator                Rotation;
		TEnumAsByte<EAttachLocation>   LocationType;
		bool                           bStopWhenAttachedToDestroyed;
		bool                           bLooping;
		float                          IntensityMultiplier;
		float                          StartTime;
		class UForceFeedbackAttenuation* AttenuationSettings;
		bool                           bAutoDestroy;
		class UForceFeedbackComponent* ReturnValue;
	} params;

	params.ForceFeedbackEffect = ForceFeedbackEffect;
	params.AttachToComponent = AttachToComponent;
	params.AttachPointName = AttachPointName;
	params.Location = Location;
	params.Rotation = Rotation;
	params.LocationType = LocationType;
	params.bStopWhenAttachedToDestroyed = bStopWhenAttachedToDestroyed;
	params.bLooping = bLooping;
	params.IntensityMultiplier = IntensityMultiplier;
	params.StartTime = StartTime;
	params.AttenuationSettings = AttenuationSettings;
	params.bAutoDestroy = bAutoDestroy;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameplayStatics.SpawnForceFeedbackAtLocation
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UObject*                 WorldContextObject             (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UForceFeedbackEffect*    ForceFeedbackEffect            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 Location                       (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                Rotation                       (CPF_Parm, CPF_IsPlainOldData)
// bool                           bLooping                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          IntensityMultiplier            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          StartTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UForceFeedbackAttenuation* AttenuationSettings            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAutoDestroy                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UForceFeedbackComponent* ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_InstancedReference, CPF_IsPlainOldData)

class UForceFeedbackComponent* UGameplayStatics::SpawnForceFeedbackAtLocation(class UObject* WorldContextObject, class UForceFeedbackEffect* ForceFeedbackEffect, const struct FVector& Location, const struct FRotator& Rotation, bool bLooping, float IntensityMultiplier, float StartTime, class UForceFeedbackAttenuation* AttenuationSettings, bool bAutoDestroy)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameplayStatics.SpawnForceFeedbackAtLocation");

	struct
	{
		class UObject*                 WorldContextObject;
		class UForceFeedbackEffect*    ForceFeedbackEffect;
		struct FVector                 Location;
		struct FRotator                Rotation;
		bool                           bLooping;
		float                          IntensityMultiplier;
		float                          StartTime;
		class UForceFeedbackAttenuation* AttenuationSettings;
		bool                           bAutoDestroy;
		class UForceFeedbackComponent* ReturnValue;
	} params;

	params.WorldContextObject = WorldContextObject;
	params.ForceFeedbackEffect = ForceFeedbackEffect;
	params.Location = Location;
	params.Rotation = Rotation;
	params.bLooping = bLooping;
	params.IntensityMultiplier = IntensityMultiplier;
	params.StartTime = StartTime;
	params.AttenuationSettings = AttenuationSettings;
	params.bAutoDestroy = bAutoDestroy;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameplayStatics.SpawnEmitterAttached
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UParticleSystem*         EmitterTemplate                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class USceneComponent*         AttachToComponent              (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FName                   AttachPointName                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 Location                       (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                Rotation                       (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 Scale                          (CPF_Parm, CPF_IsPlainOldData)
// TEnumAsByte<EAttachLocation>   LocationType                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAutoDestroy                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UParticleSystemComponent* ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_InstancedReference, CPF_IsPlainOldData)

class UParticleSystemComponent* UGameplayStatics::SpawnEmitterAttached(class UParticleSystem* EmitterTemplate, class USceneComponent* AttachToComponent, const struct FName& AttachPointName, const struct FVector& Location, const struct FRotator& Rotation, const struct FVector& Scale, TEnumAsByte<EAttachLocation> LocationType, bool bAutoDestroy)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameplayStatics.SpawnEmitterAttached");

	struct
	{
		class UParticleSystem*         EmitterTemplate;
		class USceneComponent*         AttachToComponent;
		struct FName                   AttachPointName;
		struct FVector                 Location;
		struct FRotator                Rotation;
		struct FVector                 Scale;
		TEnumAsByte<EAttachLocation>   LocationType;
		bool                           bAutoDestroy;
		class UParticleSystemComponent* ReturnValue;
	} params;

	params.EmitterTemplate = EmitterTemplate;
	params.AttachToComponent = AttachToComponent;
	params.AttachPointName = AttachPointName;
	params.Location = Location;
	params.Rotation = Rotation;
	params.Scale = Scale;
	params.LocationType = LocationType;
	params.bAutoDestroy = bAutoDestroy;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameplayStatics.SpawnEmitterAtLocation
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UObject*                 WorldContextObject             (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UParticleSystem*         EmitterTemplate                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 Location                       (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                Rotation                       (CPF_Parm, CPF_IsPlainOldData)
// struct FVector                 Scale                          (CPF_Parm, CPF_IsPlainOldData)
// bool                           bAutoDestroy                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UParticleSystemComponent* ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_InstancedReference, CPF_IsPlainOldData)

class UParticleSystemComponent* UGameplayStatics::SpawnEmitterAtLocation(class UObject* WorldContextObject, class UParticleSystem* EmitterTemplate, const struct FVector& Location, const struct FRotator& Rotation, const struct FVector& Scale, bool bAutoDestroy)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameplayStatics.SpawnEmitterAtLocation");

	struct
	{
		class UObject*                 WorldContextObject;
		class UParticleSystem*         EmitterTemplate;
		struct FVector                 Location;
		struct FRotator                Rotation;
		struct FVector                 Scale;
		bool                           bAutoDestroy;
		class UParticleSystemComponent* ReturnValue;
	} params;

	params.WorldContextObject = WorldContextObject;
	params.EmitterTemplate = EmitterTemplate;
	params.Location = Location;
	params.Rotation = Rotation;
	params.Scale = Scale;
	params.bAutoDestroy = bAutoDestroy;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameplayStatics.SpawnDialogueAttached
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UDialogueWave*           Dialogue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FDialogueContext        Context                        (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm)
// class USceneComponent*         AttachToComponent              (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FName                   AttachPointName                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 Location                       (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                Rotation                       (CPF_Parm, CPF_IsPlainOldData)
// TEnumAsByte<EAttachLocation>   LocationType                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bStopWhenAttachedToDestroyed   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          VolumeMultiplier               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          PitchMultiplier                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          StartTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class USoundAttenuation*       AttenuationSettings            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAutoDestroy                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UAudioComponent*         ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_InstancedReference, CPF_IsPlainOldData)

class UAudioComponent* UGameplayStatics::SpawnDialogueAttached(class UDialogueWave* Dialogue, const struct FDialogueContext& Context, class USceneComponent* AttachToComponent, const struct FName& AttachPointName, const struct FVector& Location, const struct FRotator& Rotation, TEnumAsByte<EAttachLocation> LocationType, bool bStopWhenAttachedToDestroyed, float VolumeMultiplier, float PitchMultiplier, float StartTime, class USoundAttenuation* AttenuationSettings, bool bAutoDestroy)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameplayStatics.SpawnDialogueAttached");

	struct
	{
		class UDialogueWave*           Dialogue;
		struct FDialogueContext        Context;
		class USceneComponent*         AttachToComponent;
		struct FName                   AttachPointName;
		struct FVector                 Location;
		struct FRotator                Rotation;
		TEnumAsByte<EAttachLocation>   LocationType;
		bool                           bStopWhenAttachedToDestroyed;
		float                          VolumeMultiplier;
		float                          PitchMultiplier;
		float                          StartTime;
		class USoundAttenuation*       AttenuationSettings;
		bool                           bAutoDestroy;
		class UAudioComponent*         ReturnValue;
	} params;

	params.Dialogue = Dialogue;
	params.Context = Context;
	params.AttachToComponent = AttachToComponent;
	params.AttachPointName = AttachPointName;
	params.Location = Location;
	params.Rotation = Rotation;
	params.LocationType = LocationType;
	params.bStopWhenAttachedToDestroyed = bStopWhenAttachedToDestroyed;
	params.VolumeMultiplier = VolumeMultiplier;
	params.PitchMultiplier = PitchMultiplier;
	params.StartTime = StartTime;
	params.AttenuationSettings = AttenuationSettings;
	params.bAutoDestroy = bAutoDestroy;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameplayStatics.SpawnDialogueAtLocation
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UObject*                 WorldContextObject             (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UDialogueWave*           Dialogue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FDialogueContext        Context                        (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm)
// struct FVector                 Location                       (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                Rotation                       (CPF_Parm, CPF_IsPlainOldData)
// float                          VolumeMultiplier               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          PitchMultiplier                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          StartTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class USoundAttenuation*       AttenuationSettings            (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAutoDestroy                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UAudioComponent*         ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_InstancedReference, CPF_IsPlainOldData)

class UAudioComponent* UGameplayStatics::SpawnDialogueAtLocation(class UObject* WorldContextObject, class UDialogueWave* Dialogue, const struct FDialogueContext& Context, const struct FVector& Location, const struct FRotator& Rotation, float VolumeMultiplier, float PitchMultiplier, float StartTime, class USoundAttenuation* AttenuationSettings, bool bAutoDestroy)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameplayStatics.SpawnDialogueAtLocation");

	struct
	{
		class UObject*                 WorldContextObject;
		class UDialogueWave*           Dialogue;
		struct FDialogueContext        Context;
		struct FVector                 Location;
		struct FRotator                Rotation;
		float                          VolumeMultiplier;
		float                          PitchMultiplier;
		float                          StartTime;
		class USoundAttenuation*       AttenuationSettings;
		bool                           bAutoDestroy;
		class UAudioComponent*         ReturnValue;
	} params;

	params.WorldContextObject = WorldContextObject;
	params.Dialogue = Dialogue;
	params.Context = Context;
	params.Location = Location;
	params.Rotation = Rotation;
	params.VolumeMultiplier = VolumeMultiplier;
	params.PitchMultiplier = PitchMultiplier;
	params.StartTime = StartTime;
	params.AttenuationSettings = AttenuationSettings;
	params.bAutoDestroy = bAutoDestroy;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameplayStatics.SpawnDialogue2D
// (FUNC_Final, FUNC_BlueprintCosmetic, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasOutParms, FUNC_BlueprintCallable)
// Parameters:
// class UObject*                 WorldContextObject             (CPF_ConstParm, CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UDialogueWave*           Dialogue                       (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FDialogueContext        Context                        (CPF_ConstParm, CPF_Parm, CPF_OutParm, CPF_ReferenceParm)
// float                          VolumeMultiplier               (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          PitchMultiplier                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// float                          StartTime                      (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// bool                           bAutoDestroy                   (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// class UAudioComponent*         ReturnValue                    (CPF_ExportObject, CPF_Parm, CPF_OutParm, CPF_ZeroConstructor, CPF_ReturnParm, CPF_InstancedReference, CPF_IsPlainOldData)

class UAudioComponent* UGameplayStatics::SpawnDialogue2D(class UObject* WorldContextObject, class UDialogueWave* Dialogue, const struct FDialogueContext& Context, float VolumeMultiplier, float PitchMultiplier, float StartTime, bool bAutoDestroy)
{
	static auto fn = UObject::FindObject<UFunction>("Function Engine.GameplayStatics.SpawnDialogue2D");

	struct
	{
		class UObject*                 WorldContextObject;
		class UDialogueWave*           Dialogue;
		struct FDialogueContext        Context;
		float                          VolumeMultiplier;
		float                          PitchMultiplier;
		float                          StartTime;
		bool                           bAutoDestroy;
		class UAudioComponent*         ReturnValue;
	} params;

	params.WorldContextObject = WorldContextObject;
	params.Dialogue = Dialogue;
	params.Context = Context;
	params.VolumeMultiplier = VolumeMultiplier;
	params.PitchMultiplier = PitchMultiplier;
	params.StartTime = StartTime;
	params.bAutoDestroy = bAutoDestroy;

	static auto defaultObj = StaticClass()->CreateDefaultObject();
	defaultObj->ProcessEvent(fn, &params);

	return params.ReturnValue;
}


// Function Engine.GameplayStatics.SpawnDecalAttached
// (FUNC_Final, FUNC_Native, FUNC_Static, FUNC_Public, FUNC_HasDefaults, FUNC_BlueprintCallable)
// Parameters:
// class UMaterialInterface*      DecalMaterial                  (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 DecalSize                      (CPF_Parm, CPF_IsPlainOldData)
// class USceneComponent*         AttachToComponent              (CPF_Parm, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
// struct FName                   AttachPointName                (CPF_Parm, CPF_ZeroConstructor, CPF_IsPlainOldData)
// struct FVector                 Location                       (CPF_Parm, CPF_IsPlainOldData)
// struct FRotator                Rotation          