#pragma once

// SCUM (0.1.17) SDK

#ifdef _MSC_VER
	#pragma pack(push, 0x8)
#endif

#include "SCUM_Engine_structs.hpp"

namespace SDK
{
//---------------------------------------------------------------------------
//Classes
//---------------------------------------------------------------------------

// Class Engine.Actor
// 0x02F0 (0x0318 - 0x0028)
class AActor : public UObject
{
public:
	struct FActorTickFunction                          PrimaryActorTick;                                         // 0x0028(0x0058) (CPF_Edit, CPF_DisableEditOnInstance)
	unsigned char                                      bHidden : 1;                                              // 0x0080(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Net)
	unsigned char                                      bNetTemporary : 1;                                        // 0x0080(0x0001)
	unsigned char                                      bNetStartup : 1;                                          // 0x0080(0x0001)
	unsigned char                                      bOnlyRelevantToOwner : 1;                                 // 0x0080(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_DisableEditOnInstance)
	unsigned char                                      bAlwaysRelevant : 1;                                      // 0x0080(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_DisableEditOnInstance)
	unsigned char                                      bReplicateMovement : 1;                                   // 0x0080(0x0001) (CPF_Edit, CPF_Net, CPF_DisableEditOnInstance)
	unsigned char                                      bTearOff : 1;                                             // 0x0080(0x0001) (CPF_Net)
	unsigned char                                      bExchangedRoles : 1;                                      // 0x0080(0x0001) (CPF_Transient)
	unsigned char                                      bNetLoadOnClient : 1;                                     // 0x0081(0x0001) (CPF_Edit, CPF_DisableEditOnInstance)
	unsigned char                                      bNetUseOwnerRelevancy : 1;                                // 0x0081(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_DisableEditOnInstance)
	unsigned char                                      bRelevantForNetworkReplays : 1;                           // 0x0081(0x0001)
	unsigned char                                      bAllowTickBeforeBeginPlay : 1;                            // 0x0081(0x0001) (CPF_Edit, CPF_DisableEditOnInstance)
	unsigned char                                      bAutoDestroyWhenFinished : 1;                             // 0x0081(0x0001) (CPF_BlueprintVisible)
	unsigned char                                      bBlockInput : 1;                                          // 0x0081(0x0001) (CPF_Edit, CPF_DisableEditOnInstance)
	unsigned char                                      bCanBeDamaged : 1;                                        // 0x0081(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_Net, CPF_SaveGame)
	unsigned char                                      bCollideWhenPlacing : 1;                                  // 0x0081(0x0001)
	unsigned char                                      bFindCameraComponentWhenViewTarget : 1;                   // 0x0082(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bGenerateOverlapEventsDuringLevelStreaming : 1;           // 0x0082(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bIgnoresOriginShifting : 1;                               // 0x0082(0x0001) (CPF_Edit)
	unsigned char                                      bEnableAutoLODGeneration : 1;                             // 0x0082(0x0001) (CPF_Edit)
	unsigned char                                      bActorSeamlessTraveled : 1;                               // 0x0082(0x0001)
	unsigned char                                      bReplicates : 1;                                          // 0x0082(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_DisableEditOnInstance)
	unsigned char                                      bCanBeInCluster : 1;                                      // 0x0082(0x0001) (CPF_Edit)
	unsigned char                                      bAllowReceiveTickEventOnDedicatedServer : 1;              // 0x0082(0x0001)
	unsigned char                                      UnknownData00 : 5;                                        // 0x0083(0x0001)
	unsigned char                                      bActorEnableCollision : 1;                                // 0x0083(0x0001)
	unsigned char                                      bActorIsBeingDestroyed : 1;                               // 0x0083(0x0001) (CPF_Transient, CPF_DuplicateTransient)
	unsigned char                                      UnknownData01[0x1];                                       // 0x0084(0x0001) MISSED OFFSET
	TEnumAsByte<ENetRole>                              RemoteRole;                                               // 0x0085(0x0001) (CPF_Net, CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x2];                                       // 0x0086(0x0002) MISSED OFFSET
	struct FRepMovement                                ReplicatedMovement;                                       // 0x0088(0x0034) (CPF_Edit, CPF_Net, CPF_DisableEditOnInstance)
	float                                              InitialLifeSpan;                                          // 0x00BC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              CustomTimeDilation;                                       // 0x00C0(0x0004) (CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0x4];                                       // 0x00C4(0x0004) MISSED OFFSET
	struct FRepAttachment                              AttachmentReplication;                                    // 0x00C8(0x0040) (CPF_Net, CPF_Transient)
	class AActor*                                      Owner;                                                    // 0x0108(0x0008) (CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FName                                       NetDriverName;                                            // 0x0110(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ENetRole>                              Role;                                                     // 0x0118(0x0001) (CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ENetDormancy>                          NetDormancy;                                              // 0x0119(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	ESpawnActorCollisionHandlingMethod                 SpawnCollisionHandlingMethod;                             // 0x011A(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EAutoReceiveInput>                     AutoReceiveInput;                                         // 0x011B(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                InputPriority;                                            // 0x011C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UInputComponent*                             InputComponent;                                           // 0x0120(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	float                                              NetCullDistanceSquared;                                   // 0x0128(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	int                                                NetTag;                                                   // 0x012C(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              NetUpdateFrequency;                                       // 0x0130(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	float                                              MinNetUpdateFrequency;                                    // 0x0134(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	float                                              NetPriority;                                              // 0x0138(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	unsigned char                                      UnknownData04[0x4];                                       // 0x013C(0x0004) MISSED OFFSET
	class APawn*                                       Instigator;                                               // 0x0140(0x0008) (CPF_BlueprintVisible, CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<class AActor*>                              Children;                                                 // 0x0148(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	class USceneComponent*                             RootComponent;                                            // 0x0158(0x0008) (CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	TArray<class AMatineeActor*>                       ControllingMatineeActors;                                 // 0x0160(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	unsigned char                                      UnknownData05[0x8];                                       // 0x0170(0x0008) MISSED OFFSET
	TArray<struct FName>                               Layers;                                                   // 0x0178(0x0010) (CPF_ZeroConstructor)
	TWeakObjectPtr<class UChildActorComponent>         ParentComponent;                                          // 0x0188(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	TArray<struct FName>                               Tags;                                                     // 0x0190(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor)
	struct FScriptMulticastDelegate                    OnTakeAnyDamage;                                          // 0x01A0(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnTakePointDamage;                                        // 0x01B0(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnActorBeginOverlap;                                      // 0x01C0(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnActorEndOverlap;                                        // 0x01D0(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnBeginCursorOver;                                        // 0x01E0(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnEndCursorOver;                                          // 0x01F0(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnClicked;                                                // 0x0200(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnReleased;                                               // 0x0210(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnInputTouchBegin;                                        // 0x0220(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnInputTouchEnd;                                          // 0x0230(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnInputTouchEnter;                                        // 0x0240(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnInputTouchLeave;                                        // 0x0250(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnActorHit;                                               // 0x0260(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnDestroyed;                                              // 0x0270(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnEndPlay;                                                // 0x0280(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	unsigned char                                      UnknownData06[0x60];                                      // 0x0290(0x0060) MISSED OFFSET
	TArray<class UActorComponent*>                     InstanceComponents;                                       // 0x02F0(0x0010) (CPF_ExportObject, CPF_ZeroConstructor)
	TArray<class UActorComponent*>                     BlueprintCreatedComponents;                               // 0x0300(0x0010) (CPF_ExportObject, CPF_ZeroConstructor)
	unsigned char                                      UnknownData07[0x8];                                       // 0x0310(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Actor");
		return ptr;
	}


	bool WasRecentlyRendered(float Tolerance);
	void UserConstructionScript();
	void TearOff();
	void SnapRootComponentTo(class AActor* InParentActor, const struct FName& InSocketName);
	void SetTickGroup(TEnumAsByte<ETickingGroup> NewTickGroup);
	void SetTickableWhenPaused(bool bTickableWhenPaused);
	void SetReplicates(bool bInReplicates);
	void SetReplicateMovement(bool bInReplicateMovement);
	void SetOwner(class AActor* NewOwner);
	void SetNetDormancy(TEnumAsByte<ENetDormancy> NewDormancy);
	void SetLifeSpan(float InLifespan);
	void SetActorTickInterval(float TickInterval);
	void SetActorTickEnabled(bool bEnabled);
	void SetActorScale3D(const struct FVector& NewScale3D);
	void SetActorRelativeScale3D(const struct FVector& NewRelativeScale);
	void SetActorHiddenInGame(bool bNewHidden);
	void SetActorEnableCollision(bool bNewActorEnableCollision);
	void RemoveTickPrerequisiteComponent(class UActorComponent* PrerequisiteComponent);
	void RemoveTickPrerequisiteActor(class AActor* PrerequisiteActor);
	void ReceiveTick(float DeltaSeconds);
	void ReceiveRadialDamage(float DamageReceived, class UDamageType* DamageType, const struct FVector& Origin, const struct FHitResult& HitInfo, class AController* InstigatedBy, class AActor* DamageCauser);
	void ReceivePointDamage(float Damage, class UDamageType* DamageType, const struct FVector& HitLocation, const struct FVector& HitNormal, class UPrimitiveComponent* HitComponent, const struct FName& BoneName, const struct FVector& ShotFromDirection, class AController* InstigatedBy, class AActor* DamageCauser, const struct FHitResult& HitInfo);
	void ReceiveHit(class UPrimitiveComponent* MyComp, class AActor* Other, class UPrimitiveComponent* OtherComp, bool bSelfMoved, const struct FVector& HitLocation, const struct FVector& HitNormal, const struct FVector& NormalImpulse, const struct FHitResult& Hit);
	void ReceiveEndPlay(TEnumAsByte<EEndPlayReason> EndPlayReason);
	void ReceiveDestroyed();
	void ReceiveBeginPlay();
	void ReceiveAnyDamage(float Damage, class UDamageType* DamageType, class AController* InstigatedBy, class AActor* DamageCauser);
	void ReceiveActorOnReleased(const struct FKey& ButtonReleased);
	void ReceiveActorOnInputTouchLeave(TEnumAsByte<ETouchIndex> FingerIndex);
	void ReceiveActorOnInputTouchEnter(TEnumAsByte<ETouchIndex> FingerIndex);
	void ReceiveActorOnInputTouchEnd(TEnumAsByte<ETouchIndex> FingerIndex);
	void ReceiveActorOnInputTouchBegin(TEnumAsByte<ETouchIndex> FingerIndex);
	void ReceiveActorOnClicked(const struct FKey& ButtonPressed);
	void ReceiveActorEndOverlap(class AActor* OtherActor);
	void ReceiveActorEndCursorOver();
	void ReceiveActorBeginOverlap(class AActor* OtherActor);
	void ReceiveActorBeginCursorOver();
	void PrestreamTextures(float Seconds, bool bEnableStreaming, int CinematicTextureGroups);
	void OnRep_ReplicateMovement();
	void OnRep_ReplicatedMovement();
	void OnRep_Owner();
	void OnRep_Instigator();
	void OnRep_AttachmentReplication();
	void MakeNoise(float Loudness, class APawn* NoiseInstigator, const struct FVector& NoiseLocation, float MaxRange, const struct FName& Tag);
	class UMaterialInstanceDynamic* MakeMIDForMaterial(class UMaterialInterface* Parent);
	bool K2_TeleportTo(const struct FVector& DestLocation, const struct FRotator& DestRotation);
	bool K2_SetActorTransform(const struct FTransform& NewTransform, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	bool K2_SetActorRotation(const struct FRotator& NewRotation, bool bTeleportPhysics);
	void K2_SetActorRelativeTransform(const struct FTransform& NewRelativeTransform, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_SetActorRelativeRotation(const struct FRotator& NewRelativeRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_SetActorRelativeLocation(const struct FVector& NewRelativeLocation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	bool K2_SetActorLocationAndRotation(const struct FVector& NewLocation, const struct FRotator& NewRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	bool K2_SetActorLocation(const struct FVector& NewLocation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_OnReset();
	void K2_OnEndViewTarget(class APlayerController* PC);
	void K2_OnBecomeViewTarget(class APlayerController* PC);
	class USceneComponent* K2_GetRootComponent();
	struct FRotator K2_GetActorRotation();
	struct FVector K2_GetActorLocation();
	void K2_DetachFromActor(EDetachmentRule LocationRule, EDetachmentRule RotationRule, EDetachmentRule ScaleRule);
	void K2_DestroyComponent(class UActorComponent* Component);
	void K2_DestroyActor();
	void K2_AttachToComponent(class USceneComponent* Parent, const struct FName& SocketName, EAttachmentRule LocationRule, EAttachmentRule RotationRule, EAttachmentRule ScaleRule, bool bWeldSimulatedBodies);
	void K2_AttachToActor(class AActor* ParentActor, const struct FName& SocketName, EAttachmentRule LocationRule, EAttachmentRule RotationRule, EAttachmentRule ScaleRule, bool bWeldSimulatedBodies);
	void K2_AttachRootComponentToActor(class AActor* InParentActor, const struct FName& InSocketName, TEnumAsByte<EAttachLocation> AttachLocationType, bool bWeldSimulatedBodies);
	void K2_AttachRootComponentTo(class USceneComponent* InParent, const struct FName& InSocketName, TEnumAsByte<EAttachLocation> AttachLocationType, bool bWeldSimulatedBodies);
	void K2_AddActorWorldTransform(const struct FTransform& DeltaTransform, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_AddActorWorldRotation(const struct FRotator& DeltaRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_AddActorWorldOffset(const struct FVector& DeltaLocation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_AddActorLocalTransform(const struct FTransform& NewTransform, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_AddActorLocalRotation(const struct FRotator& DeltaRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_AddActorLocalOffset(const struct FVector& DeltaLocation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	bool IsOverlappingActor(class AActor* Other);
	bool IsChildActor();
	bool IsActorTickEnabled();
	bool IsActorBeingDestroyed();
	bool HasAuthority();
	float GetVerticalDistanceTo(class AActor* OtherActor);
	struct FVector GetVelocity();
	struct FTransform GetTransform();
	bool GetTickableWhenPaused();
	float GetSquaredDistanceTo(class AActor* OtherActor);
	TEnumAsByte<ENetRole> GetRemoteRole();
	class UChildActorComponent* GetParentComponent();
	class AActor* GetParentActor();
	class AActor* GetOwner();
	void GetOverlappingComponents(TArray<class UPrimitiveComponent*>* OverlappingComponents);
	void GetOverlappingActors(class UClass* ClassFilter, TArray<class AActor*>* OverlappingActors);
	float GetLifeSpan();
	class AController* GetInstigatorController();
	class APawn* GetInstigator();
	struct FVector GetInputVectorAxisValue(const struct FKey& InputAxisKey);
	float GetInputAxisValue(const struct FName& InputAxisName);
	float GetInputAxisKeyValue(const struct FKey& InputAxisKey);
	float GetHorizontalDotProductTo(class AActor* OtherActor);
	float GetHorizontalDistanceTo(class AActor* OtherActor);
	float GetGameTimeSinceCreation();
	float GetDotProductTo(class AActor* OtherActor);
	float GetDistanceTo(class AActor* OtherActor);
	TArray<class UActorComponent*> GetComponentsByTag(class UClass* ComponentClass, const struct FName& Tag);
	TArray<class UActorComponent*> GetComponentsByClass(class UClass* ComponentClass);
	class UActorComponent* GetComponentByClass(class UClass* ComponentClass);
	struct FName GetAttachParentSocketName();
	class AActor* GetAttachParentActor();
	void GetAttachedActors(TArray<class AActor*>* OutActors);
	void GetAllChildActors(bool bIncludeDescendants, TArray<class AActor*>* ChildActors);
	struct FVector GetActorUpVector();
	float GetActorTimeDilation();
	float GetActorTickInterval();
	struct FVector GetActorScale3D();
	struct FVector GetActorRightVector();
	struct FVector GetActorRelativeScale3D();
	struct FVector GetActorForwardVector();
	void GetActorEyesViewPoint(struct FVector* OutLocation, struct FRotator* OutRotation);
	bool GetActorEnableCollision();
	void GetActorBounds(bool bOnlyCollidingComponents, struct FVector* Origin, struct FVector* BoxExtent);
	void ForceNetUpdate();
	void FlushNetDormancy();
	void EnableInput(class APlayerController* PlayerController);
	void DisableInput(class APlayerController* PlayerController);
	void DetachRootComponentFromParent(bool bMaintainWorldPosition);
	void AddTickPrerequisiteComponent(class UActorComponent* PrerequisiteComponent);
	void AddTickPrerequisiteActor(class AActor* PrerequisiteActor);
	class UActorComponent* AddComponent(const struct FName& TemplateName, bool bManualAttachment, const struct FTransform& RelativeTransform, class UObject* ComponentTemplateContext);
	bool ActorHasTag(const struct FName& Tag);
};


// Class Engine.Pawn
// 0x0060 (0x0378 - 0x0318)
class APawn : public AActor
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0318(0x0008) MISSED OFFSET
	unsigned char                                      bUseControllerRotationPitch : 1;                          // 0x0320(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bUseControllerRotationYaw : 1;                            // 0x0320(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bUseControllerRotationRoll : 1;                           // 0x0320(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bCanAffectNavigationGeneration : 1;                       // 0x0320(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData01[0x3];                                       // 0x0321(0x0003) MISSED OFFSET
	float                                              BaseEyeHeight;                                            // 0x0324(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EAutoReceiveInput>                     AutoPossessPlayer;                                        // 0x0328(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	EAutoPossessAI                                     AutoPossessAI;                                            // 0x0329(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x6];                                       // 0x032A(0x0006) MISSED OFFSET
	class UClass*                                      AIControllerClass;                                        // 0x0330(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class APlayerState*                                PlayerState;                                              // 0x0338(0x0008) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      RemoteViewPitch;                                          // 0x0340(0x0001) (CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0x7];                                       // 0x0341(0x0007) MISSED OFFSET
	class AController*                                 LastHitBy;                                                // 0x0348(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class AController*                                 Controller;                                               // 0x0350(0x0008) (CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData04[0x4];                                       // 0x0358(0x0004) MISSED OFFSET
	struct FVector                                     ControlInputVector;                                       // 0x035C(0x000C) (CPF_Transient, CPF_IsPlainOldData)
	struct FVector                                     LastControlInputVector;                                   // 0x0368(0x000C) (CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData05[0x4];                                       // 0x0374(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Pawn");
		return ptr;
	}


	void SpawnDefaultController();
	void SetCanAffectNavigationGeneration(bool bNewValue, bool bForceUpdate);
	void ReceiveUnpossessed(class AController* OldController);
	void ReceivePossessed(class AController* NewController);
	void PawnMakeNoise(float Loudness, const struct FVector& NoiseLocation, bool bUseNoiseMakerLocation, class AActor* NoiseMaker);
	void OnRep_PlayerState();
	void OnRep_Controller();
	void LaunchPawn(const struct FVector& LaunchVelocity, bool bXYOverride, bool bZOverride);
	struct FVector K2_GetMovementInputVector();
	bool IsPlayerControlled();
	bool IsMoveInputIgnored();
	bool IsLocallyControlled();
	bool IsControlled();
	struct FVector GetPendingMovementInputVector();
	struct FVector GetNavAgentLocation();
	class UPawnMovementComponent* GetMovementComponent();
	static class AActor* GetMovementBaseActor(class APawn* Pawn);
	struct FVector GetLastMovementInputVector();
	struct FRotator GetControlRotation();
	class AController* GetController();
	struct FRotator GetBaseAimRotation();
	void DetachFromControllerPendingDestroy();
	struct FVector ConsumeMovementInputVector();
	void AddMovementInput(const struct FVector& WorldDirection, float ScaleValue, bool bForce);
	void AddControllerYawInput(float Val);
	void AddControllerRollInput(float Val);
	void AddControllerPitchInput(float Val);
};


// Class Engine.Character
// 0x03B8 (0x0730 - 0x0378)
class ACharacter : public APawn
{
public:
	class USkeletalMeshComponent*                      Mesh;                                                     // 0x0378(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)
	class UCharacterMovementComponent*                 CharacterMovement;                                        // 0x0380(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)
	class UCapsuleComponent*                           CapsuleComponent;                                         // 0x0388(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)
	struct FBasedMovementInfo                          BasedMovement;                                            // 0x0390(0x0030)
	struct FBasedMovementInfo                          ReplicatedBasedMovement;                                  // 0x03C0(0x0030) (CPF_Net)
	float                                              AnimRootMotionTranslationScale;                           // 0x03F0(0x0004) (CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FVector                                     BaseTranslationOffset;                                    // 0x03F4(0x000C) (CPF_IsPlainOldData)
	struct FQuat                                       BaseRotationOffset;                                       // 0x0400(0x0010) (CPF_IsPlainOldData)
	float                                              ReplicatedServerLastTransformUpdateTimeStamp;             // 0x0410(0x0004) (CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      ReplicatedMovementMode;                                   // 0x0414(0x0001) (CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bInBaseReplication;                                       // 0x0415(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x2];                                       // 0x0416(0x0002) MISSED OFFSET
	float                                              CrouchedEyeHeight;                                        // 0x0418(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bIsCrouched : 1;                                          // 0x041C(0x0001) (CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData01[0x3];                                       // 0x041D(0x0003) MISSED OFFSET
	uint32_t                                           ReplicatedCrouchedStateAndCapsuleHalfHeight;              // 0x0420(0x0004) (CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bPressedJump : 1;                                         // 0x0424(0x0001) (CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bClientUpdating : 1;                                      // 0x0424(0x0001) (CPF_Transient)
	unsigned char                                      bClientWasFalling : 1;                                    // 0x0424(0x0001) (CPF_Transient)
	unsigned char                                      bClientResimulateRootMotion : 1;                          // 0x0424(0x0001) (CPF_Transient)
	unsigned char                                      bClientResimulateRootMotionSources : 1;                   // 0x0424(0x0001) (CPF_Transient)
	unsigned char                                      bSimGravityDisabled : 1;                                  // 0x0424(0x0001)
	unsigned char                                      bClientCheckEncroachmentOnNetUpdate : 1;                  // 0x0424(0x0001) (CPF_Transient)
	unsigned char                                      bServerMoveIgnoreRootMotion : 1;                          // 0x0424(0x0001) (CPF_Transient)
	unsigned char                                      bWasJumping : 1;                                          // 0x0425(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_DisableEditOnTemplate, CPF_Transient, CPF_EditConst)
	unsigned char                                      UnknownData02[0x2];                                       // 0x0426(0x0002) MISSED OFFSET
	float                                              JumpKeyHoldTime;                                          // 0x0428(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_DisableEditOnTemplate, CPF_Transient, CPF_EditConst, CPF_IsPlainOldData)
	float                                              JumpMaxHoldTime;                                          // 0x042C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                JumpMaxCount;                                             // 0x0430(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                JumpCurrentCount;                                         // 0x0434(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_DisableEditOnTemplate, CPF_EditConst, CPF_IsPlainOldData)
	struct FScriptMulticastDelegate                    OnReachedJumpApex;                                        // 0x0438(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	unsigned char                                      UnknownData03[0x10];                                      // 0x0448(0x0010) MISSED OFFSET
	struct FScriptMulticastDelegate                    MovementModeChangedDelegate;                              // 0x0458(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnCharacterMovementUpdated;                               // 0x0468(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FRootMotionSourceGroup                      SavedRootMotion;                                          // 0x0478(0x0100) (CPF_Transient)
	unsigned char                                      UnknownData04[0x8];                                       // 0x0578(0x0008) MISSED OFFSET
	struct FRootMotionMovementParams                   ClientRootMotionParams;                                   // 0x0580(0x0040) (CPF_Transient)
	TArray<struct FSimulatedRootMotionReplicatedMove>  RootMotionRepMoves;                                       // 0x05C0(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	struct FRepRootMotionMontage                       RepRootMotion;                                            // 0x05D0(0x0160) (CPF_Net)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Character");
		return ptr;
	}


	void UnCrouch(bool bClientSimulation);
	void StopJumping();
	void StopAnimMontage(class UAnimMontage* AnimMontage);
	void SetReplicateMovement(bool bInReplicateMovement);
	void ServerMoveOld(float OldTimeStamp, const struct FVector_NetQuantize10& OldAccel, unsigned char OldMoveFlags, float InCrouchedHalfHeight);
	void ServerMoveNoBase(float Timestamp, const struct FVector_NetQuantize10& InAccel, const struct FVector_NetQuantize100& ClientLoc, unsigned char CompressedMoveFlags, unsigned char ClientRoll, uint32_t View, unsigned char ClientMovementMode, float InCrouchedHalfHeight);
	void ServerMoveDualNoBase(float TimeStamp0, const struct FVector_NetQuantize10& InAccel0, unsigned char PendingFlags, uint32_t View0, float Timestamp, const struct FVector_NetQuantize10& InAccel, const struct FVector_NetQuantize100& ClientLoc, unsigned char NewFlags, unsigned char ClientRoll, uint32_t View, unsigned char ClientMovementMode, float InCrouchedHalfHeight);
	void ServerMoveDualHybridRootMotion(float TimeStamp0, const struct FVector_NetQuantize10& InAccel0, unsigned char PendingFlags, uint32_t View0, float Timestamp, const struct FVector_NetQuantize10& InAccel, const struct FVector_NetQuantize100& ClientLoc, unsigned char NewFlags, unsigned char ClientRoll, uint32_t View, class UPrimitiveComponent* ClientMovementBase, const struct FName& ClientBaseBoneName, unsigned char ClientMovementMode, float InCrouchedHalfHeight);
	void ServerMoveDual(float TimeStamp0, const struct FVector_NetQuantize10& InAccel0, unsigned char PendingFlags, uint32_t View0, float Timestamp, const struct FVector_NetQuantize10& InAccel, const struct FVector_NetQuantize100& ClientLoc, unsigned char NewFlags, unsigned char ClientRoll, uint32_t View, class UPrimitiveComponent* ClientMovementBase, const struct FName& ClientBaseBoneName, unsigned char ClientMovementMode, float InCrouchedHalfHeight);
	void ServerMove(float Timestamp, const struct FVector_NetQuantize10& InAccel, const struct FVector_NetQuantize100& ClientLoc, unsigned char CompressedMoveFlags, unsigned char ClientRoll, uint32_t View, class UPrimitiveComponent* ClientMovementBase, const struct FName& ClientBaseBoneName, unsigned char ClientMovementMode, float InCrouchedHalfHeight);
	void RootMotionDebugClientPrintOnScreen(const struct FString& inString);
	float PlayAnimMontage(class UAnimMontage* AnimMontage, float InPlayRate, const struct FName& StartSectionName);
	void OnWalkingOffLedge(const struct FVector& PreviousFloorImpactNormal, const struct FVector& PreviousFloorContactNormal, const struct FVector& PreviousLocation, float TimeDelta);
	void OnRep_RootMotion();
	void OnRep_ReplicatedCrouchedStateAndCapsuleHalfHeight();
	void OnRep_ReplicatedBasedMovement();
	void OnLaunched(const struct FVector& LaunchVelocity, bool bXYOverride, bool bZOverride);
	void OnLanded(const struct FHitResult& Hit);
	void OnJumped();
	void LaunchCharacter(const struct FVector& LaunchVelocity, bool bXYOverride, bool bZOverride);
	void K2_UpdateCustomMovement(float DeltaTime);
	void K2_OnStartCrouch(float HalfHeightAdjust, float ScaledHalfHeightAdjust);
	void K2_OnMovementModeChanged(TEnumAsByte<EMovementMode> PrevMovementMode, TEnumAsByte<EMovementMode> NewMovementMode, unsigned char PrevCustomMode, unsigned char NewCustomMode);
	void K2_OnEndCrouch(float HalfHeightAdjust, float ScaledHalfHeightAdjust);
	void Jump();
	bool IsPlayingRootMotion();
	bool IsPlayingNetworkedRootMotionMontage();
	bool IsJumpProvidingForce();
	class UAnimMontage* GetCurrentMontage();
	struct FVector GetBaseTranslationOffset();
	struct FRotator GetBaseRotationOffsetRotator();
	float GetAnimRootMotionTranslationScale();
	void Crouch(bool bClientSimulation);
	void ClientVeryShortAdjustPosition(float Timestamp, const struct FVector& NewLoc, class UPrimitiveComponent* NewBase, const struct FName& NewBaseBoneName, bool bHasBase, bool bBaseRelativePosition, unsigned char ServerMovementMode);
	void ClientCheatWalk();
	void ClientCheatGhost();
	void ClientCheatFly();
	void ClientAdjustRootMotionSourcePosition(float Timestamp, const struct FRootMotionSourceGroup& ServerRootMotion, bool bHasAnimRootMotion, float ServerMontageTrackPosition, const struct FVector& ServerLoc, const struct FVector_NetQuantizeNormal& ServerRotation, float ServerVelZ, class UPrimitiveComponent* ServerBase, const struct FName& ServerBoneName, bool bHasBase, bool bBaseRelativePosition, unsigned char ServerMovementMode);
	void ClientAdjustRootMotionPosition(float Timestamp, float ServerMontageTrackPosition, const struct FVector& ServerLoc, const struct FVector_NetQuantizeNormal& ServerRotation, float ServerVelZ, class UPrimitiveComponent* ServerBase, const struct FName& ServerBoneName, bool bHasBase, bool bBaseRelativePosition, unsigned char ServerMovementMode);
	void ClientAdjustPosition(float Timestamp, const struct FVector& NewLoc, const struct FVector& NewVel, class UPrimitiveComponent* NewBase, const struct FName& NewBaseBoneName, bool bHasBase, bool bBaseRelativePosition, unsigned char ServerMovementMode);
	void ClientAckGoodMove(float Timestamp);
	bool CanJumpInternal();
	bool CanJump();
	void CacheInitialMeshOffset(const struct FVector& MeshRelativeLocation, const struct FRotator& MeshRelativeRotation);
};


// Class Engine.ActorComponent
// 0x00C8 (0x00F0 - 0x0028)
class UActorComponent : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET
	struct FActorComponentTickFunction                 PrimaryComponentTick;                                     // 0x0030(0x0058) (CPF_Edit, CPF_DisableEditOnInstance)
	TArray<struct FName>                               ComponentTags;                                            // 0x0088(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor)
	TArray<class UAssetUserData*>                      AssetUserData;                                            // 0x0098(0x0010) (CPF_Edit, CPF_ExportObject, CPF_ZeroConstructor)
	unsigned char                                      UnknownData01 : 3;                                        // 0x00A8(0x0001)
	unsigned char                                      bReplicates : 1;                                          // 0x00A8(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Net, CPF_DisableEditOnInstance)
	unsigned char                                      bNetAddressable : 1;                                      // 0x00A8(0x0001)
	unsigned char                                      UnknownData02 : 3;                                        // 0x00A8(0x0001)
	unsigned char                                      UnknownData03 : 7;                                        // 0x00A9(0x0001)
	unsigned char                                      bAutoActivate : 1;                                        // 0x00A9(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bIsActive : 1;                                            // 0x00AA(0x0001) (CPF_Net, CPF_Transient)
	unsigned char                                      bEditableWhenInherited : 1;                               // 0x00AA(0x0001) (CPF_Edit, CPF_DisableEditOnInstance)
	unsigned char                                      UnknownData04 : 1;                                        // 0x00AA(0x0001)
	unsigned char                                      bCanEverAffectNavigation : 1;                             // 0x00AA(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData05 : 2;                                        // 0x00AA(0x0001)
	unsigned char                                      bIsEditorOnly : 1;                                        // 0x00AA(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData06[0x1];                                       // 0x00AB(0x0001) MISSED OFFSET
	EComponentCreationMethod                           CreationMethod;                                           // 0x00AC(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData07[0x3];                                       // 0x00AD(0x0003) MISSED OFFSET
	TArray<struct FSimpleMemberReference>              UCSModifiedProperties;                                    // 0x00B0(0x0010) (CPF_ZeroConstructor)
	struct FScriptMulticastDelegate                    OnComponentActivated;                                     // 0x00C0(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnComponentDeactivated;                                   // 0x00D0(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	unsigned char                                      UnknownData08[0x10];                                      // 0x00E0(0x0010) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ActorComponent");
		return ptr;
	}


	void ToggleActive();
	void SetTickGroup(TEnumAsByte<ETickingGroup> NewTickGroup);
	void SetTickableWhenPaused(bool bTickableWhenPaused);
	void SetIsReplicated(bool ShouldReplicate);
	void SetComponentTickInterval(float TickInterval);
	void SetComponentTickEnabled(bool bEnabled);
	void SetAutoActivate(bool bNewAutoActivate);
	void SetActive(bool bNewActive, bool bReset);
	void RemoveTickPrerequisiteComponent(class UActorComponent* PrerequisiteComponent);
	void RemoveTickPrerequisiteActor(class AActor* PrerequisiteActor);
	void ReceiveTick(float DeltaSeconds);
	void ReceiveEndPlay(TEnumAsByte<EEndPlayReason> EndPlayReason);
	void ReceiveBeginPlay();
	void OnRep_IsActive();
	void K2_DestroyComponent(class UObject* Object);
	bool IsComponentTickEnabled();
	bool IsBeingDestroyed();
	bool IsActive();
	class AActor* GetOwner();
	float GetComponentTickInterval();
	void Deactivate();
	bool ComponentHasTag(const struct FName& Tag);
	void AddTickPrerequisiteComponent(class UActorComponent* PrerequisiteComponent);
	void AddTickPrerequisiteActor(class AActor* PrerequisiteActor);
	void Activate(bool bReset);
};


// Class Engine.MovementComponent
// 0x0048 (0x0138 - 0x00F0)
class UMovementComponent : public UActorComponent
{
public:
	class USceneComponent*                             UpdatedComponent;                                         // 0x00F0(0x0008) (CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_Transient, CPF_InstancedReference, CPF_DuplicateTransient, CPF_IsPlainOldData)
	class UPrimitiveComponent*                         UpdatedPrimitive;                                         // 0x00F8(0x0008) (CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_Transient, CPF_InstancedReference, CPF_DuplicateTransient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x0100(0x0004) MISSED OFFSET
	struct FVector                                     Velocity;                                                 // 0x0104(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_IsPlainOldData)
	unsigned char                                      bConstrainToPlane : 1;                                    // 0x0110(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bSnapToPlaneAtStart : 1;                                  // 0x0110(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData01[0x3];                                       // 0x0111(0x0003) MISSED OFFSET
	EPlaneConstraintAxisSetting                        PlaneConstraintAxisSetting;                               // 0x0114(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x3];                                       // 0x0115(0x0003) MISSED OFFSET
	struct FVector                                     PlaneConstraintNormal;                                    // 0x0118(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	struct FVector                                     PlaneConstraintOrigin;                                    // 0x0124(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	unsigned char                                      bUpdateOnlyIfRendered : 1;                                // 0x0130(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bAutoUpdateTickRegistration : 1;                          // 0x0130(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bTickBeforeOwner : 1;                                     // 0x0130(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bAutoRegisterUpdatedComponent : 1;                        // 0x0130(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData03[0x7];                                       // 0x0131(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MovementComponent");
		return ptr;
	}


	void StopMovementImmediately();
	void SnapUpdatedComponentToPlane();
	void SetUpdatedComponent(class USceneComponent* NewUpdatedComponent);
	void SetPlaneConstraintOrigin(const struct FVector& PlaneOrigin);
	void SetPlaneConstraintNormal(const struct FVector& PlaneNormal);
	void SetPlaneConstraintFromVectors(const struct FVector& Forward, const struct FVector& Up);
	void SetPlaneConstraintEnabled(bool bEnabled);
	void SetPlaneConstraintAxisSetting(EPlaneConstraintAxisSetting NewAxisSetting);
	void PhysicsVolumeChanged(class APhysicsVolume* NewVolume);
	bool K2_MoveUpdatedComponent(const struct FVector& Delta, const struct FRotator& NewRotation, bool bSweep, bool bTeleport, struct FHitResult* OutHit);
	float K2_GetModifiedMaxSpeed();
	float K2_GetMaxSpeedModifier();
	bool IsExceedingMaxSpeed(float MaxSpeed);
	struct FVector GetPlaneConstraintOrigin();
	struct FVector GetPlaneConstraintNormal();
	EPlaneConstraintAxisSetting GetPlaneConstraintAxisSetting();
	class APhysicsVolume* GetPhysicsVolume();
	float GetMaxSpeed();
	float GetGravityZ();
	struct FVector ConstrainNormalToPlane(const struct FVector& Normal);
	struct FVector ConstrainLocationToPlane(const struct FVector& Location);
	struct FVector ConstrainDirectionToPlane(const struct FVector& Direction);
};


// Class Engine.NavMovementComponent
// 0x0038 (0x0170 - 0x0138)
class UNavMovementComponent : public UMovementComponent
{
public:
	struct FNavAgentProperties                         NavAgentProps;                                            // 0x0138(0x0020) (CPF_Edit, CPF_BlueprintVisible)
	float                                              FixedPathBrakingDistance;                                 // 0x0158(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bUpdateNavAgentWithOwnersCollision : 1;                   // 0x015C(0x0001) (CPF_Edit)
	unsigned char                                      bUseAccelerationForPaths : 1;                             // 0x015C(0x0001) (CPF_Edit, CPF_Config, CPF_GlobalConfig)
	unsigned char                                      bUseFixedBrakingDistanceForPaths : 1;                     // 0x015C(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x3];                                       // 0x015D(0x0003) MISSED OFFSET
	struct FMovementProperties                         MovementState;                                            // 0x0160(0x0004)
	unsigned char                                      UnknownData01[0xC];                                       // 0x0164(0x000C) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavMovementComponent");
		return ptr;
	}


	void StopMovementKeepPathing();
	void StopActiveMovement();
	bool IsSwimming();
	bool IsMovingOnGround();
	bool IsFlying();
	bool IsFalling();
	bool IsCrouching();
};


// Class Engine.PawnMovementComponent
// 0x0008 (0x0178 - 0x0170)
class UPawnMovementComponent : public UNavMovementComponent
{
public:
	class APawn*                                       PawnOwner;                                                // 0x0170(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_DuplicateTransient, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.PawnMovementComponent");
		return ptr;
	}


	struct FVector K2_GetInputVector();
	bool IsMoveInputIgnored();
	struct FVector GetPendingInputVector();
	class APawn* GetPawnOwner();
	struct FVector GetLastInputVector();
	struct FVector ConsumeInputVector();
	void AddInputVector(const struct FVector& WorldVector, bool bForce);
};


// Class Engine.CharacterMovementComponent
// 0x0648 (0x07C0 - 0x0178)
class UCharacterMovementComponent : public UPawnMovementComponent
{
public:
	unsigned char                                      UnknownData00[0x10];                                      // 0x0178(0x0010) MISSED OFFSET
	class ACharacter*                                  CharacterOwner;                                           // 0x0188(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_DuplicateTransient, CPF_IsPlainOldData)
	unsigned char                                      bApplyGravityWhileJumping : 1;                            // 0x0190(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData01[0x3];                                       // 0x0191(0x0003) MISSED OFFSET
	float                                              GravityScale;                                             // 0x0194(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxStepHeight;                                            // 0x0198(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              JumpZVelocity;                                            // 0x019C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              JumpOffJumpZFactor;                                       // 0x01A0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              WalkableFloorAngle;                                       // 0x01A4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              WalkableFloorZ;                                           // 0x01A8(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)
	TEnumAsByte<EMovementMode>                         MovementMode;                                             // 0x01AC(0x0001) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      CustomMovementMode;                                       // 0x01AD(0x0001) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x22];                                      // 0x01AE(0x0022) MISSED OFFSET
	float                                              GroundFriction;                                           // 0x01D0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxWalkSpeed;                                             // 0x01D4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxWalkSpeedCrouched;                                     // 0x01D8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxSwimSpeed;                                             // 0x01DC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxFlySpeed;                                              // 0x01E0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxCustomMovementSpeed;                                   // 0x01E4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxAcceleration;                                          // 0x01E8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MinAnalogWalkSpeed;                                       // 0x01EC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              BrakingFrictionFactor;                                    // 0x01F0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              BrakingFriction;                                          // 0x01F4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bUseSeparateBrakingFriction : 1;                          // 0x01F8(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_DisableEditOnInstance)
	unsigned char                                      UnknownData03[0x3];                                       // 0x01F9(0x0003) MISSED OFFSET
	float                                              BrakingDecelerationWalking;                               // 0x01FC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              BrakingDecelerationFalling;                               // 0x0200(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              BrakingDecelerationSwimming;                              // 0x0204(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              BrakingDecelerationFlying;                                // 0x0208(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              AirControl;                                               // 0x020C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              AirControlBoostMultiplier;                                // 0x0210(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              AirControlBoostVelocityThreshold;                         // 0x0214(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              FallingLateralFriction;                                   // 0x0218(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              CrouchedHalfHeight;                                       // 0x021C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              Buoyancy;                                                 // 0x0220(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              PerchRadiusThreshold;                                     // 0x0224(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              PerchAdditionalHeight;                                    // 0x0228(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FRotator                                    RotationRate;                                             // 0x022C(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_IsPlainOldData)
	unsigned char                                      bUseControllerDesiredRotation : 1;                        // 0x0238(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bOrientRotationToMovement : 1;                            // 0x0238(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bSweepWhileNavWalking : 1;                                // 0x0238(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData04 : 1;                                        // 0x0238(0x0001)
	unsigned char                                      bMovementInProgress : 1;                                  // 0x0238(0x0001)
	unsigned char                                      bEnableScopedMovementUpdates : 1;                         // 0x0238(0x0001) (CPF_Edit)
	unsigned char                                      bForceMaxAccel : 1;                                       // 0x0238(0x0001)
	unsigned char                                      bRunPhysicsWithNoController : 1;                          // 0x0238(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bForceNextFloorCheck : 1;                                 // 0x0239(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_DisableEditOnTemplate, CPF_EditConst)
	unsigned char                                      bShrinkProxyCapsule : 1;                                  // 0x0239(0x0001)
	unsigned char                                      bCanWalkOffLedges : 1;                                    // 0x0239(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bCanWalkOffLedgesWhenCrouching : 1;                       // 0x0239(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData05 : 2;                                        // 0x0239(0x0001)
	unsigned char                                      bNetworkSkipProxyPredictionOnNetUpdate : 1;               // 0x0239(0x0001) (CPF_Edit, CPF_DisableEditOnInstance)
	unsigned char                                      bDeferUpdateMoveComponent : 1;                            // 0x0239(0x0001)
	unsigned char                                      UnknownData06[0x6];                                       // 0x023A(0x0006) MISSED OFFSET
	class USceneComponent*                             DeferredUpdatedMoveComponent;                             // 0x0240(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	float                                              MaxOutOfWaterStepHeight;                                  // 0x0248(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              OutofWaterZ;                                              // 0x024C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              Mass;                                                     // 0x0250(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bEnablePhysicsInteraction;                                // 0x0254(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bTouchForceScaledToMass;                                  // 0x0255(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bPushForceScaledToMass;                                   // 0x0256(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bPushForceUsingZOffset;                                   // 0x0257(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bScalePushForceToVelocity;                                // 0x0258(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData07[0x3];                                       // 0x0259(0x0003) MISSED OFFSET
	float                                              StandingDownwardForceScale;                               // 0x025C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              InitialPushForceFactor;                                   // 0x0260(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              PushForceFactor;                                          // 0x0264(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              PushForcePointZOffsetFactor;                              // 0x0268(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              TouchForceFactor;                                         // 0x026C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MinTouchForce;                                            // 0x0270(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxTouchForce;                                            // 0x0274(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              RepulsionForce;                                           // 0x0278(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bForceBraking : 1;                                        // 0x027C(0x0001) (CPF_Deprecated)
	unsigned char                                      UnknownData08[0x3];                                       // 0x027D(0x0003) MISSED OFFSET
	float                                              CrouchedSpeedMultiplier;                                  // 0x0280(0x0004) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	float                                              UpperImpactNormalScale;                                   // 0x0284(0x0004) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	struct FVector                                     Acceleration;                                             // 0x0288(0x000C) (CPF_Net, CPF_IsPlainOldData)
	struct FVector                                     LastUpdateLocation;                                       // 0x0294(0x000C) (CPF_IsPlainOldData)
	struct FQuat                                       LastUpdateRotation;                                       // 0x02A0(0x0010) (CPF_IsPlainOldData)
	struct FVector                                     LastUpdateVelocity;                                       // 0x02B0(0x000C) (CPF_IsPlainOldData)
	float                                              ServerLastTransformUpdateTimeStamp;                       // 0x02BC(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              ServerLastClientGoodMoveAckTime;                          // 0x02C0(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              ServerLastClientAdjustmentTime;                           // 0x02C4(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	struct FVector                                     PendingImpulseToApply;                                    // 0x02C8(0x000C) (CPF_IsPlainOldData)
	struct FVector                                     PendingForceToApply;                                      // 0x02D4(0x000C) (CPF_IsPlainOldData)
	float                                              AnalogInputModifier;                                      // 0x02E0(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData09[0x8];                                       // 0x02E4(0x0008) MISSED OFFSET
	float                                              MaxSimulationTimeStep;                                    // 0x02EC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                MaxSimulationIterations;                                  // 0x02F0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxDepenetrationWithGeometry;                             // 0x02F4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxDepenetrationWithGeometryAsProxy;                      // 0x02F8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxDepenetrationWithPawn;                                 // 0x02FC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxDepenetrationWithPawnAsProxy;                          // 0x0300(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              NetworkSimulatedSmoothLocationTime;                       // 0x0304(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	float                                              NetworkSimulatedSmoothRotationTime;                       // 0x0308(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	float                                              ListenServerNetworkSimulatedSmoothLocationTime;           // 0x030C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	float                                              ListenServerNetworkSimulatedSmoothRotationTime;           // 0x0310(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	float                                              NetProxyShrinkRadius;                                     // 0x0314(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	float                                              NetProxyShrinkHalfHeight;                                 // 0x0318(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	float                                              NetworkMaxSmoothUpdateDistance;                           // 0x031C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	float                                              NetworkNoSmoothUpdateDistance;                            // 0x0320(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	ENetworkSmoothingMode                              NetworkSmoothingMode;                                     // 0x0324(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData10[0x3];                                       // 0x0325(0x0003) MISSED OFFSET
	float                                              NetworkMinTimeBetweenClientAckGoodMoves;                  // 0x0328(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	float                                              NetworkMinTimeBetweenClientAdjustments;                   // 0x032C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	float                                              NetworkMinTimeBetweenClientAdjustmentsLargeCorrection;    // 0x0330(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	float                                              NetworkLargeClientCorrectionDistance;                     // 0x0334(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	float                                              LedgeCheckThreshold;                                      // 0x0338(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              JumpOutOfWaterPitch;                                      // 0x033C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FFindFloorResult                            CurrentFloor;                                             // 0x0340(0x0098) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_DisableEditOnTemplate, CPF_EditConst)
	TEnumAsByte<EMovementMode>                         DefaultLandMovementMode;                                  // 0x03D8(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EMovementMode>                         DefaultWaterMovementMode;                                 // 0x03D9(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EMovementMode>                         GroundMovementMode;                                       // 0x03DA(0x0001) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData11[0x1];                                       // 0x03DB(0x0001) MISSED OFFSET
	unsigned char                                      bMaintainHorizontalGroundVelocity : 1;                    // 0x03DC(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bImpartBaseVelocityX : 1;                                 // 0x03DC(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bImpartBaseVelocityY : 1;                                 // 0x03DC(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bImpartBaseVelocityZ : 1;                                 // 0x03DC(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bImpartBaseAngularVelocity : 1;                           // 0x03DC(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bJustTeleported : 1;                                      // 0x03DC(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_DisableEditOnTemplate, CPF_Transient, CPF_EditConst)
	unsigned char                                      bNetworkUpdateReceived : 1;                               // 0x03DC(0x0001) (CPF_Transient)
	unsigned char                                      bNetworkMovementModeChanged : 1;                          // 0x03DC(0x0001) (CPF_Transient)
	unsigned char                                      bIgnoreClientMovementErrorChecksAndCorrection : 1;        // 0x03DD(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_Transient)
	unsigned char                                      bNotifyApex : 1;                                          // 0x03DD(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_EditConst)
	unsigned char                                      bCheatFlying : 1;                                         // 0x03DD(0x0001)
	unsigned char                                      bWantsToCrouch : 1;                                       // 0x03DD(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_DisableEditOnTemplate, CPF_EditConst)
	unsigned char                                      bCrouchMaintainsBaseLocation : 1;                         // 0x03DD(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_DisableEditOnTemplate, CPF_EditConst)
	unsigned char                                      bIgnoreBaseRotation : 1;                                  // 0x03DD(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bFastAttachedMove : 1;                                    // 0x03DD(0x0001)
	unsigned char                                      bAlwaysCheckFloor : 1;                                    // 0x03DD(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bUseFlatBaseForFloorChecks : 1;                           // 0x03DE(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bPerformingJumpOff : 1;                                   // 0x03DE(0x0001)
	unsigned char                                      bWantsToLeaveNavWalking : 1;                              // 0x03DE(0x0001)
	unsigned char                                      bUseRVOAvoidance : 1;                                     // 0x03DE(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bRequestedMoveUseAcceleration : 1;                        // 0x03DE(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData12 : 1;                                        // 0x03DE(0x0001)
	unsigned char                                      bHasRequestedVelocity : 1;                                // 0x03DE(0x0001) (CPF_Transient)
	unsigned char                                      bRequestedMoveWithMaxSpeed : 1;                           // 0x03DE(0x0001) (CPF_Transient)
	unsigned char                                      bWasAvoidanceUpdated : 1;                                 // 0x03DF(0x0001) (CPF_Transient)
	unsigned char                                      UnknownData13 : 2;                                        // 0x03DF(0x0001)
	unsigned char                                      bProjectNavMeshWalking : 1;                               // 0x03DF(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bProjectNavMeshOnBothWorldChannels : 1;                   // 0x03DF(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData14[0x10];                                      // 0x03E0(0x0010) MISSED OFFSET
	float                                              AvoidanceConsiderationRadius;                             // 0x03F0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FVector                                     RequestedVelocity;                                        // 0x03F4(0x000C) (CPF_Transient, CPF_IsPlainOldData)
	int                                                AvoidanceUID;                                             // 0x0400(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)
	struct FNavAvoidanceMask                           AvoidanceGroup;                                           // 0x0404(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	struct FNavAvoidanceMask                           GroupsToAvoid;                                            // 0x0408(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	struct FNavAvoidanceMask                           GroupsToIgnore;                                           // 0x040C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	float                                              AvoidanceWeight;                                          // 0x0410(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FVector                                     PendingLaunchVelocity;                                    // 0x0414(0x000C) (CPF_IsPlainOldData)
	unsigned char                                      UnknownData15[0xA0];                                      // 0x0420(0x00A0) MISSED OFFSET
	float                                              NavMeshProjectionInterval;                                // 0x04C0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              NavMeshProjectionTimer;                                   // 0x04C4(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              NavMeshProjectionInterpSpeed;                             // 0x04C8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              NavMeshProjectionHeightScaleUp;                           // 0x04CC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              NavMeshProjectionHeightScaleDown;                         // 0x04D0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              NavWalkingFloorDistTolerance;                             // 0x04D4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FCharacterMovementComponentPostPhysicsTickFunction PostPhysicsTickFunction;                                  // 0x04D8(0x0058)
	unsigned char                                      UnknownData16[0x10];                                      // 0x0530(0x0010) MISSED OFFSET
	float                                              MinTimeBetweenTimeStampResets;                            // 0x0540(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData17[0x4];                                       // 0x0544(0x0004) MISSED OFFSET
	struct FRootMotionSourceGroup                      CurrentRootMotion;                                        // 0x0548(0x0100) (CPF_Transient)
	unsigned char                                      UnknownData18[0x98];                                      // 0x0648(0x0098) MISSED OFFSET
	struct FRootMotionMovementParams                   RootMotionParams;                                         // 0x06E0(0x0040) (CPF_Transient)
	struct FVector                                     AnimRootMotionVelocity;                                   // 0x0720(0x000C) (CPF_Transient, CPF_IsPlainOldData)
	bool                                               bWasSimulatingRootMotion;                                 // 0x072C(0x0001) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData19[0x3];                                       // 0x072D(0x0003) MISSED OFFSET
	unsigned char                                      bAllowPhysicsRotationDuringAnimRootMotion : 1;            // 0x0730(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData20[0x8F];                                      // 0x0731(0x008F) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CharacterMovementComponent");
		return ptr;
	}


	void SetWalkableFloorZ(float InWalkableFloorZ);
	void SetWalkableFloorAngle(float InWalkableFloorAngle);
	void SetMovementMode(TEnumAsByte<EMovementMode> NewMovementMode, unsigned char NewCustomMode);
	void SetGroupsToIgnoreMask(const struct FNavAvoidanceMask& GroupMask);
	void SetGroupsToIgnore(int GroupFlags);
	void SetGroupsToAvoidMask(const struct FNavAvoidanceMask& GroupMask);
	void SetGroupsToAvoid(int GroupFlags);
	void SetAvoidanceGroupMask(const struct FNavAvoidanceMask& GroupMask);
	void SetAvoidanceGroup(int GroupFlags);
	void SetAvoidanceEnabled(bool bEnable);
	float K2_GetWalkableFloorZ();
	float K2_GetWalkableFloorAngle();
	float K2_GetModifiedMaxAcceleration();
	void K2_FindFloor(const struct FVector& CapsuleLocation, struct FFindFloorResult* FloorResult);
	void K2_ComputeFloorDist(const struct FVector& CapsuleLocation, float LineDistance, float SweepDistance, float SweepRadius, struct FFindFloorResult* FloorResult);
	bool IsWalking();
	bool IsWalkable(const struct FHitResult& Hit);
	float GetValidPerchRadius();
	float GetPerchRadiusThreshold();
	class UPrimitiveComponent* GetMovementBase();
	float GetMinAnalogSpeed();
	float GetMaxJumpHeightWithJumpTime();
	float GetMaxJumpHeight();
	float GetMaxBrakingDeceleration();
	float GetMaxAcceleration();
	struct FVector GetImpartedMovementBaseVelocity();
	struct FVector GetCurrentAcceleration();
	class ACharacter* GetCharacterOwner();
	float GetAnalogInputModifier();
	void DisableMovement();
	void ClearAccumulatedForces();
	void CapsuleTouched(class UPrimitiveComponent* OverlappedComp, class AActor* Other, class UPrimitiveComponent* OtherComp, int OtherBodyIndex, bool bFromSweep, const struct FHitResult& SweepResult);
	void CalcVelocity(float DeltaTime, float Friction, bool bFluid, float BrakingDeceleration);
	void AddImpulse(const struct FVector& Impulse, bool bVelocityChange);
	void AddForce(const struct FVector& Force);
};


// Class Engine.Controller
// 0x0068 (0x0380 - 0x0318)
class AController : public AActor
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0318(0x0008) MISSED OFFSET
	class APlayerState*                                PlayerState;                                              // 0x0320(0x0008) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x8];                                       // 0x0328(0x0008) MISSED OFFSET
	struct FScriptMulticastDelegate                    OnInstigatedAnyDamage;                                    // 0x0330(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FName                                       StateName;                                                // 0x0340(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class APawn*                                       Pawn;                                                     // 0x0348(0x0008) (CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x8];                                       // 0x0350(0x0008) MISSED OFFSET
	class ACharacter*                                  Character;                                                // 0x0358(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class USceneComponent*                             TransformComponent;                                       // 0x0360(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	struct FRotator                                    ControlRotation;                                          // 0x0368(0x000C) (CPF_IsPlainOldData)
	unsigned char                                      bAttachToPawn : 1;                                        // 0x0374(0x0001) (CPF_Edit, CPF_DisableEditOnInstance)
	unsigned char                                      bIsPlayerController : 1;                                  // 0x0374(0x0001)
	unsigned char                                      UnknownData03[0xB];                                       // 0x0375(0x000B) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Controller");
		return ptr;
	}


	void UnPossess();
	void StopMovement();
	void SetInitialLocationAndRotation(const struct FVector& NewLocation, const struct FRotator& NewRotation);
	void SetIgnoreMoveInput(bool bNewMoveInput);
	void SetIgnoreLookInput(bool bNewLookInput);
	void SetControlRotation(const struct FRotator& NewRotation);
	void ResetIgnoreMoveInput();
	void ResetIgnoreLookInput();
	void ResetIgnoreInputFlags();
	void ReceiveInstigatedAnyDamage(float Damage, class UDamageType* DamageType, class AActor* DamagedActor, class AActor* DamageCauser);
	void Possess(class APawn* InPawn);
	void OnRep_PlayerState();
	void OnRep_Pawn();
	bool LineOfSightTo(class AActor* Other, const struct FVector& ViewPoint, bool bAlternateChecks);
	class APawn* K2_GetPawn();
	bool IsPlayerController();
	bool IsMoveInputIgnored();
	bool IsLookInputIgnored();
	bool IsLocalPlayerController();
	bool IsLocalController();
	class AActor* GetViewTarget();
	struct FRotator GetDesiredRotation();
	struct FRotator GetControlRotation();
	void ClientSetRotation(const struct FRotator& NewRotation, bool bResetCamera);
	void ClientSetLocation(const struct FVector& NewLocation, const struct FRotator& NewRotation);
	class APlayerController* CastToPlayerController();
};


// Class Engine.SceneComponent
// 0x01A0 (0x0290 - 0x00F0)
class USceneComponent : public UActorComponent
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x00F0(0x0008) MISSED OFFSET
	TWeakObjectPtr<class APhysicsVolume>               PhysicsVolume;                                            // 0x00F8(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class USceneComponent*                             AttachParent;                                             // 0x0100(0x0008) (CPF_ExportObject, CPF_Net, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	struct FName                                       AttachSocketName;                                         // 0x0108(0x0008) (CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<class USceneComponent*>                     AttachChildren;                                           // 0x0110(0x0010) (CPF_ExportObject, CPF_Net, CPF_ZeroConstructor, CPF_Transient)
	TArray<class USceneComponent*>                     ClientAttachedChildren;                                   // 0x0120(0x0010) (CPF_ExportObject, CPF_ZeroConstructor, CPF_Transient)
	unsigned char                                      UnknownData01[0x2C];                                      // 0x0130(0x002C) MISSED OFFSET
	struct FVector                                     RelativeLocation;                                         // 0x015C(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Net, CPF_IsPlainOldData)
	struct FRotator                                    RelativeRotation;                                         // 0x0168(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Net, CPF_IsPlainOldData)
	struct FVector                                     RelativeScale3D;                                          // 0x0174(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Net, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x30];                                      // 0x0180(0x0030) MISSED OFFSET
	struct FVector                                     ComponentVelocity;                                        // 0x01B0(0x000C) (CPF_IsPlainOldData)
	unsigned char                                      bComponentToWorldUpdated : 1;                             // 0x01BC(0x0001) (CPF_Transient)
	unsigned char                                      bAbsoluteLocation : 1;                                    // 0x01BC(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_Net)
	unsigned char                                      bAbsoluteRotation : 1;                                    // 0x01BC(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_Net)
	unsigned char                                      bAbsoluteScale : 1;                                       // 0x01BC(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_Net)
	unsigned char                                      bVisible : 1;                                             // 0x01BC(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Net)
	unsigned char                                      bHiddenInGame : 1;                                        // 0x01BC(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bShouldUpdatePhysicsVolume : 1;                           // 0x01BC(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bBoundsChangeTriggersStreamingDataRebuild : 1;            // 0x01BC(0x0001)
	unsigned char                                      bUseAttachParentBound : 1;                                // 0x01BD(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData03 : 4;                                        // 0x01BD(0x0001)
	unsigned char                                      bAbsoluteTranslation : 1;                                 // 0x01BD(0x0001) (CPF_Deprecated)
	TEnumAsByte<EComponentMobility>                    Mobility;                                                 // 0x01BE(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EDetailMode>                           DetailMode;                                               // 0x01BF(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData04[0x40];                                      // 0x01C0(0x0040) MISSED OFFSET
	struct FScriptMulticastDelegate                    PhysicsVolumeChangedDelegate;                             // 0x0200(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	unsigned char                                      UnknownData05[0x80];                                      // 0x0210(0x0080) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.SceneComponent");
		return ptr;
	}


	void ToggleVisibility(bool bPropagateToChildren);
	bool SnapTo(class USceneComponent* InParent, const struct FName& InSocketName);
	void SetWorldScale3D(const struct FVector& NewScale);
	void SetVisibility(bool bNewVisibility, bool bPropagateToChildren);
	void SetRelativeScale3D(const struct FVector& NewScale3D);
	void SetHiddenInGame(bool NewHidden, bool bPropagateToChildren);
	void SetAbsolute(bool bNewAbsoluteLocation, bool bNewAbsoluteRotation, bool bNewAbsoluteScale);
	void ResetRelativeTransform();
	void OnRep_Visibility(bool OldValue);
	void OnRep_Transform();
	void OnRep_AttachSocketName();
	void OnRep_AttachParent();
	void OnRep_AttachChildren();
	void K2_SetWorldTransform(const struct FTransform& NewTransform, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_SetWorldRotation(const struct FRotator& NewRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_SetWorldLocationAndRotation(const struct FVector& NewLocation, const struct FRotator& NewRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_SetWorldLocation(const struct FVector& NewLocation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_SetRelativeTransform(const struct FTransform& NewTransform, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_SetRelativeRotation(const struct FRotator& NewRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_SetRelativeLocationAndRotation(const struct FVector& NewLocation, const struct FRotator& NewRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_SetRelativeLocation(const struct FVector& NewLocation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	struct FTransform K2_GetComponentToWorld();
	struct FVector K2_GetComponentScale();
	struct FRotator K2_GetComponentRotation();
	struct FVector K2_GetComponentLocation();
	void K2_DetachFromComponent(EDetachmentRule LocationRule, EDetachmentRule RotationRule, EDetachmentRule ScaleRule, bool bCallModify);
	bool K2_AttachToComponent(class USceneComponent* Parent, const struct FName& SocketName, EAttachmentRule LocationRule, EAttachmentRule RotationRule, EAttachmentRule ScaleRule, bool bWeldSimulatedBodies);
	bool K2_AttachTo(class USceneComponent* InParent, const struct FName& InSocketName, TEnumAsByte<EAttachLocation> AttachType, bool bWeldSimulatedBodies);
	void K2_AddWorldTransform(const struct FTransform& DeltaTransform, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_AddWorldRotation(const struct FRotator& DeltaRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_AddWorldOffset(const struct FVector& DeltaLocation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_AddRelativeRotation(const struct FRotator& DeltaRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_AddRelativeLocation(const struct FVector& DeltaLocation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_AddLocalTransform(const struct FTransform& DeltaTransform, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_AddLocalRotation(const struct FRotator& DeltaRotation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	void K2_AddLocalOffset(const struct FVector& DeltaLocation, bool bSweep, bool bTeleport, struct FHitResult* SweepHitResult);
	bool IsVisible();
	bool IsSimulatingPhysics(const struct FName& BoneName);
	bool IsAnySimulatingPhysics();
	struct FVector GetUpVector();
	struct FTransform GetSocketTransform(const struct FName& InSocketName, TEnumAsByte<ERelativeTransformSpace> TransformSpace);
	struct FRotator GetSocketRotation(const struct FName& InSocketName);
	struct FQuat GetSocketQuaternion(const struct FName& InSocketName);
	struct FVector GetSocketLocation(const struct FName& InSocketName);
	struct FVector GetRightVector();
	struct FTransform GetRelativeTransform();
	class APhysicsVolume* GetPhysicsVolume();
	void GetParentComponents(TArray<class USceneComponent*>* Parents);
	int GetNumChildrenComponents();
	struct FVector GetForwardVector();
	struct FVector GetComponentVelocity();
	void GetChildrenComponents(bool bIncludeAllDescendants, TArray<class USceneComponent*>* Children);
	class USceneComponent* GetChildComponent(int ChildIndex);
	struct FName GetAttachSocketName();
	class USceneComponent* GetAttachParent();
	TArray<struct FName> GetAllSocketNames();
	bool DoesSocketExist(const struct FName& InSocketName);
	void DetachFromParent(bool bMaintainWorldPosition, bool bCallModify);
};


// Class Engine.PrimitiveComponent
// 0x03D0 (0x0660 - 0x0290)
class UPrimitiveComponent : public USceneComponent
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0290(0x0008) MISSED OFFSET
	float                                              MinDrawDistance;                                          // 0x0298(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              LDMaxDrawDistance;                                        // 0x029C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              CachedMaxDrawDistance;                                    // 0x02A0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)
	TEnumAsByte<ESceneDepthPriorityGroup>              DepthPriorityGroup;                                       // 0x02A4(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ESceneDepthPriorityGroup>              ViewOwnerDepthPriorityGroup;                              // 0x02A5(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EIndirectLightingCacheQuality>         IndirectLightingCacheQuality;                             // 0x02A6(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	ELightmapType                                      LightmapType;                                             // 0x02A7(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01 : 3;                                        // 0x02A8(0x0001)
	unsigned char                                      bAlwaysCreatePhysicsState : 1;                            // 0x02A8(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bGenerateOverlapEvents : 1;                               // 0x02A8(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bMultiBodyOverlap : 1;                                    // 0x02A8(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bCheckAsyncSceneOnMove : 1;                               // 0x02A8(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bTraceComplexOnMove : 1;                                  // 0x02A8(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bReturnMaterialOnMove : 1;                                // 0x02A9(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bUseViewOwnerDepthPriorityGroup : 1;                      // 0x02A9(0x0001)
	unsigned char                                      bAllowCullDistanceVolume : 1;                             // 0x02A9(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bHasMotionBlurVelocityMeshes : 1;                         // 0x02A9(0x0001)
	unsigned char                                      bVisibleInReflectionCaptures : 1;                         // 0x02A9(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bRenderInMainPass : 1;                                    // 0x02A9(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bRenderInMono : 1;                                        // 0x02A9(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bReceivesDecals : 1;                                      // 0x02A9(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bOwnerNoSee : 1;                                          // 0x02AA(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bOnlyOwnerSee : 1;                                        // 0x02AA(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bTreatAsBackgroundForOcclusion : 1;                       // 0x02AA(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUseAsOccluder : 1;                                       // 0x02AA(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bSelectable : 1;                                          // 0x02AA(0x0001)
	unsigned char                                      bForceMipStreaming : 1;                                   // 0x02AA(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bHasPerInstanceHitProxies : 1;                            // 0x02AA(0x0001)
	unsigned char                                      CastShadow : 1;                                           // 0x02AA(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bAffectDynamicIndirectLighting : 1;                       // 0x02AB(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bAffectDistanceFieldLighting : 1;                         // 0x02AB(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bCastDynamicShadow : 1;                                   // 0x02AB(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bCastStaticShadow : 1;                                    // 0x02AB(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bCastVolumetricTranslucentShadow : 1;                     // 0x02AB(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bSelfShadowOnly : 1;                                      // 0x02AB(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bCastFarShadow : 1;                                       // 0x02AB(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bCastInsetShadow : 1;                                     // 0x02AB(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bCastCinematicShadow : 1;                                 // 0x02AC(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bCastHiddenShadow : 1;                                    // 0x02AC(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bCastShadowAsTwoSided : 1;                                // 0x02AC(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bLightAsIfStatic : 1;                                     // 0x02AC(0x0001) (CPF_Deprecated)
	unsigned char                                      bLightAttachmentsAsGroup : 1;                             // 0x02AC(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bReceiveMobileCSMShadows : 1;                             // 0x02AC(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bSingleSampleShadowFromStationaryLights : 1;              // 0x02AC(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bIgnoreRadialImpulse : 1;                                 // 0x02AC(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bIgnoreRadialForce : 1;                                   // 0x02AD(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bApplyImpulseOnDamage : 1;                                // 0x02AD(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      AlwaysLoadOnClient : 1;                                   // 0x02AD(0x0001)
	unsigned char                                      AlwaysLoadOnServer : 1;                                   // 0x02AD(0x0001)
	unsigned char                                      bUseEditorCompositing : 1;                                // 0x02AD(0x0001)
	unsigned char                                      bRenderCustomDepth : 1;                                   // 0x02AD(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	TEnumAsByte<EHasCustomNavigableGeometry>           bHasCustomNavigableGeometry;                              // 0x02AE(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ECanBeCharacterBase>                   CanBeCharacterBase;                                       // 0x02AF(0x0001) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x1];                                       // 0x02B0(0x0001) MISSED OFFSET
	TEnumAsByte<ECanBeCharacterBase>                   CanCharacterStepUpOn;                                     // 0x02B1(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FLightingChannels                           LightingChannels;                                         // 0x02B2(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	ERendererStencilMask                               CustomDepthStencilWriteMask;                              // 0x02B3(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                CustomDepthStencilValue;                                  // 0x02B4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                TranslucencySortPriority;                                 // 0x02B8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                VisibilityId;                                             // 0x02BC(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0x4];                                       // 0x02C0(0x0004) MISSED OFFSET
	float                                              LpvBiasMultiplier;                                        // 0x02C4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData04[0x8];                                       // 0x02C8(0x0008) MISSED OFFSET
	float                                              BoundsScale;                                              // 0x02D0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              LastSubmitTime;                                           // 0x02D4(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              LastRenderTime;                                           // 0x02D8(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              LastRenderTimeOnScreen;                                   // 0x02DC(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	TArray<class AActor*>                              MoveIgnoreActors;                                         // 0x02E0(0x0010) (CPF_ZeroConstructor, CPF_Transient, CPF_DuplicateTransient)
	TArray<class UPrimitiveComponent*>                 MoveIgnoreComponents;                                     // 0x02F0(0x0010) (CPF_ExportObject, CPF_ZeroConstructor, CPF_Transient, CPF_DuplicateTransient)
	unsigned char                                      UnknownData05[0x10];                                      // 0x0300(0x0010) MISSED OFFSET
	struct FBodyInstance                               BodyInstance;                                             // 0x0310(0x0200) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	struct FScriptMulticastDelegate                    OnComponentHit;                                           // 0x0510(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnComponentBeginOverlap;                                  // 0x0520(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnComponentEndOverlap;                                    // 0x0530(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnComponentWake;                                          // 0x0540(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnComponentSleep;                                         // 0x0550(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	unsigned char                                      UnknownData06[0x10];                                      // 0x0560(0x0010) MISSED OFFSET
	struct FScriptMulticastDelegate                    OnBeginCursorOver;                                        // 0x0570(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnEndCursorOver;                                          // 0x0580(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnClicked;                                                // 0x0590(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnReleased;                                               // 0x05A0(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnInputTouchBegin;                                        // 0x05B0(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnInputTouchEnd;                                          // 0x05C0(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnInputTouchEnter;                                        // 0x05D0(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnInputTouchLeave;                                        // 0x05E0(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	unsigned char                                      UnknownData07[0x10];                                      // 0x05F0(0x0010) MISSED OFFSET
	class UPrimitiveComponent*                         LODParentPrimitive;                                       // 0x0600(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_DuplicateTransient, CPF_IsPlainOldData)
	struct FPrimitiveComponentPostPhysicsTickFunction  PostPhysicsComponentTick;                                 // 0x0608(0x0058)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.PrimitiveComponent");
		return ptr;
	}


	void WakeRigidBody(const struct FName& BoneName);
	void WakeAllRigidBodies();
	void SetWalkableSlopeOverride(const struct FWalkableSlopeOverride& NewOverride);
	void SetUseCCD(bool InUseCCD, const struct FName& BoneName);
	void SetTranslucentSortPriority(int NewTranslucentSortPriority);
	void SetSingleSampleShadowFromStationaryLights(bool bNewSingleSampleShadowFromStationaryLights);
	void SetSimulatePhysics(bool bSimulate);
	void SetRenderInMono(bool bValue);
	void SetRenderInMainPass(bool bValue);
	void SetRenderCustomDepth(bool bValue);
	void SetReceivesDecals(bool bNewReceivesDecals);
	void SetPhysMaterialOverride(class UPhysicalMaterial* NewPhysMaterial);
	void SetPhysicsMaxAngularVelocityInRadians(float NewMaxAngVel, bool bAddToCurrent, const struct FName& BoneName);
	void SetPhysicsMaxAngularVelocityInDegrees(float NewMaxAngVel, bool bAddToCurrent, const struct FName& BoneName);
	void SetPhysicsMaxAngularVelocity(float NewMaxAngVel, bool bAddToCurrent, const struct FName& BoneName);
	void SetPhysicsLinearVelocity(const struct FVector& NewVel, bool bAddToCurrent, const struct FName& BoneName);
	void SetPhysicsAngularVelocityInRadians(const struct FVector& NewAngVel, bool bAddToCurrent, const struct FName& BoneName);
	void SetPhysicsAngularVelocityInDegrees(const struct FVector& NewAngVel, bool bAddToCurrent, const struct FName& BoneName);
	void SetPhysicsAngularVelocity(const struct FVector& NewAngVel, bool bAddToCurrent, const struct FName& BoneName);
	void SetOwnerNoSee(bool bNewOwnerNoSee);
	void SetOnlyOwnerSee(bool bNewOnlyOwnerSee);
	void SetNotifyRigidBodyCollision(bool bNewNotifyRigidBodyCollision);
	void SetMaterialByName(const struct FName& MaterialSlotName, class UMaterialInterface* Material);
	void SetMaterial(int ElementIndex, class UMaterialInterface* Material);
	void SetMassScale(const struct FName& BoneName, float InMassScale);
	void SetMassOverrideInKg(const struct FName& BoneName, float MassInKg, bool bOverrideMass);
	void SetLockedAxis(TEnumAsByte<EDOFMode> LockedAxis);
	void SetLinearDamping(float InDamping);
	void SetEnableGravity(bool bGravityEnabled);
	void SetCustomDepthStencilWriteMask(ERendererStencilMask WriteMaskBit);
	void SetCustomDepthStencilValue(int Value);
	void SetCullDistance(float NewCullDistance);
	void SetConstraintMode(TEnumAsByte<EDOFMode> ConstraintMode);
	void SetCollisionResponseToChannel(TEnumAsByte<ECollisionChannel> Channel, TEnumAsByte<ECollisionResponse> NewResponse);
	void SetCollisionResponseToAllChannels(TEnumAsByte<ECollisionResponse> NewResponse);
	void SetCollisionProfileName(const struct FName& InCollisionProfileName);
	void SetCollisionObjectType(TEnumAsByte<ECollisionChannel> Channel);
	void SetCollisionEnabled(TEnumAsByte<ECollisionEnabled> NewType);
	void SetCenterOfMass(const struct FVector& CenterOfMassOffset, const struct FName& BoneName);
	void SetCastShadow(bool NewCastShadow);
	void SetBoundsScale(float NewBoundsScale);
	void SetAngularDamping(float InDamping);
	void SetAllUseCCD(bool InUseCCD);
	void SetAllPhysicsLinearVelocity(const struct FVector& NewVel, bool bAddToCurrent);
	void SetAllPhysicsAngularVelocityInRadians(const struct FVector& NewAngVel, bool bAddToCurrent);
	void SetAllPhysicsAngularVelocityInDegrees(const struct FVector& NewAngVel, bool bAddToCurrent);
	void SetAllPhysicsAngularVelocity(const struct FVector& NewAngVel, bool bAddToCurrent);
	void SetAllMassScale(float InMassScale);
	struct FVector ScaleByMomentOfInertia(const struct FVector& InputVector, const struct FName& BoneName);
	void PutRigidBodyToSleep(const struct FName& BoneName);
	bool K2_LineTraceComponent(const struct FVector& TraceStart, const struct FVector& TraceEnd, bool bTraceComplex, bool bShowTrace, struct FVector* HitLocation, struct FVector* HitNormal, struct FName* BoneName, struct FHitResult* OutHit);
	bool K2_IsQueryCollisionEnabled();
	bool K2_IsPhysicsCollisionEnabled();
	bool K2_IsCollisionEnabled();
	bool IsOverlappingComponent(class UPrimitiveComponent* OtherComp);
	bool IsOverlappingActor(class AActor* Other);
	bool IsGravityEnabled();
	bool IsAnyRigidBodyAwake();
	void IgnoreComponentWhenMoving(class UPrimitiveComponent* Component, bool bShouldIgnore);
	void IgnoreActorWhenMoving(class AActor* Actor, bool bShouldIgnore);
	struct FWalkableSlopeOverride GetWalkableSlopeOverride();
	struct FVector GetPhysicsLinearVelocityAtPoint(const struct FVector& Point, const struct FName& BoneName);
	struct FVector GetPhysicsLinearVelocity(const struct FName& BoneName);
	struct FVector GetPhysicsAngularVelocityInRadians(const struct FName& BoneName);
	struct FVector GetPhysicsAngularVelocityInDegrees(const struct FName& BoneName);
	struct FVector GetPhysicsAngularVelocity(const struct FName& BoneName);
	void GetOverlappingComponents(TArray<class UPrimitiveComponent*>* InOverlappingComponents);
	void GetOverlappingActors(class UClass* ClassFilter, TArray<class AActor*>* OverlappingActors);
	int GetNumMaterials();
	class UMaterialInterface* GetMaterialFromCollisionFaceIndex(int FaceIndex, int* SectionIndex);
	class UMaterialInterface* GetMaterial(int ElementIndex);
	float GetMassScale(const struct FName& BoneName);
	float GetMass();
	float GetLinearDamping();
	struct FVector GetInertiaTensor(const struct FName& BoneName);
	TEnumAsByte<ECollisionResponse> GetCollisionResponseToChannel(TEnumAsByte<ECollisionChannel> Channel);
	struct FName GetCollisionProfileName();
	TEnumAsByte<ECollisionChannel> GetCollisionObjectType();
	TEnumAsByte<ECollisionEnabled> GetCollisionEnabled();
	float GetClosestPointOnCollision(const struct FVector& Point, const struct FName& BoneName, struct FVector* OutPointOnBody);
	struct FVector GetCenterOfMass(const struct FName& BoneName);
	float GetAngularDamping();
	class UMaterialInstanceDynamic* CreateDynamicMaterialInstance(int ElementIndex, class UMaterialInterface* SourceMaterial);
	class UMaterialInstanceDynamic* CreateAndSetMaterialInstanceDynamicFromMaterial(int ElementIndex, class UMaterialInterface* Parent);
	class UMaterialInstanceDynamic* CreateAndSetMaterialInstanceDynamic(int ElementIndex);
	TArray<class UPrimitiveComponent*> CopyArrayOfMoveIgnoreComponents();
	TArray<class AActor*> CopyArrayOfMoveIgnoreActors();
	void ClearMoveIgnoreComponents();
	void ClearMoveIgnoreActors();
	bool CanCharacterStepUp(class APawn* Pawn);
	void AddTorqueInRadians(const struct FVector& Torque, const struct FName& BoneName, bool bAccelChange);
	void AddTorqueInDegrees(const struct FVector& Torque, const struct FName& BoneName, bool bAccelChange);
	void AddTorque(const struct FVector& Torque, const struct FName& BoneName, bool bAccelChange);
	void AddRadialImpulse(const struct FVector& Origin, float Radius, float Strength, TEnumAsByte<ERadialImpulseFalloff> Falloff, bool bVelChange);
	void AddRadialForce(const struct FVector& Origin, float Radius, float Strength, TEnumAsByte<ERadialImpulseFalloff> Falloff, bool bAccelChange);
	void AddImpulseAtLocation(const struct FVector& Impulse, const struct FVector& Location, const struct FName& BoneName);
	void AddImpulse(const struct FVector& Impulse, const struct FName& BoneName, bool bVelChange);
	void AddForceAtLocationLocal(const struct FVector& Force, const struct FVector& Location, const struct FName& BoneName);
	void AddForceAtLocation(const struct FVector& Force, const struct FVector& Location, const struct FName& BoneName);
	void AddForce(const struct FVector& Force, const struct FName& BoneName, bool bAccelChange);
	void AddAngularImpulseInRadians(const struct FVector& Impulse, const struct FName& BoneName, bool bVelChange);
	void AddAngularImpulseInDegrees(const struct FVector& Impulse, const struct FName& BoneName, bool bVelChange);
	void AddAngularImpulse(const struct FVector& Impulse, const struct FName& BoneName, bool bVelChange);
};


// Class Engine.MeshComponent
// 0x0030 (0x0690 - 0x0660)
class UMeshComponent : public UPrimitiveComponent
{
public:
	TArray<class UMaterialInterface*>                  OverrideMaterials;                                        // 0x0660(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	unsigned char                                      UnknownData00[0x20];                                      // 0x0670(0x0020) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MeshComponent");
		return ptr;
	}


	void SetVectorParameterValueOnMaterials(const struct FName& ParameterName, const struct FVector& ParameterValue);
	void SetScalarParameterValueOnMaterials(const struct FName& ParameterName, float ParameterValue);
	void PrestreamTextures(float Seconds, bool bPrioritizeCharacterTextures, int CinematicTextureGroups);
	bool IsMaterialSlotNameValid(const struct FName& MaterialSlotName);
	TArray<struct FName> GetMaterialSlotNames();
	TArray<class UMaterialInterface*> GetMaterials();
	int GetMaterialIndex(const struct FName& MaterialSlotName);
};


// Class Engine.SkinnedMeshComponent
// 0x0170 (0x0800 - 0x0690)
class USkinnedMeshComponent : public UMeshComponent
{
public:
	TWeakObjectPtr<class USkinnedMeshComponent>        MasterPoseComponent;                                      // 0x0690(0x0008) (CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x74];                                      // 0x0698(0x0074) MISSED OFFSET
	struct FColor                                      WireframeColor;                                           // 0x070C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x28];                                      // 0x0710(0x0028) MISSED OFFSET
	class UPhysicsAsset*                               PhysicsAssetOverride;                                     // 0x0738(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                ForcedLodModel;                                           // 0x0740(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                MinLodModel;                                              // 0x0744(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0xC];                                       // 0x0748(0x000C) MISSED OFFSET
	float                                              StreamingDistanceMultiplier;                              // 0x0754(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<struct FSkelMeshComponentLODInfo>           LODInfo;                                                  // 0x0758(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	unsigned char                                      UnknownData03[0x10];                                      // 0x0768(0x0010) MISSED OFFSET
	TEnumAsByte<EMeshComponentUpdateFlag>              MeshComponentUpdateFlag;                                  // 0x0778(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bUseBoundsFromMasterPoseComponent : 1;                    // 0x0779(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bForceWireframe : 1;                                      // 0x0779(0x0001)
	unsigned char                                      bDisplayBones : 1;                                        // 0x0779(0x0001) (CPF_Deprecated)
	unsigned char                                      bDisableMorphTarget : 1;                                  // 0x0779(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bHideSkin : 1;                                            // 0x0779(0x0001)
	unsigned char                                      bPerBoneMotionBlur : 1;                                   // 0x0779(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bComponentUseFixedSkelBounds : 1;                         // 0x0779(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bConsiderAllBodiesForBounds : 1;                          // 0x0779(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData04[0x2];                                       // 0x077A(0x0002) MISSED OFFSET
	unsigned char                                      bSyncAttachParentLOD : 1;                                 // 0x077C(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData05[0x3];                                       // 0x077D(0x0003) MISSED OFFSET
	unsigned char                                      bCanHighlightSelectedSections : 1;                        // 0x0780(0x0001) (CPF_Transient)
	unsigned char                                      bRecentlyRendered : 1;                                    // 0x0780(0x0001) (CPF_Transient)
	unsigned char                                      bCastCapsuleDirectShadow : 1;                             // 0x0780(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bCastCapsuleIndirectShadow : 1;                           // 0x0780(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bCPUSkinning : 1;                                         // 0x0780(0x0001) (CPF_Transient)
	unsigned char                                      bEnableUpdateRateOptimizations : 1;                       // 0x0780(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bDisplayDebugUpdateRateOptimizations : 1;                 // 0x0780(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData06 : 1;                                        // 0x0780(0x0001)
	unsigned char                                      UnknownData07 : 1;                                        // 0x0781(0x0001)
	unsigned char                                      bCachedLocalBoundsUpToDate : 1;                           // 0x0781(0x0001) (CPF_Transient)
	unsigned char                                      bForceMeshObjectUpdate : 1;                               // 0x0781(0x0001) (CPF_Transient)
	unsigned char                                      UnknownData08[0xE];                                       // 0x0782(0x000E) MISSED OFFSET
	float                                              CapsuleIndirectShadowMinVisibility;                       // 0x0790(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FBoxSphereBounds                            CachedLocalBounds;                                        // 0x0794(0x001C) (CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData09[0x50];                                      // 0x07B0(0x0050) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.SkinnedMeshComponent");
		return ptr;
	}


	void UnHideBoneByName(const struct FName& BoneName);
	void TransformToBoneSpace(const struct FName& BoneName, const struct FVector& InPosition, const struct FRotator& InRotation, struct FVector* OutPosition, struct FRotator* OutRotation);
	void TransformFromBoneSpace(const struct FName& BoneName, const struct FVector& InPosition, const struct FRotator& InRotation, struct FVector* OutPosition, struct FRotator* OutRotation);
	void ShowMaterialSection(int MaterialID, bool bShow, int LODIndex);
	void ShowAllMaterialSections(int LODIndex);
	void SetVertexColorOverride_LinearColor(int LODIndex, TArray<struct FLinearColor> VertexColors);
	void SetSkinWeightOverride(int LODIndex, TArray<struct FSkelMeshSkinWeightInfo> SkinWeights);
	void SetSkeletalMesh(class USkeletalMesh* NewMesh, bool bReinitPose);
	void SetPhysicsAsset(class UPhysicsAsset* NewPhysicsAsset, bool bForceReInit);
	void SetMinLOD(int InNewMinLOD);
	void SetMasterPoseComponent(class USkinnedMeshComponent* NewMasterBoneComponent);
	void SetForcedLOD(int InNewForcedLOD);
	void SetCastCapsuleIndirectShadow(bool bNewValue);
	void SetCastCapsuleDirectShadow(bool bNewValue);
	void SetCapsuleIndirectShadowMinVisibility(float NewValue);
	bool IsMaterialSectionShown(int MaterialID, int LODIndex);
	bool IsBoneHiddenByName(const struct FName& BoneName);
	void HideBoneByName(const struct FName& BoneName, TEnumAsByte<EPhysBodyOp> PhysBodyOption);
	struct FName GetSocketBoneName(const struct FName& InSocketName);
	struct FVector GetRefPosePosition(int BoneIndex);
	struct FName GetParentBone(const struct FName& BoneName);
	int GetNumLODs();
	int GetNumBones();
	struct FName GetBoneName(int BoneIndex);
	int GetBoneIndex(const struct FName& BoneName);
	struct FName FindClosestBone_K2(const struct FVector& TestLocation, float IgnoreScale, bool bRequirePhysicsAsset, struct FVector* BoneLocation);
	void ClearVertexColorOverride(int LODIndex);
	void ClearSkinWeightOverride(int LODIndex);
	bool BoneIsChildOf(const struct FName& BoneName, const struct FName& ParentBoneName);
};


// Class Engine.SkeletalMeshComponent
// 0x0500 (0x0D00 - 0x0800)
class USkeletalMeshComponent : public USkinnedMeshComponent
{
public:
	class UAnimBlueprintGeneratedClass*                AnimBlueprintGeneratedClass;                              // 0x0800(0x0008) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      AnimClass;                                                // 0x0808(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UAnimInstance*                               AnimScriptInstance;                                       // 0x0810(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	TArray<class UAnimInstance*>                       SubInstances;                                             // 0x0818(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	class UAnimInstance*                               PostProcessAnimInstance;                                  // 0x0828(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	bool                                               bDisablePostProcessBlueprint;                             // 0x0830(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0831(0x0007) MISSED OFFSET
	struct FSingleAnimationPlayData                    AnimationData;                                            // 0x0838(0x0018) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData01[0x10];                                      // 0x0850(0x0010) MISSED OFFSET
	struct FVector                                     RootBoneTranslation;                                      // 0x0860(0x000C) (CPF_Transient, CPF_IsPlainOldData)
	struct FVector                                     LineCheckBoundsScale;                                     // 0x086C(0x000C) (CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x20];                                      // 0x0878(0x0020) MISSED OFFSET
	TArray<struct FTransform>                          CachedBoneSpaceTransforms;                                // 0x0898(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	TArray<struct FTransform>                          CachedComponentSpaceTransforms;                           // 0x08A8(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	unsigned char                                      UnknownData03[0x20];                                      // 0x08B8(0x0020) MISSED OFFSET
	float                                              GlobalAnimRateScale;                                      // 0x08D8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	EDynamicActorScene                                 UseAsyncScene;                                            // 0x08DC(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EKinematicBonesUpdateToPhysics>        KinematicBonesUpdateType;                                 // 0x08DD(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EPhysicsTransformUpdateMode>           PhysicsTransformUpdateMode;                               // 0x08DE(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData04[0x1];                                       // 0x08DF(0x0001) MISSED OFFSET
	TEnumAsByte<EAnimationMode>                        AnimationMode;                                            // 0x08E0(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData05[0x1];                                       // 0x08E1(0x0001) MISSED OFFSET
	unsigned char                                      UnknownData06 : 1;                                        // 0x08E2(0x0001)
	unsigned char                                      bHasValidBodies : 1;                                      // 0x08E2(0x0001) (CPF_Transient)
	unsigned char                                      UnknownData07 : 1;                                        // 0x08E2(0x0001)
	unsigned char                                      bBlendPhysics : 1;                                        // 0x08E2(0x0001) (CPF_Transient)
	unsigned char                                      bEnablePhysicsOnDedicatedServer : 1;                      // 0x08E2(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bUpdateJointsFromAnimation : 1;                           // 0x08E2(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bDisableClothSimulation : 1;                              // 0x08E2(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bAllowAnimCurveEvaluation : 1;                            // 0x08E2(0x0001) (CPF_Edit)
	unsigned char                                      bDisableAnimCurves : 1;                                   // 0x08E3(0x0001) (CPF_Deprecated)
	unsigned char                                      UnknownData08 : 3;                                        // 0x08E3(0x0001)
	unsigned char                                      bCollideWithEnvironment : 1;                              // 0x08E3(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bCollideWithAttachedChildren : 1;                         // 0x08E3(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bLocalSpaceSimulation : 1;                                // 0x08E3(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bResetAfterTeleport : 1;                                  // 0x08E3(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData09 : 1;                                        // 0x08E4(0x0001)
	unsigned char                                      bDeferMovementFromSceneQueries : 1;                       // 0x08E4(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bNoSkeletonUpdate : 1;                                    // 0x08E4(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bPauseAnims : 1;                                          // 0x08E4(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bUseRefPoseOnInitAnim : 1;                                // 0x08E4(0x0001) (CPF_Edit)
	unsigned char                                      bEnablePerPolyCollision : 1;                              // 0x08E4(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bForceRefpose : 1;                                        // 0x08E4(0x0001)
	unsigned char                                      bOnlyAllowAutonomousTickPose : 1;                         // 0x08E4(0x0001) (CPF_Transient)
	unsigned char                                      bIsAutonomousTickPose : 1;                                // 0x08E5(0x0001) (CPF_Transient)
	unsigned char                                      bOldForceRefPose : 1;                                     // 0x08E5(0x0001)
	unsigned char                                      bShowPrePhysBones : 1;                                    // 0x08E5(0x0001)
	unsigned char                                      bRequiredBonesUpToDate : 1;                               // 0x08E5(0x0001) (CPF_Transient)
	unsigned char                                      bAnimTreeInitialised : 1;                                 // 0x08E5(0x0001) (CPF_Transient)
	unsigned char                                      bIncludeComponentLocationIntoBounds : 1;                  // 0x08E5(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bEnableLineCheckWithBounds : 1;                           // 0x08E5(0x0001)
	unsigned char                                      UnknownData10 : 1;                                        // 0x08E5(0x0001)
	unsigned char                                      bNeedsQueuedAnimEventsDispatched : 1;                     // 0x08E6(0x0001) (CPF_Transient)
	unsigned char                                      UnknownData11[0x1];                                       // 0x08E7(0x0001) MISSED OFFSET
	TArray<struct FName>                               DisallowedAnimCurves;                                     // 0x08E8(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	uint16_t                                           CachedAnimCurveUidVersion;                                // 0x08F8(0x0002) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData12[0x2];                                       // 0x08FA(0x0002) MISSED OFFSET
	float                                              ClothBlendWeight;                                         // 0x08FC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UBodySetup*                                  BodySetup;                                                // 0x0900(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData13[0x8];                                       // 0x0908(0x0008) MISSED OFFSET
	struct FScriptMulticastDelegate                    OnConstraintBroken;                                       // 0x0910(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	class UClass*                                      ClothingSimulationFactory;                                // 0x0920(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData14[0xF8];                                      // 0x0928(0x00F8) MISSED OFFSET
	float                                              TeleportDistanceThreshold;                                // 0x0A20(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              TeleportRotationThreshold;                                // 0x0A24(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData15[0x8];                                       // 0x0A28(0x0008) MISSED OFFSET
	uint32_t                                           LastPoseTickFrame;                                        // 0x0A30(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData16[0x5C];                                      // 0x0A34(0x005C) MISSED OFFSET
	class UClothingSimulationInteractor*               ClothingInteractor;                                       // 0x0A90(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData17[0xA8];                                      // 0x0A98(0x00A8) MISSED OFFSET
	struct FScriptMulticastDelegate                    OnAnimInitialized;                                        // 0x0B40(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	unsigned char                                      UnknownData18[0x1B0];                                     // 0x0B50(0x01B0) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.SkeletalMeshComponent");
		return ptr;
	}


	void UnbindClothFromMasterPoseComponent(bool bRestoreSimulationSpace);
	void ToggleDisablePostProcessBlueprint();
	void SuspendClothingSimulation();
	void Stop();
	void SnapshotPose(struct FPoseSnapshot* Snapshot);
	void SetUpdateAnimationInEditor(bool NewUpdateState);
	void SetTeleportRotationThreshold(float Threshold);
	void SetTeleportDistanceThreshold(float Threshold);
	void SetPosition(float InPos, bool bFireNotifies);
	void SetPlayRate(float Rate);
	void SetPhysicsBlendWeight(float PhysicsBlendWeight);
	void SetNotifyRigidBodyCollisionBelow(bool bNewNotifyRigidBodyCollision, const struct FName& BoneName, bool bIncludeSelf);
	void SetMorphTarget(const struct FName& MorphTargetName, float Value, bool bRemoveZeroWeight);
	void SetEnablePhysicsBlending(bool bNewBlendPhysics);
	void SetEnableGravityOnAllBodiesBelow(bool bEnableGravity, const struct FName& BoneName, bool bIncludeSelf);
	void SetEnableBodyGravity(bool bEnableGravity, const struct FName& BoneName);
	void SetDisablePostProcessBlueprint(bool bInDisablePostProcess);
	void SetDisableAnimCurves(bool bInDisableAnimCurves);
	void SetConstraintProfileForAll(const struct FName& ProfileName, bool bDefaultIfNotFound);
	void SetConstraintProfile(const struct FName& JointName, const struct FName& ProfileName, bool bDefaultIfNotFound);
	void SetClothMaxDistanceScale(float Scale);
	void SetBodyNotifyRigidBodyCollision(bool bNewNotifyRigidBodyCollision, const struct FName& BoneName);
	void SetAnimInstanceClass(class UClass* NewClass);
	void SetAnimationMode(TEnumAsByte<EAnimationMode> InAnimationMode);
	void SetAnimation(class UAnimationAsset* NewAnimToPlay);
	void SetAngularLimits(const struct FName& InBoneName, float Swing1LimitAngle, float TwistLimitAngle, float Swing2LimitAngle);
	void SetAllowedAnimCurvesEvaluation(TArray<struct FName> List, bool bAllow);
	void SetAllowAnimCurveEvaluation(bool bInAllow);
	void SetAllMotorsAngularVelocityDrive(bool bEnableSwingDrive, bool bEnableTwistDrive, bool bSkipCustomPhysicsType);
	void SetAllMotorsAngularPositionDrive(bool bEnableSwingDrive, bool bEnableTwistDrive, bool bSkipCustomPhysicsType);
	void SetAllMotorsAngularDriveParams(float InSpring, float InDamping, float InForceLimit, bool bSkipCustomPhysicsType);
	void SetAllBodiesSimulatePhysics(bool bNewSimulate);
	void SetAllBodiesPhysicsBlendWeight(float PhysicsBlendWeight, bool bSkipCustomPhysicsType);
	void SetAllBodiesBelowSimulatePhysics(const struct FName& InBoneName, bool bNewSimulate, bool bIncludeSelf);
	void SetAllBodiesBelowPhysicsBlendWeight(const struct FName& InBoneName, float PhysicsBlendWeight, bool bSkipCustomPhysicsType, bool bIncludeSelf);
	void ResumeClothingSimulation();
	void ResetClothTeleportMode();
	void ResetAllowedAnimCurveEvaluation();
	void ResetAllBodiesSimulatePhysics();
	void PlayAnimation(class UAnimationAsset* NewAnimToPlay, bool bLooping);
	void Play(bool bLooping);
	void OverrideAnimationData(class UAnimationAsset* InAnimToPlay, bool bIsLooping, bool bIsPlaying, float Position, float PlayRate);
	bool K2_GetClosestPointOnPhysicsAsset(const struct FVector& WorldPosition, struct FVector* ClosestWorldPosition, struct FVector* Normal, struct FName* BoneName, float* Distance);
	bool IsPlaying();
	bool IsClothingSimulationSuspended();
	bool IsBodyGravityEnabled(const struct FName& BoneName);
	float GetTeleportRotationThreshold();
	float GetTeleportDistanceThreshold();
	struct FVector GetSkeletalCenterOfMass();
	class UAnimInstance* GetPostProcessInstance();
	float GetPosition();
	float GetPlayRate();
	float GetMorphTarget(const struct FName& MorphTargetName);
	bool GetDisablePostProcessBlueprint();
	bool GetDisableAnimCurves();
	void GetCurrentJointAngles(const struct FName& InBoneName, float* Swing1Angle, float* TwistAngle, float* Swing2Angle);
	float GetClothMaxDistanceScale();
	class UClothingSimulationInteractor* GetClothingSimulationInteractor();
	float GetBoneMass(const struct FName& BoneName, bool bScaleMass);
	class UAnimInstance* GetAnimInstance();
	TEnumAsByte<EAnimationMode> GetAnimationMode();
	bool GetAllowedAnimCurveEvaluate();
	void ForceClothNextUpdateTeleportAndReset();
	void ForceClothNextUpdateTeleport();
	struct FName FindConstraintBoneName(int ConstraintIndex);
	void ClearMorphTargets();
	void BreakConstraint(const struct FVector& Impulse, const struct FVector& HitLocation, const struct FName& InBoneName);
	void BindClothToMasterPoseComponent();
	void AllowAnimCurveEvaluation(const struct FName& NameOfCurve, bool bAllow);
	void AddImpulseToAllBodiesBelow(const struct FVector& Impulse, const struct FName& BoneName, bool bVelChange, bool bIncludeSelf);
	void AddForceToAllBodiesBelow(const struct FVector& Force, const struct FName& BoneName, bool bAccelChange, bool bIncludeSelf);
	void AccumulateAllBodiesBelowPhysicsBlendWeight(const struct FName& InBoneName, float AddPhysicsBlendWeight, bool bSkipCustomPhysicsType);
};


// Class Engine.AnimInstance
// 0x0398 (0x03C0 - 0x0028)
class UAnimInstance : public UObject
{
public:
	float                                              DeltaTime;                                                // 0x0028(0x0004) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x002C(0x0004) MISSED OFFSET
	class USkeleton*                                   CurrentSkeleton;                                          // 0x0030(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	TEnumAsByte<ERootMotionMode>                       RootMotionMode;                                           // 0x0038(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	bool                                               bRunUpdatesInWorkerThreads;                               // 0x0039(0x0001) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	bool                                               bCanUseParallelUpdateAnimation;                           // 0x003A(0x0001) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	bool                                               bUseMultiThreadedAnimationUpdate;                         // 0x003B(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bWarnAboutBlueprintUsage;                                 // 0x003C(0x0001) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x3];                                       // 0x003D(0x0003) MISSED OFFSET
	struct FScriptMulticastDelegate                    OnMontageBlendingOut;                                     // 0x0040(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnMontageStarted;                                         // 0x0050(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnMontageEnded;                                           // 0x0060(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnAllMontageInstancesEnded;                               // 0x0070(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	unsigned char                                      UnknownData02[0x60];                                      // 0x0080(0x0060) MISSED OFFSET
	bool                                               bQueueMontageEvents;                                      // 0x00E0(0x0001) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0x2F];                                      // 0x00E1(0x002F) MISSED OFFSET
	struct FAnimNotifyQueue                            NotifyQueue;                                              // 0x0110(0x0070) (CPF_Transient)
	TArray<struct FAnimNotifyEvent>                    ActiveAnimNotifyState;                                    // 0x0180(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	unsigned char                                      UnknownData04[0x230];                                     // 0x0190(0x0230) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimInstance");
		return ptr;
	}


	void UnlockAIResources(bool bUnlockMovement, bool UnlockAILogic);
	class APawn* TryGetPawnOwner();
	void StopSlotAnimation(float InBlendOutTime, const struct FName& SlotNodeName);
	void SnapshotPose(struct FPoseSnapshot* Snapshot);
	void SetRootMotionMode(TEnumAsByte<ERootMotionMode> Value);
	void SetMorphTarget(const struct FName& MorphTargetName, float Value);
	void SavePoseSnapshot(const struct FName& SnapshotName);
	class UAnimMontage* PlaySlotAnimationAsDynamicMontage(class UAnimSequenceBase* Asset, const struct FName& SlotNodeName, float BlendInTime, float BlendOutTime, float InPlayRate, int LoopCount, float BlendOutTriggerTime, float InTimeToStartMontageAt);
	float PlaySlotAnimation(class UAnimSequenceBase* Asset, const struct FName& SlotNodeName, float BlendInTime, float BlendOutTime, float InPlayRate, int LoopCount);
	void Montage_Stop(float InBlendOutTime, class UAnimMontage* Montage);
	void Montage_SetPosition(class UAnimMontage* Montage, float NewPosition);
	void Montage_SetPlayRate(class UAnimMontage* Montage, float NewPlayRate);
	void Montage_SetNextSection(const struct FName& SectionNameToChange, const struct FName& NextSection, class UAnimMontage* Montage);
	void Montage_Resume(class UAnimMontage* Montage);
	float Montage_Play(class UAnimMontage* MontageToPlay, float InPlayRate, EMontagePlayReturnType ReturnValueType, float InTimeToStartMontageAt, bool bStopAllMontages);
	void Montage_Pause(class UAnimMontage* Montage);
	void Montage_JumpToSectionsEnd(const struct FName& SectionName, class UAnimMontage* Montage);
	void Montage_JumpToSection(const struct FName& SectionName, class UAnimMontage* Montage);
	bool Montage_IsPlaying(class UAnimMontage* Montage);
	bool Montage_IsActive(class UAnimMontage* Montage);
	float Montage_GetPosition(class UAnimMontage* Montage);
	float Montage_GetPlayRate(class UAnimMontage* Montage);
	bool Montage_GetIsStopped(class UAnimMontage* Montage);
	struct FName Montage_GetCurrentSection(class UAnimMontage* Montage);
	float Montage_GetBlendTime(class UAnimMontage* Montage);
	void LockAIResources(bool bLockMovement, bool LockAILogic);
	bool IsSyncGroupBetweenMarkers(const struct FName& InSyncGroupName, const struct FName& PreviousMarker, const struct FName& NextMarker, bool bRespectMarkerOrder);
	bool IsPlayingSlotAnimation(class UAnimSequenceBase* Asset, const struct FName& SlotNodeName);
	bool IsAnyMontagePlaying();
	bool HasMarkerBeenHitThisFrame(const struct FName& SyncGroup, const struct FName& MarkerName);
	bool GetTimeToClosestMarker(const struct FName& SyncGroup, const struct FName& MarkerName, float* OutMarkerTime);
	struct FMarkerSyncAnimPosition GetSyncGroupPosition(const struct FName& InSyncGroupName);
	float GetRelevantAnimTimeRemainingFraction(int MachineIndex, int StateIndex);
	float GetRelevantAnimTimeRemaining(int MachineIndex, int StateIndex);
	float GetRelevantAnimTimeFraction(int MachineIndex, int StateIndex);
	float GetRelevantAnimTime(int MachineIndex, int StateIndex);
	float GetRelevantAnimLength(int MachineIndex, int StateIndex);
	class USkeletalMeshComponent* GetOwningComponent();
	class AActor* GetOwningActor();
	float GetInstanceTransitionTimeElapsedFraction(int MachineIndex, int TransitionIndex);
	float GetInstanceTransitionTimeElapsed(int MachineIndex, int TransitionIndex);
	float GetInstanceTransitionCrossfadeDuration(int MachineIndex, int TransitionIndex);
	float GetInstanceStateWeight(int MachineIndex, int StateIndex);
	float GetInstanceMachineWeight(int MachineIndex);
	float GetInstanceCurrentStateElapsedTime(int MachineIndex);
	float GetInstanceAssetPlayerTimeFromEndFraction(int AssetPlayerIndex);
	float GetInstanceAssetPlayerTimeFromEnd(int AssetPlayerIndex);
	float GetInstanceAssetPlayerTimeFraction(int AssetPlayerIndex);
	float GetInstanceAssetPlayerTime(int AssetPlayerIndex);
	float GetInstanceAssetPlayerLength(int AssetPlayerIndex);
	float GetCurveValue(const struct FName& CurveName);
	struct FName GetCurrentStateName(int MachineIndex);
	class UAnimMontage* GetCurrentActiveMontage();
	void ClearMorphTargets();
	float CalculateDirection(const struct FVector& Velocity, const struct FRotator& BaseRotation);
	void BlueprintUpdateAnimation(float DeltaTimeX);
	void BlueprintPostEvaluateAnimation();
	void BlueprintInitializeAnimation();
	void BlueprintBeginPlay();
};


// Class Engine.DataAsset
// 0x0008 (0x0030 - 0x0028)
class UDataAsset : public UObject
{
public:
	class UClass*                                      NativeClass;                                              // 0x0028(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DataAsset");
		return ptr;
	}

};


// Class Engine.BlueprintFunctionLibrary
// 0x0000 (0x0028 - 0x0028)
class UBlueprintFunctionLibrary : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BlueprintFunctionLibrary");
		return ptr;
	}

};


// Class Engine.AnimNotify
// 0x0010 (0x0038 - 0x0028)
class UAnimNotify : public UObject
{
public:
	unsigned char                                      UnknownData00[0x10];                                      // 0x0028(0x0010) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimNotify");
		return ptr;
	}


	bool Received_Notify(class USkeletalMeshComponent* MeshComp, class UAnimSequenceBase* Animation);
	struct FString GetNotifyName();
};


// Class Engine.AnimNotifyState
// 0x0008 (0x0030 - 0x0028)
class UAnimNotifyState : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimNotifyState");
		return ptr;
	}


	bool Received_NotifyTick(class USkeletalMeshComponent* MeshComp, class UAnimSequenceBase* Animation, float FrameDeltaTime);
	bool Received_NotifyEnd(class USkeletalMeshComponent* MeshComp, class UAnimSequenceBase* Animation);
	bool Received_NotifyBegin(class USkeletalMeshComponent* MeshComp, class UAnimSequenceBase* Animation, float TotalDuration);
	struct FString GetNotifyName();
};


// Class Engine.AssetUserData
// 0x0000 (0x0028 - 0x0028)
class UAssetUserData : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AssetUserData");
		return ptr;
	}

};


// Class Engine.AssetManager
// 0x03A8 (0x03D0 - 0x0028)
class UAssetManager : public UObject
{
public:
	unsigned char                                      UnknownData00[0x230];                                     // 0x0028(0x0230) MISSED OFFSET
	TArray<class UObject*>                             ObjectReferenceList;                                      // 0x0258(0x0010) (CPF_ZeroConstructor)
	bool                                               bIsGlobalAsyncScanEnvironment;                            // 0x0268(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bShouldGuessTypeAndName;                                  // 0x0269(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bShouldUseSynchronousLoad;                                // 0x026A(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bIsLoadingFromPakFiles;                                   // 0x026B(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bShouldAcquireMissingChunksOnLoad;                        // 0x026C(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bOnlyCookProductionAssets;                                // 0x026D(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bIsBulkScanning;                                          // 0x026E(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bIsManagementDatabaseCurrent;                             // 0x026F(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bUpdateManagementDatabaseAfterScan;                       // 0x0270(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bIncludeOnlyOnDiskAssets;                                 // 0x0271(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x2];                                       // 0x0272(0x0002) MISSED OFFSET
	int                                                NumberOfSpawnedNotifications;                             // 0x0274(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x158];                                     // 0x0278(0x0158) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AssetManager");
		return ptr;
	}

};


// Class Engine.GameInstance
// 0x00C8 (0x00F0 - 0x0028)
class UGameInstance : public UObject
{
public:
	unsigned char                                      UnknownData00[0x10];                                      // 0x0028(0x0010) MISSED OFFSET
	TArray<class ULocalPlayer*>                        LocalPlayers;                                             // 0x0038(0x0010) (CPF_ZeroConstructor)
	class UOnlineSession*                              OnlineSession;                                            // 0x0048(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0xA0];                                      // 0x0050(0x00A0) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.GameInstance");
		return ptr;
	}


	void ReceiveShutdown();
	void ReceiveInit();
	void HandleTravelError(TEnumAsByte<ETravelFailure> FailureType);
	void HandleNetworkError(TEnumAsByte<ENetworkFailure> FailureType, bool bIsServer);
	void DebugRemovePlayer(int ControllerId);
	void DebugCreatePlayer(int ControllerId);
};


// Class Engine.Info
// 0x0000 (0x0318 - 0x0318)
class AInfo : public AActor
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Info");
		return ptr;
	}

};


// Class Engine.GameModeBase
// 0x00A0 (0x03B8 - 0x0318)
class AGameModeBase : public AInfo
{
public:
	struct FString                                     OptionsString;                                            // 0x0318(0x0010) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor)
	class UClass*                                      GameSessionClass;                                         // 0x0328(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      GameStateClass;                                           // 0x0330(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_NoClear, CPF_IsPlainOldData)
	class UClass*                                      PlayerControllerClass;                                    // 0x0338(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_NoClear, CPF_IsPlainOldData)
	class UClass*                                      PlayerStateClass;                                         // 0x0340(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_NoClear, CPF_IsPlainOldData)
	class UClass*                                      HUDClass;                                                 // 0x0348(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      DefaultPawnClass;                                         // 0x0350(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      SpectatorClass;                                           // 0x0358(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_NoClear, CPF_IsPlainOldData)
	class UClass*                                      ReplaySpectatorPlayerControllerClass;                     // 0x0360(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_NoClear, CPF_IsPlainOldData)
	class UClass*                                      ServerStatReplicatorClass;                                // 0x0368(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_NoClear, CPF_IsPlainOldData)
	class AGameSession*                                GameSession;                                              // 0x0370(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class AGameStateBase*                              GameState;                                                // 0x0378(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class AServerStatReplicator*                       ServerStatReplicator;                                     // 0x0380(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	struct FText                                       DefaultPlayerName;                                        // 0x0388(0x0018) (CPF_Edit)
	unsigned char                                      bUseSeamlessTravel : 1;                                   // 0x03A0(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bStartPlayersAsSpectators : 1;                            // 0x03A0(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bPauseable : 1;                                           // 0x03A0(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData00[0x17];                                      // 0x03A1(0x0017) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.GameModeBase");
		return ptr;
	}


	void StartPlay();
	class APawn* SpawnDefaultPawnFor(class AController* NewPlayer, class AActor* StartSpot);
	class APawn* SpawnDefaultPawnAtTransform(class AController* NewPlayer, const struct FTransform& SpawnTransform);
	bool ShouldReset(class AActor* ActorToReset);
	void ReturnToMainMenuHost();
	void RestartPlayerAtTransform(class AController* NewPlayer, const struct FTransform& SpawnTransform);
	void RestartPlayerAtPlayerStart(class AController* NewPlayer, class AActor* StartSpot);
	void RestartPlayer(class AController* NewPlayer);
	void ResetLevel();
	bool PlayerCanRestart(class APlayerController* Player);
	bool MustSpectate(class APlayerController* NewPlayerController);
	void K2_PostLogin(class APlayerController* NewPlayer);
	void K2_OnSwapPlayerControllers(class APlayerController* OldPC, class APlayerController* NewPC);
	void K2_OnRestartPlayer(class AController* NewPlayer);
	void K2_OnLogout(class AController* ExitingController);
	void K2_OnChangeName(class AController* Other, const struct FString& NewName, bool bNameChange);
	class AActor* K2_FindPlayerStart(class AController* Player, const struct FString& IncomingName);
	void InitStartSpot(class AActor* StartSpot, class AController* NewPlayer);
	void InitializeHUDForPlayer(class APlayerController* NewPlayer);
	bool HasMatchStarted();
	void HandleStartingNewPlayer(class APlayerController* NewPlayer);
	int GetNumSpectators();
	int GetNumPlayers();
	class UClass* GetDefaultPawnClassForController(class AController* InController);
	class AActor* FindPlayerStart(class AController* Player, const struct FString& IncomingName);
	class AActor* ChoosePlayerStart(class AController* Player);
	void ChangeName(class AController* Controller, const struct FString& NewName, bool bNameChange);
	bool CanSpectate(class APlayerController* Viewer, class APlayerState* ViewTarget);
};


// Class Engine.GameMode
// 0x0048 (0x0400 - 0x03B8)
class AGameMode : public AGameModeBase
{
public:
	struct FName                                       MatchState;                                               // 0x03B8(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      bDelayedStart : 1;                                        // 0x03C0(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData00[0x3];                                       // 0x03C1(0x0003) MISSED OFFSET
	int                                                NumSpectators;                                            // 0x03C4(0x0004) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                NumPlayers;                                               // 0x03C8(0x0004) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                NumBots;                                                  // 0x03CC(0x0004) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MinRespawnDelay;                                          // 0x03D0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                NumTravellingPlayers;                                     // 0x03D4(0x0004) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      EngineMessageClass;                                       // 0x03D8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<class APlayerState*>                        InactivePlayerArray;                                      // 0x03E0(0x0010) (CPF_ZeroConstructor)
	float                                              InactivePlayerStateLifeSpan;                              // 0x03F0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                MaxInactivePlayers;                                       // 0x03F4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bHandleDedicatedServerReplays;                            // 0x03F8(0x0001) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x7];                                       // 0x03F9(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.GameMode");
		return ptr;
	}


	void StartMatch();
	void SetBandwidthLimit(float AsyncIOBandwidthLimit);
	void Say(const struct FString& Msg);
	void RestartGame();
	bool ReadyToStartMatch();
	bool ReadyToEndMatch();
	void K2_OnSetMatchState(const struct FName& NewState);
	bool IsMatchInProgress();
	bool HasMatchEnded();
	struct FName GetMatchState();
	void EndMatch();
	void AbortMatch();
};


// Class Engine.GameSession
// 0x0018 (0x0330 - 0x0318)
class AGameSession : public AInfo
{
public:
	int                                                MaxSpectators;                                            // 0x0318(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	int                                                MaxPlayers;                                               // 0x031C(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	int                                                MaxPartySize;                                             // 0x0320(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      MaxSplitscreensPerConnection;                             // 0x0324(0x0001) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	bool                                               bRequiresPushToTalk;                                      // 0x0325(0x0001) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x2];                                       // 0x0326(0x0002) MISSED OFFSET
	struct FName                                       SessionName;                                              // 0x0328(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.GameSession");
		return ptr;
	}

};


// Class Engine.GameStateBase
// 0x0040 (0x0358 - 0x0318)
class AGameStateBase : public AInfo
{
public:
	class UClass*                                      GameModeClass;                                            // 0x0318(0x0008) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Net, CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class AGameModeBase*                               AuthorityGameMode;                                        // 0x0320(0x0008) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class UClass*                                      SpectatorClass;                                           // 0x0328(0x0008) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Net, CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	TArray<class APlayerState*>                        PlayerArray;                                              // 0x0330(0x0010) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_Transient)
	bool                                               bReplicatedHasBegunPlay;                                  // 0x0340(0x0001) (CPF_Net, CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0341(0x0003) MISSED OFFSET
	float                                              ReplicatedWorldTimeSeconds;                               // 0x0344(0x0004) (CPF_Net, CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              ServerWorldTimeSecondsDelta;                              // 0x0348(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              ServerWorldTimeSecondsUpdateFrequency;                    // 0x034C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x8];                                       // 0x0350(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.GameStateBase");
		return ptr;
	}


	void OnRep_SpectatorClass();
	void OnRep_ReplicatedWorldTimeSeconds();
	void OnRep_ReplicatedHasBegunPlay();
	void OnRep_GameModeClass();
	bool HasMatchStarted();
	bool HasBegunPlay();
	float GetServerWorldTimeSeconds();
	float GetPlayerStartTime(class AController* Controller);
	float GetPlayerRespawnDelay(class AController* Controller);
};


// Class Engine.GameState
// 0x0020 (0x0378 - 0x0358)
class AGameState : public AGameStateBase
{
public:
	struct FName                                       MatchState;                                               // 0x0358(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Net, CPF_ZeroConstructor, CPF_DisableEditOnTemplate, CPF_EditConst, CPF_IsPlainOldData)
	struct FName                                       PreviousMatchState;                                       // 0x0360(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_DisableEditOnTemplate, CPF_EditConst, CPF_IsPlainOldData)
	int                                                ElapsedTime;                                              // 0x0368(0x0004) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0xC];                                       // 0x036C(0x000C) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.GameState");
		return ptr;
	}


	void OnRep_MatchState();
	void OnRep_ElapsedTime();
};


// Class Engine.Brush
// 0x0038 (0x0350 - 0x0318)
class ABrush : public AActor
{
public:
	TEnumAsByte<EBrushType>                            BrushType;                                                // 0x0318(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0319(0x0003) MISSED OFFSET
	struct FColor                                      BrushColor;                                               // 0x031C(0x0004) (CPF_IsPlainOldData)
	int                                                PolyFlags;                                                // 0x0320(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bColored : 1;                                             // 0x0324(0x0001)
	unsigned char                                      bSolidWhenSelected : 1;                                   // 0x0324(0x0001)
	unsigned char                                      bPlaceableFromClassBrowser : 1;                           // 0x0324(0x0001)
	unsigned char                                      bNotForClientOrServer : 1;                                // 0x0324(0x0001)
	unsigned char                                      UnknownData01[0x3];                                       // 0x0325(0x0003) MISSED OFFSET
	class UModel*                                      Brush;                                                    // 0x0328(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	class UBrushComponent*                             BrushComponent;                                           // 0x0330(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)
	unsigned char                                      bInManipulation : 1;                                      // 0x0338(0x0001)
	unsigned char                                      UnknownData02[0x7];                                       // 0x0339(0x0007) MISSED OFFSET
	TArray<struct FGeomSelection>                      SavedSelections;                                          // 0x0340(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Brush");
		return ptr;
	}

};


// Class Engine.Volume
// 0x0000 (0x0350 - 0x0350)
class AVolume : public ABrush
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Volume");
		return ptr;
	}

};


// Class Engine.DefaultPawn
// 0x0028 (0x03A0 - 0x0378)
class ADefaultPawn : public APawn
{
public:
	float                                              BaseTurnRate;                                             // 0x0378(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)
	float                                              BaseLookUpRate;                                           // 0x037C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)
	class UPawnMovementComponent*                      MovementComponent;                                        // 0x0380(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)
	class USphereComponent*                            CollisionComponent;                                       // 0x0388(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)
	class UStaticMeshComponent*                        MeshComponent;                                            // 0x0390(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)
	unsigned char                                      bAddDefaultMovementBindings : 1;                          // 0x0398(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0399(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DefaultPawn");
		return ptr;
	}


	void TurnAtRate(float Rate);
	void MoveUp_World(float Val);
	void MoveRight(float Val);
	void MoveForward(float Val);
	void LookUpAtRate(float Rate);
};


// Class Engine.SpectatorPawn
// 0x0000 (0x03A0 - 0x03A0)
class ASpectatorPawn : public ADefaultPawn
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.SpectatorPawn");
		return ptr;
	}

};


// Class Engine.PhysicsVolume
// 0x0010 (0x0360 - 0x0350)
class APhysicsVolume : public AVolume
{
public:
	float                                              TerminalVelocity;                                         // 0x0350(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                Priority;                                                 // 0x0354(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              FluidFriction;                                            // 0x0358(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bWaterVolume : 1;                                         // 0x035C(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bPhysicsOnContact : 1;                                    // 0x035C(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData00[0x3];                                       // 0x035D(0x0003) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.PhysicsVolume");
		return ptr;
	}

};


// Class Engine.WorldSettings
// 0x01C0 (0x04D8 - 0x0318)
class AWorldSettings : public AInfo
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0318(0x0008) MISSED OFFSET
	unsigned char                                      bEnableWorldBoundsChecks : 1;                             // 0x0320(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bEnableNavigationSystem : 1;                              // 0x0320(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Config)
	unsigned char                                      bEnableAISystem : 1;                                      // 0x0320(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Config)
	unsigned char                                      bEnableWorldComposition : 1;                              // 0x0320(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUseClientSideLevelStreamingVolumes : 1;                  // 0x0320(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bEnableWorldOriginRebasing : 1;                           // 0x0320(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bWorldGravitySet : 1;                                     // 0x0320(0x0001) (CPF_Transient)
	unsigned char                                      bGlobalGravitySet : 1;                                    // 0x0320(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData01[0x3];                                       // 0x0321(0x0003) MISSED OFFSET
	float                                              KillZ;                                                    // 0x0324(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      KillZDamageType;                                          // 0x0328(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              WorldGravityZ;                                            // 0x0330(0x0004) (CPF_Net, CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              GlobalGravityZ;                                           // 0x0334(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      DefaultPhysicsVolumeClass;                                // 0x0338(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_NoClear, CPF_IsPlainOldData)
	class UClass*                                      PhysicsCollisionHandlerClass;                             // 0x0340(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      DefaultGameMode;                                          // 0x0348(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      GameNetworkManagerClass;                                  // 0x0350(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                PackedLightAndShadowMapTextureSize;                       // 0x0358(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bMinimizeBSPSections : 1;                                 // 0x035C(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData02[0x3];                                       // 0x035D(0x0003) MISSED OFFSET
	struct FVector                                     DefaultColorScale;                                        // 0x0360(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	float                                              DefaultMaxDistanceFieldOcclusionDistance;                 // 0x036C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              GlobalDistanceFieldViewDistance;                          // 0x0370(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              DynamicIndirectShadowsSelfShadowingIntensity;             // 0x0374(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      bPrecomputeVisibility : 1;                                // 0x0378(0x0001) (CPF_Edit)
	unsigned char                                      bPlaceCellsOnlyAlongCameraTracks : 1;                     // 0x0378(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData03[0x3];                                       // 0x0379(0x0003) MISSED OFFSET
	int                                                VisibilityCellSize;                                       // 0x037C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EVisibilityAggressiveness>             VisibilityAggressiveness;                                 // 0x0380(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData04[0x3];                                       // 0x0381(0x0003) MISSED OFFSET
	unsigned char                                      bForceNoPrecomputedLighting : 1;                          // 0x0384(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData05[0x3];                                       // 0x0385(0x0003) MISSED OFFSET
	struct FLightmassWorldInfoSettings                 LightmassSettings;                                        // 0x0388(0x0054) (CPF_Edit)
	unsigned char                                      UnknownData06[0x4];                                       // 0x03DC(0x0004) MISSED OFFSET
	struct FReverbSettings                             DefaultReverbSettings;                                    // 0x03E0(0x0020) (CPF_Edit, CPF_Config)
	struct FInteriorSettings                           DefaultAmbientZoneSettings;                               // 0x0400(0x0024) (CPF_Edit, CPF_Config)
	unsigned char                                      UnknownData07[0x4];                                       // 0x0424(0x0004) MISSED OFFSET
	class USoundMix*                                   DefaultBaseSoundMix;                                      // 0x0428(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              WorldToMeters;                                            // 0x0430(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MonoCullingDistance;                                      // 0x0434(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UBookMark*                                   BookMarks[0xA];                                           // 0x0438(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              TimeDilation;                                             // 0x0488(0x0004) (CPF_Net, CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              MatineeTimeDilation;                                      // 0x048C(0x0004) (CPF_Net, CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              DemoPlayTimeDilation;                                     // 0x0490(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              MinGlobalTimeDilation;                                    // 0x0494(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              MaxGlobalTimeDilation;                                    // 0x0498(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              MinUndilatedFrameTime;                                    // 0x049C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              MaxUndilatedFrameTime;                                    // 0x04A0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData08[0x4];                                       // 0x04A4(0x0004) MISSED OFFSET
	class APlayerState*                                Pauser;                                                   // 0x04A8(0x0008) (CPF_Net, CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      bHighPriorityLoading : 1;                                 // 0x04B0(0x0001) (CPF_Net)
	unsigned char                                      bHighPriorityLoadingLocal : 1;                            // 0x04B0(0x0001)
	unsigned char                                      UnknownData09[0x7];                                       // 0x04B1(0x0007) MISSED OFFSET
	TArray<struct FNetViewer>                          ReplicationViewers;                                       // 0x04B8(0x0010) (CPF_ZeroConstructor)
	TArray<class UAssetUserData*>                      AssetUserData;                                            // 0x04C8(0x0010) (CPF_ExportObject, CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.WorldSettings");
		return ptr;
	}


	void OnRep_WorldGravityZ();
};


// Class Engine.CameraActor
// 0x0558 (0x0870 - 0x0318)
class ACameraActor : public AActor
{
public:
	TEnumAsByte<EAutoReceiveInput>                     AutoActivateForPlayer;                                    // 0x0318(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0319(0x0007) MISSED OFFSET
	class UCameraComponent*                            CameraComponent;                                          // 0x0320(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)
	class USceneComponent*                             SceneComponent;                                           // 0x0328(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x8];                                       // 0x0330(0x0008) MISSED OFFSET
	unsigned char                                      bConstrainAspectRatio : 1;                                // 0x0338(0x0001) (CPF_Deprecated)
	unsigned char                                      UnknownData02[0x3];                                       // 0x0339(0x0003) MISSED OFFSET
	float                                              AspectRatio;                                              // 0x033C(0x0004) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	float                                              FOVAngle;                                                 // 0x0340(0x0004) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	float                                              PostProcessBlendWeight;                                   // 0x0344(0x0004) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0x8];                                       // 0x0348(0x0008) MISSED OFFSET
	struct FPostProcessSettings                        PostProcessSettings;                                      // 0x0350(0x0520) (CPF_Deprecated)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CameraActor");
		return ptr;
	}


	int GetAutoActivatePlayerIndex();
};


// Class Engine.StaticMeshComponent
// 0x0060 (0x06F0 - 0x0690)
class UStaticMeshComponent : public UMeshComponent
{
public:
	int                                                MinLOD;                                                   // 0x0690(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                SubDivisionStepSize;                                      // 0x0694(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UStaticMesh*                                 StaticMesh;                                               // 0x0698(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FColor                                      WireframeColorOverride;                                   // 0x06A0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	unsigned char                                      bOverrideWireframeColor : 1;                              // 0x06A4(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bOverrideMinLOD : 1;                                      // 0x06A4(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bOverrideNavigationExport : 1;                            // 0x06A4(0x0001) (CPF_Transient)
	unsigned char                                      bForceNavigationObstacle : 1;                             // 0x06A4(0x0001) (CPF_Transient)
	unsigned char                                      bDisallowMeshPaintPerInstance : 1;                        // 0x06A4(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bIgnoreInstanceForTextureStreaming : 1;                   // 0x06A4(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bOverrideLightMapRes : 1;                                 // 0x06A4(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bCastDistanceFieldIndirectShadow : 1;                     // 0x06A4(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bOverrideDistanceFieldSelfShadowBias : 1;                 // 0x06A5(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUseSubDivisions : 1;                                     // 0x06A5(0x0001)
	unsigned char                                      bUseDefaultCollision : 1;                                 // 0x06A5(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x2];                                       // 0x06A6(0x0002) MISSED OFFSET
	int                                                OverriddenLightMapRes;                                    // 0x06A8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              DistanceFieldIndirectShadowMinVisibility;                 // 0x06AC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              DistanceFieldSelfShadowBias;                              // 0x06B0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              StreamingDistanceMultiplier;                              // 0x06B4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<struct FStaticMeshComponentLODInfo>         LODData;                                                  // 0x06B8(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	TArray<struct FStreamingTextureBuildInfo>          StreamingTextureData;                                     // 0x06C8(0x0010) (CPF_ZeroConstructor)
	struct FLightmassPrimitiveSettings                 LightmassSettings;                                        // 0x06D8(0x0018) (CPF_Edit)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.StaticMeshComponent");
		return ptr;
	}


	bool SetStaticMesh(class UStaticMesh* NewMesh);
	void SetForcedLodModel(int NewForcedLodModel);
	void SetDistanceFieldSelfShadowBias(float NewValue);
	void OnRep_StaticMesh(class UStaticMesh* OldStaticMesh);
	void GetLocalBounds(struct FVector* Min, struct FVector* Max);
};


// Class Engine.DamageType
// 0x0018 (0x0040 - 0x0028)
class UDamageType : public UObject
{
public:
	unsigned char                                      bCausedByWorld : 1;                                       // 0x0028(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bScaleMomentumByMass : 1;                                 // 0x0028(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bRadialDamageVelChange : 1;                               // 0x0028(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0029(0x0003) MISSED OFFSET
	float                                              DamageImpulse;                                            // 0x002C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              DestructibleImpulse;                                      // 0x0030(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              DestructibleDamageSpreadScale;                            // 0x0034(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              DamageFalloff;                                            // 0x0038(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x003C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DamageType");
		return ptr;
	}

};


// Class Engine.InstancedStaticMeshComponent
// 0x00F0 (0x07E0 - 0x06F0)
class UInstancedStaticMeshComponent : public UStaticMeshComponent
{
public:
	TArray<struct FInstancedStaticMeshInstanceData>    PerInstanceSMData;                                        // 0x06F0(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	int                                                InstancingRandomSeed;                                     // 0x0700(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                InstanceStartCullDistance;                                // 0x0704(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                InstanceEndCullDistance;                                  // 0x0708(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x070C(0x0004) MISSED OFFSET
	TArray<int>                                        InstanceReorderTable;                                     // 0x0710(0x0010) (CPF_ZeroConstructor)
	TArray<int>                                        RemovedInstances;                                         // 0x0720(0x0010) (CPF_ZeroConstructor)
	bool                                               UseDynamicInstanceBuffer;                                 // 0x0730(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               KeepInstanceBufferCPUAccess;                              // 0x0731(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x86];                                      // 0x0732(0x0086) MISSED OFFSET
	class UPhysicsSerializer*                          PhysicsSerializer;                                        // 0x07B8(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	int                                                NumPendingLightmaps;                                      // 0x07C0(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_DuplicateTransient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x4];                                       // 0x07C4(0x0004) MISSED OFFSET
	TArray<struct FInstancedStaticMeshMappingInfo>     CachedMappings;                                           // 0x07C8(0x0010) (CPF_ZeroConstructor, CPF_Transient, CPF_DuplicateTransient)
	unsigned char                                      UnknownData03[0x8];                                       // 0x07D8(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InstancedStaticMeshComponent");
		return ptr;
	}


	bool UpdateInstanceTransform(int InstanceIndex, const struct FTransform& NewInstanceTransform, bool bWorldSpace, bool bMarkRenderStateDirty, bool bTeleport);
	void SetCullDistances(int StartCullDistance, int EndCullDistance);
	bool RemoveInstance(int InstanceIndex);
	bool GetInstanceTransform(int InstanceIndex, bool bWorldSpace, struct FTransform* OutInstanceTransform);
	TArray<int> GetInstancesOverlappingSphere(const struct FVector& Center, float Radius, bool bSphereInWorldSpace);
	TArray<int> GetInstancesOverlappingBox(const struct FBox& Box, bool bBoxInWorldSpace);
	int GetInstanceCount();
	void ClearInstances();
	int AddInstanceWorldSpace(const struct FTransform& WorldTransform);
	int AddInstance(const struct FTransform& InstanceTransform);
};


// Class Engine.HierarchicalInstancedStaticMeshComponent
// 0x00F0 (0x08D0 - 0x07E0)
class UHierarchicalInstancedStaticMeshComponent : public UInstancedStaticMeshComponent
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x07E0(0x0008) MISSED OFFSET
	TArray<int>                                        SortedInstances;                                          // 0x07E8(0x0010) (CPF_ZeroConstructor)
	int                                                NumBuiltInstances;                                        // 0x07F8(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x07FC(0x0004) MISSED OFFSET
	struct FBox                                        BuiltInstanceBounds;                                      // 0x0800(0x001C) (CPF_IsPlainOldData)
	struct FBox                                        UnbuiltInstanceBounds;                                    // 0x081C(0x001C) (CPF_IsPlainOldData)
	TArray<struct FBox>                                UnbuiltInstanceBoundsList;                                // 0x0838(0x0010) (CPF_ZeroConstructor)
	TArray<int>                                        UnbuiltInstanceIndexList;                                 // 0x0848(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      bEnableDensityScaling : 1;                                // 0x0858(0x0001)
	unsigned char                                      UnknownData02[0x27];                                      // 0x0859(0x0027) MISSED OFFSET
	int                                                OcclusionLayerNumNodes;                                   // 0x0880(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FBoxSphereBounds                            CacheMeshExtendedBounds;                                  // 0x0884(0x001C) (CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0x4];                                       // 0x08A0(0x0004) MISSED OFFSET
	bool                                               bDisableCollision;                                        // 0x08A4(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData04[0x2B];                                      // 0x08A5(0x002B) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.HierarchicalInstancedStaticMeshComponent");
		return ptr;
	}


	bool RemoveInstances(TArray<int> InstancesToRemove);
};


// Class Engine.HUD
// 0x00F0 (0x0408 - 0x0318)
class AHUD : public AActor
{
public:
	class APlayerController*                           PlayerOwner;                                              // 0x0318(0x0008) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bLostFocusPaused : 1;                                     // 0x0320(0x0001) (CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bShowHUD : 1;                                             // 0x0320(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bShowDebugInfo : 1;                                       // 0x0320(0x0001) (CPF_BlueprintVisible)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0321(0x0003) MISSED OFFSET
	int                                                CurrentTargetIndex;                                       // 0x0324(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      bShowHitBoxDebugInfo : 1;                                 // 0x0328(0x0001) (CPF_BlueprintVisible)
	unsigned char                                      bShowOverlays : 1;                                        // 0x0328(0x0001) (CPF_BlueprintVisible)
	unsigned char                                      bEnableDebugTextShadow : 1;                               // 0x0328(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData01[0x7];                                       // 0x0329(0x0007) MISSED OFFSET
	TArray<class AActor*>                              PostRenderedActors;                                       // 0x0330(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      UnknownData02[0x8];                                       // 0x0340(0x0008) MISSED OFFSET
	TArray<struct FName>                               DebugDisplay;                                             // 0x0348(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	TArray<struct FName>                               ToggledDebugCategories;                                   // 0x0358(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	class UCanvas*                                     Canvas;                                                   // 0x0368(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UCanvas*                                     DebugCanvas;                                              // 0x0370(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<struct FDebugTextInfo>                      DebugTextList;                                            // 0x0378(0x0010) (CPF_ZeroConstructor)
	class UClass*                                      ShowDebugTargetDesiredClass;                              // 0x0388(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class AActor*                                      ShowDebugTargetActor;                                     // 0x0390(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0x70];                                      // 0x0398(0x0070) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.HUD");
		return ptr;
	}


	void ShowHUD();
	void ShowDebugToggleSubCategory(const struct FName& Category);
	void ShowDebugForReticleTargetToggle(class UClass* DesiredClass);
	void ShowDebug(const struct FName& DebugType);
	void RemoveDebugText(class AActor* SrcActor, bool bLeaveDurationText);
	void RemoveAllDebugStrings();
	void ReceiveHitBoxRelease(const struct FName& BoxName);
	void ReceiveHitBoxEndCursorOver(const struct FName& BoxName);
	void ReceiveHitBoxClick(const struct FName& BoxName);
	void ReceiveHitBoxBeginCursorOver(const struct FName& BoxName);
	void ReceiveDrawHUD(int SizeX, int SizeY);
	struct FVector Project(const struct FVector& Location);
	void PreviousDebugTarget();
	void NextDebugTarget();
	void GetTextSize(const struct FString& Text, class UFont* Font, float Scale, float* OutWidth, float* OutHeight);
	class APlayerController* GetOwningPlayerController();
	class APawn* GetOwningPawn();
	void GetActorsInSelectionRectangle(class UClass* ClassFilter, const struct FVector2D& FirstPoint, const struct FVector2D& SecondPoint, bool bIncludeNonCollidingComponents, bool bActorMustBeFullyEnclosed, TArray<class AActor*>* OutActors);
	void DrawTextureSimple(class UTexture* Texture, float ScreenX, float ScreenY, float Scale, bool bScalePosition);
	void DrawTexture(class UTexture* Texture, float ScreenX, float ScreenY, float ScreenW, float ScreenH, float TextureU, float TextureV, float TextureUWidth, float TextureVHeight, const struct FLinearColor& TintColor, TEnumAsByte<EBlendMode> BlendMode, float Scale, bool bScalePosition, float Rotation, const struct FVector2D& RotPivot);
	void DrawText(const struct FString& Text, const struct FLinearColor& TextColor, float ScreenX, float ScreenY, class UFont* Font, float Scale, bool bScalePosition);
	void DrawRect(const struct FLinearColor& RectColor, float ScreenX, float ScreenY, float ScreenW, float ScreenH);
	void DrawMaterialTriangle(class UMaterialInterface* Material, const struct FVector2D& V0_Pos, const struct FVector2D& V1_Pos, const struct FVector2D& V2_Pos, const struct FVector2D& V0_UV, const struct FVector2D& V1_UV, const struct FVector2D& V2_UV, const struct FLinearColor& V0_Color, const struct FLinearColor& V1_Color, const struct FLinearColor& V2_Color);
	void DrawMaterialSimple(class UMaterialInterface* Material, float ScreenX, float ScreenY, float ScreenW, float ScreenH, float Scale, bool bScalePosition);
	void DrawMaterial(class UMaterialInterface* Material, float ScreenX, float ScreenY, float ScreenW, float ScreenH, float MaterialU, float MaterialV, float MaterialUWidth, float MaterialVHeight, float Scale, bool bScalePosition, float Rotation, const struct FVector2D& RotPivot);
	void DrawLine(float StartScreenX, float StartScreenY, float EndScreenX, float EndScreenY, const struct FLinearColor& LineColor, float LineThickness);
	void Deproject(float ScreenX, float ScreenY, struct FVector* WorldPosition, struct FVector* WorldDirection);
	void AddHitBox(const struct FVector2D& Position, const struct FVector2D& Size, const struct FName& InName, bool bConsumesInput, int Priority);
	void AddDebugText(const struct FString& DebugText, class AActor* SrcActor, float Duration, const struct FVector& Offset, const struct FVector& DesiredOffset, const struct FColor& TextColor, bool bSkipOverwriteCheck, bool bAbsoluteLocation, bool bKeepAttachedToActor, class UFont* InFont, float FontScale, bool bDrawShadow);
};


// Class Engine.ShapeComponent
// 0x0020 (0x0680 - 0x0660)
class UShapeComponent : public UPrimitiveComponent
{
public:
	struct FColor                                      ShapeColor;                                               // 0x0660(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x0664(0x0004) MISSED OFFSET
	class UBodySetup*                                  ShapeBodySetup;                                           // 0x0668(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_DuplicateTransient, CPF_IsPlainOldData)
	unsigned char                                      bDrawOnlyIfSelected : 1;                                  // 0x0670(0x0001)
	unsigned char                                      bShouldCollideWhenPlacing : 1;                            // 0x0670(0x0001)
	unsigned char                                      bDynamicObstacle : 1;                                     // 0x0670(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData01[0x7];                                       // 0x0671(0x0007) MISSED OFFSET
	class UClass*                                      AreaClass;                                                // 0x0678(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ShapeComponent");
		return ptr;
	}

};


// Class Engine.CapsuleComponent
// 0x0010 (0x0690 - 0x0680)
class UCapsuleComponent : public UShapeComponent
{
public:
	float                                              CapsuleHalfHeight;                                        // 0x0680(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              CapsuleRadius;                                            // 0x0684(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              CapsuleHeight;                                            // 0x0688(0x0004) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x068C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CapsuleComponent");
		return ptr;
	}


	void SetCapsuleSize(float InRadius, float InHalfHeight, bool bUpdateOverlaps);
	void SetCapsuleRadius(float Radius, bool bUpdateOverlaps);
	void SetCapsuleHalfHeight(float HalfHeight, bool bUpdateOverlaps);
	void GetUnscaledCapsuleSize_WithoutHemisphere(float* OutRadius, float* OutHalfHeightWithoutHemisphere);
	void GetUnscaledCapsuleSize(float* OutRadius, float* OutHalfHeight);
	float GetUnscaledCapsuleRadius();
	float GetUnscaledCapsuleHalfHeight_WithoutHemisphere();
	float GetUnscaledCapsuleHalfHeight();
	float GetShapeScale();
	void GetScaledCapsuleSize_WithoutHemisphere(float* OutRadius, float* OutHalfHeightWithoutHemisphere);
	void GetScaledCapsuleSize(float* OutRadius, float* OutHalfHeight);
	float GetScaledCapsuleRadius();
	float GetScaledCapsuleHalfHeight_WithoutHemisphere();
	float GetScaledCapsuleHalfHeight();
};


// Class Engine.PlayerController
// 0x02F0 (0x0670 - 0x0380)
class APlayerController : public AController
{
public:
	class UPlayer*                                     Player;                                                   // 0x0380(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class APawn*                                       AcknowledgedPawn;                                         // 0x0388(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UInterpTrackInstDirector*                    ControllingDirTrackInst;                                  // 0x0390(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class AHUD*                                        MyHUD;                                                    // 0x0398(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class APlayerCameraManager*                        PlayerCameraManager;                                      // 0x03A0(0x0008) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      PlayerCameraManagerClass;                                 // 0x03A8(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bAutoManageActiveCameraTarget;                            // 0x03B0(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x3];                                       // 0x03B1(0x0003) MISSED OFFSET
	struct FRotator                                    TargetViewRotation;                                       // 0x03B4(0x000C) (CPF_Net, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0xC];                                       // 0x03C0(0x000C) MISSED OFFSET
	float                                              SmoothTargetViewRotationSpeed;                            // 0x03CC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x8];                                       // 0x03D0(0x0008) MISSED OFFSET
	TArray<class AActor*>                              HiddenActors;                                             // 0x03D8(0x0010) (CPF_ZeroConstructor)
	TArray<TWeakObjectPtr<class UPrimitiveComponent>>  HiddenPrimitiveComponents;                                // 0x03E8(0x0010) (CPF_ExportObject, CPF_ZeroConstructor)
	unsigned char                                      UnknownData03[0x4];                                       // 0x03F8(0x0004) MISSED OFFSET
	float                                              LastSpectatorStateSynchTime;                              // 0x03FC(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FVector                                     LastSpectatorSyncLocation;                                // 0x0400(0x000C) (CPF_Transient, CPF_IsPlainOldData)
	struct FRotator                                    LastSpectatorSyncRotation;                                // 0x040C(0x000C) (CPF_Transient, CPF_IsPlainOldData)
	int                                                ClientCap;                                                // 0x0418(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData04[0x4];                                       // 0x041C(0x0004) MISSED OFFSET
	class UCheatManager*                               CheatManager;                                             // 0x0420(0x0008) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class UClass*                                      CheatClass;                                               // 0x0428(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	class UPlayerInput*                                PlayerInput;                                              // 0x0430(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	TArray<struct FActiveForceFeedbackEffect>          ActiveForceFeedbackEffects;                               // 0x0438(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	unsigned char                                      UnknownData05[0xA0];                                      // 0x0448(0x00A0) MISSED OFFSET
	unsigned char                                      UnknownData06 : 4;                                        // 0x04E8(0x0001)
	unsigned char                                      bPlayerIsWaiting : 1;                                     // 0x04E8(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_DisableEditOnTemplate, CPF_EditConst)
	unsigned char                                      UnknownData07[0x3];                                       // 0x04E9(0x0003) MISSED OFFSET
	unsigned char                                      NetPlayerIndex;                                           // 0x04EC(0x0001) (CPF_ZeroConstructor, CPF_DuplicateTransient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData08[0x3B];                                      // 0x04ED(0x003B) MISSED OFFSET
	class UNetConnection*                              PendingSwapConnection;                                    // 0x0528(0x0008) (CPF_ZeroConstructor, CPF_DuplicateTransient, CPF_IsPlainOldData)
	class UNetConnection*                              NetConnection;                                            // 0x0530(0x0008) (CPF_ZeroConstructor, CPF_DuplicateTransient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData09[0xC];                                       // 0x0538(0x000C) MISSED OFFSET
	float                                              InputYawScale;                                            // 0x0544(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              InputPitchScale;                                          // 0x0548(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              InputRollScale;                                           // 0x054C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      bShowMouseCursor : 1;                                     // 0x0550(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bEnableClickEvents : 1;                                   // 0x0550(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bEnableTouchEvents : 1;                                   // 0x0550(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bEnableMouseOverEvents : 1;                               // 0x0550(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bEnableTouchOverEvents : 1;                               // 0x0550(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bForceFeedbackEnabled : 1;                                // 0x0550(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData10[0x3];                                       // 0x0551(0x0003) MISSED OFFSET
	float                                              ForceFeedbackScale;                                       // 0x0554(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	TArray<struct FKey>                                ClickEventKeys;                                           // 0x0558(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor)
	TEnumAsByte<EMouseCursor>                          DefaultMouseCursor;                                       // 0x0568(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EMouseCursor>                          CurrentMouseCursor;                                       // 0x0569(0x0001) (CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ECollisionChannel>                     DefaultClickTraceChannel;                                 // 0x056A(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ECollisionChannel>                     CurrentClickTraceChannel;                                 // 0x056B(0x0001) (CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              HitResultTraceDistance;                                   // 0x056C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	uint16_t                                           SeamlessTravelCount;                                      // 0x0570(0x0002) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	uint16_t                                           LastCompletedSeamlessTravelCount;                         // 0x0572(0x0002) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData11[0x74];                                      // 0x0574(0x0074) MISSED OFFSET
	class UInputComponent*                             InactiveStateInputComponent;                              // 0x05E8(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	unsigned char                                      UnknownData12 : 2;                                        // 0x05F0(0x0001)
	unsigned char                                      bShouldPerformFullTickWhenPaused : 1;                     // 0x05F0(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData13[0x17];                                      // 0x05F1(0x0017) MISSED OFFSET
	class UTouchInterface*                             CurrentTouchInterface;                                    // 0x0608(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData14[0x40];                                      // 0x0610(0x0040) MISSED OFFSET
	class ASpectatorPawn*                              SpectatorPawn;                                            // 0x0650(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData15[0x4];                                       // 0x0658(0x0004) MISSED OFFSET
	bool                                               bIsLocalPlayerController;                                 // 0x065C(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData16[0x3];                                       // 0x065D(0x0003) MISSED OFFSET
	struct FVector                                     SpawnLocation;                                            // 0x0660(0x000C) (CPF_Net, CPF_IsPlainOldData)
	unsigned char                                      UnknownData17[0x4];                                       // 0x066C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.PlayerController");
		return ptr;
	}


	bool WasInputKeyJustReleased(const struct FKey& Key);
	bool WasInputKeyJustPressed(const struct FKey& Key);
	void ToggleSpeaking(bool bInSpeaking);
	void SwitchLevel(const struct FString& URL);
	void StopHapticEffect(EControllerHand Hand);
	void StartFire(unsigned char FireModeNum);
	void SetVirtualJoystickVisibility(bool bVisible);
	void SetViewTargetWithBlend(class AActor* NewViewTarget, float BlendTime, TEnumAsByte<EViewTargetBlendFunction> BlendFunc, float BlendExp, bool bLockOutgoing);
	void SetName(const struct FString& S);
	void SetMouseLocation(int X, int Y);
	void SetMouseCursorWidget(TEnumAsByte<EMouseCursor> Cursor, class UUserWidget* CursorWidget);
	void SetHapticsByValue(float Frequency, float Amplitude, EControllerHand Hand);
	void SetControllerLightColor(const struct FColor& Color);
	void SetCinematicMode(bool bInCinematicMode, bool bHidePlayer, bool bAffectsHUD, bool bAffectsMovement, bool bAffectsTurning);
	void SetAudioListenerOverride(class USceneComponent* AttachToComponent, const struct FVector& Location, const struct FRotator& Rotation);
	void ServerViewSelf(const struct FViewTargetTransitionParams& TransitionParams);
	void ServerViewPrevPlayer();
	void ServerViewNextPlayer();
	void ServerVerifyViewTarget();
	void ServerUpdateMultipleLevelsVisibility(TArray<struct FUpdateLevelVisibilityLevelInfo> LevelVisibilities);
	void ServerUpdateLevelVisibility(const struct FName& PackageName, bool bIsVisible);
	void ServerUpdateCamera(const struct FVector_NetQuantize& CamLoc, int CamPitchAndYaw);
	void ServerUnmutePlayer(const struct FUniqueNetIdRepl& PlayerId);
	void ServerToggleAILogging();
	void ServerShortTimeout();
	void ServerSetSpectatorWaiting(bool bWaiting);
	void ServerSetSpectatorLocation(const struct FVector& NewLoc, const struct FRotator& NewRot);
	void ServerRestartPlayer();
	void ServerPause();
	void ServerNotifyLoadedWorld(const struct FName& WorldPackageName);
	void ServerMutePlayer(const struct FUniqueNetIdRepl& PlayerId);
	void ServerCheckClientPossessionReliable();
	void ServerCheckClientPossession();
	void ServerChangeName(const struct FString& S);
	void ServerCamera(const struct FName& NewMode);
	void ServerAcknowledgePossession(class APawn* P);
	void SendToConsole(const struct FString& Command);
	void RestartLevel();
	bool ProjectWorldLocationToScreen(const struct FVector& WorldLocation, bool bPlayerViewportRelative, struct FVector2D* ScreenLocation);
	void PlayHapticEffect(class UHapticFeedbackEffect_Base* HapticEffect, EControllerHand Hand, float Scale, bool bLoop);
	void PlayDynamicForceFeedback(float Intensity, float Duration, bool bAffectsLeftLarge, bool bAffectsLeftSmall, bool bAffectsRightLarge, bool bAffectsRightSmall, TEnumAsByte<EDynamicForceFeedbackAction> action, const struct FLatentActionInfo& LatentInfo);
	void Pause();
	void OnServerStartedVisualLogger(bool bIsLogging);
	void LocalTravel(const struct FString& URL);
	bool IsInputKeyDown(const struct FKey& Key);
	void GetViewportSize(int* SizeX, int* SizeY);
	class ASpectatorPawn* GetSpectatorPawn();
	bool GetMousePosition(float* LocationX, float* LocationY);
	struct FVector GetInputVectorKeyState(const struct FKey& Key);
	void GetInputTouchState(TEnumAsByte<ETouchIndex> FingerIndex, float* LocationX, float* LocationY, bool* bIsCurrentlyPressed);
	void GetInputMouseDelta(float* DeltaX, float* DeltaY);
	void GetInputMotionState(struct FVector* Tilt, struct FVector* RotationRate, struct FVector* Gravity, struct FVector* Acceleration);
	float GetInputKeyTimeDown(const struct FKey& Key);
	void GetInputAnalogStickState(TEnumAsByte<EControllerAnalogStick> WhichStick, float* StickX, float* StickY);
	float GetInputAnalogKeyState(const struct FKey& Key);
	class AHUD* GetHUD();
	bool GetHitResultUnderFingerForObjects(TEnumAsByte<ETouchIndex> FingerIndex, TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, bool bTraceComplex, struct FHitResult* HitResult);
	bool GetHitResultUnderFingerByChannel(TEnumAsByte<ETouchIndex> FingerIndex, TEnumAsByte<ETraceTypeQuery> TraceChannel, bool bTraceComplex, struct FHitResult* HitResult);
	bool GetHitResultUnderFinger(TEnumAsByte<ETouchIndex> FingerIndex, TEnumAsByte<ECollisionChannel> TraceChannel, bool bTraceComplex, struct FHitResult* HitResult);
	bool GetHitResultUnderCursorForObjects(TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, bool bTraceComplex, struct FHitResult* HitResult);
	bool GetHitResultUnderCursorByChannel(TEnumAsByte<ETraceTypeQuery> TraceChannel, bool bTraceComplex, struct FHitResult* HitResult);
	bool GetHitResultUnderCursor(TEnumAsByte<ECollisionChannel> TraceChannel, bool bTraceComplex, struct FHitResult* HitResult);
	struct FVector GetFocalLocation();
	void FOV(float NewFOV);
	void EnableCheats();
	bool DeprojectScreenPositionToWorld(float ScreenX, float ScreenY, struct FVector* WorldLocation, struct FVector* WorldDirection);
	bool DeprojectMousePositionToWorld(struct FVector* WorldLocation, struct FVector* WorldDirection);
	void ConsoleKey(const struct FKey& Key);
	void ClientWasKicked(const struct FText& KickReason);
	void ClientVoiceHandshakeComplete();
	void ClientUpdateMultipleLevelsStreamingStatus(TArray<struct FUpdateLevelStreamingLevelStatus> LevelStatuses);
	void ClientUpdateLevelStreamingStatus(const struct FName& PackageName, bool bNewShouldBeLoaded, bool bNewShouldBeVisible, bool bNewShouldBlockOnLoad, int LODIndex);
	void ClientUnmutePlayer(const struct FUniqueNetIdRepl& PlayerId);
	void ClientTravelInternal(const struct FString& URL, TEnumAsByte<ETravelType> TravelType, bool bSeamless, const struct FGuid& MapPackageGuid);
	void ClientTravel(const struct FString& URL, TEnumAsByte<ETravelType> TravelType, bool bSeamless, const struct FGuid& MapPackageGuid);
	void ClientTeamMessage(class APlayerState* SenderPlayerState, const struct FString& S, const struct FName& Type, float MsgLifeTime);
	void ClientStopForceFeedback(class UForceFeedbackEffect* ForceFeedbackEffect, const struct FName& Tag);
	void ClientStopCameraShake(class UClass* Shake, bool bImmediately);
	void ClientStopCameraAnim(class UCameraAnim* AnimToStop);
	void ClientStartOnlineSession();
	void ClientSpawnCameraLensEffect(class UClass* LensEffectEmitterClass);
	void ClientSetViewTarget(class AActor* A, const struct FViewTargetTransitionParams& TransitionParams);
	void ClientSetSpectatorWaiting(bool bWaiting);
	void ClientSetHUD(class UClass* NewHUDClass);
	void ClientSetForceMipLevelsToBeResident(class UMaterialInterface* Material, float ForceDuration, int CinematicTextureGroups);
	void ClientSetCinematicMode(bool bInCinematicMode, bool bAffectsMovement, bool bAffectsTurning, bool bAffectsHUD);
	void ClientSetCameraMode(const struct FName& NewCamMode);
	void ClientSetCameraFade(bool bEnableFading, const struct FColor& FadeColor, const struct FVector2D& FadeAlpha, float FadeTime, bool bFadeAudio);
	void ClientSetBlockOnAsyncLoading();
	void ClientReturnToMainMenuWithTextReason(const struct FText& ReturnReason);
	void ClientReturnToMainMenu(const struct FString& ReturnReason);
	void ClientRetryClientRestart(class APawn* NewPawn);
	void ClientRestart(class APawn* NewPawn);
	void ClientReset();
	void ClientRepObjRef(class UObject* Object);
	void ClientReceiveLocalizedMessage(class UClass* Message, int Switch, class APlayerState* RelatedPlayerState_2, class APlayerState* RelatedPlayerState_3, class UObject* OptionalObject);
	void ClientPrestreamTextures(class AActor* ForcedActor, float ForceDuration, bool bEnableStreaming, int CinematicTextureGroups);
	void ClientPrepareMapChange(const struct FName& LevelName, bool bFirst, bool bLast);
	void ClientPlaySoundAtLocation(class USoundBase* Sound, const struct FVector& Location, float VolumeMultiplier, float PitchMultiplier);
	void ClientPlaySound(class USoundBase* Sound, float VolumeMultiplier, float PitchMultiplier);
	void ClientPlayForceFeedback(class UForceFeedbackEffect* ForceFeedbackEffect, bool bLooping, bool bIgnoreTimeDilation, const struct FName& Tag);
	void ClientPlayCameraShake(class UClass* Shake, float Scale, TEnumAsByte<ECameraAnimPlaySpace> PlaySpace, const struct FRotator& UserPlaySpaceRot);
	void ClientPlayCameraAnim(class UCameraAnim* AnimToPlay, float Scale, float Rate, float BlendInTime, float BlendOutTime, bool bLoop, bool bRandomStartTime, TEnumAsByte<ECameraAnimPlaySpace> Space, const struct FRotator& CustomPlaySpace);
	void ClientMutePlayer(const struct FUniqueNetIdRepl& PlayerId);
	void ClientMessage(const struct FString& S, const struct FName& Type, float MsgLifeTime);
	void ClientIgnoreMoveInput(bool bIgnore);
	void ClientIgnoreLookInput(bool bIgnore);
	void ClientGotoState(const struct FName& NewState);
	void ClientGameEnded(class AActor* EndGameFocus, bool bIsWinner);
	void ClientForceGarbageCollection();
	void ClientFlushLevelStreaming();
	void ClientEndOnlineSession();
	void ClientEnableNetworkVoice(bool bEnable);
	void ClientCommitMapChange();
	void ClientClearCameraLensEffects();
	void ClientCapBandwidth(int Cap);
	void ClientCancelPendingMapChange();
	void ClientAddTextureStreamingLoc(const struct FVector& InLoc, float Duration, bool bOverrideLocation);
	void ClearAudioListenerOverride();
	void Camera(const struct FName& NewMode);
	void AddYawInput(float Val);
	void AddRollInput(float Val);
	void AddPitchInput(float Val);
	void ActivateTouchInterface(class UTouchInterface* NewTouchInterface);
};


// Class Engine.ParticleModuleEventSendToGame
// 0x0000 (0x0028 - 0x0028)
class UParticleModuleEventSendToGame : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ParticleModuleEventSendToGame");
		return ptr;
	}

};


// Class Engine.PlayerCameraManager
// 0x17C8 (0x1AE0 - 0x0318)
class APlayerCameraManager : public AActor
{
public:
	class APlayerController*                           PCOwner;                                                  // 0x0318(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class USceneComponent*                             TransformComponent;                                       // 0x0320(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x8];                                       // 0x0328(0x0008) MISSED OFFSET
	float                                              DefaultFOV;                                               // 0x0330(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x0334(0x0004) MISSED OFFSET
	float                                              DefaultOrthoWidth;                                        // 0x0338(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x4];                                       // 0x033C(0x0004) MISSED OFFSET
	float                                              DefaultAspectRatio;                                       // 0x0340(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0x4C];                                      // 0x0344(0x004C) MISSED OFFSET
	struct FCameraCacheEntry                           CameraCache;                                              // 0x0390(0x0580) (CPF_Transient)
	struct FCameraCacheEntry                           LastFrameCameraCache;                                     // 0x0910(0x0580) (CPF_Transient)
	struct FTViewTarget                                ViewTarget;                                               // 0x0E90(0x0590) (CPF_Transient)
	struct FTViewTarget                                PendingViewTarget;                                        // 0x1420(0x0590) (CPF_Transient)
	unsigned char                                      UnknownData04[0x18];                                      // 0x19B0(0x0018) MISSED OFFSET
	TArray<class UCameraModifier*>                     ModifierList;                                             // 0x19C8(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	TArray<class UClass*>                              DefaultModifiers;                                         // 0x19D8(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_DisableEditOnInstance)
	float                                              FreeCamDistance;                                          // 0x19E8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FVector                                     FreeCamOffset;                                            // 0x19EC(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_IsPlainOldData)
	struct FVector                                     ViewTargetOffset;                                         // 0x19F8(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_IsPlainOldData)
	unsigned char                                      UnknownData05[0x14];                                      // 0x1A04(0x0014) MISSED OFFSET
	TArray<class AEmitterCameraLensEffectBase*>        CameraLensEffects;                                        // 0x1A18(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	class UCameraModifier_CameraShake*                 CachedCameraShakeMod;                                     // 0x1A28(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class UCameraAnimInst*                             AnimInstPool[0x8];                                        // 0x1A30(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	TArray<struct FPostProcessSettings>                PostProcessBlendCache;                                    // 0x1A70(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	unsigned char                                      UnknownData06[0x10];                                      // 0x1A80(0x0010) MISSED OFFSET
	TArray<class UCameraAnimInst*>                     ActiveAnims;                                              // 0x1A90(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	TArray<class UCameraAnimInst*>                     FreeAnims;                                                // 0x1AA0(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	class ACameraActor*                                AnimCameraActor;                                          // 0x1AB0(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      bIsOrthographic : 1;                                      // 0x1AB8(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bDefaultConstrainAspectRatio : 1;                         // 0x1AB8(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData07 : 5;                                        // 0x1AB8(0x0001)
	unsigned char                                      bUseClientSideCameraUpdates : 1;                          // 0x1AB8(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData08 : 2;                                        // 0x1AB9(0x0001)
	unsigned char                                      bGameCameraCutThisFrame : 1;                              // 0x1AB9(0x0001) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Transient)
	unsigned char                                      UnknownData09[0x2];                                       // 0x1ABA(0x0002) MISSED OFFSET
	float                                              ViewPitchMin;                                             // 0x1ABC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ViewPitchMax;                                             // 0x1AC0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ViewYawMin;                                               // 0x1AC4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ViewYawMax;                                               // 0x1AC8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ViewRollMin;                                              // 0x1ACC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ViewRollMax;                                              // 0x1AD0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData10[0xC];                                       // 0x1AD4(0x000C) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.PlayerCameraManager");
		return ptr;
	}


	void StopCameraShake(class UCameraShake* ShakeInstance, bool bImmediately);
	void StopCameraFade();
	void StopCameraAnimInst(class UCameraAnimInst* AnimInst, bool bImmediate);
	void StopAllInstancesOfCameraShake(class UClass* Shake, bool bImmediately);
	void StopAllInstancesOfCameraAnim(class UCameraAnim* Anim, bool bImmediate);
	void StopAllCameraShakes(bool bImmediately);
	void StopAllCameraAnims(bool bImmediate);
	void StartCameraFade(float FromAlpha, float ToAlpha, float Duration, const struct FLinearColor& Color, bool bShouldFadeAudio, bool bHoldWhenFinished);
	void SetManualCameraFade(float InFadeAmount, const struct FLinearColor& Color, bool bInFadeAudio);
	bool RemoveCameraModifier(class UCameraModifier* ModifierToRemove);
	void RemoveCameraLensEffect(class AEmitterCameraLensEffectBase* Emitter);
	class UCameraShake* PlayCameraShake(class UClass* ShakeClass, float Scale, TEnumAsByte<ECameraAnimPlaySpace> PlaySpace, const struct FRotator& UserPlaySpaceRot);
	class UCameraAnimInst* PlayCameraAnim(class UCameraAnim* Anim, float Rate, float Scale, float BlendInTime, float BlendOutTime, bool bLoop, bool bRandomStartTime, float Duration, TEnumAsByte<ECameraAnimPlaySpace> PlaySpace, const struct FRotator& UserPlaySpaceRot);
	void PhotographyCameraModify(const struct FVector& NewCameraLocation, const struct FVector& PreviousCameraLocation, const struct FVector& OriginalCameraLocation, struct FVector* ResultCameraLocation);
	void OnPhotographySessionStart();
	void OnPhotographySessionEnd();
	void OnPhotographyMultiPartCaptureStart();
	void OnPhotographyMultiPartCaptureEnd();
	class APlayerController* GetOwningPlayerController();
	float GetFOVAngle();
	struct FRotator GetCameraRotation();
	struct FVector GetCameraLocation();
	class UCameraModifier* FindCameraModifierByClass(class UClass* ModifierClass);
	void ClearCameraLensEffects();
	bool BlueprintUpdateCamera(class AActor* CameraTarget, struct FVector* NewCameraLocation, struct FRotator* NewCameraRotation, float* NewCameraFOV);
	class UCameraModifier* AddNewCameraModifier(class UClass* ModifierClass);
	class AEmitterCameraLensEffectBase* AddCameraLensEffect(class UClass* LensEffectEmitterClass);
};


// Class Engine.CameraComponent
// 0x05A0 (0x0830 - 0x0290)
class UCameraComponent : public USceneComponent
{
public:
	float                                              FieldOfView;                                              // 0x0290(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              OrthoWidth;                                               // 0x0294(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              OrthoNearClipPlane;                                       // 0x0298(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              OrthoFarClipPlane;                                        // 0x029C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              AspectRatio;                                              // 0x02A0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bConstrainAspectRatio : 1;                                // 0x02A4(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bUseFieldOfViewForLOD : 1;                                // 0x02A4(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bLockToHmd : 1;                                           // 0x02A4(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bUsePawnControlRotation : 1;                              // 0x02A4(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData00[0x3];                                       // 0x02A5(0x0003) MISSED OFFSET
	TEnumAsByte<ECameraProjectionMode>                 ProjectionMode;                                           // 0x02A8(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x3];                                       // 0x02A9(0x0003) MISSED OFFSET
	float                                              PostProcessBlendWeight;                                   // 0x02AC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FPostProcessSettings                        PostProcessSettings;                                      // 0x02B0(0x0520) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData02[0x58];                                      // 0x07D0(0x0058) MISSED OFFSET
	unsigned char                                      bUseControllerViewRotation : 1;                           // 0x0828(0x0001) (CPF_Deprecated)
	unsigned char                                      UnknownData03[0x7];                                       // 0x0829(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CameraComponent");
		return ptr;
	}


	void SetUseFieldOfViewForLOD(bool bInUseFieldOfViewForLOD);
	void SetProjectionMode(TEnumAsByte<ECameraProjectionMode> InProjectionMode);
	void SetPostProcessBlendWeight(float InPostProcessBlendWeight);
	void SetOrthoWidth(float InOrthoWidth);
	void SetOrthoNearClipPlane(float InOrthoNearClipPlane);
	void SetOrthoFarClipPlane(float InOrthoFarClipPlane);
	void SetFieldOfView(float InFieldOfView);
	void SetConstraintAspectRatio(bool bInConstrainAspectRatio);
	void SetAspectRatio(float InAspectRatio);
	void RemoveBlendable(const TScriptInterface<class UBlendableInterface>& InBlendableObject);
	void GetCameraView(float DeltaTime, struct FMinimalViewInfo* DesiredView);
	void AddOrUpdateBlendable(const TScriptInterface<class UBlendableInterface>& InBlendableObject, float InWeight);
};


// Class Engine.SpringArmComponent
// 0x0090 (0x0320 - 0x0290)
class USpringArmComponent : public USceneComponent
{
public:
	float                                              TargetArmLength;                                          // 0x0290(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FVector                                     SocketOffset;                                             // 0x0294(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_IsPlainOldData)
	struct FVector                                     TargetOffset;                                             // 0x02A0(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_IsPlainOldData)
	float                                              ProbeSize;                                                // 0x02AC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ECollisionChannel>                     ProbeChannel;                                             // 0x02B0(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x3];                                       // 0x02B1(0x0003) MISSED OFFSET
	unsigned char                                      bDoCollisionTest : 1;                                     // 0x02B4(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bUsePawnControlRotation : 1;                              // 0x02B4(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bInheritPitch : 1;                                        // 0x02B4(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bInheritYaw : 1;                                          // 0x02B4(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bInheritRoll : 1;                                         // 0x02B4(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bEnableCameraLag : 1;                                     // 0x02B4(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bEnableCameraRotationLag : 1;                             // 0x02B4(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bUseCameraLagSubstepping : 1;                             // 0x02B4(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bDrawDebugLagMarkers : 1;                                 // 0x02B5(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData01[0x2];                                       // 0x02B6(0x0002) MISSED OFFSET
	float                                              CameraLagSpeed;                                           // 0x02B8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              CameraRotationLagSpeed;                                   // 0x02BC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              CameraLagMaxTimeStep;                                     // 0x02C0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              CameraLagMaxDistance;                                     // 0x02C4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x58];                                      // 0x02C8(0x0058) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.SpringArmComponent");
		return ptr;
	}


	bool IsCollisionFixApplied();
	struct FVector GetUnfixedCameraPosition();
	struct FRotator GetTargetRotation();
};


// Class Engine.NavigationData
// 0x01A8 (0x04C0 - 0x0318)
class ANavigationData : public AActor
{
public:
	class UPrimitiveComponent*                         RenderingComp;                                            // 0x0318(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_Transient, CPF_InstancedReference, CPF_DuplicateTransient, CPF_IsPlainOldData)
	struct FNavDataConfig                              NavDataConfig;                                            // 0x0320(0x0058)
	unsigned char                                      bEnableDrawing : 1;                                       // 0x0378(0x0001) (CPF_Edit, CPF_Transient)
	unsigned char                                      bForceRebuildOnLoad : 1;                                  // 0x0378(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bCanBeMainNavData : 1;                                    // 0x0378(0x0001) (CPF_Edit, CPF_Config, CPF_EditConst)
	unsigned char                                      bCanSpawnOnRebuild : 1;                                   // 0x0378(0x0001) (CPF_Edit, CPF_Config, CPF_EditConst)
	unsigned char                                      bRebuildAtRuntime : 1;                                    // 0x0378(0x0001) (CPF_Config, CPF_Deprecated)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0379(0x0003) MISSED OFFSET
	ERuntimeGenerationType                             RuntimeGeneration;                                        // 0x037C(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x3];                                       // 0x037D(0x0003) MISSED OFFSET
	float                                              ObservedPathsTickInterval;                                // 0x0380(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	uint32_t                                           DataVersion;                                              // 0x0384(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0xD0];                                      // 0x0388(0x00D0) MISSED OFFSET
	TArray<struct FSupportedAreaData>                  SupportedAreas;                                           // 0x0458(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      UnknownData03[0x58];                                      // 0x0468(0x0058) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavigationData");
		return ptr;
	}

};


// Class Engine.RecastNavMesh
// 0x0110 (0x05D0 - 0x04C0)
class ARecastNavMesh : public ANavigationData
{
public:
	unsigned char                                      bDrawTriangleEdges : 1;                                   // 0x04C0(0x0001) (CPF_Edit)
	unsigned char                                      bDrawPolyEdges : 1;                                       // 0x04C0(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bDrawFilledPolys : 1;                                     // 0x04C0(0x0001) (CPF_Edit)
	unsigned char                                      bDrawNavMeshEdges : 1;                                    // 0x04C0(0x0001) (CPF_Edit)
	unsigned char                                      bDrawTileBounds : 1;                                      // 0x04C0(0x0001) (CPF_Edit)
	unsigned char                                      bDrawPathCollidingGeometry : 1;                           // 0x04C0(0x0001) (CPF_Edit)
	unsigned char                                      bDrawTileLabels : 1;                                      // 0x04C0(0x0001) (CPF_Edit)
	unsigned char                                      bDrawPolygonLabels : 1;                                   // 0x04C0(0x0001) (CPF_Edit)
	unsigned char                                      bDrawDefaultPolygonCost : 1;                              // 0x04C1(0x0001) (CPF_Edit)
	unsigned char                                      bDrawLabelsOnPathNodes : 1;                               // 0x04C1(0x0001) (CPF_Edit)
	unsigned char                                      bDrawNavLinks : 1;                                        // 0x04C1(0x0001) (CPF_Edit)
	unsigned char                                      bDrawFailedNavLinks : 1;                                  // 0x04C1(0x0001) (CPF_Edit)
	unsigned char                                      bDrawClusters : 1;                                        // 0x04C1(0x0001) (CPF_Edit)
	unsigned char                                      bDrawOctree : 1;                                          // 0x04C1(0x0001) (CPF_Edit)
	unsigned char                                      bDistinctlyDrawTilesBeingBuilt : 1;                       // 0x04C1(0x0001) (CPF_Config)
	unsigned char                                      bDrawNavMesh : 1;                                         // 0x04C1(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x2];                                       // 0x04C2(0x0002) MISSED OFFSET
	float                                              DrawOffset;                                               // 0x04C4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      bFixedTilePoolSize : 1;                                   // 0x04C8(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      UnknownData01[0x3];                                       // 0x04C9(0x0003) MISSED OFFSET
	int                                                TilePoolSize;                                             // 0x04CC(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              TileSizeUU;                                               // 0x04D0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              CellSize;                                                 // 0x04D4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              CellHeight;                                               // 0x04D8(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              AgentRadius;                                              // 0x04DC(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              AgentHeight;                                              // 0x04E0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              AgentMaxHeight;                                           // 0x04E4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              AgentMaxSlope;                                            // 0x04E8(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              AgentMaxStepHeight;                                       // 0x04EC(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              MinRegionArea;                                            // 0x04F0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              MergeRegionSize;                                          // 0x04F4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              MaxSimplificationError;                                   // 0x04F8(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                MaxSimultaneousTileGenerationJobsCount;                   // 0x04FC(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                TileNumberHardLimit;                                      // 0x0500(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                PolyRefTileBits;                                          // 0x0504(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)
	int                                                PolyRefNavPolyBits;                                       // 0x0508(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)
	int                                                PolyRefSaltBits;                                          // 0x050C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)
	float                                              DefaultDrawDistance;                                      // 0x0510(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              DefaultMaxSearchNodes;                                    // 0x0514(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              DefaultMaxHierarchicalSearchNodes;                        // 0x0518(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	TEnumAsByte<ERecastPartitioning>                   RegionPartitioning;                                       // 0x051C(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	TEnumAsByte<ERecastPartitioning>                   LayerPartitioning;                                        // 0x051D(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x2];                                       // 0x051E(0x0002) MISSED OFFSET
	int                                                RegionChunkSplits;                                        // 0x0520(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                LayerChunkSplits;                                         // 0x0524(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      bSortNavigationAreasByCost : 1;                           // 0x0528(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bPerformVoxelFiltering : 1;                               // 0x0528(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bMarkLowHeightAreas : 1;                                  // 0x0528(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bFilterLowSpanSequences : 1;                              // 0x0528(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bFilterLowSpanFromTileCache : 1;                          // 0x0528(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bDoFullyAsyncNavDataGathering : 1;                        // 0x0528(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bUseBetterOffsetsFromCorners : 1;                         // 0x0528(0x0001) (CPF_Config)
	unsigned char                                      bStoreEmptyTileLayers : 1;                                // 0x0528(0x0001) (CPF_Config)
	unsigned char                                      bUseVirtualFilters : 1;                                   // 0x0529(0x0001) (CPF_Config)
	unsigned char                                      bAllowNavLinkAsPathEnd : 1;                               // 0x0529(0x0001) (CPF_Config)
	unsigned char                                      bUseVoxelCache : 1;                                       // 0x0529(0x0001) (CPF_Config)
	unsigned char                                      UnknownData03[0x2];                                       // 0x052A(0x0002) MISSED OFFSET
	float                                              TileSetUpdateInterval;                                    // 0x052C(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              HeuristicScale;                                           // 0x0530(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              VerticalDeviationFromGroundCompensation;                  // 0x0534(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData04[0x98];                                      // 0x0538(0x0098) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.RecastNavMesh");
		return ptr;
	}

};


// Class Engine.NavigationObjectBase
// 0x0028 (0x0340 - 0x0318)
class ANavigationObjectBase : public AActor
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0318(0x0008) MISSED OFFSET
	class UCapsuleComponent*                           CapsuleComponent;                                         // 0x0320(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	class UBillboardComponent*                         GoodSprite;                                               // 0x0328(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	class UBillboardComponent*                         BadSprite;                                                // 0x0330(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	unsigned char                                      bIsPIEPlayerStart : 1;                                    // 0x0338(0x0001)
	unsigned char                                      UnknownData01[0x7];                                       // 0x0339(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavigationObjectBase");
		return ptr;
	}

};


// Class Engine.PlayerStart
// 0x0008 (0x0348 - 0x0340)
class APlayerStart : public ANavigationObjectBase
{
public:
	struct FName                                       PlayerStartTag;                                           // 0x0340(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.PlayerStart");
		return ptr;
	}

};


// Class Engine.ProjectileMovementComponent
// 0x0068 (0x01A0 - 0x0138)
class UProjectileMovementComponent : public UMovementComponent
{
public:
	float                                              InitialSpeed;                                             // 0x0138(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxSpeed;                                                 // 0x013C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bRotationFollowsVelocity : 1;                             // 0x0140(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bShouldBounce : 1;                                        // 0x0140(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bInitialVelocityInLocalSpace : 1;                         // 0x0140(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bForceSubStepping : 1;                                    // 0x0140(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bIsHomingProjectile : 1;                                  // 0x0140(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bBounceAngleAffectsFriction : 1;                          // 0x0140(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bIsSliding : 1;                                           // 0x0140(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_DisableEditOnTemplate, CPF_EditConst)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0141(0x0003) MISSED OFFSET
	float                                              PreviousHitTime;                                          // 0x0144(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_DisableEditOnTemplate, CPF_EditConst, CPF_IsPlainOldData)
	struct FVector                                     PreviousHitNormal;                                        // 0x0148(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_DisableEditOnTemplate, CPF_EditConst, CPF_IsPlainOldData)
	float                                              ProjectileGravityScale;                                   // 0x0154(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              Buoyancy;                                                 // 0x0158(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              Bounciness;                                               // 0x015C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              Friction;                                                 // 0x0160(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              BounceVelocityStopSimulatingThreshold;                    // 0x0164(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FScriptMulticastDelegate                    OnProjectileBounce;                                       // 0x0168(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnProjectileStop;                                         // 0x0178(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	float                                              HomingAccelerationMagnitude;                              // 0x0188(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TWeakObjectPtr<class USceneComponent>              HomingTargetComponent;                                    // 0x018C(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_ZeroConstructor, CPF_DisableEditOnTemplate, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)
	float                                              MaxSimulationTimeStep;                                    // 0x0194(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                MaxSimulationIterations;                                  // 0x0198(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x019C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ProjectileMovementComponent");
		return ptr;
	}


	void StopSimulating(const struct FHitResult& HitResult);
	void SetVelocityInLocalSpace(const struct FVector& NewVelocity);
	void OnProjectileStopDelegate__DelegateSignature(const struct FHitResult& ImpactResult);
	void OnProjectileBounceDelegate__DelegateSignature(const struct FHitResult& ImpactResult, const struct FVector& ImpactVelocity);
	struct FVector LimitVelocity(const struct FVector& NewVelocity);
};


// Class Engine.AudioComponent
// 0x05E0 (0x0870 - 0x0290)
class UAudioComponent : public USceneComponent
{
public:
	class USoundBase*                                  Sound;                                                    // 0x0290(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<struct FAudioComponentParam>                InstanceParameters;                                       // 0x0298(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor)
	class USoundClass*                                 SoundClassOverride;                                       // 0x02A8(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bAutoDestroy : 1;                                         // 0x02B0(0x0001)
	unsigned char                                      bStopWhenOwnerDestroyed : 1;                              // 0x02B0(0x0001)
	unsigned char                                      bShouldRemainActiveIfDropped : 1;                         // 0x02B0(0x0001)
	unsigned char                                      bAllowSpatialization : 1;                                 // 0x02B0(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bOverrideAttenuation : 1;                                 // 0x02B0(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData00[0x3];                                       // 0x02B1(0x0003) MISSED OFFSET
	unsigned char                                      bOverrideSubtitlePriority : 1;                            // 0x02B4(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData01[0x3];                                       // 0x02B5(0x0003) MISSED OFFSET
	unsigned char                                      bIsUISound : 1;                                           // 0x02B8(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bEnableLowPassFilter : 1;                                 // 0x02B8(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bOverridePriority : 1;                                    // 0x02B8(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bSuppressSubtitles : 1;                                   // 0x02B8(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData02[0x7];                                       // 0x02B9(0x0007) MISSED OFFSET
	struct FName                                       AudioComponentUserID;                                     // 0x02C0(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              PitchModulationMin;                                       // 0x02C8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              PitchModulationMax;                                       // 0x02CC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              VolumeModulationMin;                                      // 0x02D0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              VolumeModulationMax;                                      // 0x02D4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              VolumeMultiplier;                                         // 0x02D8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                EnvelopeFollowerAttackTime;                               // 0x02DC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                EnvelopeFollowerReleaseTime;                              // 0x02E0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              Priority;                                                 // 0x02E4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              SubtitlePriority;                                         // 0x02E8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              VolumeWeightedPriorityScale;                              // 0x02EC(0x0004) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	float                                              PitchMultiplier;                                          // 0x02F0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              HighFrequencyGainMultiplier;                              // 0x02F4(0x0004) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	float                                              LowPassFilterFrequency;                                   // 0x02F8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0x4];                                       // 0x02FC(0x0004) MISSED OFFSET
	class USoundAttenuation*                           AttenuationSettings;                                      // 0x0300(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoundAttenuationSettings                   AttenuationOverrides;                                     // 0x0308(0x02F0) (CPF_Edit, CPF_BlueprintVisible)
	class USoundConcurrency*                           ConcurrencySettings;                                      // 0x05F8(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData04[0x8];                                       // 0x0600(0x0008) MISSED OFFSET
	struct FScriptMulticastDelegate                    OnAudioFinished;                                          // 0x0608(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	unsigned char                                      UnknownData05[0x78];                                      // 0x0618(0x0078) MISSED OFFSET
	struct FScriptMulticastDelegate                    OnAudioPlaybackPercent;                                   // 0x0690(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	unsigned char                                      UnknownData06[0x70];                                      // 0x06A0(0x0070) MISSED OFFSET
	struct FScriptMulticastDelegate                    OnAudioSingleEnvelopeValue;                               // 0x0710(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	unsigned char                                      UnknownData07[0x70];                                      // 0x0720(0x0070) MISSED OFFSET
	struct FScriptMulticastDelegate                    OnAudioMultiEnvelopeValue;                                // 0x0790(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	unsigned char                                      UnknownData08[0x70];                                      // 0x07A0(0x0070) MISSED OFFSET
	struct FScriptDelegate                             OnQueueSubtitles;                                         // 0x0810(0x0014) (CPF_ZeroConstructor, CPF_InstancedReference)
	unsigned char                                      bAutoManageAttachment : 1;                                // 0x0820(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData09[0x3];                                       // 0x0821(0x0003) MISSED OFFSET
	TWeakObjectPtr<class USceneComponent>              AutoAttachParent;                                         // 0x0824(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_ZeroConstructor, CPF_DisableEditOnTemplate, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)
	unsigned char                                      UnknownData10[0x4];                                       // 0x082C(0x0004) MISSED OFFSET
	struct FName                                       AutoAttachSocketName;                                     // 0x0830(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	EAttachmentRule                                    AutoAttachLocationRule;                                   // 0x0838(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	EAttachmentRule                                    AutoAttachRotationRule;                                   // 0x0839(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	EAttachmentRule                                    AutoAttachScaleRule;                                      // 0x083A(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData11[0x35];                                      // 0x083B(0x0035) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AudioComponent");
		return ptr;
	}


	void Stop();
	void SetWaveParameter(const struct FName& InName, class USoundWave* InWave);
	void SetVolumeMultiplier(float NewVolumeMultiplier);
	void SetUISound(bool bInUISound);
	void SetSubmixSend(class USoundSubmix* Submix, float SendLevel);
	void SetSound(class USoundBase* NewSound);
	void SetPitchMultiplier(float NewPitchMultiplier);
	void SetPaused(bool bPause);
	void SetLowPassFilterFrequency(float InLowPassFilterFrequency);
	void SetLowPassFilterEnabled(bool InLowPassFilterEnabled);
	void SetIntParameter(const struct FName& InName, int inInt);
	void SetFloatParameter(const struct FName& InName, float InFloat);
	void SetBoolParameter(const struct FName& InName, bool InBool);
	void Play(float StartTime);
	bool IsPlaying();
	void FadeOut(float FadeOutDuration, float FadeVolumeLevel);
	void FadeIn(float FadeInDuration, float FadeVolumeLevel, float StartTime);
	bool BP_GetAttenuationSettingsToApply(struct FSoundAttenuationSettings* OutAttenuationSettings);
	void AdjustVolume(float AdjustVolumeDuration, float AdjustVolumeLevel);
	void AdjustAttenuation(const struct FSoundAttenuationSettings& InAttenuationSettings);
};


// Class Engine.SceneCapture
// 0x0008 (0x0320 - 0x0318)
class ASceneCapture : public AActor
{
public:
	class UStaticMeshComponent*                        MeshComp;                                                 // 0x0318(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.SceneCapture");
		return ptr;
	}

};


// Class Engine.SceneCapture2D
// 0x0010 (0x0330 - 0x0320)
class ASceneCapture2D : public ASceneCapture
{
public:
	class USceneCaptureComponent2D*                    CaptureComponent2D;                                       // 0x0320(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)
	class UDrawFrustumComponent*                       DrawFrustum;                                              // 0x0328(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.SceneCapture2D");
		return ptr;
	}


	void OnInterpToggle(bool bEnable);
};


// Class Engine.StaticMeshActor
// 0x0010 (0x0328 - 0x0318)
class AStaticMeshActor : public AActor
{
public:
	class UStaticMeshComponent*                        StaticMeshComponent;                                      // 0x0318(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)
	bool                                               bStaticMeshReplicateMovement;                             // 0x0320(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	ENavDataGatheringMode                              NavigationGeometryGatheringMode;                          // 0x0321(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x6];                                       // 0x0322(0x0006) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.StaticMeshActor");
		return ptr;
	}

};


// Class Engine.MaterialInterface
// 0x0048 (0x0070 - 0x0028)
class UMaterialInterface : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET
	class USubsurfaceProfile*                          SubsurfaceProfile;                                        // 0x0030(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x8];                                       // 0x0038(0x0008) MISSED OFFSET
	struct FLightmassMaterialInterfaceSettings         LightmassSettings;                                        // 0x0040(0x0014) (CPF_Edit)
	unsigned char                                      UnknownData02[0x4];                                       // 0x0054(0x0004) MISSED OFFSET
	TArray<struct FMaterialTextureInfo>                TextureStreamingData;                                     // 0x0058(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      UnknownData03[0x8];                                       // 0x0068(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialInterface");
		return ptr;
	}


	void SetForceMipLevelsToBeResident(bool OverrideForceMiplevelsToBeResident, bool bForceMiplevelsToBeResidentValue, float ForceDuration, int CinematicTextureGroups);
	class UPhysicalMaterial* GetPhysicalMaterial();
	class UMaterial* GetBaseMaterial();
};


// Class Engine.MaterialInstance
// 0x0160 (0x01D0 - 0x0070)
class UMaterialInstance : public UMaterialInterface
{
public:
	class UPhysicalMaterial*                           PhysMaterial;                                             // 0x0070(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UMaterialInterface*                          Parent;                                                   // 0x0078(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bHasStaticPermutationResource : 1;                        // 0x0080(0x0001)
	unsigned char                                      bOverrideSubsurfaceProfile : 1;                           // 0x0080(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0081(0x0007) MISSED OFFSET
	TArray<struct FScalarParameterValue>               ScalarParameterValues;                                    // 0x0088(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor)
	TArray<struct FVectorParameterValue>               VectorParameterValues;                                    // 0x0098(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor)
	TArray<struct FTextureParameterValue>              TextureParameterValues;                                   // 0x00A8(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor)
	TArray<struct FFontParameterValue>                 FontParameterValues;                                      // 0x00B8(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor)
	bool                                               bOverrideBaseProperties;                                  // 0x00C8(0x0001) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x3];                                       // 0x00C9(0x0003) MISSED OFFSET
	struct FMaterialInstanceBasePropertyOverrides      BasePropertyOverrides;                                    // 0x00CC(0x0014) (CPF_Edit)
	unsigned char                                      UnknownData02[0x28];                                      // 0x00E0(0x0028) MISSED OFFSET
	TArray<class UTexture*>                            PermutationTextureReferences;                             // 0x0108(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	struct FStaticParameterSet                         StaticParameters;                                         // 0x0118(0x0040)
	unsigned char                                      UnknownData03[0x78];                                      // 0x0158(0x0078) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialInstance");
		return ptr;
	}

};


// Class Engine.MaterialInstanceConstant
// 0x0000 (0x01D0 - 0x01D0)
class UMaterialInstanceConstant : public UMaterialInstance
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialInstanceConstant");
		return ptr;
	}


	struct FLinearColor K2_GetVectorParameterValue(const struct FName& ParameterName);
	class UTexture* K2_GetTextureParameterValue(const struct FName& ParameterName);
	float K2_GetScalarParameterValue(const struct FName& ParameterName);
};


// Class Engine.MaterialExpression
// 0x0038 (0x0060 - 0x0028)
class UMaterialExpression : public UObject
{
public:
	class UMaterial*                                   Material;                                                 // 0x0028(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UMaterialFunction*                           Function;                                                 // 0x0030(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FString                                     desc;                                                     // 0x0038(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	unsigned char                                      bRealtimePreview : 1;                                     // 0x0048(0x0001)
	unsigned char                                      bNeedToUpdatePreview : 1;                                 // 0x0048(0x0001) (CPF_Transient)
	unsigned char                                      bIsParameterExpression : 1;                               // 0x0048(0x0001)
	unsigned char                                      bCommentBubbleVisible : 1;                                // 0x0048(0x0001)
	unsigned char                                      bShowOutputNameOnPin : 1;                                 // 0x0048(0x0001)
	unsigned char                                      bShowMaskColorsOnPin : 1;                                 // 0x0048(0x0001)
	unsigned char                                      bHidePreviewWindow : 1;                                   // 0x0048(0x0001)
	unsigned char                                      bCollapsed : 1;                                           // 0x0048(0x0001)
	unsigned char                                      bShaderInputData : 1;                                     // 0x0049(0x0001)
	unsigned char                                      bShowInputs : 1;                                          // 0x0049(0x0001)
	unsigned char                                      bShowOutputs : 1;                                         // 0x0049(0x0001)
	unsigned char                                      UnknownData00[0x6];                                       // 0x004A(0x0006) MISSED OFFSET
	TArray<struct FExpressionOutput>                   Outputs;                                                  // 0x0050(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpression");
		return ptr;
	}

};


// Class Engine.MaterialExpressionCustomOutput
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionCustomOutput : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionCustomOutput");
		return ptr;
	}

};


// Class Engine.BlueprintAsyncActionBase
// 0x0000 (0x0028 - 0x0028)
class UBlueprintAsyncActionBase : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BlueprintAsyncActionBase");
		return ptr;
	}


	void Activate();
};


// Class Engine.BlueprintGeneratedClass
// 0x00E0 (0x02D8 - 0x01F8)
class UBlueprintGeneratedClass : public UClass
{
public:
	int                                                NumReplicatedProperties;                                  // 0x01F8(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bHasNativizedParent : 1;                                  // 0x01FC(0x0001)
	unsigned char                                      UnknownData00[0x3];                                       // 0x01FD(0x0003) MISSED OFFSET
	TArray<class UDynamicBlueprintBinding*>            DynamicBindingObjects;                                    // 0x0200(0x0010) (CPF_ZeroConstructor)
	TArray<class UActorComponent*>                     ComponentTemplates;                                       // 0x0210(0x0010) (CPF_ExportObject, CPF_ZeroConstructor)
	TArray<class UTimelineTemplate*>                   Timelines;                                                // 0x0220(0x0010) (CPF_ZeroConstructor)
	class USimpleConstructionScript*                   SimpleConstructionScript;                                 // 0x0230(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UInheritableComponentHandler*                InheritableComponentHandler;                              // 0x0238(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UStructProperty*                             UberGraphFramePointerProperty;                            // 0x0240(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UFunction*                                   UberGraphFunction;                                        // 0x0248(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TMap<struct FName, struct FBlueprintCookedComponentInstancingData> CookedComponentInstancingData;                            // 0x0250(0x0050) (CPF_ZeroConstructor)
	unsigned char                                      UnknownData01[0x38];                                      // 0x02A0(0x0038) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BlueprintGeneratedClass");
		return ptr;
	}

};


// Class Engine.UserDefinedStruct
// 0x0048 (0x00E0 - 0x0098)
class UUserDefinedStruct : public UScriptStruct
{
public:
	TEnumAsByte<EUserDefinedStructureStatus>           Status;                                                   // 0x0098(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0099(0x0003) MISSED OFFSET
	struct FGuid                                       Guid;                                                     // 0x009C(0x0010) (CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x34];                                      // 0x00AC(0x0034) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.UserDefinedStruct");
		return ptr;
	}

};


// Class Engine.AISystemBase
// 0x0028 (0x0050 - 0x0028)
class UAISystemBase : public UObject
{
public:
	struct FSoftClassPath                              AISystemClassName;                                        // 0x0028(0x0018) (CPF_Config, CPF_GlobalConfig, CPF_NoClear)
	struct FName                                       AISystemModuleName;                                       // 0x0040(0x0008) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_NoClear, CPF_IsPlainOldData)
	bool                                               bInstantiateAISystemOnClient;                             // 0x0048(0x0001) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_NoClear, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0049(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AISystemBase");
		return ptr;
	}

};


// Class Engine.CrowdManagerBase
// 0x0000 (0x0028 - 0x0028)
class UCrowdManagerBase : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CrowdManagerBase");
		return ptr;
	}

};


// Class Engine.NavigationQueryFilter
// 0x0020 (0x0048 - 0x0028)
class UNavigationQueryFilter : public UObject
{
public:
	TArray<struct FNavigationFilterArea>               Areas;                                                    // 0x0028(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	struct FNavigationFilterFlags                      IncludeFlags;                                             // 0x0038(0x0004) (CPF_Edit, CPF_IsPlainOldData)
	struct FNavigationFilterFlags                      ExcludeFlags;                                             // 0x003C(0x0004) (CPF_Edit, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x8];                                       // 0x0040(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavigationQueryFilter");
		return ptr;
	}

};


// Class Engine.Model
// 0x02B8 (0x02E0 - 0x0028)
class UModel : public UObject
{
public:
	unsigned char                                      UnknownData00[0x2B8];                                     // 0x0028(0x02B8) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Model");
		return ptr;
	}

};


// Class Engine.AbstractNavData
// 0x0000 (0x04C0 - 0x04C0)
class AAbstractNavData : public ANavigationData
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AbstractNavData");
		return ptr;
	}

};


// Class Engine.Channel
// 0x0040 (0x0068 - 0x0028)
class UChannel : public UObject
{
public:
	class UNetConnection*                              Connection;                                               // 0x0028(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x38];                                      // 0x0030(0x0038) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Channel");
		return ptr;
	}

};


// Class Engine.ActorChannel
// 0x01C8 (0x0230 - 0x0068)
class UActorChannel : public UChannel
{
public:
	class AActor*                                      Actor;                                                    // 0x0068(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0xE0];                                      // 0x0070(0x00E0) MISSED OFFSET
	TArray<class UObject*>                             CreateSubObjects;                                         // 0x0150(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      UnknownData01[0xD0];                                      // 0x0160(0x00D0) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ActorChannel");
		return ptr;
	}

};


// Class Engine.AnimationAsset
// 0x0050 (0x0078 - 0x0028)
class UAnimationAsset : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET
	class USkeleton*                                   Skeleton;                                                 // 0x0030(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x20];                                      // 0x0038(0x0020) MISSED OFFSET
	TArray<class UAnimMetaData*>                       MetaData;                                                 // 0x0058(0x0010) (CPF_Edit, CPF_ExportObject, CPF_ZeroConstructor)
	TArray<class UAssetUserData*>                      AssetUserData;                                            // 0x0068(0x0010) (CPF_Edit, CPF_ExportObject, CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimationAsset");
		return ptr;
	}

};


// Class Engine.BlendSpaceBase
// 0x00C8 (0x0140 - 0x0078)
class UBlendSpaceBase : public UAnimationAsset
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0078(0x0008) MISSED OFFSET
	bool                                               bRotationBlendInMeshSpace;                                // 0x0080(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x3];                                       // 0x0081(0x0003) MISSED OFFSET
	float                                              AnimLength;                                               // 0x0084(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	struct FInterpolationParameter                     InterpolationParam[0x3];                                  // 0x0088(0x0008) (CPF_Edit)
	float                                              TargetWeightInterpolationSpeedPerSec;                     // 0x00A0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ENotifyTriggerMode>                    NotifyTriggerMode;                                        // 0x00A4(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x3];                                       // 0x00A5(0x0003) MISSED OFFSET
	TArray<struct FPerBoneInterpolation>               PerBoneBlend;                                             // 0x00A8(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	int                                                SampleIndexWithMarkers;                                   // 0x00B8(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0x4];                                       // 0x00BC(0x0004) MISSED OFFSET
	TArray<struct FBlendSample>                        SampleData;                                               // 0x00C0(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	TArray<struct FEditorElement>                      GridSamples;                                              // 0x00D0(0x0010) (CPF_ZeroConstructor)
	struct FBlendParameter                             BlendParameters[0x3];                                     // 0x00E0(0x0020) (CPF_Edit)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BlendSpaceBase");
		return ptr;
	}

};


// Class Engine.BlendSpace
// 0x0008 (0x0148 - 0x0140)
class UBlendSpace : public UBlendSpaceBase
{
public:
	TEnumAsByte<EBlendSpaceAxis>                       AxisToScaleAnimation;                                     // 0x0140(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0141(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BlendSpace");
		return ptr;
	}

};


// Class Engine.AimOffsetBlendSpace
// 0x0000 (0x0148 - 0x0148)
class UAimOffsetBlendSpace : public UBlendSpace
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AimOffsetBlendSpace");
		return ptr;
	}

};


// Class Engine.BlendSpace1D
// 0x0008 (0x0148 - 0x0140)
class UBlendSpace1D : public UBlendSpaceBase
{
public:
	bool                                               bScaleAnimation;                                          // 0x0140(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0141(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BlendSpace1D");
		return ptr;
	}

};


// Class Engine.AimOffsetBlendSpace1D
// 0x0000 (0x0148 - 0x0148)
class UAimOffsetBlendSpace1D : public UBlendSpace1D
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AimOffsetBlendSpace1D");
		return ptr;
	}

};


// Class Engine.AmbientSound
// 0x0008 (0x0320 - 0x0318)
class AAmbientSound : public AActor
{
public:
	class UAudioComponent*                             AudioComponent;                                           // 0x0318(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AmbientSound");
		return ptr;
	}


	void Stop();
	void Play(float StartTime);
	void FadeOut(float FadeOutDuration, float FadeVolumeLevel);
	void FadeIn(float FadeInDuration, float FadeVolumeLevel);
	void AdjustVolume(float AdjustVolumeDuration, float AdjustVolumeLevel);
};


// Class Engine.DeveloperSettings
// 0x0010 (0x0038 - 0x0028)
class UDeveloperSettings : public UObject
{
public:
	unsigned char                                      UnknownData00[0x10];                                      // 0x0028(0x0010) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DeveloperSettings");
		return ptr;
	}

};


// Class Engine.AnimationSettings
// 0x0038 (0x0070 - 0x0038)
class UAnimationSettings : public UDeveloperSettings
{
public:
	int                                                CompressCommandletVersion;                                // 0x0038(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_EditConst, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x003C(0x0004) MISSED OFFSET
	TArray<struct FString>                             KeyEndEffectorsMatchNameArray;                            // 0x0040(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	class UClass*                                      DefaultCompressionAlgorithm;                              // 0x0050(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_NoClear, CPF_IsPlainOldData)
	TEnumAsByte<EAnimationCompressionFormat>           RotationCompressionFormat;                                // 0x0058(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	TEnumAsByte<EAnimationCompressionFormat>           TranslationCompressionFormat;                             // 0x0059(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x2];                                       // 0x005A(0x0002) MISSED OFFSET
	float                                              MaxCurveError;                                            // 0x005C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              AlternativeCompressionThreshold;                          // 0x0060(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               ForceRecompression;                                       // 0x0064(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bOnlyCheckForMissingSkeletalMeshes;                       // 0x0065(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bForceBelowThreshold;                                     // 0x0066(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bFirstRecompressUsingCurrentOrDefault;                    // 0x0067(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bRaiseMaxErrorToExisting;                                 // 0x0068(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bTryFixedBitwiseCompression;                              // 0x0069(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bTryPerTrackBitwiseCompression;                           // 0x006A(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bTryLinearKeyRemovalCompression;                          // 0x006B(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bTryIntervalKeyRemoval;                                   // 0x006C(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bEnablePerformanceLog;                                    // 0x006D(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bStripAnimationDataOnDedicatedServer;                     // 0x006E(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bTickAnimationOnSkeletalMeshInit;                         // 0x006F(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimationSettings");
		return ptr;
	}

};


// Class Engine.BlueprintCore
// 0x0028 (0x0050 - 0x0028)
class UBlueprintCore : public UObject
{
public:
	class UClass*                                      SkeletonGeneratedClass;                                   // 0x0028(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class UClass*                                      GeneratedClass;                                           // 0x0030(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bLegacyNeedToPurgeSkelRefs;                               // 0x0038(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bLegacyGeneratedClassIsAuthoritative;                     // 0x0039(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x2];                                       // 0x003A(0x0002) MISSED OFFSET
	struct FGuid                                       BlueprintGuid;                                            // 0x003C(0x0010) (CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x004C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BlueprintCore");
		return ptr;
	}

};


// Class Engine.Blueprint
// 0x0150 (0x01A0 - 0x0050)
class UBlueprint : public UBlueprintCore
{
public:
	unsigned char                                      bRecompileOnLoad : 1;                                     // 0x0050(0x0001) (CPF_Config)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0051(0x0007) MISSED OFFSET
	class UClass*                                      ParentClass;                                              // 0x0058(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UObject*                                     PRIVATE_InnermostPreviousCDO;                             // 0x0060(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      bHasBeenRegenerated : 1;                                  // 0x0068(0x0001) (CPF_Transient)
	unsigned char                                      bIsRegeneratingOnLoad : 1;                                // 0x0068(0x0001) (CPF_Transient)
	unsigned char                                      UnknownData01[0x7];                                       // 0x0069(0x0007) MISSED OFFSET
	class USimpleConstructionScript*                   SimpleConstructionScript;                                 // 0x0070(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<class UActorComponent*>                     ComponentTemplates;                                       // 0x0078(0x0010) (CPF_ExportObject, CPF_ZeroConstructor)
	TArray<class UTimelineTemplate*>                   Timelines;                                                // 0x0088(0x0010) (CPF_ZeroConstructor)
	class UInheritableComponentHandler*                InheritableComponentHandler;                              // 0x0098(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EBlueprintType>                        BlueprintType;                                            // 0x00A0(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x3];                                       // 0x00A1(0x0003) MISSED OFFSET
	int                                                BlueprintSystemVersion;                                   // 0x00A4(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0xE8];                                      // 0x00A8(0x00E8) MISSED OFFSET
	bool                                               bNativize;                                                // 0x0190(0x0001) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	unsigned char                                      UnknownData04[0xF];                                       // 0x0191(0x000F) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Blueprint");
		return ptr;
	}

};


// Class Engine.AnimBlueprint
// 0x0020 (0x01C0 - 0x01A0)
class UAnimBlueprint : public UBlueprint
{
public:
	TArray<struct FAnimGroupInfo>                      Groups;                                                   // 0x01A0(0x0010) (CPF_ZeroConstructor)
	bool                                               bUseMultiThreadedAnimationUpdate;                         // 0x01B0(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bWarnAboutBlueprintUsage;                                 // 0x01B1(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0xE];                                       // 0x01B2(0x000E) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimBlueprint");
		return ptr;
	}

};


// Class Engine.AnimBlueprintGeneratedClass
// 0x0070 (0x0348 - 0x02D8)
class UAnimBlueprintGeneratedClass : public UBlueprintGeneratedClass
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x02D8(0x0008) MISSED OFFSET
	TArray<struct FBakedAnimationStateMachine>         BakedStateMachines;                                       // 0x02E0(0x0010) (CPF_ZeroConstructor)
	class USkeleton*                                   TargetSkeleton;                                           // 0x02F0(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<struct FAnimNotifyEvent>                    AnimNotifies;                                             // 0x02F8(0x0010) (CPF_ZeroConstructor)
	int                                                RootAnimNodeIndex;                                        // 0x0308(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x030C(0x0004) MISSED OFFSET
	TArray<int>                                        OrderedSavedPoseIndices;                                  // 0x0310(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      UnknownData02[0x18];                                      // 0x0320(0x0018) MISSED OFFSET
	TArray<struct FName>                               SyncGroupNames;                                           // 0x0338(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimBlueprintGeneratedClass");
		return ptr;
	}

};


// Class Engine.AnimClassData
// 0x0070 (0x0098 - 0x0028)
class UAnimClassData : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET
	TArray<struct FBakedAnimationStateMachine>         BakedStateMachines;                                       // 0x0030(0x0010) (CPF_ZeroConstructor)
	class USkeleton*                                   TargetSkeleton;                                           // 0x0040(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<struct FAnimNotifyEvent>                    AnimNotifies;                                             // 0x0048(0x0010) (CPF_ZeroConstructor)
	int                                                RootAnimNodeIndex;                                        // 0x0058(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x005C(0x0004) MISSED OFFSET
	TArray<int>                                        OrderedSavedPoseIndices;                                  // 0x0060(0x0010) (CPF_ZeroConstructor)
	class UStructProperty*                             RootAnimNodeProperty;                                     // 0x0070(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<class UStructProperty*>                     AnimNodeProperties;                                       // 0x0078(0x0010) (CPF_ZeroConstructor)
	TArray<struct FName>                               SyncGroupNames;                                           // 0x0088(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimClassData");
		return ptr;
	}

};


// Class Engine.AnimClassInterface
// 0x0000 (0x0028 - 0x0028)
class UAnimClassInterface : public UInterface
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimClassInterface");
		return ptr;
	}

};


// Class Engine.AnimSequenceBase
// 0x0028 (0x00A0 - 0x0078)
class UAnimSequenceBase : public UAnimationAsset
{
public:
	TArray<struct FAnimNotifyEvent>                    Notifies;                                                 // 0x0078(0x0010) (CPF_ZeroConstructor)
	float                                              SequenceLength;                                           // 0x0088(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)
	float                                              RateScale;                                                // 0x008C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FRawCurveTracks                             RawCurveData;                                             // 0x0090(0x0010)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimSequenceBase");
		return ptr;
	}


	float GetPlayLength();
};


// Class Engine.AnimCompositeBase
// 0x0000 (0x00A0 - 0x00A0)
class UAnimCompositeBase : public UAnimSequenceBase
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimCompositeBase");
		return ptr;
	}

};


// Class Engine.AnimComposite
// 0x0010 (0x00B0 - 0x00A0)
class UAnimComposite : public UAnimCompositeBase
{
public:
	struct FAnimTrack                                  AnimationTrack;                                           // 0x00A0(0x0010)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimComposite");
		return ptr;
	}

};


// Class Engine.AnimCompress
// 0x0020 (0x0048 - 0x0028)
class UAnimCompress : public UObject
{
public:
	struct FString                                     Description;                                              // 0x0028(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_EditConst)
	unsigned char                                      bNeedsSkeleton : 1;                                       // 0x0038(0x0001)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0039(0x0003) MISSED OFFSET
	TEnumAsByte<EAnimationCompressionFormat>           TranslationCompressionFormat;                             // 0x003C(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EAnimationCompressionFormat>           RotationCompressionFormat;                                // 0x003D(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EAnimationCompressionFormat>           ScaleCompressionFormat;                                   // 0x003E(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x1];                                       // 0x003F(0x0001) MISSED OFFSET
	float                                              MaxCurveError;                                            // 0x0040(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x4];                                       // 0x0044(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimCompress");
		return ptr;
	}

};


// Class Engine.AnimCompress_Automatic
// 0x0008 (0x0050 - 0x0048)
class UAnimCompress_Automatic : public UAnimCompress
{
public:
	float                                              MaxEndEffectorError;                                      // 0x0048(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bTryFixedBitwiseCompression : 1;                          // 0x004C(0x0001) (CPF_Edit)
	unsigned char                                      bTryPerTrackBitwiseCompression : 1;                       // 0x004C(0x0001) (CPF_Edit)
	unsigned char                                      bTryLinearKeyRemovalCompression : 1;                      // 0x004C(0x0001) (CPF_Edit)
	unsigned char                                      bTryIntervalKeyRemoval : 1;                               // 0x004C(0x0001) (CPF_Edit)
	unsigned char                                      bRunCurrentDefaultCompressor : 1;                         // 0x004C(0x0001) (CPF_Edit)
	unsigned char                                      bAutoReplaceIfExistingErrorTooGreat : 1;                  // 0x004C(0x0001) (CPF_Edit)
	unsigned char                                      bRaiseMaxErrorToExisting : 1;                             // 0x004C(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x3];                                       // 0x004D(0x0003) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimCompress_Automatic");
		return ptr;
	}

};


// Class Engine.AnimCompress_BitwiseCompressOnly
// 0x0000 (0x0048 - 0x0048)
class UAnimCompress_BitwiseCompressOnly : public UAnimCompress
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimCompress_BitwiseCompressOnly");
		return ptr;
	}

};


// Class Engine.AnimCompress_LeastDestructive
// 0x0000 (0x0048 - 0x0048)
class UAnimCompress_LeastDestructive : public UAnimCompress
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimCompress_LeastDestructive");
		return ptr;
	}

};


// Class Engine.AnimCompress_RemoveLinearKeys
// 0x0020 (0x0068 - 0x0048)
class UAnimCompress_RemoveLinearKeys : public UAnimCompress
{
public:
	float                                              MaxPosDiff;                                               // 0x0048(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxAngleDiff;                                             // 0x004C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxScaleDiff;                                             // 0x0050(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxEffectorDiff;                                          // 0x0054(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MinEffectorDiff;                                          // 0x0058(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              EffectorDiffSocket;                                       // 0x005C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ParentKeyScale;                                           // 0x0060(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bRetarget : 1;                                            // 0x0064(0x0001) (CPF_Edit)
	unsigned char                                      bActuallyFilterLinearKeys : 1;                            // 0x0064(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0065(0x0003) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimCompress_RemoveLinearKeys");
		return ptr;
	}

};


// Class Engine.AnimCompress_PerTrackCompression
// 0x0080 (0x00E8 - 0x0068)
class UAnimCompress_PerTrackCompression : public UAnimCompress_RemoveLinearKeys
{
public:
	float                                              MaxZeroingThreshold;                                      // 0x0068(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxPosDiffBitwise;                                        // 0x006C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxAngleDiffBitwise;                                      // 0x0070(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxScaleDiffBitwise;                                      // 0x0074(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<TEnumAsByte<EAnimationCompressionFormat>>   AllowedRotationFormats;                                   // 0x0078(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	TArray<TEnumAsByte<EAnimationCompressionFormat>>   AllowedTranslationFormats;                                // 0x0088(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	TArray<TEnumAsByte<EAnimationCompressionFormat>>   AllowedScaleFormats;                                      // 0x0098(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	unsigned char                                      bResampleAnimation : 1;                                   // 0x00A8(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x3];                                       // 0x00A9(0x0003) MISSED OFFSET
	float                                              ResampledFramerate;                                       // 0x00AC(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                MinKeysForResampling;                                     // 0x00B0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bUseAdaptiveError : 1;                                    // 0x00B4(0x0001) (CPF_Edit)
	unsigned char                                      bUseOverrideForEndEffectors : 1;                          // 0x00B4(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData01[0x3];                                       // 0x00B5(0x0003) MISSED OFFSET
	int                                                TrackHeightBias;                                          // 0x00B8(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ParentingDivisor;                                         // 0x00BC(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ParentingDivisorExponent;                                 // 0x00C0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bUseAdaptiveError2 : 1;                                   // 0x00C4(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData02[0x3];                                       // 0x00C5(0x0003) MISSED OFFSET
	float                                              RotationErrorSourceRatio;                                 // 0x00C8(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              TranslationErrorSourceRatio;                              // 0x00CC(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ScaleErrorSourceRatio;                                    // 0x00D0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxErrorPerTrackRatio;                                    // 0x00D4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              PerturbationProbeSize;                                    // 0x00D8(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0xC];                                       // 0x00DC(0x000C) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimCompress_PerTrackCompression");
		return ptr;
	}

};


// Class Engine.AnimCompress_RemoveEverySecondKey
// 0x0008 (0x0050 - 0x0048)
class UAnimCompress_RemoveEverySecondKey : public UAnimCompress
{
public:
	int                                                MinKeys;                                                  // 0x0048(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bStartAtSecondKey : 1;                                    // 0x004C(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x3];                                       // 0x004D(0x0003) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimCompress_RemoveEverySecondKey");
		return ptr;
	}

};


// Class Engine.AnimCompress_RemoveTrivialKeys
// 0x0010 (0x0058 - 0x0048)
class UAnimCompress_RemoveTrivialKeys : public UAnimCompress
{
public:
	float                                              MaxPosDiff;                                               // 0x0048(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxAngleDiff;                                             // 0x004C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxScaleDiff;                                             // 0x0050(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x0054(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimCompress_RemoveTrivialKeys");
		return ptr;
	}

};


// Class Engine.AnimMetaData
// 0x0000 (0x0028 - 0x0028)
class UAnimMetaData : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimMetaData");
		return ptr;
	}

};


// Class Engine.AnimMontage
// 0x0138 (0x01D8 - 0x00A0)
class UAnimMontage : public UAnimCompositeBase
{
public:
	struct FAlphaBlend                                 BlendIn;                                                  // 0x00A0(0x0038) (CPF_Edit)
	float                                              BlendInTime;                                              // 0x00D8(0x0004) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x00DC(0x0004) MISSED OFFSET
	struct FAlphaBlend                                 BlendOut;                                                 // 0x00E0(0x0038) (CPF_Edit)
	float                                              BlendOutTime;                                             // 0x0118(0x0004) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	float                                              BlendOutTriggerTime;                                      // 0x011C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FName                                       SyncGroup;                                                // 0x0120(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                SyncSlotIndex;                                            // 0x0128(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x012C(0x0004) MISSED OFFSET
	struct FMarkerSyncData                             MarkerData;                                               // 0x0130(0x0020)
	TArray<struct FCompositeSection>                   CompositeSections;                                        // 0x0150(0x0010) (CPF_ZeroConstructor)
	TArray<struct FSlotAnimationTrack>                 SlotAnimTracks;                                           // 0x0160(0x0010) (CPF_ZeroConstructor)
	TArray<struct FBranchingPoint>                     BranchingPoints;                                          // 0x0170(0x0010) (CPF_ZeroConstructor, CPF_Deprecated)
	bool                                               bEnableRootMotionTranslation;                             // 0x0180(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bEnableRootMotionRotation;                                // 0x0181(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ERootMotionRootLock>                   RootMotionRootLock;                                       // 0x0182(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x5];                                       // 0x0183(0x0005) MISSED OFFSET
	TArray<struct FBranchingPointMarker>               BranchingPointMarkers;                                    // 0x0188(0x0010) (CPF_ZeroConstructor)
	TArray<int>                                        BranchingPointStateNotifyIndices;                         // 0x0198(0x0010) (CPF_ZeroConstructor)
	struct FTimeStretchCurve                           TimeStretchCurve;                                         // 0x01A8(0x0028) (CPF_Edit)
	struct FName                                       TimeStretchCurveName;                                     // 0x01D0(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimMontage");
		return ptr;
	}

};


// Class Engine.AnimNotify_PlayParticleEffect
// 0x0058 (0x0090 - 0x0038)
class UAnimNotify_PlayParticleEffect : public UAnimNotify
{
public:
	class UParticleSystem*                             PSTemplate;                                               // 0x0038(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FVector                                     LocationOffset;                                           // 0x0040(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	struct FRotator                                    RotationOffset;                                           // 0x004C(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	struct FVector                                     Scale;                                                    // 0x0058(0x000C) (CPF_Edit, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x1C];                                      // 0x0064(0x001C) MISSED OFFSET
	unsigned char                                      Attached : 1;                                             // 0x0080(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData01[0x7];                                       // 0x0081(0x0007) MISSED OFFSET
	struct FName                                       SocketName;                                               // 0x0088(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimNotify_PlayParticleEffect");
		return ptr;
	}

};


// Class Engine.AnimNotify_PlaySound
// 0x0020 (0x0058 - 0x0038)
class UAnimNotify_PlaySound : public UAnimNotify
{
public:
	class USoundBase*                                  Sound;                                                    // 0x0038(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              VolumeMultiplier;                                         // 0x0040(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              PitchMultiplier;                                          // 0x0044(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bFollow : 1;                                              // 0x0048(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0049(0x0007) MISSED OFFSET
	struct FName                                       AttachName;                                               // 0x0050(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimNotify_PlaySound");
		return ptr;
	}

};


// Class Engine.AnimNotify_ResetClothingSimulation
// 0x0000 (0x0038 - 0x0038)
class UAnimNotify_ResetClothingSimulation : public UAnimNotify
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimNotify_ResetClothingSimulation");
		return ptr;
	}

};


// Class Engine.AnimNotifyState_DisableRootMotion
// 0x0000 (0x0030 - 0x0030)
class UAnimNotifyState_DisableRootMotion : public UAnimNotifyState
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimNotifyState_DisableRootMotion");
		return ptr;
	}

};


// Class Engine.AnimNotifyState_TimedParticleEffect
// 0x0030 (0x0060 - 0x0030)
class UAnimNotifyState_TimedParticleEffect : public UAnimNotifyState
{
public:
	class UParticleSystem*                             PSTemplate;                                               // 0x0030(0x0008) (CPF_Edit, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FName                                       SocketName;                                               // 0x0038(0x0008) (CPF_Edit, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FVector                                     LocationOffset;                                           // 0x0040(0x000C) (CPF_Edit, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	struct FRotator                                    RotationOffset;                                           // 0x004C(0x000C) (CPF_Edit, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	bool                                               bDestroyAtEnd;                                            // 0x0058(0x0001) (CPF_Edit, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0059(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimNotifyState_TimedParticleEffect");
		return ptr;
	}

};


// Class Engine.AnimNotifyState_Trail
// 0x0030 (0x0060 - 0x0030)
class UAnimNotifyState_Trail : public UAnimNotifyState
{
public:
	class UParticleSystem*                             PSTemplate;                                               // 0x0030(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FName                                       FirstSocketName;                                          // 0x0038(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FName                                       SecondSocketName;                                         // 0x0040(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ETrailWidthMode>                       WidthScaleMode;                                           // 0x0048(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0049(0x0007) MISSED OFFSET
	struct FName                                       WidthScaleCurve;                                          // 0x0050(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bRecycleSpawnedSystems : 1;                               // 0x0058(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData01[0x7];                                       // 0x0059(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimNotifyState_Trail");
		return ptr;
	}


	class UParticleSystem* OverridePSTemplate(class USkeletalMeshComponent* MeshComp, class UAnimSequenceBase* Animation);
};


// Class Engine.AnimSequence
// 0x00F8 (0x0198 - 0x00A0)
class UAnimSequence : public UAnimSequenceBase
{
public:
	int                                                NumFrames;                                                // 0x00A0(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x00A4(0x0004) MISSED OFFSET
	TArray<struct FTrackToSkeletonMap>                 TrackToSkeletonMapTable;                                  // 0x00A8(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      UnknownData01[0x94];                                      // 0x00B8(0x0094) MISSED OFFSET
	TEnumAsByte<EAdditiveAnimationType>                AdditiveAnimType;                                         // 0x014C(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EAdditiveBasePoseType>                 RefPoseType;                                              // 0x014D(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x2];                                       // 0x014E(0x0002) MISSED OFFSET
	class UAnimSequence*                               RefPoseSeq;                                               // 0x0150(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                RefFrameIndex;                                            // 0x0158(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                EncodingPkgVersion;                                       // 0x015C(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FName                                       RetargetSource;                                           // 0x0160(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	EAnimInterpolationType                             Interpolation;                                            // 0x0168(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bEnableRootMotion;                                        // 0x0169(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ERootMotionRootLock>                   RootMotionRootLock;                                       // 0x016A(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bForceRootLock;                                           // 0x016B(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bRootMotionSettingsCopiedFromMontage;                     // 0x016C(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0x3];                                       // 0x016D(0x0003) MISSED OFFSET
	TArray<struct FAnimSyncMarker>                     AuthoredSyncMarkers;                                      // 0x0170(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      UnknownData04[0x18];                                      // 0x0180(0x0018) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimSequence");
		return ptr;
	}

};


// Class Engine.AnimSet
// 0x00C8 (0x00F0 - 0x0028)
class UAnimSet : public UObject
{
public:
	unsigned char                                      bAnimRotationOnly : 1;                                    // 0x0028(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0029(0x0007) MISSED OFFSET
	TArray<struct FName>                               TrackBoneNames;                                           // 0x0030(0x0010) (CPF_ZeroConstructor)
	TArray<struct FAnimSetMeshLinkup>                  LinkupCache;                                              // 0x0040(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	TArray<unsigned char>                              BoneUseAnimTranslation;                                   // 0x0050(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	TArray<unsigned char>                              ForceUseMeshTranslation;                                  // 0x0060(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	TArray<struct FName>                               UseTranslationBoneNames;                                  // 0x0070(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	TArray<struct FName>                               ForceMeshTranslationBoneNames;                            // 0x0080(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	struct FName                                       PreviewSkelMeshName;                                      // 0x0090(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FName                                       BestRatioSkelMeshName;                                    // 0x0098(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x50];                                      // 0x00A0(0x0050) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimSet");
		return ptr;
	}

};


// Class Engine.AnimSingleNodeInstance
// 0x0010 (0x03D0 - 0x03C0)
class UAnimSingleNodeInstance : public UAnimInstance
{
public:
	struct FScriptDelegate                             PostEvaluateAnimEvent;                                    // 0x03C0(0x0014) (CPF_ZeroConstructor, CPF_Transient, CPF_InstancedReference)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimSingleNodeInstance");
		return ptr;
	}


	void StopAnim();
	void SetReverse(bool bInReverse);
	void SetPreviewCurveOverride(const struct FName& PoseName, float Value, bool bRemoveIfZero);
	void SetPositionWithPreviousTime(float InPosition, float InPreviousTime, bool bFireNotifies);
	void SetPosition(float InPosition, bool bFireNotifies);
	void SetPlayRate(float InPlayRate);
	void SetPlaying(bool bIsPlaying);
	void SetLooping(bool bIsLooping);
	void SetBlendSpaceInput(const struct FVector& InBlendInput);
	void SetAnimationAsset(class UAnimationAsset* NewAsset, bool bIsLooping, float InPlayRate);
	void PlayAnim(bool bIsLooping, float InPlayRate, float InStartPosition);
	float GetLength();
	class UAnimationAsset* GetAnimationAsset();
};


// Class Engine.AnimStateMachineTypes
// 0x0000 (0x0028 - 0x0028)
class UAnimStateMachineTypes : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AnimStateMachineTypes");
		return ptr;
	}

};


// Class Engine.ApplicationLifecycleComponent
// 0x0050 (0x0140 - 0x00F0)
class UApplicationLifecycleComponent : public UActorComponent
{
public:
	struct FScriptMulticastDelegate                    ApplicationWillDeactivateDelegate;                        // 0x00F0(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    ApplicationHasReactivatedDelegate;                        // 0x0100(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    ApplicationWillEnterBackgroundDelegate;                   // 0x0110(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    ApplicationHasEnteredForegroundDelegate;                  // 0x0120(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    ApplicationWillTerminateDelegate;                         // 0x0130(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ApplicationLifecycleComponent");
		return ptr;
	}

};


// Class Engine.ArrowComponent
// 0x0020 (0x0680 - 0x0660)
class UArrowComponent : public UPrimitiveComponent
{
public:
	struct FColor                                      ArrowColor;                                               // 0x0660(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_IsPlainOldData)
	float                                              ArrowSize;                                                // 0x0664(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bIsScreenSizeScaled;                                      // 0x0668(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0669(0x0003) MISSED OFFSET
	float                                              ScreenSize;                                               // 0x066C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bTreatAsASprite : 1;                                      // 0x0670(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData01[0xF];                                       // 0x0671(0x000F) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ArrowComponent");
		return ptr;
	}


	void SetArrowColor(const struct FLinearColor& NewColor);
};


// Class Engine.AssetImportData
// 0x0000 (0x0028 - 0x0028)
class UAssetImportData : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AssetImportData");
		return ptr;
	}

};


// Class Engine.AssetManagerSettings
// 0x0068 (0x00A0 - 0x0038)
class UAssetManagerSettings : public UDeveloperSettings
{
public:
	TArray<struct FPrimaryAssetTypeInfo>               PrimaryAssetTypesToScan;                                  // 0x0038(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	TArray<struct FDirectoryPath>                      DirectoriesToExclude;                                     // 0x0048(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	TArray<struct FPrimaryAssetRulesOverride>          PrimaryAssetRules;                                        // 0x0058(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	bool                                               bOnlyCookProductionAssets;                                // 0x0068(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bShouldManagerDetermineTypeAndName;                       // 0x0069(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bShouldGuessTypeAndNameInEditor;                          // 0x006A(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bShouldAcquireMissingChunksOnLoad;                        // 0x006B(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x006C(0x0004) MISSED OFFSET
	TArray<struct FAssetManagerRedirect>               PrimaryAssetIdRedirects;                                  // 0x0070(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	TArray<struct FAssetManagerRedirect>               PrimaryAssetTypeRedirects;                                // 0x0080(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	TArray<struct FAssetManagerRedirect>               AssetPathRedirects;                                       // 0x0090(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AssetManagerSettings");
		return ptr;
	}

};


// Class Engine.AssetMappingTable
// 0x0010 (0x0038 - 0x0028)
class UAssetMappingTable : public UObject
{
public:
	TArray<struct FAssetMapping>                       MappedAssets;                                             // 0x0028(0x0010) (CPF_Edit, CPF_EditFixedSize, CPF_ZeroConstructor, CPF_EditConst)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AssetMappingTable");
		return ptr;
	}

};


// Class Engine.AsyncActionLoadPrimaryAssetBase
// 0x0048 (0x0070 - 0x0028)
class UAsyncActionLoadPrimaryAssetBase : public UBlueprintAsyncActionBase
{
public:
	unsigned char                                      UnknownData00[0x48];                                      // 0x0028(0x0048) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AsyncActionLoadPrimaryAssetBase");
		return ptr;
	}

};


// Class Engine.AsyncActionLoadPrimaryAsset
// 0x0010 (0x0080 - 0x0070)
class UAsyncActionLoadPrimaryAsset : public UAsyncActionLoadPrimaryAssetBase
{
public:
	struct FScriptMulticastDelegate                    Completed;                                                // 0x0070(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AsyncActionLoadPrimaryAsset");
		return ptr;
	}


	static class UAsyncActionLoadPrimaryAsset* AsyncLoadPrimaryAsset(const struct FPrimaryAssetId& PrimaryAsset, TArray<struct FName> LoadBundles);
};


// Class Engine.AsyncActionLoadPrimaryAssetClass
// 0x0010 (0x0080 - 0x0070)
class UAsyncActionLoadPrimaryAssetClass : public UAsyncActionLoadPrimaryAssetBase
{
public:
	struct FScriptMulticastDelegate                    Completed;                                                // 0x0070(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AsyncActionLoadPrimaryAssetClass");
		return ptr;
	}


	static class UAsyncActionLoadPrimaryAssetClass* AsyncLoadPrimaryAssetClass(const struct FPrimaryAssetId& PrimaryAsset, TArray<struct FName> LoadBundles);
};


// Class Engine.AsyncActionLoadPrimaryAssetList
// 0x0010 (0x0080 - 0x0070)
class UAsyncActionLoadPrimaryAssetList : public UAsyncActionLoadPrimaryAssetBase
{
public:
	struct FScriptMulticastDelegate                    Completed;                                                // 0x0070(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AsyncActionLoadPrimaryAssetList");
		return ptr;
	}


	static class UAsyncActionLoadPrimaryAssetList* AsyncLoadPrimaryAssetList(TArray<struct FPrimaryAssetId> PrimaryAssetList, TArray<struct FName> LoadBundles);
};


// Class Engine.AsyncActionLoadPrimaryAssetClassList
// 0x0010 (0x0080 - 0x0070)
class UAsyncActionLoadPrimaryAssetClassList : public UAsyncActionLoadPrimaryAssetBase
{
public:
	struct FScriptMulticastDelegate                    Completed;                                                // 0x0070(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AsyncActionLoadPrimaryAssetClassList");
		return ptr;
	}


	static class UAsyncActionLoadPrimaryAssetClassList* AsyncLoadPrimaryAssetClassList(TArray<struct FPrimaryAssetId> PrimaryAssetList, TArray<struct FName> LoadBundles);
};


// Class Engine.AsyncActionChangePrimaryAssetBundles
// 0x0010 (0x0080 - 0x0070)
class UAsyncActionChangePrimaryAssetBundles : public UAsyncActionLoadPrimaryAssetBase
{
public:
	struct FScriptMulticastDelegate                    Completed;                                                // 0x0070(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AsyncActionChangePrimaryAssetBundles");
		return ptr;
	}


	static class UAsyncActionChangePrimaryAssetBundles* AsyncChangeBundleStateForPrimaryAssetList(TArray<struct FPrimaryAssetId> PrimaryAssetList, TArray<struct FName> AddBundles, TArray<struct FName> RemoveBundles);
	static class UAsyncActionChangePrimaryAssetBundles* AsyncChangeBundleStateForMatchingPrimaryAssets(TArray<struct FName> NewBundles, TArray<struct FName> OldBundles);
};


// Class Engine.AtmosphericFog
// 0x0008 (0x0320 - 0x0318)
class AAtmosphericFog : public AInfo
{
public:
	class UAtmosphericFogComponent*                    AtmosphericFogComponent;                                  // 0x0318(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AtmosphericFog");
		return ptr;
	}

};


// Class Engine.AtmosphericFogComponent
// 0x01E0 (0x0470 - 0x0290)
class UAtmosphericFogComponent : public USceneComponent
{
public:
	float                                              SunMultiplier;                                            // 0x0290(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              FogMultiplier;                                            // 0x0294(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              DensityMultiplier;                                        // 0x0298(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              DensityOffset;                                            // 0x029C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              DistanceScale;                                            // 0x02A0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              AltitudeScale;                                            // 0x02A4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              DistanceOffset;                                           // 0x02A8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              GroundOffset;                                             // 0x02AC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              StartDistance;                                            // 0x02B0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              SunDiscScale;                                             // 0x02B4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              DefaultBrightness;                                        // 0x02B8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FColor                                      DefaultLightColor;                                        // 0x02BC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	unsigned char                                      bDisableSunDisk : 1;                                      // 0x02C0(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bDisableGroundScattering : 1;                             // 0x02C0(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData00[0x3];                                       // 0x02C1(0x0003) MISSED OFFSET
	struct FAtmospherePrecomputeParameters             PrecomputeParams;                                         // 0x02C4(0x002C) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	class UTexture2D*                                  TransmittanceTexture;                                     // 0x02F0(0x0008) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	class UTexture2D*                                  IrradianceTexture;                                        // 0x02F8(0x0008) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x170];                                     // 0x0300(0x0170) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AtmosphericFogComponent");
		return ptr;
	}


	void StartPrecompute();
	void SetSunMultiplier(float NewSunMultiplier);
	void SetStartDistance(float NewStartDistance);
	void SetPrecomputeParams(float DensityHeight, int MaxScatteringOrder, int InscatterAltitudeSampleNum);
	void SetFogMultiplier(float NewFogMultiplier);
	void SetDistanceScale(float NewDistanceScale);
	void SetDistanceOffset(float NewDistanceOffset);
	void SetDensityOffset(float NewDensityOffset);
	void SetDensityMultiplier(float NewDensityMultiplier);
	void SetDefaultLightColor(const struct FLinearColor& NewLightColor);
	void SetDefaultBrightness(float NewBrightness);
	void SetAltitudeScale(float NewAltitudeScale);
	void DisableSunDisk(bool NewSunDisk);
	void DisableGroundScattering(bool NewGroundScattering);
};


// Class Engine.AudioSettings
// 0x00A8 (0x00E0 - 0x0038)
class UAudioSettings : public UDeveloperSettings
{
public:
	struct FSoftObjectPath                             DefaultSoundClassName;                                    // 0x0038(0x0018) (CPF_Edit, CPF_Config)
	struct FSoftObjectPath                             DefaultSoundConcurrencyName;                              // 0x0050(0x0018) (CPF_Edit, CPF_Config)
	struct FSoftObjectPath                             DefaultBaseSoundMix;                                      // 0x0068(0x0018) (CPF_Edit, CPF_Config)
	struct FSoftObjectPath                             VoiPSoundClass;                                           // 0x0080(0x0018) (CPF_Edit, CPF_Config)
	EVoiceSampleRate                                   VoiPSampleRate;                                           // 0x0098(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0098(0x0003) FIX WRONG TYPE SIZE OF PREVIOUS PROPERTY
	float                                              VoipBufferingDelay;                                       // 0x009C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              DefaultReverbSendLevel;                                   // 0x00A0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              LowPassFilterResonance;                                   // 0x00A4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                MaximumConcurrentStreams;                                 // 0x00A8(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x00AC(0x0004) MISSED OFFSET
	TArray<struct FAudioQualitySettings>               QualityLevels;                                            // 0x00B0(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	unsigned char                                      bAllowVirtualizedSounds : 1;                              // 0x00C0(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bDisableMasterEQ : 1;                                     // 0x00C0(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bDisableMasterReverb : 1;                                 // 0x00C0(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bAllowCenterChannel3DPanning : 1;                         // 0x00C0(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      UnknownData02[0x7];                                       // 0x00C1(0x0007) MISSED OFFSET
	struct FString                                     DialogueFilenameFormat;                                   // 0x00C8(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	unsigned char                                      UnknownData03[0x8];                                       // 0x00D8(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AudioSettings");
		return ptr;
	}

};


// Class Engine.AudioVolume
// 0x0050 (0x03A0 - 0x0350)
class AAudioVolume : public AVolume
{
public:
	float                                              Priority;                                                 // 0x0350(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bEnabled : 1;                                             // 0x0354(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Net)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0355(0x0003) MISSED OFFSET
	struct FReverbSettings                             Settings;                                                 // 0x0358(0x0020) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	struct FInteriorSettings                           AmbientZoneSettings;                                      // 0x0378(0x0024) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData01[0x4];                                       // 0x039C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AudioVolume");
		return ptr;
	}


	void SetReverbSettings(const struct FReverbSettings& NewReverbSettings);
	void SetPriority(float NewPriority);
	void SetInteriorSettings(const struct FInteriorSettings& NewInteriorSettings);
	void SetEnabled(bool bNewEnabled);
	void OnRep_bEnabled();
};


// Class Engine.AutomationTestSettings
// 0x0300 (0x0328 - 0x0028)
class UAutomationTestSettings : public UObject
{
public:
	TArray<struct FString>                             EngineTestModules;                                        // 0x0028(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	TArray<struct FString>                             EditorTestModules;                                        // 0x0038(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	struct FSoftObjectPath                             AutomationTestmap;                                        // 0x0048(0x0018) (CPF_Edit, CPF_Config)
	TArray<struct FEditorMapPerformanceTestDefinition> EditorPerformanceTestMaps;                                // 0x0060(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	TArray<struct FSoftObjectPath>                     AssetsToOpen;                                             // 0x0070(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	struct FBuildPromotionTestSettings                 BuildPromotionTest;                                       // 0x0080(0x01F0) (CPF_Edit, CPF_Config)
	struct FMaterialEditorPromotionSettings            MaterialEditorPromotionTest;                              // 0x0270(0x0030) (CPF_Edit, CPF_Config)
	struct FParticleEditorPromotionSettings            ParticleEditorPromotionTest;                              // 0x02A0(0x0010) (CPF_Edit, CPF_Config)
	struct FBlueprintEditorPromotionSettings           BlueprintEditorPromotionTest;                             // 0x02B0(0x0030) (CPF_Edit, CPF_Config)
	TArray<struct FString>                             TestLevelFolders;                                         // 0x02E0(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	TArray<struct FExternalToolDefinition>             ExternalTools;                                            // 0x02F0(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	TArray<struct FEditorImportExportTestDefinition>   ImportExportTestDefinitions;                              // 0x0300(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	TArray<struct FLaunchOnTestSettings>               LaunchOnSettings;                                         // 0x0310(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	struct FIntPoint                                   DefaultScreenshotResolution;                              // 0x0320(0x0008) (CPF_Edit, CPF_Config, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AutomationTestSettings");
		return ptr;
	}

};


// Class Engine.AvoidanceManager
// 0x00B8 (0x00E0 - 0x0028)
class UAvoidanceManager : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET
	float                                              DefaultTimeToLive;                                        // 0x0030(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              LockTimeAfterAvoid;                                       // 0x0034(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              LockTimeAfterClean;                                       // 0x0038(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              DeltaTimeToPredict;                                       // 0x003C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              ArtificialRadiusExpansion;                                // 0x0040(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              TestHeightDifference;                                     // 0x0044(0x0004) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	float                                              HeightCheckMargin;                                        // 0x0048(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x94];                                      // 0x004C(0x0094) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AvoidanceManager");
		return ptr;
	}


	bool RegisterMovementComponent(class UMovementComponent* MovementComp, float AvoidanceWeight);
	int GetObjectCount();
	int GetNewAvoidanceUID();
	struct FVector GetAvoidanceVelocityForComponent(class UMovementComponent* MovementComp);
};


// Class Engine.BillboardComponent
// 0x0020 (0x0680 - 0x0660)
class UBillboardComponent : public UPrimitiveComponent
{
public:
	class UTexture2D*                                  Sprite;                                                   // 0x0660(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bIsScreenSizeScaled : 1;                                  // 0x0668(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0669(0x0003) MISSED OFFSET
	float                                              ScreenSize;                                               // 0x066C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              U;                                                        // 0x0670(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              UL;                                                       // 0x0674(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              V;                                                        // 0x0678(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              VL;                                                       // 0x067C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BillboardComponent");
		return ptr;
	}


	void SetUV(int NewU, int NewUL, int NewV, int NewVL);
	void SetSpriteAndUV(class UTexture2D* NewSprite, int NewU, int NewUL, int NewV, int NewVL);
	void SetSprite(class UTexture2D* NewSprite);
};


// Class Engine.BlendableInterface
// 0x0000 (0x0028 - 0x0028)
class UBlendableInterface : public UInterface
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BlendableInterface");
		return ptr;
	}

};


// Class Engine.Skeleton
// 0x0378 (0x03A0 - 0x0028)
class USkeleton : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET
	TArray<struct FBoneNode>                           BoneTree;                                                 // 0x0030(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_EditConst)
	TArray<struct FTransform>                          RefLocalPoses;                                            // 0x0040(0x0010) (CPF_ZeroConstructor, CPF_Deprecated)
	unsigned char                                      UnknownData01[0x110];                                     // 0x0050(0x0110) MISSED OFFSET
	struct FGuid                                       VirtualBoneGuid;                                          // 0x0160(0x0010) (CPF_IsPlainOldData)
	TArray<struct FVirtualBone>                        VirtualBones;                                             // 0x0170(0x0010) (CPF_ZeroConstructor)
	TArray<class USkeletalMeshSocket*>                 Sockets;                                                  // 0x0180(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      UnknownData02[0x50];                                      // 0x0190(0x0050) MISSED OFFSET
	struct FSmartNameContainer                         SmartNames;                                               // 0x01E0(0x0050)
	unsigned char                                      UnknownData03[0x18];                                      // 0x0230(0x0018) MISSED OFFSET
	TArray<class UBlendProfile*>                       BlendProfiles;                                            // 0x0248(0x0010) (CPF_ExportObject, CPF_ZeroConstructor)
	TArray<struct FAnimSlotGroup>                      SlotGroups;                                               // 0x0258(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      UnknownData04[0x128];                                     // 0x0268(0x0128) MISSED OFFSET
	TArray<class UAssetUserData*>                      AssetUserData;                                            // 0x0390(0x0010) (CPF_Edit, CPF_ExportObject, CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Skeleton");
		return ptr;
	}

};


// Class Engine.BlendProfile
// 0x0020 (0x0048 - 0x0028)
class UBlendProfile : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET
	class USkeleton*                                   OwningSkeleton;                                           // 0x0030(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<struct FBlendProfileBoneEntry>              ProfileEntries;                                           // 0x0038(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BlendProfile");
		return ptr;
	}

};


// Class Engine.BlockingVolume
// 0x0000 (0x0350 - 0x0350)
class ABlockingVolume : public AVolume
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BlockingVolume");
		return ptr;
	}

};


// Class Engine.BlueprintMapLibrary
// 0x0000 (0x0028 - 0x0028)
class UBlueprintMapLibrary : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BlueprintMapLibrary");
		return ptr;
	}


	static void SetMapPropertyByName(class UObject* Object, const struct FName& PropertyName, TMap<int, int> Value);
	static void Map_Values(TMap<int, int> TargetMap, TArray<int>* Values);
	static bool Map_Remove(TMap<int, int> TargetMap, int Key);
	static int Map_Length(TMap<int, int> TargetMap);
	static void Map_Keys(TMap<int, int> TargetMap, TArray<int>* Keys);
	static bool Map_Find(TMap<int, int> TargetMap, int Key, int* Value);
	static bool Map_Contains(TMap<int, int> TargetMap, int Key);
	static void Map_Clear(TMap<int, int> TargetMap);
	static void Map_Add(TMap<int, int> TargetMap, int Key, int Value);
};


// Class Engine.PlatformGameInstance
// 0x00B0 (0x01A0 - 0x00F0)
class UPlatformGameInstance : public UGameInstance
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x00F0(0x0008) MISSED OFFSET
	struct FScriptMulticastDelegate                    ApplicationHasReactivatedDelegate;                        // 0x00F8(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    ApplicationWillEnterBackgroundDelegate;                   // 0x0108(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    ApplicationHasEnteredForegroundDelegate;                  // 0x0118(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    ApplicationWillTerminateDelegate;                         // 0x0128(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    ApplicationRegisteredForRemoteNotificationsDelegate;      // 0x0138(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    ApplicationRegisteredForUserNotificationsDelegate;        // 0x0148(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    ApplicationFailedToRegisterForRemoteNotificationsDelegate;// 0x0158(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    ApplicationReceivedRemoteNotificationDelegate;            // 0x0168(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    ApplicationReceivedLocalNotificationDelegate;             // 0x0178(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    ApplicationReceivedScreenOrientationChangedNotificationDelegate;// 0x0188(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	unsigned char                                      UnknownData01[0x8];                                       // 0x0198(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.PlatformGameInstance");
		return ptr;
	}

};


// Class Engine.BlueprintPlatformLibrary
// 0x0000 (0x0028 - 0x0028)
class UBlueprintPlatformLibrary : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BlueprintPlatformLibrary");
		return ptr;
	}


	static void ScheduleLocalNotificationFromNow(int inSecondsFromNow, const struct FText& Title, const struct FText& Body, const struct FText& action, const struct FString& ActivationEvent);
	static void ScheduleLocalNotificationBadgeFromNow(int inSecondsFromNow, const struct FString& ActivationEvent);
	static void ScheduleLocalNotificationBadgeAtTime(const struct FDateTime& FireDateTime, bool LocalTime, const struct FString& ActivationEvent);
	static void ScheduleLocalNotificationAtTime(const struct FDateTime& FireDateTime, bool LocalTime, const struct FText& Title, const struct FText& Body, const struct FText& action, const struct FString& ActivationEvent);
	static void GetLaunchNotification(bool* NotificationLaunchedApp, struct FString* ActivationEvent, int* FireDate);
	static void ClearAllLocalNotifications();
	static void CancelLocalNotification(const struct FString& ActivationEvent);
};


// Class Engine.BlueprintSetLibrary
// 0x0000 (0x0028 - 0x0028)
class UBlueprintSetLibrary : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BlueprintSetLibrary");
		return ptr;
	}


	static void SetSetPropertyByName(class UObject* Object, const struct FName& PropertyName);
	static void Set_Union();
	static void Set_ToArray(TArray<int>* Result);
	static void Set_RemoveItems(TArray<int> Items);
	static bool Set_Remove(int Item);
	static int Set_Length();
	static void Set_Intersection();
	static void Set_Difference();
	static bool Set_Contains(int ItemToFind);
	static void Set_Clear();
	static void Set_AddItems(TArray<int> NewItems);
	static void Set_Add(int NewItem);
};


// Class Engine.BodySetup
// 0x02F8 (0x0320 - 0x0028)
class UBodySetup : public UObject
{
public:
	struct FKAggregateGeom                             AggGeom;                                                  // 0x0028(0x0048) (CPF_Edit)
	struct FName                                       BoneName;                                                 // 0x0070(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)
	TEnumAsByte<EPhysicsType>                          PhysicsType;                                              // 0x0078(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bAlwaysFullAnimWeight : 1;                                // 0x0079(0x0001) (CPF_Deprecated)
	unsigned char                                      bConsiderForBounds : 1;                                   // 0x0079(0x0001) (CPF_Edit)
	unsigned char                                      bMeshCollideAll : 1;                                      // 0x0079(0x0001) (CPF_Transient)
	unsigned char                                      bDoubleSidedGeometry : 1;                                 // 0x0079(0x0001) (CPF_Edit)
	unsigned char                                      bGenerateNonMirroredCollision : 1;                        // 0x0079(0x0001)
	unsigned char                                      bSharedCookedData : 1;                                    // 0x0079(0x0001)
	unsigned char                                      bGenerateMirroredCollision : 1;                           // 0x0079(0x0001)
	unsigned char                                      UnknownData00[0x1];                                       // 0x007A(0x0001) MISSED OFFSET
	TEnumAsByte<EBodyCollisionResponse>                CollisionReponse;                                         // 0x007B(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ECollisionTraceFlag>                   CollisionTraceFlag;                                       // 0x007C(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x3];                                       // 0x007D(0x0003) MISSED OFFSET
	class UPhysicalMaterial*                           PhysMaterial;                                             // 0x0080(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FWalkableSlopeOverride                      WalkableSlopeOverride;                                    // 0x0088(0x0010) (CPF_Edit, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x68];                                      // 0x0098(0x0068) MISSED OFFSET
	struct FBodyInstance                               DefaultInstance;                                          // 0x0100(0x0200) (CPF_Edit)
	unsigned char                                      UnknownData03[0x8];                                       // 0x0300(0x0008) MISSED OFFSET
	struct FVector                                     BuildScale3D;                                             // 0x0308(0x000C) (CPF_IsPlainOldData)
	unsigned char                                      UnknownData04[0xC];                                       // 0x0314(0x000C) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BodySetup");
		return ptr;
	}

};


// Class Engine.BoneMaskFilter
// 0x0010 (0x0038 - 0x0028)
class UBoneMaskFilter : public UObject
{
public:
	TArray<struct FInputBlendPose>                     BlendPoses;                                               // 0x0028(0x0010) (CPF_Edit, CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BoneMaskFilter");
		return ptr;
	}

};


// Class Engine.BookMark
// 0x0028 (0x0050 - 0x0028)
class UBookMark : public UObject
{
public:
	struct FVector                                     Location;                                                 // 0x0028(0x000C) (CPF_Edit, CPF_IsPlainOldData)
	struct FRotator                                    Rotation;                                                 // 0x0034(0x000C) (CPF_Edit, CPF_IsPlainOldData)
	TArray<struct FString>                             HiddenLevels;                                             // 0x0040(0x0010) (CPF_Edit, CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BookMark");
		return ptr;
	}

};


// Class Engine.BookMark2D
// 0x0010 (0x0038 - 0x0028)
class UBookMark2D : public UObject
{
public:
	float                                              Zoom2D;                                                   // 0x0028(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FIntPoint                                   Location;                                                 // 0x002C(0x0008) (CPF_Edit, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x0034(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BookMark2D");
		return ptr;
	}

};


// Class Engine.BoxComponent
// 0x0010 (0x0690 - 0x0680)
class UBoxComponent : public UShapeComponent
{
public:
	struct FVector                                     BoxExtent;                                                // 0x0680(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x068C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BoxComponent");
		return ptr;
	}


	void SetBoxExtent(const struct FVector& InBoxExtent, bool bUpdateOverlaps);
	struct FVector GetUnscaledBoxExtent();
	struct FVector GetScaledBoxExtent();
};


// Class Engine.ReflectionCapture
// 0x0008 (0x0320 - 0x0318)
class AReflectionCapture : public AActor
{
public:
	class UReflectionCaptureComponent*                 CaptureComponent;                                         // 0x0318(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ReflectionCapture");
		return ptr;
	}

};


// Class Engine.BoxReflectionCapture
// 0x0000 (0x0320 - 0x0320)
class ABoxReflectionCapture : public AReflectionCapture
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BoxReflectionCapture");
		return ptr;
	}

};


// Class Engine.ReflectionCaptureComponent
// 0x0070 (0x0300 - 0x0290)
class UReflectionCaptureComponent : public USceneComponent
{
public:
	class UBillboardComponent*                         CaptureOffsetComponent;                                   // 0x0290(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	EReflectionSourceType                              ReflectionSourceType;                                     // 0x0298(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0299(0x0007) MISSED OFFSET
	class UTextureCube*                                Cubemap;                                                  // 0x02A0(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              SourceCubemapAngle;                                       // 0x02A8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              Brightness;                                               // 0x02AC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FVector                                     CaptureOffset;                                            // 0x02B0(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_IsPlainOldData)
	struct FGuid                                       MapBuildDataId;                                           // 0x02BC(0x0010) (CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x34];                                      // 0x02CC(0x0034) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ReflectionCaptureComponent");
		return ptr;
	}

};


// Class Engine.BoxReflectionCaptureComponent
// 0x0020 (0x0320 - 0x0300)
class UBoxReflectionCaptureComponent : public UReflectionCaptureComponent
{
public:
	float                                              BoxTransitionDistance;                                    // 0x0300(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x0304(0x0004) MISSED OFFSET
	class UBoxComponent*                               PreviewInfluenceBox;                                      // 0x0308(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	class UBoxComponent*                               PreviewCaptureBox;                                        // 0x0310(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x8];                                       // 0x0318(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BoxReflectionCaptureComponent");
		return ptr;
	}

};


// Class Engine.Breakpoint
// 0x0018 (0x0040 - 0x0028)
class UBreakpoint : public UObject
{
public:
	unsigned char                                      bEnabled : 1;                                             // 0x0028(0x0001) (CPF_Transient)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0029(0x0007) MISSED OFFSET
	class UEdGraphNode*                                Node;                                                     // 0x0030(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bStepOnce : 1;                                            // 0x0038(0x0001)
	unsigned char                                      bStepOnce_WasPreviouslyDisabled : 1;                      // 0x0038(0x0001)
	unsigned char                                      bStepOnce_RemoveAfterHit : 1;                             // 0x0038(0x0001)
	unsigned char                                      UnknownData01[0x7];                                       // 0x0039(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Breakpoint");
		return ptr;
	}

};


// Class Engine.BrushBuilder
// 0x0058 (0x0080 - 0x0028)
class UBrushBuilder : public UObject
{
public:
	struct FString                                     BitmapFilename;                                           // 0x0028(0x0010) (CPF_ZeroConstructor)
	struct FString                                     ToolTip;                                                  // 0x0038(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      NotifyBadParams : 1;                                      // 0x0048(0x0001) (CPF_Transient)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0049(0x0007) MISSED OFFSET
	TArray<struct FVector>                             Vertices;                                                 // 0x0050(0x0010) (CPF_ZeroConstructor)
	TArray<struct FBuilderPoly>                        Polys;                                                    // 0x0060(0x0010) (CPF_ZeroConstructor)
	struct FName                                       Layer;                                                    // 0x0070(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      MergeCoplanars : 1;                                       // 0x0078(0x0001)
	unsigned char                                      UnknownData01[0x7];                                       // 0x0079(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BrushBuilder");
		return ptr;
	}

};


// Class Engine.BrushComponent
// 0x0020 (0x0680 - 0x0660)
class UBrushComponent : public UPrimitiveComponent
{
public:
	class UModel*                                      Brush;                                                    // 0x0660(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UBodySetup*                                  BrushBodySetup;                                           // 0x0668(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FVector                                     PrePivot;                                                 // 0x0670(0x000C) (CPF_Deprecated, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x067C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BrushComponent");
		return ptr;
	}

};


// Class Engine.BrushShape
// 0x0000 (0x0350 - 0x0350)
class ABrushShape : public ABrush
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.BrushShape");
		return ptr;
	}

};


// Class Engine.ButtonStyleAsset
// 0x0238 (0x0260 - 0x0028)
class UButtonStyleAsset : public UObject
{
public:
	struct FButtonStyle                                ButtonStyle;                                              // 0x0028(0x0238) (CPF_Edit)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ButtonStyleAsset");
		return ptr;
	}

};


// Class Engine.CameraAnim
// 0x0568 (0x0590 - 0x0028)
class UCameraAnim : public UObject
{
public:
	class UInterpGroup*                                CameraInterpGroup;                                        // 0x0028(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              AnimLength;                                               // 0x0030(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FBox                                        BoundingBox;                                              // 0x0034(0x001C) (CPF_IsPlainOldData)
	unsigned char                                      bRelativeToInitialTransform : 1;                          // 0x0050(0x0001) (CPF_Edit, CPF_DisableEditOnInstance)
	unsigned char                                      bRelativeToInitialFOV : 1;                                // 0x0050(0x0001) (CPF_Edit, CPF_DisableEditOnInstance)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0051(0x0003) MISSED OFFSET
	float                                              BaseFOV;                                                  // 0x0054(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x8];                                       // 0x0058(0x0008) MISSED OFFSET
	struct FPostProcessSettings                        BasePostProcessSettings;                                  // 0x0060(0x0520)
	float                                              BasePostProcessBlendWeight;                               // 0x0580(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0xC];                                       // 0x0584(0x000C) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CameraAnim");
		return ptr;
	}

};


// Class Engine.CameraAnimInst
// 0x00E8 (0x0110 - 0x0028)
class UCameraAnimInst : public UObject
{
public:
	class UCameraAnim*                                 CamAnim;                                                  // 0x0028(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UInterpGroupInst*                            InterpGroupInst;                                          // 0x0030(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x18];                                      // 0x0038(0x0018) MISSED OFFSET
	float                                              PlayRate;                                                 // 0x0050(0x0004) (CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x14];                                      // 0x0054(0x0014) MISSED OFFSET
	class UInterpTrackMove*                            MoveTrack;                                                // 0x0068(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class UInterpTrackInstMove*                        MoveInst;                                                 // 0x0070(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	TEnumAsByte<ECameraAnimPlaySpace>                  PlaySpace;                                                // 0x0078(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x97];                                      // 0x0079(0x0097) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CameraAnimInst");
		return ptr;
	}


	void Stop(bool bImmediate);
	void SetScale(float NewDuration);
	void SetDuration(float NewDuration);
};


// Class Engine.CameraBlockingVolume
// 0x0000 (0x0350 - 0x0350)
class ACameraBlockingVolume : public AVolume
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CameraBlockingVolume");
		return ptr;
	}

};


// Class Engine.CameraModifier
// 0x0020 (0x0048 - 0x0028)
class UCameraModifier : public UObject
{
public:
	unsigned char                                      bDebug : 1;                                               // 0x0028(0x0001) (CPF_Edit)
	unsigned char                                      bExclusive : 1;                                           // 0x0028(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_DisableEditOnInstance)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0029(0x0003) MISSED OFFSET
	unsigned char                                      Priority;                                                 // 0x002C(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x3];                                       // 0x002D(0x0003) MISSED OFFSET
	class APlayerCameraManager*                        CameraOwner;                                              // 0x0030(0x0008) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              AlphaInTime;                                              // 0x0038(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	float                                              AlphaOutTime;                                             // 0x003C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	float                                              Alpha;                                                    // 0x0040(0x0004) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x4];                                       // 0x0044(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CameraModifier");
		return ptr;
	}


	bool IsDisabled();
	class AActor* GetViewTarget();
	void EnableModifier();
	void DisableModifier(bool bImmediate);
	void BlueprintModifyPostProcess(float DeltaTime, float* PostProcessBlendWeight, struct FPostProcessSettings* PostProcessSettings);
	void BlueprintModifyCamera(float DeltaTime, const struct FVector& ViewLocation, const struct FRotator& ViewRotation, float FOV, struct FVector* NewViewLocation, struct FRotator* NewViewRotation, float* NewFOV);
};


// Class Engine.CameraModifier_CameraShake
// 0x0018 (0x0060 - 0x0048)
class UCameraModifier_CameraShake : public UCameraModifier
{
public:
	TArray<class UCameraShake*>                        ActiveShakes;                                             // 0x0048(0x0010) (CPF_ZeroConstructor)
	float                                              SplitScreenShakeScale;                                    // 0x0058(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x005C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CameraModifier_CameraShake");
		return ptr;
	}

};


// Class Engine.CameraShake
// 0x0138 (0x0160 - 0x0028)
class UCameraShake : public UObject
{
public:
	unsigned char                                      bSingleInstance : 1;                                      // 0x0028(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0029(0x0003) MISSED OFFSET
	float                                              OscillationDuration;                                      // 0x002C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              OscillationBlendInTime;                                   // 0x0030(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              OscillationBlendOutTime;                                  // 0x0034(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FROscillator                                RotOscillation;                                           // 0x0038(0x0024) (CPF_Edit)
	struct FVOscillator                                LocOscillation;                                           // 0x005C(0x0024) (CPF_Edit)
	struct FFOscillator                                FOVOscillation;                                           // 0x0080(0x000C) (CPF_Edit)
	float                                              AnimPlayRate;                                             // 0x008C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              AnimScale;                                                // 0x0090(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              AnimBlendInTime;                                          // 0x0094(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              AnimBlendOutTime;                                         // 0x0098(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              RandomAnimSegmentDuration;                                // 0x009C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UCameraAnim*                                 Anim;                                                     // 0x00A0(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bRandomAnimSegment : 1;                                   // 0x00A8(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData01[0x17];                                      // 0x00A9(0x0017) MISSED OFFSET
	class APlayerCameraManager*                        CameraOwner;                                              // 0x00C0(0x0008) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x80];                                      // 0x00C8(0x0080) MISSED OFFSET
	float                                              ShakeScale;                                               // 0x0148(0x0004) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              OscillatorTimeRemaining;                                  // 0x014C(0x0004) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class UCameraAnimInst*                             AnimInst;                                                 // 0x0150(0x0008) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0x8];                                       // 0x0158(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CameraShake");
		return ptr;
	}


	void ReceiveStopShake(bool bImmediately);
	void ReceivePlayShake(float Scale);
	bool ReceiveIsFinished();
	void BlueprintUpdateCameraShake(float DeltaTime, float Alpha, const struct FMinimalViewInfo& POV, struct FMinimalViewInfo* ModifiedPOV);
};


// Class Engine.Canvas
// 0x02A8 (0x02D0 - 0x0028)
class UCanvas : public UObject
{
public:
	float                                              OrgX;                                                     // 0x0028(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              OrgY;                                                     // 0x002C(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ClipX;                                                    // 0x0030(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ClipY;                                                    // 0x0034(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FColor                                      DrawColor;                                                // 0x0038(0x0004) (CPF_IsPlainOldData)
	unsigned char                                      bCenterX : 1;                                             // 0x003C(0x0001)
	unsigned char                                      bCenterY : 1;                                             // 0x003C(0x0001)
	unsigned char                                      bNoSmooth : 1;                                            // 0x003C(0x0001)
	unsigned char                                      UnknownData00[0x3];                                       // 0x003D(0x0003) MISSED OFFSET
	int                                                SizeX;                                                    // 0x0040(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                SizeY;                                                    // 0x0044(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x8];                                       // 0x0048(0x0008) MISSED OFFSET
	struct FPlane                                      ColorModulate;                                            // 0x0050(0x0010) (CPF_IsPlainOldData)
	class UTexture2D*                                  DefaultTexture;                                           // 0x0060(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UTexture2D*                                  GradientTexture0;                                         // 0x0068(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UReporterGraph*                              ReporterGraph;                                            // 0x0070(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x258];                                     // 0x0078(0x0258) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Canvas");
		return ptr;
	}


	struct FVector2D K2_TextSize(class UFont* RenderFont, const struct FString& RenderText, const struct FVector2D& Scale);
	struct FVector2D K2_StrLen(class UFont* RenderFont, const struct FString& RenderText);
	struct FVector K2_Project(const struct FVector& WorldLocation);
	void K2_DrawTriangle(class UTexture* RenderTexture, TArray<struct FCanvasUVTri> Triangles);
	void K2_DrawTexture(class UTexture* RenderTexture, const struct FVector2D& ScreenPosition, const struct FVector2D& ScreenSize, const struct FVector2D& CoordinatePosition, const struct FVector2D& CoordinateSize, const struct FLinearColor& RenderColor, TEnumAsByte<EBlendMode> BlendMode, float Rotation, const struct FVector2D& PivotPoint);
	void K2_DrawText(class UFont* RenderFont, const struct FString& RenderText, const struct FVector2D& ScreenPosition, const struct FLinearColor& RenderColor, float Kerning, const struct FLinearColor& ShadowColor, const struct FVector2D& ShadowOffset, bool bCentreX, bool bCentreY, bool bOutlined, const struct FLinearColor& OutlineColor);
	void K2_DrawPolygon(class UTexture* RenderTexture, const struct FVector2D& ScreenPosition, const struct FVector2D& Radius, int NumberOfSides, const struct FLinearColor& RenderColor);
	void K2_DrawMaterialTriangle(class UMaterialInterface* RenderMaterial, TArray<struct FCanvasUVTri> Triangles);
	void K2_DrawMaterial(class UMaterialInterface* RenderMaterial, const struct FVector2D& ScreenPosition, const struct FVector2D& ScreenSize, const struct FVector2D& CoordinatePosition, const struct FVector2D& CoordinateSize, float Rotation, const struct FVector2D& PivotPoint);
	void K2_DrawLine(const struct FVector2D& ScreenPositionA, const struct FVector2D& ScreenPositionB, float Thickness, const struct FLinearColor& RenderColor);
	void K2_DrawBox(const struct FVector2D& ScreenPosition, const struct FVector2D& ScreenSize, float Thickness);
	void K2_DrawBorder(class UTexture* BorderTexture, class UTexture* BackgroundTexture, class UTexture* LeftBorderTexture, class UTexture* RightBorderTexture, class UTexture* TopBorderTexture, class UTexture* BottomBorderTexture, const struct FVector2D& ScreenPosition, const struct FVector2D& ScreenSize, const struct FVector2D& CoordinatePosition, const struct FVector2D& CoordinateSize, const struct FLinearColor& RenderColor, const struct FVector2D& BorderScale, const struct FVector2D& BackgroundScale, float Rotation, const struct FVector2D& PivotPoint, const struct FVector2D& CornerSize);
	void K2_Deproject(const struct FVector2D& ScreenPosition, struct FVector* WorldOrigin, struct FVector* WorldDirection);
};


// Class Engine.Texture
// 0x0090 (0x00B8 - 0x0028)
class UTexture : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET
	struct FGuid                                       LightingGuid;                                             // 0x0030(0x0010) (CPF_IsPlainOldData)
	int                                                LODBias;                                                  // 0x0040(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                NumCinematicMipLevels;                                    // 0x0044(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ETextureCompressionSettings>           CompressionSettings;                                      // 0x0048(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ETextureFilter>                        Filter;                                                   // 0x0049(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ETextureGroup>                         LODGroup;                                                 // 0x004A(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      SRGB : 1;                                                 // 0x004B(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      NeverStream : 1;                                          // 0x004B(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bNoTiling : 1;                                            // 0x004B(0x0001)
	unsigned char                                      bUseCinematicMipLevels : 1;                               // 0x004B(0x0001) (CPF_Transient)
	unsigned char                                      bAsyncResourceReleaseHasBeenStarted : 1;                  // 0x004B(0x0001) (CPF_Transient)
	int                                                CachedCombinedLODBias;                                    // 0x004C(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	TArray<class UAssetUserData*>                      AssetUserData;                                            // 0x0050(0x0010) (CPF_Edit, CPF_ExportObject, CPF_ZeroConstructor)
	unsigned char                                      UnknownData01[0x58];                                      // 0x0060(0x0058) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Texture");
		return ptr;
	}

};


// Class Engine.TextureRenderTarget
// 0x0008 (0x00C0 - 0x00B8)
class UTextureRenderTarget : public UTexture
{
public:
	float                                              TargetGamma;                                              // 0x00B8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x00BC(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.TextureRenderTarget");
		return ptr;
	}

};


// Class Engine.TextureRenderTarget2D
// 0x0028 (0x00E8 - 0x00C0)
class UTextureRenderTarget2D : public UTextureRenderTarget
{
public:
	int                                                SizeX;                                                    // 0x00C0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                SizeY;                                                    // 0x00C4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FLinearColor                                ClearColor;                                               // 0x00C8(0x0010) (CPF_IsPlainOldData)
	TEnumAsByte<ETextureAddress>                       AddressX;                                                 // 0x00D8(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ETextureAddress>                       AddressY;                                                 // 0x00D9(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bForceLinearGamma : 1;                                    // 0x00DA(0x0001)
	unsigned char                                      bHDR : 1;                                                 // 0x00DA(0x0001) (CPF_Deprecated)
	unsigned char                                      bGPUSharedFlag : 1;                                       // 0x00DA(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bAutoGenerateMips : 1;                                    // 0x00DA(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	TEnumAsByte<ETextureRenderTargetFormat>            RenderTargetFormat;                                       // 0x00DB(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EPixelFormat>                          OverrideFormat;                                           // 0x00DC(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0xB];                                       // 0x00DD(0x000B) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.TextureRenderTarget2D");
		return ptr;
	}

};


// Class Engine.CanvasRenderTarget2D
// 0x0020 (0x0108 - 0x00E8)
class UCanvasRenderTarget2D : public UTextureRenderTarget2D
{
public:
	struct FScriptMulticastDelegate                    OnCanvasRenderTargetUpdate;                               // 0x00E8(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	TWeakObjectPtr<class UWorld>                       World;                                                    // 0x00F8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bShouldClearRenderTargetOnReceiveUpdate;                  // 0x0100(0x0001) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0101(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CanvasRenderTarget2D");
		return ptr;
	}


	void UpdateResource();
	void ReceiveUpdate(class UCanvas* Canvas, int Width, int Height);
	void GetSize(int* Width, int* Height);
	static class UCanvasRenderTarget2D* CreateCanvasRenderTarget2D(class UObject* WorldContextObject, class UClass* CanvasRenderTarget2DClass, int Width, int Height);
};


// Class Engine.CheatManager
// 0x0050 (0x0078 - 0x0028)
class UCheatManager : public UObject
{
public:
	class ADebugCameraController*                      DebugCameraControllerRef;                                 // 0x0028(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      DebugCameraControllerClass;                               // 0x0030(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x40];                                      // 0x0038(0x0040) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CheatManager");
		return ptr;
	}


	void Walk();
	void ViewSelf();
	void ViewPlayer(const struct FString& S);
	void ViewClass(class UClass* DesiredClass);
	void ViewActor(const struct FName& ActorName);
	void ToggleServerStatReplicatorUpdateStatNet();
	void ToggleServerStatReplicatorClientOverwrite();
	void ToggleDebugCamera();
	void ToggleAILogging();
	void TestCollisionDistance();
	void Teleport();
	void Summon(const struct FString& ClassName);
	void StreamLevelOut(const struct FName& PackageName);
	void StreamLevelIn(const struct FName& PackageName);
	void SpawnServerStatReplicator();
	void Slomo(float NewTimeDilation);
	void SetWorldOrigin();
	void SetNavDrawDistance(float DrawDistance);
	void SetMouseSensitivityToDefault();
	void ServerToggleAILogging();
	void ReceiveInitCheatManager();
	void ReceiveEndPlay();
	void RebuildNavigation();
	void PlayersOnly();
	void OnlyLoadLevel(const struct FName& PackageName);
	void LogLoc();
	void InvertMouse();
	void God();
	void Ghost();
	void FreezeFrame(float Delay);
	void Fly();
	void FlushLog();
	void EnableDebugCamera();
	void DumpVoiceMutingState();
	void DumpPartyState();
	void DumpOnlineSessionState();
	void DumpChatState();
	void DisableDebugCamera();
	void DestroyTarget();
	void DestroyServerStatReplicator();
	void DestroyPawns(class UClass* aClass);
	void DestroyAllPawnsExceptTarget();
	void DestroyAll(class UClass* aClass);
	void DebugCapsuleSweepSize(float HalfHeight, float Radius);
	void DebugCapsuleSweepPawn();
	void DebugCapsuleSweepComplex(bool bTraceComplex);
	void DebugCapsuleSweepClear();
	void DebugCapsuleSweepChannel(TEnumAsByte<ECollisionChannel> Channel);
	void DebugCapsuleSweepCapture();
	void DebugCapsuleSweep();
	void DamageTarget(float DamageAmount);
	void CheatScript(const struct FString& ScriptName);
	void ChangeSize(float F);
	void BugItStringCreator(const struct FVector& ViewLocation, const struct FRotator& ViewRotation, struct FString* GoString, struct FString* LocString);
	void BugItGo(float X, float Y, float Z, float Pitch, float Yaw, float Roll);
	void BugIt(const struct FString& ScreenShotDescription);
};


// Class Engine.CheckBoxStyleAsset
// 0x04F0 (0x0518 - 0x0028)
class UCheckBoxStyleAsset : public UObject
{
public:
	struct FCheckBoxStyle                              CheckBoxStyle;                                            // 0x0028(0x04F0) (CPF_Edit)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CheckBoxStyleAsset");
		return ptr;
	}

};


// Class Engine.ChildActorComponent
// 0x0030 (0x02C0 - 0x0290)
class UChildActorComponent : public USceneComponent
{
public:
	class UClass*                                      ChildActorClass;                                          // 0x0290(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class AActor*                                      ChildActor;                                               // 0x0298(0x0008) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class AActor*                                      ChildActorTemplate;                                       // 0x02A0(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_EditConst, CPF_DuplicateTransient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x18];                                      // 0x02A8(0x0018) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ChildActorComponent");
		return ptr;
	}


	void SetChildActorClass(class UClass* InClass);
};


// Class Engine.Player
// 0x0020 (0x0048 - 0x0028)
class UPlayer : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET
	class APlayerController*                           PlayerController;                                         // 0x0030(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	int                                                CurrentNetSpeed;                                          // 0x0038(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                ConfiguredInternetSpeed;                                  // 0x003C(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	int                                                ConfiguredLanSpeed;                                       // 0x0040(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x0044(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Player");
		return ptr;
	}

};


// Class Engine.NetConnection
// 0x33768 (0x337B0 - 0x0048)
class UNetConnection : public UPlayer
{
public:
	TArray<class UChildConnection*>                    Children;                                                 // 0x0048(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	class UNetDriver*                                  Driver;                                                   // 0x0058(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      PackageMapClass;                                          // 0x0060(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UPackageMap*                                 PackageMap;                                               // 0x0068(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<class UChannel*>                            OpenChannels;                                             // 0x0070(0x0010) (CPF_ZeroConstructor)
	TArray<class AActor*>                              SentTemporaries;                                          // 0x0080(0x0010) (CPF_ZeroConstructor)
	class AActor*                                      ViewTarget;                                               // 0x0090(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class AActor*                                      OwningActor;                                              // 0x0098(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                MaxPacket;                                                // 0x00A0(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      InternalAck : 1;                                          // 0x00A4(0x0001)
	unsigned char                                      UnknownData00[0xB3];                                      // 0x00A5(0x00B3) MISSED OFFSET
	struct FUniqueNetIdRepl                            PlayerId;                                                 // 0x0158(0x0018)
	unsigned char                                      UnknownData01[0x68];                                      // 0x0170(0x0068) MISSED OFFSET
	double                                             LastReceiveTime;                                          // 0x01D8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x33530];                                   // 0x01E0(0x33530) MISSED OFFSET
	TArray<class UChannel*>                            ChannelsToTick;                                           // 0x33710(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      UnknownData03[0x90];                                      // 0x33720(0x0090) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NetConnection");
		return ptr;
	}

};


// Class Engine.ChildConnection
// 0x0008 (0x337B8 - 0x337B0)
class UChildConnection : public UNetConnection
{
public:
	class UNetConnection*                              Parent;                                                   // 0x337B0(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ChildConnection");
		return ptr;
	}

};


// Class Engine.PlatformInterfaceBase
// 0x0010 (0x0038 - 0x0028)
class UPlatformInterfaceBase : public UObject
{
public:
	TArray<struct FDelegateArray>                      AllDelegates;                                             // 0x0028(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.PlatformInterfaceBase");
		return ptr;
	}

};


// Class Engine.CloudStorageBase
// 0x0018 (0x0050 - 0x0038)
class UCloudStorageBase : public UPlatformInterfaceBase
{
public:
	TArray<struct FString>                             LocalCloudFiles;                                          // 0x0038(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      bSuppressDelegateCalls : 1;                               // 0x0048(0x0001)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0049(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CloudStorageBase");
		return ptr;
	}

};


// Class Engine.CollisionProfile
// 0x0120 (0x0158 - 0x0038)
class UCollisionProfile : public UDeveloperSettings
{
public:
	TArray<struct FCollisionResponseTemplate>          Profiles;                                                 // 0x0038(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	TArray<struct FCustomChannelSetup>                 DefaultChannelResponses;                                  // 0x0048(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	TArray<struct FCustomProfile>                      EditProfiles;                                             // 0x0058(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	TArray<struct FRedirector>                         ProfileRedirects;                                         // 0x0068(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	TArray<struct FRedirector>                         CollisionChannelRedirects;                                // 0x0078(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	unsigned char                                      UnknownData00[0xD0];                                      // 0x0088(0x00D0) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CollisionProfile");
		return ptr;
	}

};


// Class Engine.Commandlet
// 0x0058 (0x0080 - 0x0028)
class UCommandlet : public UObject
{
public:
	struct FString                                     HelpDescription;                                          // 0x0028(0x0010) (CPF_ZeroConstructor)
	struct FString                                     HelpUsage;                                                // 0x0038(0x0010) (CPF_ZeroConstructor)
	struct FString                                     HelpWebLink;                                              // 0x0048(0x0010) (CPF_ZeroConstructor)
	TArray<struct FString>                             HelpParamNames;                                           // 0x0058(0x0010) (CPF_ZeroConstructor)
	TArray<struct FString>                             HelpParamDescriptions;                                    // 0x0068(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      IsServer : 1;                                             // 0x0078(0x0001)
	unsigned char                                      IsClient : 1;                                             // 0x0078(0x0001)
	unsigned char                                      IsEditor : 1;                                             // 0x0078(0x0001)
	unsigned char                                      LogToConsole : 1;                                         // 0x0078(0x0001)
	unsigned char                                      ShowErrorCount : 1;                                       // 0x0078(0x0001)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0079(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Commandlet");
		return ptr;
	}

};


// Class Engine.DynamicBlueprintBinding
// 0x0000 (0x0028 - 0x0028)
class UDynamicBlueprintBinding : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DynamicBlueprintBinding");
		return ptr;
	}

};


// Class Engine.ComponentDelegateBinding
// 0x0010 (0x0038 - 0x0028)
class UComponentDelegateBinding : public UDynamicBlueprintBinding
{
public:
	TArray<struct FBlueprintComponentDelegateBinding>  ComponentDelegateBindings;                                // 0x0028(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ComponentDelegateBinding");
		return ptr;
	}

};


// Class Engine.Engine
// 0x0DE8 (0x0E10 - 0x0028)
class UEngine : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET
	class UFont*                                       TinyFont;                                                 // 0x0030(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             TinyFontName;                                             // 0x0038(0x0018) (CPF_Edit, CPF_Config, CPF_GlobalConfig)
	class UFont*                                       SmallFont;                                                // 0x0050(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             SmallFontName;                                            // 0x0058(0x0018) (CPF_Edit, CPF_Config, CPF_GlobalConfig)
	class UFont*                                       MediumFont;                                               // 0x0070(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             MediumFontName;                                           // 0x0078(0x0018) (CPF_Edit, CPF_Config, CPF_GlobalConfig)
	class UFont*                                       LargeFont;                                                // 0x0090(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             LargeFontName;                                            // 0x0098(0x0018) (CPF_Edit, CPF_Config, CPF_GlobalConfig)
	class UFont*                                       SubtitleFont;                                             // 0x00B0(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             SubtitleFontName;                                         // 0x00B8(0x0018) (CPF_Edit, CPF_Config, CPF_GlobalConfig)
	TArray<class UFont*>                               AdditionalFonts;                                          // 0x00D0(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      UnknownData01[0x8];                                       // 0x00E0(0x0008) MISSED OFFSET
	TArray<struct FString>                             AdditionalFontNames;                                      // 0x00E8(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	class UClass*                                      ConsoleClass;                                             // 0x00F8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftClassPath                              ConsoleClassName;                                         // 0x0100(0x0018) (CPF_Edit, CPF_Config, CPF_GlobalConfig, CPF_NoClear)
	class UClass*                                      GameViewportClientClass;                                  // 0x0118(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftClassPath                              GameViewportClientClassName;                              // 0x0120(0x0018) (CPF_Edit, CPF_Config, CPF_GlobalConfig, CPF_NoClear)
	class UClass*                                      LocalPlayerClass;                                         // 0x0138(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftClassPath                              LocalPlayerClassName;                                     // 0x0140(0x0018) (CPF_Edit, CPF_Config, CPF_GlobalConfig, CPF_NoClear)
	class UClass*                                      WorldSettingsClass;                                       // 0x0158(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftClassPath                              WorldSettingsClassName;                                   // 0x0160(0x0018) (CPF_Edit, CPF_Config, CPF_GlobalConfig, CPF_NoClear)
	struct FSoftClassPath                              NavigationSystemClassName;                                // 0x0178(0x0018) (CPF_Config, CPF_GlobalConfig, CPF_NoClear)
	class UClass*                                      NavigationSystemClass;                                    // 0x0190(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftClassPath                              AvoidanceManagerClassName;                                // 0x0198(0x0018) (CPF_Config, CPF_GlobalConfig, CPF_NoClear)
	class UClass*                                      AvoidanceManagerClass;                                    // 0x01B0(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      PhysicsCollisionHandlerClass;                             // 0x01B8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftClassPath                              PhysicsCollisionHandlerClassName;                         // 0x01C0(0x0018) (CPF_Edit, CPF_Config, CPF_GlobalConfig, CPF_NoClear)
	struct FSoftClassPath                              GameUserSettingsClassName;                                // 0x01D8(0x0018) (CPF_Config, CPF_GlobalConfig, CPF_NoClear)
	class UClass*                                      GameUserSettingsClass;                                    // 0x01F0(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftClassPath                              AIControllerClassName;                                    // 0x01F8(0x0018) (CPF_Config, CPF_GlobalConfig, CPF_NoClear)
	class UGameUserSettings*                           GameUserSettings;                                         // 0x0210(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      LevelScriptActorClass;                                    // 0x0218(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftClassPath                              LevelScriptActorClassName;                                // 0x0220(0x0018) (CPF_Edit, CPF_Config, CPF_GlobalConfig, CPF_NoClear)
	struct FSoftClassPath                              DefaultBlueprintBaseClassName;                            // 0x0238(0x0018) (CPF_Edit, CPF_Config, CPF_GlobalConfig, CPF_NoClear)
	struct FSoftClassPath                              GameSingletonClassName;                                   // 0x0250(0x0018) (CPF_Edit, CPF_Config, CPF_GlobalConfig, CPF_NoClear)
	class UObject*                                     GameSingleton;                                            // 0x0268(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftClassPath                              AssetManagerClassName;                                    // 0x0270(0x0018) (CPF_Edit, CPF_Config, CPF_GlobalConfig, CPF_NoClear)
	class UAssetManager*                               AssetManager;                                             // 0x0288(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UTexture2D*                                  DefaultTexture;                                           // 0x0290(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             DefaultTextureName;                                       // 0x0298(0x0018) (CPF_Config, CPF_GlobalConfig)
	class UTexture*                                    DefaultDiffuseTexture;                                    // 0x02B0(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             DefaultDiffuseTextureName;                                // 0x02B8(0x0018) (CPF_Config, CPF_GlobalConfig)
	class UTexture2D*                                  DefaultBSPVertexTexture;                                  // 0x02D0(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             DefaultBSPVertexTextureName;                              // 0x02D8(0x0018) (CPF_Config, CPF_GlobalConfig)
	class UTexture2D*                                  HighFrequencyNoiseTexture;                                // 0x02F0(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             HighFrequencyNoiseTextureName;                            // 0x02F8(0x0018) (CPF_Config, CPF_GlobalConfig)
	class UTexture2D*                                  DefaultBokehTexture;                                      // 0x0310(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             DefaultBokehTextureName;                                  // 0x0318(0x0018) (CPF_Config, CPF_GlobalConfig)
	class UTexture2D*                                  DefaultBloomKernelTexture;                                // 0x0330(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             DefaultBloomKernelTextureName;                            // 0x0338(0x0018) (CPF_Config, CPF_GlobalConfig)
	class UMaterial*                                   WireframeMaterial;                                        // 0x0350(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FString                                     WireframeMaterialName;                                    // 0x0358(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	class UMaterial*                                   DebugMeshMaterial;                                        // 0x0368(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             DebugMeshMaterialName;                                    // 0x0370(0x0018) (CPF_Config, CPF_GlobalConfig)
	class UMaterial*                                   LevelColorationLitMaterial;                               // 0x0388(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FString                                     LevelColorationLitMaterialName;                           // 0x0390(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	class UMaterial*                                   LevelColorationUnlitMaterial;                             // 0x03A0(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FString                                     LevelColorationUnlitMaterialName;                         // 0x03A8(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	class UMaterial*                                   LightingTexelDensityMaterial;                             // 0x03B8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FString                                     LightingTexelDensityName;                                 // 0x03C0(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	class UMaterial*                                   ShadedLevelColorationLitMaterial;                         // 0x03D0(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FString                                     ShadedLevelColorationLitMaterialName;                     // 0x03D8(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	class UMaterial*                                   ShadedLevelColorationUnlitMaterial;                       // 0x03E8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FString                                     ShadedLevelColorationUnlitMaterialName;                   // 0x03F0(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	class UMaterial*                                   RemoveSurfaceMaterial;                                    // 0x0400(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             RemoveSurfaceMaterialName;                                // 0x0408(0x0018) (CPF_Config, CPF_GlobalConfig)
	class UMaterial*                                   VertexColorMaterial;                                      // 0x0420(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FString                                     VertexColorMaterialName;                                  // 0x0428(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	class UMaterial*                                   VertexColorViewModeMaterial_ColorOnly;                    // 0x0438(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FString                                     VertexColorViewModeMaterialName_ColorOnly;                // 0x0440(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	class UMaterial*                                   VertexColorViewModeMaterial_AlphaAsColor;                 // 0x0450(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FString                                     VertexColorViewModeMaterialName_AlphaAsColor;             // 0x0458(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	class UMaterial*                                   VertexColorViewModeMaterial_RedOnly;                      // 0x0468(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FString                                     VertexColorViewModeMaterialName_RedOnly;                  // 0x0470(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	class UMaterial*                                   VertexColorViewModeMaterial_GreenOnly;                    // 0x0480(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FString                                     VertexColorViewModeMaterialName_GreenOnly;                // 0x0488(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	class UMaterial*                                   VertexColorViewModeMaterial_BlueOnly;                     // 0x0498(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FString                                     VertexColorViewModeMaterialName_BlueOnly;                 // 0x04A0(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	struct FSoftObjectPath                             DebugEditorMaterialName;                                  // 0x04B0(0x0018) (CPF_Config, CPF_GlobalConfig)
	class UMaterial*                                   ConstraintLimitMaterial;                                  // 0x04C8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UMaterialInstanceDynamic*                    ConstraintLimitMaterialX;                                 // 0x04D0(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UMaterialInstanceDynamic*                    ConstraintLimitMaterialXAxis;                             // 0x04D8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UMaterialInstanceDynamic*                    ConstraintLimitMaterialY;                                 // 0x04E0(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UMaterialInstanceDynamic*                    ConstraintLimitMaterialYAxis;                             // 0x04E8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UMaterialInstanceDynamic*                    ConstraintLimitMaterialZ;                                 // 0x04F0(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UMaterialInstanceDynamic*                    ConstraintLimitMaterialZAxis;                             // 0x04F8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UMaterialInstanceDynamic*                    ConstraintLimitMaterialPrismatic;                         // 0x0500(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UMaterial*                                   InvalidLightmapSettingsMaterial;                          // 0x0508(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             InvalidLightmapSettingsMaterialName;                      // 0x0510(0x0018) (CPF_Config, CPF_GlobalConfig)
	class UMaterial*                                   PreviewShadowsIndicatorMaterial;                          // 0x0528(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             PreviewShadowsIndicatorMaterialName;                      // 0x0530(0x0018) (CPF_Edit, CPF_Config, CPF_GlobalConfig)
	class UMaterial*                                   ArrowMaterial;                                            // 0x0548(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             ArrowMaterialName;                                        // 0x0550(0x0018) (CPF_Config, CPF_GlobalConfig)
	struct FLinearColor                                LightingOnlyBrightness;                                   // 0x0568(0x0010) (CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	TArray<struct FLinearColor>                        ShaderComplexityColors;                                   // 0x0578(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	TArray<struct FLinearColor>                        QuadComplexityColors;                                     // 0x0588(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	TArray<struct FLinearColor>                        LightComplexityColors;                                    // 0x0598(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	TArray<struct FLinearColor>                        StationaryLightOverlapColors;                             // 0x05A8(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	TArray<struct FLinearColor>                        LODColorationColors;                                      // 0x05B8(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	TArray<struct FLinearColor>                        HLODColorationColors;                                     // 0x05C8(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	TArray<struct FLinearColor>                        StreamingAccuracyColors;                                  // 0x05D8(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	float                                              MaxPixelShaderAdditiveComplexityCount;                    // 0x05E8(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	float                                              MaxES2PixelShaderAdditiveComplexityCount;                 // 0x05EC(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	float                                              MinLightMapDensity;                                       // 0x05F0(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	float                                              IdealLightMapDensity;                                     // 0x05F4(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	float                                              MaxLightMapDensity;                                       // 0x05F8(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	unsigned char                                      bRenderLightMapDensityGrayscale : 1;                      // 0x05FC(0x0001) (CPF_Config, CPF_GlobalConfig)
	unsigned char                                      UnknownData02[0x3];                                       // 0x05FD(0x0003) MISSED OFFSET
	float                                              RenderLightMapDensityGrayscaleScale;                      // 0x0600(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	float                                              RenderLightMapDensityColorScale;                          // 0x0604(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	struct FLinearColor                                LightMapDensityVertexMappedColor;                         // 0x0608(0x0010) (CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	struct FLinearColor                                LightMapDensitySelectedColor;                             // 0x0618(0x0010) (CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	TArray<struct FStatColorMapping>                   StatColorMappings;                                        // 0x0628(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	class UPhysicalMaterial*                           DefaultPhysMaterial;                                      // 0x0638(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             DefaultPhysMaterialName;                                  // 0x0640(0x0018) (CPF_Config, CPF_GlobalConfig)
	TArray<struct FGameNameRedirect>                   ActiveGameNameRedirects;                                  // 0x0658(0x0010) (CPF_ZeroConstructor, CPF_Config)
	TArray<struct FClassRedirect>                      ActiveClassRedirects;                                     // 0x0668(0x0010) (CPF_ZeroConstructor, CPF_Config)
	TArray<struct FPluginRedirect>                     ActivePluginRedirects;                                    // 0x0678(0x0010) (CPF_ZeroConstructor, CPF_Config)
	TArray<struct FStructRedirect>                     ActiveStructRedirects;                                    // 0x0688(0x0010) (CPF_ZeroConstructor, CPF_Config)
	class UTexture2D*                                  PreIntegratedSkinBRDFTexture;                             // 0x0698(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             PreIntegratedSkinBRDFTextureName;                         // 0x06A0(0x0018) (CPF_Config, CPF_GlobalConfig)
	class UTexture2D*                                  MiniFontTexture;                                          // 0x06B8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             MiniFontTextureName;                                      // 0x06C0(0x0018) (CPF_Config, CPF_GlobalConfig)
	class UTexture*                                    WeightMapPlaceholderTexture;                              // 0x06D8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             WeightMapPlaceholderTextureName;                          // 0x06E0(0x0018) (CPF_Config, CPF_GlobalConfig)
	class UTexture2D*                                  LightMapDensityTexture;                                   // 0x06F8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoftObjectPath                             LightMapDensityTextureName;                               // 0x0700(0x0018) (CPF_Config, CPF_GlobalConfig)
	unsigned char                                      UnknownData03[0x8];                                       // 0x0718(0x0008) MISSED OFFSET
	class UGameViewportClient*                         GameViewport;                                             // 0x0720(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<struct FString>                             DeferredCommands;                                         // 0x0728(0x0010) (CPF_ZeroConstructor)
	int                                                TickCycles;                                               // 0x0738(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                GameCycles;                                               // 0x073C(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                ClientCycles;                                             // 0x0740(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              NearClipPlane;                                            // 0x0744(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      bHardwareSurveyEnabled : 1;                               // 0x0748(0x0001) (CPF_Deprecated)
	unsigned char                                      bSubtitlesEnabled : 1;                                    // 0x0748(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bSubtitlesForcedOff : 1;                                  // 0x0748(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      UnknownData04[0x3];                                       // 0x0749(0x0003) MISSED OFFSET
	int                                                MaximumLoopIterationCount;                                // 0x074C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      bCanBlueprintsTickByDefault : 1;                          // 0x0750(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bOptimizeAnimBlueprintMemberVariableAccess : 1;           // 0x0750(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bAllowMultiThreadedAnimationUpdate : 1;                   // 0x0750(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bEnableEditorPSysRealtimeLOD : 1;                         // 0x0750(0x0001) (CPF_Config)
	unsigned char                                      UnknownData05 : 1;                                        // 0x0750(0x0001)
	unsigned char                                      bSmoothFrameRate : 1;                                     // 0x0750(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bUseFixedFrameRate : 1;                                   // 0x0750(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      UnknownData06[0x3];                                       // 0x0751(0x0003) MISSED OFFSET
	float                                              FixedFrameRate;                                           // 0x0754(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	struct FFloatRange                                 SmoothedFrameRateRange;                                   // 0x0758(0x0010) (CPF_Edit, CPF_Config)
	unsigned char                                      bCheckForMultiplePawnsSpawnedInAFrame : 1;                // 0x0768(0x0001) (CPF_Config)
	unsigned char                                      UnknownData07[0x3];                                       // 0x0769(0x0003) MISSED OFFSET
	int                                                NumPawnsAllowedToBeSpawnedInAFrame;                       // 0x076C(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      bShouldGenerateLowQualityLightmaps : 1;                   // 0x0770(0x0001) (CPF_Config, CPF_GlobalConfig, CPF_Deprecated)
	unsigned char                                      UnknownData08[0x3];                                       // 0x0771(0x0003) MISSED OFFSET
	struct FColor                                      C_WorldBox;                                               // 0x0774(0x0004) (CPF_IsPlainOldData)
	struct FColor                                      C_BrushWire;                                              // 0x0778(0x0004) (CPF_IsPlainOldData)
	struct FColor                                      C_AddWire;                                                // 0x077C(0x0004) (CPF_IsPlainOldData)
	struct FColor                                      C_SubtractWire;                                           // 0x0780(0x0004) (CPF_IsPlainOldData)
	struct FColor                                      C_SemiSolidWire;                                          // 0x0784(0x0004) (CPF_IsPlainOldData)
	struct FColor                                      C_NonSolidWire;                                           // 0x0788(0x0004) (CPF_IsPlainOldData)
	struct FColor                                      C_WireBackground;                                         // 0x078C(0x0004) (CPF_IsPlainOldData)
	struct FColor                                      C_ScaleBoxHi;                                             // 0x0790(0x0004) (CPF_IsPlainOldData)
	struct FColor                                      C_VolumeCollision;                                        // 0x0794(0x0004) (CPF_IsPlainOldData)
	struct FColor                                      C_BSPCollision;                                           // 0x0798(0x0004) (CPF_IsPlainOldData)
	struct FColor                                      C_OrthoBackground;                                        // 0x079C(0x0004) (CPF_IsPlainOldData)
	struct FColor                                      C_Volume;                                                 // 0x07A0(0x0004) (CPF_IsPlainOldData)
	struct FColor                                      C_BrushShape;                                             // 0x07A4(0x0004) (CPF_IsPlainOldData)
	float                                              StreamingDistanceFactor;                                  // 0x07A8(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData09[0x4];                                       // 0x07AC(0x0004) MISSED OFFSET
	struct FDirectoryPath                              GameScreenshotSaveDirectory;                              // 0x07B0(0x0010) (CPF_Edit, CPF_Config)
	TEnumAsByte<ETransitionType>                       TransitionType;                                           // 0x07C0(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData10[0x7];                                       // 0x07C1(0x0007) MISSED OFFSET
	struct FString                                     TransitionDescription;                                    // 0x07C8(0x0010) (CPF_ZeroConstructor)
	struct FString                                     TransitionGameMode;                                       // 0x07D8(0x0010) (CPF_ZeroConstructor)
	float                                              MeshLODRange;                                             // 0x07E8(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      bAllowMatureLanguage : 1;                                 // 0x07EC(0x0001) (CPF_Config)
	unsigned char                                      UnknownData11[0x3];                                       // 0x07ED(0x0003) MISSED OFFSET
	float                                              CameraRotationThreshold;                                  // 0x07F0(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              CameraTranslationThreshold;                               // 0x07F4(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              PrimitiveProbablyVisibleTime;                             // 0x07F8(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              MaxOcclusionPixelsFraction;                               // 0x07FC(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      bPauseOnLossOfFocus : 1;                                  // 0x0800(0x0001) (CPF_Config)
	unsigned char                                      UnknownData12[0x3];                                       // 0x0801(0x0003) MISSED OFFSET
	int                                                MaxParticleResize;                                        // 0x0804(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                MaxParticleResizeWarn;                                    // 0x0808(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData13[0x4];                                       // 0x080C(0x0004) MISSED OFFSET
	TArray<struct FDropNoteInfo>                       PendingDroppedNotes;                                      // 0x0810(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	struct FRigidBodyErrorCorrection                   PhysicErrorCorrection;                                    // 0x0820(0x001C) (CPF_Config)
	float                                              NetClientTicksPerSecond;                                  // 0x083C(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	float                                              DisplayGamma;                                             // 0x0840(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              MinDesiredFrameRate;                                      // 0x0844(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	struct FLinearColor                                DefaultSelectedMaterialColor;                             // 0x0848(0x0010) (CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	struct FLinearColor                                SelectedMaterialColor;                                    // 0x0858(0x0010) (CPF_Transient, CPF_IsPlainOldData)
	struct FLinearColor                                SelectionOutlineColor;                                    // 0x0868(0x0010) (CPF_Transient, CPF_IsPlainOldData)
	struct FLinearColor                                SubduedSelectionOutlineColor;                             // 0x0878(0x0010) (CPF_Transient, CPF_IsPlainOldData)
	struct FLinearColor                                SelectedMaterialColorOverride;                            // 0x0888(0x0010) (CPF_Transient, CPF_IsPlainOldData)
	bool                                               bIsOverridingSelectedColor;                               // 0x0898(0x0001) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData14[0x3];                                       // 0x0899(0x0003) MISSED OFFSET
	unsigned char                                      bEnableOnScreenDebugMessages : 1;                         // 0x089C(0x0001) (CPF_Config, CPF_GlobalConfig)
	unsigned char                                      bEnableOnScreenDebugMessagesDisplay : 1;                  // 0x089C(0x0001) (CPF_Transient)
	unsigned char                                      bSuppressMapWarnings : 1;                                 // 0x089C(0x0001) (CPF_Config, CPF_GlobalConfig)
	unsigned char                                      bDisableAILogging : 1;                                    // 0x089C(0x0001) (CPF_Config, CPF_GlobalConfig)
	unsigned char                                      UnknownData15[0x3];                                       // 0x089D(0x0003) MISSED OFFSET
	uint32_t                                           bEnableVisualLogRecordingOnStart;                         // 0x08A0(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	unsigned char                                      UnknownData16[0x4];                                       // 0x08A4(0x0004) MISSED OFFSET
	int                                                ScreenSaverInhibitorSemaphore;                            // 0x08A8(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      bLockReadOnlyLevels : 1;                                  // 0x08AC(0x0001) (CPF_Transient)
	unsigned char                                      UnknownData17[0x3];                                       // 0x08AD(0x0003) MISSED OFFSET
	struct FString                                     ParticleEventManagerClassPath;                            // 0x08B0(0x0010) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig)
	unsigned char                                      UnknownData18[0x10];                                      // 0x08C0(0x0010) MISSED OFFSET
	float                                              SelectionHighlightIntensity;                              // 0x08D0(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              SelectionMeshSectionHighlightIntensity;                   // 0x08D4(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              BSPSelectionHighlightIntensity;                           // 0x08D8(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              HoverHighlightIntensity;                                  // 0x08DC(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              SelectionHighlightIntensityBillboards;                    // 0x08E0(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData19[0x40C];                                     // 0x08E4(0x040C) MISSED OFFSET
	TArray<struct FNetDriverDefinition>                NetDriverDefinitions;                                     // 0x0CF0(0x0010) (CPF_ZeroConstructor, CPF_Transient, CPF_Config)
	TArray<struct FString>                             ServerActors;                                             // 0x0D00(0x0010) (CPF_ZeroConstructor, CPF_Config)
	TArray<struct FString>                             RuntimeServerActors;                                      // 0x0D10(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      bStartedLoadMapMovie : 1;                                 // 0x0D20(0x0001) (CPF_Transient)
	unsigned char                                      UnknownData20[0x17];                                      // 0x0D21(0x0017) MISSED OFFSET
	int                                                NextWorldContextHandle;                                   // 0x0D38(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData21[0xD4];                                      // 0x0D3C(0x00D4) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Engine");
		return ptr;
	}

};


// Class Engine.ScriptViewportClient
// 0x0010 (0x0038 - 0x0028)
class UScriptViewportClient : public UObject
{
public:
	unsigned char                                      UnknownData00[0x10];                                      // 0x0028(0x0010) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ScriptViewportClient");
		return ptr;
	}

};


// Class Engine.GameViewportClient
// 0x05E8 (0x0620 - 0x0038)
class UGameViewportClient : public UScriptViewportClient
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0038(0x0008) MISSED OFFSET
	class UConsole*                                    ViewportConsole;                                          // 0x0040(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<struct FDebugDisplayProperty>               DebugProperties;                                          // 0x0048(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      UnknownData01[0x30];                                      // 0x0058(0x0030) MISSED OFFSET
	class UWorld*                                      World;                                                    // 0x0088(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UGameInstance*                               GameInstance;                                             // 0x0090(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x588];                                     // 0x0098(0x0588) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.GameViewportClient");
		return ptr;
	}


	void SSSwapControllers();
	void ShowTitleSafeArea();
	void SetConsoleTarget(int PlayerIndex);
};


// Class Engine.Console
// 0x0108 (0x0130 - 0x0028)
class UConsole : public UObject
{
public:
	unsigned char                                      UnknownData00[0x10];                                      // 0x0028(0x0010) MISSED OFFSET
	class ULocalPlayer*                                ConsoleTargetPlayer;                                      // 0x0038(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UTexture2D*                                  DefaultTexture_Black;                                     // 0x0040(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UTexture2D*                                  DefaultTexture_White;                                     // 0x0048(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x18];                                      // 0x0050(0x0018) MISSED OFFSET
	TArray<struct FString>                             HistoryBuffer;                                            // 0x0068(0x0010) (CPF_ZeroConstructor, CPF_Config)
	unsigned char                                      UnknownData02[0xB8];                                      // 0x0078(0x00B8) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Console");
		return ptr;
	}

};


// Class Engine.ControlChannel
// 0x0018 (0x0080 - 0x0068)
class UControlChannel : public UChannel
{
public:
	unsigned char                                      UnknownData00[0x18];                                      // 0x0068(0x0018) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ControlChannel");
		return ptr;
	}

};


// Class Engine.ControlRigInterface
// 0x0000 (0x0028 - 0x0028)
class UControlRigInterface : public UInterface
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ControlRigInterface");
		return ptr;
	}

};


// Class Engine.StreamingSettings
// 0x0030 (0x0068 - 0x0038)
class UStreamingSettings : public UDeveloperSettings
{
public:
	unsigned char                                      AsyncLoadingThreadEnabled : 1;                            // 0x0038(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      WarnIfTimeLimitExceeded : 1;                              // 0x0038(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0039(0x0003) MISSED OFFSET
	float                                              TimeLimitExceededMultiplier;                              // 0x003C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              TimeLimitExceededMinTime;                                 // 0x0040(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                MinBulkDataSizeForAsyncLoading;                           // 0x0044(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UseBackgroundLevelStreaming : 1;                          // 0x0048(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      AsyncLoadingUseFullTimeLimit : 1;                         // 0x0048(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      UnknownData01[0x3];                                       // 0x0049(0x0003) MISSED OFFSET
	float                                              AsyncLoadingTimeLimit;                                    // 0x004C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              PriorityAsyncLoadingExtraTime;                            // 0x0050(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              LevelStreamingActorsUpdateTimeLimit;                      // 0x0054(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                LevelStreamingComponentsRegistrationGranularity;          // 0x0058(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              LevelStreamingUnregisterComponentsTimeLimit;              // 0x005C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                LevelStreamingComponentsUnregistrationGranularity;        // 0x0060(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      EventDrivenLoaderEnabled : 1;                             // 0x0064(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      UnknownData02[0x3];                                       // 0x0065(0x0003) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.StreamingSettings");
		return ptr;
	}

};


// Class Engine.GarbageCollectionSettings
// 0x0020 (0x0058 - 0x0038)
class UGarbageCollectionSettings : public UDeveloperSettings
{
public:
	float                                              TimeBetweenPurgingPendingKillObjects;                     // 0x0038(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      FlushStreamingOnGC : 1;                                   // 0x003C(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      AllowParallelGC : 1;                                      // 0x003C(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      CreateGCClusters : 1;                                     // 0x003C(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      MergeGCClusters : 1;                                      // 0x003C(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      ActorClusteringEnabled : 1;                               // 0x003C(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      BlueprintClusteringEnabled : 1;                           // 0x003C(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      UseDisregardForGCOnDedicatedServers : 1;                  // 0x003C(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      UnknownData00[0x3];                                       // 0x003D(0x0003) MISSED OFFSET
	int                                                NumRetriesBeforeForcingGC;                                // 0x0040(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                MaxObjectsNotConsideredByGC;                              // 0x0044(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                SizeOfPermanentObjectPool;                                // 0x0048(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                MaxObjectsInGame;                                         // 0x004C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                MaxObjectsInEditor;                                       // 0x0050(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x0054(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.GarbageCollectionSettings");
		return ptr;
	}

};


// Class Engine.CullDistanceVolume
// 0x0018 (0x0368 - 0x0350)
class ACullDistanceVolume : public AVolume
{
public:
	TArray<struct FCullDistanceSizePair>               CullDistances;                                            // 0x0350(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor)
	unsigned char                                      bEnabled : 1;                                             // 0x0360(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0361(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CullDistanceVolume");
		return ptr;
	}

};


// Class Engine.CurveBase
// 0x0008 (0x0030 - 0x0028)
class UCurveBase : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CurveBase");
		return ptr;
	}


	void GetValueRange(float* MinValue, float* MaxValue);
	void GetTimeRange(float* MinTime, float* MaxTime);
};


// Class Engine.CurveEdPresetCurve
// 0x0000 (0x0028 - 0x0028)
class UCurveEdPresetCurve : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CurveEdPresetCurve");
		return ptr;
	}

};


// Class Engine.CurveFloat
// 0x0078 (0x00A8 - 0x0030)
class UCurveFloat : public UCurveBase
{
public:
	struct FRichCurve                                  FloatCurve;                                               // 0x0030(0x0070)
	bool                                               bIsEventCurve;                                            // 0x00A0(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x00A1(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CurveFloat");
		return ptr;
	}


	float GetFloatValue(float InTime);
};


// Class Engine.CurveLinearColor
// 0x01C0 (0x01F0 - 0x0030)
class UCurveLinearColor : public UCurveBase
{
public:
	struct FRichCurve                                  FloatCurves[0x4];                                         // 0x0030(0x0070)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CurveLinearColor");
		return ptr;
	}


	struct FLinearColor GetLinearColorValue(float InTime);
};


// Class Engine.CurveSourceInterface
// 0x0000 (0x0028 - 0x0028)
class UCurveSourceInterface : public UInterface
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CurveSourceInterface");
		return ptr;
	}


	float GetCurveValue(const struct FName& CurveName);
	void GetCurves(TArray<struct FNamedCurveValue>* OutValues);
	struct FName GetBindingName();
};


// Class Engine.CurveTable
// 0x0058 (0x0080 - 0x0028)
class UCurveTable : public UObject
{
public:
	unsigned char                                      UnknownData00[0x58];                                      // 0x0028(0x0058) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CurveTable");
		return ptr;
	}

};


// Class Engine.CurveVector
// 0x0150 (0x0180 - 0x0030)
class UCurveVector : public UCurveBase
{
public:
	struct FRichCurve                                  FloatCurves[0x3];                                         // 0x0030(0x0070)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.CurveVector");
		return ptr;
	}


	struct FVector GetVectorValue(float InTime);
};


// Class Engine.PrimaryDataAsset
// 0x0000 (0x0030 - 0x0030)
class UPrimaryDataAsset : public UDataAsset
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.PrimaryDataAsset");
		return ptr;
	}

};


// Class Engine.DataTable
// 0x0060 (0x0088 - 0x0028)
class UDataTable : public UObject
{
public:
	class UScriptStruct*                               RowStruct;                                                // 0x0028(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x50];                                      // 0x0030(0x0050) MISSED OFFSET
	bool                                               bStripFromClientBuilds;                                   // 0x0080(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x7];                                       // 0x0081(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DataTable");
		return ptr;
	}

};


// Class Engine.DataTableFunctionLibrary
// 0x0000 (0x0028 - 0x0028)
class UDataTableFunctionLibrary : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DataTableFunctionLibrary");
		return ptr;
	}


	static void GetDataTableRowNames(class UDataTable* Table, TArray<struct FName>* OutRowNames);
	static bool GetDataTableRowFromName(class UDataTable* Table, const struct FName& RowName, struct FTableRowBase* OutRow);
	static TArray<struct FString> GetDataTableColumnAsString(class UDataTable* DataTable, const struct FName& PropertyName);
	static void EvaluateCurveTableRow(class UCurveTable* CurveTable, const struct FName& RowName, float InXY, const struct FString& ContextString, TEnumAsByte<EEvaluateCurveTableResult>* OutResult, float* OutXY);
};


// Class Engine.DebugCameraController
// 0x0048 (0x06B8 - 0x0670)
class ADebugCameraController : public APlayerController
{
public:
	unsigned char                                      bShowSelectedInfo : 1;                                    // 0x0670(0x0001) (CPF_Config, CPF_GlobalConfig)
	unsigned char                                      bIsFrozenRendering : 1;                                   // 0x0670(0x0001)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0671(0x0007) MISSED OFFSET
	class UDrawFrustumComponent*                       DrawFrustum;                                              // 0x0678(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x20];                                      // 0x0680(0x0020) MISSED OFFSET
	float                                              SpeedScale;                                               // 0x06A0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	float                                              InitialMaxSpeed;                                          // 0x06A4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	float                                              InitialAccel;                                             // 0x06A8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	float                                              InitialDecel;                                             // 0x06AC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x8];                                       // 0x06B0(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DebugCameraController");
		return ptr;
	}


	void ToggleDisplay();
	void ShowDebugSelectedInfo();
	void SetPawnMovementSpeedScale(float NewSpeedScale);
	void ReceiveOnDeactivate(class APlayerController* RestoredPC);
	void ReceiveOnActorSelected(class AActor* NewSelectedActor, const struct FVector& SelectHitLocation, const struct FVector& SelectHitNormal, const struct FHitResult& Hit);
	void ReceiveOnActivate(class APlayerController* OriginalPC);
	class AActor* GetSelectedActor();
};


// Class Engine.DebugCameraHUD
// 0x0000 (0x0408 - 0x0408)
class ADebugCameraHUD : public AHUD
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DebugCameraHUD");
		return ptr;
	}

};


// Class Engine.DebugDrawService
// 0x0000 (0x0028 - 0x0028)
class UDebugDrawService : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DebugDrawService");
		return ptr;
	}

};


// Class Engine.DecalActor
// 0x0008 (0x0320 - 0x0318)
class ADecalActor : public AActor
{
public:
	class UDecalComponent*                             Decal;                                                    // 0x0318(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DecalActor");
		return ptr;
	}


	void SetDecalMaterial(class UMaterialInterface* NewDecalMaterial);
	class UMaterialInterface* GetDecalMaterial();
	class UMaterialInstanceDynamic* CreateDynamicMaterialInstance();
};


// Class Engine.DecalComponent
// 0x0040 (0x02D0 - 0x0290)
class UDecalComponent : public USceneComponent
{
public:
	class UMaterialInterface*                          DecalMaterial;                                            // 0x0290(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                SortOrder;                                                // 0x0298(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              FadeScreenSize;                                           // 0x029C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              FadeStartDelay;                                           // 0x02A0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              FadeDuration;                                             // 0x02A4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bDestroyOwnerAfterFade : 1;                               // 0x02A8(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData00[0x3];                                       // 0x02A9(0x0003) MISSED OFFSET
	struct FVector                                     DecalSize;                                                // 0x02AC(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x18];                                      // 0x02B8(0x0018) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DecalComponent");
		return ptr;
	}


	void SetSortOrder(int Value);
	void SetFadeScreenSize(float NewFadeScreenSize);
	void SetFadeOut(float StartDelay, float Duration, bool DestroyOwnerAfterFade);
	void SetDecalMaterial(class UMaterialInterface* NewDecalMaterial);
	float GetFadeStartDelay();
	float GetFadeDuration();
	class UMaterialInterface* GetDecalMaterial();
	class UMaterialInstanceDynamic* CreateDynamicMaterialInstance();
};


// Class Engine.DefaultPhysicsVolume
// 0x0000 (0x0360 - 0x0360)
class ADefaultPhysicsVolume : public APhysicsVolume
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DefaultPhysicsVolume");
		return ptr;
	}

};


// Class Engine.DemoNetConnection
// 0x0020 (0x337D0 - 0x337B0)
class UDemoNetConnection : public UNetConnection
{
public:
	unsigned char                                      UnknownData00[0x20];                                      // 0x337B0(0x0020) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DemoNetConnection");
		return ptr;
	}

};


// Class Engine.NetDriver
// 0x04E0 (0x0508 - 0x0028)
class UNetDriver : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET
	struct FString                                     NetConnectionClassName;                                   // 0x0030(0x0010) (CPF_ZeroConstructor, CPF_Config)
	int                                                MaxDownloadSize;                                          // 0x0040(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      bClampListenServerTickRate : 1;                           // 0x0044(0x0001) (CPF_Config)
	unsigned char                                      UnknownData01[0x3];                                       // 0x0045(0x0003) MISSED OFFSET
	int                                                NetServerMaxTickRate;                                     // 0x0048(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                MaxInternetClientRate;                                    // 0x004C(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                MaxClientRate;                                            // 0x0050(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              ServerTravelPause;                                        // 0x0054(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              SpawnPrioritySeconds;                                     // 0x0058(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              RelevantTimeout;                                          // 0x005C(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              KeepAliveTime;                                            // 0x0060(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              InitialConnectTimeout;                                    // 0x0064(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              ConnectionTimeout;                                        // 0x0068(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              TimeoutMultiplierForUnoptimizedBuilds;                    // 0x006C(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bNoTimeouts;                                              // 0x0070(0x0001) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x7];                                       // 0x0071(0x0007) MISSED OFFSET
	class UNetConnection*                              ServerConnection;                                         // 0x0078(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<class UNetConnection*>                      ClientConnections;                                        // 0x0080(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      UnknownData03[0x28];                                      // 0x0090(0x0028) MISSED OFFSET
	class UWorld*                                      World;                                                    // 0x00B8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UPackage*                                    WorldPackage;                                             // 0x00C0(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData04[0x20];                                      // 0x00C8(0x0020) MISSED OFFSET
	class UClass*                                      NetConnectionClass;                                       // 0x00E8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UProperty*                                   RoleProperty;                                             // 0x00F0(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UProperty*                                   RemoteRoleProperty;                                       // 0x00F8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FName                                       NetDriverName;                                            // 0x0100(0x0008) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData05[0x48];                                      // 0x0108(0x0048) MISSED OFFSET
	float                                              Time;                                                     // 0x0150(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData06[0x3B4];                                     // 0x0154(0x03B4) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NetDriver");
		return ptr;
	}

};


// Class Engine.DemoNetDriver
// 0x05A8 (0x0AB0 - 0x0508)
class UDemoNetDriver : public UNetDriver
{
public:
	unsigned char                                      UnknownData00[0xF8];                                      // 0x0508(0x00F8) MISSED OFFSET
	TMap<struct FString, struct FRollbackNetStartupActorInfo> RollbackNetStartupActors;                                 // 0x0600(0x0050) (CPF_ZeroConstructor, CPF_Transient)
	unsigned char                                      UnknownData01[0x404];                                     // 0x0650(0x0404) MISSED OFFSET
	float                                              CheckpointSaveMaxMSPerFrame;                              // 0x0A54(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x30];                                      // 0x0A58(0x0030) MISSED OFFSET
	bool                                               bIsLocalReplay;                                           // 0x0A88(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0x27];                                      // 0x0A89(0x0027) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DemoNetDriver");
		return ptr;
	}

};


// Class Engine.PendingNetGame
// 0x00A0 (0x00C8 - 0x0028)
class UPendingNetGame : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET
	class UNetDriver*                                  NetDriver;                                                // 0x0030(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UDemoNetDriver*                              DemoNetDriver;                                            // 0x0038(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x88];                                      // 0x0040(0x0088) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.PendingNetGame");
		return ptr;
	}

};


// Class Engine.DemoPendingNetGame
// 0x0000 (0x00C8 - 0x00C8)
class UDemoPendingNetGame : public UPendingNetGame
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DemoPendingNetGame");
		return ptr;
	}

};


// Class Engine.DestructibleInterface
// 0x0000 (0x0028 - 0x0028)
class UDestructibleInterface : public UInterface
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DestructibleInterface");
		return ptr;
	}

};


// Class Engine.TextureLODSettings
// 0x0010 (0x0038 - 0x0028)
class UTextureLODSettings : public UObject
{
public:
	TArray<struct FTextureLODGroup>                    TextureLODGroups;                                         // 0x0028(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.TextureLODSettings");
		return ptr;
	}

};


// Class Engine.DeviceProfile
// 0x0098 (0x00D0 - 0x0038)
class UDeviceProfile : public UTextureLODSettings
{
public:
	struct FString                                     DeviceType;                                               // 0x0038(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_EditConst)
	struct FString                                     BaseProfileName;                                          // 0x0048(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	class UObject*                                     Parent;                                                   // 0x0058(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x18];                                      // 0x0060(0x0018) MISSED OFFSET
	TArray<struct FString>                             CVars;                                                    // 0x0078(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	unsigned char                                      UnknownData01[0x48];                                      // 0x0088(0x0048) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DeviceProfile");
		return ptr;
	}

};


// Class Engine.DeviceProfileManager
// 0x00E8 (0x0110 - 0x0028)
class UDeviceProfileManager : public UObject
{
public:
	TArray<class UObject*>                             Profiles;                                                 // 0x0028(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	unsigned char                                      UnknownData00[0xD8];                                      // 0x0038(0x00D8) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DeviceProfileManager");
		return ptr;
	}

};


// Class Engine.SoundBase
// 0x0090 (0x00B8 - 0x0028)
class USoundBase : public UObject
{
public:
	class USoundClass*                                 SoundClassObject;                                         // 0x0028(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bDebug : 1;                                               // 0x0030(0x0001) (CPF_Edit)
	unsigned char                                      bOverrideConcurrency : 1;                                 // 0x0030(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bOutputToBusOnly : 1;                                     // 0x0030(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bIgnoreFocus : 1;                                         // 0x0030(0x0001) (CPF_Deprecated)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0031(0x0007) MISSED OFFSET
	class USoundConcurrency*                           SoundConcurrencySettings;                                 // 0x0038(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FSoundConcurrencySettings                   ConcurrencyOverrides;                                     // 0x0040(0x0010) (CPF_Edit, CPF_BlueprintVisible)
	TEnumAsByte<EMaxConcurrentResolutionRule>          MaxConcurrentResolutionRule;                              // 0x0050(0x0001) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x3];                                       // 0x0051(0x0003) MISSED OFFSET
	int                                                MaxConcurrentPlayCount;                                   // 0x0054(0x0004) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	float                                              Duration;                                                 // 0x0058(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x4];                                       // 0x005C(0x0004) MISSED OFFSET
	class USoundAttenuation*                           AttenuationSettings;                                      // 0x0060(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              Priority;                                                 // 0x0068(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0x4];                                       // 0x006C(0x0004) MISSED OFFSET
	class USoundSubmix*                                SoundSubmixObject;                                        // 0x0070(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<struct FSoundSubmixSendInfo>                SoundSubmixSends;                                         // 0x0078(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor)
	class USoundEffectSourcePresetChain*               SourceEffectChain;                                        // 0x0088(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<struct FSoundSourceBusSendInfo>             BusSends;                                                 // 0x0090(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor)
	TArray<struct FSoundSourceBusSendInfo>             PreEffectBusSends;                                        // 0x00A0(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor)
	unsigned char                                      UnknownData04[0x8];                                       // 0x00B0(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.SoundBase");
		return ptr;
	}

};


// Class Engine.DialogueSoundWaveProxy
// 0x0020 (0x00D8 - 0x00B8)
class UDialogueSoundWaveProxy : public USoundBase
{
public:
	unsigned char                                      UnknownData00[0x20];                                      // 0x00B8(0x0020) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DialogueSoundWaveProxy");
		return ptr;
	}

};


// Class Engine.DialogueVoice
// 0x0018 (0x0040 - 0x0028)
class UDialogueVoice : public UObject
{
public:
	TEnumAsByte<EGrammaticalGender>                    Gender;                                                   // 0x0028(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EGrammaticalNumber>                    Plurality;                                                // 0x0029(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x2];                                       // 0x002A(0x0002) MISSED OFFSET
	struct FGuid                                       LocalizationGUID;                                         // 0x002C(0x0010) (CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x003C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DialogueVoice");
		return ptr;
	}

};


// Class Engine.DialogueWave
// 0x0048 (0x0070 - 0x0028)
class UDialogueWave : public UObject
{
public:
	unsigned char                                      bMature : 1;                                              // 0x0028(0x0001) (CPF_Edit)
	unsigned char                                      bOverride_SubtitleOverride : 1;                           // 0x0028(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0029(0x0007) MISSED OFFSET
	struct FString                                     SpokenText;                                               // 0x0030(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	struct FString                                     SubtitleOverride;                                         // 0x0040(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	TArray<struct FDialogueContextMapping>             ContextMappings;                                          // 0x0050(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	struct FGuid                                       LocalizationGUID;                                         // 0x0060(0x0010) (CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DialogueWave");
		return ptr;
	}

};


// Class Engine.Light
// 0x0010 (0x0328 - 0x0318)
class ALight : public AActor
{
public:
	class ULightComponent*                             LightComponent;                                           // 0x0318(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)
	unsigned char                                      bEnabled : 1;                                             // 0x0320(0x0001) (CPF_Net)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0321(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Light");
		return ptr;
	}


	void ToggleEnabled();
	void SetLightFunctionScale(const struct FVector& NewLightFunctionScale);
	void SetLightFunctionMaterial(class UMaterialInterface* NewLightFunctionMaterial);
	void SetLightFunctionFadeDistance(float NewLightFunctionFadeDistance);
	void SetLightColor(const struct FLinearColor& NewLightColor);
	void SetEnabled(bool bSetEnabled);
	void SetCastShadows(bool bNewValue);
	void SetBrightness(float NewBrightness);
	void SetAffectTranslucentLighting(bool bNewValue);
	void OnRep_bEnabled();
	bool IsEnabled();
	struct FLinearColor GetLightColor();
	float GetBrightness();
};


// Class Engine.DirectionalLight
// 0x0000 (0x0328 - 0x0328)
class ADirectionalLight : public ALight
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DirectionalLight");
		return ptr;
	}

};


// Class Engine.LightComponentBase
// 0x0030 (0x02C0 - 0x0290)
class ULightComponentBase : public USceneComponent
{
public:
	struct FGuid                                       LightGuid;                                                // 0x0290(0x0010) (CPF_IsPlainOldData)
	float                                              Brightness;                                               // 0x02A0(0x0004) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	float                                              Intensity;                                                // 0x02A4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FColor                                      LightColor;                                               // 0x02A8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	unsigned char                                      bAffectsWorld : 1;                                        // 0x02AC(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      CastShadows : 1;                                          // 0x02AC(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      CastStaticShadows : 1;                                    // 0x02AC(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      CastDynamicShadows : 1;                                   // 0x02AC(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bAffectTranslucentLighting : 1;                           // 0x02AC(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bCastVolumetricShadow : 1;                                // 0x02AC(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData00[0x3];                                       // 0x02AD(0x0003) MISSED OFFSET
	float                                              IndirectLightingIntensity;                                // 0x02B0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              VolumetricScatteringIntensity;                            // 0x02B4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x8];                                       // 0x02B8(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LightComponentBase");
		return ptr;
	}


	void SetCastVolumetricShadow(bool bNewValue);
	void SetCastShadows(bool bNewValue);
	struct FLinearColor GetLightColor();
};


// Class Engine.LightComponent
// 0x0100 (0x03C0 - 0x02C0)
class ULightComponent : public ULightComponentBase
{
public:
	float                                              MaxDistanceFadeRange;                                     // 0x02C0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bUseTemperature : 1;                                      // 0x02C4(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData00[0x3];                                       // 0x02C5(0x0003) MISSED OFFSET
	int                                                ShadowMapChannel;                                         // 0x02C8(0x0004) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x02CC(0x0004) MISSED OFFSET
	float                                              MinRoughness;                                             // 0x02D0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ShadowResolutionScale;                                    // 0x02D4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ShadowBias;                                               // 0x02D8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ShadowSharpen;                                            // 0x02DC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ContactShadowLength;                                      // 0x02E0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      InverseSquaredFalloff : 1;                                // 0x02E4(0x0001) (CPF_Deprecated)
	unsigned char                                      CastTranslucentShadows : 1;                               // 0x02E4(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bCastShadowsFromCinematicObjectsOnly : 1;                 // 0x02E4(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bAffectDynamicIndirectLighting : 1;                       // 0x02E4(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bForceCachedShadowsForMovablePrimitives : 1;              // 0x02E4(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData02[0x3];                                       // 0x02E5(0x0003) MISSED OFFSET
	struct FLightingChannels                           LightingChannels;                                         // 0x02E8(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData03[0x7];                                       // 0x02E9(0x0007) MISSED OFFSET
	class UMaterialInterface*                          LightFunctionMaterial;                                    // 0x02F0(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FVector                                     LightFunctionScale;                                       // 0x02F8(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	unsigned char                                      UnknownData04[0x4];                                       // 0x0304(0x0004) MISSED OFFSET
	class UTextureLightProfile*                        IESTexture;                                               // 0x0308(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bUseIESBrightness : 1;                                    // 0x0310(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData05[0x3];                                       // 0x0311(0x0003) MISSED OFFSET
	float                                              IESBrightnessScale;                                       // 0x0314(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              LightFunctionFadeDistance;                                // 0x0318(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              DisabledBrightness;                                       // 0x031C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bEnableLightShaftBloom : 1;                               // 0x0320(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData06[0x3];                                       // 0x0321(0x0003) MISSED OFFSET
	float                                              BloomScale;                                               // 0x0324(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              BloomThreshold;                                           // 0x0328(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FColor                                      BloomTint;                                                // 0x032C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	bool                                               bUseRayTracedDistanceFieldShadows;                        // 0x0330(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData07[0x3];                                       // 0x0331(0x0003) MISSED OFFSET
	float                                              RayStartOffsetDepthScale;                                 // 0x0334(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData08[0x88];                                      // 0x0338(0x0088) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LightComponent");
		return ptr;
	}


	void SetVolumetricScatteringIntensity(float NewIntensity);
	void SetTemperature(float NewTemperature);
	void SetShadowBias(float NewValue);
	void SetLightFunctionScale(const struct FVector& NewLightFunctionScale);
	void SetLightFunctionMaterial(class UMaterialInterface* NewLightFunctionMaterial);
	void SetLightFunctionFadeDistance(float NewLightFunctionFadeDistance);
	void SetLightFunctionDisabledBrightness(float NewValue);
	void SetLightColor(const struct FLinearColor& NewLightColor, bool bSRGB);
	void SetIntensity(float NewIntensity);
	void SetIndirectLightingIntensity(float NewIntensity);
	void SetIESTexture(class UTextureLightProfile* NewValue);
	void SetForceCachedShadowsForMovablePrimitives(bool bNewValue);
	void SetEnableLightShaftBloom(bool bNewValue);
	void SetBloomTint(const struct FColor& NewValue);
	void SetBloomThreshold(float NewValue);
	void SetBloomScale(float NewValue);
	void SetAffectTranslucentLighting(bool bNewValue);
	void SetAffectDynamicIndirectLighting(bool bNewValue);
};


// Class Engine.DirectionalLightComponent
// 0x0070 (0x0430 - 0x03C0)
class UDirectionalLightComponent : public ULightComponent
{
public:
	unsigned char                                      bEnableLightShaftOcclusion : 1;                           // 0x03C0(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData00[0x3];                                       // 0x03C1(0x0003) MISSED OFFSET
	float                                              OcclusionMaskDarkness;                                    // 0x03C4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              OcclusionDepthRange;                                      // 0x03C8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FVector                                     LightShaftOverrideDirection;                              // 0x03CC(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	float                                              WholeSceneDynamicShadowRadius;                            // 0x03D8(0x0004) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	float                                              DynamicShadowDistanceMovableLight;                        // 0x03DC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              DynamicShadowDistanceStationaryLight;                     // 0x03E0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                DynamicShadowCascades;                                    // 0x03E4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              CascadeDistributionExponent;                              // 0x03E8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              CascadeTransitionFraction;                                // 0x03EC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ShadowDistanceFadeoutFraction;                            // 0x03F0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bUseInsetShadowsForMovableObjects : 1;                    // 0x03F4(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData01[0x3];                                       // 0x03F5(0x0003) MISSED OFFSET
	int                                                FarShadowCascadeCount;                                    // 0x03F8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              FarShadowDistance;                                        // 0x03FC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              DistanceFieldShadowDistance;                              // 0x0400(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              LightSourceAngle;                                         // 0x0404(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              TraceDistance;                                            // 0x0408(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FLightmassDirectionalLightSettings          LightmassSettings;                                        // 0x040C(0x0010) (CPF_Edit)
	unsigned char                                      bCastModulatedShadows : 1;                                // 0x041C(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData02[0x3];                                       // 0x041D(0x0003) MISSED OFFSET
	struct FColor                                      ModulatedShadowColor;                                     // 0x0420(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	unsigned char                                      bUsedAsAtmosphereSunLight : 1;                            // 0x0424(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData03[0xB];                                       // 0x0425(0x000B) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DirectionalLightComponent");
		return ptr;
	}


	void SetShadowDistanceFadeoutFraction(float NewValue);
	void SetOcclusionMaskDarkness(float NewValue);
	void SetLightShaftOverrideDirection(const struct FVector& NewValue);
	void SetEnableLightShaftOcclusion(bool bNewValue);
	void SetDynamicShadowDistanceStationaryLight(float NewValue);
	void SetDynamicShadowDistanceMovableLight(float NewValue);
	void SetDynamicShadowCascades(int NewValue);
	void SetCascadeTransitionFraction(float NewValue);
	void SetCascadeDistributionExponent(float NewValue);
};


// Class Engine.Distribution
// 0x0008 (0x0030 - 0x0028)
class UDistribution : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Distribution");
		return ptr;
	}

};


// Class Engine.DistributionFloat
// 0x0008 (0x0038 - 0x0030)
class UDistributionFloat : public UDistribution
{
public:
	unsigned char                                      bCanBeBaked : 1;                                          // 0x0030(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00 : 1;                                        // 0x0030(0x0001)
	unsigned char                                      bBakedDataSuccesfully : 1;                                // 0x0030(0x0001)
	unsigned char                                      UnknownData01[0x7];                                       // 0x0031(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DistributionFloat");
		return ptr;
	}

};


// Class Engine.DistributionFloatConstant
// 0x0008 (0x0040 - 0x0038)
class UDistributionFloatConstant : public UDistributionFloat
{
public:
	float                                              Constant;                                                 // 0x0038(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x003C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DistributionFloatConstant");
		return ptr;
	}

};


// Class Engine.DistributionFloatConstantCurve
// 0x0018 (0x0050 - 0x0038)
class UDistributionFloatConstantCurve : public UDistributionFloat
{
public:
	struct FInterpCurveFloat                           ConstantCurve;                                            // 0x0038(0x0018) (CPF_Edit)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DistributionFloatConstantCurve");
		return ptr;
	}

};


// Class Engine.DistributionFloatParameterBase
// 0x0020 (0x0060 - 0x0040)
class UDistributionFloatParameterBase : public UDistributionFloatConstant
{
public:
	struct FName                                       ParameterName;                                            // 0x0040(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MinInput;                                                 // 0x0048(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxInput;                                                 // 0x004C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MinOutput;                                                // 0x0050(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxOutput;                                                // 0x0054(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EDistributionParamMode>                ParamMode;                                                // 0x0058(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0059(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DistributionFloatParameterBase");
		return ptr;
	}

};


// Class Engine.DistributionFloatParticleParameter
// 0x0000 (0x0060 - 0x0060)
class UDistributionFloatParticleParameter : public UDistributionFloatParameterBase
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DistributionFloatParticleParameter");
		return ptr;
	}

};


// Class Engine.DistributionFloatUniform
// 0x0008 (0x0040 - 0x0038)
class UDistributionFloatUniform : public UDistributionFloat
{
public:
	float                                              Min;                                                      // 0x0038(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              Max;                                                      // 0x003C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DistributionFloatUniform");
		return ptr;
	}

};


// Class Engine.DistributionFloatUniformCurve
// 0x0018 (0x0050 - 0x0038)
class UDistributionFloatUniformCurve : public UDistributionFloat
{
public:
	struct FInterpCurveVector2D                        ConstantCurve;                                            // 0x0038(0x0018) (CPF_Edit)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DistributionFloatUniformCurve");
		return ptr;
	}

};


// Class Engine.DistributionVector
// 0x0008 (0x0038 - 0x0030)
class UDistributionVector : public UDistribution
{
public:
	unsigned char                                      bCanBeBaked : 1;                                          // 0x0030(0x0001) (CPF_Edit)
	unsigned char                                      bIsDirty : 1;                                             // 0x0030(0x0001)
	unsigned char                                      bBakedDataSuccesfully : 1;                                // 0x0030(0x0001)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0031(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DistributionVector");
		return ptr;
	}

};


// Class Engine.DistributionVectorConstant
// 0x0018 (0x0050 - 0x0038)
class UDistributionVectorConstant : public UDistributionVector
{
public:
	struct FVector                                     Constant;                                                 // 0x0038(0x000C) (CPF_Edit, CPF_IsPlainOldData)
	unsigned char                                      bLockAxes : 1;                                            // 0x0044(0x0001)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0045(0x0003) MISSED OFFSET
	TEnumAsByte<EDistributionVectorLockFlags>          LockedAxes;                                               // 0x0048(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x7];                                       // 0x0049(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DistributionVectorConstant");
		return ptr;
	}

};


// Class Engine.DistributionVectorConstantCurve
// 0x0020 (0x0058 - 0x0038)
class UDistributionVectorConstantCurve : public UDistributionVector
{
public:
	struct FInterpCurveVector                          ConstantCurve;                                            // 0x0038(0x0018) (CPF_Edit)
	unsigned char                                      bLockAxes : 1;                                            // 0x0050(0x0001)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0051(0x0003) MISSED OFFSET
	TEnumAsByte<EDistributionVectorLockFlags>          LockedAxes;                                               // 0x0054(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x3];                                       // 0x0055(0x0003) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DistributionVectorConstantCurve");
		return ptr;
	}

};


// Class Engine.DistributionVectorParameterBase
// 0x0040 (0x0090 - 0x0050)
class UDistributionVectorParameterBase : public UDistributionVectorConstant
{
public:
	struct FName                                       ParameterName;                                            // 0x0050(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FVector                                     MinInput;                                                 // 0x0058(0x000C) (CPF_Edit, CPF_IsPlainOldData)
	struct FVector                                     MaxInput;                                                 // 0x0064(0x000C) (CPF_Edit, CPF_IsPlainOldData)
	struct FVector                                     MinOutput;                                                // 0x0070(0x000C) (CPF_Edit, CPF_IsPlainOldData)
	struct FVector                                     MaxOutput;                                                // 0x007C(0x000C) (CPF_Edit, CPF_IsPlainOldData)
	TEnumAsByte<EDistributionParamMode>                ParamModes[0x3];                                          // 0x0088(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x5];                                       // 0x008B(0x0005) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DistributionVectorParameterBase");
		return ptr;
	}

};


// Class Engine.DistributionVectorParticleParameter
// 0x0000 (0x0090 - 0x0090)
class UDistributionVectorParticleParameter : public UDistributionVectorParameterBase
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DistributionVectorParticleParameter");
		return ptr;
	}

};


// Class Engine.DistributionVectorUniform
// 0x0028 (0x0060 - 0x0038)
class UDistributionVectorUniform : public UDistributionVector
{
public:
	struct FVector                                     Max;                                                      // 0x0038(0x000C) (CPF_Edit, CPF_IsPlainOldData)
	struct FVector                                     Min;                                                      // 0x0044(0x000C) (CPF_Edit, CPF_IsPlainOldData)
	unsigned char                                      bLockAxes : 1;                                            // 0x0050(0x0001)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0051(0x0003) MISSED OFFSET
	TEnumAsByte<EDistributionVectorLockFlags>          LockedAxes;                                               // 0x0054(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EDistributionVectorMirrorFlags>        MirrorFlags[0x3];                                         // 0x0055(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bUseExtremes : 1;                                         // 0x0058(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData01[0x7];                                       // 0x0059(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DistributionVectorUniform");
		return ptr;
	}

};


// Class Engine.DistributionVectorUniformCurve
// 0x0028 (0x0060 - 0x0038)
class UDistributionVectorUniformCurve : public UDistributionVector
{
public:
	struct FInterpCurveTwoVectors                      ConstantCurve;                                            // 0x0038(0x0018) (CPF_Edit)
	unsigned char                                      bLockAxes1 : 1;                                           // 0x0050(0x0001)
	unsigned char                                      bLockAxes2 : 1;                                           // 0x0050(0x0001)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0051(0x0003) MISSED OFFSET
	TEnumAsByte<EDistributionVectorLockFlags>          LockedAxes[0x2];                                          // 0x0054(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EDistributionVectorMirrorFlags>        MirrorFlags[0x3];                                         // 0x0056(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x3];                                       // 0x0059(0x0003) MISSED OFFSET
	unsigned char                                      bUseExtremes : 1;                                         // 0x005C(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData02[0x3];                                       // 0x005D(0x0003) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DistributionVectorUniformCurve");
		return ptr;
	}

};


// Class Engine.DocumentationActor
// 0x0008 (0x0320 - 0x0318)
class ADocumentationActor : public AActor
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0318(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DocumentationActor");
		return ptr;
	}

};


// Class Engine.DPICustomScalingRule
// 0x0000 (0x0028 - 0x0028)
class UDPICustomScalingRule : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DPICustomScalingRule");
		return ptr;
	}

};


// Class Engine.DrawFrustumComponent
// 0x0020 (0x0680 - 0x0660)
class UDrawFrustumComponent : public UPrimitiveComponent
{
public:
	struct FColor                                      FrustumColor;                                             // 0x0660(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_IsPlainOldData)
	float                                              FrustumAngle;                                             // 0x0664(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              FrustumAspectRatio;                                       // 0x0668(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              FrustumStartDist;                                         // 0x066C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              FrustumEndDist;                                           // 0x0670(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x0674(0x0004) MISSED OFFSET
	class UTexture*                                    Texture;                                                  // 0x0678(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DrawFrustumComponent");
		return ptr;
	}

};


// Class Engine.SphereComponent
// 0x0010 (0x0690 - 0x0680)
class USphereComponent : public UShapeComponent
{
public:
	float                                              SphereRadius;                                             // 0x0680(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0xC];                                       // 0x0684(0x000C) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.SphereComponent");
		return ptr;
	}


	void SetSphereRadius(float InSphereRadius, bool bUpdateOverlaps);
	float GetUnscaledSphereRadius();
	float GetShapeScale();
	float GetScaledSphereRadius();
};


// Class Engine.DrawSphereComponent
// 0x0000 (0x0690 - 0x0690)
class UDrawSphereComponent : public USphereComponent
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.DrawSphereComponent");
		return ptr;
	}

};


// Class Engine.EdGraph
// 0x0098 (0x00C0 - 0x0028)
class UEdGraph : public UObject
{
public:
	class UClass*                                      Schema;                                                   // 0x0028(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<class UEdGraphNode*>                        Nodes;                                                    // 0x0030(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      bEditable : 1;                                            // 0x0040(0x0001)
	unsigned char                                      bAllowDeletion : 1;                                       // 0x0040(0x0001)
	unsigned char                                      bAllowRenaming : 1;                                       // 0x0040(0x0001)
	unsigned char                                      UnknownData00[0x7F];                                      // 0x0041(0x007F) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.EdGraph");
		return ptr;
	}

};


// Class Engine.EdGraphNode
// 0x0070 (0x0098 - 0x0028)
class UEdGraphNode : public UObject
{
public:
	unsigned char                                      UnknownData00[0x10];                                      // 0x0028(0x0010) MISSED OFFSET
	TArray<class UEdGraphPin_Deprecated*>              DeprecatedPins;                                           // 0x0038(0x0010) (CPF_ZeroConstructor)
	int                                                NodePosX;                                                 // 0x0048(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                NodePosY;                                                 // 0x004C(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                NodeWidth;                                                // 0x0050(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                NodeHeight;                                               // 0x0054(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ENodeAdvancedPins>                     AdvancedPinDisplay;                                       // 0x0058(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	ENodeEnabledState                                  EnabledState;                                             // 0x0059(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x1];                                       // 0x005A(0x0001) MISSED OFFSET
	unsigned char                                      bUserSetEnabledState : 1;                                 // 0x005B(0x0001)
	unsigned char                                      UnknownData02 : 1;                                        // 0x005B(0x0001)
	unsigned char                                      bIsNodeEnabled : 1;                                       // 0x005B(0x0001) (CPF_Deprecated)
	unsigned char                                      UnknownData03 : 1;                                        // 0x005B(0x0001)
	unsigned char                                      bHasCompilerMessage : 1;                                  // 0x005B(0x0001)
	unsigned char                                      bCommentBubblePinned : 1;                                 // 0x005B(0x0001)
	unsigned char                                      bCommentBubbleVisible : 1;                                // 0x005B(0x0001)
	unsigned char                                      bCommentBubbleMakeVisible : 1;                            // 0x005B(0x0001) (CPF_Transient)
	unsigned char                                      UnknownData04[0x4];                                       // 0x005C(0x0004) MISSED OFFSET
	struct FString                                     NodeComment;                                              // 0x0060(0x0010) (CPF_ZeroConstructor)
	int                                                ErrorType;                                                // 0x0070(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData05[0x4];                                       // 0x0074(0x0004) MISSED OFFSET
	struct FString                                     ErrorMsg;                                                 // 0x0078(0x0010) (CPF_ZeroConstructor)
	struct FGuid                                       NodeGuid;                                                 // 0x0088(0x0010) (CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.EdGraphNode");
		return ptr;
	}

};


// Class Engine.EdGraphNode_Documentation
// 0x0020 (0x00B8 - 0x0098)
class UEdGraphNode_Documentation : public UEdGraphNode
{
public:
	struct FString                                     Link;                                                     // 0x0098(0x0010) (CPF_ZeroConstructor)
	struct FString                                     Excerpt;                                                  // 0x00A8(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.EdGraphNode_Documentation");
		return ptr;
	}

};


// Class Engine.EdGraphPin_Deprecated
// 0x00F8 (0x0120 - 0x0028)
class UEdGraphPin_Deprecated : public UObject
{
public:
	struct FString                                     PinName;                                                  // 0x0028(0x0010) (CPF_ZeroConstructor)
	struct FString                                     PinToolTip;                                               // 0x0038(0x0010) (CPF_ZeroConstructor)
	TEnumAsByte<EEdGraphPinDirection>                  Direction;                                                // 0x0048(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0049(0x0007) MISSED OFFSET
	struct FEdGraphPinType                             PinType;                                                  // 0x0050(0x0060)
	struct FString                                     DefaultValue;                                             // 0x00B0(0x0010) (CPF_ZeroConstructor)
	struct FString                                     AutogeneratedDefaultValue;                                // 0x00C0(0x0010) (CPF_ZeroConstructor)
	class UObject*                                     DefaultObject;                                            // 0x00D0(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FText                                       DefaultTextValue;                                         // 0x00D8(0x0018)
	TArray<class UEdGraphPin_Deprecated*>              LinkedTo;                                                 // 0x00F0(0x0010) (CPF_ZeroConstructor)
	TArray<class UEdGraphPin_Deprecated*>              SubPins;                                                  // 0x0100(0x0010) (CPF_ZeroConstructor)
	class UEdGraphPin_Deprecated*                      ParentPin;                                                // 0x0110(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UEdGraphPin_Deprecated*                      ReferencePassThroughConnection;                           // 0x0118(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.EdGraphPin_Deprecated");
		return ptr;
	}

};


// Class Engine.EdGraphSchema
// 0x0000 (0x0028 - 0x0028)
class UEdGraphSchema : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.EdGraphSchema");
		return ptr;
	}

};


// Class Engine.Emitter
// 0x0050 (0x0368 - 0x0318)
class AEmitter : public AActor
{
public:
	class UParticleSystemComponent*                    ParticleSystemComponent;                                  // 0x0318(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)
	unsigned char                                      bDestroyOnSystemFinish : 1;                               // 0x0320(0x0001)
	unsigned char                                      bPostUpdateTickGroup : 1;                                 // 0x0320(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bCurrentlyActive : 1;                                     // 0x0320(0x0001) (CPF_Net)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0321(0x0007) MISSED OFFSET
	struct FScriptMulticastDelegate                    OnParticleSpawn;                                          // 0x0328(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnParticleBurst;                                          // 0x0338(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnParticleDeath;                                          // 0x0348(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnParticleCollide;                                        // 0x0358(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Emitter");
		return ptr;
	}


	void ToggleActive();
	void SetVectorParameter(const struct FName& ParameterName, const struct FVector& Param);
	void SetTemplate(class UParticleSystem* NewTemplate);
	void SetMaterialParameter(const struct FName& ParameterName, class UMaterialInterface* Param);
	void SetFloatParameter(const struct FName& ParameterName, float Param);
	void SetColorParameter(const struct FName& ParameterName, const struct FLinearColor& Param);
	void SetActorParameter(const struct FName& ParameterName, class AActor* Param);
	void OnRep_bCurrentlyActive();
	void OnParticleSystemFinished(class UParticleSystemComponent* FinishedComponent);
	bool IsActive();
	void Deactivate();
	void Activate();
};


// Class Engine.EmitterCameraLensEffectBase
// 0x0068 (0x03D0 - 0x0368)
class AEmitterCameraLensEffectBase : public AEmitter
{
public:
	class UParticleSystem*                             PS_CameraEffect;                                          // 0x0368(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	class UParticleSystem*                             PS_CameraEffectNonExtremeContent;                         // 0x0370(0x0008) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	class APlayerCameraManager*                        BaseCamera;                                               // 0x0378(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	struct FTransform                                  RelativeTransform;                                        // 0x0380(0x0030) (CPF_Edit, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	float                                              BaseFOV;                                                  // 0x03B0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	unsigned char                                      bAllowMultipleInstances : 1;                              // 0x03B4(0x0001) (CPF_Edit)
	unsigned char                                      bResetWhenRetriggered : 1;                                // 0x03B4(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x3];                                       // 0x03B5(0x0003) MISSED OFFSET
	TArray<class UClass*>                              EmittersToTreatAsSame;                                    // 0x03B8(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnInstance)
	float                                              DistFromCamera;                                           // 0x03C8(0x0004) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x03CC(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.EmitterCameraLensEffectBase");
		return ptr;
	}

};


// Class Engine.EndUserSettings
// 0x0010 (0x0038 - 0x0028)
class UEndUserSettings : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET
	bool                                               bSendAnonymousUsageDataToEpic;                            // 0x0030(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bSendMeanTimeBetweenFailureDataToEpic;                    // 0x0031(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bAllowUserIdInUsageData;                                  // 0x0032(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x5];                                       // 0x0033(0x0005) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.EndUserSettings");
		return ptr;
	}

};


// Class Engine.EngineBaseTypes
// 0x0000 (0x0028 - 0x0028)
class UEngineBaseTypes : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.EngineBaseTypes");
		return ptr;
	}

};


// Class Engine.EngineHandlerComponentFactory
// 0x0000 (0x0028 - 0x0028)
class UEngineHandlerComponentFactory : public UHandlerComponentFactory
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.EngineHandlerComponentFactory");
		return ptr;
	}

};


// Class Engine.LocalMessage
// 0x0000 (0x0028 - 0x0028)
class ULocalMessage : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LocalMessage");
		return ptr;
	}

};


// Class Engine.EngineMessage
// 0x0080 (0x00A8 - 0x0028)
class UEngineMessage : public ULocalMessage
{
public:
	struct FString                                     FailedPlaceMessage;                                       // 0x0028(0x0010) (CPF_ZeroConstructor)
	struct FString                                     MaxedOutMessage;                                          // 0x0038(0x0010) (CPF_ZeroConstructor)
	struct FString                                     EnteredMessage;                                           // 0x0048(0x0010) (CPF_ZeroConstructor)
	struct FString                                     LeftMessage;                                              // 0x0058(0x0010) (CPF_ZeroConstructor)
	struct FString                                     GlobalNameChange;                                         // 0x0068(0x0010) (CPF_ZeroConstructor)
	struct FString                                     SpecEnteredMessage;                                       // 0x0078(0x0010) (CPF_ZeroConstructor)
	struct FString                                     NewPlayerMessage;                                         // 0x0088(0x0010) (CPF_ZeroConstructor)
	struct FString                                     NewSpecMessage;                                           // 0x0098(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.EngineMessage");
		return ptr;
	}

};


// Class Engine.EngineTypes
// 0x0000 (0x0028 - 0x0028)
class UEngineTypes : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.EngineTypes");
		return ptr;
	}

};


// Class Engine.ExponentialHeightFog
// 0x0010 (0x0328 - 0x0318)
class AExponentialHeightFog : public AInfo
{
public:
	class UExponentialHeightFogComponent*              Component;                                                // 0x0318(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)
	unsigned char                                      bEnabled : 1;                                             // 0x0320(0x0001) (CPF_Net)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0321(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ExponentialHeightFog");
		return ptr;
	}


	void OnRep_bEnabled();
};


// Class Engine.ExponentialHeightFogComponent
// 0x0090 (0x0320 - 0x0290)
class UExponentialHeightFogComponent : public USceneComponent
{
public:
	float                                              FogDensity;                                               // 0x0290(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FLinearColor                                FogInscatteringColor;                                     // 0x0294(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x02A4(0x0004) MISSED OFFSET
	class UTextureCube*                                InscatteringColorCubemap;                                 // 0x02A8(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              InscatteringColorCubemapAngle;                            // 0x02B0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FLinearColor                                InscatteringTextureTint;                                  // 0x02B4(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	float                                              FullyDirectionalInscatteringColorDistance;                // 0x02C4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              NonDirectionalInscatteringColorDistance;                  // 0x02C8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              DirectionalInscatteringExponent;                          // 0x02CC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              DirectionalInscatteringStartDistance;                     // 0x02D0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FLinearColor                                DirectionalInscatteringColor;                             // 0x02D4(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	float                                              FogHeightFalloff;                                         // 0x02E4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              FogMaxOpacity;                                            // 0x02E8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              StartDistance;                                            // 0x02EC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              FogCutoffDistance;                                        // 0x02F0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bEnableVolumetricFog;                                     // 0x02F4(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x3];                                       // 0x02F5(0x0003) MISSED OFFSET
	float                                              VolumetricFogScatteringDistribution;                      // 0x02F8(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FColor                                      VolumetricFogAlbedo;                                      // 0x02FC(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	struct FLinearColor                                VolumetricFogEmissive;                                    // 0x0300(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_IsPlainOldData)
	float                                              VolumetricFogExtinctionScale;                             // 0x0310(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              VolumetricFogDistance;                                    // 0x0314(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              VolumetricFogStaticLightingScatteringIntensity;           // 0x0318(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bOverrideLightColorsWithFogInscatteringColors;            // 0x031C(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x3];                                       // 0x031D(0x0003) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ExponentialHeightFogComponent");
		return ptr;
	}


	void SetVolumetricFogScatteringDistribution(float NewValue);
	void SetVolumetricFogExtinctionScale(float NewValue);
	void SetVolumetricFogEmissive(const struct FLinearColor& NewValue);
	void SetVolumetricFogDistance(float NewValue);
	void SetVolumetricFogAlbedo(const struct FColor& NewValue);
	void SetVolumetricFog(bool bNewValue);
	void SetStartDistance(float Value);
	void SetNonDirectionalInscatteringColorDistance(float Value);
	void SetInscatteringTextureTint(const struct FLinearColor& Value);
	void SetInscatteringColorCubemapAngle(float Value);
	void SetInscatteringColorCubemap(class UTextureCube* Value);
	void SetFullyDirectionalInscatteringColorDistance(float Value);
	void SetFogMaxOpacity(float Value);
	void SetFogInscatteringColor(const struct FLinearColor& Value);
	void SetFogHeightFalloff(float Value);
	void SetFogDensity(float Value);
	void SetFogCutoffDistance(float Value);
	void SetDirectionalInscatteringStartDistance(float Value);
	void SetDirectionalInscatteringExponent(float Value);
	void SetDirectionalInscatteringColor(const struct FLinearColor& Value);
};


// Class Engine.Exporter
// 0x0040 (0x0068 - 0x0028)
class UExporter : public UObject
{
public:
	class UClass*                                      SupportedClass;                                           // 0x0028(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UObject*                                     ExportRootScope;                                          // 0x0030(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	TArray<struct FString>                             FormatExtension;                                          // 0x0038(0x0010) (CPF_ZeroConstructor)
	TArray<struct FString>                             FormatDescription;                                        // 0x0048(0x0010) (CPF_ZeroConstructor)
	int                                                PreferredFormatIndex;                                     // 0x0058(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                TextIndent;                                               // 0x005C(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bText : 1;                                                // 0x0060(0x0001)
	unsigned char                                      bSelectedOnly : 1;                                        // 0x0060(0x0001)
	unsigned char                                      bForceFileOperations : 1;                                 // 0x0060(0x0001)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0061(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Exporter");
		return ptr;
	}

};


// Class Engine.FloatingPawnMovement
// 0x0018 (0x0190 - 0x0178)
class UFloatingPawnMovement : public UPawnMovementComponent
{
public:
	float                                              MaxSpeed;                                                 // 0x0178(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              Acceleration;                                             // 0x017C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              Deceleration;                                             // 0x0180(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              TurningBoost;                                             // 0x0184(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bPositionCorrected : 1;                                   // 0x0188(0x0001) (CPF_Transient)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0189(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.FloatingPawnMovement");
		return ptr;
	}

};


// Class Engine.Font
// 0x01A8 (0x01D0 - 0x0028)
class UFont : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET
	EFontCacheType                                     FontCacheType;                                            // 0x0030(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x7];                                       // 0x0031(0x0007) MISSED OFFSET
	TArray<struct FFontCharacter>                      Characters;                                               // 0x0038(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	TArray<class UTexture2D*>                          Textures;                                                 // 0x0048(0x0010) (CPF_ZeroConstructor)
	int                                                IsRemapped;                                               // 0x0058(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              EmScale;                                                  // 0x005C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              Ascent;                                                   // 0x0060(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              Descent;                                                  // 0x0064(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              Leading;                                                  // 0x0068(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                Kerning;                                                  // 0x006C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FFontImportOptionsData                      ImportOptions;                                            // 0x0070(0x00B0) (CPF_Edit)
	int                                                NumCharacters;                                            // 0x0120(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x4];                                       // 0x0124(0x0004) MISSED OFFSET
	TArray<int>                                        MaxCharHeight;                                            // 0x0128(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	float                                              ScalingFactor;                                            // 0x0138(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                LegacyFontSize;                                           // 0x013C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FName                                       LegacyFontName;                                           // 0x0140(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FCompositeFont                              CompositeFont;                                            // 0x0148(0x0038)
	unsigned char                                      UnknownData03[0x50];                                      // 0x0180(0x0050) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Font");
		return ptr;
	}

};


// Class Engine.FontFace
// 0x0030 (0x0058 - 0x0028)
class UFontFace : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET
	struct FString                                     SourceFilename;                                           // 0x0030(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor)
	EFontHinting                                       Hinting;                                                  // 0x0040(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	EFontLoadingPolicy                                 LoadingPolicy;                                            // 0x0041(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	EFontLayoutMethod                                  LayoutMethod;                                             // 0x0042(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x15];                                      // 0x0043(0x0015) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.FontFace");
		return ptr;
	}

};


// Class Engine.FontImportOptions
// 0x00B0 (0x00D8 - 0x0028)
class UFontImportOptions : public UObject
{
public:
	struct FFontImportOptionsData                      Data;                                                     // 0x0028(0x00B0) (CPF_Edit)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.FontImportOptions");
		return ptr;
	}

};


// Class Engine.ForceFeedbackAttenuation
// 0x00A8 (0x00D0 - 0x0028)
class UForceFeedbackAttenuation : public UObject
{
public:
	struct FForceFeedbackAttenuationSettings           Attenuation;                                              // 0x0028(0x00A8) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ForceFeedbackAttenuation");
		return ptr;
	}

};


// Class Engine.ForceFeedbackComponent
// 0x00E0 (0x0370 - 0x0290)
class UForceFeedbackComponent : public USceneComponent
{
public:
	class UForceFeedbackEffect*                        ForceFeedbackEffect;                                      // 0x0290(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bAutoDestroy : 1;                                         // 0x0298(0x0001)
	unsigned char                                      bStopWhenOwnerDestroyed : 1;                              // 0x0298(0x0001)
	unsigned char                                      bLooping : 1;                                             // 0x0298(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bIgnoreTimeDilation : 1;                                  // 0x0298(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bOverrideAttenuation : 1;                                 // 0x0298(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0299(0x0003) MISSED OFFSET
	float                                              IntensityMultiplier;                                      // 0x029C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UForceFeedbackAttenuation*                   AttenuationSettings;                                      // 0x02A0(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FForceFeedbackAttenuationSettings           AttenuationOverrides;                                     // 0x02A8(0x00A8) (CPF_Edit, CPF_BlueprintVisible)
	struct FScriptMulticastDelegate                    OnForceFeedbackFinished;                                  // 0x0350(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	unsigned char                                      UnknownData01[0x10];                                      // 0x0360(0x0010) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ForceFeedbackComponent");
		return ptr;
	}


	void Stop();
	void SetIntensityMultiplier(float NewIntensityMultiplier);
	void SetForceFeedbackEffect(class UForceFeedbackEffect* NewForceFeedbackEffect);
	void Play(float StartTime);
	bool BP_GetAttenuationSettingsToApply(struct FForceFeedbackAttenuationSettings* OutAttenuationSettings);
	void AdjustAttenuation(const struct FForceFeedbackAttenuationSettings& InAttenuationSettings);
};


// Class Engine.ForceFeedbackEffect
// 0x0018 (0x0040 - 0x0028)
class UForceFeedbackEffect : public UObject
{
public:
	TArray<struct FForceFeedbackChannelDetails>        ChannelDetails;                                           // 0x0028(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	float                                              Duration;                                                 // 0x0038(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x003C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ForceFeedbackEffect");
		return ptr;
	}

};


// Class Engine.GameEngine
// 0x0050 (0x0E60 - 0x0E10)
class UGameEngine : public UEngine
{
public:
	class UGameInstance*                               GameInstance;                                             // 0x0E10(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x48];                                      // 0x0E18(0x0048) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.GameEngine");
		return ptr;
	}

};


// Class Engine.GameNetworkManager
// 0x0088 (0x03A0 - 0x0318)
class AGameNetworkManager : public AInfo
{
public:
	int                                                AdjustedNetSpeed;                                         // 0x0318(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              LastNetSpeedUpdateTime;                                   // 0x031C(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                TotalNetBandwidth;                                        // 0x0320(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	int                                                MinDynamicBandwidth;                                      // 0x0324(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	int                                                MaxDynamicBandwidth;                                      // 0x0328(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	unsigned char                                      bIsStandbyCheckingEnabled : 1;                            // 0x032C(0x0001) (CPF_Config)
	unsigned char                                      bHasStandbyCheatTriggered : 1;                            // 0x032C(0x0001)
	unsigned char                                      UnknownData00[0x3];                                       // 0x032D(0x0003) MISSED OFFSET
	float                                              StandbyRxCheatTime;                                       // 0x0330(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              StandbyTxCheatTime;                                       // 0x0334(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                BadPingThreshold;                                         // 0x0338(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              PercentMissingForRxStandby;                               // 0x033C(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              PercentMissingForTxStandby;                               // 0x0340(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              PercentForBadPing;                                        // 0x0344(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              JoinInProgressStandbyWaitTime;                            // 0x0348(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              MoveRepSize;                                              // 0x034C(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	float                                              MAXPOSITIONERRORSQUARED;                                  // 0x0350(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	float                                              MAXNEARZEROVELOCITYSQUARED;                               // 0x0354(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	float                                              CLIENTADJUSTUPDATECOST;                                   // 0x0358(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	float                                              MAXCLIENTUPDATEINTERVAL;                                  // 0x035C(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	float                                              MaxMoveDeltaTime;                                         // 0x0360(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	float                                              ClientNetSendMoveDeltaTime;                               // 0x0364(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	float                                              ClientNetSendMoveDeltaTimeThrottled;                      // 0x0368(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	int                                                ClientNetSendMoveThrottleAtNetSpeed;                      // 0x036C(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	int                                                ClientNetSendMoveThrottleOverPlayerCount;                 // 0x0370(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	bool                                               ClientAuthorativePosition;                                // 0x0374(0x0001) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x3];                                       // 0x0375(0x0003) MISSED OFFSET
	float                                              ClientErrorUpdateRateLimit;                               // 0x0378(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	bool                                               bMovementTimeDiscrepancyDetection;                        // 0x037C(0x0001) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	bool                                               bMovementTimeDiscrepancyResolution;                       // 0x037D(0x0001) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x2];                                       // 0x037E(0x0002) MISSED OFFSET
	float                                              MovementTimeDiscrepancyMaxTimeMargin;                     // 0x0380(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	float                                              MovementTimeDiscrepancyMinTimeMargin;                     // 0x0384(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	float                                              MovementTimeDiscrepancyResolutionRate;                    // 0x0388(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	float                                              MovementTimeDiscrepancyDriftAllowance;                    // 0x038C(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	bool                                               bMovementTimeDiscrepancyForceCorrectionsDuringResolution; // 0x0390(0x0001) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	bool                                               bUseDistanceBasedRelevancy;                               // 0x0391(0x0001) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0xE];                                       // 0x0392(0x000E) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.GameNetworkManager");
		return ptr;
	}

};


// Class Engine.GameplayStatics
// 0x0000 (0x0028 - 0x0028)
class UGameplayStatics : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.GameplayStatics");
		return ptr;
	}


	static void UnloadStreamLevel(class UObject* WorldContextObject, const struct FName& LevelName, const struct FLatentActionInfo& LatentInfo);
	static bool SuggestProjectileVelocity_CustomArc(class UObject* WorldContextObject, const struct FVector& StartPos, const struct FVector& EndPos, float OverrideGravityZ, float ArcParam, struct FVector* OutLaunchVelocity);
	static class UAudioComponent* SpawnSoundAttached(class USoundBase* Sound, class USceneComponent* AttachToComponent, const struct FName& AttachPointName, const struct FVector& Location, const struct FRotator& Rotation, TEnumAsByte<EAttachLocation> LocationType, bool bStopWhenAttachedToDestroyed, float VolumeMultiplier, float PitchMultiplier, float StartTime, class USoundAttenuation* AttenuationSettings, class USoundConcurrency* ConcurrencySettings, bool bAutoDestroy);
	static class UAudioComponent* SpawnSoundAtLocation(class UObject* WorldContextObject, class USoundBase* Sound, const struct FVector& Location, const struct FRotator& Rotation, float VolumeMultiplier, float PitchMultiplier, float StartTime, class USoundAttenuation* AttenuationSettings, class USoundConcurrency* ConcurrencySettings, bool bAutoDestroy);
	static class UAudioComponent* SpawnSound2D(class UObject* WorldContextObject, class USoundBase* Sound, float VolumeMultiplier, float PitchMultiplier, float StartTime, class USoundConcurrency* ConcurrencySettings, bool bPersistAcrossLevelTransition, bool bAutoDestroy);
	static class UObject* SpawnObject(class UClass* ObjectClass, class UObject* Outer);
	static class UForceFeedbackComponent* SpawnForceFeedbackAttached(class UForceFeedbackEffect* ForceFeedbackEffect, class USceneComponent* AttachToComponent, const struct FName& AttachPointName, const struct FVector& Location, const struct FRotator& Rotation, TEnumAsByte<EAttachLocation> LocationType, bool bStopWhenAttachedToDestroyed, bool bLooping, float IntensityMultiplier, float StartTime, class UForceFeedbackAttenuation* AttenuationSettings, bool bAutoDestroy);
	static class UForceFeedbackComponent* SpawnForceFeedbackAtLocation(class UObject* WorldContextObject, class UForceFeedbackEffect* ForceFeedbackEffect, const struct FVector& Location, const struct FRotator& Rotation, bool bLooping, float IntensityMultiplier, float StartTime, class UForceFeedbackAttenuation* AttenuationSettings, bool bAutoDestroy);
	static class UParticleSystemComponent* SpawnEmitterAttached(class UParticleSystem* EmitterTemplate, class USceneComponent* AttachToComponent, const struct FName& AttachPointName, const struct FVector& Location, const struct FRotator& Rotation, const struct FVector& Scale, TEnumAsByte<EAttachLocation> LocationType, bool bAutoDestroy);
	static class UParticleSystemComponent* SpawnEmitterAtLocation(class UObject* WorldContextObject, class UParticleSystem* EmitterTemplate, const struct FVector& Location, const struct FRotator& Rotation, const struct FVector& Scale, bool bAutoDestroy);
	static class UAudioComponent* SpawnDialogueAttached(class UDialogueWave* Dialogue, const struct FDialogueContext& Context, class USceneComponent* AttachToComponent, const struct FName& AttachPointName, const struct FVector& Location, const struct FRotator& Rotation, TEnumAsByte<EAttachLocation> LocationType, bool bStopWhenAttachedToDestroyed, float VolumeMultiplier, float PitchMultiplier, float StartTime, class USoundAttenuation* AttenuationSettings, bool bAutoDestroy);
	static class UAudioComponent* SpawnDialogueAtLocation(class UObject* WorldContextObject, class UDialogueWave* Dialogue, const struct FDialogueContext& Context, const struct FVector& Location, const struct FRotator& Rotation, float VolumeMultiplier, float PitchMultiplier, float StartTime, class USoundAttenuation* AttenuationSettings, bool bAutoDestroy);
	static class UAudioComponent* SpawnDialogue2D(class UObject* WorldContextObject, class UDialogueWave* Dialogue, const struct FDialogueContext& Context, float VolumeMultiplier, float PitchMultiplier, float StartTime, bool bAutoDestroy);
	static class UDecalComponent* SpawnDecalAttached(class UMaterialInterface* DecalMaterial, const struct FVector& DecalSize, class USceneComponent* AttachToComponent, const struct FName& AttachPointName, const struct FVector& Location, const struct FRotator& Rotation, TEnumAsByte<EAttachLocation> LocationType, float LifeSpan);
	static class UDecalComponent* SpawnDecalAtLocation(class UObject* WorldContextObject, class UMaterialInterface* DecalMaterial, const struct FVector& DecalSize, const struct FVector& Location, const struct FRotator& Rotation, float LifeSpan);
	static void SetWorldOriginLocation(class UObject* WorldContextObject, const struct FIntVector& NewLocation);
	static void SetSubtitlesEnabled(bool bEnabled);
	static void SetSoundMixClassOverride(class UObject* WorldContextObject, class USoundMix* InSoundMixModifier, class USoundClass* InSoundClass, float Volume, float Pitch, float FadeInTime, bool bApplyToChildren);
	static void SetPlayerControllerID(class APlayerController* Player, int ControllerId);
	static void SetGlobalTimeDilation(class UObject* WorldContextObject, float TimeDilation);
	static void SetGlobalPitchModulation(class UObject* WorldContextObject, float PitchModulation, float TimeSec);
	static void SetGlobalListenerFocusParameters(class UObject* WorldContextObject, float FocusAzimuthScale, float NonFocusAzimuthScale, float FocusDistanceScale, float NonFocusDistanceScale, float FocusVolumeScale, float NonFocusVolumeScale, float FocusPriorityScale, float NonFocusPriorityScale);
	static bool SetGamePaused(class UObject* WorldContextObject, bool bPaused);
	static void SetBaseSoundMix(class UObject* WorldContextObject, class USoundMix* InSoundMix);
	static bool SaveGameToSlot(class USaveGame* SaveGameObject, const struct FString& SlotName, int UserIndex);
	static void RemovePlayer(class APlayerController* Player, bool bDestroyPawn);
	static struct FVector RebaseZeroOriginOntoLocal(class UObject* WorldContextObject, const struct FVector& WorldLocation);
	static struct FVector RebaseLocalOriginOntoZero(class UObject* WorldContextObject, const struct FVector& WorldLocation);
	static void PushSoundMixModifier(class UObject* WorldContextObject, class USoundMix* InSoundMixModifier);
	static bool ProjectWorldToScreen(class APlayerController* Player, const struct FVector& WorldPosition, bool bPlayerViewportRelative, struct FVector2D* ScreenPosition);
	static void PopSoundMixModifier(class UObject* WorldContextObject, class USoundMix* InSoundMixModifier);
	static void PlayWorldCameraShake(class UObject* WorldContextObject, class UClass* Shake, const struct FVector& Epicenter, float InnerRadius, float OuterRadius, float Falloff, bool bOrientShakeTowardsEpicenter);
	static void PlaySoundAtLocation(class UObject* WorldContextObject, class USoundBase* Sound, const struct FVector& Location, const struct FRotator& Rotation, float VolumeMultiplier, float PitchMultiplier, float StartTime, class USoundAttenuation* AttenuationSettings, class USoundConcurrency* ConcurrencySettings, class AActor* OwningActor);
	static void PlaySound2D(class UObject* WorldContextObject, class USoundBase* Sound, float VolumeMultiplier, float PitchMultiplier, float StartTime, class USoundConcurrency* ConcurrencySettings, class AActor* OwningActor);
	static void PlayDialogueAtLocation(class UObject* WorldContextObject, class UDialogueWave* Dialogue, const struct FDialogueContext& Context, const struct FVector& Location, const struct FRotator& Rotation, float VolumeMultiplier, float PitchMultiplier, float StartTime, class USoundAttenuation* AttenuationSettings);
	static void PlayDialogue2D(class UObject* WorldContextObject, class UDialogueWave* Dialogue, const struct FDialogueContext& Context, float VolumeMultiplier, float PitchMultiplier, float StartTime);
	static struct FString ParseOption(const struct FString& Options, const struct FString& Key);
	static void OpenLevel(class UObject* WorldContextObject, const struct FName& LevelName, bool bAbsolute, const struct FString& Options);
	static struct FHitResult MakeHitResult(bool bBlockingHit, bool bInitialOverlap, float Time, float Distance, const struct FVector& Location, const struct FVector& ImpactPoint, const struct FVector& Normal, const struct FVector& ImpactNormal, class UPhysicalMaterial* PhysMat, class AActor* HitActor, class UPrimitiveComponent* HitComponent, const struct FName& HitBoneName, int HitItem, int FaceIndex, const struct FVector& TraceStart, const struct FVector& TraceEnd);
	static void LoadStreamLevel(class UObject* WorldContextObject, const struct FName& LevelName, bool bMakeVisibleAfterLoad, bool bShouldBlockOnLoad, const struct FLatentActionInfo& LatentInfo);
	static class USaveGame* LoadGameFromSlot(const struct FString& SlotName, int UserIndex);
	static bool IsGamePaused(class UObject* WorldContextObject);
	static bool HasOption(const struct FString& Options, const struct FString& InKey);
	static bool HasLaunchOption(const struct FString& OptionToCheck);
	static int GrassOverlappingSphereCount(class UObject* WorldContextObject, class UStaticMesh* StaticMesh, const struct FVector& CenterPosition, float Radius);
	static struct FIntVector GetWorldOriginLocation(class UObject* WorldContextObject);
	static float GetWorldDeltaSeconds(class UObject* WorldContextObject);
	static float GetUnpausedTimeSeconds(class UObject* WorldContextObject);
	static float GetTimeSeconds(class UObject* WorldContextObject);
	static TEnumAsByte<EPhysicalSurface> GetSurfaceType(const struct FHitResult& Hit);
	static class ULevelStreaming* GetStreamingLevel(class UObject* WorldContextObject, const struct FName& PackageName);
	static float GetRealTimeSeconds(class UObject* WorldContextObject);
	static class APawn* GetPlayerPawn(class UObject* WorldContextObject, int PlayerIndex);
	static int GetPlayerControllerID(class APlayerController* Player);
	static class APlayerController* GetPlayerController(class UObject* WorldContextObject, int PlayerIndex);
	static class ACharacter* GetPlayerCharacter(class UObject* WorldContextObject, int PlayerIndex);
	static class APlayerCameraManager* GetPlayerCameraManager(class UObject* WorldContextObject, int PlayerIndex);
	static struct FString GetPlatformName();
	static class UClass* GetObjectClass(class UObject* Object);
	static void GetKeyValue(const struct FString& Pair, struct FString* Key, struct FString* Value);
	static int GetIntOption(const struct FString& Options, const struct FString& Key, int DefaultValue);
	static float GetGlobalTimeDilation(class UObject* WorldContextObject);
	static class AGameStateBase* GetGameState(class UObject* WorldContextObject);
	static class AGameModeBase* GetGameMode(class UObject* WorldContextObject);
	static class UGameInstance* GetGameInstance(class UObject* WorldContextObject);
	static class UReverbEffect* GetCurrentReverbEffect(class UObject* WorldContextObject);
	static struct FString GetCurrentLevelName(class UObject* WorldContextObject, bool bRemovePrefixString);
	static float GetAudioTimeSeconds(class UObject* WorldContextObject);
	static void GetAllActorsWithTag(class UObject* WorldContextObject, const struct FName& Tag, TArray<class AActor*>* OutActors);
	static void GetAllActorsWithInterface(class UObject* WorldContextObject, class UClass* Interface, TArray<class AActor*>* OutActors);
	static void GetAllActorsOfClass(class UObject* WorldContextObject, class UClass* ActorClass, TArray<class AActor*>* OutActors);
	static void GetActorArrayBounds(TArray<class AActor*> Actors, bool bOnlyCollidingComponents, struct FVector* Center, struct FVector* BoxExtent);
	static struct FVector GetActorArrayAverageLocation(TArray<class AActor*> Actors);
	static void GetAccurateRealTime(class UObject* WorldContextObject, int* Seconds, float* PartialSeconds);
	static void FlushLevelStreaming(class UObject* WorldContextObject);
	static class AActor* FinishSpawningActor(class AActor* Actor, const struct FTransform& SpawnTransform);
	static bool FindCollisionUV(const struct FHitResult& Hit, int UVChannel, struct FVector2D* UV);
	static void EnableLiveStreaming(bool Enable);
	static bool DoesSaveGameExist(const struct FString& SlotName, int UserIndex);
	static bool DeprojectScreenToWorld(class APlayerController* Player, const struct FVector2D& ScreenPosition, struct FVector* WorldPosition, struct FVector* WorldDirection);
	static bool DeleteGameInSlot(const struct FString& SlotName, int UserIndex);
	static void DeactivateReverbEffect(class UObject* WorldContextObject, const struct FName& TagName);
	static class UAudioComponent* CreateSound2D(class UObject* WorldContextObject, class USoundBase* Sound, float VolumeMultiplier, float PitchMultiplier, float StartTime, class USoundConcurrency* ConcurrencySettings, bool bPersistAcrossLevelTransition, bool bAutoDestroy);
	static class USaveGame* CreateSaveGameObjectFromBlueprint(class UBlueprint* SaveGameBlueprint);
	static class USaveGame* CreateSaveGameObject(class UClass* SaveGameClass);
	static class APlayerController* CreatePlayer(class UObject* WorldContextObject, int ControllerId, bool bSpawnPawn);
	static void ClearSoundMixModifiers(class UObject* WorldContextObject);
	static void ClearSoundMixClassOverride(class UObject* WorldContextObject, class USoundMix* InSoundMixModifier, class USoundClass* InSoundClass, float FadeOutTime);
	static void CancelAsyncLoading();
	static void BreakHitResult(const struct FHitResult& Hit, bool* bBlockingHit, bool* bInitialOverlap, float* Time, float* Distance, struct FVector* Location, struct FVector* ImpactPoint, struct FVector* Normal, struct FVector* ImpactNormal, class UPhysicalMaterial** PhysMat, class AActor** HitActor, class UPrimitiveComponent** HitComponent, struct FName* HitBoneName, int* HitItem, int* FaceIndex, struct FVector* TraceStart, struct FVector* TraceEnd);
	static bool BlueprintSuggestProjectileVelocity(class UObject* WorldContextObject, const struct FVector& startLocation, const struct FVector& EndLocation, float LaunchSpeed, float OverrideGravityZ, TEnumAsByte<ESuggestProjVelocityTraceOption> TraceOption, float CollisionRadius, bool bFavorHighArc, bool bDrawDebug, struct FVector* TossVelocity);
	static bool Blueprint_PredictProjectilePath_ByTraceChannel(class UObject* WorldContextObject, const struct FVector& StartPos, const struct FVector& LaunchVelocity, bool bTracePath, float ProjectileRadius, TEnumAsByte<ECollisionChannel> TraceChannel, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, float DrawDebugTime, float SimFrequency, float MaxSimTime, float OverrideGravityZ, struct FHitResult* OutHit, TArray<struct FVector>* OutPathPositions, struct FVector* OutLastTraceDestination);
	static bool Blueprint_PredictProjectilePath_ByObjectType(class UObject* WorldContextObject, const struct FVector& StartPos, const struct FVector& LaunchVelocity, bool bTracePath, float ProjectileRadius, TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, float DrawDebugTime, float SimFrequency, float MaxSimTime, float OverrideGravityZ, struct FHitResult* OutHit, TArray<struct FVector>* OutPathPositions, struct FVector* OutLastTraceDestination);
	static bool Blueprint_PredictProjectilePath_Advanced(class UObject* WorldContextObject, const struct FPredictProjectilePathParams& PredictParams, struct FPredictProjectilePathResult* PredictResult);
	static class AActor* BeginSpawningActorFromClass(class UObject* WorldContextObject, class UClass* ActorClass, const struct FTransform& SpawnTransform, bool bNoCollisionFail, class AActor* Owner);
	static class AActor* BeginSpawningActorFromBlueprint(class UObject* WorldContextObject, class UBlueprint* Blueprint, const struct FTransform& SpawnTransform, bool bNoCollisionFail);
	static class AActor* BeginDeferredActorSpawnFromClass(class UObject* WorldContextObject, class UClass* ActorClass, const struct FTransform& SpawnTransform, ESpawnActorCollisionHandlingMethod CollisionHandlingOverride, class AActor* Owner);
	static bool AreSubtitlesEnabled();
	static bool AreAnyListenersWithinRange(class UObject* WorldContextObject, const struct FVector& Location, float MaximumRange);
	static bool ApplyRadialDamageWithFalloff(class UObject* WorldContextObject, float BaseDamage, float MinimumDamage, const struct FVector& Origin, float DamageInnerRadius, float DamageOuterRadius, float DamageFalloff, class UClass* DamageTypeClass, TArray<class AActor*> IgnoreActors, class AActor* DamageCauser, class AController* InstigatedByController, TEnumAsByte<ECollisionChannel> DamagePreventionChannel);
	static bool ApplyRadialDamage(class UObject* WorldContextObject, float BaseDamage, const struct FVector& Origin, float DamageRadius, class UClass* DamageTypeClass, TArray<class AActor*> IgnoreActors, class AActor* DamageCauser, class AController* InstigatedByController, bool bDoFullDamage, TEnumAsByte<ECollisionChannel> DamagePreventionChannel);
	static float ApplyPointDamage(class AActor* DamagedActor, float BaseDamage, const struct FVector& HitFromDirection, const struct FHitResult& HitInfo, class AController* eventInstigator, class AActor* DamageCauser, class UClass* DamageTypeClass);
	static float ApplyDamage(class AActor* DamagedActor, float BaseDamage, class AController* eventInstigator, class AActor* DamageCauser, class UClass* DamageTypeClass);
	static void ActivateReverbEffect(class UObject* WorldContextObject, class UReverbEffect* ReverbEffect, const struct FName& TagName, float Priority, float Volume, float FadeTime);
};


// Class Engine.GameUserSettings
// 0x00E0 (0x0108 - 0x0028)
class UGameUserSettings : public UObject
{
public:
	bool                                               bUseVSync;                                                // 0x0028(0x0001) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bUseDynamicResolution;                                    // 0x0029(0x0001) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4E];                                      // 0x002A(0x004E) MISSED OFFSET
	uint32_t                                           ResolutionSizeX;                                          // 0x0078(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	uint32_t                                           ResolutionSizeY;                                          // 0x007C(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	uint32_t                                           LastUserConfirmedResolutionSizeX;                         // 0x0080(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	uint32_t                                           LastUserConfirmedResolutionSizeY;                         // 0x0084(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                WindowPosX;                                               // 0x0088(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                WindowPosY;                                               // 0x008C(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                FullscreenMode;                                           // 0x0090(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                LastConfirmedFullscreenMode;                              // 0x0094(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                PreferredFullscreenMode;                                  // 0x0098(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	uint32_t                                           Version;                                                  // 0x009C(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	int                                                AudioQualityLevel;                                        // 0x00A0(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              FrameRateLimit;                                           // 0x00A4(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x00A8(0x0004) MISSED OFFSET
	int                                                DesiredScreenWidth;                                       // 0x00AC(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bUseDesiredScreenHeight;                                  // 0x00B0(0x0001) (CPF_ZeroConstructor, CPF_Config, CPF_GlobalConfig, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x3];                                       // 0x00B1(0x0003) MISSED OFFSET
	int                                                DesiredScreenHeight;                                      // 0x00B4(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              LastRecommendedScreenWidth;                               // 0x00B8(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              LastRecommendedScreenHeight;                              // 0x00BC(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              LastCPUBenchmarkResult;                                   // 0x00C0(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              LastGPUBenchmarkResult;                                   // 0x00C4(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	TArray<float>                                      LastCPUBenchmarkSteps;                                    // 0x00C8(0x0010) (CPF_ZeroConstructor, CPF_Config)
	TArray<float>                                      LastGPUBenchmarkSteps;                                    // 0x00D8(0x0010) (CPF_ZeroConstructor, CPF_Config)
	float                                              LastGPUBenchmarkMultiplier;                               // 0x00E8(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bUseHDRDisplayOutput;                                     // 0x00EC(0x0001) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0x3];                                       // 0x00ED(0x0003) MISSED OFFSET
	int                                                HDRDisplayOutputNits;                                     // 0x00F0(0x0004) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData04[0x4];                                       // 0x00F4(0x0004) MISSED OFFSET
	struct FScriptMulticastDelegate                    OnGameUserSettingsUINeedsUpdate;                          // 0x00F8(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.GameUserSettings");
		return ptr;
	}


	void ValidateSettings();
	bool SupportsHDRDisplayOutput();
	void SetVSyncEnabled(bool bEnable);
	void SetVisualEffectQuality(int Value);
	void SetViewDistanceQuality(int Value);
	void SetToDefaults();
	void SetTextureQuality(int Value);
	void SetShadowQuality(int Value);
	void SetScreenResolution(const struct FIntPoint& Resolution);
	void SetResolutionScaleValueEx(float NewScaleValue);
	void SetResolutionScaleValue(int NewScaleValue);
	void SetResolutionScaleNormalized(float NewScaleNormalized);
	void SetPostProcessingQuality(int Value);
	void SetOverallScalabilityLevel(int Value);
	void SetFullscreenMode(TEnumAsByte<EWindowMode> InFullscreenMode);
	void SetFrameRateLimit(float NewLimit);
	void SetFoliageQuality(int Value);
	void SetDynamicResolutionEnabled(bool bEnable);
	void SetBenchmarkFallbackValues();
	void SetAudioQualityLevel(int QualityLevel);
	void SetAntiAliasingQuality(int Value);
	void SaveSettings();
	void RunHardwareBenchmark(int WorkScale, float CPUMultiplier, float GPUMultiplier);
	void RevertVideoMode();
	void ResetToCurrentSettings();
	void LoadSettings(bool bForceReload);
	bool IsVSyncEnabled();
	bool IsVSyncDirty();
	bool IsScreenResolutionDirty();
	bool IsHDREnabled();
	bool IsFullscreenModeDirty();
	bool IsDynamicResolutionEnabled();
	bool IsDynamicResolutionDirty();
	bool IsDirty();
	int GetVisualEffectQuality();
	int GetViewDistanceQuality();
	int GetTextureQuality();
	int GetShadowQuality();
	struct FIntPoint GetScreenResolution();
	void GetResolutionScaleInformationEx(float* CurrentScaleNormalized, float* CurrentScaleValue, float* MinScaleValue, float* MaxScaleValue);
	void GetResolutionScaleInformation(float* CurrentScaleNormalized, int* CurrentScaleValue, int* MinScaleValue, int* MaxScaleValue);
	float GetRecommendedResolutionScale();
	TEnumAsByte<EWindowMode> GetPreferredFullscreenMode();
	int GetPostProcessingQuality();
	int GetOverallScalabilityLevel();
	struct FIntPoint GetLastConfirmedScreenResolution();
	TEnumAsByte<EWindowMode> GetLastConfirmedFullscreenMode();
	static class UGameUserSettings* GetGameUserSettings();
	TEnumAsByte<EWindowMode> GetFullscreenMode();
	float GetFrameRateLimit();
	int GetFoliageQuality();
	struct FIntPoint GetDesktopResolution();
	static struct FIntPoint GetDefaultWindowPosition();
	static TEnumAsByte<EWindowMode> GetDefaultWindowMode();
	float GetDefaultResolutionScale();
	static struct FIntPoint GetDefaultResolution();
	int GetCurrentHDRDisplayNits();
	int GetAudioQualityLevel();
	int GetAntiAliasingQuality();
	void EnableHDRDisplayOutput(bool bEnable, int DisplayNits);
	void ConfirmVideoMode();
	void ApplySettings(bool bCheckForCommandLineOverrides);
	void ApplyResolutionSettings(bool bCheckForCommandLineOverrides);
	void ApplyNonResolutionSettings();
	void ApplyHardwareBenchmarkResults();
};


// Class Engine.SpotLight
// 0x0008 (0x0330 - 0x0328)
class ASpotLight : public ALight
{
public:
	class USpotLightComponent*                         SpotLightComponent;                                       // 0x0328(0x0008) (CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.SpotLight");
		return ptr;
	}


	void SetOuterConeAngle(float NewOuterConeAngle);
	void SetInnerConeAngle(float NewInnerConeAngle);
};


// Class Engine.GeneratedMeshAreaLight
// 0x0000 (0x0330 - 0x0330)
class AGeneratedMeshAreaLight : public ASpotLight
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.GeneratedMeshAreaLight");
		return ptr;
	}

};


// Class Engine.HapticFeedbackEffect_Base
// 0x0000 (0x0028 - 0x0028)
class UHapticFeedbackEffect_Base : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.HapticFeedbackEffect_Base");
		return ptr;
	}

};


// Class Engine.HapticFeedbackEffect_Buffer
// 0x0040 (0x0068 - 0x0028)
class UHapticFeedbackEffect_Buffer : public UHapticFeedbackEffect_Base
{
public:
	TArray<unsigned char>                              Amplitudes;                                               // 0x0028(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	int                                                SampleRate;                                               // 0x0038(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x2C];                                      // 0x003C(0x002C) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.HapticFeedbackEffect_Buffer");
		return ptr;
	}

};


// Class Engine.HapticFeedbackEffect_Curve
// 0x00F0 (0x0118 - 0x0028)
class UHapticFeedbackEffect_Curve : public UHapticFeedbackEffect_Base
{
public:
	struct FHapticFeedbackDetails_Curve                HapticDetails;                                            // 0x0028(0x00F0) (CPF_Edit)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.HapticFeedbackEffect_Curve");
		return ptr;
	}

};


// Class Engine.HapticFeedbackEffect_SoundWave
// 0x0038 (0x0060 - 0x0028)
class UHapticFeedbackEffect_SoundWave : public UHapticFeedbackEffect_Base
{
public:
	class USoundWave*                                  SoundWave;                                                // 0x0028(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x30];                                      // 0x0030(0x0030) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.HapticFeedbackEffect_SoundWave");
		return ptr;
	}

};


// Class Engine.AmbisonicsSubmixSettingsBase
// 0x0000 (0x0028 - 0x0028)
class UAmbisonicsSubmixSettingsBase : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.AmbisonicsSubmixSettingsBase");
		return ptr;
	}

};


// Class Engine.SpatializationPluginSourceSettingsBase
// 0x0000 (0x0028 - 0x0028)
class USpatializationPluginSourceSettingsBase : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.SpatializationPluginSourceSettingsBase");
		return ptr;
	}

};


// Class Engine.OcclusionPluginSourceSettingsBase
// 0x0000 (0x0028 - 0x0028)
class UOcclusionPluginSourceSettingsBase : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.OcclusionPluginSourceSettingsBase");
		return ptr;
	}

};


// Class Engine.ReverbPluginSourceSettingsBase
// 0x0000 (0x0028 - 0x0028)
class UReverbPluginSourceSettingsBase : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ReverbPluginSourceSettingsBase");
		return ptr;
	}

};


// Class Engine.ImportanceSamplingLibrary
// 0x0000 (0x0028 - 0x0028)
class UImportanceSamplingLibrary : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ImportanceSamplingLibrary");
		return ptr;
	}


	static float RandomSobolFloat(int Index, int Dimension, float Seed);
	static struct FVector RandomSobolCell3D(int Index, int NumCells, const struct FVector& Cell, const struct FVector& Seed);
	static struct FVector2D RandomSobolCell2D(int Index, int NumCells, const struct FVector2D& Cell, const struct FVector2D& Seed);
	static float NextSobolFloat(int Index, int Dimension, float PreviousValue);
	static struct FVector NextSobolCell3D(int Index, int NumCells, const struct FVector& PreviousValue);
	static struct FVector2D NextSobolCell2D(int Index, int NumCells, const struct FVector2D& PreviousValue);
	static struct FImportanceTexture MakeImportanceTexture(class UTexture2D* Texture, TEnumAsByte<EImportanceWeight> WeightingFunc);
	static void ImportanceSample(const struct FImportanceTexture& Texture, const struct FVector2D& Rand, int Samples, float Intensity, struct FVector2D* SamplePosition, struct FLinearColor* SampleColor, float* SampleIntensity, float* SampleSize);
	static void BreakImportanceTexture(const struct FImportanceTexture& ImportanceTexture, class UTexture2D** Texture, TEnumAsByte<EImportanceWeight>* WeightingFunc);
};


// Class Engine.ImportantToggleSettingInterface
// 0x0000 (0x0028 - 0x0028)
class UImportantToggleSettingInterface : public UInterface
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ImportantToggleSettingInterface");
		return ptr;
	}

};


// Class Engine.InGameAdManager
// 0x0028 (0x0060 - 0x0038)
class UInGameAdManager : public UPlatformInterfaceBase
{
public:
	unsigned char                                      bShouldPauseWhileAdOpen : 1;                              // 0x0038(0x0001)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0039(0x0007) MISSED OFFSET
	TArray<struct FScriptDelegate>                     ClickedBannerDelegates;                                   // 0x0040(0x0010) (CPF_ZeroConstructor)
	TArray<struct FScriptDelegate>                     ClosedAdDelegates;                                        // 0x0050(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InGameAdManager");
		return ptr;
	}

};


// Class Engine.InheritableComponentHandler
// 0x0020 (0x0048 - 0x0028)
class UInheritableComponentHandler : public UObject
{
public:
	TArray<struct FComponentOverrideRecord>            Records;                                                  // 0x0028(0x0010) (CPF_ZeroConstructor)
	TArray<class UActorComponent*>                     UnnecessaryComponents;                                    // 0x0038(0x0010) (CPF_ExportObject, CPF_ZeroConstructor, CPF_Transient)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InheritableComponentHandler");
		return ptr;
	}

};


// Class Engine.InputDelegateBinding
// 0x0000 (0x0028 - 0x0028)
class UInputDelegateBinding : public UDynamicBlueprintBinding
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InputDelegateBinding");
		return ptr;
	}

};


// Class Engine.InputActionDelegateBinding
// 0x0010 (0x0038 - 0x0028)
class UInputActionDelegateBinding : public UInputDelegateBinding
{
public:
	TArray<struct FBlueprintInputActionDelegateBinding> InputActionDelegateBindings;                              // 0x0028(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InputActionDelegateBinding");
		return ptr;
	}

};


// Class Engine.InputAxisDelegateBinding
// 0x0010 (0x0038 - 0x0028)
class UInputAxisDelegateBinding : public UInputDelegateBinding
{
public:
	TArray<struct FBlueprintInputAxisDelegateBinding>  InputAxisDelegateBindings;                                // 0x0028(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InputAxisDelegateBinding");
		return ptr;
	}

};


// Class Engine.InputAxisKeyDelegateBinding
// 0x0010 (0x0038 - 0x0028)
class UInputAxisKeyDelegateBinding : public UInputDelegateBinding
{
public:
	TArray<struct FBlueprintInputAxisKeyDelegateBinding> InputAxisKeyDelegateBindings;                             // 0x0028(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InputAxisKeyDelegateBinding");
		return ptr;
	}

};


// Class Engine.InputComponent
// 0x0078 (0x0168 - 0x00F0)
class UInputComponent : public UActorComponent
{
public:
	unsigned char                                      UnknownData00[0x78];                                      // 0x00F0(0x0078) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InputComponent");
		return ptr;
	}


	bool WasControllerKeyJustReleased(const struct FKey& Key);
	bool WasControllerKeyJustPressed(const struct FKey& Key);
	bool IsControllerKeyDown(const struct FKey& Key);
	void GetTouchState(int FingerIndex, float* LocationX, float* LocationY, bool* bIsCurrentlyPressed);
	struct FVector GetControllerVectorKeyState(const struct FKey& Key);
	void GetControllerMouseDelta(float* DeltaX, float* DeltaY);
	float GetControllerKeyTimeDown(const struct FKey& Key);
	void GetControllerAnalogStickState(TEnumAsByte<EControllerAnalogStick> WhichStick, float* StickX, float* StickY);
	float GetControllerAnalogKeyState(const struct FKey& Key);
};


// Class Engine.InputKeyDelegateBinding
// 0x0010 (0x0038 - 0x0028)
class UInputKeyDelegateBinding : public UInputDelegateBinding
{
public:
	TArray<struct FBlueprintInputKeyDelegateBinding>   InputKeyDelegateBindings;                                 // 0x0028(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InputKeyDelegateBinding");
		return ptr;
	}

};


// Class Engine.InputSettings
// 0x0088 (0x00B0 - 0x0028)
class UInputSettings : public UObject
{
public:
	TArray<struct FInputAxisConfigEntry>               AxisConfig;                                               // 0x0028(0x0010) (CPF_Edit, CPF_EditFixedSize, CPF_ZeroConstructor, CPF_Config)
	unsigned char                                      bAltEnterTogglesFullscreen : 1;                           // 0x0038(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bF11TogglesFullscreen : 1;                                // 0x0038(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bUseMouseForTouch : 1;                                    // 0x0038(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bEnableMouseSmoothing : 1;                                // 0x0038(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bEnableFOVScaling : 1;                                    // 0x0038(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0039(0x0003) MISSED OFFSET
	float                                              FOVScale;                                                 // 0x003C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              DoubleClickTime;                                          // 0x0040(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bCaptureMouseOnLaunch;                                    // 0x0044(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	EMouseCaptureMode                                  DefaultViewportMouseCaptureMode;                          // 0x0045(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bDefaultViewportMouseLock;                                // 0x0046(0x0001) (CPF_ZeroConstructor, CPF_Config, CPF_Deprecated, CPF_IsPlainOldData)
	EMouseLockMode                                     DefaultViewportMouseLockMode;                             // 0x0047(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	TArray<struct FInputActionKeyMapping>              ActionMappings;                                           // 0x0048(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	TArray<struct FInputAxisKeyMapping>                AxisMappings;                                             // 0x0058(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	bool                                               bAlwaysShowTouchInterface;                                // 0x0068(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	bool                                               bShowConsoleOnFourFingerTap;                              // 0x0069(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x6];                                       // 0x006A(0x0006) MISSED OFFSET
	struct FSoftObjectPath                             DefaultTouchInterface;                                    // 0x0070(0x0018) (CPF_Edit, CPF_Config)
	struct FKey                                        ConsoleKey;                                               // 0x0088(0x0018) (CPF_Config, CPF_Deprecated)
	TArray<struct FKey>                                ConsoleKeys;                                              // 0x00A0(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InputSettings");
		return ptr;
	}


	void SaveKeyMappings();
	void RemoveAxisMapping(const struct FInputAxisKeyMapping& KeyMapping, bool bForceRebuildKeymaps);
	void RemoveActionMapping(const struct FInputActionKeyMapping& KeyMapping, bool bForceRebuildKeymaps);
	static class UInputSettings* GetInputSettings();
	void GetAxisNames(TArray<struct FName>* AxisNames);
	void GetAxisMappingByName(const struct FName& InAxisName, TArray<struct FInputAxisKeyMapping>* OutMappings);
	void GetActionNames(TArray<struct FName>* ActionNames);
	void GetActionMappingByName(const struct FName& InActionName, TArray<struct FInputActionKeyMapping>* OutMappings);
	void ForceRebuildKeymaps();
	void AddAxisMapping(const struct FInputAxisKeyMapping& KeyMapping, bool bForceRebuildKeymaps);
	void AddActionMapping(const struct FInputActionKeyMapping& KeyMapping, bool bForceRebuildKeymaps);
};


// Class Engine.InputTouchDelegateBinding
// 0x0010 (0x0038 - 0x0028)
class UInputTouchDelegateBinding : public UInputDelegateBinding
{
public:
	TArray<struct FBlueprintInputTouchDelegateBinding> InputTouchDelegateBindings;                               // 0x0028(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InputTouchDelegateBinding");
		return ptr;
	}

};


// Class Engine.InputVectorAxisDelegateBinding
// 0x0000 (0x0038 - 0x0038)
class UInputVectorAxisDelegateBinding : public UInputAxisKeyDelegateBinding
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InputVectorAxisDelegateBinding");
		return ptr;
	}

};


// Class Engine.Interface_AssetUserData
// 0x0000 (0x0028 - 0x0028)
class UInterface_AssetUserData : public UInterface
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Interface_AssetUserData");
		return ptr;
	}

};


// Class Engine.Interface_CollisionDataProvider
// 0x0000 (0x0028 - 0x0028)
class UInterface_CollisionDataProvider : public UInterface
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Interface_CollisionDataProvider");
		return ptr;
	}

};


// Class Engine.Interface_PostProcessVolume
// 0x0000 (0x0028 - 0x0028)
class UInterface_PostProcessVolume : public UInterface
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Interface_PostProcessVolume");
		return ptr;
	}

};


// Class Engine.InterpCurveEdSetup
// 0x0018 (0x0040 - 0x0028)
class UInterpCurveEdSetup : public UObject
{
public:
	TArray<struct FCurveEdTab>                         Tabs;                                                     // 0x0028(0x0010) (CPF_ZeroConstructor)
	int                                                ActiveTab;                                                // 0x0038(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x003C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpCurveEdSetup");
		return ptr;
	}

};


// Class Engine.InterpData
// 0x0048 (0x0070 - 0x0028)
class UInterpData : public UObject
{
public:
	float                                              InterpLength;                                             // 0x0028(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)
	float                                              PathBuildTime;                                            // 0x002C(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<class UInterpGroup*>                        InterpGroups;                                             // 0x0030(0x0010) (CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor)
	class UInterpCurveEdSetup*                         CurveEdSetup;                                             // 0x0040(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              EdSectionStart;                                           // 0x0048(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              EdSectionEnd;                                             // 0x004C(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bShouldBakeAndPrune : 1;                                  // 0x0050(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0051(0x0007) MISSED OFFSET
	class UInterpGroupDirector*                        CachedDirectorGroup;                                      // 0x0058(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	TArray<struct FName>                               AllEventNames;                                            // 0x0060(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpData");
		return ptr;
	}

};


// Class Engine.InterpFilter
// 0x0010 (0x0038 - 0x0028)
class UInterpFilter : public UObject
{
public:
	struct FString                                     Caption;                                                  // 0x0028(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpFilter");
		return ptr;
	}

};


// Class Engine.InterpFilter_Classes
// 0x0000 (0x0038 - 0x0038)
class UInterpFilter_Classes : public UInterpFilter
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpFilter_Classes");
		return ptr;
	}

};


// Class Engine.InterpFilter_Custom
// 0x0000 (0x0038 - 0x0038)
class UInterpFilter_Custom : public UInterpFilter
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpFilter_Custom");
		return ptr;
	}

};


// Class Engine.InterpGroup
// 0x0028 (0x0050 - 0x0028)
class UInterpGroup : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET
	TArray<class UInterpTrack*>                        InterpTracks;                                             // 0x0030(0x0010) (CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor)
	struct FName                                       GroupName;                                                // 0x0040(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FColor                                      GroupColor;                                               // 0x0048(0x0004) (CPF_Edit, CPF_IsPlainOldData)
	unsigned char                                      bCollapsed : 1;                                           // 0x004C(0x0001)
	unsigned char                                      bVisible : 1;                                             // 0x004C(0x0001) (CPF_Transient)
	unsigned char                                      bIsFolder : 1;                                            // 0x004C(0x0001)
	unsigned char                                      bIsParented : 1;                                          // 0x004C(0x0001)
	unsigned char                                      bIsSelected : 1;                                          // 0x004C(0x0001) (CPF_Transient)
	unsigned char                                      UnknownData01[0x3];                                       // 0x004D(0x0003) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpGroup");
		return ptr;
	}

};


// Class Engine.InterpGroupCamera
// 0x0010 (0x0060 - 0x0050)
class UInterpGroupCamera : public UInterpGroup
{
public:
	class UCameraAnim*                                 CameraAnimInst;                                           // 0x0050(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              CompressTolerance;                                        // 0x0058(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x005C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpGroupCamera");
		return ptr;
	}

};


// Class Engine.InterpGroupDirector
// 0x0000 (0x0050 - 0x0050)
class UInterpGroupDirector : public UInterpGroup
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpGroupDirector");
		return ptr;
	}

};


// Class Engine.InterpGroupInst
// 0x0020 (0x0048 - 0x0028)
class UInterpGroupInst : public UObject
{
public:
	class UInterpGroup*                                Group;                                                    // 0x0028(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class AActor*                                      GroupActor;                                               // 0x0030(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<class UInterpTrackInst*>                    TrackInst;                                                // 0x0038(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpGroupInst");
		return ptr;
	}

};


// Class Engine.InterpGroupInstCamera
// 0x0000 (0x0048 - 0x0048)
class UInterpGroupInstCamera : public UInterpGroupInst
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpGroupInstCamera");
		return ptr;
	}

};


// Class Engine.InterpGroupInstDirector
// 0x0000 (0x0048 - 0x0048)
class UInterpGroupInstDirector : public UInterpGroupInst
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpGroupInstDirector");
		return ptr;
	}

};


// Class Engine.InterpToMovementComponent
// 0x00A0 (0x01D8 - 0x0138)
class UInterpToMovementComponent : public UMovementComponent
{
public:
	float                                              Duration;                                                 // 0x0138(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bPauseOnImpact : 1;                                       // 0x013C(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData00[0x3];                                       // 0x013D(0x0003) MISSED OFFSET
	EInterpToBehaviourType                             BehaviourType;                                            // 0x0140(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x3];                                       // 0x0141(0x0003) MISSED OFFSET
	unsigned char                                      bForceSubStepping : 1;                                    // 0x0144(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData02[0x3];                                       // 0x0145(0x0003) MISSED OFFSET
	struct FScriptMulticastDelegate                    OnInterpToReverse;                                        // 0x0148(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnInterpToStop;                                           // 0x0158(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnWaitBeginDelegate;                                      // 0x0168(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnWaitEndDelegate;                                        // 0x0178(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnResetDelegate;                                          // 0x0188(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	float                                              MaxSimulationTimeStep;                                    // 0x0198(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                MaxSimulationIterations;                                  // 0x019C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<struct FInterpControlPoint>                 ControlPoints;                                            // 0x01A0(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor)
	unsigned char                                      UnknownData03[0x28];                                      // 0x01B0(0x0028) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpToMovementComponent");
		return ptr;
	}


	void StopSimulating(const struct FHitResult& HitResult);
	void RestartMovement(float InitialDirection);
	void OnInterpToWaitEndDelegate__DelegateSignature(const struct FHitResult& ImpactResult, float Time);
	void OnInterpToWaitBeginDelegate__DelegateSignature(const struct FHitResult& ImpactResult, float Time);
	void OnInterpToStopDelegate__DelegateSignature(const struct FHitResult& ImpactResult, float Time);
	void OnInterpToReverseDelegate__DelegateSignature(const struct FHitResult& ImpactResult, float Time);
	void OnInterpToResetDelegate__DelegateSignature(const struct FHitResult& ImpactResult, float Time);
	void FinaliseControlPoints();
};


// Class Engine.InterpTrack
// 0x0048 (0x0070 - 0x0028)
class UInterpTrack : public UObject
{
public:
	unsigned char                                      UnknownData00[0x10];                                      // 0x0028(0x0010) MISSED OFFSET
	TArray<class UInterpTrack*>                        SubTracks;                                                // 0x0038(0x0010) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor)
	class UClass*                                      TrackInstClass;                                           // 0x0048(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ETrackActiveCondition>                 ActiveCondition;                                          // 0x0050(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x7];                                       // 0x0051(0x0007) MISSED OFFSET
	struct FString                                     TrackTitle;                                               // 0x0058(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      bOnePerGroup : 1;                                         // 0x0068(0x0001)
	unsigned char                                      bDirGroupOnly : 1;                                        // 0x0068(0x0001)
	unsigned char                                      bDisableTrack : 1;                                        // 0x0068(0x0001)
	unsigned char                                      bIsSelected : 1;                                          // 0x0068(0x0001) (CPF_Transient)
	unsigned char                                      bIsAnimControlTrack : 1;                                  // 0x0068(0x0001)
	unsigned char                                      bSubTrackOnly : 1;                                        // 0x0068(0x0001)
	unsigned char                                      bVisible : 1;                                             // 0x0068(0x0001) (CPF_Transient)
	unsigned char                                      bIsRecording : 1;                                         // 0x0068(0x0001) (CPF_Transient)
	unsigned char                                      UnknownData02[0x7];                                       // 0x0069(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrack");
		return ptr;
	}

};


// Class Engine.InterpTrackFloatBase
// 0x0020 (0x0090 - 0x0070)
class UInterpTrackFloatBase : public UInterpTrack
{
public:
	struct FInterpCurveFloat                           FloatTrack;                                               // 0x0070(0x0018)
	float                                              CurveTension;                                             // 0x0088(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x008C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackFloatBase");
		return ptr;
	}

};


// Class Engine.InterpTrackAnimControl
// 0x0020 (0x00B0 - 0x0090)
class UInterpTrackAnimControl : public UInterpTrackFloatBase
{
public:
	struct FName                                       SlotName;                                                 // 0x0090(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<struct FAnimControlTrackKey>                AnimSeqs;                                                 // 0x0098(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      bSkipAnimNotifiers : 1;                                   // 0x00A8(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x7];                                       // 0x00A9(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackAnimControl");
		return ptr;
	}

};


// Class Engine.InterpTrackVectorBase
// 0x0020 (0x0090 - 0x0070)
class UInterpTrackVectorBase : public UInterpTrack
{
public:
	struct FInterpCurveVector                          VectorTrack;                                              // 0x0070(0x0018)
	float                                              CurveTension;                                             // 0x0088(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x008C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackVectorBase");
		return ptr;
	}

};


// Class Engine.InterpTrackAudioMaster
// 0x0000 (0x0090 - 0x0090)
class UInterpTrackAudioMaster : public UInterpTrackVectorBase
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackAudioMaster");
		return ptr;
	}

};


// Class Engine.InterpTrackBoolProp
// 0x0018 (0x0088 - 0x0070)
class UInterpTrackBoolProp : public UInterpTrack
{
public:
	TArray<struct FBoolTrackKey>                       BoolTrack;                                                // 0x0070(0x0010) (CPF_ZeroConstructor)
	struct FName                                       PropertyName;                                             // 0x0080(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackBoolProp");
		return ptr;
	}

};


// Class Engine.InterpTrackColorProp
// 0x0008 (0x0098 - 0x0090)
class UInterpTrackColorProp : public UInterpTrackVectorBase
{
public:
	struct FName                                       PropertyName;                                             // 0x0090(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackColorProp");
		return ptr;
	}

};


// Class Engine.InterpTrackColorScale
// 0x0000 (0x0090 - 0x0090)
class UInterpTrackColorScale : public UInterpTrackVectorBase
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackColorScale");
		return ptr;
	}

};


// Class Engine.InterpTrackDirector
// 0x0018 (0x0088 - 0x0070)
class UInterpTrackDirector : public UInterpTrack
{
public:
	TArray<struct FDirectorTrackCut>                   CutTrack;                                                 // 0x0070(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      bSimulateCameraCutsOnClients : 1;                         // 0x0080(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0081(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackDirector");
		return ptr;
	}

};


// Class Engine.InterpTrackEvent
// 0x0018 (0x0088 - 0x0070)
class UInterpTrackEvent : public UInterpTrack
{
public:
	TArray<struct FEventTrackKey>                      EventTrack;                                               // 0x0070(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      bFireEventsWhenForwards : 1;                              // 0x0080(0x0001) (CPF_Edit)
	unsigned char                                      bFireEventsWhenBackwards : 1;                             // 0x0080(0x0001) (CPF_Edit)
	unsigned char                                      bFireEventsWhenJumpingForwards : 1;                       // 0x0080(0x0001) (CPF_Edit)
	unsigned char                                      bUseCustomEventName : 1;                                  // 0x0080(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0081(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackEvent");
		return ptr;
	}

};


// Class Engine.InterpTrackFade
// 0x0018 (0x00A8 - 0x0090)
class UInterpTrackFade : public UInterpTrackFloatBase
{
public:
	unsigned char                                      bPersistFade : 1;                                         // 0x0090(0x0001) (CPF_Edit)
	unsigned char                                      bFadeAudio : 1;                                           // 0x0090(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0091(0x0003) MISSED OFFSET
	struct FLinearColor                                FadeColor;                                                // 0x0094(0x0010) (CPF_Edit, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x00A4(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackFade");
		return ptr;
	}

};


// Class Engine.InterpTrackFloatAnimBPParam
// 0x0020 (0x00B0 - 0x0090)
class UInterpTrackFloatAnimBPParam : public UInterpTrackFloatBase
{
public:
	class UAnimBlueprintGeneratedClass*                AnimBlueprintClass;                                       // 0x0090(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      AnimClass;                                                // 0x0098(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FName                                       ParamName;                                                // 0x00A0(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x8];                                       // 0x00A8(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackFloatAnimBPParam");
		return ptr;
	}

};


// Class Engine.InterpTrackFloatMaterialParam
// 0x0018 (0x00A8 - 0x0090)
class UInterpTrackFloatMaterialParam : public UInterpTrackFloatBase
{
public:
	TArray<class UMaterialInterface*>                  TargetMaterials;                                          // 0x0090(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	struct FName                                       ParamName;                                                // 0x00A0(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackFloatMaterialParam");
		return ptr;
	}

};


// Class Engine.InterpTrackFloatParticleParam
// 0x0008 (0x0098 - 0x0090)
class UInterpTrackFloatParticleParam : public UInterpTrackFloatBase
{
public:
	struct FName                                       ParamName;                                                // 0x0090(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackFloatParticleParam");
		return ptr;
	}

};


// Class Engine.InterpTrackFloatProp
// 0x0008 (0x0098 - 0x0090)
class UInterpTrackFloatProp : public UInterpTrackFloatBase
{
public:
	struct FName                                       PropertyName;                                             // 0x0090(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackFloatProp");
		return ptr;
	}

};


// Class Engine.InterpTrackInst
// 0x0000 (0x0028 - 0x0028)
class UInterpTrackInst : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInst");
		return ptr;
	}

};


// Class Engine.InterpTrackInstAnimControl
// 0x0008 (0x0030 - 0x0028)
class UInterpTrackInstAnimControl : public UInterpTrackInst
{
public:
	float                                              LastUpdatePosition;                                       // 0x0028(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x002C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstAnimControl");
		return ptr;
	}

};


// Class Engine.InterpTrackInstAudioMaster
// 0x0000 (0x0028 - 0x0028)
class UInterpTrackInstAudioMaster : public UInterpTrackInst
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstAudioMaster");
		return ptr;
	}

};


// Class Engine.InterpTrackInstProperty
// 0x0010 (0x0038 - 0x0028)
class UInterpTrackInstProperty : public UInterpTrackInst
{
public:
	class UProperty*                                   InterpProperty;                                           // 0x0028(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UObject*                                     PropertyOuterObjectInst;                                  // 0x0030(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstProperty");
		return ptr;
	}

};


// Class Engine.InterpTrackInstBoolProp
// 0x0018 (0x0050 - 0x0038)
class UInterpTrackInstBoolProp : public UInterpTrackInstProperty
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0038(0x0008) MISSED OFFSET
	class UBoolProperty*                               BoolProperty;                                             // 0x0040(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	bool                                               ResetBool;                                                // 0x0048(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x7];                                       // 0x0049(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstBoolProp");
		return ptr;
	}

};


// Class Engine.InterpTrackInstColorProp
// 0x0010 (0x0048 - 0x0038)
class UInterpTrackInstColorProp : public UInterpTrackInstProperty
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0038(0x0008) MISSED OFFSET
	struct FColor                                      ResetColor;                                               // 0x0040(0x0004) (CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x0044(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstColorProp");
		return ptr;
	}

};


// Class Engine.InterpTrackInstColorScale
// 0x0000 (0x0028 - 0x0028)
class UInterpTrackInstColorScale : public UInterpTrackInst
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstColorScale");
		return ptr;
	}

};


// Class Engine.InterpTrackInstDirector
// 0x0008 (0x0030 - 0x0028)
class UInterpTrackInstDirector : public UInterpTrackInst
{
public:
	class AActor*                                      OldViewTarget;                                            // 0x0028(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstDirector");
		return ptr;
	}

};


// Class Engine.InterpTrackInstEvent
// 0x0008 (0x0030 - 0x0028)
class UInterpTrackInstEvent : public UInterpTrackInst
{
public:
	float                                              LastUpdatePosition;                                       // 0x0028(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x002C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstEvent");
		return ptr;
	}

};


// Class Engine.InterpTrackInstFade
// 0x0000 (0x0028 - 0x0028)
class UInterpTrackInstFade : public UInterpTrackInst
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstFade");
		return ptr;
	}

};


// Class Engine.InterpTrackInstFloatAnimBPParam
// 0x0018 (0x0040 - 0x0028)
class UInterpTrackInstFloatAnimBPParam : public UInterpTrackInst
{
public:
	class UAnimInstance*                               AnimScriptInstance;                                       // 0x0028(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	float                                              ResetFloat;                                               // 0x0030(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0xC];                                       // 0x0034(0x000C) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstFloatAnimBPParam");
		return ptr;
	}

};


// Class Engine.InterpTrackInstFloatMaterialParam
// 0x0038 (0x0060 - 0x0028)
class UInterpTrackInstFloatMaterialParam : public UInterpTrackInst
{
public:
	TArray<class UMaterialInstanceDynamic*>            MaterialInstances;                                        // 0x0028(0x0010) (CPF_ZeroConstructor)
	TArray<float>                                      ResetFloats;                                              // 0x0038(0x0010) (CPF_ZeroConstructor)
	TArray<struct FPrimitiveMaterialRef>               PrimitiveMaterialRefs;                                    // 0x0048(0x0010) (CPF_ZeroConstructor)
	class UInterpTrackFloatMaterialParam*              InstancedTrack;                                           // 0x0058(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstFloatMaterialParam");
		return ptr;
	}

};


// Class Engine.InterpTrackInstFloatParticleParam
// 0x0008 (0x0030 - 0x0028)
class UInterpTrackInstFloatParticleParam : public UInterpTrackInst
{
public:
	float                                              ResetFloat;                                               // 0x0028(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x002C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstFloatParticleParam");
		return ptr;
	}

};


// Class Engine.InterpTrackInstFloatProp
// 0x0010 (0x0048 - 0x0038)
class UInterpTrackInstFloatProp : public UInterpTrackInstProperty
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0038(0x0008) MISSED OFFSET
	float                                              ResetFloat;                                               // 0x0040(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x0044(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstFloatProp");
		return ptr;
	}

};


// Class Engine.InterpTrackInstLinearColorProp
// 0x0018 (0x0050 - 0x0038)
class UInterpTrackInstLinearColorProp : public UInterpTrackInstProperty
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0038(0x0008) MISSED OFFSET
	struct FLinearColor                                ResetColor;                                               // 0x0040(0x0010) (CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstLinearColorProp");
		return ptr;
	}

};


// Class Engine.InterpTrackInstMove
// 0x0018 (0x0040 - 0x0028)
class UInterpTrackInstMove : public UInterpTrackInst
{
public:
	struct FVector                                     ResetLocation;                                            // 0x0028(0x000C) (CPF_IsPlainOldData)
	struct FRotator                                    ResetRotation;                                            // 0x0034(0x000C) (CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstMove");
		return ptr;
	}

};


// Class Engine.InterpTrackInstParticleReplay
// 0x0008 (0x0030 - 0x0028)
class UInterpTrackInstParticleReplay : public UInterpTrackInst
{
public:
	float                                              LastUpdatePosition;                                       // 0x0028(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x002C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstParticleReplay");
		return ptr;
	}

};


// Class Engine.InterpTrackInstSlomo
// 0x0008 (0x0030 - 0x0028)
class UInterpTrackInstSlomo : public UInterpTrackInst
{
public:
	float                                              OldTimeDilation;                                          // 0x0028(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x002C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstSlomo");
		return ptr;
	}

};


// Class Engine.InterpTrackInstSound
// 0x0010 (0x0038 - 0x0028)
class UInterpTrackInstSound : public UInterpTrackInst
{
public:
	float                                              LastUpdatePosition;                                       // 0x0028(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x002C(0x0004) MISSED OFFSET
	class UAudioComponent*                             PlayAudioComp;                                            // 0x0030(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_Transient, CPF_InstancedReference, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstSound");
		return ptr;
	}

};


// Class Engine.InterpTrackInstToggle
// 0x0010 (0x0038 - 0x0028)
class UInterpTrackInstToggle : public UInterpTrackInst
{
public:
	TEnumAsByte<ETrackToggleAction>                    action;                                                   // 0x0028(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0029(0x0003) MISSED OFFSET
	float                                              LastUpdatePosition;                                       // 0x002C(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bSavedActiveState : 1;                                    // 0x0030(0x0001)
	unsigned char                                      UnknownData01[0x7];                                       // 0x0031(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstToggle");
		return ptr;
	}

};


// Class Engine.InterpTrackInstVectorMaterialParam
// 0x0038 (0x0060 - 0x0028)
class UInterpTrackInstVectorMaterialParam : public UInterpTrackInst
{
public:
	TArray<class UMaterialInstanceDynamic*>            MaterialInstances;                                        // 0x0028(0x0010) (CPF_ZeroConstructor)
	TArray<struct FVector>                             ResetVectors;                                             // 0x0038(0x0010) (CPF_ZeroConstructor)
	TArray<struct FPrimitiveMaterialRef>               PrimitiveMaterialRefs;                                    // 0x0048(0x0010) (CPF_ZeroConstructor)
	class UInterpTrackVectorMaterialParam*             InstancedTrack;                                           // 0x0058(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstVectorMaterialParam");
		return ptr;
	}

};


// Class Engine.InterpTrackInstVectorProp
// 0x0018 (0x0050 - 0x0038)
class UInterpTrackInstVectorProp : public UInterpTrackInstProperty
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0038(0x0008) MISSED OFFSET
	struct FVector                                     ResetVector;                                              // 0x0040(0x000C) (CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x004C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstVectorProp");
		return ptr;
	}

};


// Class Engine.InterpTrackInstVisibility
// 0x0008 (0x0030 - 0x0028)
class UInterpTrackInstVisibility : public UInterpTrackInst
{
public:
	TEnumAsByte<EVisibilityTrackAction>                action;                                                   // 0x0028(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0029(0x0003) MISSED OFFSET
	float                                              LastUpdatePosition;                                       // 0x002C(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackInstVisibility");
		return ptr;
	}

};


// Class Engine.InterpTrackLinearColorBase
// 0x0020 (0x0090 - 0x0070)
class UInterpTrackLinearColorBase : public UInterpTrack
{
public:
	struct FInterpCurveLinearColor                     LinearColorTrack;                                         // 0x0070(0x0018)
	float                                              CurveTension;                                             // 0x0088(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x008C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackLinearColorBase");
		return ptr;
	}

};


// Class Engine.InterpTrackLinearColorProp
// 0x0008 (0x0098 - 0x0090)
class UInterpTrackLinearColorProp : public UInterpTrackLinearColorBase
{
public:
	struct FName                                       PropertyName;                                             // 0x0090(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackLinearColorProp");
		return ptr;
	}

};


// Class Engine.InterpTrackMove
// 0x0058 (0x00C8 - 0x0070)
class UInterpTrackMove : public UInterpTrack
{
public:
	struct FInterpCurveVector                          PosTrack;                                                 // 0x0070(0x0018) (CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	struct FInterpCurveVector                          EulerTrack;                                               // 0x0088(0x0018)
	struct FInterpLookupTrack                          LookupTrack;                                              // 0x00A0(0x0010)
	struct FName                                       LookAtGroupName;                                          // 0x00B0(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              LinCurveTension;                                          // 0x00B8(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              AngCurveTension;                                          // 0x00BC(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bUseQuatInterpolation : 1;                                // 0x00C0(0x0001) (CPF_Edit)
	unsigned char                                      bShowArrowAtKeys : 1;                                     // 0x00C0(0x0001) (CPF_Edit)
	unsigned char                                      bDisableMovement : 1;                                     // 0x00C0(0x0001) (CPF_Edit)
	unsigned char                                      bShowTranslationOnCurveEd : 1;                            // 0x00C0(0x0001) (CPF_Edit)
	unsigned char                                      bShowRotationOnCurveEd : 1;                               // 0x00C0(0x0001) (CPF_Edit)
	unsigned char                                      bHide3DTrack : 1;                                         // 0x00C0(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x3];                                       // 0x00C1(0x0003) MISSED OFFSET
	TEnumAsByte<EInterpTrackMoveRotMode>               RotMode;                                                  // 0x00C4(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x3];                                       // 0x00C5(0x0003) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackMove");
		return ptr;
	}

};


// Class Engine.InterpTrackMoveAxis
// 0x0018 (0x00A8 - 0x0090)
class UInterpTrackMoveAxis : public UInterpTrackFloatBase
{
public:
	TEnumAsByte<EInterpMoveAxis>                       MoveAxis;                                                 // 0x0090(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0091(0x0007) MISSED OFFSET
	struct FInterpLookupTrack                          LookupTrack;                                              // 0x0098(0x0010)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackMoveAxis");
		return ptr;
	}

};


// Class Engine.InterpTrackParticleReplay
// 0x0010 (0x0080 - 0x0070)
class UInterpTrackParticleReplay : public UInterpTrack
{
public:
	TArray<struct FParticleReplayTrackKey>             TrackKeys;                                                // 0x0070(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackParticleReplay");
		return ptr;
	}

};


// Class Engine.InterpTrackSlomo
// 0x0000 (0x0090 - 0x0090)
class UInterpTrackSlomo : public UInterpTrackFloatBase
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackSlomo");
		return ptr;
	}

};


// Class Engine.InterpTrackSound
// 0x0018 (0x00A8 - 0x0090)
class UInterpTrackSound : public UInterpTrackVectorBase
{
public:
	TArray<struct FSoundTrackKey>                      Sounds;                                                   // 0x0090(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      bPlayOnReverse : 1;                                       // 0x00A0(0x0001) (CPF_Edit)
	unsigned char                                      bContinueSoundOnMatineeEnd : 1;                           // 0x00A0(0x0001) (CPF_Edit)
	unsigned char                                      bSuppressSubtitles : 1;                                   // 0x00A0(0x0001) (CPF_Edit)
	unsigned char                                      bTreatAsDialogue : 1;                                     // 0x00A0(0x0001) (CPF_Edit)
	unsigned char                                      bAttach : 1;                                              // 0x00A0(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x7];                                       // 0x00A1(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackSound");
		return ptr;
	}

};


// Class Engine.InterpTrackToggle
// 0x0018 (0x0088 - 0x0070)
class UInterpTrackToggle : public UInterpTrack
{
public:
	TArray<struct FToggleTrackKey>                     ToggleTrack;                                              // 0x0070(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      bActivateSystemEachUpdate : 1;                            // 0x0080(0x0001) (CPF_Edit)
	unsigned char                                      bActivateWithJustAttachedFlag : 1;                        // 0x0080(0x0001) (CPF_Edit)
	unsigned char                                      bFireEventsWhenForwards : 1;                              // 0x0080(0x0001) (CPF_Edit)
	unsigned char                                      bFireEventsWhenBackwards : 1;                             // 0x0080(0x0001) (CPF_Edit)
	unsigned char                                      bFireEventsWhenJumpingForwards : 1;                       // 0x0080(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0081(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackToggle");
		return ptr;
	}

};


// Class Engine.InterpTrackVectorMaterialParam
// 0x0018 (0x00A8 - 0x0090)
class UInterpTrackVectorMaterialParam : public UInterpTrackVectorBase
{
public:
	TArray<class UMaterialInterface*>                  TargetMaterials;                                          // 0x0090(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	struct FName                                       ParamName;                                                // 0x00A0(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackVectorMaterialParam");
		return ptr;
	}

};


// Class Engine.InterpTrackVectorProp
// 0x0008 (0x0098 - 0x0090)
class UInterpTrackVectorProp : public UInterpTrackVectorBase
{
public:
	struct FName                                       PropertyName;                                             // 0x0090(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackVectorProp");
		return ptr;
	}

};


// Class Engine.InterpTrackVisibility
// 0x0018 (0x0088 - 0x0070)
class UInterpTrackVisibility : public UInterpTrack
{
public:
	TArray<struct FVisibilityTrackKey>                 VisibilityTrack;                                          // 0x0070(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      bFireEventsWhenForwards : 1;                              // 0x0080(0x0001) (CPF_Edit)
	unsigned char                                      bFireEventsWhenBackwards : 1;                             // 0x0080(0x0001) (CPF_Edit)
	unsigned char                                      bFireEventsWhenJumpingForwards : 1;                       // 0x0080(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0081(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.InterpTrackVisibility");
		return ptr;
	}

};


// Class Engine.IntSerialization
// 0x0028 (0x0050 - 0x0028)
class UIntSerialization : public UObject
{
public:
	uint16_t                                           UnsignedInt16Variable;                                    // 0x0028(0x0002) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x2];                                       // 0x002A(0x0002) MISSED OFFSET
	uint32_t                                           UnsignedInt32Variable;                                    // 0x002C(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	uint64_t                                           UnsignedInt64Variable;                                    // 0x0030(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	int8_t                                             SignedInt8Variable;                                       // 0x0038(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x1];                                       // 0x0039(0x0001) MISSED OFFSET
	int16_t                                            SignedInt16Variable;                                      // 0x003A(0x0002) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x4];                                       // 0x003C(0x0004) MISSED OFFSET
	int64_t                                            SignedInt64Variable;                                      // 0x0040(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnsignedInt8Variable;                                     // 0x0048(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0x3];                                       // 0x0049(0x0003) MISSED OFFSET
	int                                                SignedInt32Variable;                                      // 0x004C(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.IntSerialization");
		return ptr;
	}

};


// Class Engine.KillZVolume
// 0x0000 (0x0360 - 0x0360)
class AKillZVolume : public APhysicsVolume
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.KillZVolume");
		return ptr;
	}

};


// Class Engine.KismetArrayLibrary
// 0x0000 (0x0028 - 0x0028)
class UKismetArrayLibrary : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.KismetArrayLibrary");
		return ptr;
	}


	static void SetArrayPropertyByName(class UObject* Object, const struct FName& PropertyName, TArray<int> Value);
	static void FilterArray(TArray<class AActor*> TargetArray, class UClass* FilterClass, TArray<class AActor*>* FilteredArray);
	static void Array_Swap(TArray<int> TargetArray, int FirstIndex, int SecondIndex);
	static void Array_Shuffle(TArray<int> TargetArray);
	static void Array_Set(TArray<int> TargetArray, int Index, int Item, bool bSizeToFit);
	static void Array_Resize(TArray<int> TargetArray, int Size);
	static bool Array_RemoveItem(TArray<int> TargetArray, int Item);
	static void Array_Remove(TArray<int> TargetArray, int IndexToRemove);
	static int Array_Length(TArray<int> TargetArray);
	static int Array_LastIndex(TArray<int> TargetArray);
	static bool Array_IsValidIndex(TArray<int> TargetArray, int IndexToTest);
	static void Array_Insert(TArray<int> TargetArray, int NewItem, int Index);
	static void Array_Get(TArray<int> TargetArray, int Index, int* Item);
	static int Array_Find(TArray<int> TargetArray, int ItemToFind);
	static bool Array_Contains(TArray<int> TargetArray, int ItemToFind);
	static void Array_Clear(TArray<int> TargetArray);
	static void Array_Append(TArray<int> TargetArray, TArray<int> SourceArray);
	static int Array_AddUnique(TArray<int> TargetArray, int NewItem);
	static int Array_Add(TArray<int> TargetArray, int NewItem);
};


// Class Engine.KismetGuidLibrary
// 0x0000 (0x0028 - 0x0028)
class UKismetGuidLibrary : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.KismetGuidLibrary");
		return ptr;
	}


	static void Parse_StringToGuid(const struct FString& GuidString, struct FGuid* OutGuid, bool* Success);
	static bool NotEqual_GuidGuid(const struct FGuid& A, const struct FGuid& B);
	static struct FGuid NewGuid();
	static bool IsValid_Guid(const struct FGuid& InGuid);
	static void Invalidate_Guid(struct FGuid* InGuid);
	static bool EqualEqual_GuidGuid(const struct FGuid& A, const struct FGuid& B);
	static struct FString Conv_GuidToString(const struct FGuid& InGuid);
};


// Class Engine.KismetInputLibrary
// 0x0000 (0x0028 - 0x0028)
class UKismetInputLibrary : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.KismetInputLibrary");
		return ptr;
	}


	static bool PointerEvent_IsTouchEvent(const struct FPointerEvent& Input);
	static bool PointerEvent_IsMouseButtonDown(const struct FPointerEvent& Input, const struct FKey& MouseButton);
	static float PointerEvent_GetWheelDelta(const struct FPointerEvent& Input);
	static int PointerEvent_GetUserIndex(const struct FPointerEvent& Input);
	static int PointerEvent_GetTouchpadIndex(const struct FPointerEvent& Input);
	static struct FVector2D PointerEvent_GetScreenSpacePosition(const struct FPointerEvent& Input);
	static int PointerEvent_GetPointerIndex(const struct FPointerEvent& Input);
	static struct FVector2D PointerEvent_GetLastScreenSpacePosition(const struct FPointerEvent& Input);
	static ESlateGesture PointerEvent_GetGestureType(const struct FPointerEvent& Input);
	static struct FVector2D PointerEvent_GetGestureDelta(const struct FPointerEvent& Input);
	static struct FKey PointerEvent_GetEffectingButton(const struct FPointerEvent& Input);
	static struct FVector2D PointerEvent_GetCursorDelta(const struct FPointerEvent& Input);
	static bool Key_IsVectorAxis(const struct FKey& Key);
	static bool Key_IsMouseButton(const struct FKey& Key);
	static bool Key_IsModifierKey(const struct FKey& Key);
	static bool Key_IsKeyboardKey(const struct FKey& Key);
	static bool Key_IsGamepadKey(const struct FKey& Key);
	static bool Key_IsFloatAxis(const struct FKey& Key);
	static struct FText Key_GetDisplayName(const struct FKey& Key);
	static bool InputEvent_IsShiftDown(const struct FInputEvent& Input);
	static bool InputEvent_IsRightShiftDown(const struct FInputEvent& Input);
	static bool InputEvent_IsRightControlDown(const struct FInputEvent& Input);
	static bool InputEvent_IsRightCommandDown(const struct FInputEvent& Input);
	static bool InputEvent_IsRightAltDown(const struct FInputEvent& Input);
	static bool InputEvent_IsRepeat(const struct FInputEvent& Input);
	static bool InputEvent_IsLeftShiftDown(const struct FInputEvent& Input);
	static bool InputEvent_IsLeftControlDown(const struct FInputEvent& Input);
	static bool InputEvent_IsLeftCommandDown(const struct FInputEvent& Input);
	static bool InputEvent_IsLeftAltDown(const struct FInputEvent& Input);
	static bool InputEvent_IsControlDown(const struct FInputEvent& Input);
	static bool InputEvent_IsCommandDown(const struct FInputEvent& Input);
	static bool InputEvent_IsAltDown(const struct FInputEvent& Input);
	static int GetUserIndex(const struct FKeyEvent& Input);
	static struct FKey GetKey(const struct FKeyEvent& Input);
	static float GetAnalogValue(const struct FAnalogInputEvent& Input);
	static bool EqualEqual_KeyKey(const struct FKey& A, const struct FKey& B);
	static bool EqualEqual_InputChordInputChord(const struct FInputChord& A, const struct FInputChord& B);
	static void CalibrateTilt();
};


// Class Engine.KismetInternationalizationLibrary
// 0x0000 (0x0028 - 0x0028)
class UKismetInternationalizationLibrary : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.KismetInternationalizationLibrary");
		return ptr;
	}


	static bool SetCurrentLocale(const struct FString& Culture, bool SaveToConfig);
	static bool SetCurrentLanguageAndLocale(const struct FString& Culture, bool SaveToConfig);
	static bool SetCurrentLanguage(const struct FString& Culture, bool SaveToConfig);
	static bool SetCurrentCulture(const struct FString& Culture, bool SaveToConfig);
	static bool SetCurrentAssetGroupCulture(const struct FName& AssetGroup, const struct FString& Culture, bool SaveToConfig);
	static struct FString GetCurrentLocale();
	static struct FString GetCurrentLanguage();
	static struct FString GetCurrentCulture();
	static struct FString GetCurrentAssetGroupCulture(const struct FName& AssetGroup);
	static void ClearCurrentAssetGroupCulture(const struct FName& AssetGroup, bool SaveToConfig);
};


// Class Engine.KismetMaterialLibrary
// 0x0000 (0x0028 - 0x0028)
class UKismetMaterialLibrary : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.KismetMaterialLibrary");
		return ptr;
	}


	static void SetVectorParameterValue(class UObject* WorldContextObject, class UMaterialParameterCollection* Collection, const struct FName& ParameterName, const struct FLinearColor& ParameterValue);
	static void SetScalarParameterValue(class UObject* WorldContextObject, class UMaterialParameterCollection* Collection, const struct FName& ParameterName, float ParameterValue);
	static struct FLinearColor GetVectorParameterValue(class UObject* WorldContextObject, class UMaterialParameterCollection* Collection, const struct FName& ParameterName);
	static float GetScalarParameterValue(class UObject* WorldContextObject, class UMaterialParameterCollection* Collection, const struct FName& ParameterName);
	static class UMaterialInstanceDynamic* CreateDynamicMaterialInstance(class UObject* WorldContextObject, class UMaterialInterface* Parent);
};


// Class Engine.KismetMathLibrary
// 0x0000 (0x0028 - 0x0028)
class UKismetMathLibrary : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.KismetMathLibrary");
		return ptr;
	}


	static int Xor_IntInt(int A, int B);
	static float VSizeXY(const struct FVector& A);
	static float VSizeSquared(const struct FVector& A);
	static float VSize2DSquared(const struct FVector2D& A);
	static float VSize2D(const struct FVector2D& A);
	static float VSize(const struct FVector& A);
	static struct FVector VLerp(const struct FVector& A, const struct FVector& B, float Alpha);
	static struct FVector VInterpTo_Constant(const struct FVector& Current, const struct FVector& Target, float DeltaTime, float InterpSpeed);
	static struct FVector VInterpTo(const struct FVector& Current, const struct FVector& Target, float DeltaTime, float InterpSpeed);
	static struct FVector VectorSpringInterp(const struct FVector& Current, const struct FVector& Target, float Stiffness, float CriticalDampingFactor, float DeltaTime, float Mass, struct FVectorSpringState* SpringState);
	static struct FVector2D Vector2DInterpTo_Constant(const struct FVector2D& Current, const struct FVector2D& Target, float DeltaTime, float InterpSpeed);
	static struct FVector2D Vector2DInterpTo(const struct FVector2D& Current, const struct FVector2D& Target, float DeltaTime, float InterpSpeed);
	static struct FVector VEase(const struct FVector& A, const struct FVector& B, float Alpha, TEnumAsByte<EEasingFunc> EasingFunc, float BlendExp, int Steps);
	static struct FDateTime UtcNow();
	static struct FRotator TransformRotation(const struct FTransform& T, const struct FRotator& Rotation);
	static struct FVector TransformLocation(const struct FTransform& T, const struct FVector& Location);
	static struct FVector TransformDirection(const struct FTransform& T, const struct FVector& Direction);
	static struct FDateTime Today();
	static struct FTransform TLerp(const struct FTransform& A, const struct FTransform& B, float Alpha, TEnumAsByte<ELerpInterpolationMode> InterpMode);
	static struct FTransform TInterpTo(const struct FTransform& Current, const struct FTransform& Target, float DeltaTime, float InterpSpeed);
	static struct FTimespan TimespanZeroValue();
	static float TimespanRatio(const struct FTimespan& A, const struct FTimespan& B);
	static struct FTimespan TimespanMinValue();
	static struct FTimespan TimespanMaxValue();
	static bool TimespanFromString(const struct FString& TimespanString, struct FTimespan* Result);
	static struct FTransform TEase(const struct FTransform& A, const struct FTransform& B, float Alpha, TEnumAsByte<EEasingFunc> EasingFunc, float BlendExp, int Steps);
	static float Tan(float A);
	static struct FVector Subtract_VectorVector(const struct FVector& A, const struct FVector& B);
	static struct FVector Subtract_VectorInt(const struct FVector& A, int B);
	static struct FVector Subtract_VectorFloat(const struct FVector& A, float B);
	static struct FVector2D Subtract_Vector2DVector2D(const struct FVector2D& A, const struct FVector2D& B);
	static struct FVector2D Subtract_Vector2DFloat(const struct FVector2D& A, float B);
	static struct FTimespan Subtract_TimespanTimespan(const struct FTimespan& A, const struct FTimespan& B);
	static int Subtract_IntInt(int A, int B);
	static float Subtract_FloatFloat(float A, float B);
	static struct FDateTime Subtract_DateTimeTimespan(const struct FDateTime& A, const struct FTimespan& B);
	static struct FTimespan Subtract_DateTimeDateTime(const struct FDateTime& A, const struct FDateTime& B);
	static unsigned char Subtract_ByteByte(unsigned char A, unsigned char B);
	static float Square(float A);
	static float Sqrt(float A);
	static float Sin(float A);
	static int SignOfInteger(int A);
	static float SignOfFloat(float A);
	static void SetRandomStreamSeed(int NewSeed, struct FRandomStream* Stream);
	static struct FVector SelectVector(const struct FVector& A, const struct FVector& B, bool bPickA);
	static struct FTransform SelectTransform(const struct FTransform& A, const struct FTransform& B, bool bPickA);
	static struct FString SelectString(const struct FString& A, const struct FString& B, bool bPickA);
	static struct FRotator SelectRotator(const struct FRotator& A, const struct FRotator& B, bool bPickA);
	static class UObject* SelectObject(class UObject* A, class UObject* B, bool bSelectA);
	static int SelectInt(int A, int B, bool bPickA);
	static float SelectFloat(float A, float B, bool bPickA);
	static struct FLinearColor SelectColor(const struct FLinearColor& A, const struct FLinearColor& B, bool bPickA);
	static class UClass* SelectClass(class UClass* A, class UClass* B, bool bSelectA);
	static void SeedRandomStream(struct FRandomStream* Stream);
	static int Round(float A);
	static struct FRotator RotatorFromAxisAndAngle(const struct FVector& Axis, float Angle);
	static struct FVector RotateAngleAxis(const struct FVector& InVect, float AngleDeg, const struct FVector& Axis);
	static struct FRotator RLerp(const struct FRotator& A, const struct FRotator& B, float Alpha, bool bShortestPath);
	static struct FRotator RInterpTo_Constant(const struct FRotator& Current, const struct FRotator& Target, float DeltaTime, float InterpSpeed);
	static struct FRotator RInterpTo(const struct FRotator& Current, const struct FRotator& Target, float DeltaTime, float InterpSpeed);
	static void RGBToHSV_Vector(const struct FLinearColor& RGB, struct FLinearColor* HSV);
	static void RGBToHSV(const struct FLinearColor& InColor, float* H, float* S, float* V, float* A);
	static void ResetVectorSpringState(struct FVectorSpringState* SpringState);
	static void ResetRandomStream(const struct FRandomStream& Stream);
	static void ResetFloatSpringState(struct FFloatSpringState* SpringState);
	static struct FRotator REase(const struct FRotator& A, const struct FRotator& B, float Alpha, bool bShortestPath, TEnumAsByte<EEasingFunc> EasingFunc, float BlendExp, int Steps);
	static struct FVector RandomUnitVectorInEllipticalConeInRadiansFromStream(const struct FVector& ConeDir, float MaxYawInRadians, float MaxPitchInRadians, const struct FRandomStream& Stream);
	static struct FVector RandomUnitVectorInEllipticalConeInRadians(const struct FVector& ConeDir, float MaxYawInRadians, float MaxPitchInRadians);
	static struct FVector RandomUnitVectorInEllipticalConeInDegreesFromStream(const struct FVector& ConeDir, float MaxYawInDegrees, float MaxPitchInDegrees, const struct FRandomStream& Stream);
	static struct FVector RandomUnitVectorInEllipticalConeInDegrees(const struct FVector& ConeDir, float MaxYawInDegrees, float MaxPitchInDegrees);
	static struct FVector RandomUnitVectorInConeInRadiansFromStream(const struct FVector& ConeDir, float ConeHalfAngleInRadians, const struct FRandomStream& Stream);
	static struct FVector RandomUnitVectorInConeInRadians(const struct FVector& ConeDir, float ConeHalfAngleInRadians);
	static struct FVector RandomUnitVectorInConeInDegreesFromStream(const struct FVector& ConeDir, float ConeHalfAngleInDegrees, const struct FRandomStream& Stream);
	static struct FVector RandomUnitVectorInConeInDegrees(const struct FVector& ConeDir, float ConeHalfAngleInDegrees);
	static struct FVector RandomUnitVectorFromStream(const struct FRandomStream& Stream);
	static struct FVector RandomUnitVector();
	static struct FRotator RandomRotatorFromStream(bool bRoll, const struct FRandomStream& Stream);
	static struct FRotator RandomRotator(bool bRoll);
	static struct FVector RandomPointInBoundingBox(const struct FVector& Origin, const struct FVector& BoxExtent);
	static int RandomIntegerInRangeFromStream(int Min, int Max, const struct FRandomStream& Stream);
	static int RandomIntegerInRange(int Min, int Max);
	static int RandomIntegerFromStream(int Max, const struct FRandomStream& Stream);
	static int RandomInteger(int Max);
	static float RandomFloatInRangeFromStream(float Min, float Max, const struct FRandomStream& Stream);
	static float RandomFloatInRange(float Min, float Max);
	static float RandomFloatFromStream(const struct FRandomStream& Stream);
	static float RandomFloat();
	static bool RandomBoolWithWeightFromStream(float Weight, const struct FRandomStream& RandomStream);
	static bool RandomBoolWithWeight(float Weight);
	static bool RandomBoolFromStream(const struct FRandomStream& Stream);
	static bool RandomBool();
	static float RadiansToDegrees(float A);
	static struct FVector ProjectVectorOnToVector(const struct FVector& V, const struct FVector& Target);
	static struct FVector ProjectVectorOnToPlane(const struct FVector& V, const struct FVector& PlaneNormal);
	static struct FVector ProjectPointOnToPlane(const struct FVector& Point, const struct FVector& PlaneBase, const struct FVector& PlaneNormal);
	static bool PointsAreCoplanar(TArray<struct FVector> Points, float Tolerance);
	static int Percent_IntInt(int A, int B);
	static float Percent_FloatFloat(float A, float B);
	static unsigned char Percent_ByteByte(unsigned char A, unsigned char B);
	static int Or_IntInt(int A, int B);
	static struct FDateTime Now();
	static bool NotEqual_VectorVector(const struct FVector& A, const struct FVector& B, float ErrorTolerance);
	static bool NotEqual_Vector2DVector2D(const struct FVector2D& A, const struct FVector2D& B, float ErrorTolerance);
	static bool NotEqual_TimespanTimespan(const struct FTimespan& A, const struct FTimespan& B);
	static bool NotEqual_RotatorRotator(const struct FRotator& A, const struct FRotator& B, float ErrorTolerance);
	static bool NotEqual_ObjectObject(class UObject* A, class UObject* B);
	static bool NotEqual_NameName(const struct FName& A, const struct FName& B);
	static bool NotEqual_IntInt(int A, int B);
	static bool NotEqual_FloatFloat(float A, float B);
	static bool NotEqual_DateTimeDateTime(const struct FDateTime& A, const struct FDateTime& B);
	static bool NotEqual_ClassClass(class UClass* A, class UClass* B);
	static bool NotEqual_ByteByte(unsigned char A, unsigned char B);
	static bool NotEqual_BoolBool(bool A, bool B);
	static bool Not_PreBool(bool A);
	static int Not_Int(int A);
	static float NormalizeToRange(float Value, float RangeMin, float RangeMax);
	static struct FRotator NormalizedDeltaRotator(const struct FRotator& A, const struct FRotator& B);
	static float NormalizeAxis(float Angle);
	static struct FVector2D Normal2D(const struct FVector2D& A);
	static struct FVector Normal(const struct FVector& A);
	static struct FVector NegateVector(const struct FVector& A);
	static struct FRotator NegateRotator(const struct FRotator& A);
	static bool NearlyEqual_TransformTransform(const struct FTransform& A, const struct FTransform& B, float LocationTolerance, float RotationTolerance, float Scale3DTolerance);
	static bool NearlyEqual_FloatFloat(float A, float B, float ErrorTolerance);
	static float MultiplyMultiply_FloatFloat(float Base, float Exp);
	static float MultiplyByPi(float Value);
	static struct FVector Multiply_VectorVector(const struct FVector& A, const struct FVector& B);
	static struct FVector Multiply_VectorInt(const struct FVector& A, int B);
	static struct FVector Multiply_VectorFloat(const struct FVector& A, float B);
	static struct FVector2D Multiply_Vector2DVector2D(const struct FVector2D& A, const struct FVector2D& B);
	static struct FVector2D Multiply_Vector2DFloat(const struct FVector2D& A, float B);
	static struct FTimespan Multiply_TimespanFloat(const struct FTimespan& A, float Scalar);
	static struct FRotator Multiply_RotatorInt(const struct FRotator& A, int B);
	static struct FRotator Multiply_RotatorFloat(const struct FRotator& A, float B);
	static struct FLinearColor Multiply_LinearColorLinearColor(const struct FLinearColor& A, const struct FLinearColor& B);
	static struct FLinearColor Multiply_LinearColorFloat(const struct FLinearColor& A, float B);
	static int Multiply_IntInt(int A, int B);
	static float Multiply_IntFloat(int A, float B);
	static float Multiply_FloatFloat(float A, float B);
	static unsigned char Multiply_ByteByte(unsigned char A, unsigned char B);
	static struct FVector MirrorVectorByNormal(const struct FVector& InVect, const struct FVector& InNormal);
	static void MinOfIntArray(TArray<int> IntArray, int* IndexOfMinValue, int* MinValue);
	static void MinOfFloatArray(TArray<float> FloatArray, int* IndexOfMinValue, float* MinValue);
	static void MinOfByteArray(TArray<unsigned char> ByteArray, int* IndexOfMinValue, unsigned char* MinValue);
	static void MinimumAreaRectangle(class UObject* WorldContextObject, TArray<struct FVector> InVerts, const struct FVector& SampleSurfaceNormal, bool bDebugDraw, struct FVector* OutRectCenter, struct FRotator* OutRectRotation, float* OutSideLengthX, float* OutSideLengthY);
	static int Min(int A, int B);
	static void MaxOfIntArray(TArray<int> IntArray, int* IndexOfMaxValue, int* MaxValue);
	static void MaxOfFloatArray(TArray<float> FloatArray, int* IndexOfMaxValue, float* MaxValue);
	static void MaxOfByteArray(TArray<unsigned char> ByteArray, int* IndexOfMaxValue, unsigned char* MaxValue);
	static int Max(int A, int B);
	static float MapRangeUnclamped(float Value, float InRangeA, float InRangeB, float OutRangeA, float OutRangeB);
	static float MapRangeClamped(float Value, float InRangeA, float InRangeB, float OutRangeA, float OutRangeB);
	static struct FVector2D MakeVector2D(float X, float Y);
	static struct FVector MakeVector(float X, float Y, float Z);
	static struct FTransform MakeTransform(const struct FVector& Location, const struct FRotator& Rotation, const struct FVector& Scale);
	static struct FTimespan MakeTimespan2(int Days, int Hours, int Minutes, int Seconds, int FractionNano);
	static struct FTimespan MakeTimespan(int Days, int Hours, int Minutes, int Seconds, int Milliseconds);
	static struct FRotator MakeRotFromZY(const struct FVector& Z, const struct FVector& Y);
	static struct FRotator MakeRotFromZX(const struct FVector& Z, const struct FVector& X);
	static struct FRotator MakeRotFromZ(const struct FVector& Z);
	static struct FRotator MakeRotFromYZ(const struct FVector& Y, const struct FVector& Z);
	static struct FRotator MakeRotFromYX(const struct FVector& Y, const struct FVector& X);
	static struct FRotator MakeRotFromY(const struct FVector& Y);
	static struct FRotator MakeRotFromXZ(const struct FVector& X, const struct FVector& Z);
	static struct FRotator MakeRotFromXY(const struct FVector& X, const struct FVector& Y);
	static struct FRotator MakeRotFromX(const struct FVector& X);
	static struct FRotator MakeRotator(float Roll, float Pitch, float Yaw);
	static struct FRotator MakeRotationFromAxes(const struct FVector& Forward, const struct FVector& Right, const struct FVector& Up);
	static struct FRandomStream MakeRandomStream(int InitialSeed);
	static float MakePulsatingValue(float InCurrentTime, float InPulsesPerSecond, float InPhase);
	static struct FPlane MakePlaneFromPointAndNormal(const struct FVector& Point, const struct FVector& Normal);
	static struct FDateTime MakeDateTime(int Year, int Month, int Day, int Hour, int Minute, int Second, int Millisecond);
	static struct FLinearColor MakeColor(float R, float G, float B, float A);
	static struct FBox2D MakeBox2D(const struct FVector2D& Min, const struct FVector2D& Max);
	static struct FBox MakeBox(const struct FVector& Min, const struct FVector& Max);
	static float Loge(float A);
	static float Log(float A, float Base);
	static bool LinePlaneIntersection_OriginNormal(const struct FVector& LineStart, const struct FVector& LineEnd, const struct FVector& PlaneOrigin, const struct FVector& PlaneNormal, float* T, struct FVector* Intersection);
	static bool LinePlaneIntersection(const struct FVector& LineStart, const struct FVector& LineEnd, const struct FPlane& APlane, float* T, struct FVector* Intersection);
	static struct FLinearColor LinearColorLerpUsingHSV(const struct FLinearColor& A, const struct FLinearColor& B, float Alpha);
	static struct FLinearColor LinearColorLerp(const struct FLinearColor& A, const struct FLinearColor& B, float Alpha);
	static struct FVector LessLess_VectorRotator(const struct FVector& A, const struct FRotator& B);
	static bool LessEqual_TimespanTimespan(const struct FTimespan& A, const struct FTimespan& B);
	static bool LessEqual_IntInt(int A, int B);
	static bool LessEqual_FloatFloat(float A, float B);
	static bool LessEqual_DateTimeDateTime(const struct FDateTime& A, const struct FDateTime& B);
	static bool LessEqual_ByteByte(unsigned char A, unsigned char B);
	static bool Less_TimespanTimespan(const struct FTimespan& A, const struct FTimespan& B);
	static bool Less_IntInt(int A, int B);
	static bool Less_FloatFloat(float A, float B);
	static bool Less_DateTimeDateTime(const struct FDateTime& A, const struct FDateTime& B);
	static bool Less_ByteByte(unsigned char A, unsigned char B);
	static float Lerp(float A, float B, float Alpha);
	static bool IsPointInBoxWithTransform(const struct FVector& Point, const struct FTransform& BoxWorldTransform, const struct FVector& BoxExtent);
	static bool IsPointInBox(const struct FVector& Point, const struct FVector& BoxOrigin, const struct FVector& BoxExtent);
	static bool IsMorning(const struct FDateTime& A);
	static bool IsLeapYear(int Year);
	static bool IsAfternoon(const struct FDateTime& A);
	static struct FTransform InvertTransform(const struct FTransform& T);
	static struct FRotator InverseTransformRotation(const struct FTransform& T, const struct FRotator& Rotation);
	static struct FVector InverseTransformLocation(const struct FTransform& T, const struct FVector& Location);
	static struct FVector InverseTransformDirection(const struct FTransform& T, const struct FVector& Direction);
	static bool InRange_IntInt(int Value, int Min, int Max, bool InclusiveMin, bool InclusiveMax);
	static bool InRange_FloatFloat(float Value, float Min, float Max, bool InclusiveMin, bool InclusiveMax);
	static float Hypotenuse(float Width, float Height);
	static void HSVToRGB_Vector(const struct FLinearColor& HSV, struct FLinearColor* RGB);
	static struct FLinearColor HSVToRGB(float H, float S, float V, float A);
	static float GridSnap_Float(float Location, float GridSize);
	static struct FVector GreaterGreater_VectorRotator(const struct FVector& A, const struct FRotator& B);
	static bool GreaterEqual_TimespanTimespan(const struct FTimespan& A, const struct FTimespan& B);
	static bool GreaterEqual_IntInt(int A, int B);
	static bool GreaterEqual_FloatFloat(float A, float B);
	static bool GreaterEqual_DateTimeDateTime(const struct FDateTime& A, const struct FDateTime& B);
	static bool GreaterEqual_ByteByte(unsigned char A, unsigned char B);
	static bool Greater_TimespanTimespan(const struct FTimespan& A, const struct FTimespan& B);
	static bool Greater_IntInt(int A, int B);
	static bool Greater_FloatFloat(float A, float B);
	static bool Greater_DateTimeDateTime(const struct FDateTime& A, const struct FDateTime& B);
	static bool Greater_ByteByte(unsigned char A, unsigned char B);
	static int GetYear(const struct FDateTime& A);
	static void GetYawPitchFromVector(const struct FVector& InVec, float* Yaw, float* Pitch);
	static struct FVector GetVectorArrayAverage(TArray<struct FVector> Vectors);
	static struct FVector GetUpVector(const struct FRotator& InRot);
	static float GetTotalSeconds(const struct FTimespan& A);
	static float GetTotalMinutes(const struct FTimespan& A);
	static float GetTotalMilliseconds(const struct FTimespan& A);
	static float GetTotalHours(const struct FTimespan& A);
	static float GetTotalDays(const struct FTimespan& A);
	static struct FTimespan GetTimeOfDay(const struct FDateTime& A);
	static float GetTAU();
	static int GetSeconds(const struct FTimespan& A);
	static int GetSecond(const struct FDateTime& A);
	static struct FVector GetRightVector(const struct FRotator& InRot);
	static struct FVector GetReflectionVector(const struct FVector& Direction, const struct FVector& SurfaceNormal);
	static float GetPointDistanceToSegment(const struct FVector& Point, const struct FVector& SegmentStart, const struct FVector& SegmentEnd);
	static float GetPointDistanceToLine(const struct FVector& Point, const struct FVector& LineOrigin, const struct FVector& LineDirection);
	static float GetPI();
	static int GetMonth(const struct FDateTime& A);
	static int GetMinutes(const struct FTimespan& A);
	static int GetMinute(const struct FDateTime& A);
	static float GetMinElement(const struct FVector& A);
	static int GetMilliseconds(const struct FTimespan& A);
	static int GetMillisecond(const struct FDateTime& A);
	static float GetMaxElement(const struct FVector& A);
	static int GetHours(const struct FTimespan& A);
	static int GetHour12(const struct FDateTime& A);
	static int GetHour(const struct FDateTime& A);
	static struct FVector GetForwardVector(const struct FRotator& InRot);
	static struct FTimespan GetDuration(const struct FTimespan& A);
	static struct FVector GetDirectionUnitVector(const struct FVector& From, const struct FVector& To);
	static int GetDays(const struct FTimespan& A);
	static int GetDayOfYear(const struct FDateTime& A);
	static int GetDay(const struct FDateTime& A);
	static struct FDateTime GetDate(const struct FDateTime& A);
	static void GetAzimuthAndElevation(const struct FVector& InDirection, const struct FTransform& ReferenceFrame, float* Azimuth, float* Elevation);
	static void GetAxes(const struct FRotator& A, struct FVector* X, struct FVector* Y, struct FVector* Z);
	static struct FIntVector FTruncVector(const struct FVector& InVector);
	static int FTrunc(float A);
	static struct FTimespan FromSeconds(float Seconds);
	static struct FTimespan FromMinutes(float Minutes);
	static struct FTimespan FromMilliseconds(float Milliseconds);
	static struct FTimespan FromHours(float Hours);
	static struct FTimespan FromDays(float Days);
	static float Fraction(float A);
	static int FMod(float Dividend, float Divisor, float* Remainder);
	static float FMin(float A, float B);
	static float FMax(float A, float B);
	static float FloatSpringInterp(float Current, float Target, float Stiffness, float CriticalDampingFactor, float DeltaTime, float Mass, struct FFloatSpringState* SpringState);
	static float FixedTurn(float InCurrent, float InDesired, float InDeltaRate);
	static float FInterpTo_Constant(float Current, float Target, float DeltaTime, float InterpSpeed);
	static float FInterpTo(float Current, float Target, float DeltaTime, float InterpSpeed);
	static float FInterpEaseInOut(float A, float B, float Alpha, float Exponent);
	static void FindNearestPointsOnLineSegments(const struct FVector& Segment1Start, const struct FVector& Segment1End, const struct FVector& Segment2Start, const struct FVector& Segment2End, struct FVector* Segment1Point, struct FVector* Segment2Point);
	static struct FRotator FindLookAtRotation(const struct FVector& Start, const struct FVector& Target);
	static struct FVector FindClosestPointOnSegment(const struct FVector& Point, const struct FVector& SegmentStart, const struct FVector& SegmentEnd);
	static struct FVector FindClosestPointOnLine(const struct FVector& Point, const struct FVector& LineOrigin, const struct FVector& LineDirection);
	static int FFloor(float A);
	static float FClamp(float Value, float Min, float Max);
	static int FCeil(float A);
	static float Exp(float A);
	static bool EqualEqual_VectorVector(const struct FVector& A, const struct FVector& B, float ErrorTolerance);
	static bool EqualEqual_Vector2DVector2D(const struct FVector2D& A, const struct FVector2D& B, float ErrorTolerance);
	static bool EqualEqual_TransformTransform(const struct FTransform& A, const struct FTransform& B);
	static bool EqualEqual_TimespanTimespan(const struct FTimespan& A, const struct FTimespan& B);
	static bool EqualEqual_RotatorRotator(const struct FRotator& A, const struct FRotator& B, float ErrorTolerance);
	static bool EqualEqual_ObjectObject(class UObject* A, class UObject* B);
	static bool EqualEqual_NameName(const struct FName& A, const struct FName& B);
	static bool EqualEqual_IntInt(int A, int B);
	static bool EqualEqual_FloatFloat(float A, float B);
	static bool EqualEqual_DateTimeDateTime(const struct FDateTime& A, const struct FDateTime& B);
	static bool EqualEqual_ClassClass(class UClass* A, class UClass* B);
	static bool EqualEqual_ByteByte(unsigned char A, unsigned char B);
	static bool EqualEqual_BoolBool(bool A, bool B);
	static float Ease(float A, float B, float Alpha, TEnumAsByte<EEasingFunc> EasingFunc, float BlendExp, int Steps);
	static float DotProduct2D(const struct FVector2D& A, const struct FVector2D& B);
	static float Dot_VectorVector(const struct FVector& A, const struct FVector& B);
	static struct FVector Divide_VectorVector(const struct FVector& A, const struct FVector& B);
	static struct FVector Divide_VectorInt(const struct FVector& A, int B);
	static struct FVector Divide_VectorFloat(const struct FVector& A, float B);
	static struct FVector2D Divide_Vector2DVector2D(const struct FVector2D& A, const struct FVector2D& B);
	static struct FVector2D Divide_Vector2DFloat(const struct FVector2D& A, float B);
	static struct FTimespan Divide_TimespanFloat(const struct FTimespan& A, float Scalar);
	static int Divide_IntInt(int A, int B);
	static float Divide_FloatFloat(float A, float B);
	static unsigned char Divide_ByteByte(unsigned char A, unsigned char B);
	static float DegTan(float A);
	static float DegSin(float A);
	static float DegreesToRadians(float A);
	static float DegCos(float A);
	static float DegAtan2(float A, float B);
	static float DegAtan(float A);
	static float DegAsin(float A);
	static float DegAcos(float A);
	static int DaysInYear(int Year);
	static int DaysInMonth(int Year, int Month);
	static struct FDateTime DateTimeMinValue();
	static struct FDateTime DateTimeMaxValue();
	static bool DateTimeFromString(const struct FString& DateTimeString, struct FDateTime* Result);
	static bool DateTimeFromIsoString(const struct FString& IsoString, struct FDateTime* Result);
	static float CrossProduct2D(const struct FVector2D& A, const struct FVector2D& B);
	static struct FVector Cross_VectorVector(const struct FVector& A, const struct FVector& B);
	static struct FVector CreateVectorFromYawPitch(float Yaw, float Pitch, float Length);
	static float Cos(float A);
	static struct FTransform ConvertTransformToRelative(const struct FTransform& Transform, const struct FTransform& ParentTransform);
	static struct FVector2D Conv_VectorToVector2D(const struct FVector& InVector);
	static struct FTransform Conv_VectorToTransform(const struct FVector& InLocation);
	static struct FRotator Conv_VectorToRotator(const struct FVector& InVec);
	static struct FLinearColor Conv_VectorToLinearColor(const struct FVector& InVec);
	static struct FVector Conv_Vector2DToVector(const struct FVector2D& InVector2D, float Z);
	static struct FVector Conv_RotatorToVector(const struct FRotator& InRot);
	static struct FVector Conv_LinearColorToVector(const struct FLinearColor& InLinearColor);
	static struct FColor Conv_LinearColorToColor(const struct FLinearColor& InLinearColor);
	static struct FVector Conv_IntVectorToVector(const struct FIntVector& InIntVector);
	static struct FIntVector Conv_IntToIntVector(int inInt);
	static float Conv_IntToFloat(int inInt);
	static unsigned char Conv_IntToByte(int inInt);
	static bool Conv_IntToBool(int inInt);
	static struct FVector Conv_FloatToVector(float InFloat);
	static struct FLinearColor Conv_FloatToLinearColor(float InFloat);
	static struct FLinearColor Conv_ColorToLinearColor(const struct FColor& InColor);
	static int Conv_ByteToInt(unsigned char InByte);
	static float Conv_ByteToFloat(unsigned char InByte);
	static int Conv_BoolToInt(bool InBool);
	static float Conv_BoolToFloat(bool InBool);
	static unsigned char Conv_BoolToByte(bool InBool);
	static struct FTransform ComposeTransforms(const struct FTransform& A, const struct FTransform& B);
	static struct FRotator ComposeRotators(const struct FRotator& A, const struct FRotator& B);
	static bool ClassIsChildOf(class UClass* TestClass, class UClass* ParentClass);
	static struct FVector ClampVectorSize(const struct FVector& A, float Min, float Max);
	static float ClampAxis(float Angle);
	static float ClampAngle(float AngleDegrees, float MinAngleDegrees, float MaxAngleDegrees);
	static int Clamp(int Value, int Min, int Max);
	static struct FLinearColor CInterpTo(const struct FLinearColor& Current, const struct FLinearColor& Target, float DeltaTime, float InterpSpeed);
	static void BreakVector2D(const struct FVector2D& InVec, float* X, float* Y);
	static void BreakVector(const struct FVector& InVec, float* X, float* Y, float* Z);
	static void BreakTransform(const struct FTransform& InTransform, struct FVector* Location, struct FRotator* Rotation, struct FVector* Scale);
	static void BreakTimespan2(const struct FTimespan& InTimespan, int* Days, int* Hours, int* Minutes, int* Seconds, int* FractionNano);
	static void BreakTimespan(const struct FTimespan& InTimespan, int* Days, int* Hours, int* Minutes, int* Seconds, int* Milliseconds);
	static void BreakRotIntoAxes(const struct FRotator& InRot, struct FVector* X, struct FVector* Y, struct FVector* Z);
	static void BreakRotator(const struct FRotator& InRot, float* Roll, float* Pitch, float* Yaw);
	static void BreakRandomStream(const struct FRandomStream& InRandomStream, int* InitialSeed);
	static void BreakDateTime(const struct FDateTime& InDateTime, int* Year, int* Month, int* Day, int* Hour, int* Minute, int* Second, int* Millisecond);
	static void BreakColor(const struct FLinearColor& InColor, float* R, float* G, float* B, float* A);
	static bool BooleanXOR(bool A, bool B);
	static bool BooleanOR(bool A, bool B);
	static bool BooleanNOR(bool A, bool B);
	static bool BooleanNAND(bool A, bool B);
	static bool BooleanAND(bool A, bool B);
	static unsigned char BMin(unsigned char A, unsigned char B);
	static unsigned char BMax(unsigned char A, unsigned char B);
	static float Atan2(float A, float B);
	static float Atan(float A);
	static float Asin(float A);
	static int And_IntInt(int A, int B);
	static struct FVector Add_VectorVector(const struct FVector& A, const struct FVector& B);
	static struct FVector Add_VectorInt(const struct FVector& A, int B);
	static struct FVector Add_VectorFloat(const struct FVector& A, float B);
	static struct FVector2D Add_Vector2DVector2D(const struct FVector2D& A, const struct FVector2D& B);
	static struct FVector2D Add_Vector2DFloat(const struct FVector2D& A, float B);
	static struct FTimespan Add_TimespanTimespan(const struct FTimespan& A, const struct FTimespan& B);
	static int Add_IntInt(int A, int B);
	static float Add_FloatFloat(float A, float B);
	static struct FDateTime Add_DateTimeTimespan(const struct FDateTime& A, const struct FTimespan& B);
	static unsigned char Add_ByteByte(unsigned char A, unsigned char B);
	static float Acos(float A);
	static int Abs_Int(int A);
	static float Abs(float A);
};


// Class Engine.KismetNodeHelperLibrary
// 0x0000 (0x0028 - 0x0028)
class UKismetNodeHelperLibrary : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.KismetNodeHelperLibrary");
		return ptr;
	}


	static void MarkBit(int Index, int* Data);
	static bool HasUnmarkedBit(int Data, int NumBits);
	static bool HasMarkedBit(int Data, int NumBits);
	static unsigned char GetValidValue(class UEnum* Enum, unsigned char EnumeratorValue);
	static int GetUnmarkedBit(int Data, int StartIdx, int NumBits, bool bRandom);
	static int GetRandomUnmarkedBit(int Data, int StartIdx, int NumBits);
	static int GetFirstUnmarkedBit(int Data, int StartIdx, int NumBits);
	static unsigned char GetEnumeratorValueFromIndex(class UEnum* Enum, unsigned char EnumeratorIndex);
	static struct FString GetEnumeratorUserFriendlyName(class UEnum* Enum, unsigned char EnumeratorValue);
	static struct FName GetEnumeratorName(class UEnum* Enum, unsigned char EnumeratorValue);
	static void ClearBit(int Index, int* Data);
	static void ClearAllBits(int* Data);
	static bool BitIsMarked(int Data, int Index);
};


// Class Engine.KismetRenderingLibrary
// 0x0000 (0x0028 - 0x0028)
class UKismetRenderingLibrary : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.KismetRenderingLibrary");
		return ptr;
	}


	static class UTexture2D* RenderTargetCreateStaticTexture2DEditorOnly(class UTextureRenderTarget2D* RenderTarget, const struct FString& Name, TEnumAsByte<ETextureCompressionSettings> CompressionSettings, TEnumAsByte<ETextureMipGenSettings> MipSettings);
	static void ReleaseRenderTarget2D(class UTextureRenderTarget2D* TextureRenderTarget);
	static struct FSkelMeshSkinWeightInfo MakeSkinWeightInfo(int Bone0, unsigned char Weight0, int Bone1, unsigned char Weight1, int Bone2, unsigned char Weight2, int Bone3, unsigned char Weight3);
	static void ExportTexture2D(class UObject* WorldContextObject, class UTexture2D* Texture, const struct FString& FilePath, const struct FString& Filename);
	static void ExportRenderTarget(class UObject* WorldContextObject, class UTextureRenderTarget2D* TextureRenderTarget, const struct FString& FilePath, const struct FString& Filename);
	static void EndDrawCanvasToRenderTarget(class UObject* WorldContextObject, const struct FDrawToRenderTargetContext& Context);
	static void DrawMaterialToRenderTarget(class UObject* WorldContextObject, class UTextureRenderTarget2D* TextureRenderTarget, class UMaterialInterface* Material);
	static class UTextureRenderTarget2D* CreateRenderTarget2D(class UObject* WorldContextObject, int Width, int Height, TEnumAsByte<ETextureRenderTargetFormat> Format);
	static void ConvertRenderTargetToTexture2DEditorOnly(class UObject* WorldContextObject, class UTextureRenderTarget2D* RenderTarget, class UTexture2D* Texture);
	static void ClearRenderTarget2D(class UObject* WorldContextObject, class UTextureRenderTarget2D* TextureRenderTarget, const struct FLinearColor& ClearColor);
	static void BreakSkinWeightInfo(const struct FSkelMeshSkinWeightInfo& InWeight, int* Bone0, unsigned char* Weight0, int* Bone1, unsigned char* Weight1, int* Bone2, unsigned char* Weight2, int* Bone3, unsigned char* Weight3);
	static void BeginDrawCanvasToRenderTarget(class UObject* WorldContextObject, class UTextureRenderTarget2D* TextureRenderTarget, class UCanvas** Canvas, struct FVector2D* Size, struct FDrawToRenderTargetContext* Context);
};


// Class Engine.KismetStringLibrary
// 0x0000 (0x0028 - 0x0028)
class UKismetStringLibrary : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.KismetStringLibrary");
		return ptr;
	}


	static struct FString TrimTrailing(const struct FString& SourceString);
	static struct FString Trim(const struct FString& SourceString);
	static struct FString ToUpper(const struct FString& SourceString);
	static struct FString ToLower(const struct FString& SourceString);
	static struct FString TimeSecondsToString(float InSeconds);
	static bool StartsWith(const struct FString& SourceString, const struct FString& InPrefix, TEnumAsByte<ESearchCase> SearchCase);
	static bool Split(const struct FString& SourceString, const struct FString& InStr, TEnumAsByte<ESearchCase> SearchCase, TEnumAsByte<ESearchDir> SearchDir, struct FString* LeftS, struct FString* RightS);
	static struct FString RightPad(const struct FString& SourceString, int ChCount);
	static struct FString RightChop(const struct FString& SourceString, int count);
	static struct FString Right(const struct FString& SourceString, int count);
	static struct FString Reverse(const struct FString& SourceString);
	static int ReplaceInline(const struct FString& SearchText, const struct FString& ReplacementText, TEnumAsByte<ESearchCase> SearchCase, struct FString* SourceString);
	static struct FString Replace(const struct FString& SourceString, const struct FString& From, const struct FString& To, TEnumAsByte<ESearchCase> SearchCase);
	static TArray<struct FString> ParseIntoArray(const struct FString& SourceString, const struct FString& Delimiter, bool CullEmptyStrings);
	static bool NotEqual_StrStr(const struct FString& A, const struct FString& B);
	static bool NotEqual_StriStri(const struct FString& A, const struct FString& B);
	static struct FString Mid(const struct FString& SourceString, int Start, int count);
	static bool MatchesWildcard(const struct FString& SourceString, const struct FString& Wildcard, TEnumAsByte<ESearchCase> SearchCase);
	static int Len(const struct FString& S);
	static struct FString LeftPad(const struct FString& SourceString, int ChCount);
	static struct FString LeftChop(const struct FString& SourceString, int count);
	static struct FString Left(const struct FString& SourceString, int count);
	static struct FString JoinStringArray(TArray<struct FString> SourceArray, const struct FString& Separator);
	static bool IsNumeric(const struct FString& SourceString);
	static struct FString GetSubstring(const struct FString& SourceString, int StartIndex, int Length);
	static int GetCharacterAsNumber(const struct FString& SourceString, int Index);
	static TArray<struct FString> GetCharacterArrayFromString(const struct FString& SourceString);
	static int FindSubstring(const struct FString& SearchIn, const struct FString& Substring, bool bUseCase, bool bSearchFromEnd, int StartPosition);
	static bool EqualEqual_StrStr(const struct FString& A, const struct FString& B);
	static bool EqualEqual_StriStri(const struct FString& A, const struct FString& B);
	static bool EndsWith(const struct FString& SourceString, const struct FString& InSuffix, TEnumAsByte<ESearchCase> SearchCase);
	static int CullArray(const struct FString& SourceString, TArray<struct FString>* inArray);
	static struct FString Conv_VectorToString(const struct FVector& InVec);
	static struct FString Conv_Vector2dToString(const struct FVector2D& InVec);
	static struct FString Conv_TransformToString(const struct FTransform& InTrans);
	static void Conv_StringToVector2D(const struct FString& inString, struct FVector2D* OutConvertedVector2D, bool* OutIsValid);
	static void Conv_StringToVector(const struct FString& inString, struct FVector* OutConvertedVector, bool* OutIsValid);
	static void Conv_StringToRotator(const struct FString& inString, struct FRotator* OutConvertedRotator, bool* OutIsValid);
	static struct FName Conv_StringToName(const struct FString& inString);
	static int Conv_StringToInt(const struct FString& inString);
	static float Conv_StringToFloat(const struct FString& inString);
	static void Conv_StringToColor(const struct FString& inString, struct FLinearColor* OutConvertedColor, bool* OutIsValid);
	static struct FString Conv_RotatorToString(const struct FRotator& InRot);
	static struct FString Conv_ObjectToString(class UObject* InObj);
	static struct FString Conv_NameToString(const struct FName& InName);
	static struct FString Conv_IntVectorToString(const struct FIntVector& InIntVec);
	static struct FString Conv_IntToString(int inInt);
	static struct FString Conv_FloatToString(float InFloat);
	static struct FString Conv_ColorToString(const struct FLinearColor& InColor);
	static struct FString Conv_ByteToString(unsigned char InByte);
	static struct FString Conv_BoolToString(bool InBool);
	static bool Contains(const struct FString& SearchIn, const struct FString& Substring, bool bUseCase, bool bSearchFromEnd);
	static struct FString Concat_StrStr(const struct FString& A, const struct FString& B);
	static struct FString BuildString_Vector2d(const struct FString& AppendTo, const struct FString& prefix, const struct FVector2D& InVector2D, const struct FString& suffix);
	static struct FString BuildString_Vector(const struct FString& AppendTo, const struct FString& prefix, const struct FVector& InVector, const struct FString& suffix);
	static struct FString BuildString_Rotator(const struct FString& AppendTo, const struct FString& prefix, const struct FRotator& InRot, const struct FString& suffix);
	static struct FString BuildString_Object(const struct FString& AppendTo, const struct FString& prefix, class UObject* InObj, const struct FString& suffix);
	static struct FString BuildString_Name(const struct FString& AppendTo, const struct FString& prefix, const struct FName& InName, const struct FString& suffix);
	static struct FString BuildString_IntVector(const struct FString& AppendTo, const struct FString& prefix, const struct FIntVector& InIntVector, const struct FString& suffix);
	static struct FString BuildString_Int(const struct FString& AppendTo, const struct FString& prefix, int inInt, const struct FString& suffix);
	static struct FString BuildString_Float(const struct FString& AppendTo, const struct FString& prefix, float InFloat, const struct FString& suffix);
	static struct FString BuildString_Color(const struct FString& AppendTo, const struct FString& prefix, const struct FLinearColor& InColor, const struct FString& suffix);
	static struct FString BuildString_Bool(const struct FString& AppendTo, const struct FString& prefix, bool InBool, const struct FString& suffix);
};


// Class Engine.KismetStringTableLibrary
// 0x0000 (0x0028 - 0x0028)
class UKismetStringTableLibrary : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.KismetStringTableLibrary");
		return ptr;
	}


	static bool IsRegisteredTableId(const struct FName& TableId);
	static bool IsRegisteredTableEntry(const struct FName& TableId, const struct FString& Key);
	static struct FString GetTableNamespace(const struct FName& TableId);
	static struct FString GetTableEntrySourceString(const struct FName& TableId, const struct FString& Key);
	static struct FString GetTableEntryMetaData(const struct FName& TableId, const struct FString& Key, const struct FName& MetaDataId);
	static TArray<struct FName> GetRegisteredStringTables();
	static TArray<struct FName> GetMetaDataIdsFromStringTableEntry(const struct FName& TableId, const struct FString& Key);
	static TArray<struct FString> GetKeysFromStringTable(const struct FName& TableId);
};


// Class Engine.KismetSystemLibrary
// 0x0000 (0x0028 - 0x0028)
class UKismetSystemLibrary : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.KismetSystemLibrary");
		return ptr;
	}


	static void UnregisterForRemoteNotifications();
	static void UnloadPrimaryAssetList(TArray<struct FPrimaryAssetId> PrimaryAssetIdList);
	static void UnloadPrimaryAsset(const struct FPrimaryAssetId& PrimaryAssetId);
	static void StackTrace();
	static bool SphereTraceSingleForObjects(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, float Radius, TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, struct FHitResult* OutHit);
	static bool SphereTraceSingleByProfile(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, float Radius, const struct FName& ProfileName, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, struct FHitResult* OutHit);
	static bool SphereTraceSingle(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, float Radius, TEnumAsByte<ETraceTypeQuery> TraceChannel, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, struct FHitResult* OutHit);
	static bool SphereTraceMultiForObjects(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, float Radius, TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, TArray<struct FHitResult>* OutHits);
	static bool SphereTraceMultiByProfile(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, float Radius, const struct FName& ProfileName, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, TArray<struct FHitResult>* OutHits);
	static bool SphereTraceMulti(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, float Radius, TEnumAsByte<ETraceTypeQuery> TraceChannel, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, TArray<struct FHitResult>* OutHits);
	static bool SphereOverlapComponents(class UObject* WorldContextObject, const struct FVector& SpherePos, float SphereRadius, TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, class UClass* ComponentClassFilter, TArray<class AActor*> ActorsToIgnore, TArray<class UPrimitiveComponent*>* OutComponents);
	static bool SphereOverlapActors(class UObject* WorldContextObject, const struct FVector& SpherePos, float SphereRadius, TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, class UClass* ActorClassFilter, TArray<class AActor*> ActorsToIgnore, TArray<class AActor*>* OutActors);
	static void ShowPlatformSpecificLeaderboardScreen(const struct FString& CategoryName);
	static void ShowPlatformSpecificAchievementsScreen(class APlayerController* SpecificPlayer);
	static void ShowInterstitialAd();
	static void ShowAdBanner(int AdIdIndex, bool bShowOnBottomOfScreen);
	static void SetWindowTitle(const struct FText& Title);
	static void SetVolumeButtonsHandledBySystem(bool bEnabled);
	static void SetVectorPropertyByName(class UObject* Object, const struct FName& PropertyName, const struct FVector& Value);
	static void SetUserActivity(const struct FUserActivity& UserActivity);
	static void SetTransformPropertyByName(class UObject* Object, const struct FName& PropertyName, const struct FTransform& Value);
	static void SetTextPropertyByName(class UObject* Object, const struct FName& PropertyName, const struct FText& Value);
	static void SetSuppressViewportTransitionMessage(class UObject* WorldContextObject, bool bState);
	static void SetStructurePropertyByName(class UObject* Object, const struct FName& PropertyName, const struct FGenericStruct& Value);
	static void SetStringPropertyByName(class UObject* Object, const struct FName& PropertyName, const struct FString& Value);
	static void SetSoftObjectPropertyByName(class UObject* Object, const struct FName& PropertyName, TSoftObjectPtr<class UObject> Value);
	static void SetSoftClassPropertyByName(class UObject* Object, const struct FName& PropertyName, TSoftObjectPtr<class UClass> Value);
	static void SetRotatorPropertyByName(class UObject* Object, const struct FName& PropertyName, const struct FRotator& Value);
	static void SetObjectPropertyByName(class UObject* Object, const struct FName& PropertyName, class UObject* Value);
	static void SetNamePropertyByName(class UObject* Object, const struct FName& PropertyName, const struct FName& Value);
	static void SetLinearColorPropertyByName(class UObject* Object, const struct FName& PropertyName, const struct FLinearColor& Value);
	static void SetIntPropertyByName(class UObject* Object, const struct FName& PropertyName, int Value);
	static void SetInterfacePropertyByName(class UObject* Object, const struct FName& PropertyName, const TScriptInterface<class UInterface>& Value);
	static void SetFloatPropertyByName(class UObject* Object, const struct FName& PropertyName, float Value);
	static void SetCollisionProfileNameProperty(class UObject* Object, const struct FName& PropertyName, const struct FCollisionProfileName& Value);
	static void SetClassPropertyByName(class UObject* Object, const struct FName& PropertyName, class UClass* Value);
	static void SetBytePropertyByName(class UObject* Object, const struct FName& PropertyName, unsigned char Value);
	static void SetBoolPropertyByName(class UObject* Object, const struct FName& PropertyName, bool Value);
	static void RetriggerableDelay(class UObject* WorldContextObject, float Duration, const struct FLatentActionInfo& LatentInfo);
	static void ResetGamepadAssignmentToController(int ControllerId);
	static void ResetGamepadAssignments();
	static void RegisterForRemoteNotifications();
	static void QuitGame(class UObject* WorldContextObject, class APlayerController* SpecificPlayer, TEnumAsByte<EQuitPreference> QuitPreference);
	static void PrintWarning(const struct FString& inString);
	static void PrintText(class UObject* WorldContextObject, const struct FText& InText, bool bPrintToScreen, bool bPrintToLog, const struct FLinearColor& TextColor, float Duration);
	static void PrintString(class UObject* WorldContextObject, const struct FString& inString, bool bPrintToScreen, bool bPrintToLog, const struct FLinearColor& TextColor, float Duration);
	void OnAssetLoaded__DelegateSignature(class UObject* Loaded);
	void OnAssetClassLoaded__DelegateSignature(class UClass* Loaded);
	static bool NotEqual_SoftObjectReference(TSoftObjectPtr<class UObject> A, TSoftObjectPtr<class UObject> B);
	static bool NotEqual_SoftClassReference(TSoftObjectPtr<class UClass> A, TSoftObjectPtr<class UClass> B);
	static bool NotEqual_PrimaryAssetType(const struct FPrimaryAssetType& A, const struct FPrimaryAssetType& B);
	static bool NotEqual_PrimaryAssetId(const struct FPrimaryAssetId& A, const struct FPrimaryAssetId& B);
	static void MoveComponentTo(class USceneComponent* Component, const struct FVector& TargetRelativeLocation, const struct FRotator& TargetRelativeRotation, bool bEaseOut, bool bEaseIn, float OverTime, bool bForceShortestRotationPath, TEnumAsByte<EMoveComponentAction> MoveAction, const struct FLatentActionInfo& LatentInfo);
	static struct FSoftObjectPath MakeSoftObjectPath(const struct FString& PathString);
	static struct FText MakeLiteralText(const struct FText& Value);
	static struct FString MakeLiteralString(const struct FString& Value);
	static struct FName MakeLiteralName(const struct FName& Value);
	static int MakeLiteralInt(int Value);
	static float MakeLiteralFloat(float Value);
	static unsigned char MakeLiteralByte(unsigned char Value);
	static bool MakeLiteralBool(bool Value);
	static void LoadInterstitialAd(int AdIdIndex);
	static void LoadAssetClass(class UObject* WorldContextObject, TSoftObjectPtr<class UClass> AssetClass, const struct FScriptDelegate& OnLoaded, const struct FLatentActionInfo& LatentInfo);
	static void LoadAsset(class UObject* WorldContextObject, TSoftObjectPtr<class UObject> Asset, const struct FScriptDelegate& OnLoaded, const struct FLatentActionInfo& LatentInfo);
	static bool LineTraceSingleForObjects(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, struct FHitResult* OutHit);
	static bool LineTraceSingleByProfile(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, const struct FName& ProfileName, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, struct FHitResult* OutHit);
	static bool LineTraceSingle(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, TEnumAsByte<ETraceTypeQuery> TraceChannel, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, struct FHitResult* OutHit);
	static bool LineTraceMultiForObjects(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, TArray<struct FHitResult>* OutHits);
	static bool LineTraceMultiByProfile(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, const struct FName& ProfileName, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, TArray<struct FHitResult>* OutHits);
	static bool LineTraceMulti(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, TEnumAsByte<ETraceTypeQuery> TraceChannel, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, TArray<struct FHitResult>* OutHits);
	static void LaunchURL(const struct FString& URL);
	static void K2_UnPauseTimerHandle(class UObject* WorldContextObject, const struct FTimerHandle& Handle);
	static void K2_UnPauseTimerDelegate(const struct FScriptDelegate& Delegate);
	static void K2_UnPauseTimer(class UObject* Object, const struct FString& FunctionName);
	static bool K2_TimerExistsHandle(class UObject* WorldContextObject, const struct FTimerHandle& Handle);
	static bool K2_TimerExistsDelegate(const struct FScriptDelegate& Delegate);
	static bool K2_TimerExists(class UObject* Object, const struct FString& FunctionName);
	static struct FTimerHandle K2_SetTimerDelegate(const struct FScriptDelegate& Delegate, float Time, bool bLooping);
	static struct FTimerHandle K2_SetTimer(class UObject* Object, const struct FString& FunctionName, float Time, bool bLooping);
	static void K2_PauseTimerHandle(class UObject* WorldContextObject, const struct FTimerHandle& Handle);
	static void K2_PauseTimerDelegate(const struct FScriptDelegate& Delegate);
	static void K2_PauseTimer(class UObject* Object, const struct FString& FunctionName);
	static bool K2_IsValidTimerHandle(const struct FTimerHandle& Handle);
	static bool K2_IsTimerPausedHandle(class UObject* WorldContextObject, const struct FTimerHandle& Handle);
	static bool K2_IsTimerPausedDelegate(const struct FScriptDelegate& Delegate);
	static bool K2_IsTimerPaused(class UObject* Object, const struct FString& FunctionName);
	static bool K2_IsTimerActiveHandle(class UObject* WorldContextObject, const struct FTimerHandle& Handle);
	static bool K2_IsTimerActiveDelegate(const struct FScriptDelegate& Delegate);
	static bool K2_IsTimerActive(class UObject* Object, const struct FString& FunctionName);
	static struct FTimerHandle K2_InvalidateTimerHandle(struct FTimerHandle* Handle);
	static float K2_GetTimerRemainingTimeHandle(class UObject* WorldContextObject, const struct FTimerHandle& Handle);
	static float K2_GetTimerRemainingTimeDelegate(const struct FScriptDelegate& Delegate);
	static float K2_GetTimerRemainingTime(class UObject* Object, const struct FString& FunctionName);
	static float K2_GetTimerElapsedTimeHandle(class UObject* WorldContextObject, const struct FTimerHandle& Handle);
	static float K2_GetTimerElapsedTimeDelegate(const struct FScriptDelegate& Delegate);
	static float K2_GetTimerElapsedTime(class UObject* Object, const struct FString& FunctionName);
	static void K2_ClearTimerHandle(class UObject* WorldContextObject, const struct FTimerHandle& Handle);
	static void K2_ClearTimerDelegate(const struct FScriptDelegate& Delegate);
	static void K2_ClearTimer(class UObject* Object, const struct FString& FunctionName);
	static void K2_ClearAndInvalidateTimerHandle(class UObject* WorldContextObject, struct FTimerHandle* Handle);
	static bool IsValidSoftObjectReference(TSoftObjectPtr<class UObject> SoftObjectReference);
	static bool IsValidSoftClassReference(TSoftObjectPtr<class UClass> SoftClassReference);
	static bool IsValidPrimaryAssetType(const struct FPrimaryAssetType& PrimaryAssetType);
	static bool IsValidPrimaryAssetId(const struct FPrimaryAssetId& PrimaryAssetId);
	static bool IsValidClass(class UClass* Class);
	static bool IsValid(class UObject* Object);
	static bool IsStandalone(class UObject* WorldContextObject);
	static bool IsServer(class UObject* WorldContextObject);
	static bool IsPackagedForDistribution();
	static bool IsLoggedIn(class APlayerController* SpecificPlayer);
	static bool IsInterstitialAdRequested();
	static bool IsInterstitialAdAvailable();
	static bool IsDedicatedServer(class UObject* WorldContextObject);
	static bool IsControllerAssignedToGamepad(int ControllerId);
	static void HideAdBanner();
	static bool GetVolumeButtonsHandledBySystem();
	static struct FString GetUniqueDeviceId();
	static bool GetSupportedFullscreenResolutions(TArray<struct FIntPoint>* Resolutions);
	static TSoftObjectPtr<class UObject> GetSoftObjectReferenceFromPrimaryAssetId(const struct FPrimaryAssetId& PrimaryAssetId);
	static TSoftObjectPtr<class UClass> GetSoftClassReferenceFromPrimaryAssetId(const struct FPrimaryAssetId& PrimaryAssetId);
	static int GetRenderingMaterialQualityLevel();
	static int GetRenderingDetailMode();
	static struct FString GetProjectSavedDirectory();
	static struct FString GetProjectDirectory();
	static struct FString GetProjectContentDirectory();
	static void GetPrimaryAssetsWithBundleState(TArray<struct FName> RequiredBundles, TArray<struct FName> ExcludedBundles, TArray<struct FPrimaryAssetType> ValidTypes, bool bForceCurrentState, TArray<struct FPrimaryAssetId>* OutPrimaryAssetIdList);
	static void GetPrimaryAssetIdList(const struct FPrimaryAssetType& PrimaryAssetType, TArray<struct FPrimaryAssetId>* OutPrimaryAssetIdList);
	static struct FPrimaryAssetId GetPrimaryAssetIdFromSoftObjectReference(TSoftObjectPtr<class UObject> SoftObjectReference);
	static struct FPrimaryAssetId GetPrimaryAssetIdFromSoftClassReference(TSoftObjectPtr<class UClass> SoftClassReference);
	static struct FPrimaryAssetId GetPrimaryAssetIdFromObject(class UObject* Object);
	static struct FPrimaryAssetId GetPrimaryAssetIdFromClass(class UClass* Class);
	static TArray<struct FString> GetPreferredLanguages();
	static struct FString GetPlatformUserName();
	static struct FString GetPathName(class UObject* Object);
	static struct FString GetObjectName(class UObject* Object);
	static class UObject* GetObjectFromPrimaryAssetId(const struct FPrimaryAssetId& PrimaryAssetId);
	static int GetMinYResolutionForUI();
	static int GetMinYResolutionFor3DView();
	static struct FString GetLocalCurrencySymbol();
	static struct FString GetLocalCurrencyCode();
	static float GetGameTimeInSeconds(class UObject* WorldContextObject);
	static struct FString GetGameName();
	static struct FString GetGameBundleId();
	static struct FString GetEngineVersion();
	static struct FString GetDisplayName(class UObject* Object);
	static struct FString GetDeviceId();
	static struct FString GetDefaultLocale();
	static struct FString GetDefaultLanguage();
	static bool GetCurrentBundleState(const struct FPrimaryAssetId& PrimaryAssetId, bool bForceCurrentState, TArray<struct FName>* OutBundles);
	static bool GetConvenientWindowedResolutions(TArray<struct FIntPoint>* Resolutions);
	static int GetConsoleVariableIntValue(class UObject* WorldContextObject, const struct FString& VariableName);
	static float GetConsoleVariableFloatValue(class UObject* WorldContextObject, const struct FString& VariableName);
	static void GetComponentBounds(class USceneComponent* Component, struct FVector* Origin, struct FVector* BoxExtent, float* SphereRadius);
	static struct FString GetCommandLine();
	static class UClass* GetClassFromPrimaryAssetId(const struct FPrimaryAssetId& PrimaryAssetId);
	static struct FString GetClassDisplayName(class UClass* Class);
	static int GetAdIDCount();
	static void GetActorListFromComponentList(TArray<class UPrimitiveComponent*> ComponentList, class UClass* ActorClassFilter, TArray<class AActor*>* OutActorList);
	static void GetActorBounds(class AActor* Actor, struct FVector* Origin, struct FVector* BoxExtent);
	static void ForceCloseAdBanner();
	static void FlushPersistentDebugLines(class UObject* WorldContextObject);
	static void FlushDebugStrings(class UObject* WorldContextObject);
	static void ExecuteConsoleCommand(class UObject* WorldContextObject, const struct FString& Command, class APlayerController* SpecificPlayer);
	static bool EqualEqual_SoftObjectReference(TSoftObjectPtr<class UObject> A, TSoftObjectPtr<class UObject> B);
	static bool EqualEqual_SoftClassReference(TSoftObjectPtr<class UClass> A, TSoftObjectPtr<class UClass> B);
	static bool EqualEqual_PrimaryAssetType(const struct FPrimaryAssetType& A, const struct FPrimaryAssetType& B);
	static bool EqualEqual_PrimaryAssetId(const struct FPrimaryAssetId& A, const struct FPrimaryAssetId& B);
	static void DrawDebugString(class UObject* WorldContextObject, const struct FVector& TextLocation, const struct FString& Text, class AActor* TestBaseActor, const struct FLinearColor& TextColor, float Duration);
	static void DrawDebugSphere(class UObject* WorldContextObject, const struct FVector& Center, float Radius, int Segments, const struct FLinearColor& LineColor, float Duration, float Thickness);
	static void DrawDebugPoint(class UObject* WorldContextObject, const struct FVector& Position, float Size, const struct FLinearColor& PointColor, float Duration);
	static void DrawDebugPlane(class UObject* WorldContextObject, const struct FPlane& PlaneCoordinates, const struct FVector& Location, float Size, const struct FLinearColor& PlaneColor, float Duration);
	static void DrawDebugLine(class UObject* WorldContextObject, const struct FVector& LineStart, const struct FVector& LineEnd, const struct FLinearColor& LineColor, float Duration, float Thickness);
	static void DrawDebugFrustum(class UObject* WorldContextObject, const struct FTransform& FrustumTransform, const struct FLinearColor& FrustumColor, float Duration, float Thickness);
	static void DrawDebugFloatHistoryTransform(class UObject* WorldContextObject, const struct FDebugFloatHistory& FloatHistory, const struct FTransform& DrawTransform, const struct FVector2D& DrawSize, const struct FLinearColor& DrawColor, float Duration);
	static void DrawDebugFloatHistoryLocation(class UObject* WorldContextObject, const struct FDebugFloatHistory& FloatHistory, const struct FVector& DrawLocation, const struct FVector2D& DrawSize, const struct FLinearColor& DrawColor, float Duration);
	static void DrawDebugCylinder(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, float Radius, int Segments, const struct FLinearColor& LineColor, float Duration, float Thickness);
	static void DrawDebugCoordinateSystem(class UObject* WorldContextObject, const struct FVector& AxisLoc, const struct FRotator& AxisRot, float Scale, float Duration, float Thickness);
	static void DrawDebugConeInDegrees(class UObject* WorldContextObject, const struct FVector& Origin, const struct FVector& Direction, float Length, float AngleWidth, float AngleHeight, int NumSides, const struct FLinearColor& LineColor, float Duration, float Thickness);
	static void DrawDebugCone(class UObject* WorldContextObject, const struct FVector& Origin, const struct FVector& Direction, float Length, float AngleWidth, float AngleHeight, int NumSides, const struct FLinearColor& LineColor, float Duration, float Thickness);
	static void DrawDebugCircle(class UObject* WorldContextObject, const struct FVector& Center, float Radius, int NumSegments, const struct FLinearColor& LineColor, float Duration, float Thickness, const struct FVector& YAxis, const struct FVector& ZAxis, bool bDrawAxis);
	static void DrawDebugCapsule(class UObject* WorldContextObject, const struct FVector& Center, float HalfHeight, float Radius, const struct FRotator& Rotation, const struct FLinearColor& LineColor, float Duration, float Thickness);
	static void DrawDebugCamera(class ACameraActor* CameraActor, const struct FLinearColor& CameraColor, float Duration);
	static void DrawDebugBox(class UObject* WorldContextObject, const struct FVector& Center, const struct FVector& Extent, const struct FLinearColor& LineColor, const struct FRotator& Rotation, float Duration, float Thickness);
	static void DrawDebugArrow(class UObject* WorldContextObject, const struct FVector& LineStart, const struct FVector& LineEnd, float ArrowSize, const struct FLinearColor& LineColor, float Duration, float Thickness);
	static bool DoesImplementInterface(class UObject* TestObject, class UClass* Interface);
	static void Delay(class UObject* WorldContextObject, float Duration, const struct FLatentActionInfo& LatentInfo);
	static void CreateCopyForUndoBuffer(class UObject* ObjectToModify);
	static struct FString Conv_SoftObjectReferenceToString(TSoftObjectPtr<class UObject> SoftObjectReference);
	static class UObject* Conv_SoftObjectReferenceToObject(TSoftObjectPtr<class UObject> SoftObject);
	static struct FString Conv_SoftClassReferenceToString(TSoftObjectPtr<class UClass> SoftClassReference);
	static class UClass* Conv_SoftClassReferenceToClass(TSoftObjectPtr<class UClass> SoftClass);
	static struct FString Conv_PrimaryAssetTypeToString(const struct FPrimaryAssetType& PrimaryAssetType);
	static struct FString Conv_PrimaryAssetIdToString(const struct FPrimaryAssetId& PrimaryAssetId);
	static TSoftObjectPtr<class UObject> Conv_ObjectToSoftObjectReference(class UObject* Object);
	static class UObject* Conv_InterfaceToObject(const TScriptInterface<class UInterface>& Interface);
	static TSoftObjectPtr<class UClass> Conv_ClassToSoftClassReference(class UClass* Class);
	static void ControlScreensaver(bool bAllowScreenSaver);
	static bool ComponentOverlapComponents(class UPrimitiveComponent* Component, const struct FTransform& ComponentTransform, TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, class UClass* ComponentClassFilter, TArray<class AActor*> ActorsToIgnore, TArray<class UPrimitiveComponent*>* OutComponents);
	static bool ComponentOverlapActors(class UPrimitiveComponent* Component, const struct FTransform& ComponentTransform, TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, class UClass* ActorClassFilter, TArray<class AActor*> ActorsToIgnore, TArray<class AActor*>* OutActors);
	static void CollectGarbage();
	static bool CapsuleTraceSingleForObjects(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, float Radius, float HalfHeight, TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, struct FHitResult* OutHit);
	static bool CapsuleTraceSingleByProfile(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, float Radius, float HalfHeight, const struct FName& ProfileName, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, struct FHitResult* OutHit);
	static bool CapsuleTraceSingle(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, float Radius, float HalfHeight, TEnumAsByte<ETraceTypeQuery> TraceChannel, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, struct FHitResult* OutHit);
	static bool CapsuleTraceMultiForObjects(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, float Radius, float HalfHeight, TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, TArray<struct FHitResult>* OutHits);
	static bool CapsuleTraceMultiByProfile(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, float Radius, float HalfHeight, const struct FName& ProfileName, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, TArray<struct FHitResult>* OutHits);
	static bool CapsuleTraceMulti(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, float Radius, float HalfHeight, TEnumAsByte<ETraceTypeQuery> TraceChannel, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, TArray<struct FHitResult>* OutHits);
	static bool CapsuleOverlapComponents(class UObject* WorldContextObject, const struct FVector& CapsulePos, float Radius, float HalfHeight, TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, class UClass* ComponentClassFilter, TArray<class AActor*> ActorsToIgnore, TArray<class UPrimitiveComponent*>* OutComponents);
	static bool CapsuleOverlapActors(class UObject* WorldContextObject, const struct FVector& CapsulePos, float Radius, float HalfHeight, TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, class UClass* ActorClassFilter, TArray<class AActor*> ActorsToIgnore, TArray<class AActor*>* OutActors);
	static bool CanLaunchURL(const struct FString& URL);
	static void BreakSoftObjectPath(const struct FSoftObjectPath& InSoftObjectPath, struct FString* PathString);
	static bool BoxTraceSingleForObjects(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, const struct FVector& HalfSize, const struct FRotator& Orientation, TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, struct FHitResult* OutHit);
	static bool BoxTraceSingleByProfile(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, const struct FVector& HalfSize, const struct FRotator& Orientation, const struct FName& ProfileName, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, struct FHitResult* OutHit);
	static bool BoxTraceSingle(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, const struct FVector& HalfSize, const struct FRotator& Orientation, TEnumAsByte<ETraceTypeQuery> TraceChannel, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, struct FHitResult* OutHit);
	static bool BoxTraceMultiForObjects(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, const struct FVector& HalfSize, const struct FRotator& Orientation, TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, TArray<struct FHitResult>* OutHits);
	static bool BoxTraceMultiByProfile(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, const struct FVector& HalfSize, const struct FRotator& Orientation, const struct FName& ProfileName, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, TArray<struct FHitResult>* OutHits);
	static bool BoxTraceMulti(class UObject* WorldContextObject, const struct FVector& Start, const struct FVector& End, const struct FVector& HalfSize, const struct FRotator& Orientation, TEnumAsByte<ETraceTypeQuery> TraceChannel, bool bTraceComplex, TArray<class AActor*> ActorsToIgnore, TEnumAsByte<EDrawDebugTrace> DrawDebugType, bool bIgnoreSelf, const struct FLinearColor& TraceColor, const struct FLinearColor& TraceHitColor, float DrawTime, TArray<struct FHitResult>* OutHits);
	static bool BoxOverlapComponents(class UObject* WorldContextObject, const struct FVector& BoxPos, const struct FVector& Extent, TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, class UClass* ComponentClassFilter, TArray<class AActor*> ActorsToIgnore, TArray<class UPrimitiveComponent*>* OutComponents);
	static bool BoxOverlapActors(class UObject* WorldContextObject, const struct FVector& BoxPos, const struct FVector& BoxExtent, TArray<TEnumAsByte<EObjectTypeQuery>> ObjectTypes, class UClass* ActorClassFilter, TArray<class AActor*> ActorsToIgnore, TArray<class AActor*>* OutActors);
	static struct FDebugFloatHistory AddFloatHistorySample(float Value, const struct FDebugFloatHistory& FloatHistory);
};


// Class Engine.KismetTextLibrary
// 0x0000 (0x0028 - 0x0028)
class UKismetTextLibrary : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.KismetTextLibrary");
		return ptr;
	}


	static struct FText TextTrimTrailing(const struct FText& InText);
	static struct FText TextTrimPrecedingAndTrailing(const struct FText& InText);
	static struct FText TextTrimPreceding(const struct FText& InText);
	static struct FText TextToUpper(const struct FText& InText);
	static struct FText TextToLower(const struct FText& InText);
	static bool TextIsTransient(const struct FText& InText);
	static bool TextIsFromStringTable(const struct FText& Text);
	static bool TextIsEmpty(const struct FText& InText);
	static bool TextIsCultureInvariant(const struct FText& InText);
	static struct FText TextFromStringTable(const struct FName& TableId, const struct FString& Key);
	static bool StringTableIdAndKeyFromText(const struct FText& Text, struct FName* OutTableId, struct FString* OutKey);
	static bool NotEqual_TextText(const struct FText& A, const struct FText& B);
	static bool NotEqual_IgnoreCase_TextText(const struct FText& A, const struct FText& B);
	static struct FText GetEmptyText();
	static struct FText Format(const struct FText& InPattern, TArray<struct FFormatArgumentData> InArgs);
	static bool FindTextInLocalizationTable(const struct FString& Namespace, const struct FString& Key, struct FText* OutText);
	static bool EqualEqual_TextText(const struct FText& A, const struct FText& B);
	static bool EqualEqual_IgnoreCase_TextText(const struct FText& A, const struct FText& B);
	static struct FText Conv_VectorToText(const struct FVector& InVec);
	static struct FText Conv_Vector2dToText(const struct FVector2D& InVec);
	static struct FText Conv_TransformToText(const struct FTransform& InTrans);
	static struct FString Conv_TextToString(const struct FText& InText);
	static struct FText Conv_StringToText(const struct FString& inString);
	static struct FText Conv_RotatorToText(const struct FRotator& InRot);
	static struct FText Conv_ObjectToText(class UObject* InObj);
	static struct FText Conv_NameToText(const struct FName& InName);
	static struct FText Conv_IntToText(int Value, bool bAlwaysSign, bool bUseGrouping, int MinimumIntegralDigits, int MaximumIntegralDigits);
	static struct FText Conv_FloatToText(float Value, TEnumAsByte<ERoundingMode> RoundingMode, bool bAlwaysSign, bool bUseGrouping, int MinimumIntegralDigits, int MaximumIntegralDigits, int MinimumFractionalDigits, int MaximumFractionalDigits);
	static struct FText Conv_ColorToText(const struct FLinearColor& InColor);
	static struct FText Conv_ByteToText(unsigned char Value);
	static struct FText Conv_BoolToText(bool InBool);
	static struct FText AsTimeZoneTime_DateTime(const struct FDateTime& InDateTime, const struct FString& InTimeZone);
	static struct FText AsTimeZoneDateTime_DateTime(const struct FDateTime& InDateTime, const struct FString& InTimeZone);
	static struct FText AsTimeZoneDate_DateTime(const struct FDateTime& InDateTime, const struct FString& InTimeZone);
	static struct FText AsTimespan_Timespan(const struct FTimespan& InTimespan);
	static struct FText AsTime_DateTime(const struct FDateTime& In);
	static struct FText AsPercent_Float(float Value, TEnumAsByte<ERoundingMode> RoundingMode, bool bAlwaysSign, bool bUseGrouping, int MinimumIntegralDigits, int MaximumIntegralDigits, int MinimumFractionalDigits, int MaximumFractionalDigits);
	static struct FText AsDateTime_DateTime(const struct FDateTime& In);
	static struct FText AsDate_DateTime(const struct FDateTime& InDateTime);
	static struct FText AsCurrencyBase(int BaseValue, const struct FString& CurrencyCode);
	static struct FText AsCurrency_Integer(int Value, TEnumAsByte<ERoundingMode> RoundingMode, bool bAlwaysSign, bool bUseGrouping, int MinimumIntegralDigits, int MaximumIntegralDigits, int MinimumFractionalDigits, int MaximumFractionalDigits, const struct FString& CurrencyCode);
	static struct FText AsCurrency_Float(float Value, TEnumAsByte<ERoundingMode> RoundingMode, bool bAlwaysSign, bool bUseGrouping, int MinimumIntegralDigits, int MaximumIntegralDigits, int MinimumFractionalDigits, int MaximumFractionalDigits, const struct FString& CurrencyCode);
};


// Class Engine.Layer
// 0x0020 (0x0048 - 0x0028)
class ULayer : public UObject
{
public:
	struct FName                                       LayerName;                                                // 0x0028(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bIsVisible : 1;                                           // 0x0030(0x0001)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0031(0x0007) MISSED OFFSET
	TArray<struct FLayerActorStats>                    ActorStats;                                               // 0x0038(0x0010) (CPF_ZeroConstructor, CPF_Transient)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Layer");
		return ptr;
	}

};


// Class Engine.Level
// 0x0308 (0x0330 - 0x0028)
class ULevel : public UObject
{
public:
	unsigned char                                      UnknownData00[0x98];                                      // 0x0028(0x0098) MISSED OFFSET
	class UWorld*                                      OwningWorld;                                              // 0x00C0(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class UModel*                                      Model;                                                    // 0x00C8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<class UModelComponent*>                     ModelComponents;                                          // 0x00D0(0x0010) (CPF_ExportObject, CPF_ZeroConstructor)
	class ULevelActorContainer*                        ActorCluster;                                             // 0x00E0(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_Transient, CPF_InstancedReference, CPF_DuplicateTransient, CPF_IsPlainOldData)
	int                                                NumTextureStreamingUnbuiltComponents;                     // 0x00E8(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                NumTextureStreamingDirtyResources;                        // 0x00EC(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class ALevelScriptActor*                           LevelScriptActor;                                         // 0x00F0(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class ANavigationObjectBase*                       NavListStart;                                             // 0x00F8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class ANavigationObjectBase*                       NavListEnd;                                               // 0x0100(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<class UNavigationDataChunk*>                NavDataChunks;                                            // 0x0108(0x0010) (CPF_ZeroConstructor)
	float                                              LightmapTotalSize;                                        // 0x0118(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)
	float                                              ShadowmapTotalSize;                                       // 0x011C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)
	TArray<struct FVector>                             StaticNavigableGeometry;                                  // 0x0120(0x0010) (CPF_ZeroConstructor)
	TArray<struct FGuid>                               StreamingTextureGuids;                                    // 0x0130(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      UnknownData01[0x90];                                      // 0x0140(0x0090) MISSED OFFSET
	bool                                               bIsLightingScenario;                                      // 0x01D0(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x3];                                       // 0x01D1(0x0003) MISSED OFFSET
	struct FGuid                                       LevelBuildDataId;                                         // 0x01D4(0x0010) (CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0x4];                                       // 0x01E4(0x0004) MISSED OFFSET
	class UMapBuildDataRegistry*                       MapBuildData;                                             // 0x01E8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FIntVector                                  LightBuildLevelOffset;                                    // 0x01F0(0x000C) (CPF_IsPlainOldData)
	unsigned char                                      UnknownData04 : 2;                                        // 0x01FC(0x0001)
	unsigned char                                      bTextureStreamingRotationChanged : 1;                     // 0x01FC(0x0001)
	unsigned char                                      bIsVisible : 1;                                           // 0x01FC(0x0001) (CPF_Transient)
	unsigned char                                      bLocked : 1;                                              // 0x01FC(0x0001)
	unsigned char                                      UnknownData05[0x103];                                     // 0x01FD(0x0103) MISSED OFFSET
	class AWorldSettings*                              WorldSettings;                                            // 0x0300(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData06[0x8];                                       // 0x0308(0x0008) MISSED OFFSET
	TArray<class UAssetUserData*>                      AssetUserData;                                            // 0x0310(0x0010) (CPF_ExportObject, CPF_ZeroConstructor)
	unsigned char                                      UnknownData07[0x10];                                      // 0x0320(0x0010) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Level");
		return ptr;
	}

};


// Class Engine.LevelActorContainer
// 0x0010 (0x0038 - 0x0028)
class ULevelActorContainer : public UObject
{
public:
	TArray<class AActor*>                              Actors;                                                   // 0x0028(0x0010) (CPF_ZeroConstructor, CPF_Transient)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LevelActorContainer");
		return ptr;
	}

};


// Class Engine.LevelBounds
// 0x0008 (0x0320 - 0x0318)
class ALevelBounds : public AActor
{
public:
	bool                                               bAutoUpdateBounds;                                        // 0x0318(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0319(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LevelBounds");
		return ptr;
	}

};


// Class Engine.LevelScriptActor
// 0x0008 (0x0320 - 0x0318)
class ALevelScriptActor : public AActor
{
public:
	unsigned char                                      bInputEnabled : 1;                                        // 0x0318(0x0001)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0319(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LevelScriptActor");
		return ptr;
	}


	void WorldOriginLocationChanged(const struct FIntVector& OldOriginLocation, const struct FIntVector& NewOriginLocation);
	void SetCinematicMode(bool bCinematicMode, bool bHidePlayer, bool bAffectsHUD, bool bAffectsMovement, bool bAffectsTurning);
	bool RemoteEvent(const struct FName& EventName);
	void LevelReset();
};


// Class Engine.LevelScriptBlueprint
// 0x0000 (0x01A0 - 0x01A0)
class ULevelScriptBlueprint : public UBlueprint
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LevelScriptBlueprint");
		return ptr;
	}

};


// Class Engine.World
// 0x0978 (0x09A0 - 0x0028)
class UWorld : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET
	class ULevel*                                      PersistentLevel;                                          // 0x0030(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class UNetDriver*                                  NetDriver;                                                // 0x0038(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class ULineBatchComponent*                         LineBatcher;                                              // 0x0040(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_Transient, CPF_InstancedReference, CPF_IsPlainOldData)
	class ULineBatchComponent*                         PersistentLineBatcher;                                    // 0x0048(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_Transient, CPF_InstancedReference, CPF_IsPlainOldData)
	class ULineBatchComponent*                         ForegroundLineBatcher;                                    // 0x0050(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_Transient, CPF_InstancedReference, CPF_IsPlainOldData)
	class AGameNetworkManager*                         NetworkManager;                                           // 0x0058(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class UPhysicsCollisionHandler*                    PhysicsCollisionHandler;                                  // 0x0060(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	TArray<class UObject*>                             ExtraReferencedObjects;                                   // 0x0068(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	TArray<class UObject*>                             PerModuleDataObjects;                                     // 0x0078(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	TArray<class ULevelStreaming*>                     StreamingLevels;                                          // 0x0088(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	struct FString                                     StreamingLevelsPrefix;                                    // 0x0098(0x0010) (CPF_ZeroConstructor)
	class ULevel*                                      CurrentLevelPendingVisibility;                            // 0x00A8(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class ULevel*                                      CurrentLevelPendingInvisibility;                          // 0x00B0(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class UDemoNetDriver*                              DemoNetDriver;                                            // 0x00B8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class AParticleEventManager*                       MyParticleEventManager;                                   // 0x00C0(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class APhysicsVolume*                              DefaultPhysicsVolume;                                     // 0x00C8(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x18];                                      // 0x00D0(0x0018) MISSED OFFSET
	class UNavigationSystem*                           NavigationSystem;                                         // 0x00E8(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class AGameModeBase*                               AuthorityGameMode;                                        // 0x00F0(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class AGameStateBase*                              GameState;                                                // 0x00F8(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class UAISystemBase*                               AISystem;                                                 // 0x0100(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class UAvoidanceManager*                           AvoidanceManager;                                         // 0x0108(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	TArray<class ULevel*>                              Levels;                                                   // 0x0110(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	TArray<struct FLevelCollection>                    LevelCollections;                                         // 0x0120(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	unsigned char                                      UnknownData02[0x8];                                       // 0x0130(0x0008) MISSED OFFSET
	class ULevel*                                      CurrentLevel;                                             // 0x0138(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class UGameInstance*                               OwningGameInstance;                                       // 0x0140(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	TArray<class UMaterialParameterCollectionInstance*> ParameterCollectionInstances;                             // 0x0148(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	class UCanvas*                                     CanvasForRenderingToTarget;                               // 0x0158(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class UCanvas*                                     CanvasForDrawMaterialToRenderTarget;                      // 0x0160(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0x7D8];                                     // 0x0168(0x07D8) MISSED OFFSET
	class UWorldComposition*                           WorldComposition;                                         // 0x0940(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData04[0x4A];                                      // 0x0948(0x004A) MISSED OFFSET
	unsigned char                                      bAreConstraintsDirty : 1;                                 // 0x0992(0x0001) (CPF_Transient)
	unsigned char                                      UnknownData05[0xD];                                       // 0x0993(0x000D) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.World");
		return ptr;
	}

};


// Class Engine.LevelStreaming
// 0x0138 (0x0160 - 0x0028)
class ULevelStreaming : public UObject
{
public:
	struct FName                                       PackageName;                                              // 0x0028(0x0008) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	TSoftObjectPtr<class UWorld>                       WorldAsset;                                               // 0x0030(0x0028) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_EditConst)
	struct FName                                       PackageNameToLoad;                                        // 0x0058(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<struct FName>                               LODPackageNames;                                          // 0x0060(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      UnknownData00[0x10];                                      // 0x0070(0x0010) MISSED OFFSET
	struct FTransform                                  LevelTransform;                                           // 0x0080(0x0030) (CPF_Edit, CPF_BlueprintVisible, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01 : 3;                                        // 0x00B0(0x0001)
	unsigned char                                      bShouldBeVisibleInEditor : 1;                             // 0x00B0(0x0001)
	unsigned char                                      bLocked : 1;                                              // 0x00B0(0x0001)
	unsigned char                                      bShouldBeLoaded : 1;                                      // 0x00B0(0x0001) (CPF_BlueprintVisible)
	unsigned char                                      bShouldBeVisible : 1;                                     // 0x00B0(0x0001) (CPF_BlueprintVisible)
	unsigned char                                      bIsStatic : 1;                                            // 0x00B0(0x0001) (CPF_Edit, CPF_DisableEditOnInstance)
	unsigned char                                      bShouldBlockOnLoad : 1;                                   // 0x00B1(0x0001) (CPF_BlueprintVisible)
	unsigned char                                      UnknownData02[0x2];                                       // 0x00B2(0x0002) MISSED OFFSET
	int                                                LevelLODIndex;                                            // 0x00B4(0x0004) (CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      bDisableDistanceStreaming : 1;                            // 0x00B8(0x0001) (CPF_BlueprintVisible, CPF_Transient)
	unsigned char                                      UnknownData03 : 1;                                        // 0x00B8(0x0001)
	unsigned char                                      bDrawOnLevelStatusMap : 1;                                // 0x00B8(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData04[0x3];                                       // 0x00B9(0x0003) MISSED OFFSET
	struct FColor                                      DrawColor;                                                // 0x00BC(0x0004) (CPF_Deprecated, CPF_IsPlainOldData)
	struct FLinearColor                                LevelColor;                                               // 0x00C0(0x0010) (CPF_Edit, CPF_IsPlainOldData)
	TArray<class ALevelStreamingVolume*>               EditorStreamingVolumes;                                   // 0x00D0(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	float                                              MinTimeBetweenVolumeUnloadRequests;                       // 0x00E0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData05[0x4];                                       // 0x00E4(0x0004) MISSED OFFSET
	TArray<struct FString>                             Keywords;                                                 // 0x00E8(0x0010) (CPF_ZeroConstructor)
	struct FScriptMulticastDelegate                    OnLevelLoaded;                                            // 0x00F8(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnLevelUnloaded;                                          // 0x0108(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnLevelShown;                                             // 0x0118(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnLevelHidden;                                            // 0x0128(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	class ULevel*                                      LoadedLevel;                                              // 0x0138(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class ULevel*                                      PendingUnloadLevel;                                       // 0x0140(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData06[0x18];                                      // 0x0148(0x0018) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LevelStreaming");
		return ptr;
	}


	bool IsStreamingStatePending();
	bool IsLevelVisible();
	bool IsLevelLoaded();
	struct FName GetWorldAssetPackageFName();
	class ALevelScriptActor* GetLevelScriptActor();
	class ULevelStreaming* CreateInstance(const struct FString& UniqueInstanceName);
};


// Class Engine.LevelStreamingAlwaysLoaded
// 0x0000 (0x0160 - 0x0160)
class ULevelStreamingAlwaysLoaded : public ULevelStreaming
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LevelStreamingAlwaysLoaded");
		return ptr;
	}

};


// Class Engine.LevelStreamingKismet
// 0x0000 (0x0160 - 0x0160)
class ULevelStreamingKismet : public ULevelStreaming
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LevelStreamingKismet");
		return ptr;
	}


	static class ULevelStreamingKismet* LoadLevelInstanceBySoftObjectPtr(class UObject* WorldContextObject, TSoftObjectPtr<class UWorld> Level, const struct FVector& Location, const struct FRotator& Rotation, bool* bOutSuccess);
	static class ULevelStreamingKismet* LoadLevelInstance(class UObject* WorldContextObject, const struct FString& LevelName, const struct FVector& Location, const struct FRotator& Rotation, bool* bOutSuccess);
};


// Class Engine.LevelStreamingPersistent
// 0x0000 (0x0160 - 0x0160)
class ULevelStreamingPersistent : public ULevelStreaming
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LevelStreamingPersistent");
		return ptr;
	}

};


// Class Engine.LevelStreamingVolume
// 0x0018 (0x0368 - 0x0350)
class ALevelStreamingVolume : public AVolume
{
public:
	TArray<struct FName>                               StreamingLevelNames;                                      // 0x0350(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst)
	unsigned char                                      bEditorPreVisOnly : 1;                                    // 0x0360(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bDisabled : 1;                                            // 0x0360(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0361(0x0003) MISSED OFFSET
	TEnumAsByte<EStreamingVolumeUsage>                 StreamingUsage;                                           // 0x0364(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x3];                                       // 0x0365(0x0003) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LevelStreamingVolume");
		return ptr;
	}

};


// Class Engine.LightmappedSurfaceCollection
// 0x0018 (0x0040 - 0x0028)
class ULightmappedSurfaceCollection : public UObject
{
public:
	class UModel*                                      SourceModel;                                              // 0x0028(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<int>                                        Surfaces;                                                 // 0x0030(0x0010) (CPF_Edit, CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LightmappedSurfaceCollection");
		return ptr;
	}

};


// Class Engine.Texture2D
// 0x0038 (0x00F0 - 0x00B8)
class UTexture2D : public UTexture
{
public:
	int                                                StreamingIndex;                                           // 0x00B8(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_DuplicateTransient, CPF_IsPlainOldData)
	int                                                LevelIndex;                                               // 0x00BC(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_DuplicateTransient, CPF_IsPlainOldData)
	int                                                FirstResourceMemMip;                                      // 0x00C0(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bTemporarilyDisableStreaming : 1;                         // 0x00C4(0x0001) (CPF_Transient)
	unsigned char                                      bIsStreamable : 1;                                        // 0x00C4(0x0001) (CPF_Transient)
	unsigned char                                      bHasStreamingUpdatePending : 1;                           // 0x00C4(0x0001) (CPF_Transient)
	unsigned char                                      bForceMiplevelsToBeResident : 1;                          // 0x00C4(0x0001) (CPF_Transient)
	unsigned char                                      bIgnoreStreamingMipBias : 1;                              // 0x00C4(0x0001) (CPF_Transient)
	unsigned char                                      bGlobalForceMipLevelsToBeResident : 1;                    // 0x00C4(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	TEnumAsByte<ETextureAddress>                       AddressX;                                                 // 0x00C5(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ETextureAddress>                       AddressY;                                                 // 0x00C6(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x1];                                       // 0x00C7(0x0001) MISSED OFFSET
	struct FIntPoint                                   ImportedSize;                                             // 0x00C8(0x0008) (CPF_IsPlainOldData)
	double                                             ForceMipLevelsToBeResidentTimestamp;                      // 0x00D0(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x18];                                      // 0x00D8(0x0018) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Texture2D");
		return ptr;
	}


	int Blueprint_GetSizeY();
	int Blueprint_GetSizeX();
};


// Class Engine.LightMapTexture2D
// 0x0008 (0x00F8 - 0x00F0)
class ULightMapTexture2D : public UTexture2D
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x00F0(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LightMapTexture2D");
		return ptr;
	}

};


// Class Engine.LightmassCharacterIndirectDetailVolume
// 0x0000 (0x0350 - 0x0350)
class ALightmassCharacterIndirectDetailVolume : public AVolume
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LightmassCharacterIndirectDetailVolume");
		return ptr;
	}

};


// Class Engine.LightmassImportanceVolume
// 0x0000 (0x0350 - 0x0350)
class ALightmassImportanceVolume : public AVolume
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LightmassImportanceVolume");
		return ptr;
	}

};


// Class Engine.LightmassPortal
// 0x0008 (0x0320 - 0x0318)
class ALightmassPortal : public AActor
{
public:
	class ULightmassPortalComponent*                   PortalComponent;                                          // 0x0318(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ExportObject, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LightmassPortal");
		return ptr;
	}

};


// Class Engine.LightmassPortalComponent
// 0x0010 (0x02A0 - 0x0290)
class ULightmassPortalComponent : public USceneComponent
{
public:
	class UBoxComponent*                               PreviewBox;                                               // 0x0290(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x8];                                       // 0x0298(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LightmassPortalComponent");
		return ptr;
	}

};


// Class Engine.LightmassPrimitiveSettingsObject
// 0x0018 (0x0040 - 0x0028)
class ULightmassPrimitiveSettingsObject : public UObject
{
public:
	struct FLightmassPrimitiveSettings                 LightmassSettings;                                        // 0x0028(0x0018) (CPF_Edit)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LightmassPrimitiveSettingsObject");
		return ptr;
	}

};


// Class Engine.LineBatchComponent
// 0x0040 (0x06A0 - 0x0660)
class ULineBatchComponent : public UPrimitiveComponent
{
public:
	unsigned char                                      UnknownData00[0x40];                                      // 0x0660(0x0040) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LineBatchComponent");
		return ptr;
	}

};


// Class Engine.LocalPlayer
// 0x0168 (0x01B0 - 0x0048)
class ULocalPlayer : public UPlayer
{
public:
	unsigned char                                      UnknownData00[0x10];                                      // 0x0048(0x0010) MISSED OFFSET
	class UGameViewportClient*                         ViewportClient;                                           // 0x0058(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x1C];                                      // 0x0060(0x001C) MISSED OFFSET
	TEnumAsByte<EAspectRatioAxisConstraint>            AspectRatioAxisConstraint;                                // 0x007C(0x0001) (CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x3];                                       // 0x007D(0x0003) MISSED OFFSET
	class UClass*                                      PendingLevelPlayerControllerClass;                        // 0x0080(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bSentSplitJoin : 1;                                       // 0x0088(0x0001) (CPF_Edit, CPF_Transient, CPF_EditConst)
	unsigned char                                      UnknownData03[0x67];                                      // 0x0089(0x0067) MISSED OFFSET
	int                                                ControllerId;                                             // 0x00F0(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData04[0xBC];                                      // 0x00F4(0x00BC) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LocalPlayer");
		return ptr;
	}

};


// Class Engine.LODActor
// 0x0038 (0x0350 - 0x0318)
class ALODActor : public AActor
{
public:
	class UStaticMeshComponent*                        StaticMeshComponent;                                      // 0x0318(0x0008) (CPF_Edit, CPF_ExportObject, CPF_ZeroConstructor, CPF_EditConst, CPF_InstancedReference, CPF_IsPlainOldData)
	TArray<class AActor*>                              SubActors;                                                // 0x0320(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_EditConst)
	float                                              LODDrawDistance;                                          // 0x0330(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                LODLevel;                                                 // 0x0334(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)
	TArray<class UObject*>                             SubObjects;                                               // 0x0338(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_EditConst)
	unsigned char                                      UnknownData00[0x8];                                       // 0x0348(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.LODActor");
		return ptr;
	}

};


// Class Engine.MapBuildDataRegistry
// 0x01A0 (0x01C8 - 0x0028)
class UMapBuildDataRegistry : public UObject
{
public:
	TEnumAsByte<ELightingBuildQuality>                 LevelLightingQuality;                                     // 0x0028(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x19F];                                     // 0x0029(0x019F) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MapBuildDataRegistry");
		return ptr;
	}

};


// Class Engine.Material
// 0x0838 (0x08A8 - 0x0070)
class UMaterial : public UMaterialInterface
{
public:
	class UPhysicalMaterial*                           PhysMaterial;                                             // 0x0070(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FColorMaterialInput                         DiffuseColor;                                             // 0x0078(0x0038) (CPF_Deprecated)
	struct FColorMaterialInput                         SpecularColor;                                            // 0x00B0(0x0038) (CPF_Deprecated)
	struct FColorMaterialInput                         BaseColor;                                                // 0x00E8(0x0038)
	struct FScalarMaterialInput                        Metallic;                                                 // 0x0120(0x0038)
	struct FScalarMaterialInput                        Specular;                                                 // 0x0158(0x0038)
	struct FScalarMaterialInput                        Roughness;                                                // 0x0190(0x0038)
	struct FVectorMaterialInput                        Normal;                                                   // 0x01C8(0x0040)
	struct FColorMaterialInput                         EmissiveColor;                                            // 0x0208(0x0038)
	struct FScalarMaterialInput                        Opacity;                                                  // 0x0240(0x0038)
	struct FScalarMaterialInput                        OpacityMask;                                              // 0x0278(0x0038)
	TEnumAsByte<EMaterialDomain>                       MaterialDomain;                                           // 0x02B0(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EBlendMode>                            BlendMode;                                                // 0x02B1(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EDecalBlendMode>                       DecalBlendMode;                                           // 0x02B2(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EMaterialDecalResponse>                MaterialDecalResponse;                                    // 0x02B3(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EMaterialShadingModel>                 ShadingModel;                                             // 0x02B4(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x3];                                       // 0x02B5(0x0003) MISSED OFFSET
	float                                              OpacityMaskClipValue;                                     // 0x02B8(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bCastDynamicShadowAsMasked : 1;                           // 0x02BC(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData01[0x3];                                       // 0x02BD(0x0003) MISSED OFFSET
	struct FVectorMaterialInput                        WorldPositionOffset;                                      // 0x02C0(0x0040)
	struct FVectorMaterialInput                        WorldDisplacement;                                        // 0x0300(0x0040)
	struct FScalarMaterialInput                        TessellationMultiplier;                                   // 0x0340(0x0038)
	struct FColorMaterialInput                         SubsurfaceColor;                                          // 0x0378(0x0038)
	struct FScalarMaterialInput                        ClearCoat;                                                // 0x03B0(0x0038)
	struct FScalarMaterialInput                        ClearCoatRoughness;                                       // 0x03E8(0x0038)
	struct FScalarMaterialInput                        AmbientOcclusion;                                         // 0x0420(0x0038)
	struct FScalarMaterialInput                        Refraction;                                               // 0x0458(0x0038)
	struct FVector2MaterialInput                       CustomizedUVs[0x8];                                       // 0x0490(0x0040)
	struct FMaterialAttributesInput                    MaterialAttributes;                                       // 0x0690(0x0038)
	struct FScalarMaterialInput                        PixelDepthOffset;                                         // 0x06C8(0x0038)
	unsigned char                                      bEnableSeparateTranslucency : 1;                          // 0x0700(0x0001) (CPF_Edit)
	unsigned char                                      bEnableMobileSeparateTranslucency : 1;                    // 0x0700(0x0001) (CPF_Edit)
	unsigned char                                      bEnableResponsiveAA : 1;                                  // 0x0700(0x0001) (CPF_Edit)
	unsigned char                                      bScreenSpaceReflections : 1;                              // 0x0700(0x0001) (CPF_Edit)
	unsigned char                                      TwoSided : 1;                                             // 0x0700(0x0001) (CPF_Edit)
	unsigned char                                      DitheredLODTransition : 1;                                // 0x0700(0x0001) (CPF_Edit)
	unsigned char                                      DitherOpacityMask : 1;                                    // 0x0700(0x0001) (CPF_Edit)
	unsigned char                                      bAllowNegativeEmissiveColor : 1;                          // 0x0700(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData02[0x3];                                       // 0x0701(0x0003) MISSED OFFSET
	int                                                NumCustomizedUVs;                                         // 0x0704(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ETranslucencyLightingMode>             TranslucencyLightingMode;                                 // 0x0708(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData03[0x3];                                       // 0x0709(0x0003) MISSED OFFSET
	float                                              TranslucencyDirectionalLightingIntensity;                 // 0x070C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      AllowTranslucentCustomDepthWrites : 1;                    // 0x0710(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData04[0x3];                                       // 0x0711(0x0003) MISSED OFFSET
	float                                              TranslucentShadowDensityScale;                            // 0x0714(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              TranslucentSelfShadowDensityScale;                        // 0x0718(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              TranslucentSelfShadowSecondDensityScale;                  // 0x071C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              TranslucentSelfShadowSecondOpacity;                       // 0x0720(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              TranslucentBackscatteringExponent;                        // 0x0724(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FLinearColor                                TranslucentMultipleScatteringExtinction;                  // 0x0728(0x0010) (CPF_Edit, CPF_IsPlainOldData)
	float                                              TranslucentShadowStartOffset;                             // 0x0738(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bDisableDepthTest : 1;                                    // 0x073C(0x0001) (CPF_Edit)
	unsigned char                                      bGenerateSphericalParticleNormals : 1;                    // 0x073C(0x0001) (CPF_Edit)
	unsigned char                                      bTangentSpaceNormal : 1;                                  // 0x073C(0x0001) (CPF_Edit)
	unsigned char                                      bUseEmissiveForDynamicAreaLighting : 1;                   // 0x073C(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bBlockGI : 1;                                             // 0x073C(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bUsedAsSpecialEngineMaterial : 1;                         // 0x073C(0x0001) (CPF_DuplicateTransient)
	unsigned char                                      bUsedWithSkeletalMesh : 1;                                // 0x073C(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUsedWithEditorCompositing : 1;                           // 0x073C(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUsedWithParticleSprites : 1;                             // 0x073D(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUsedWithBeamTrails : 1;                                  // 0x073D(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUsedWithMeshParticles : 1;                               // 0x073D(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUsedWithNiagaraSprites : 1;                              // 0x073D(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUsedWithNiagaraRibbons : 1;                              // 0x073D(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUsedWithNiagaraMeshParticles : 1;                        // 0x073D(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUsedWithStaticLighting : 1;                              // 0x073D(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUsedWithMorphTargets : 1;                                // 0x073D(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUsedWithSplineMeshes : 1;                                // 0x073E(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUsedWithInstancedStaticMeshes : 1;                       // 0x073E(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUsesDistortion : 1;                                      // 0x073E(0x0001)
	unsigned char                                      bUsedWithClothing : 1;                                    // 0x073E(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUsedWithUI : 1;                                          // 0x073E(0x0001) (CPF_Deprecated)
	unsigned char                                      bAutomaticallySetUsageInEditor : 1;                       // 0x073E(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bFullyRough : 1;                                          // 0x073E(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUseFullPrecision : 1;                                    // 0x073E(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUseLightmapDirectionality : 1;                           // 0x073F(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUseHQForwardReflections : 1;                             // 0x073F(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bUsePlanarForwardReflections : 1;                         // 0x073F(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bNormalCurvatureToRoughness : 1;                          // 0x073F(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	TEnumAsByte<EMaterialTessellationMode>             D3D11TessellationMode;                                    // 0x0740(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData05[0x3];                                       // 0x0741(0x0003) MISSED OFFSET
	unsigned char                                      bEnableCrackFreeDisplacement : 1;                         // 0x0744(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      bEnableAdaptiveTessellation : 1;                          // 0x0744(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly)
	unsigned char                                      UnknownData06[0x3];                                       // 0x0745(0x0003) MISSED OFFSET
	float                                              MaxDisplacement;                                          // 0x0748(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      Wireframe : 1;                                            // 0x074C(0x0001) (CPF_Edit)
	unsigned char                                      bOutputVelocityOnBasePass : 1;                            // 0x074C(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData07[0x3];                                       // 0x074D(0x0003) MISSED OFFSET
	int                                                EditorX;                                                  // 0x0750(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                EditorY;                                                  // 0x0754(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                EditorPitch;                                              // 0x0758(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                EditorYaw;                                                // 0x075C(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<class UMaterialExpression*>                 Expressions;                                              // 0x0760(0x0010) (CPF_ZeroConstructor)
	TArray<struct FMaterialFunctionInfo>               MaterialFunctionInfos;                                    // 0x0770(0x0010) (CPF_ZeroConstructor)
	TArray<struct FMaterialParameterCollectionInfo>    MaterialParameterCollectionInfos;                         // 0x0780(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      bCanMaskedBeAssumedOpaque : 1;                            // 0x0790(0x0001)
	unsigned char                                      bIsMasked : 1;                                            // 0x0790(0x0001) (CPF_Deprecated)
	unsigned char                                      bIsPreviewMaterial : 1;                                   // 0x0790(0x0001) (CPF_Transient, CPF_DuplicateTransient)
	unsigned char                                      bIsFunctionPreviewMaterial : 1;                           // 0x0790(0x0001) (CPF_Transient, CPF_DuplicateTransient)
	unsigned char                                      bUseMaterialAttributes : 1;                               // 0x0790(0x0001) (CPF_Edit)
	unsigned char                                      bUseTranslucencyVertexFog : 1;                            // 0x0790(0x0001) (CPF_Edit)
	unsigned char                                      bComputeFogPerPixel : 1;                                  // 0x0790(0x0001) (CPF_Edit)
	unsigned char                                      bAllowDevelopmentShaderCompile : 1;                       // 0x0790(0x0001) (CPF_Transient, CPF_DuplicateTransient)
	unsigned char                                      bIsMaterialEditorStatsMaterial : 1;                       // 0x0791(0x0001) (CPF_Transient, CPF_DuplicateTransient)
	unsigned char                                      UnknownData08[0x2];                                       // 0x0792(0x0002) MISSED OFFSET
	uint32_t                                           UsageFlagWarnings;                                        // 0x0794(0x0004) (CPF_ZeroConstructor, CPF_Transient, CPF_DuplicateTransient, CPF_IsPlainOldData)
	TEnumAsByte<EBlendableLocation>                    BlendableLocation;                                        // 0x0798(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData09[0x3];                                       // 0x0799(0x0003) MISSED OFFSET
	int                                                BlendablePriority;                                        // 0x079C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               BlendableOutputAlpha;                                     // 0x07A0(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ERefractionMode>                       RefractionMode;                                           // 0x07A1(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData10[0x2];                                       // 0x07A2(0x0002) MISSED OFFSET
	float                                              RefractionDepthBias;                                      // 0x07A4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FGuid                                       StateId;                                                  // 0x07A8(0x0010) (CPF_IsPlainOldData)
	unsigned char                                      UnknownData11[0xE0];                                      // 0x07B8(0x00E0) MISSED OFFSET
	TArray<class UTexture*>                            ExpressionTextureReferences;                              // 0x0898(0x0010) (CPF_ZeroConstructor, CPF_Transient)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.Material");
		return ptr;
	}

};


// Class Engine.MaterialBillboardComponent
// 0x0010 (0x0670 - 0x0660)
class UMaterialBillboardComponent : public UPrimitiveComponent
{
public:
	TArray<struct FMaterialSpriteElement>              Elements;                                                 // 0x0660(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialBillboardComponent");
		return ptr;
	}


	void SetElements(TArray<struct FMaterialSpriteElement> NewElements);
	void AddElement(class UMaterialInterface* Material, class UCurveFloat* DistanceToOpacityCurve, bool bSizeIsInScreenSpace, float BaseSizeX, float BaseSizeY, class UCurveFloat* DistanceToSizeCurve);
};


// Class Engine.MaterialExpressionAbs
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionAbs : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionAbs");
		return ptr;
	}

};


// Class Engine.MaterialExpressionActorPositionWS
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionActorPositionWS : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionActorPositionWS");
		return ptr;
	}

};


// Class Engine.MaterialExpressionAdd
// 0x0068 (0x00C8 - 0x0060)
class UMaterialExpressionAdd : public UMaterialExpression
{
public:
	struct FExpressionInput                            A;                                                        // 0x0060(0x0030)
	struct FExpressionInput                            B;                                                        // 0x0090(0x0030)
	float                                              ConstA;                                                   // 0x00C0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ConstB;                                                   // 0x00C4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionAdd");
		return ptr;
	}

};


// Class Engine.MaterialExpressionTextureBase
// 0x0010 (0x0070 - 0x0060)
class UMaterialExpressionTextureBase : public UMaterialExpression
{
public:
	class UTexture*                                    Texture;                                                  // 0x0060(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EMaterialSamplerType>                  SamplerType;                                              // 0x0068(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0069(0x0003) MISSED OFFSET
	unsigned char                                      IsDefaultMeshpaintTexture : 1;                            // 0x006C(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData01[0x3];                                       // 0x006D(0x0003) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionTextureBase");
		return ptr;
	}

};


// Class Engine.MaterialExpressionTextureSample
// 0x0108 (0x0178 - 0x0070)
class UMaterialExpressionTextureSample : public UMaterialExpressionTextureBase
{
public:
	struct FExpressionInput                            coordinates;                                              // 0x0070(0x0030)
	struct FExpressionInput                            TextureObject;                                            // 0x00A0(0x0030)
	struct FExpressionInput                            MipValue;                                                 // 0x00D0(0x0030)
	struct FExpressionInput                            CoordinatesDX;                                            // 0x0100(0x0030)
	struct FExpressionInput                            CoordinatesDY;                                            // 0x0130(0x0030)
	TEnumAsByte<ETextureMipValueMode>                  MipValueMode;                                             // 0x0160(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ESamplerSourceMode>                    SamplerSource;                                            // 0x0161(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x2];                                       // 0x0162(0x0002) MISSED OFFSET
	uint32_t                                           ConstCoordinate;                                          // 0x0164(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                ConstMipValue;                                            // 0x0168(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      AutomaticViewMipBias : 1;                                 // 0x016C(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData01[0xB];                                       // 0x016D(0x000B) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionTextureSample");
		return ptr;
	}

};


// Class Engine.MaterialExpressionTextureSampleParameter
// 0x0020 (0x0198 - 0x0178)
class UMaterialExpressionTextureSampleParameter : public UMaterialExpressionTextureSample
{
public:
	struct FName                                       ParameterName;                                            // 0x0178(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FGuid                                       ExpressionGUID;                                           // 0x0180(0x0010) (CPF_IsPlainOldData)
	struct FName                                       Group;                                                    // 0x0190(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionTextureSampleParameter");
		return ptr;
	}

};


// Class Engine.MaterialExpressionTextureSampleParameter2D
// 0x0000 (0x0198 - 0x0198)
class UMaterialExpressionTextureSampleParameter2D : public UMaterialExpressionTextureSampleParameter
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionTextureSampleParameter2D");
		return ptr;
	}

};


// Class Engine.MaterialExpressionAntialiasedTextureMask
// 0x0008 (0x01A0 - 0x0198)
class UMaterialExpressionAntialiasedTextureMask : public UMaterialExpressionTextureSampleParameter2D
{
public:
	float                                              Threshold;                                                // 0x0198(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ETextureColorChannel>                  Channel;                                                  // 0x019C(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x3];                                       // 0x019D(0x0003) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionAntialiasedTextureMask");
		return ptr;
	}

};


// Class Engine.MaterialExpressionAppendVector
// 0x0060 (0x00C0 - 0x0060)
class UMaterialExpressionAppendVector : public UMaterialExpression
{
public:
	struct FExpressionInput                            A;                                                        // 0x0060(0x0030)
	struct FExpressionInput                            B;                                                        // 0x0090(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionAppendVector");
		return ptr;
	}

};


// Class Engine.MaterialExpressionArccosine
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionArccosine : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionArccosine");
		return ptr;
	}

};


// Class Engine.MaterialExpressionArccosineFast
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionArccosineFast : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionArccosineFast");
		return ptr;
	}

};


// Class Engine.MaterialExpressionArcsine
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionArcsine : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionArcsine");
		return ptr;
	}

};


// Class Engine.MaterialExpressionArcsineFast
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionArcsineFast : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionArcsineFast");
		return ptr;
	}

};


// Class Engine.MaterialExpressionArctangent
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionArctangent : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionArctangent");
		return ptr;
	}

};


// Class Engine.MaterialExpressionArctangent2
// 0x0060 (0x00C0 - 0x0060)
class UMaterialExpressionArctangent2 : public UMaterialExpression
{
public:
	struct FExpressionInput                            Y;                                                        // 0x0060(0x0030)
	struct FExpressionInput                            X;                                                        // 0x0090(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionArctangent2");
		return ptr;
	}

};


// Class Engine.MaterialExpressionArctangent2Fast
// 0x0060 (0x00C0 - 0x0060)
class UMaterialExpressionArctangent2Fast : public UMaterialExpression
{
public:
	struct FExpressionInput                            Y;                                                        // 0x0060(0x0030)
	struct FExpressionInput                            X;                                                        // 0x0090(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionArctangent2Fast");
		return ptr;
	}

};


// Class Engine.MaterialExpressionArctangentFast
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionArctangentFast : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionArctangentFast");
		return ptr;
	}

};


// Class Engine.MaterialExpressionAtmosphericFogColor
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionAtmosphericFogColor : public UMaterialExpression
{
public:
	struct FExpressionInput                            WorldPosition;                                            // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionAtmosphericFogColor");
		return ptr;
	}

};


// Class Engine.MaterialExpressionAtmosphericLightColor
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionAtmosphericLightColor : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionAtmosphericLightColor");
		return ptr;
	}

};


// Class Engine.MaterialExpressionAtmosphericLightVector
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionAtmosphericLightVector : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionAtmosphericLightVector");
		return ptr;
	}

};


// Class Engine.MaterialExpressionBentNormalCustomOutput
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionBentNormalCustomOutput : public UMaterialExpressionCustomOutput
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionBentNormalCustomOutput");
		return ptr;
	}

};


// Class Engine.MaterialExpressionBlackBody
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionBlackBody : public UMaterialExpression
{
public:
	struct FExpressionInput                            Temp;                                                     // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionBlackBody");
		return ptr;
	}

};


// Class Engine.MaterialExpressionBlendMaterialAttributes
// 0x00A8 (0x0108 - 0x0060)
class UMaterialExpressionBlendMaterialAttributes : public UMaterialExpression
{
public:
	struct FMaterialAttributesInput                    A;                                                        // 0x0060(0x0038)
	struct FMaterialAttributesInput                    B;                                                        // 0x0098(0x0038)
	struct FExpressionInput                            Alpha;                                                    // 0x00D0(0x0030)
	TEnumAsByte<EMaterialAttributeBlend>               PixelAttributeBlendType;                                  // 0x0100(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EMaterialAttributeBlend>               VertexAttributeBlendType;                                 // 0x0101(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x6];                                       // 0x0102(0x0006) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionBlendMaterialAttributes");
		return ptr;
	}

};


// Class Engine.MaterialExpressionBreakMaterialAttributes
// 0x0038 (0x0098 - 0x0060)
class UMaterialExpressionBreakMaterialAttributes : public UMaterialExpression
{
public:
	struct FMaterialAttributesInput                    MaterialAttributes;                                       // 0x0060(0x0038)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionBreakMaterialAttributes");
		return ptr;
	}

};


// Class Engine.MaterialExpressionBumpOffset
// 0x00A0 (0x0100 - 0x0060)
class UMaterialExpressionBumpOffset : public UMaterialExpression
{
public:
	struct FExpressionInput                            Coordinate;                                               // 0x0060(0x0030)
	struct FExpressionInput                            Height;                                                   // 0x0090(0x0030)
	struct FExpressionInput                            HeightRatioInput;                                         // 0x00C0(0x0030)
	float                                              HeightRatio;                                              // 0x00F0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ReferencePlane;                                           // 0x00F4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	uint32_t                                           ConstCoordinate;                                          // 0x00F8(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x00FC(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionBumpOffset");
		return ptr;
	}

};


// Class Engine.MaterialExpressionCameraPositionWS
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionCameraPositionWS : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionCameraPositionWS");
		return ptr;
	}

};


// Class Engine.MaterialExpressionCameraVectorWS
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionCameraVectorWS : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionCameraVectorWS");
		return ptr;
	}

};


// Class Engine.MaterialExpressionCeil
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionCeil : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionCeil");
		return ptr;
	}

};


// Class Engine.MaterialExpressionParameter
// 0x0020 (0x0080 - 0x0060)
class UMaterialExpressionParameter : public UMaterialExpression
{
public:
	struct FName                                       ParameterName;                                            // 0x0060(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FGuid                                       ExpressionGUID;                                           // 0x0068(0x0010) (CPF_IsPlainOldData)
	struct FName                                       Group;                                                    // 0x0078(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionParameter");
		return ptr;
	}

};


// Class Engine.MaterialExpressionVectorParameter
// 0x0010 (0x0090 - 0x0080)
class UMaterialExpressionVectorParameter : public UMaterialExpressionParameter
{
public:
	struct FLinearColor                                DefaultValue;                                             // 0x0080(0x0010) (CPF_Edit, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionVectorParameter");
		return ptr;
	}

};


// Class Engine.MaterialExpressionChannelMaskParameter
// 0x0038 (0x00C8 - 0x0090)
class UMaterialExpressionChannelMaskParameter : public UMaterialExpressionVectorParameter
{
public:
	TEnumAsByte<EChannelMaskParameterColor>            MaskChannel;                                              // 0x0090(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0091(0x0007) MISSED OFFSET
	struct FExpressionInput                            Input;                                                    // 0x0098(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionChannelMaskParameter");
		return ptr;
	}

};


// Class Engine.MaterialExpressionClamp
// 0x00A0 (0x0100 - 0x0060)
class UMaterialExpressionClamp : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)
	struct FExpressionInput                            Min;                                                      // 0x0090(0x0030)
	struct FExpressionInput                            Max;                                                      // 0x00C0(0x0030)
	TEnumAsByte<EClampMode>                            ClampMode;                                                // 0x00F0(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x3];                                       // 0x00F1(0x0003) MISSED OFFSET
	float                                              MinDefault;                                               // 0x00F4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              MaxDefault;                                               // 0x00F8(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x00FC(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionClamp");
		return ptr;
	}

};


// Class Engine.MaterialExpressionClearCoatNormalCustomOutput
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionClearCoatNormalCustomOutput : public UMaterialExpressionCustomOutput
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionClearCoatNormalCustomOutput");
		return ptr;
	}

};


// Class Engine.MaterialExpressionCollectionParameter
// 0x0020 (0x0080 - 0x0060)
class UMaterialExpressionCollectionParameter : public UMaterialExpression
{
public:
	class UMaterialParameterCollection*                Collection;                                               // 0x0060(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FName                                       ParameterName;                                            // 0x0068(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FGuid                                       ParameterId;                                              // 0x0070(0x0010) (CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionCollectionParameter");
		return ptr;
	}

};


// Class Engine.MaterialExpressionComment
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionComment : public UMaterialExpression
{
public:
	int                                                SizeX;                                                    // 0x0060(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                SizeY;                                                    // 0x0064(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FString                                     Text;                                                     // 0x0068(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	struct FLinearColor                                CommentColor;                                             // 0x0078(0x0010) (CPF_Edit, CPF_IsPlainOldData)
	int                                                FontSize;                                                 // 0x0088(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x008C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionComment");
		return ptr;
	}

};


// Class Engine.MaterialExpressionComponentMask
// 0x0038 (0x0098 - 0x0060)
class UMaterialExpressionComponentMask : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)
	unsigned char                                      R : 1;                                                    // 0x0090(0x0001) (CPF_Edit)
	unsigned char                                      G : 1;                                                    // 0x0090(0x0001) (CPF_Edit)
	unsigned char                                      B : 1;                                                    // 0x0090(0x0001) (CPF_Edit)
	unsigned char                                      A : 1;                                                    // 0x0090(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0091(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionComponentMask");
		return ptr;
	}

};


// Class Engine.MaterialExpressionConstant
// 0x0008 (0x0068 - 0x0060)
class UMaterialExpressionConstant : public UMaterialExpression
{
public:
	float                                              R;                                                        // 0x0060(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x0064(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionConstant");
		return ptr;
	}

};


// Class Engine.MaterialExpressionConstant2Vector
// 0x0008 (0x0068 - 0x0060)
class UMaterialExpressionConstant2Vector : public UMaterialExpression
{
public:
	float                                              R;                                                        // 0x0060(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              G;                                                        // 0x0064(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionConstant2Vector");
		return ptr;
	}

};


// Class Engine.MaterialExpressionConstant3Vector
// 0x0010 (0x0070 - 0x0060)
class UMaterialExpressionConstant3Vector : public UMaterialExpression
{
public:
	struct FLinearColor                                Constant;                                                 // 0x0060(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionConstant3Vector");
		return ptr;
	}

};


// Class Engine.MaterialExpressionConstant4Vector
// 0x0010 (0x0070 - 0x0060)
class UMaterialExpressionConstant4Vector : public UMaterialExpression
{
public:
	struct FLinearColor                                Constant;                                                 // 0x0060(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionConstant4Vector");
		return ptr;
	}

};


// Class Engine.MaterialExpressionConstantBiasScale
// 0x0038 (0x0098 - 0x0060)
class UMaterialExpressionConstantBiasScale : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)
	float                                              Bias;                                                     // 0x0090(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              Scale;                                                    // 0x0094(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionConstantBiasScale");
		return ptr;
	}

};


// Class Engine.MaterialExpressionCosine
// 0x0038 (0x0098 - 0x0060)
class UMaterialExpressionCosine : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)
	float                                              Period;                                                   // 0x0090(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x0094(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionCosine");
		return ptr;
	}

};


// Class Engine.MaterialExpressionCrossProduct
// 0x0060 (0x00C0 - 0x0060)
class UMaterialExpressionCrossProduct : public UMaterialExpression
{
public:
	struct FExpressionInput                            A;                                                        // 0x0060(0x0030)
	struct FExpressionInput                            B;                                                        // 0x0090(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionCrossProduct");
		return ptr;
	}

};


// Class Engine.MaterialExpressionCustom
// 0x0038 (0x0098 - 0x0060)
class UMaterialExpressionCustom : public UMaterialExpression
{
public:
	struct FString                                     Code;                                                     // 0x0060(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	TEnumAsByte<ECustomMaterialOutputType>             OutputType;                                               // 0x0070(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0071(0x0007) MISSED OFFSET
	struct FString                                     Description;                                              // 0x0078(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	TArray<struct FCustomInput>                        Inputs;                                                   // 0x0088(0x0010) (CPF_Edit, CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionCustom");
		return ptr;
	}

};


// Class Engine.MaterialExpressionDDX
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionDDX : public UMaterialExpression
{
public:
	struct FExpressionInput                            Value;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionDDX");
		return ptr;
	}

};


// Class Engine.MaterialExpressionDDY
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionDDY : public UMaterialExpression
{
public:
	struct FExpressionInput                            Value;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionDDY");
		return ptr;
	}

};


// Class Engine.MaterialExpressionDecalDerivative
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionDecalDerivative : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionDecalDerivative");
		return ptr;
	}

};


// Class Engine.MaterialExpressionDecalLifetimeOpacity
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionDecalLifetimeOpacity : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionDecalLifetimeOpacity");
		return ptr;
	}

};


// Class Engine.MaterialExpressionDecalMipmapLevel
// 0x0038 (0x0098 - 0x0060)
class UMaterialExpressionDecalMipmapLevel : public UMaterialExpression
{
public:
	struct FExpressionInput                            TextureSize;                                              // 0x0060(0x0030)
	float                                              ConstWidth;                                               // 0x0090(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ConstHeight;                                              // 0x0094(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionDecalMipmapLevel");
		return ptr;
	}

};


// Class Engine.MaterialExpressionDepthFade
// 0x0068 (0x00C8 - 0x0060)
class UMaterialExpressionDepthFade : public UMaterialExpression
{
public:
	struct FExpressionInput                            InOpacity;                                                // 0x0060(0x0030)
	struct FExpressionInput                            FadeDistance;                                             // 0x0090(0x0030)
	float                                              OpacityDefault;                                           // 0x00C0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              FadeDistanceDefault;                                      // 0x00C4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionDepthFade");
		return ptr;
	}

};


// Class Engine.MaterialExpressionDepthOfFieldFunction
// 0x0038 (0x0098 - 0x0060)
class UMaterialExpressionDepthOfFieldFunction : public UMaterialExpression
{
public:
	TEnumAsByte<EDepthOfFieldFunctionValue>            FunctionValue;                                            // 0x0060(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0061(0x0007) MISSED OFFSET
	struct FExpressionInput                            Depth;                                                    // 0x0068(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionDepthOfFieldFunction");
		return ptr;
	}

};


// Class Engine.MaterialExpressionDeriveNormalZ
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionDeriveNormalZ : public UMaterialExpression
{
public:
	struct FExpressionInput                            InXY;                                                     // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionDeriveNormalZ");
		return ptr;
	}

};


// Class Engine.MaterialExpressionDesaturation
// 0x0070 (0x00D0 - 0x0060)
class UMaterialExpressionDesaturation : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)
	struct FExpressionInput                            Fraction;                                                 // 0x0090(0x0030)
	struct FLinearColor                                LuminanceFactors;                                         // 0x00C0(0x0010) (CPF_Edit, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionDesaturation");
		return ptr;
	}

};


// Class Engine.MaterialExpressionDistance
// 0x0060 (0x00C0 - 0x0060)
class UMaterialExpressionDistance : public UMaterialExpression
{
public:
	struct FExpressionInput                            A;                                                        // 0x0060(0x0030)
	struct FExpressionInput                            B;                                                        // 0x0090(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionDistance");
		return ptr;
	}

};


// Class Engine.MaterialExpressionDistanceCullFade
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionDistanceCullFade : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionDistanceCullFade");
		return ptr;
	}

};


// Class Engine.MaterialExpressionDistanceFieldGradient
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionDistanceFieldGradient : public UMaterialExpression
{
public:
	struct FExpressionInput                            Position;                                                 // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionDistanceFieldGradient");
		return ptr;
	}

};


// Class Engine.MaterialExpressionDistanceToNearestSurface
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionDistanceToNearestSurface : public UMaterialExpression
{
public:
	struct FExpressionInput                            Position;                                                 // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionDistanceToNearestSurface");
		return ptr;
	}

};


// Class Engine.MaterialExpressionDivide
// 0x0068 (0x00C8 - 0x0060)
class UMaterialExpressionDivide : public UMaterialExpression
{
public:
	struct FExpressionInput                            A;                                                        // 0x0060(0x0030)
	struct FExpressionInput                            B;                                                        // 0x0090(0x0030)
	float                                              ConstA;                                                   // 0x00C0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ConstB;                                                   // 0x00C4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionDivide");
		return ptr;
	}

};


// Class Engine.MaterialExpressionDotProduct
// 0x0060 (0x00C0 - 0x0060)
class UMaterialExpressionDotProduct : public UMaterialExpression
{
public:
	struct FExpressionInput                            A;                                                        // 0x0060(0x0030)
	struct FExpressionInput                            B;                                                        // 0x0090(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionDotProduct");
		return ptr;
	}

};


// Class Engine.MaterialExpressionDynamicParameter
// 0x0020 (0x0080 - 0x0060)
class UMaterialExpressionDynamicParameter : public UMaterialExpression
{
public:
	TArray<struct FString>                             ParamNames;                                               // 0x0060(0x0010) (CPF_Edit, CPF_EditFixedSize, CPF_ZeroConstructor)
	struct FLinearColor                                DefaultValue;                                             // 0x0070(0x0010) (CPF_Edit, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionDynamicParameter");
		return ptr;
	}

};


// Class Engine.MaterialExpressionEyeAdaptation
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionEyeAdaptation : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionEyeAdaptation");
		return ptr;
	}

};


// Class Engine.MaterialExpressionFeatureLevelSwitch
// 0x00F0 (0x0150 - 0x0060)
class UMaterialExpressionFeatureLevelSwitch : public UMaterialExpression
{
public:
	struct FExpressionInput                            Default;                                                  // 0x0060(0x0030)
	struct FExpressionInput                            Inputs[0x4];                                              // 0x0090(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionFeatureLevelSwitch");
		return ptr;
	}

};


// Class Engine.MaterialExpressionFloor
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionFloor : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionFloor");
		return ptr;
	}

};


// Class Engine.MaterialExpressionFmod
// 0x0060 (0x00C0 - 0x0060)
class UMaterialExpressionFmod : public UMaterialExpression
{
public:
	struct FExpressionInput                            A;                                                        // 0x0060(0x0030)
	struct FExpressionInput                            B;                                                        // 0x0090(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionFmod");
		return ptr;
	}

};


// Class Engine.MaterialExpressionFontSample
// 0x0010 (0x0070 - 0x0060)
class UMaterialExpressionFontSample : public UMaterialExpression
{
public:
	class UFont*                                       Font;                                                     // 0x0060(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                FontTexturePage;                                          // 0x0068(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x006C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionFontSample");
		return ptr;
	}

};


// Class Engine.MaterialExpressionFontSampleParameter
// 0x0020 (0x0090 - 0x0070)
class UMaterialExpressionFontSampleParameter : public UMaterialExpressionFontSample
{
public:
	struct FName                                       ParameterName;                                            // 0x0070(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FGuid                                       ExpressionGUID;                                           // 0x0078(0x0010) (CPF_IsPlainOldData)
	struct FName                                       Group;                                                    // 0x0088(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionFontSampleParameter");
		return ptr;
	}

};


// Class Engine.MaterialExpressionFrac
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionFrac : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionFrac");
		return ptr;
	}

};


// Class Engine.MaterialExpressionFresnel
// 0x00A0 (0x0100 - 0x0060)
class UMaterialExpressionFresnel : public UMaterialExpression
{
public:
	struct FExpressionInput                            ExponentIn;                                               // 0x0060(0x0030)
	float                                              Exponent;                                                 // 0x0090(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x0094(0x0004) MISSED OFFSET
	struct FExpressionInput                            BaseReflectFractionIn;                                    // 0x0098(0x0030)
	float                                              BaseReflectFraction;                                      // 0x00C8(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x00CC(0x0004) MISSED OFFSET
	struct FExpressionInput                            Normal;                                                   // 0x00D0(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionFresnel");
		return ptr;
	}

};


// Class Engine.MaterialExpressionFunctionInput
// 0x00B0 (0x0110 - 0x0060)
class UMaterialExpressionFunctionInput : public UMaterialExpression
{
public:
	struct FExpressionInput                            Preview;                                                  // 0x0060(0x0030)
	struct FName                                       InputName;                                                // 0x0090(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FString                                     Description;                                              // 0x0098(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	struct FGuid                                       ID;                                                       // 0x00A8(0x0010) (CPF_IsPlainOldData)
	TEnumAsByte<EFunctionInputType>                    InputType;                                                // 0x00B8(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x00B9(0x0007) MISSED OFFSET
	struct FVector4                                    PreviewValue;                                             // 0x00C0(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_IsPlainOldData)
	unsigned char                                      bUsePreviewValueAsDefault : 1;                            // 0x00D0(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData01[0x3];                                       // 0x00D1(0x0003) MISSED OFFSET
	int                                                SortPriority;                                             // 0x00D4(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bCompilingFunctionPreview : 1;                            // 0x00D8(0x0001) (CPF_Transient)
	unsigned char                                      UnknownData02[0x37];                                      // 0x00D9(0x0037) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionFunctionInput");
		return ptr;
	}

};


// Class Engine.MaterialExpressionFunctionOutput
// 0x0068 (0x00C8 - 0x0060)
class UMaterialExpressionFunctionOutput : public UMaterialExpression
{
public:
	struct FName                                       OutputName;                                               // 0x0060(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FString                                     Description;                                              // 0x0068(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	int                                                SortPriority;                                             // 0x0078(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x007C(0x0004) MISSED OFFSET
	struct FExpressionInput                            A;                                                        // 0x0080(0x0030)
	unsigned char                                      bLastPreviewed : 1;                                       // 0x00B0(0x0001)
	unsigned char                                      UnknownData01[0x3];                                       // 0x00B1(0x0003) MISSED OFFSET
	struct FGuid                                       ID;                                                       // 0x00B4(0x0010) (CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x4];                                       // 0x00C4(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionFunctionOutput");
		return ptr;
	}

};


// Class Engine.MaterialExpressionGetMaterialAttributes
// 0x0048 (0x00A8 - 0x0060)
class UMaterialExpressionGetMaterialAttributes : public UMaterialExpression
{
public:
	struct FMaterialAttributesInput                    MaterialAttributes;                                       // 0x0060(0x0038)
	TArray<struct FGuid>                               AttributeGetTypes;                                        // 0x0098(0x0010) (CPF_Edit, CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionGetMaterialAttributes");
		return ptr;
	}

};


// Class Engine.MaterialExpressionGIReplace
// 0x0090 (0x00F0 - 0x0060)
class UMaterialExpressionGIReplace : public UMaterialExpression
{
public:
	struct FExpressionInput                            Default;                                                  // 0x0060(0x0030)
	struct FExpressionInput                            StaticIndirect;                                           // 0x0090(0x0030)
	struct FExpressionInput                            DynamicIndirect;                                          // 0x00C0(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionGIReplace");
		return ptr;
	}

};


// Class Engine.MaterialExpressionIf
// 0x0100 (0x0160 - 0x0060)
class UMaterialExpressionIf : public UMaterialExpression
{
public:
	struct FExpressionInput                            A;                                                        // 0x0060(0x0030)
	struct FExpressionInput                            B;                                                        // 0x0090(0x0030)
	struct FExpressionInput                            AGreaterThanB;                                            // 0x00C0(0x0030)
	struct FExpressionInput                            AEqualsB;                                                 // 0x00F0(0x0030)
	struct FExpressionInput                            ALessThanB;                                               // 0x0120(0x0030)
	float                                              EqualsThreshold;                                          // 0x0150(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ConstB;                                                   // 0x0154(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ConstAEqualsB;                                            // 0x0158(0x0004) (CPF_ZeroConstructor, CPF_Deprecated, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x015C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionIf");
		return ptr;
	}

};


// Class Engine.MaterialExpressionLightmapUVs
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionLightmapUVs : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionLightmapUVs");
		return ptr;
	}

};


// Class Engine.MaterialExpressionLightmassReplace
// 0x0060 (0x00C0 - 0x0060)
class UMaterialExpressionLightmassReplace : public UMaterialExpression
{
public:
	struct FExpressionInput                            Realtime;                                                 // 0x0060(0x0030)
	struct FExpressionInput                            Lightmass;                                                // 0x0090(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionLightmassReplace");
		return ptr;
	}

};


// Class Engine.MaterialExpressionLightVector
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionLightVector : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionLightVector");
		return ptr;
	}

};


// Class Engine.MaterialExpressionLinearInterpolate
// 0x00A0 (0x0100 - 0x0060)
class UMaterialExpressionLinearInterpolate : public UMaterialExpression
{
public:
	struct FExpressionInput                            A;                                                        // 0x0060(0x0030)
	struct FExpressionInput                            B;                                                        // 0x0090(0x0030)
	struct FExpressionInput                            Alpha;                                                    // 0x00C0(0x0030)
	float                                              ConstA;                                                   // 0x00F0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ConstB;                                                   // 0x00F4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ConstAlpha;                                               // 0x00F8(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x00FC(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionLinearInterpolate");
		return ptr;
	}

};


// Class Engine.MaterialExpressionLogarithm10
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionLogarithm10 : public UMaterialExpression
{
public:
	struct FExpressionInput                            X;                                                        // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionLogarithm10");
		return ptr;
	}

};


// Class Engine.MaterialExpressionLogarithm2
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionLogarithm2 : public UMaterialExpression
{
public:
	struct FExpressionInput                            X;                                                        // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionLogarithm2");
		return ptr;
	}

};


// Class Engine.MaterialExpressionMakeMaterialAttributes
// 0x04B0 (0x0510 - 0x0060)
class UMaterialExpressionMakeMaterialAttributes : public UMaterialExpression
{
public:
	struct FExpressionInput                            BaseColor;                                                // 0x0060(0x0030)
	struct FExpressionInput                            Metallic;                                                 // 0x0090(0x0030)
	struct FExpressionInput                            Specular;                                                 // 0x00C0(0x0030)
	struct FExpressionInput                            Roughness;                                                // 0x00F0(0x0030)
	struct FExpressionInput                            EmissiveColor;                                            // 0x0120(0x0030)
	struct FExpressionInput                            Opacity;                                                  // 0x0150(0x0030)
	struct FExpressionInput                            OpacityMask;                                              // 0x0180(0x0030)
	struct FExpressionInput                            Normal;                                                   // 0x01B0(0x0030)
	struct FExpressionInput                            WorldPositionOffset;                                      // 0x01E0(0x0030)
	struct FExpressionInput                            WorldDisplacement;                                        // 0x0210(0x0030)
	struct FExpressionInput                            TessellationMultiplier;                                   // 0x0240(0x0030)
	struct FExpressionInput                            SubsurfaceColor;                                          // 0x0270(0x0030)
	struct FExpressionInput                            ClearCoat;                                                // 0x02A0(0x0030)
	struct FExpressionInput                            ClearCoatRoughness;                                       // 0x02D0(0x0030)
	struct FExpressionInput                            AmbientOcclusion;                                         // 0x0300(0x0030)
	struct FExpressionInput                            Refraction;                                               // 0x0330(0x0030)
	struct FExpressionInput                            CustomizedUVs[0x8];                                       // 0x0360(0x0030)
	struct FExpressionInput                            PixelDepthOffset;                                         // 0x04E0(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionMakeMaterialAttributes");
		return ptr;
	}

};


// Class Engine.MaterialExpressionMaterialAttributeLayers
// 0x00C0 (0x0120 - 0x0060)
class UMaterialExpressionMaterialAttributeLayers : public UMaterialExpression
{
public:
	struct FName                                       ParameterName;                                            // 0x0060(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FGuid                                       ExpressionGUID;                                           // 0x0068(0x0010) (CPF_IsPlainOldData)
	struct FMaterialAttributesInput                    Input;                                                    // 0x0078(0x0038)
	struct FMaterialLayersFunctions                    DefaultLayers;                                            // 0x00B0(0x0040) (CPF_Edit)
	TArray<class UMaterialExpressionMaterialFunctionCall*> LayerCallers;                                             // 0x00F0(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	TArray<class UMaterialExpressionMaterialFunctionCall*> BlendCallers;                                             // 0x0100(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	bool                                               bIsLayerGraphBuilt;                                       // 0x0110(0x0001) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0xF];                                       // 0x0111(0x000F) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionMaterialAttributeLayers");
		return ptr;
	}

};


// Class Engine.MaterialExpressionMaterialFunctionCall
// 0x0038 (0x0098 - 0x0060)
class UMaterialExpressionMaterialFunctionCall : public UMaterialExpression
{
public:
	class UMaterialFunctionInterface*                  MaterialFunction;                                         // 0x0060(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<struct FFunctionExpressionInput>            FunctionInputs;                                           // 0x0068(0x0010) (CPF_ZeroConstructor)
	TArray<struct FFunctionExpressionOutput>           FunctionOutputs;                                          // 0x0078(0x0010) (CPF_ZeroConstructor)
	struct FMaterialParameterInfo                      FunctionParameterInfo;                                    // 0x0088(0x0010) (CPF_Transient)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionMaterialFunctionCall");
		return ptr;
	}

};


// Class Engine.MaterialExpressionMaterialLayerOutput
// 0x0000 (0x00C8 - 0x00C8)
class UMaterialExpressionMaterialLayerOutput : public UMaterialExpressionFunctionOutput
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionMaterialLayerOutput");
		return ptr;
	}

};


// Class Engine.MaterialExpressionMaterialProxyReplace
// 0x0060 (0x00C0 - 0x0060)
class UMaterialExpressionMaterialProxyReplace : public UMaterialExpression
{
public:
	struct FExpressionInput                            Realtime;                                                 // 0x0060(0x0030)
	struct FExpressionInput                            MaterialProxy;                                            // 0x0090(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionMaterialProxyReplace");
		return ptr;
	}

};


// Class Engine.MaterialExpressionMax
// 0x0068 (0x00C8 - 0x0060)
class UMaterialExpressionMax : public UMaterialExpression
{
public:
	struct FExpressionInput                            A;                                                        // 0x0060(0x0030)
	struct FExpressionInput                            B;                                                        // 0x0090(0x0030)
	float                                              ConstA;                                                   // 0x00C0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ConstB;                                                   // 0x00C4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionMax");
		return ptr;
	}

};


// Class Engine.MaterialExpressionMin
// 0x0068 (0x00C8 - 0x0060)
class UMaterialExpressionMin : public UMaterialExpression
{
public:
	struct FExpressionInput                            A;                                                        // 0x0060(0x0030)
	struct FExpressionInput                            B;                                                        // 0x0090(0x0030)
	float                                              ConstA;                                                   // 0x00C0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ConstB;                                                   // 0x00C4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionMin");
		return ptr;
	}

};


// Class Engine.MaterialExpressionMultiply
// 0x0068 (0x00C8 - 0x0060)
class UMaterialExpressionMultiply : public UMaterialExpression
{
public:
	struct FExpressionInput                            A;                                                        // 0x0060(0x0030)
	struct FExpressionInput                            B;                                                        // 0x0090(0x0030)
	float                                              ConstA;                                                   // 0x00C0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ConstB;                                                   // 0x00C4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionMultiply");
		return ptr;
	}

};


// Class Engine.MaterialExpressionNoise
// 0x0088 (0x00E8 - 0x0060)
class UMaterialExpressionNoise : public UMaterialExpression
{
public:
	struct FExpressionInput                            Position;                                                 // 0x0060(0x0030)
	struct FExpressionInput                            FilterWidth;                                              // 0x0090(0x0030)
	float                                              Scale;                                                    // 0x00C0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                Quality;                                                  // 0x00C4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ENoiseFunction>                        NoiseFunction;                                            // 0x00C8(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x3];                                       // 0x00C9(0x0003) MISSED OFFSET
	unsigned char                                      bTurbulence : 1;                                          // 0x00CC(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData01[0x3];                                       // 0x00CD(0x0003) MISSED OFFSET
	int                                                Levels;                                                   // 0x00D0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              OutputMin;                                                // 0x00D4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              OutputMax;                                                // 0x00D8(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              LevelScale;                                               // 0x00DC(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bTiling : 1;                                              // 0x00E0(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData02[0x3];                                       // 0x00E1(0x0003) MISSED OFFSET
	uint32_t                                           RepeatSize;                                               // 0x00E4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionNoise");
		return ptr;
	}

};


// Class Engine.MaterialExpressionNormalize
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionNormalize : public UMaterialExpression
{
public:
	struct FExpressionInput                            VectorInput;                                              // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionNormalize");
		return ptr;
	}

};


// Class Engine.MaterialExpressionObjectBounds
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionObjectBounds : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionObjectBounds");
		return ptr;
	}

};


// Class Engine.MaterialExpressionObjectOrientation
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionObjectOrientation : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionObjectOrientation");
		return ptr;
	}

};


// Class Engine.MaterialExpressionObjectPositionWS
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionObjectPositionWS : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionObjectPositionWS");
		return ptr;
	}

};


// Class Engine.MaterialExpressionObjectRadius
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionObjectRadius : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionObjectRadius");
		return ptr;
	}

};


// Class Engine.MaterialExpressionOneMinus
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionOneMinus : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionOneMinus");
		return ptr;
	}

};


// Class Engine.MaterialExpressionPanner
// 0x00A0 (0x0100 - 0x0060)
class UMaterialExpressionPanner : public UMaterialExpression
{
public:
	struct FExpressionInput                            Coordinate;                                               // 0x0060(0x0030)
	struct FExpressionInput                            Time;                                                     // 0x0090(0x0030)
	struct FExpressionInput                            Speed;                                                    // 0x00C0(0x0030)
	float                                              SpeedX;                                                   // 0x00F0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              SpeedY;                                                   // 0x00F4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	uint32_t                                           ConstCoordinate;                                          // 0x00F8(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bFractionalPart;                                          // 0x00FC(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x3];                                       // 0x00FD(0x0003) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionPanner");
		return ptr;
	}

};


// Class Engine.MaterialExpressionParticleColor
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionParticleColor : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionParticleColor");
		return ptr;
	}

};


// Class Engine.MaterialExpressionParticleDirection
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionParticleDirection : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionParticleDirection");
		return ptr;
	}

};


// Class Engine.MaterialExpressionParticleMacroUV
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionParticleMacroUV : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionParticleMacroUV");
		return ptr;
	}

};


// Class Engine.MaterialExpressionParticleMotionBlurFade
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionParticleMotionBlurFade : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionParticleMotionBlurFade");
		return ptr;
	}

};


// Class Engine.MaterialExpressionParticlePositionWS
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionParticlePositionWS : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionParticlePositionWS");
		return ptr;
	}

};


// Class Engine.MaterialExpressionParticleRadius
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionParticleRadius : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionParticleRadius");
		return ptr;
	}

};


// Class Engine.MaterialExpressionParticleRandom
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionParticleRandom : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionParticleRandom");
		return ptr;
	}

};


// Class Engine.MaterialExpressionParticleRelativeTime
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionParticleRelativeTime : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionParticleRelativeTime");
		return ptr;
	}

};


// Class Engine.MaterialExpressionParticleSize
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionParticleSize : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionParticleSize");
		return ptr;
	}

};


// Class Engine.MaterialExpressionParticleSpeed
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionParticleSpeed : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionParticleSpeed");
		return ptr;
	}

};


// Class Engine.MaterialExpressionParticleSubUV
// 0x0008 (0x0180 - 0x0178)
class UMaterialExpressionParticleSubUV : public UMaterialExpressionTextureSample
{
public:
	unsigned char                                      bBlend : 1;                                               // 0x0178(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0179(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionParticleSubUV");
		return ptr;
	}

};


// Class Engine.MaterialExpressionPerInstanceFadeAmount
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionPerInstanceFadeAmount : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionPerInstanceFadeAmount");
		return ptr;
	}

};


// Class Engine.MaterialExpressionPerInstanceRandom
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionPerInstanceRandom : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionPerInstanceRandom");
		return ptr;
	}

};


// Class Engine.MaterialExpressionPixelDepth
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionPixelDepth : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionPixelDepth");
		return ptr;
	}

};


// Class Engine.MaterialExpressionPixelNormalWS
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionPixelNormalWS : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionPixelNormalWS");
		return ptr;
	}

};


// Class Engine.MaterialExpressionPower
// 0x0068 (0x00C8 - 0x0060)
class UMaterialExpressionPower : public UMaterialExpression
{
public:
	struct FExpressionInput                            Base;                                                     // 0x0060(0x0030)
	struct FExpressionInput                            Exponent;                                                 // 0x0090(0x0030)
	float                                              ConstExponent;                                            // 0x00C0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x00C4(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionPower");
		return ptr;
	}

};


// Class Engine.MaterialExpressionPrecomputedAOMask
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionPrecomputedAOMask : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionPrecomputedAOMask");
		return ptr;
	}

};


// Class Engine.MaterialExpressionPreSkinnedNormal
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionPreSkinnedNormal : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionPreSkinnedNormal");
		return ptr;
	}

};


// Class Engine.MaterialExpressionPreSkinnedPosition
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionPreSkinnedPosition : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionPreSkinnedPosition");
		return ptr;
	}

};


// Class Engine.MaterialExpressionPreviousFrameSwitch
// 0x0060 (0x00C0 - 0x0060)
class UMaterialExpressionPreviousFrameSwitch : public UMaterialExpression
{
public:
	struct FExpressionInput                            CurrentFrame;                                             // 0x0060(0x0030)
	struct FExpressionInput                            PreviousFrame;                                            // 0x0090(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionPreviousFrameSwitch");
		return ptr;
	}

};


// Class Engine.MaterialExpressionQualitySwitch
// 0x00C0 (0x0120 - 0x0060)
class UMaterialExpressionQualitySwitch : public UMaterialExpression
{
public:
	struct FExpressionInput                            Default;                                                  // 0x0060(0x0030)
	struct FExpressionInput                            Inputs[0x3];                                              // 0x0090(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionQualitySwitch");
		return ptr;
	}

};


// Class Engine.MaterialExpressionReflectionVectorWS
// 0x0038 (0x0098 - 0x0060)
class UMaterialExpressionReflectionVectorWS : public UMaterialExpression
{
public:
	struct FExpressionInput                            CustomWorldNormal;                                        // 0x0060(0x0030)
	unsigned char                                      bNormalizeCustomWorldNormal : 1;                          // 0x0090(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0091(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionReflectionVectorWS");
		return ptr;
	}

};


// Class Engine.MaterialExpressionReroute
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionReroute : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionReroute");
		return ptr;
	}

};


// Class Engine.MaterialExpressionRotateAboutAxis
// 0x00C8 (0x0128 - 0x0060)
class UMaterialExpressionRotateAboutAxis : public UMaterialExpression
{
public:
	struct FExpressionInput                            NormalizedRotationAxis;                                   // 0x0060(0x0030)
	struct FExpressionInput                            RotationAngle;                                            // 0x0090(0x0030)
	struct FExpressionInput                            PivotPoint;                                               // 0x00C0(0x0030)
	struct FExpressionInput                            Position;                                                 // 0x00F0(0x0030)
	float                                              Period;                                                   // 0x0120(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x0124(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionRotateAboutAxis");
		return ptr;
	}

};


// Class Engine.MaterialExpressionRotator
// 0x0070 (0x00D0 - 0x0060)
class UMaterialExpressionRotator : public UMaterialExpression
{
public:
	struct FExpressionInput                            Coordinate;                                               // 0x0060(0x0030)
	struct FExpressionInput                            Time;                                                     // 0x0090(0x0030)
	float                                              CenterX;                                                  // 0x00C0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              CenterY;                                                  // 0x00C4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              Speed;                                                    // 0x00C8(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	uint32_t                                           ConstCoordinate;                                          // 0x00CC(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionRotator");
		return ptr;
	}

};


// Class Engine.MaterialExpressionRound
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionRound : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionRound");
		return ptr;
	}

};


// Class Engine.MaterialExpressionSaturate
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionSaturate : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionSaturate");
		return ptr;
	}

};


// Class Engine.MaterialExpressionScalarParameter
// 0x0010 (0x0090 - 0x0080)
class UMaterialExpressionScalarParameter : public UMaterialExpressionParameter
{
public:
	float                                              DefaultValue;                                             // 0x0080(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              SliderMin;                                                // 0x0084(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              SliderMax;                                                // 0x0088(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x008C(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionScalarParameter");
		return ptr;
	}

};


// Class Engine.MaterialExpressionSceneColor
// 0x0070 (0x00D0 - 0x0060)
class UMaterialExpressionSceneColor : public UMaterialExpression
{
public:
	TEnumAsByte<EMaterialSceneAttributeInputMode>      InputMode;                                                // 0x0060(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0061(0x0007) MISSED OFFSET
	struct FExpressionInput                            Input;                                                    // 0x0068(0x0030)
	struct FExpressionInput                            OffsetFraction;                                           // 0x0098(0x0030) (CPF_Deprecated)
	struct FVector2D                                   ConstInput;                                               // 0x00C8(0x0008) (CPF_Edit, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionSceneColor");
		return ptr;
	}

};


// Class Engine.MaterialExpressionSceneDepth
// 0x0070 (0x00D0 - 0x0060)
class UMaterialExpressionSceneDepth : public UMaterialExpression
{
public:
	TEnumAsByte<EMaterialSceneAttributeInputMode>      InputMode;                                                // 0x0060(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0061(0x0007) MISSED OFFSET
	struct FExpressionInput                            Input;                                                    // 0x0068(0x0030)
	struct FExpressionInput                            coordinates;                                              // 0x0098(0x0030) (CPF_Deprecated)
	struct FVector2D                                   ConstInput;                                               // 0x00C8(0x0008) (CPF_Edit, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionSceneDepth");
		return ptr;
	}

};


// Class Engine.MaterialExpressionSceneTexelSize
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionSceneTexelSize : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionSceneTexelSize");
		return ptr;
	}

};


// Class Engine.MaterialExpressionSceneTexture
// 0x0038 (0x0098 - 0x0060)
class UMaterialExpressionSceneTexture : public UMaterialExpression
{
public:
	struct FExpressionInput                            coordinates;                                              // 0x0060(0x0030)
	TEnumAsByte<ESceneTextureId>                       SceneTextureId;                                           // 0x0090(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bFiltered;                                                // 0x0091(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x6];                                       // 0x0092(0x0006) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionSceneTexture");
		return ptr;
	}

};


// Class Engine.MaterialExpressionScreenPosition
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionScreenPosition : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionScreenPosition");
		return ptr;
	}

};


// Class Engine.MaterialExpressionSetMaterialAttributes
// 0x0020 (0x0080 - 0x0060)
class UMaterialExpressionSetMaterialAttributes : public UMaterialExpression
{
public:
	TArray<struct FExpressionInput>                    Inputs;                                                   // 0x0060(0x0010) (CPF_ZeroConstructor)
	TArray<struct FGuid>                               AttributeSetTypes;                                        // 0x0070(0x0010) (CPF_Edit, CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionSetMaterialAttributes");
		return ptr;
	}

};


// Class Engine.MaterialExpressionSign
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionSign : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionSign");
		return ptr;
	}

};


// Class Engine.MaterialExpressionSine
// 0x0038 (0x0098 - 0x0060)
class UMaterialExpressionSine : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)
	float                                              Period;                                                   // 0x0090(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x0094(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionSine");
		return ptr;
	}

};


// Class Engine.MaterialExpressionSobol
// 0x00A0 (0x0100 - 0x0060)
class UMaterialExpressionSobol : public UMaterialExpression
{
public:
	struct FExpressionInput                            Cell;                                                     // 0x0060(0x0030)
	struct FExpressionInput                            Index;                                                    // 0x0090(0x0030)
	struct FExpressionInput                            Seed;                                                     // 0x00C0(0x0030)
	uint32_t                                           ConstIndex;                                               // 0x00F0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FVector2D                                   ConstSeed;                                                // 0x00F4(0x0008) (CPF_Edit, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x00FC(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionSobol");
		return ptr;
	}

};


// Class Engine.MaterialExpressionSpeedTree
// 0x00D0 (0x0130 - 0x0060)
class UMaterialExpressionSpeedTree : public UMaterialExpression
{
public:
	struct FExpressionInput                            GeometryInput;                                            // 0x0060(0x0030)
	struct FExpressionInput                            WindInput;                                                // 0x0090(0x0030)
	struct FExpressionInput                            LODInput;                                                 // 0x00C0(0x0030)
	struct FExpressionInput                            ExtraBendWS;                                              // 0x00F0(0x0030)
	TEnumAsByte<ESpeedTreeGeometryType>                GeometryType;                                             // 0x0120(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ESpeedTreeWindType>                    WindType;                                                 // 0x0121(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<ESpeedTreeLODType>                     LODType;                                                  // 0x0122(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x1];                                       // 0x0123(0x0001) MISSED OFFSET
	float                                              BillboardThreshold;                                       // 0x0124(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	bool                                               bAccurateWindVelocities;                                  // 0x0128(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x7];                                       // 0x0129(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionSpeedTree");
		return ptr;
	}

};


// Class Engine.MaterialExpressionSphereMask
// 0x00C8 (0x0128 - 0x0060)
class UMaterialExpressionSphereMask : public UMaterialExpression
{
public:
	struct FExpressionInput                            A;                                                        // 0x0060(0x0030)
	struct FExpressionInput                            B;                                                        // 0x0090(0x0030)
	struct FExpressionInput                            Radius;                                                   // 0x00C0(0x0030)
	struct FExpressionInput                            Hardness;                                                 // 0x00F0(0x0030)
	float                                              AttenuationRadius;                                        // 0x0120(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              HardnessPercent;                                          // 0x0124(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionSphereMask");
		return ptr;
	}

};


// Class Engine.MaterialExpressionSphericalParticleOpacity
// 0x0038 (0x0098 - 0x0060)
class UMaterialExpressionSphericalParticleOpacity : public UMaterialExpression
{
public:
	struct FExpressionInput                            Density;                                                  // 0x0060(0x0030)
	float                                              ConstantDensity;                                          // 0x0090(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x0094(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionSphericalParticleOpacity");
		return ptr;
	}

};


// Class Engine.MaterialExpressionSquareRoot
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionSquareRoot : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionSquareRoot");
		return ptr;
	}

};


// Class Engine.MaterialExpressionStaticBool
// 0x0008 (0x0068 - 0x0060)
class UMaterialExpressionStaticBool : public UMaterialExpression
{
public:
	unsigned char                                      Value : 1;                                                // 0x0060(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0061(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionStaticBool");
		return ptr;
	}

};


// Class Engine.MaterialExpressionStaticBoolParameter
// 0x0008 (0x0088 - 0x0080)
class UMaterialExpressionStaticBoolParameter : public UMaterialExpressionParameter
{
public:
	unsigned char                                      DefaultValue : 1;                                         // 0x0080(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0081(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionStaticBoolParameter");
		return ptr;
	}

};


// Class Engine.MaterialExpressionStaticComponentMaskParameter
// 0x0038 (0x00B8 - 0x0080)
class UMaterialExpressionStaticComponentMaskParameter : public UMaterialExpressionParameter
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0080(0x0030)
	unsigned char                                      DefaultR : 1;                                             // 0x00B0(0x0001) (CPF_Edit)
	unsigned char                                      DefaultG : 1;                                             // 0x00B0(0x0001) (CPF_Edit)
	unsigned char                                      DefaultB : 1;                                             // 0x00B0(0x0001) (CPF_Edit)
	unsigned char                                      DefaultA : 1;                                             // 0x00B0(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x7];                                       // 0x00B1(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionStaticComponentMaskParameter");
		return ptr;
	}

};


// Class Engine.MaterialExpressionStaticSwitch
// 0x0098 (0x00F8 - 0x0060)
class UMaterialExpressionStaticSwitch : public UMaterialExpression
{
public:
	unsigned char                                      DefaultValue : 1;                                         // 0x0060(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0061(0x0007) MISSED OFFSET
	struct FExpressionInput                            A;                                                        // 0x0068(0x0030)
	struct FExpressionInput                            B;                                                        // 0x0098(0x0030)
	struct FExpressionInput                            Value;                                                    // 0x00C8(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionStaticSwitch");
		return ptr;
	}

};


// Class Engine.MaterialExpressionStaticSwitchParameter
// 0x0060 (0x00E8 - 0x0088)
class UMaterialExpressionStaticSwitchParameter : public UMaterialExpressionStaticBoolParameter
{
public:
	struct FExpressionInput                            A;                                                        // 0x0088(0x0030)
	struct FExpressionInput                            B;                                                        // 0x00B8(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionStaticSwitchParameter");
		return ptr;
	}

};


// Class Engine.MaterialExpressionSubtract
// 0x0068 (0x00C8 - 0x0060)
class UMaterialExpressionSubtract : public UMaterialExpression
{
public:
	struct FExpressionInput                            A;                                                        // 0x0060(0x0030)
	struct FExpressionInput                            B;                                                        // 0x0090(0x0030)
	float                                              ConstA;                                                   // 0x00C0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              ConstB;                                                   // 0x00C4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionSubtract");
		return ptr;
	}

};


// Class Engine.MaterialExpressionTangent
// 0x0038 (0x0098 - 0x0060)
class UMaterialExpressionTangent : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)
	float                                              Period;                                                   // 0x0090(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x0094(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionTangent");
		return ptr;
	}

};


// Class Engine.MaterialExpressionTangentOutput
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionTangentOutput : public UMaterialExpressionCustomOutput
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionTangentOutput");
		return ptr;
	}

};


// Class Engine.MaterialExpressionTemporalSobol
// 0x0070 (0x00D0 - 0x0060)
class UMaterialExpressionTemporalSobol : public UMaterialExpression
{
public:
	struct FExpressionInput                            Index;                                                    // 0x0060(0x0030)
	struct FExpressionInput                            Seed;                                                     // 0x0090(0x0030)
	uint32_t                                           ConstIndex;                                               // 0x00C0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FVector2D                                   ConstSeed;                                                // 0x00C4(0x0008) (CPF_Edit, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x4];                                       // 0x00CC(0x0004) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionTemporalSobol");
		return ptr;
	}

};


// Class Engine.MaterialExpressionTextureCoordinate
// 0x0010 (0x0070 - 0x0060)
class UMaterialExpressionTextureCoordinate : public UMaterialExpression
{
public:
	int                                                CoordinateIndex;                                          // 0x0060(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              UTiling;                                                  // 0x0064(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              VTiling;                                                  // 0x0068(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnMirrorU : 1;                                            // 0x006C(0x0001) (CPF_Edit)
	unsigned char                                      UnMirrorV : 1;                                            // 0x006C(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x3];                                       // 0x006D(0x0003) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionTextureCoordinate");
		return ptr;
	}

};


// Class Engine.MaterialExpressionTextureObject
// 0x0000 (0x0070 - 0x0070)
class UMaterialExpressionTextureObject : public UMaterialExpressionTextureBase
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionTextureObject");
		return ptr;
	}

};


// Class Engine.MaterialExpressionTextureObjectParameter
// 0x0000 (0x0198 - 0x0198)
class UMaterialExpressionTextureObjectParameter : public UMaterialExpressionTextureSampleParameter
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionTextureObjectParameter");
		return ptr;
	}

};


// Class Engine.MaterialExpressionTextureProperty
// 0x0038 (0x0098 - 0x0060)
class UMaterialExpressionTextureProperty : public UMaterialExpression
{
public:
	struct FExpressionInput                            TextureObject;                                            // 0x0060(0x0030)
	TEnumAsByte<EMaterialExposedTextureProperty>       Property;                                                 // 0x0090(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0091(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionTextureProperty");
		return ptr;
	}

};


// Class Engine.MaterialExpressionTextureSampleParameterCube
// 0x0000 (0x0198 - 0x0198)
class UMaterialExpressionTextureSampleParameterCube : public UMaterialExpressionTextureSampleParameter
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionTextureSampleParameterCube");
		return ptr;
	}

};


// Class Engine.MaterialExpressionTextureSampleParameterSubUV
// 0x0008 (0x01A0 - 0x0198)
class UMaterialExpressionTextureSampleParameterSubUV : public UMaterialExpressionTextureSampleParameter2D
{
public:
	unsigned char                                      bBlend : 1;                                               // 0x0198(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0199(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionTextureSampleParameterSubUV");
		return ptr;
	}

};


// Class Engine.MaterialExpressionTime
// 0x0008 (0x0068 - 0x0060)
class UMaterialExpressionTime : public UMaterialExpression
{
public:
	unsigned char                                      bIgnorePause : 1;                                         // 0x0060(0x0001) (CPF_Edit)
	unsigned char                                      bOverride_Period : 1;                                     // 0x0060(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0061(0x0003) MISSED OFFSET
	float                                              Period;                                                   // 0x0064(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionTime");
		return ptr;
	}

};


// Class Engine.MaterialExpressionTransform
// 0x0038 (0x0098 - 0x0060)
class UMaterialExpressionTransform : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)
	TEnumAsByte<EMaterialVectorCoordTransformSource>   TransformSourceType;                                      // 0x0090(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EMaterialVectorCoordTransform>         TransformType;                                            // 0x0091(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x6];                                       // 0x0092(0x0006) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionTransform");
		return ptr;
	}

};


// Class Engine.MaterialExpressionTransformPosition
// 0x0038 (0x0098 - 0x0060)
class UMaterialExpressionTransformPosition : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)
	TEnumAsByte<EMaterialPositionTransformSource>      TransformSourceType;                                      // 0x0090(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	TEnumAsByte<EMaterialPositionTransformSource>      TransformType;                                            // 0x0091(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x6];                                       // 0x0092(0x0006) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionTransformPosition");
		return ptr;
	}

};


// Class Engine.MaterialExpressionTruncate
// 0x0030 (0x0090 - 0x0060)
class UMaterialExpressionTruncate : public UMaterialExpression
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionTruncate");
		return ptr;
	}

};


// Class Engine.MaterialExpressionTwoSidedSign
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionTwoSidedSign : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionTwoSidedSign");
		return ptr;
	}

};


// Class Engine.MaterialExpressionVectorNoise
// 0x0040 (0x00A0 - 0x0060)
class UMaterialExpressionVectorNoise : public UMaterialExpression
{
public:
	struct FExpressionInput                            Position;                                                 // 0x0060(0x0030)
	TEnumAsByte<EVectorNoiseFunction>                  NoiseFunction;                                            // 0x0090(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x3];                                       // 0x0091(0x0003) MISSED OFFSET
	int                                                Quality;                                                  // 0x0094(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bTiling : 1;                                              // 0x0098(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData01[0x3];                                       // 0x0099(0x0003) MISSED OFFSET
	uint32_t                                           TileSize;                                                 // 0x009C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionVectorNoise");
		return ptr;
	}

};


// Class Engine.MaterialExpressionVertexColor
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionVertexColor : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionVertexColor");
		return ptr;
	}

};


// Class Engine.MaterialExpressionVertexInterpolator
// 0x0040 (0x00A0 - 0x0060)
class UMaterialExpressionVertexInterpolator : public UMaterialExpressionCustomOutput
{
public:
	struct FExpressionInput                            Input;                                                    // 0x0060(0x0030)
	unsigned char                                      UnknownData00[0x10];                                      // 0x0090(0x0010) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionVertexInterpolator");
		return ptr;
	}

};


// Class Engine.MaterialExpressionVertexNormalWS
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionVertexNormalWS : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionVertexNormalWS");
		return ptr;
	}

};


// Class Engine.MaterialExpressionViewProperty
// 0x0008 (0x0068 - 0x0060)
class UMaterialExpressionViewProperty : public UMaterialExpression
{
public:
	TEnumAsByte<EMaterialExposedViewProperty>          Property;                                                 // 0x0060(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0061(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionViewProperty");
		return ptr;
	}

};


// Class Engine.MaterialExpressionViewSize
// 0x0000 (0x0060 - 0x0060)
class UMaterialExpressionViewSize : public UMaterialExpression
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionViewSize");
		return ptr;
	}

};


// Class Engine.MaterialExpressionWorldPosition
// 0x0008 (0x0068 - 0x0060)
class UMaterialExpressionWorldPosition : public UMaterialExpression
{
public:
	TEnumAsByte<EWorldPositionIncludedOffsets>         WorldPositionShaderOffset;                                // 0x0060(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0061(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialExpressionWorldPosition");
		return ptr;
	}

};


// Class Engine.MaterialFunctionInterface
// 0x0018 (0x0040 - 0x0028)
class UMaterialFunctionInterface : public UObject
{
public:
	struct FGuid                                       StateId;                                                  // 0x0028(0x0010) (CPF_DuplicateTransient, CPF_IsPlainOldData)
	TEnumAsByte<EMaterialFunctionUsage>                MaterialFunctionUsage;                                    // 0x0038(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0039(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialFunctionInterface");
		return ptr;
	}

};


// Class Engine.MaterialFunction
// 0x0030 (0x0070 - 0x0040)
class UMaterialFunction : public UMaterialFunctionInterface
{
public:
	struct FString                                     Description;                                              // 0x0040(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	unsigned char                                      bExposeToLibrary : 1;                                     // 0x0050(0x0001) (CPF_Edit)
	unsigned char                                      bPrefixParameterNames : 1;                                // 0x0050(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData00[0x7];                                       // 0x0051(0x0007) MISSED OFFSET
	TArray<class UMaterialExpression*>                 FunctionExpressions;                                      // 0x0058(0x0010) (CPF_ZeroConstructor)
	unsigned char                                      bReentrantFlag : 1;                                       // 0x0068(0x0001) (CPF_Transient)
	unsigned char                                      UnknownData01[0x7];                                       // 0x0069(0x0007) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialFunction");
		return ptr;
	}

};


// Class Engine.MaterialFunctionInstance
// 0x0070 (0x00B0 - 0x0040)
class UMaterialFunctionInstance : public UMaterialFunctionInterface
{
public:
	class UMaterialFunctionInterface*                  Parent;                                                   // 0x0040(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UMaterialFunctionInterface*                  Base;                                                     // 0x0048(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	TArray<struct FScalarParameterValue>               ScalarParameterValues;                                    // 0x0050(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	TArray<struct FVectorParameterValue>               VectorParameterValues;                                    // 0x0060(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	TArray<struct FTextureParameterValue>              TextureParameterValues;                                   // 0x0070(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	TArray<struct FFontParameterValue>                 FontParameterValues;                                      // 0x0080(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	TArray<struct FStaticSwitchParameter>              StaticSwitchParameterValues;                              // 0x0090(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	TArray<struct FStaticComponentMaskParameter>       StaticComponentMaskParameterValues;                       // 0x00A0(0x0010) (CPF_Edit, CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialFunctionInstance");
		return ptr;
	}

};


// Class Engine.MaterialFunctionMaterialLayer
// 0x0000 (0x0070 - 0x0070)
class UMaterialFunctionMaterialLayer : public UMaterialFunction
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialFunctionMaterialLayer");
		return ptr;
	}

};


// Class Engine.MaterialFunctionMaterialLayerInstance
// 0x0000 (0x00B0 - 0x00B0)
class UMaterialFunctionMaterialLayerInstance : public UMaterialFunctionInstance
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialFunctionMaterialLayerInstance");
		return ptr;
	}

};


// Class Engine.MaterialFunctionMaterialLayerBlend
// 0x0000 (0x0070 - 0x0070)
class UMaterialFunctionMaterialLayerBlend : public UMaterialFunction
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialFunctionMaterialLayerBlend");
		return ptr;
	}

};


// Class Engine.MaterialFunctionMaterialLayerBlendInstance
// 0x0000 (0x00B0 - 0x00B0)
class UMaterialFunctionMaterialLayerBlendInstance : public UMaterialFunctionInstance
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialFunctionMaterialLayerBlendInstance");
		return ptr;
	}

};


// Class Engine.MaterialInstanceActor
// 0x0010 (0x0328 - 0x0318)
class AMaterialInstanceActor : public AActor
{
public:
	TArray<class AActor*>                              TargetActors;                                             // 0x0318(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialInstanceActor");
		return ptr;
	}

};


// Class Engine.MaterialInstanceDynamic
// 0x0050 (0x0220 - 0x01D0)
class UMaterialInstanceDynamic : public UMaterialInstance
{
public:
	unsigned char                                      UnknownData00[0x50];                                      // 0x01D0(0x0050) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialInstanceDynamic");
		return ptr;
	}


	void SetVectorParameterValue(const struct FName& ParameterName, const struct FLinearColor& Value);
	void SetTextureParameterValue(const struct FName& ParameterName, class UTexture* Value);
	void SetScalarParameterValue(const struct FName& ParameterName, float Value);
	void K2_InterpolateMaterialInstanceParams(class UMaterialInstance* SourceA, class UMaterialInstance* SourceB, float Alpha);
	struct FLinearColor K2_GetVectorParameterValue(const struct FName& ParameterName);
	class UTexture* K2_GetTextureParameterValue(const struct FName& ParameterName);
	float K2_GetScalarParameterValue(const struct FName& ParameterName);
	void K2_CopyMaterialInstanceParameters(class UMaterialInterface* Source);
	void CopyParameterOverrides(class UMaterialInstance* MaterialInstance);
	void CopyInterpParameters(class UMaterialInstance* Source);
};


// Class Engine.MaterialParameterCollection
// 0x0040 (0x0068 - 0x0028)
class UMaterialParameterCollection : public UObject
{
public:
	struct FGuid                                       StateId;                                                  // 0x0028(0x0010) (CPF_DuplicateTransient, CPF_IsPlainOldData)
	TArray<struct FCollectionScalarParameter>          ScalarParameters;                                         // 0x0038(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	TArray<struct FCollectionVectorParameter>          VectorParameters;                                         // 0x0048(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	unsigned char                                      UnknownData00[0x10];                                      // 0x0058(0x0010) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialParameterCollection");
		return ptr;
	}

};


// Class Engine.MaterialParameterCollectionInstance
// 0x00C0 (0x00E8 - 0x0028)
class UMaterialParameterCollectionInstance : public UObject
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0028(0x0008) MISSED OFFSET
	class UMaterialParameterCollection*                Collection;                                               // 0x0030(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UWorld*                                      World;                                                    // 0x0038(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0xA8];                                      // 0x0040(0x00A8) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MaterialParameterCollectionInstance");
		return ptr;
	}

};


// Class Engine.MatineeActor
// 0x00A8 (0x03C0 - 0x0318)
class AMatineeActor : public AActor
{
public:
	class UInterpData*                                 MatineeData;                                              // 0x0318(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FName                                       MatineeControllerName;                                    // 0x0320(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              PlayRate;                                                 // 0x0328(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bPlayOnLevelLoad : 1;                                     // 0x032C(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bForceStartPos : 1;                                       // 0x032C(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData00[0x3];                                       // 0x032D(0x0003) MISSED OFFSET
	float                                              ForceStartPosition;                                       // 0x0330(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bLooping : 1;                                             // 0x0334(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_Net)
	unsigned char                                      bRewindOnPlay : 1;                                        // 0x0334(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bNoResetOnRewind : 1;                                     // 0x0334(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bRewindIfAlreadyPlaying : 1;                              // 0x0334(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bDisableRadioFilter : 1;                                  // 0x0334(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bClientSideOnly : 1;                                      // 0x0334(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bSkipUpdateIfNotVisible : 1;                              // 0x0334(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bIsSkippable : 1;                                         // 0x0334(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData01[0x3];                                       // 0x0335(0x0003) MISSED OFFSET
	int                                                PreferredSplitScreenNum;                                  // 0x0338(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bDisableMovementInput : 1;                                // 0x033C(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bDisableLookAtInput : 1;                                  // 0x033C(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bHidePlayer : 1;                                          // 0x033C(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      bHideHud : 1;                                             // 0x033C(0x0001) (CPF_Edit, CPF_BlueprintVisible)
	unsigned char                                      UnknownData02[0x3];                                       // 0x033D(0x0003) MISSED OFFSET
	TArray<struct FInterpGroupActorInfo>               GroupActorInfos;                                          // 0x0340(0x0010) (CPF_Net, CPF_ZeroConstructor)
	unsigned char                                      bShouldShowGore : 1;                                      // 0x0350(0x0001) (CPF_Transient)
	unsigned char                                      UnknownData03[0x7];                                       // 0x0351(0x0007) MISSED OFFSET
	TArray<class UInterpGroupInst*>                    GroupInst;                                                // 0x0358(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	TArray<struct FCameraCutInfo>                      CameraCuts;                                               // 0x0368(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	unsigned char                                      bIsPlaying : 1;                                           // 0x0378(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Net, CPF_Transient, CPF_EditConst)
	unsigned char                                      bReversePlayback : 1;                                     // 0x0378(0x0001) (CPF_Net)
	unsigned char                                      bPaused : 1;                                              // 0x0378(0x0001) (CPF_Net, CPF_Transient)
	unsigned char                                      bPendingStop : 1;                                         // 0x0378(0x0001) (CPF_Net, CPF_Transient)
	unsigned char                                      UnknownData04[0x3];                                       // 0x0379(0x0003) MISSED OFFSET
	float                                              InterpPosition;                                           // 0x037C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Net, CPF_ZeroConstructor, CPF_EditConst, CPF_IsPlainOldData)
	unsigned char                                      UnknownData05[0x4];                                       // 0x0380(0x0004) MISSED OFFSET
	unsigned char                                      ReplicationForceIsPlaying;                                // 0x0384(0x0001) (CPF_Net, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData06[0x3];                                       // 0x0385(0x0003) MISSED OFFSET
	struct FScriptMulticastDelegate                    OnPlay;                                                   // 0x0388(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnStop;                                                   // 0x0398(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	struct FScriptMulticastDelegate                    OnPause;                                                  // 0x03A8(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	unsigned char                                      UnknownData07[0x8];                                       // 0x03B8(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MatineeActor");
		return ptr;
	}


	void Stop();
	void SetPosition(float NewPosition, bool bJump);
	void SetLoopingState(bool bNewLooping);
	void Reverse();
	void Play();
	void Pause();
	void EnableGroupByName(const struct FString& GroupName, bool bEnable);
	void ChangePlaybackDirection();
};


// Class Engine.MatineeActorCameraAnim
// 0x0008 (0x03C8 - 0x03C0)
class AMatineeActorCameraAnim : public AMatineeActor
{
public:
	class UCameraAnim*                                 CameraAnim;                                               // 0x03C0(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MatineeActorCameraAnim");
		return ptr;
	}

};


// Class Engine.MatineeAnimInterface
// 0x0000 (0x0028 - 0x0028)
class UMatineeAnimInterface : public UInterface
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MatineeAnimInterface");
		return ptr;
	}

};


// Class Engine.MatineeInterface
// 0x0000 (0x0028 - 0x0028)
class UMatineeInterface : public UInterface
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MatineeInterface");
		return ptr;
	}

};


// Class Engine.MeshMergeCullingVolume
// 0x0000 (0x0350 - 0x0350)
class AMeshMergeCullingVolume : public AVolume
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MeshMergeCullingVolume");
		return ptr;
	}

};


// Class Engine.MeshSimplificationSettings
// 0x0008 (0x0040 - 0x0038)
class UMeshSimplificationSettings : public UDeveloperSettings
{
public:
	struct FName                                       MeshReductionModuleName;                                  // 0x0038(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MeshSimplificationSettings");
		return ptr;
	}

};


// Class Engine.MeshVertexPainterKismetLibrary
// 0x0000 (0x0028 - 0x0028)
class UMeshVertexPainterKismetLibrary : public UBlueprintFunctionLibrary
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MeshVertexPainterKismetLibrary");
		return ptr;
	}


	static void RemovePaintedVertices(class UStaticMeshComponent* StaticMeshComponent);
	static void PaintVerticesSingleColor(class UStaticMeshComponent* StaticMeshComponent, const struct FLinearColor& FillColor, bool bConvertToSRGB);
	static void PaintVerticesLerpAlongAxis(class UStaticMeshComponent* StaticMeshComponent, const struct FLinearColor& StartColor, const struct FLinearColor& EndColor, EVertexPaintAxis Axis, bool bConvertToSRGB);
};


// Class Engine.MicroTransactionBase
// 0x0030 (0x0068 - 0x0038)
class UMicroTransactionBase : public UPlatformInterfaceBase
{
public:
	TArray<struct FPurchaseInfo>                       AvailableProducts;                                        // 0x0038(0x0010) (CPF_ZeroConstructor)
	struct FString                                     LastError;                                                // 0x0048(0x0010) (CPF_ZeroConstructor)
	struct FString                                     LastErrorSolution;                                        // 0x0058(0x0010) (CPF_ZeroConstructor)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MicroTransactionBase");
		return ptr;
	}

};


// Class Engine.ModelComponent
// 0x0040 (0x06A0 - 0x0660)
class UModelComponent : public UPrimitiveComponent
{
public:
	unsigned char                                      UnknownData00[0x18];                                      // 0x0660(0x0018) MISSED OFFSET
	class UBodySetup*                                  ModelBodySetup;                                           // 0x0678(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x20];                                      // 0x0680(0x0020) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.ModelComponent");
		return ptr;
	}

};


// Class Engine.MorphTarget
// 0x0018 (0x0040 - 0x0028)
class UMorphTarget : public UObject
{
public:
	class USkeletalMesh*                               BaseSkelMesh;                                             // 0x0028(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x10];                                      // 0x0030(0x0010) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.MorphTarget");
		return ptr;
	}

};


// Class Engine.NavAgentInterface
// 0x0000 (0x0028 - 0x0028)
class UNavAgentInterface : public UInterface
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavAgentInterface");
		return ptr;
	}

};


// Class Engine.NavArea
// 0x0018 (0x0040 - 0x0028)
class UNavArea : public UObject
{
public:
	float                                              DefaultCost;                                              // 0x0028(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	float                                              FixedAreaEnteringCost;                                    // 0x002C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	struct FColor                                      DrawColor;                                                // 0x0030(0x0004) (CPF_Edit, CPF_Config, CPF_IsPlainOldData)
	struct FNavAgentSelector                           SupportedAgents;                                          // 0x0034(0x0004) (CPF_Edit, CPF_Config)
	unsigned char                                      bSupportsAgent0 : 1;                                      // 0x0038(0x0001) (CPF_Config)
	unsigned char                                      bSupportsAgent1 : 1;                                      // 0x0038(0x0001) (CPF_Config)
	unsigned char                                      bSupportsAgent2 : 1;                                      // 0x0038(0x0001) (CPF_Config)
	unsigned char                                      bSupportsAgent3 : 1;                                      // 0x0038(0x0001) (CPF_Config)
	unsigned char                                      bSupportsAgent4 : 1;                                      // 0x0038(0x0001) (CPF_Config)
	unsigned char                                      bSupportsAgent5 : 1;                                      // 0x0038(0x0001) (CPF_Config)
	unsigned char                                      bSupportsAgent6 : 1;                                      // 0x0038(0x0001) (CPF_Config)
	unsigned char                                      bSupportsAgent7 : 1;                                      // 0x0038(0x0001) (CPF_Config)
	unsigned char                                      bSupportsAgent8 : 1;                                      // 0x0039(0x0001) (CPF_Config)
	unsigned char                                      bSupportsAgent9 : 1;                                      // 0x0039(0x0001) (CPF_Config)
	unsigned char                                      bSupportsAgent10 : 1;                                     // 0x0039(0x0001) (CPF_Config)
	unsigned char                                      bSupportsAgent11 : 1;                                     // 0x0039(0x0001) (CPF_Config)
	unsigned char                                      bSupportsAgent12 : 1;                                     // 0x0039(0x0001) (CPF_Config)
	unsigned char                                      bSupportsAgent13 : 1;                                     // 0x0039(0x0001) (CPF_Config)
	unsigned char                                      bSupportsAgent14 : 1;                                     // 0x0039(0x0001) (CPF_Config)
	unsigned char                                      bSupportsAgent15 : 1;                                     // 0x0039(0x0001) (CPF_Config)
	unsigned char                                      UnknownData00[0x6];                                       // 0x003A(0x0006) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavArea");
		return ptr;
	}

};


// Class Engine.NavArea_Default
// 0x0000 (0x0040 - 0x0040)
class UNavArea_Default : public UNavArea
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavArea_Default");
		return ptr;
	}

};


// Class Engine.NavArea_LowHeight
// 0x0000 (0x0040 - 0x0040)
class UNavArea_LowHeight : public UNavArea
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavArea_LowHeight");
		return ptr;
	}

};


// Class Engine.NavArea_Null
// 0x0000 (0x0040 - 0x0040)
class UNavArea_Null : public UNavArea
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavArea_Null");
		return ptr;
	}

};


// Class Engine.NavArea_Obstacle
// 0x0000 (0x0040 - 0x0040)
class UNavArea_Obstacle : public UNavArea
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavArea_Obstacle");
		return ptr;
	}

};


// Class Engine.NavAreaMeta
// 0x0000 (0x0040 - 0x0040)
class UNavAreaMeta : public UNavArea
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavAreaMeta");
		return ptr;
	}

};


// Class Engine.NavAreaMeta_SwitchByAgent
// 0x0080 (0x00C0 - 0x0040)
class UNavAreaMeta_SwitchByAgent : public UNavAreaMeta
{
public:
	class UClass*                                      Agent0Area;                                               // 0x0040(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      Agent1Area;                                               // 0x0048(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      Agent2Area;                                               // 0x0050(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      Agent3Area;                                               // 0x0058(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      Agent4Area;                                               // 0x0060(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      Agent5Area;                                               // 0x0068(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      Agent6Area;                                               // 0x0070(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      Agent7Area;                                               // 0x0078(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      Agent8Area;                                               // 0x0080(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      Agent9Area;                                               // 0x0088(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      Agent10Area;                                              // 0x0090(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      Agent11Area;                                              // 0x0098(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      Agent12Area;                                              // 0x00A0(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      Agent13Area;                                              // 0x00A8(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      Agent14Area;                                              // 0x00B0(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      Agent15Area;                                              // 0x00B8(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavAreaMeta_SwitchByAgent");
		return ptr;
	}

};


// Class Engine.NavCollision
// 0x00A8 (0x00D0 - 0x0028)
class UNavCollision : public UObject
{
public:
	unsigned char                                      UnknownData00[0x50];                                      // 0x0028(0x0050) MISSED OFFSET
	TArray<struct FNavCollisionCylinder>               CylinderCollision;                                        // 0x0078(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	TArray<struct FNavCollisionBox>                    BoxCollision;                                             // 0x0088(0x0010) (CPF_Edit, CPF_ZeroConstructor)
	class UClass*                                      AreaClass;                                                // 0x0098(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bIsDynamicObstacle : 1;                                   // 0x00A0(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bGatherConvexGeometry : 1;                                // 0x00A0(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      UnknownData01[0x2F];                                      // 0x00A1(0x002F) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavCollision");
		return ptr;
	}

};


// Class Engine.NavEdgeProviderInterface
// 0x0000 (0x0028 - 0x0028)
class UNavEdgeProviderInterface : public UInterface
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavEdgeProviderInterface");
		return ptr;
	}

};


// Class Engine.NavigationDataChunk
// 0x0008 (0x0030 - 0x0028)
class UNavigationDataChunk : public UObject
{
public:
	struct FName                                       NavigationDataName;                                       // 0x0028(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavigationDataChunk");
		return ptr;
	}

};


// Class Engine.NavigationGraph
// 0x0000 (0x04C0 - 0x04C0)
class ANavigationGraph : public ANavigationData
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavigationGraph");
		return ptr;
	}

};


// Class Engine.NavigationGraphNode
// 0x0000 (0x0318 - 0x0318)
class ANavigationGraphNode : public AActor
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavigationGraphNode");
		return ptr;
	}

};


// Class Engine.NavigationGraphNodeComponent
// 0x0030 (0x02C0 - 0x0290)
class UNavigationGraphNodeComponent : public USceneComponent
{
public:
	struct FNavGraphNode                               Node;                                                     // 0x0290(0x0018)
	class UNavigationGraphNodeComponent*               NextNodeComponent;                                        // 0x02A8(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	class UNavigationGraphNodeComponent*               PrevNodeComponent;                                        // 0x02B0(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x8];                                       // 0x02B8(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavigationGraphNodeComponent");
		return ptr;
	}

};


// Class Engine.NavigationInvokerComponent
// 0x0010 (0x0100 - 0x00F0)
class UNavigationInvokerComponent : public UActorComponent
{
public:
	float                                              TileGenerationRadius;                                     // 0x00F0(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	float                                              TileRemovalRadius;                                        // 0x00F4(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      NavigationDataToUpdate;                                   // 0x00F8(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavigationInvokerComponent");
		return ptr;
	}

};


// Class Engine.NavigationPath
// 0x0098 (0x00C0 - 0x0028)
class UNavigationPath : public UObject
{
public:
	struct FScriptMulticastDelegate                    PathUpdatedNotifier;                                      // 0x0028(0x0010) (CPF_ZeroConstructor, CPF_InstancedReference, CPF_BlueprintAssignable)
	TArray<struct FVector>                             PathPoints;                                               // 0x0038(0x0010) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor)
	TEnumAsByte<ENavigationOptionFlag>                 RecalculateOnInvalidation;                                // 0x0048(0x0001) (CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData00[0x77];                                      // 0x0049(0x0077) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavigationPath");
		return ptr;
	}


	bool IsValid();
	bool IsStringPulled();
	bool IsPartial();
	float GetPathLength();
	float GetPathCost();
	struct FString GetDebugString();
	void EnableRecalculationOnInvalidation(TEnumAsByte<ENavigationOptionFlag> DoRecalculation);
	void EnableDebugDrawing(bool bShouldDrawDebugData, const struct FLinearColor& PathColor);
};


// Class Engine.NavigationPathGenerator
// 0x0000 (0x0028 - 0x0028)
class UNavigationPathGenerator : public UInterface
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavigationPathGenerator");
		return ptr;
	}

};


// Class Engine.NavigationSystem
// 0x0448 (0x0470 - 0x0028)
class UNavigationSystem : public UBlueprintFunctionLibrary
{
public:
	class ANavigationData*                             MainNavData;                                              // 0x0028(0x0008) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	class ANavigationData*                             AbstractNavData;                                          // 0x0030(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	class UClass*                                      CrowdManagerClass;                                        // 0x0038(0x0008) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      bAutoCreateNavigationData : 1;                            // 0x0040(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bAllowClientSideNavigation : 1;                           // 0x0040(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      bSupportRebuilding : 1;                                   // 0x0040(0x0001)
	unsigned char                                      bInitialBuildingLocked : 1;                               // 0x0040(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      UnknownData00 : 1;                                        // 0x0040(0x0001)
	unsigned char                                      bSkipAgentHeightCheckWhenPickingNavData : 1;              // 0x0040(0x0001) (CPF_Edit, CPF_Config)
	unsigned char                                      UnknownData01[0x3];                                       // 0x0041(0x0003) MISSED OFFSET
	ENavDataGatheringModeConfig                        DataGatheringMode;                                        // 0x0044(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_DisableEditOnInstance, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x3];                                       // 0x0045(0x0003) MISSED OFFSET
	unsigned char                                      bGenerateNavigationOnlyAroundNavigationInvokers : 1;      // 0x0048(0x0001) (CPF_Edit, CPF_Config, CPF_DisableEditOnInstance)
	unsigned char                                      UnknownData03[0x3];                                       // 0x0049(0x0003) MISSED OFFSET
	float                                              ActiveTilesUpdateInterval;                                // 0x004C(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	TArray<struct FNavDataConfig>                      SupportedAgents;                                          // 0x0050(0x0010) (CPF_Edit, CPF_ZeroConstructor, CPF_Config)
	float                                              DirtyAreasUpdateFreq;                                     // 0x0060(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_Config, CPF_IsPlainOldData)
	unsigned char                                      UnknownData04[0x4];                                       // 0x0064(0x0004) MISSED OFFSET
	TArray<class ANavigationData*>                     NavDataSet;                                               // 0x0068(0x0010) (CPF_ZeroConstructor)
	TArray<class ANavigationData*>                     NavDataRegistrationQueue;                                 // 0x0078(0x0010) (CPF_ZeroConstructor, CPF_Transient)
	unsigned char                                      UnknownData05[0x60];                                      // 0x0088(0x0060) MISSED OFFSET
	struct FScriptMulticastDelegate                    OnNavDataRegisteredEvent;                                 // 0x00E8(0x0010) (CPF_ZeroConstructor, CPF_Transient, CPF_InstancedReference)
	struct FScriptMulticastDelegate                    OnNavigationGenerationFinishedDelegate;                   // 0x00F8(0x0010) (CPF_ZeroConstructor, CPF_Transient, CPF_InstancedReference, CPF_BlueprintAssignable)
	unsigned char                                      UnknownData06[0x12C];                                     // 0x0108(0x012C) MISSED OFFSET
	EFNavigationSystemRunMode                          OperationMode;                                            // 0x0234(0x0001) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData07[0x23B];                                     // 0x0235(0x023B) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavigationSystem");
		return ptr;
	}


	void UnregisterNavigationInvoker(class AActor* Invoker);
	static void SimpleMoveToLocation(class AController* Controller, const struct FVector& Goal);
	static void SimpleMoveToActor(class AController* Controller, class AActor* Goal);
	void SetMaxSimultaneousTileGenerationJobsCount(int MaxNumberOfJobs);
	void SetGeometryGatheringMode(ENavDataGatheringModeConfig NewMode);
	void ResetMaxSimultaneousTileGenerationJobsCount();
	void RegisterNavigationInvoker(class AActor* Invoker, float TileGenerationRadius, float TileRemovalRadius, class UClass* NavigationDataToUpdate);
	static struct FVector ProjectPointToNavigation(class UObject* WorldContextObject, const struct FVector& Point, class ANavigationData* NavData, class UClass* FilterClass, const struct FVector& QueryExtent);
	void OnNavigationBoundsUpdated(class ANavMeshBoundsVolume* NavVolume);
	static bool NavigationRaycast(class UObject* WorldContextObject, const struct FVector& RayStart, const struct FVector& RayEnd, class UClass* FilterClass, class AController* Querier, struct FVector* HitLocation);
	static bool K2_ProjectPointToNavigation(class UObject* WorldContextObject, const struct FVector& Point, class ANavigationData* NavData, class UClass* FilterClass, const struct FVector& QueryExtent, struct FVector* ProjectedLocation);
	static bool K2_GetRandomReachablePointInRadius(class UObject* WorldContextObject, const struct FVector& Origin, float Radius, class ANavigationData* NavData, class UClass* FilterClass, struct FVector* RandomLocation);
	static bool K2_GetRandomPointInNavigableRadius(class UObject* WorldContextObject, const struct FVector& Origin, float Radius, class ANavigationData* NavData, class UClass* FilterClass, struct FVector* RandomLocation);
	static bool IsNavigationBeingBuiltOrLocked(class UObject* WorldContextObject);
	static bool IsNavigationBeingBuilt(class UObject* WorldContextObject);
	static struct FVector GetRandomReachablePointInRadius(class UObject* WorldContextObject, const struct FVector& Origin, float Radius, class ANavigationData* NavData, class UClass* FilterClass);
	static struct FVector GetRandomPointInNavigableRadius(class UObject* WorldContextObject, const struct FVector& Origin, float Radius, class ANavigationData* NavData, class UClass* FilterClass);
	static TEnumAsByte<ENavigationQueryResult> GetPathLength(class UObject* WorldContextObject, const struct FVector& PathStart, const struct FVector& PathEnd, class ANavigationData* NavData, class UClass* FilterClass, float* PathLength);
	static TEnumAsByte<ENavigationQueryResult> GetPathCost(class UObject* WorldContextObject, const struct FVector& PathStart, const struct FVector& PathEnd, class ANavigationData* NavData, class UClass* FilterClass, float* PathCost);
	static class UNavigationSystem* GetNavigationSystem(class UObject* WorldContextObject);
	static class UNavigationPath* FindPathToLocationSynchronously(class UObject* WorldContextObject, const struct FVector& PathStart, const struct FVector& PathEnd, class AActor* PathfindingContext, class UClass* FilterClass);
	static class UNavigationPath* FindPathToActorSynchronously(class UObject* WorldContextObject, const struct FVector& PathStart, class AActor* GoalActor, float TetherDistance, class AActor* PathfindingContext, class UClass* FilterClass);
};


// Class Engine.NavigationTestingActor
// 0x0108 (0x0420 - 0x0318)
class ANavigationTestingActor : public AActor
{
public:
	unsigned char                                      UnknownData00[0x10];                                      // 0x0318(0x0010) MISSED OFFSET
	class UCapsuleComponent*                           CapsuleComponent;                                         // 0x0328(0x0008) (CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	class UNavigationInvokerComponent*                 InvokerComponent;                                         // 0x0330(0x0008) (CPF_Edit, CPF_ExportObject, CPF_ZeroConstructor, CPF_InstancedReference, CPF_IsPlainOldData)
	unsigned char                                      bActAsNavigationInvoker : 1;                              // 0x0338(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData01[0x7];                                       // 0x0339(0x0007) MISSED OFFSET
	struct FNavAgentProperties                         NavAgentProps;                                            // 0x0340(0x0020) (CPF_Edit)
	struct FVector                                     QueryingExtent;                                           // 0x0360(0x000C) (CPF_Edit, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x4];                                       // 0x036C(0x0004) MISSED OFFSET
	class ANavigationData*                             MyNavData;                                                // 0x0370(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)
	struct FVector                                     ProjectedLocation;                                        // 0x0378(0x000C) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_EditConst, CPF_IsPlainOldData)
	unsigned char                                      bProjectedLocationValid : 1;                              // 0x0384(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_EditConst)
	unsigned char                                      bSearchStart : 1;                                         // 0x0384(0x0001) (CPF_Edit)
	unsigned char                                      bUseHierarchicalPathfinding : 1;                          // 0x0384(0x0001) (CPF_Edit)
	unsigned char                                      bGatherDetailedInfo : 1;                                  // 0x0384(0x0001) (CPF_Edit)
	unsigned char                                      bDrawDistanceToWall : 1;                                  // 0x0384(0x0001) (CPF_Edit)
	unsigned char                                      bShowNodePool : 1;                                        // 0x0384(0x0001) (CPF_Edit)
	unsigned char                                      bShowBestPath : 1;                                        // 0x0384(0x0001) (CPF_Edit)
	unsigned char                                      bShowDiffWithPreviousStep : 1;                            // 0x0384(0x0001) (CPF_Edit)
	unsigned char                                      bShouldBeVisibleInGame : 1;                               // 0x0385(0x0001) (CPF_Edit)
	unsigned char                                      UnknownData03[0x2];                                       // 0x0386(0x0002) MISSED OFFSET
	TEnumAsByte<ENavCostDisplay>                       CostDisplayMode;                                          // 0x0388(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData04[0x3];                                       // 0x0389(0x0003) MISSED OFFSET
	struct FVector2D                                   TextCanvasOffset;                                         // 0x038C(0x0008) (CPF_Edit, CPF_IsPlainOldData)
	unsigned char                                      bPathExist : 1;                                           // 0x0394(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Transient, CPF_EditConst)
	unsigned char                                      bPathIsPartial : 1;                                       // 0x0394(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Transient, CPF_EditConst)
	unsigned char                                      bPathSearchOutOfNodes : 1;                                // 0x0394(0x0001) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_Transient, CPF_EditConst)
	unsigned char                                      UnknownData05[0x3];                                       // 0x0395(0x0003) MISSED OFFSET
	float                                              PathfindingTime;                                          // 0x0398(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_Transient, CPF_EditConst, CPF_IsPlainOldData)
	float                                              PathCost;                                                 // 0x039C(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_Transient, CPF_EditConst, CPF_IsPlainOldData)
	int                                                PathfindingSteps;                                         // 0x03A0(0x0004) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor, CPF_Transient, CPF_EditConst, CPF_IsPlainOldData)
	unsigned char                                      UnknownData06[0x4];                                       // 0x03A4(0x0004) MISSED OFFSET
	class ANavigationTestingActor*                     OtherActor;                                               // 0x03A8(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      FilterClass;                                              // 0x03B0(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	int                                                ShowStepIndex;                                            // 0x03B8(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_DisableEditOnTemplate, CPF_Transient, CPF_IsPlainOldData)
	float                                              OffsetFromCornersDistance;                                // 0x03BC(0x0004) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData07[0x60];                                      // 0x03C0(0x0060) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavigationTestingActor");
		return ptr;
	}

};


// Class Engine.NavigationTypes
// 0x0000 (0x0028 - 0x0028)
class UNavigationTypes : public UObject
{
public:

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavigationTypes");
		return ptr;
	}

};


// Class Engine.NavLinkComponent
// 0x0020 (0x0680 - 0x0660)
class UNavLinkComponent : public UPrimitiveComponent
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0660(0x0008) MISSED OFFSET
	TArray<struct FNavigationLink>                     Links;                                                    // 0x0668(0x0010) (CPF_Edit, CPF_BlueprintVisible, CPF_BlueprintReadOnly, CPF_ZeroConstructor)
	unsigned char                                      UnknownData01[0x8];                                       // 0x0678(0x0008) MISSED OFFSET

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavLinkComponent");
		return ptr;
	}

};


// Class Engine.NavRelevantComponent
// 0x0030 (0x0120 - 0x00F0)
class UNavRelevantComponent : public UActorComponent
{
public:
	unsigned char                                      UnknownData00[0x24];                                      // 0x00F0(0x0024) MISSED OFFSET
	unsigned char                                      bAttachToOwnersRoot : 1;                                  // 0x0114(0x0001)
	unsigned char                                      UnknownData01[0x3];                                       // 0x0115(0x0003) MISSED OFFSET
	class UObject*                                     CachedNavParent;                                          // 0x0118(0x0008) (CPF_ZeroConstructor, CPF_Transient, CPF_IsPlainOldData)

	static UClass* StaticClass()
	{
		static auto ptr = UObject::FindObject<UClass>("Class Engine.NavRelevantComponent");
		return ptr;
	}


	void SetNavigationRelevancy(bool bRelevant);
};


// Class Engine.NavLinkCustomComponent
// 0x0110 (0x0230 - 0x0120)
class UNavLinkCustomComponent : public UNavRelevantComponent
{
public:
	unsigned char                                      UnknownData00[0x8];                                       // 0x0120(0x0008) MISSED OFFSET
	uint32_t                                           NavLinkUserId;                                            // 0x0128(0x0004) (CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData01[0x4];                                       // 0x012C(0x0004) MISSED OFFSET
	class UClass*                                      EnabledAreaClass;                                         // 0x0130(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	class UClass*                                      DisabledAreaClass;                                        // 0x0138(0x0008) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	struct FVector                                     LinkRelativeStart;                                        // 0x0140(0x000C) (CPF_Edit, CPF_IsPlainOldData)
	struct FVector                                     LinkRelativeEnd;                                          // 0x014C(0x000C) (CPF_Edit, CPF_IsPlainOldData)
	TEnumAsByte<ENavLinkDirection>                     LinkDirection;                                            // 0x0158(0x0001) (CPF_Edit, CPF_ZeroConstructor, CPF_IsPlainOldData)
	unsigned char                                      UnknownData02[0x3];                                       // 0x0159(0x0003) MISSED OFFSET
	unsigned char                                      bLinkEnabled : 1;                                         // 0x015C(0x0001) (CPF_Edit)
	unsigned char                                      bNotifyWhenEnabled : 1;                                   // 0x015C(0x0001) (CPF_Edit)
	unsigned char                                      bNotifyWhenDisabled : 1;                                  // 0x015C(0x0001) (CPF_Ed