/*
 * Decompiled with CFR 0.152.
 */
package lee.study.down.task;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import lee.study.down.model.PluginBean;
import lee.study.down.plug.PluginContent;
import lee.study.down.plug.PluginUtil;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginUpdateCheckTask
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginUpdateCheckTask.class);
    private static final String HOST = "https://github.com/monkeyWie/proxyee-down-plugin/raw/master/";

    @Override
    public void run() {
        try {
            Document document = Jsoup.connect((String)"https://github.com/monkeyWie/proxyee-down-plugin").get();
            for (String name : document.select("td.content span.css-truncate.css-truncate-target").eachText()) {
                URL url = new URL(HOST + name);
                URLConnection connection = url.openConnection();
                connection.setUseCaches(false);
                PluginBean pluginBean = PluginUtil.checkAndUpdateLocalPlugin((String)name, (InputStream)connection.getInputStream());
                PluginBean current = PluginContent.get((String)name);
                if (current == null || !(pluginBean.getVersion() > current.getVersion())) continue;
                PluginContent.set((String)name, (PluginBean)pluginBean);
            }
        }
        catch (IOException e) {
            LOGGER.error("plugin set error", (Throwable)e);
        }
    }
}

