/*
 * Decompiled with CFR 0.152.
 */
package lee.study.down.mvc.controller;

import lee.study.down.content.ContentManager;
import lee.study.down.model.ResultInfo;
import lee.study.down.model.TaskInfo;
import lee.study.down.mvc.controller.HttpDownController;
import lee.study.down.mvc.form.BuildTaskForm;
import lee.study.down.mvc.form.CreateTaskForm;
import lee.study.down.mvc.form.NewTaskForm;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"open"})
public class OpenController {
    @RequestMapping(value={"createTask"})
    public ResultInfo open(@RequestBody CreateTaskForm createTaskForm) throws Exception {
        ResultInfo resultInfo = HttpDownController.commonBuildTask((BuildTaskForm)createTaskForm.getRequest());
        if (resultInfo.getStatus() == ResultInfo.ResultStatus.SUCC.getCode()) {
            TaskInfo taskInfo = ContentManager.DOWN.getTaskInfo(resultInfo.getData().toString());
            NewTaskForm taskForm = new NewTaskForm();
            taskForm.setId(taskInfo.getId());
            if (!StringUtils.isEmpty((Object)createTaskForm.getFileName())) {
                taskForm.setFileName(createTaskForm.getFileName());
            } else {
                taskForm.setFileName(taskInfo.getFileName());
            }
            if (!StringUtils.isEmpty((Object)taskInfo.getFilePath())) {
                taskForm.setFilePath(taskInfo.getFilePath());
            } else {
                taskForm.setFilePath(createTaskForm.getFilePath());
            }
            taskForm.setUnzip(createTaskForm.getUnzipFlag() == 1);
            taskForm.setUnzipPath(createTaskForm.getUnzipPath());
            taskForm.setConnections(createTaskForm.getConnections());
            resultInfo = HttpDownController.commonStartTask((NewTaskForm)taskForm);
        }
        return resultInfo;
    }
}

