/*
 * Decompiled with CFR 0.152.
 */
package lee.study.down.gui;

import com.sun.javafx.application.ParametersImpl;
import java.awt.CheckboxMenuItem;
import java.awt.Desktop;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.web.WebView;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import lee.study.down.HttpDownProxyServer;
import lee.study.down.ca.HttpDownProxyCACertFactory;
import lee.study.down.constant.HttpDownConstant;
import lee.study.down.content.ContentManager;
import lee.study.down.gui.CheckboxMenuItemGroup;
import lee.study.down.gui.HttpDownApplication;
import lee.study.down.intercept.HttpDownHandleInterceptFactory;
import lee.study.down.intercept.common.HttpDownInterceptFactory;
import lee.study.down.model.ConfigInfo;
import lee.study.down.mvc.HttpDownSpringBoot;
import lee.study.down.plug.PluginContent;
import lee.study.down.task.HttpDownProgressEventTask;
import lee.study.down.task.PluginUpdateCheckTask;
import lee.study.down.util.ByteUtil;
import lee.study.down.util.ConfigUtil;
import lee.study.down.util.FileUtil;
import lee.study.down.util.OsUtil;
import lee.study.down.util.PathUtil;
import lee.study.proxyee.crt.CertUtil;
import lee.study.proxyee.server.HttpProxyCACertFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.builder.SpringApplicationBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpDownApplication
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpDownApplication.class);
    private String url;
    private float version;
    private Stage stage;
    private Browser browser;
    private static HttpDownProxyServer proxyServer;
    private static boolean isSupportBrowser;

    private void initConfig() throws Exception {
        int viewPort = Integer.parseInt(ConfigUtil.getValue((String)"view.server.port"));
        int tomcatPort = Integer.parseInt(ConfigUtil.getValue((String)"tomcat.server.port"));
        if ("prd".equalsIgnoreCase(ConfigUtil.getValue((String)"spring.profiles.active"))) {
            try {
                if (OsUtil.isBusyPort((int)tomcatPort)) {
                    tomcatPort = OsUtil.getFreePort((int)(tomcatPort + 1));
                }
            }
            catch (Exception e) {
                LOGGER.error("getFreePort:", (Throwable)e);
                JOptionPane.showMessageDialog(null, "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u5c1d\u8bd5\u5728\u547d\u4ee4\u884c\u4e2d\u6267\u884cnetsh winsock reset\uff0c\u518d\u8fd0\u884c\u8f6f\u4ef6", "\u8fd0\u884c\u8b66\u544a", 0);
                throw e;
            }
            viewPort = tomcatPort;
            ConfigUtil.setValue((String)"view.server.port", (Object)viewPort);
            ConfigUtil.setValue((String)"tomcat.server.port", (Object)tomcatPort);
        }
        this.url = "http://127.0.0.1:" + viewPort;
        this.version = Float.parseFloat(ConfigUtil.getValue((String)"app.version"));
    }

    private void initHandle() throws Exception {
        this.initConfig();
        List args = ParametersImpl.getParameters((Application)this).getRaw();
        new SpringApplicationBuilder(new Object[]{HttpDownSpringBoot.class}).headless(false).build().run(args.toArray(new String[args.size()]));
        ContentManager.init();
        PluginContent.init();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                if (ContentManager.CONFIG.get().getSniffModel() != 3) {
                    OsUtil.disabledProxy();
                }
            }
            catch (IOException e) {
                LOGGER.error("disabledProxy error", (Throwable)e);
            }
        }));
    }

    private void afterTrayInit() {
        try {
            if (!FileUtil.exists((String)HttpDownConstant.CA_PRI_PATH) || !FileUtil.exists((String)HttpDownConstant.CA_CERT_PATH)) {
                KeyPair keyPair = CertUtil.genKeyPair();
                File priKeyFile = FileUtil.createFile((String)HttpDownConstant.CA_PRI_PATH, (boolean)true);
                File caCertFile = FileUtil.createFile((String)HttpDownConstant.CA_CERT_PATH, (boolean)false);
                Files.write(Paths.get(priKeyFile.toURI()), keyPair.getPrivate().getEncoded(), new OpenOption[0]);
                Files.write(Paths.get(caCertFile.toURI()), CertUtil.genCACert((String)"C=CN, ST=GD, L=SZ, O=lee, OU=study, CN=ProxyeeRoot", (Date)new Date(), (Date)new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(3650L)), (KeyPair)keyPair).getEncoded(), new OpenOption[0]);
            }
            if (ContentManager.CONFIG.get().isCheckCa() && !OsUtil.existsCert((String)"ProxyeeRoot", (String)ByteUtil.getCertHash((X509Certificate)CertUtil.loadCert((String)HttpDownConstant.CA_CERT_PATH)))) {
                if (OsUtil.existsCert((String)"ProxyeeRoot")) {
                    if (OsUtil.isWindows() && OsUtil.existsWindowsCert((String)"ProxyeeRoot", (boolean)false)) {
                        this.showMsg("\u68c0\u6d4b\u5230\u7cfb\u7edf\u5b58\u5728\u65e7\u7684\u8bc1\u4e66\uff0c\u8bf7\u6309\u786e\u5b9a\u518d\u6839\u636e\u5f15\u5bfc\u8fdb\u884c\u5220\u9664");
                    }
                    OsUtil.uninstallCert((String)"ProxyeeRoot");
                }
                if (OsUtil.isWindows() && !OsUtil.isAdmin()) {
                    this.showMsg("\u9700\u8981\u5b89\u88c5\u65b0\u8bc1\u4e66\uff0c\u8bf7\u6309\u786e\u5b9a\u518d\u5f15\u5bfc\u8fdb\u884c\u5b89\u88c5");
                }
                OsUtil.installCert((String)HttpDownConstant.CA_CERT_PATH);
            }
        }
        catch (Exception e) {
            ContentManager.CONFIG.get().setCheckCa(false);
            ContentManager.CONFIG.save();
            this.showMsg("\u8bc1\u4e66\u5b89\u88c5\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u5b89\u88c5");
            LOGGER.error("cert handle error", (Throwable)e);
        }
        proxyServer = new HttpDownProxyServer((HttpProxyCACertFactory)new HttpDownProxyCACertFactory(HttpDownConstant.CA_CERT_PATH, HttpDownConstant.CA_PRI_PATH), ContentManager.CONFIG.get().getSecProxyConfig(), (HttpDownInterceptFactory)new HttpDownHandleInterceptFactory(httpDownInfo -> Platform.runLater(() -> {
            if (ContentManager.CONFIG.get().getUiModel() == 1) {
                String taskId = httpDownInfo.getTaskInfo().getId();
                this.browser.webEngine.executeScript("vue.$children[0].openTabHandle('/tasks');vue.$store.commit('tasks/setNewTaskId','" + taskId + "');vue.$store.commit('tasks/setNewTaskStatus',2);");
            }
            this.open(false);
        })));
        int sniffProxyPort = ContentManager.CONFIG.get().getProxyPort();
        if (OsUtil.isBusyPort((int)sniffProxyPort)) {
            this.showMsg("\u7aef\u53e3(" + sniffProxyPort + ")\u88ab\u5360\u7528\uff0c\u8bf7\u5173\u95ed\u5360\u7528\u7aef\u53e3\u7684\u8f6f\u4ef6\u6216\u8bbe\u7f6e\u65b0\u7684\u7aef\u53e3\u53f7");
        } else {
            new Thread(() -> proxyServer.start(ContentManager.CONFIG.get().getProxyPort())).start();
        }
        new HttpDownProgressEventTask().start();
        new PluginUpdateCheckTask().start();
    }

    public void start(Stage stage) throws Exception {
        this.initHandle();
        this.stage = stage;
        Platform.setImplicitExit((boolean)false);
        isSupportBrowser = this.isSupportBrowser();
        SwingUtilities.invokeLater(() -> this.addTray());
        if (ContentManager.CONFIG.get().getUiModel() == 1 && isSupportBrowser) {
            this.initBrowser();
        }
        stage.setTitle("proxyee-down-" + this.version);
        Rectangle2D bounds = Screen.getPrimary().getVisualBounds();
        ConfigInfo cf = ContentManager.CONFIG.get();
        stage.setX(cf.getGuiX() >= 0.0 ? cf.getGuiX() : bounds.getMinX());
        stage.setY(cf.getGuiY() >= 0.0 ? cf.getGuiY() : bounds.getMinY());
        stage.setWidth(cf.getGuiWidth() >= 0.0 ? cf.getGuiWidth() : bounds.getWidth());
        stage.setHeight(cf.getGuiHeight() >= 0.0 ? cf.getGuiHeight() : bounds.getHeight());
        stage.getIcons().add((Object)new Image(Thread.currentThread().getContextClassLoader().getResourceAsStream("favicon.png")));
        stage.setOnCloseRequest(event -> {
            event.consume();
            this.close();
        });
    }

    public void open(boolean isTray) {
        if (this.browser == null || ContentManager.CONFIG.get().getUiModel() == 2) {
            try {
                OsUtil.openBrowse((String)this.url);
            }
            catch (Exception e) {
                LOGGER.error("openBrowse error:", (Throwable)e);
            }
            return;
        }
        boolean isFront = false;
        if (this.stage.isShowing()) {
            if (this.stage.isIconified()) {
                this.stage.setIconified(false);
            } else {
                isFront = true;
                this.stage.toFront();
            }
        } else {
            isFront = true;
            this.stage.show();
            this.stage.toFront();
        }
        if (isFront && !isTray && OsUtil.isWindows()) {
            this.stage.setIconified(true);
            this.stage.setIconified(false);
        }
    }

    public void close() {
        this.stage.hide();
    }

    private void showMsg(String msg) {
        JOptionPane.showMessageDialog(null, msg, "\u63d0\u793a", 2);
    }

    private void addTray() {
        block14: {
            try {
                if (!SystemTray.isSupported()) break block14;
                SystemTray systemTray = SystemTray.getSystemTray();
                URL url = Thread.currentThread().getContextClassLoader().getResource("favicon.png");
                TrayIcon trayIcon = new TrayIcon(Toolkit.getDefaultToolkit().getImage(url), "proxyee-down");
                systemTray.add(trayIcon);
                trayIcon.setImageAutoSize(true);
                trayIcon.addActionListener(event -> Platform.runLater(() -> this.open(true)));
                PopupMenu popupMenu = new PopupMenu();
                MenuItem tasksItem = new MenuItem("\u663e\u793a");
                tasksItem.addActionListener(event -> Platform.runLater(() -> this.open(true)));
                MenuItem crtItem = new MenuItem("\u8bc1\u4e66\u76ee\u5f55");
                crtItem.addActionListener(event -> {
                    try {
                        Desktop.getDesktop().open(new File(HttpDownConstant.SSL_PATH));
                    }
                    catch (Exception e) {
                        LOGGER.error("open cert dir error", (Throwable)e);
                    }
                });
                Menu proxyMenu = new Menu("\u55c5\u63a2\u6a21\u5f0f");
                if (!OsUtil.isWindows() && !OsUtil.isMac()) {
                    proxyMenu.setEnabled(false);
                } else {
                    CheckboxMenuItemGroup mig = new CheckboxMenuItemGroup();
                    CheckboxMenuItem globalProxyItem = new CheckboxMenuItem("\u5168\u7f51");
                    globalProxyItem.setName("1");
                    CheckboxMenuItem bdyProxyItem = new CheckboxMenuItem("\u767e\u5ea6\u4e91");
                    bdyProxyItem.setName("2");
                    CheckboxMenuItem disableProxyItem = new CheckboxMenuItem("\u5173\u95ed");
                    disableProxyItem.setName("3");
                    proxyMenu.add(globalProxyItem);
                    proxyMenu.add(bdyProxyItem);
                    proxyMenu.add(disableProxyItem);
                    mig.add(globalProxyItem);
                    mig.add(bdyProxyItem);
                    mig.add(disableProxyItem);
                    try {
                        if (ContentManager.CONFIG.get().getSniffModel() == 1) {
                            mig.selectItem(globalProxyItem);
                            OsUtil.enabledHTTPProxy((String)"127.0.0.1", (int)ContentManager.CONFIG.get().getProxyPort());
                        } else if (ContentManager.CONFIG.get().getSniffModel() == 2) {
                            mig.selectItem(bdyProxyItem);
                            OsUtil.enabledPACProxy((String)("http://127.0.0.1:" + ConfigUtil.getValue((String)"tomcat.server.port") + "/res/pd.pac?t=" + System.currentTimeMillis()));
                        } else {
                            mig.selectItem(disableProxyItem);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("set proxy error", (Throwable)e);
                    }
                    mig.addActionListener(event -> {
                        try {
                            String selectedItemName = ((CheckboxMenuItem)event.getSource()).getName();
                            if ("1".equals(selectedItemName)) {
                                ContentManager.CONFIG.get().setSniffModel(1);
                                OsUtil.enabledHTTPProxy((String)"127.0.0.1", (int)ContentManager.CONFIG.get().getProxyPort());
                            } else if ("2".equals(selectedItemName)) {
                                ContentManager.CONFIG.get().setSniffModel(2);
                                OsUtil.enabledPACProxy((String)("http://127.0.0.1:" + ConfigUtil.getValue((String)"tomcat.server.port") + "/res/pd.pac?t=" + System.currentTimeMillis()));
                            } else {
                                ContentManager.CONFIG.get().setSniffModel(3);
                                OsUtil.disabledProxy();
                            }
                            ContentManager.CONFIG.save();
                        }
                        catch (Exception e) {
                            LOGGER.error("proxy switch error", (Throwable)e);
                            trayIcon.displayMessage("\u63d0\u793a", "\u55c5\u63a2\u6a21\u5f0f\u5207\u6362\u5931\u8d25", TrayIcon.MessageType.INFO);
                        }
                    });
                }
                Menu uiMenu = new Menu("UI\u6a21\u5f0f");
                CheckboxMenuItemGroup mig = new CheckboxMenuItemGroup();
                CheckboxMenuItem guiItem = new CheckboxMenuItem("GUI");
                guiItem.setName("1");
                CheckboxMenuItem browserItem = new CheckboxMenuItem("\u6d4f\u89c8\u5668");
                browserItem.setName("2");
                if (isSupportBrowser) {
                    uiMenu.add(guiItem);
                } else {
                    ContentManager.CONFIG.get().setUiModel(2);
                    ContentManager.CONFIG.save();
                }
                uiMenu.add(browserItem);
                mig.add(guiItem);
                mig.add(browserItem);
                if (ContentManager.CONFIG.get().getUiModel() == 1) {
                    mig.selectItem(guiItem);
                } else {
                    mig.selectItem(browserItem);
                }
                mig.addActionListener(event -> {
                    String selectedItemName = ((CheckboxMenuItem)event.getSource()).getName();
                    Platform.runLater(() -> {
                        if ("1".equals(selectedItemName)) {
                            ContentManager.CONFIG.get().setUiModel(1);
                            this.initBrowser();
                        } else {
                            ContentManager.CONFIG.get().setUiModel(2);
                            this.destroyBrowser();
                            this.stage.close();
                        }
                        this.open(true);
                        ContentManager.CONFIG.save();
                    });
                });
                MenuItem aboutItem = new MenuItem("\u5173\u4e8e");
                aboutItem.addActionListener(event -> Platform.runLater(() -> {
                    if (ContentManager.CONFIG.get().getUiModel() == 1) {
                        this.browser.webEngine.executeScript("vue.$children[0].openTabHandle('/about');");
                    }
                    this.open(true);
                }));
                MenuItem closeItem = new MenuItem("\u9000\u51fa");
                closeItem.addActionListener(event -> {
                    ContentManager.CONFIG.get().setGuiX(this.stage.getX());
                    ContentManager.CONFIG.get().setGuiY(this.stage.getY());
                    ContentManager.CONFIG.get().setGuiHeight(this.stage.getHeight());
                    ContentManager.CONFIG.get().setGuiWidth(this.stage.getWidth());
                    ContentManager.CONFIG.save();
                    System.exit(0);
                });
                popupMenu.add(tasksItem);
                popupMenu.addSeparator();
                popupMenu.add(crtItem);
                popupMenu.add(proxyMenu);
                popupMenu.add(uiMenu);
                popupMenu.addSeparator();
                popupMenu.add(aboutItem);
                popupMenu.add(closeItem);
                trayIcon.setPopupMenu(popupMenu);
                trayIcon.displayMessage("\u63d0\u793a", "proxyee-down\u542f\u52a8\u6210\u529f", TrayIcon.MessageType.INFO);
            }
            catch (Exception e) {
                LOGGER.error("addTray error:", (Throwable)e);
                this.showMsg("\u6258\u76d8\u521d\u59cb\u5316\u5931\u8d25");
            }
        }
        this.afterTrayInit();
    }

    private void initBrowser() {
        if (this.browser == null) {
            this.browser = new Browser(this);
            this.stage.setScene(new Scene((Parent)this.browser));
        }
        this.browser.load(this.url);
    }

    private boolean isSupportBrowser() {
        try {
            new WebView();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private void destroyBrowser() {
        if (this.browser != null) {
            this.browser.load(null);
        }
    }

    public static HttpDownProxyServer getProxyServer() {
        return proxyServer;
    }

    public static void main(String[] args) {
        HttpDownApplication.launch((String[])args);
    }

    static {
        System.setProperty("LOG_PATH", PathUtil.ROOT_PATH);
        System.setProperty("io.netty.noPreferDirect", "true");
        System.setProperty("io.netty.allocator.numHeapArenas", "0");
    }
}

