/*
 * Decompiled with CFR 0.152.
 */
package lee.study.down.dispatch;

import lee.study.down.content.ContentManager;
import lee.study.down.dispatch.HttpDownCallback;
import lee.study.down.io.BdyZip;
import lee.study.down.model.ChunkInfo;
import lee.study.down.model.HttpDownInfo;
import lee.study.down.model.TaskInfo;
import lee.study.down.mvc.form.NewTaskForm;
import lee.study.down.mvc.form.WsForm;
import lee.study.down.util.FileUtil;

public class HttpDownHandleCallback
extends HttpDownCallback {
    private void sendTask(String id) {
        ContentManager.WS.sendMsg(ContentManager.DOWN.buildWsForm(id));
    }

    public void onStart(HttpDownInfo httpDownInfo) throws Exception {
        ContentManager.DOWN.save();
        this.sendTask(httpDownInfo.getTaskInfo().getId());
    }

    public void onPause(HttpDownInfo httpDownInfo) throws Exception {
        this.sendTask(httpDownInfo.getTaskInfo().getId());
    }

    public void onContinue(HttpDownInfo httpDownInfo) throws Exception {
        this.sendTask(httpDownInfo.getTaskInfo().getId());
    }

    public void onError(HttpDownInfo httpDownInfo, Throwable cause) {
        ContentManager.DOWN.saveTask(httpDownInfo.getTaskInfo().getId());
        this.sendTask(httpDownInfo.getTaskInfo().getId());
    }

    public void onChunkDone(HttpDownInfo httpDownInfo, ChunkInfo chunkInfo) {
        ContentManager.DOWN.saveTask(httpDownInfo.getTaskInfo().getId());
    }

    public void onMerge(HttpDownInfo httpDownInfo) throws Exception {
        ContentManager.DOWN.saveTask(httpDownInfo.getTaskInfo().getId());
        this.sendTask(httpDownInfo.getTaskInfo().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDone(HttpDownInfo httpDownInfo) throws Exception {
        TaskInfo taskInfo = httpDownInfo.getTaskInfo();
        ContentManager.DOWN.save();
        TaskInfo taskInfo2 = taskInfo;
        synchronized (taskInfo2) {
            FileUtil.deleteIfExists((String)taskInfo.buildTaskRecordFilePath());
            FileUtil.deleteIfExists((String)taskInfo.buildTaskRecordBakFilePath());
        }
        this.sendTask(httpDownInfo.getTaskInfo().getId());
        NewTaskForm taskForm = NewTaskForm.parse((HttpDownInfo)httpDownInfo);
        if (taskForm.isUnzip() && BdyZip.isBdyZip((String)taskInfo.buildTaskFilePath())) {
            WsForm wsForm = new WsForm(3, (Object)new /* Unavailable Anonymous Inner Class!! */);
            ContentManager.WS.sendMsg(wsForm);
        }
    }

    public void onDelete(HttpDownInfo httpDownInfo) throws Exception {
        String taskId = httpDownInfo.getTaskInfo().getId();
        ContentManager.DOWN.removeBoot(taskId);
        ContentManager.DOWN.save();
        this.sendTask(taskId);
    }
}

