/*
 * Decompiled with CFR 0.152.
 */
package lee.study.down.content;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lee.study.down.mvc.form.WsForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class WsContent {
    private static final Logger LOGGER = LoggerFactory.getLogger(WsContent.class);
    private static Map<String, WebSocketSession> wcContent;

    public void put(String id, WebSocketSession session) {
        wcContent.put(id, session);
    }

    public void remove(String id) {
        wcContent.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendMsg(WsForm wsForm) {
        try {
            if (wsForm == null) {
                return;
            }
            TextMessage message = new TextMessage((CharSequence)JSON.toJSONString((Object)wsForm));
            for (Map.Entry entry : wcContent.entrySet()) {
                WebSocketSession session = (WebSocketSession)entry.getValue();
                if (!session.isOpen()) continue;
                WebSocketSession webSocketSession = session;
                synchronized (webSocketSession) {
                    session.sendMessage((WebSocketMessage)message);
                }
            }
            return;
        }
        catch (Exception e) {
            LOGGER.warn("sendMsg", (Throwable)e);
        }
    }

    public void init() {
        wcContent = new ConcurrentHashMap();
    }
}

