Attribute VB_Name = "Module1"
'PNG Image Viewer for Visual Basic 6.0
'
'Copyright 2003 by Dmitry Brant, All Rights Reserved.

'Version 1.2, Last modified 09-27-2001
'
'me@dmitrybrant.com
'
'http://www.dmitrybrant.com


'This program supports the PNG specification as described below:

'- This program fully supports alpha channels, and alpha
'  palettes for indexed images. It also supports single
'  transparent color indices.

'- This program only supports 8 and 16-bit samples. Therefore,
'  it supports any samples from 5 to 16 original significant
'  bits, but does not support 1, 2, or 4-bit samples.

'- The program does not support gamma correction. Instead, it
'  simply stores the gamma value and does nothing with it.

'- Background colors are supported, with an option to turn
'  the background color on/off.

'- I tried to optimize the code for speed (as slow as
'  VB may be). If you have an idea for an optimization,
'  tell me about it.

'Feel free to make improvements or optimizations to the program.
'If you do, please tell me or show me what you have done.

'This program is FREEWARE. Use freely, but give me credit
'where credit is due. (this program is NOT in the
'public domain). If you will use this source code in
'your software, the copyright notice stated above
'must be included in your source code and/or in the
'Help/About box of your program.

'The SOURCE CODE of this program, or portions of it, may not
'be redistributed, either by itself or in a compilation
'package, without express authorization from the author.

'ALL PRODUCT NAMES MENTIONED IN THIS SOFTWARE ARE TRADEMARKS
'OR REGISTERED TRADEMARKS OF THEIR RESPECTIVE OWNERS.

'THIS SOFTWARE IS DISTRIBUTED "AS IS". THE SOFTWARE IS
'DISTRIBUTED WITH NO WARRANTY, EIHER EXPRESSED
'OR IMPLIED, INCLUDING, BY WAY OF EXAMPLE THE IMPLIED
'WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
'PURPOSE. THE AUTHOR WILL NOT BE LIABLE FOR DATA LOSS, DAMAGES,
'LOSS OF PROFITS OR ANY OTHER KIND OF LOSS RESULTING FROM THE
'USE OR MISUSE OF THIS SOFTWARE.

Option Explicit
DefInt A-Z

'Declares for the Zlib library
Declare Function uncompress Lib "zlib32.dll" (uncompr As Byte, uncomprLen As Any, ByVal compr As String, ByVal lcompr As Long) As Long
'Declares for fast GDI functions
Declare Function SetPixel Lib "gdi32" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long, ByVal crColor As Long) As Long
Declare Function GetPixel Lib "gdi32" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long) As Long

Public CommentStr As String                     'string to store comment/property info
Public DrawBkColor As Boolean, ClearBk As Boolean

Sub DoPNG(FName As String, FObject As Object)
    Dim str1 As String                          'multi-purpose string variable
    Dim ChunkLength As Long, ChunkCRC As Long   'Chunk data vars
    Dim ChunkType As String * 4
    Dim FWidth As Long, FHeight As Long, IWidth As Long, IHeight As Long
    Dim Bpp As Byte, ColorType As Byte          'Image properties
    Dim Compression As Byte, Filter As Byte, Transparent As Boolean
    Dim Interlace As Byte, BgColor As Long, TrColor As Long
    Dim i As Long, j As Long, k As Integer, n As Integer    'multi-purpose integers
    Dim theHdc As Long                          'Device context of the object
    Dim r As Integer, g As Integer, b As Integer, a As Integer, Inc As Long, Inc2 As Long
    Dim pr As Integer, pg As Integer, pb As Integer, pa As Integer  'decoder vars
    Dim ar As Integer, ag As Integer, ab As Integer, aa As Integer
    Dim xr As Integer, xg As Integer, xb As Integer, xa As Integer
    Dim PaletteLength As Integer, BitReduction As Integer
    Dim Stream As String        'string that will contain the bitstream
    
    '[Useless] Attributes
    Dim ImageGamma As Single
    Dim AspectX As Long, AspectY As Long, UnitType As Integer
    
    'On Error GoTo ErrorTrap
    Open FName For Binary As #1
    
    str1 = "        "
    Get #1, , str1
    
    If str1 <> Chr(137) + Chr(80) + Chr(78) + Chr(71) + Chr(13) + Chr(10) + Chr(26) + Chr(10) Then
        MsgBox "This is not a valid PNG Image.", , "Error"
       Close #1
        Exit Sub
    End If
    
    ChunkLength = GetDword
    Get #1, , ChunkType
    If ChunkType <> "IHDR" Then
        MsgBox "This is not a valid PNG Image.", , "Error"
        Close #1
        Exit Sub
    End If
    
    FWidth = GetDword
    FHeight = GetDword
    Get #1, , Bpp
    Get #1, , ColorType
    Get #1, , Compression
    Get #1, , Filter
    Get #1, , Interlace
    Get #1, , ChunkCRC
    Transparent = False
    BitReduction = Bpp \ 8

    If Compression <> 0 Then
        MsgBox "Unrecognized compression method: " + Str(Compression), vbCritical, "Error"
        Close #1
        Exit Sub
    End If
    If Filter <> 0 Then
        MsgBox "Unrecognized filtering method: " + Str(Filter), vbCritical, "Error"
        Close #1
        Exit Sub
    End If
    If Interlace <> 0 And Interlace <> 1 Then
        MsgBox "Unrecognized interlace method: " + Str(Interlace), vbCritical, "Error"
        Close #1
        Exit Sub
    End If
    If FWidth <= 0 Or FHeight <= 0 Then
        MsgBox "Invalid image dimensions.", vbCritical, "Error"
        Close #1
        Exit Sub
    End If
    If Bpp <> 8 And Bpp <> 16 Then
        MsgBox Str(Bpp) + "-bit Samples are not supported.", vbCritical, "Error"
        Close #1
        Exit Sub
    End If

    CommentStr = ""

    CommentStr = CommentStr + "Image Dimensions: " + Str(FWidth) + " x" + Str(FHeight) + vbCrLf + vbCrLf
    CommentStr = CommentStr + "Image Type:" + Str(Bpp) + "-bit, "
    Select Case ColorType
    Case 0
        CommentStr = CommentStr + "Grayscale (1 channel)" + vbCrLf + vbCrLf
    Case 2
        CommentStr = CommentStr + "TrueColor (3 channels)" + vbCrLf + vbCrLf
    Case 3
        CommentStr = CommentStr + "Indexed (1 channel)" + vbCrLf + vbCrLf
    Case 4
        CommentStr = CommentStr + "Grayscale plus Alpha (2 channels)" + vbCrLf + vbCrLf
    Case 6
        CommentStr = CommentStr + "TrueColor plus Alpha (4 channels)" + vbCrLf + vbCrLf
    Case Else
        MsgBox "Invalid ColorType: " + Str(ColorType), vbCritical, "Error"
        Close #1
        Exit Sub
    End Select

    If Interlace Then
        CommentStr = CommentStr + "Interlaced: Yes" + vbCrLf + vbCrLf
    Else
        CommentStr = CommentStr + "Interlaced: No" + vbCrLf + vbCrLf
    End If

    Do Until EOF(1)
        ChunkLength = GetDword
        Get #1, , ChunkType
        Select Case ChunkType
        
        Case "PLTE"
            PaletteLength = ChunkLength / 3
            ReDim Palette(0 To PaletteLength - 1) As Long
            For i = 0 To PaletteLength - 1
                Palette(i) = RGB(GetByte, GetByte, GetByte)
            Next i
            CommentStr = CommentStr + "Palette Entries: " + Str(PaletteLength) + vbCrLf + vbCrLf
            
        Case "IDAT"
            str1 = Space(ChunkLength)
            Get #1, , str1
            Stream = Stream + str1
            str1 = ""
            
        Case "IEND"
            Exit Do
            
        Case "pHYs"
            AspectX = GetDword
            AspectY = GetDword
            UnitType = GetByte
            If UnitType = 0 Then
                CommentStr = CommentStr + "Aspect Ratio:" + Str(AspectX) + " :" + Str(AspectY) + vbCrLf + vbCrLf
            Else
                CommentStr = CommentStr + "X-Resolution:" + Str(AspectX) + " pixels/meter" + vbCrLf + vbCrLf
                CommentStr = CommentStr + "Y-Resolution:" + Str(AspectY) + " pixels/meter" + vbCrLf + vbCrLf
            End If
            
        Case "gIFx"
            str1 = Space(ChunkLength)
            Get #1, , str1
            
        Case "bKGD"             'Background Color
            Select Case ColorType
            Case 0, 4       'Grayscale
                i = GetWord \ ((2 ^ Bpp) \ 256)  'get an integer value
                BgColor = RGB(i, i, i)
            Case 2, 6       'RGB Triple
                BgColor = RGB(GetWord \ ((2 ^ Bpp) \ 256), GetWord \ ((2 ^ Bpp) \ 256), GetWord \ ((2 ^ Bpp) \ 256))
            Case 3          'Palette Indices
                BgColor = Palette(GetByte)
            End Select
            If DrawBkColor Then FObject.Line (0, 0)-(FWidth - 1, FHeight - 1), BgColor, BF
            
        Case "cHRM"             'Color Chromaticities
            str1 = Space(ChunkLength)
            Get #1, , str1
            CommentStr = CommentStr + "Color Chromaticity data present." + vbCrLf + vbCrLf
            
        Case "gAMA"             'Image Gamma
            ImageGamma = GetDword / 100000
            CommentStr = CommentStr + "Image Gamma:" + Str(ImageGamma) + vbCrLf + vbCrLf
            
        Case "hIST"             'Image Histogram
            str1 = Space(ChunkLength)
            Get #1, , str1
            CommentStr = CommentStr + "Histogram data present." + vbCrLf + vbCrLf
            
        Case "sBIT"             'Original Significant Bits
            CommentStr = CommentStr + "Original Significant Bits:"
            Select Case ColorType
            Case 0
                CommentStr = CommentStr + Str(GetByte) + vbCrLf + vbCrLf
            Case 2, 3
                CommentStr = CommentStr + Str(GetByte) + "," + Str(GetByte) + "," + Str(GetByte) + vbCrLf + vbCrLf
            Case 4
                CommentStr = CommentStr + Str(GetByte) + "," + Str(GetByte) + vbCrLf + vbCrLf
            Case 6
                CommentStr = CommentStr + Str(GetByte) + "," + Str(GetByte) + "," + Str(GetByte) + "," + Str(GetByte) + vbCrLf + vbCrLf
            End Select
            
        Case "tIME"             'Time of Creation
            i = GetWord 'get year
            CommentStr = CommentStr + "Time of Creation:" + _
                         Str(GetByte) + "/" + Str(GetByte) + "/" + Str(i) + ", " + _
                         Str(GetByte) + ":" + Str(GetByte) + ":" + Str(GetByte) + vbCrLf + vbCrLf

        Case "tRNS"             'Transparency Data
            Select Case ColorType
            Case 0       'Grayscale
                i = GetWord \ ((2 ^ Bpp) \ 256)  'get an integer value
                TrColor = RGB(i, i, i)
                CommentStr = CommentStr + "Transparent color present." + vbCrLf + vbCrLf
            Case 2       'RGB Triple
                TrColor = RGB(GetWord \ ((2 ^ Bpp) \ 256), GetWord \ ((2 ^ Bpp) \ 256), GetWord \ ((2 ^ Bpp) \ 256))
                CommentStr = CommentStr + "Transparent color present." + vbCrLf + vbCrLf
            Case 3       'Palette Indices
                ReDim PaletteTrans(0 To PaletteLength - 1) As Byte
                For i = 0 To ChunkLength - 1
                    PaletteTrans(i) = GetByte
                Next i
                For i = ChunkLength To PaletteLength - 1
                    PaletteTrans(i) = 255
                Next i
                CommentStr = CommentStr + "Transparent palette entries: " + Str(ChunkLength) + vbCrLf + vbCrLf
            End Select
            Transparent = True
            
        Case "zTXt"             'Compressed Text
            str1 = Space(ChunkLength)
            Get #1, , str1
            CommentStr = CommentStr + "ZText data present." + vbCrLf + vbCrLf
            
        Case "tEXt"             'Comment
            str1 = Space(ChunkLength)
            Get #1, , str1
            CommentStr = CommentStr + Left(str1, InStr(str1, Chr(0)) - 1) + ": " + _
                        Right(str1, Len(str1) - InStr(str1, Chr(0))) + vbCrLf + vbCrLf

        Case Else
            CommentStr = CommentStr + "Unknown Chunk Encountered: " + ChunkType + ", Length:" + Str(ChunkLength) + vbCrLf + vbCrLf
            str1 = Space(ChunkLength)
            Get #1, , str1
            
        End Select
        Get #1, , ChunkCRC
    Loop
    
    theHdc = FObject.hdc
    
    'Decode the Stream received from IDAT
    If Interlace = 0 Then
        Select Case ColorType
        Case 0                  'The Image is grayscale [1 channel]
            'Start Inflating
            j = FWidth * FHeight * BitReduction + FHeight
            ReDim OutStr(0 To j - 1) As Byte
            i = uncompress(OutStr(0), j, Stream, Len(Stream))
            If i Then
                MsgBox "File may be corrupted! The DLL returned: " + Str(i), vbCritical, "Error"
                Close #1
                Exit Sub
            End If
            Stream = ""     'free up some memory
            
            ReDim Scanline2(0 To FWidth) As Byte
            ReDim Scanline(0 To FWidth) As Byte
            Inc = 0
            For j = 0 To FHeight - 1
                If Bpp = 8 Then
                    For i = 0 To FWidth
                        Scanline(i) = OutStr(i + Inc)
                    Next i
                    Inc = Inc + FWidth + 1
                ElseIf Bpp = 16 Then
                    Scanline(0) = OutStr(Inc)
                    For i = 0 To FWidth - 1
                        Scanline(i + 1) = OutStr(i * 2 + 1 + Inc)
                    Next i
                    Inc = Inc + FWidth * 2 + 1
                End If

                k = Scanline(0)
                Select Case k
                Case 0
                    For i = 1 To FWidth
                        r = Scanline(i)
                        SetPixel theHdc, i - 1, j, RGB(r, r, r)
                    Next i
                Case 1
                    pr = 0
                    For i = 1 To FWidth
                        r = Scanline(i)
                        r = (r + pr) Mod 256
                        If r < 0 Then r = 0
                        Scanline(i) = r
                        pr = r
                        SetPixel theHdc, i - 1, j, RGB(r, r, r)
                    Next i
                Case 2
                    For i = 1 To FWidth
                        r = Scanline(i)
                        ar = Scanline2(i)
                        r = (r + ar) Mod 256
                        Scanline(i) = r
                        SetPixel theHdc, i - 1, j, RGB(r, r, r)
                    Next i
                Case 3
                    pr = 0
                    For i = 1 To FWidth
                        r = Scanline(i)
                        ar = Scanline2(i)
                        r = (r + (ar + pr) \ 2) Mod 256
                        Scanline(i) = r
                        pr = r
                        SetPixel theHdc, i - 1, j, RGB(r, r, r)
                    Next i
                Case 4
                    xr = 0: pr = 0
                    For i = 1 To FWidth
                        r = Scanline(i)
                        ar = Scanline2(i)
                        xr = Scanline2(i - 1)
                        If i = 1 Then xr = 0
                        r = (r + PaethPredictor(pr, ar, xr)) Mod 256
                        Scanline(i) = r
                        pr = r
                        SetPixel theHdc, i - 1, j, RGB(r, r, r)
                    Next i
                End Select
                If j Mod 16 = 0 Then FObject.Refresh
                Scanline2 = Scanline
            Next j
            Erase OutStr
            Erase Scanline
            Erase Scanline2
        Case 3                  'The Image is 8-bit [1 channel]
            'Start Inflating
            j = FWidth * FHeight * BitReduction + FHeight
            ReDim OutStr(0 To j - 1) As Byte
            i = uncompress(OutStr(0), j, Stream, Len(Stream))
            If i Then
                MsgBox "File may be corrupted! The DLL returned: " + Str(i), vbCritical, "Error"
                Close #1
                Exit Sub
            End If
            Stream = ""     'free up some memory
            
            ReDim Scanline2(0 To FWidth) As Byte
            ReDim Scanline(0 To FWidth) As Byte
            Inc = 0
            For j = 0 To FHeight - 1
                If Bpp = 8 Then
                    For i = 0 To FWidth
                        Scanline(i) = OutStr(i + Inc)
                    Next i
                    Inc = Inc + FWidth + 1
                ElseIf Bpp = 16 Then
                    Scanline(0) = OutStr(Inc)
                    For i = 0 To FWidth - 1
                        Scanline(i + 1) = OutStr(i * 2 + 1 + Inc)
                    Next i
                    Inc = Inc + FWidth * 2 + 1
                End If
                
                k = Scanline(0)
                Select Case k
                Case 0
                    For i = 1 To FWidth
                        r = Scanline(i)
                        If Transparent Then
                            SetPixelA3 theHdc, i - 1, j, Palette(r), PaletteTrans(r)
                        Else
                            SetPixel theHdc, i - 1, j, Palette(r)
                        End If
                    Next i
                Case 1
                    pr = 0
                    For i = 1 To FWidth
                        r = Scanline(i)
                        r = (r + pr) Mod 256
                        If r < 0 Then r = 0
                        Scanline(i) = r
                        pr = r
                        If Transparent Then
                            SetPixelA3 theHdc, i - 1, j, Palette(r), PaletteTrans(r)
                        Else
                            SetPixel theHdc, i - 1, j, Palette(r)
                        End If
                    Next i
                Case 2
                    For i = 1 To FWidth
                        r = Scanline(i)
                        ar = Scanline2(i)
                        r = (r + ar) Mod 256
                        Scanline(i) = r
                        If Transparent Then
                            SetPixelA3 theHdc, i - 1, j, Palette(r), PaletteTrans(r)
                        Else
                            SetPixel theHdc, i - 1, j, Palette(r)
                        End If
                    Next i
                Case 3
                    pr = 0
                    For i = 1 To FWidth
                        r = Scanline(i)
                        ar = Scanline2(i)
                        r = (r + (ar + pr) \ 2) Mod 256
                        Scanline(i) = r
                        pr = r
                        If Transparent Then
                            SetPixelA3 theHdc, i - 1, j, Palette(r), PaletteTrans(r)
                        Else
                            SetPixel theHdc, i - 1, j, Palette(r)
                        End If
                    Next i
                Case 4
                    xr = 0: pr = 0
                    For i = 1 To FWidth
                        r = Scanline(i)
                        ar = Scanline2(i)
                        xr = Scanline2(i - 1)
                        If i = 1 Then xr = 0
                        r = (r + PaethPredictor(pr, ar, xr)) Mod 256
                        Scanline(i) = r
                        pr = r
                        If Transparent Then
                            SetPixelA3 theHdc, i - 1, j, Palette(r), PaletteTrans(r)
                        Else
                            SetPixel theHdc, i - 1, j, Palette(r)
                        End If
                    Next i
                End Select
                If j Mod 16 = 0 Then FObject.Refresh
                Scanline2 = Scanline
            Next j
            Erase OutStr
            Erase Scanline
            Erase Scanline2
        Case 2                         'The Image is 24-bit [3 channels]
            'Start Inflating
            j = FWidth * FHeight * 3 * BitReduction + FHeight
            ReDim OutStr(0 To j - 1) As Byte
            i = uncompress(OutStr(0), j, Stream, Len(Stream))
            If i Then
                MsgBox "File may be corrupted! The DLL returned: " + Str(i), vbCritical, "Error"
                Close #1
                Exit Sub
            End If
            Stream = ""     'free up some memory
            ReDim Scanline2(0 To FWidth * 3) As Byte
            ReDim Scanline(0 To FWidth * 3) As Byte
            Inc = 0
            For j = 0 To FHeight - 1
                If Bpp = 8 Then
                    For i = 0 To FWidth * 3
                        Scanline(i) = OutStr(i + Inc)
                    Next i
                    Inc = Inc + FWidth * 3 + 1
                ElseIf Bpp = 16 Then
                    Scanline(0) = OutStr(Inc)
                    For i = 0 To FWidth * 3 - 1
                        Scanline(i + 1) = OutStr(i * 2 + 1 + Inc)
                    Next i
                    Inc = Inc + FWidth * 6 + 1
                End If

                k = Scanline(0)
                Select Case k
                Case 0
                    For i = 0 To FWidth - 1
                        r = Scanline(i * 3 + 1)
                        g = Scanline(i * 3 + 2)
                        b = Scanline(i * 3 + 3)
                        SetPixel theHdc, i, j, RGB(r, g, b)
                    Next i
                Case 1
                    pr = 0: pg = 0: pb = 0
                    For i = 0 To FWidth - 1
                        r = Scanline(i * 3 + 1)
                        g = Scanline(i * 3 + 2)
                        b = Scanline(i * 3 + 3)
                        r = (r + pr) Mod 256: g = (g + pg) Mod 256: b = (b + pb) Mod 256
                        If r < 0 Then r = 0: If g < 0 Then g = 0: If b < 0 Then b = 0
                        Scanline(i * 3 + 1) = r
                        Scanline(i * 3 + 2) = g
                        Scanline(i * 3 + 3) = b
                        pr = r: pg = g: pb = b
                        SetPixel theHdc, i, j, RGB(r, g, b)
                    Next i
                Case 2
                    For i = 0 To FWidth - 1
                        r = Scanline(i * 3 + 1)
                        g = Scanline(i * 3 + 2)
                        b = Scanline(i * 3 + 3)
                        ar = Scanline2(i * 3 + 1)
                        ag = Scanline2(i * 3 + 2)
                        ab = Scanline2(i * 3 + 3)
                        r = (r + ar) Mod 256: g = (g + ag) Mod 256: b = (b + ab) Mod 256
                        Scanline(i * 3 + 1) = r
                        Scanline(i * 3 + 2) = g
                        Scanline(i * 3 + 3) = b
                        SetPixel theHdc, i, j, RGB(r, g, b)
                    Next i
                Case 3
                    pr = 0: pg = 0: pb = 0
                    For i = 0 To FWidth - 1
                        r = Scanline(i * 3 + 1)
                        g = Scanline(i * 3 + 2)
                        b = Scanline(i * 3 + 3)
                        ar = Scanline2(i * 3 + 1)
                        ag = Scanline2(i * 3 + 2)
                        ab = Scanline2(i * 3 + 3)
                        r = (r + (ar + pr) \ 2) Mod 256
                        g = (g + (ag + pg) \ 2) Mod 256
                        b = (b + (ab + pb) \ 2) Mod 256
                        Scanline(i * 3 + 1) = r
                        Scanline(i * 3 + 2) = g
                        Scanline(i * 3 + 3) = b
                        pr = r: pg = g: pb = b
                        SetPixel theHdc, i, j, RGB(r, g, b)
                    Next i
                Case 4
                    pr = 0: pg = 0: pb = 0
                    xr = 0: xg = 0: xb = 0
                    For i = 0 To FWidth - 1
                        r = Scanline(i * 3 + 1)
                        g = Scanline(i * 3 + 2)
                        b = Scanline(i * 3 + 3)
                        ar = Scanline2(i * 3 + 1)
                        ag = Scanline2(i * 3 + 2)
                        ab = Scanline2(i * 3 + 3)
                        If i > 0 Then
                            xr = Scanline2((i - 1) * 3 + 1)
                            xg = Scanline2((i - 1) * 3 + 2)
                            xb = Scanline2((i - 1) * 3 + 3)
                        End If
                        r = (r + PaethPredictor(pr, ar, xr)) Mod 256
                        g = (g + PaethPredictor(pg, ag, xg)) Mod 256
                        b = (b + PaethPredictor(pb, ab, xb)) Mod 256
                        Scanline(i * 3 + 1) = r
                        Scanline(i * 3 + 2) = g
                        Scanline(i * 3 + 3) = b
                        pr = r: pg = g: pb = b
                        SetPixel theHdc, i, j, RGB(r, g, b)
                    Next i
                End Select
                If j Mod 16 = 0 Then FObject.Refresh
                Scanline2 = Scanline
            Next j
            Erase OutStr
            Erase Scanline
            Erase Scanline2
        Case 4                  'Greyscale plus aplha [2 channels]
            'Start Inflating
            j = FWidth * FHeight * 2 * BitReduction + FHeight
            ReDim OutStr(0 To j - 1) As Byte
            i = uncompress(OutStr(0), j, Stream, Len(Stream))
            If i Then
                MsgBox "File may be corrupted! The DLL returned: " + Str(i), vbCritical, "Error"
                Close #1
                Exit Sub
            End If
            Stream = ""     'free up some memory
            ReDim Scanline2(0 To FWidth * 2) As Byte
            ReDim Scanline(0 To FWidth * 2) As Byte
            Inc = 0
            For j = 0 To FHeight - 1
                If Bpp = 8 Then
                    For i = 0 To FWidth * 2
                        Scanline(i) = OutStr(i + Inc)
                    Next i
                    Inc = Inc + FWidth * 2 + 1
                ElseIf Bpp = 16 Then
                    Scanline(0) = OutStr(Inc)
                    For i = 0 To FWidth * 2 - 1
                        Scanline(i + 1) = OutStr(i * 2 + 1 + Inc)
                    Next i
                    Inc = Inc + FWidth * 4 + 1
                End If
                k = Scanline(0)
                Select Case k
                Case 0
                    For i = 0 To FWidth - 1
                        r = Scanline(i * 2 + 1)
                        a = Scanline(i * 2 + 2)
                        SetPixelA theHdc, i, j, r, r, r, a
                    Next i
                Case 1
                    pr = 0: pa = 0
                    For i = 0 To FWidth - 1
                        r = Scanline(i * 2 + 1)
                        a = Scanline(i * 2 + 2)
                        r = (r + pr) Mod 256
                        a = (a + pa) Mod 256
                        If r < 0 Then r = 0
                        If a < 0 Then a = 0
                        Scanline(i * 2 + 1) = r
                        Scanline(i * 2 + 2) = a
                        pr = r: pa = a
                        SetPixelA theHdc, i, j, r, r, r, a
                    Next i
                Case 2
                    For i = 0 To FWidth - 1
                        r = Scanline(i * 2 + 1)
                        a = Scanline(i * 2 + 2)
                        ar = Scanline2(i * 2 + 1)
                        aa = Scanline2(i * 2 + 2)
                        r = (r + ar) Mod 256
                        a = (a + aa) Mod 256
                        Scanline(i * 2 + 1) = r
                        Scanline(i * 2 + 2) = a
                        SetPixelA theHdc, i, j, r, r, r, a
                    Next i
                Case 3
                    pr = 0: pa = 0
                    For i = 0 To FWidth - 1
                        r = Scanline(i * 2 + 1)
                        a = Scanline(i * 2 + 2)
                        ar = Scanline2(i * 2 + 1)
                        aa = Scanline2(i * 2 + 2)
                        r = (r + (ar + pr) \ 2) Mod 256
                        a = (a + (aa + pa) \ 2) Mod 256
                        Scanline(i * 2 + 1) = r
                        Scanline(i * 2 + 2) = a
                        pr = r: pa = a
                        SetPixelA theHdc, i, j, r, r, r, a
                    Next i
                Case 4
                    pr = 0: xr = 0: pa = 0: xa = 0
                    For i = 0 To FWidth - 1
                        r = Scanline(i * 2 + 1)
                        a = Scanline(i * 2 + 2)
                        ar = Scanline2(i * 2 + 1)
                        aa = Scanline2(i * 2 + 2)
                        If i > 0 Then
                            xr = Scanline2((i - 1) * 2 + 1)
                            xa = Scanline2((i - 1) * 2 + 2)
                        End If
                        r = (r + PaethPredictor(pr, ar, xr)) Mod 256
                        a = (a + PaethPredictor(pa, aa, xa)) Mod 256
                        Scanline(i * 2 + 1) = r
                        Scanline(i * 2 + 2) = a
                        pr = r: pa = a
                        SetPixelA theHdc, i, j, r, r, r, a
                    Next i
                End Select
                If j Mod 16 = 0 Then FObject.Refresh
                Scanline2 = Scanline
            Next j
            Erase OutStr
            Erase Scanline
            Erase Scanline2
        Case 6                      'The Image is 32-bit [4 channels]
            'Start Inflating        'We will simply ignore the alpha channel
            j = FWidth * FHeight * 4 * BitReduction + FHeight
            ReDim OutStr(0 To j - 1) As Byte
            i = uncompress(OutStr(0), j, Stream, Len(Stream))
            If i Then
                MsgBox "File may be corrupted! The DLL returned: " + Str(i), vbCritical, "Error"
                Close #1
                Exit Sub
            End If
            Stream = ""     'free up some memory
            ReDim Scanline2(0 To FWidth * 4) As Byte
            ReDim Scanline(0 To FWidth * 4) As Byte
            Inc = 0
            For j = 0 To FHeight - 1
                If Bpp = 8 Then
                    For i = 0 To FWidth * 4
                        Scanline(i) = OutStr(i + Inc)
                    Next i
                    Inc = Inc + FWidth * 4 + 1
                ElseIf Bpp = 16 Then
                    Scanline(0) = OutStr(Inc)
                    For i = 0 To FWidth * 4 - 1
                        Scanline(i + 1) = OutStr(i * 2 + 1 + Inc)
                    Next i
                    Inc = Inc + FWidth * 8 + 1
                End If
                k = Scanline(0)  'get filtering method
                Select Case k
                Case 0                      'no filter
                    For i = 0 To FWidth - 1
                        r = Scanline(i * 4 + 1)
                        g = Scanline(i * 4 + 2)
                        b = Scanline(i * 4 + 3)
                        a = Scanline(i * 4 + 4)
                        SetPixelA theHdc, i, j, r, g, b, a
                    Next i
                Case 1                      'Left filter
                    pr = 0: pg = 0: pb = 0: pa = 0
                    For i = 0 To FWidth - 1
                        r = Scanline(i * 4 + 1)
                        g = Scanline(i * 4 + 2)
                        b = Scanline(i * 4 + 3)
                        a = Scanline(i * 4 + 4)
                        r = (r + pr) Mod 256
                        g = (g + pg) Mod 256
                        b = (b + pb) Mod 256
                        a = (a + pa) Mod 256
                        If r < 0 Then r = 0
                        If g < 0 Then g = 0
                        If b < 0 Then b = 0
                        If a < 0 Then a = 0
                        Scanline(i * 4 + 1) = r
                        Scanline(i * 4 + 2) = g
                        Scanline(i * 4 + 3) = b
                        Scanline(i * 4 + 4) = a
                        pr = r: pg = g: pb = b: pa = a
                        SetPixelA theHdc, i, j, r, g, b, a
                    Next i
                Case 2                      'Up filter
                    For i = 0 To FWidth - 1
                        r = Scanline(i * 4 + 1)
                        g = Scanline(i * 4 + 2)
                        b = Scanline(i * 4 + 3)
                        a = Scanline(i * 4 + 4)
                        ar = Scanline2(i * 4 + 1)
                        ag = Scanline2(i * 4 + 2)
                        ab = Scanline2(i * 4 + 3)
                        aa = Scanline2(i * 4 + 4)
                        r = (r + ar) Mod 256
                        g = (g + ag) Mod 256
                        b = (b + ab) Mod 256
                        a = (a + aa) Mod 256
                        Scanline(i * 4 + 1) = r
                        Scanline(i * 4 + 2) = g
                        Scanline(i * 4 + 3) = b
                        Scanline(i * 4 + 4) = a
                        SetPixelA theHdc, i, j, r, g, b, a
                    Next i
                Case 3                      'Average filter
                    pr = 0: pg = 0: pb = 0: pa = 0
                    For i = 0 To FWidth - 1
                        r = Scanline(i * 4 + 1)
                        g = Scanline(i * 4 + 2)
                        b = Scanline(i * 4 + 3)
                        a = Scanline(i * 4 + 4)
                        ar = Scanline2(i * 4 + 1)
                        ag = Scanline2(i * 4 + 2)
                        ab = Scanline2(i * 4 + 3)
                        aa = Scanline2(i * 4 + 4)
                        r = (r + (ar + pr) \ 2) Mod 256
                        g = (g + (ag + pg) \ 2) Mod 256
                        b = (b + (ab + pb) \ 2) Mod 256
                        a = (a + (aa + pa) \ 2) Mod 256
                        Scanline(i * 4 + 1) = r
                        Scanline(i * 4 + 2) = g
                        Scanline(i * 4 + 3) = b
                        Scanline(i * 4 + 4) = a
                        pr = r: pg = g: pb = b: pa = a
                        SetPixelA theHdc, i, j, r, g, b, a
                    Next i
                Case 4                      'Paeth filter
                    pr = 0: pg = 0: pb = 0: pa = 0
                    xr = 0: xg = 0: xb = 0: xa = 0
                    For i = 0 To FWidth - 1
                        r = Scanline(i * 4 + 1)
                        g = Scanline(i * 4 + 2)
                        b = Scanline(i * 4 + 3)
                        a = Scanline(i * 4 + 4)
                        ar = Scanline2(i * 4 + 1)
                        ag = Scanline2(i * 4 + 2)
                        ab = Scanline2(i * 4 + 3)
                        aa = Scanline2(i * 4 + 4)
                        If i > 0 Then
                            xr = Scanline2((i - 1) * 4 + 1)
                            xg = Scanline2((i - 1) * 4 + 2)
                            xb = Scanline2((i - 1) * 4 + 3)
                            xa = Scanline2((i - 1) * 4 + 4)
                        End If
                        r = (r + PaethPredictor(pr, ar, xr)) Mod 256
                        g = (g + PaethPredictor(pg, ag, xg)) Mod 256
                        b = (b + PaethPredictor(pb, ab, xb)) Mod 256
                        a = (a + PaethPredictor(pa, aa, xa)) Mod 256
                        Scanline(i * 4 + 1) = r
                        Scanline(i * 4 + 2) = g
                        Scanline(i * 4 + 3) = b
                        Scanline(i * 4 + 4) = a
                        pr = r: pg = g: pb = b: pa = a
                        SetPixelA theHdc, i, j, r, g, b, a
                    Next i
                End Select
                If j Mod 16 = 0 Then FObject.Refresh
                Scanline2 = Scanline
            Next j
            Erase OutStr
            Erase Scanline
            Erase Scanline2
        End Select
    Else        'Adam7 interlacing
        Select Case ColorType
        Case 0, 3
            j = FWidth * FHeight * BitReduction + FHeight * 15 / 8 + 16
        Case 2
            j = FWidth * FHeight * 3 * BitReduction + FHeight * 15 / 8 + 16
        Case 4
            j = FWidth * FHeight * 2 * BitReduction + FHeight * 15 / 8 + 16
        Case 6
            j = FWidth * FHeight * 4 * BitReduction + FHeight * 15 / 8 + 16
        End Select
        
        'Inflate
        ReDim OutStr(0 To j - 1) As Byte
        i = uncompress(OutStr(0), j, Stream, Len(Stream))
        If i Then
            MsgBox "File may be corrupted! The DLL returned: " + Str(i), vbCritical, "Error"
            Close #1
            Exit Sub
        End If
        Stream = ""     'free up some memory
        
        Inc2 = 0
        
        Select Case ColorType
        Case 0                  'The Image is grayscale [1 channel]

            For n = 1 To 7
                Select Case n
                Case 1
                    IWidth = FWidth \ 8: If FWidth Mod 8 > 0 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 8: If FHeight Mod 8 > 0 Then IHeight = IHeight + 1
                Case 2
                    IWidth = FWidth \ 8: If FWidth Mod 8 > 4 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 8: If FHeight Mod 8 > 0 Then IHeight = IHeight + 1
                Case 3
                    IWidth = FWidth \ 4: If FWidth Mod 4 > 0 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 8: If FHeight Mod 8 > 4 Then IHeight = IHeight + 1
                Case 4
                    IWidth = FWidth \ 4: If FWidth Mod 4 > 2 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 4: If FHeight Mod 4 > 0 Then IHeight = IHeight + 1
                Case 5
                    IWidth = FWidth \ 2: If FWidth Mod 2 > 0 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 4: If FHeight Mod 4 > 2 Then IHeight = IHeight + 1
                Case 6
                    IWidth = FWidth \ 2
                    IHeight = FHeight \ 2: If FHeight Mod 2 > 0 Then IHeight = IHeight + 1
                Case 7
                    IWidth = FWidth
                    IHeight = FHeight \ 2
                End Select
                
                ReDim Scanline2(0 To IWidth) As Byte
                ReDim Scanline(0 To IWidth) As Byte
                Inc = 0
                For j = 0 To IHeight - 1
                    If Bpp = 8 Then
                        For i = 0 To IWidth
                            Scanline(i) = OutStr(i + Inc + Inc2)
                        Next i
                        Inc = Inc + IWidth + 1
                    ElseIf Bpp = 16 Then
                        Scanline(0) = OutStr(Inc + Inc2)
                        For i = 0 To IWidth - 1
                            Scanline(i + 1) = OutStr(i * 2 + 1 + Inc + Inc2)
                        Next i
                        Inc = Inc + IWidth * 2 + 1
                    End If

                    k = Scanline(0)
                    Select Case k
                    Case 0
                        For i = 1 To IWidth
                            r = Scanline(i)
                            SetPixelP theHdc, n, i - 1, j, RGB(r, r, r)
                        Next i
                    Case 1
                        pr = 0
                        For i = 1 To IWidth
                            r = Scanline(i)
                            r = (r + pr) Mod 256
                            If r < 0 Then r = 0
                            Scanline(i) = r
                            pr = r
                            SetPixelP theHdc, n, i - 1, j, RGB(r, r, r)
                        Next i
                    Case 2
                        For i = 1 To IWidth
                            r = Scanline(i)
                            ar = Scanline2(i)
                            r = (r + ar) Mod 256
                            Scanline(i) = r
                            SetPixelP theHdc, n, i - 1, j, RGB(r, r, r)
                        Next i
                    Case 3
                        pr = 0
                        For i = 1 To IWidth
                            r = Scanline(i)
                            ar = Scanline2(i)
                            r = (r + (ar + pr) \ 2) Mod 256
                            Scanline(i) = r
                            pr = r
                            SetPixelP theHdc, n, i - 1, j, RGB(r, r, r)
                        Next i
                    Case 4
                        xr = 0: pr = 0
                        For i = 1 To IWidth
                            r = Scanline(i)
                            ar = Scanline2(i)
                            xr = Scanline2(i - 1)
                            If i = 1 Then xr = 0
                            r = (r + PaethPredictor(pr, ar, xr)) Mod 256
                            Scanline(i) = r
                            pr = r
                            SetPixelP theHdc, n, i - 1, j, RGB(r, r, r)
                        Next i
                    End Select
                    If j Mod 16 = 0 Then FObject.Refresh
                    Scanline2 = Scanline
                Next j
                Inc2 = Inc2 + IWidth * IHeight * BitReduction + IHeight
            Next n
        Case 3                  'The Image is 8-bit [1 channel]
            For n = 1 To 7
                'MsgBox "Pass complete."
                Select Case n
                Case 1
                    IWidth = FWidth \ 8: If FWidth Mod 8 > 0 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 8: If FHeight Mod 8 > 0 Then IHeight = IHeight + 1
                Case 2
                    IWidth = FWidth \ 8: If FWidth Mod 8 > 4 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 8: If FHeight Mod 8 > 0 Then IHeight = IHeight + 1
                Case 3
                    IWidth = FWidth \ 4: If FWidth Mod 4 > 0 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 8: If FHeight Mod 8 > 4 Then IHeight = IHeight + 1
                Case 4
                    IWidth = FWidth \ 4: If FWidth Mod 4 > 2 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 4: If FHeight Mod 4 > 0 Then IHeight = IHeight + 1
                Case 5
                    IWidth = FWidth \ 2: If FWidth Mod 2 > 0 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 4: If FHeight Mod 4 > 2 Then IHeight = IHeight + 1
                Case 6
                    IWidth = FWidth \ 2
                    IHeight = FHeight \ 2: If FHeight Mod 2 > 0 Then IHeight = IHeight + 1
                Case 7
                    IWidth = FWidth
                    IHeight = FHeight \ 2
                End Select

                ReDim Scanline2(0 To IWidth) As Byte
                ReDim Scanline(0 To IWidth) As Byte
                Inc = 0
                For j = 0 To IHeight - 1
                    If Bpp = 8 Then
                        For i = 0 To IWidth
                            Scanline(i) = OutStr(i + Inc + Inc2)
                        Next i
                        Inc = Inc + IWidth + 1
                    ElseIf Bpp = 16 Then
                        Scanline(0) = OutStr(Inc + Inc2)
                        For i = 0 To IWidth - 1
                            Scanline(i + 1) = OutStr(i * 2 + 1 + Inc + Inc2)
                        Next i
                        Inc = Inc + IWidth * 2 + 1
                    End If
                    k = Scanline(0)
                    Select Case k
                    Case 0
                        For i = 1 To IWidth
                            r = Scanline(i)
                            If Transparent Then
                                SetPixelA3P theHdc, n, i - 1, j, Palette(r), PaletteTrans(r)
                            Else
                                SetPixelP theHdc, n, i - 1, j, Palette(r)
                            End If
                        Next i
                    Case 1
                        pr = 0
                        For i = 1 To IWidth
                            r = Scanline(i)
                            r = (r + pr) Mod 256
                            If r < 0 Then r = 0
                            Scanline(i) = r
                            pr = r
                            If Transparent Then
                                SetPixelA3P theHdc, n, i - 1, j, Palette(r), PaletteTrans(r)
                            Else
                                SetPixelP theHdc, n, i - 1, j, Palette(r)
                            End If
                        Next i
                    Case 2
                        For i = 1 To IWidth
                            r = Scanline(i)
                            ar = Scanline2(i)
                            r = (r + ar) Mod 256
                            Scanline(i) = r
                            If Transparent Then
                                SetPixelA3P theHdc, n, i - 1, j, Palette(r), PaletteTrans(r)
                            Else
                                SetPixelP theHdc, n, i - 1, j, Palette(r)
                            End If
                        Next i
                    Case 3
                        pr = 0
                        For i = 1 To IWidth
                            r = Scanline(i)
                            ar = Scanline2(i)
                            r = (r + (ar + pr) \ 2) Mod 256
                            Scanline(i) = r
                            pr = r
                            If Transparent Then
                                SetPixelA3P theHdc, n, i - 1, j, Palette(r), PaletteTrans(r)
                            Else
                                SetPixelP theHdc, n, i - 1, j, Palette(r)
                            End If
                        Next i
                    Case 4
                        xr = 0: pr = 0
                        For i = 1 To IWidth
                            r = Scanline(i)
                            ar = Scanline2(i)
                            xr = Scanline2(i - 1)
                            If i = 1 Then xr = 0
                            r = (r + PaethPredictor(pr, ar, xr)) Mod 256
                            Scanline(i) = r
                            pr = r
                            If Transparent Then
                                SetPixelA3P theHdc, n, i - 1, j, Palette(r), PaletteTrans(r)
                            Else
                                SetPixelP theHdc, n, i - 1, j, Palette(r)
                            End If
                        Next i
                    End Select
                    If j Mod 16 = 0 Then FObject.Refresh
                    Scanline2 = Scanline
                Next j
                Inc2 = Inc2 + IWidth * IHeight * BitReduction + IHeight
            Next n
        Case 2                         'The Image is 24-bit [3 channels]
            For n = 1 To 7
                Select Case n
                Case 1
                    IWidth = FWidth \ 8: If FWidth Mod 8 > 0 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 8: If FHeight Mod 8 > 0 Then IHeight = IHeight + 1
                Case 2
                    IWidth = FWidth \ 8: If FWidth Mod 8 > 4 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 8: If FHeight Mod 8 > 0 Then IHeight = IHeight + 1
                Case 3
                    IWidth = FWidth \ 4: If FWidth Mod 4 > 0 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 8: If FHeight Mod 8 > 4 Then IHeight = IHeight + 1
                Case 4
                    IWidth = FWidth \ 4: If FWidth Mod 4 > 2 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 4: If FHeight Mod 4 > 0 Then IHeight = IHeight + 1
                Case 5
                    IWidth = FWidth \ 2: If FWidth Mod 2 > 0 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 4: If FHeight Mod 4 > 2 Then IHeight = IHeight + 1
                Case 6
                    IWidth = FWidth \ 2
                    IHeight = FHeight \ 2: If FHeight Mod 2 > 0 Then IHeight = IHeight + 1
                Case 7
                    IWidth = FWidth
                    IHeight = FHeight \ 2
                End Select

                ReDim Scanline2(0 To IWidth * 3) As Byte
                ReDim Scanline(0 To IWidth * 3) As Byte
                Inc = 0
                For j = 0 To IHeight - 1
                    If Bpp = 8 Then
                        For i = 0 To IWidth * 3
                            Scanline(i) = OutStr(i + Inc + Inc2)
                        Next i
                        Inc = Inc + IWidth * 3 + 1
                    ElseIf Bpp = 16 Then
                        Scanline(0) = OutStr(Inc + Inc2)
                        For i = 0 To IWidth * 3 - 1
                            Scanline(i + 1) = OutStr(i * 2 + 1 + Inc + Inc2)
                        Next i
                        Inc = Inc + IWidth * 6 + 1
                    End If
                    
                    k = Scanline(0)
                    Select Case k
                    Case 0
                        For i = 0 To IWidth - 1
                            r = Scanline(i * 3 + 1)
                            g = Scanline(i * 3 + 2)
                            b = Scanline(i * 3 + 3)
                            SetPixelP theHdc, n, i, j, RGB(r, g, b)
                        Next i
                    Case 1
                        pr = 0: pg = 0: pb = 0
                        For i = 0 To IWidth - 1
                            r = Scanline(i * 3 + 1)
                            g = Scanline(i * 3 + 2)
                            b = Scanline(i * 3 + 3)
                            r = (r + pr) Mod 256
                            g = (g + pg) Mod 256
                            b = (b + pb) Mod 256
                            If r < 0 Then r = 0
                            If g < 0 Then g = 0
                            If b < 0 Then b = 0
                            Scanline(i * 3 + 1) = r
                            Scanline(i * 3 + 2) = g
                            Scanline(i * 3 + 3) = b
                            pr = r: pg = g: pb = b
                            SetPixelP theHdc, n, i, j, RGB(r, g, b)
                        Next i
                    Case 2
                        For i = 0 To IWidth - 1
                            r = Scanline(i * 3 + 1)
                            g = Scanline(i * 3 + 2)
                            b = Scanline(i * 3 + 3)
                            ar = Scanline2(i * 3 + 1)
                            ag = Scanline2(i * 3 + 2)
                            ab = Scanline2(i * 3 + 3)
                            r = (r + ar) Mod 256
                            g = (g + ag) Mod 256
                            b = (b + ab) Mod 256
                            Scanline(i * 3 + 1) = r
                            Scanline(i * 3 + 2) = g
                            Scanline(i * 3 + 3) = b
                            SetPixelP theHdc, n, i, j, RGB(r, g, b)
                        Next i
                    Case 3
                        pr = 0: pg = 0: pb = 0
                        For i = 0 To IWidth - 1
                            r = Scanline(i * 3 + 1)
                            g = Scanline(i * 3 + 2)
                            b = Scanline(i * 3 + 3)
                            ar = Scanline2(i * 3 + 1)
                            ag = Scanline2(i * 3 + 2)
                            ab = Scanline2(i * 3 + 3)
                            r = (r + (ar + pr) \ 2) Mod 256
                            g = (g + (ag + pg) \ 2) Mod 256
                            b = (b + (ab + pb) \ 2) Mod 256
                            Scanline(i * 3 + 1) = r
                            Scanline(i * 3 + 2) = g
                            Scanline(i * 3 + 3) = b
                            pr = r: pg = g: pb = b
                            SetPixelP theHdc, n, i, j, RGB(r, g, b)
                        Next i
                    Case 4
                        pr = 0: pg = 0: pb = 0
                        xr = 0: xg = 0: xb = 0
                        For i = 0 To IWidth - 1
                            r = Scanline(i * 3 + 1)
                            g = Scanline(i * 3 + 2)
                            b = Scanline(i * 3 + 3)
                            ar = Scanline2(i * 3 + 1)
                            ag = Scanline2(i * 3 + 2)
                            ab = Scanline2(i * 3 + 3)
                            If i > 0 Then
                                xr = Scanline2((i - 1) * 3 + 1)
                                xg = Scanline2((i - 1) * 3 + 2)
                                xb = Scanline2((i - 1) * 3 + 3)
                            End If
                            r = (r + PaethPredictor(pr, ar, xr)) Mod 256
                            g = (g + PaethPredictor(pg, ag, xg)) Mod 256
                            b = (b + PaethPredictor(pb, ab, xb)) Mod 256
                            Scanline(i * 3 + 1) = r
                            Scanline(i * 3 + 2) = g
                            Scanline(i * 3 + 3) = b
                            pr = r: pg = g: pb = b
                            SetPixelP theHdc, n, i, j, RGB(r, g, b)
                        Next i
                    End Select
                    If j Mod 16 = 0 Then FObject.Refresh
                    Scanline2 = Scanline
                Next j
                Inc2 = Inc2 + IWidth * IHeight * 3 * BitReduction + IHeight
            Next n
        Case 4                 'Greyscale plus alpha [2 channels]
            For n = 1 To 7
                Select Case n
                Case 1
                    IWidth = FWidth \ 8: If FWidth Mod 8 > 0 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 8: If FHeight Mod 8 > 0 Then IHeight = IHeight + 1
                Case 2
                    IWidth = FWidth \ 8: If FWidth Mod 8 > 4 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 8: If FHeight Mod 8 > 0 Then IHeight = IHeight + 1
                Case 3
                    IWidth = FWidth \ 4: If FWidth Mod 4 > 0 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 8: If FHeight Mod 8 > 4 Then IHeight = IHeight + 1
                Case 4
                    IWidth = FWidth \ 4: If FWidth Mod 4 > 2 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 4: If FHeight Mod 4 > 0 Then IHeight = IHeight + 1
                Case 5
                    IWidth = FWidth \ 2: If FWidth Mod 2 > 0 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 4: If FHeight Mod 4 > 2 Then IHeight = IHeight + 1
                Case 6
                    IWidth = FWidth \ 2
                    IHeight = FHeight \ 2: If FHeight Mod 2 > 0 Then IHeight = IHeight + 1
                Case 7
                    IWidth = FWidth
                    IHeight = FHeight \ 2
                End Select
                
                ReDim Scanline2(0 To IWidth * 2) As Byte
                ReDim Scanline(0 To IWidth * 2) As Byte
                Inc = 0
                For j = 0 To IHeight - 1
                    If Bpp = 8 Then
                        For i = 0 To IWidth * 2
                            Scanline(i) = OutStr(i + Inc + Inc2)
                        Next i
                        Inc = Inc + IWidth * 2 + 1
                    ElseIf Bpp = 16 Then
                        Scanline(0) = OutStr(Inc + Inc2)
                        For i = 0 To IWidth * 2 - 1
                            Scanline(i + 1) = OutStr(i * 2 + 1 + Inc + Inc2)
                        Next i
                        Inc = Inc + IWidth * 4 + 1
                    End If
                    k = Scanline(0)
                    Select Case k
                    Case 0
                        For i = 0 To IWidth - 1
                            r = Scanline(i * 2 + 1)
                            a = Scanline(i * 2 + 2)
                            SetPixelAP theHdc, n, i, j, r, r, r, a
                        Next i
                    Case 1
                        pr = 0: pa = 0
                        For i = 0 To IWidth - 1
                            r = Scanline(i * 2 + 1)
                            a = Scanline(i * 2 + 2)
                            r = (r + pr) Mod 256
                            a = (a + pa) Mod 256
                            If r < 0 Then r = 0
                            If a < 0 Then a = 0
                            Scanline(i * 2 + 1) = r
                            Scanline(i * 2 + 2) = a
                            pr = r: pa = a
                            SetPixelAP theHdc, n, i, j, r, r, r, a
                        Next i
                    Case 2
                        For i = 0 To IWidth - 1
                            r = Scanline(i * 2 + 1)
                            a = Scanline(i * 2 + 2)
                            ar = Scanline2(i * 2 + 1)
                            aa = Scanline2(i * 2 + 2)
                            r = (r + ar) Mod 256
                            a = (a + aa) Mod 256
                            Scanline(i * 2 + 1) = r
                            Scanline(i * 2 + 2) = a
                            SetPixelAP theHdc, n, i, j, r, r, r, a
                        Next i
                    Case 3
                        pr = 0: pa = 0
                        For i = 0 To IWidth - 1
                            r = Scanline(i * 2 + 1)
                            a = Scanline(i * 2 + 2)
                            ar = Scanline2(i * 2 + 1)
                            aa = Scanline2(i * 2 + 2)
                            r = (r + (ar + pr) \ 2) Mod 256
                            a = (a + (aa + pa) \ 2) Mod 256
                            Scanline(i * 2 + 1) = r
                            Scanline(i * 2 + 2) = a
                            pr = r: pa = a
                            SetPixelAP theHdc, n, i, j, r, r, r, a
                        Next i
                    Case 4
                        pr = 0: xr = 0: pa = 0: xa = 0
                        For i = 0 To IWidth - 1
                            r = Scanline(i * 2 + 1)
                            a = Scanline(i * 2 + 2)
                            ar = Scanline2(i * 2 + 1)
                            aa = Scanline2(i * 2 + 2)
                            If i > 0 Then
                                xr = Scanline2((i - 1) * 2 + 1)
                                xa = Scanline2((i - 1) * 2 + 2)
                            End If
                            r = (r + PaethPredictor(pr, ar, xr)) Mod 256
                            a = (a + PaethPredictor(pa, aa, xa)) Mod 256
                            Scanline(i * 2 + 1) = r
                            Scanline(i * 2 + 2) = a
                            pr = r: pa = a
                            SetPixelAP theHdc, n, i, j, r, r, r, a
                        Next i
                    End Select
                    If j Mod 16 = 0 Then FObject.Refresh
                    Scanline2 = Scanline
                Next j
                Inc2 = Inc2 + IWidth * IHeight * 2 * BitReduction + IHeight
            Next n
        Case 6                      'The Image is 32-bit [4 channels]
            For n = 1 To 7
                Select Case n
                Case 1
                    IWidth = FWidth \ 8: If FWidth Mod 8 > 0 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 8: If FHeight Mod 8 > 0 Then IHeight = IHeight + 1
                Case 2
                    IWidth = FWidth \ 8: If FWidth Mod 8 > 4 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 8: If FHeight Mod 8 > 0 Then IHeight = IHeight + 1
                Case 3
                    IWidth = FWidth \ 4: If FWidth Mod 4 > 0 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 8: If FHeight Mod 8 > 4 Then IHeight = IHeight + 1
                Case 4
                    IWidth = FWidth \ 4: If FWidth Mod 4 > 2 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 4: If FHeight Mod 4 > 0 Then IHeight = IHeight + 1
                Case 5
                    IWidth = FWidth \ 2: If FWidth Mod 2 > 0 Then IWidth = IWidth + 1
                    IHeight = FHeight \ 4: If FHeight Mod 4 > 2 Then IHeight = IHeight + 1
                Case 6
                    IWidth = FWidth \ 2
                    IHeight = FHeight \ 2: If FHeight Mod 2 > 0 Then IHeight = IHeight + 1
                Case 7
                    IWidth = FWidth
                    IHeight = FHeight \ 2
                End Select

                ReDim Scanline2(0 To IWidth * 4) As Byte
                ReDim Scanline(0 To IWidth * 4) As Byte
                Inc = 0
                For j = 0 To IHeight - 1
                    If Bpp = 8 Then
                        For i = 0 To IWidth * 4
                            Scanline(i) = OutStr(i + Inc + Inc2)
                        Next i
                        Inc = Inc + IWidth * 4 + 1
                    ElseIf Bpp = 16 Then
                        Scanline(0) = OutStr(Inc + Inc2)
                        For i = 0 To IWidth * 4 - 1
                            Scanline(i + 1) = OutStr(i * 2 + 1 + Inc + Inc2)
                        Next i
                        Inc = Inc + IWidth * 8 + 1
                    End If
                    k = Scanline(0)
                    Select Case k
                    Case 0
                        For i = 0 To IWidth - 1
                            r = Scanline(i * 4 + 1)
                            g = Scanline(i * 4 + 2)
                            b = Scanline(i * 4 + 3)
                            a = Scanline(i * 4 + 4)
                            SetPixelAP theHdc, n, i, j, r, g, b, a
                        Next i
                    Case 1
                        pr = 0: pg = 0: pb = 0: pa = 0
                        For i = 0 To IWidth - 1
                            r = Scanline(i * 4 + 1)
                            g = Scanline(i * 4 + 2)
                            b = Scanline(i * 4 + 3)
                            a = Scanline(i * 4 + 4)
                            r = (r + pr) Mod 256
                            g = (g + pg) Mod 256
                            b = (b + pb) Mod 256
                            a = (a + pa) Mod 256
                            If r < 0 Then r = 0
                            If g < 0 Then g = 0
                            If b < 0 Then b = 0
                            If a < 0 Then a = 0
                            Scanline(i * 4 + 1) = r
                            Scanline(i * 4 + 2) = g
                            Scanline(i * 4 + 3) = b
                            Scanline(i * 4 + 4) = a
                            pr = r: pg = g: pb = b: pa = a
                            SetPixelAP theHdc, n, i, j, r, g, b, a
                        Next i
                    Case 2
                        For i = 0 To IWidth - 1
                            r = Scanline(i * 4 + 1)
                            g = Scanline(i * 4 + 2)
                            b = Scanline(i * 4 + 3)
                            a = Scanline(i * 4 + 4)
                            ar = Scanline2(i * 4 + 1)
                            ag = Scanline2(i * 4 + 2)
                            ab = Scanline2(i * 4 + 3)
                            aa = Scanline2(i * 4 + 4)
                            r = (r + ar) Mod 256
                            g = (g + ag) Mod 256
                            b = (b + ab) Mod 256
                            a = (a + aa) Mod 256
                            Scanline(i * 4 + 1) = r
                            Scanline(i * 4 + 2) = g
                            Scanline(i * 4 + 3) = b
                            Scanline(i * 4 + 4) = a
                            SetPixelAP theHdc, n, i, j, r, g, b, a
                        Next i
                    Case 3
                        pr = 0: pg = 0: pb = 0: pa = 0
                        For i = 0 To IWidth - 1
                            r = Scanline(i * 4 + 1)
                            g = Scanline(i * 4 + 2)
                            b = Scanline(i * 4 + 3)
                            a = Scanline(i * 4 + 4)
                            ar = Scanline2(i * 4 + 1)
                            ag = Scanline2(i * 4 + 2)
                            ab = Scanline2(i * 4 + 3)
                            aa = Scanline2(i * 4 + 4)
                            r = (r + (ar + pr) \ 2) Mod 256
                            g = (g + (ag + pg) \ 2) Mod 256
                            b = (b + (ab + pb) \ 2) Mod 256
                            a = (a + (aa + pa) \ 2) Mod 256
                            Scanline(i * 4 + 1) = r
                            Scanline(i * 4 + 2) = g
                            Scanline(i * 4 + 3) = b
                            Scanline(i * 4 + 4) = a
                            pr = r: pg = g: pb = b: pa = a
                            SetPixelAP theHdc, n, i, j, r, g, b, a
                        Next i
                    Case 4
                        pr = 0: pg = 0: pb = 0: pa = 0
                        xr = 0: xg = 0: xb = 0: xa = 0
                        For i = 0 To IWidth - 1
                            r = Scanline(i * 4 + 1)
                            g = Scanline(i * 4 + 2)
                            b = Scanline(i * 4 + 3)
                            a = Scanline(i * 4 + 4)
                            ar = Scanline2(i * 4 + 1)
                            ag = Scanline2(i * 4 + 2)
                            ab = Scanline2(i * 4 + 3)
                            aa = Scanline2(i * 4 + 4)
                            If i > 0 Then
                                xr = Scanline2((i - 1) * 4 + 1)
                                xg = Scanline2((i - 1) * 4 + 2)
                                xb = Scanline2((i - 1) * 4 + 3)
                                xa = Scanline2((i - 1) * 4 + 4)
                            End If
                            r = (r + PaethPredictor(pr, ar, xr)) Mod 256
                            g = (g + PaethPredictor(pg, ag, xg)) Mod 256
                            b = (b + PaethPredictor(pb, ab, xb)) Mod 256
                            a = (a + PaethPredictor(pa, aa, xa)) Mod 256
                            Scanline(i * 4 + 1) = r
                            Scanline(i * 4 + 2) = g
                            Scanline(i * 4 + 3) = b
                            Scanline(i * 4 + 4) = a
                            pr = r: pg = g: pb = b: pa = a
                            SetPixelAP theHdc, n, i, j, r, g, b, a
                        Next i
                    End Select
                    If j Mod 16 = 0 Then FObject.Refresh
                    Scanline2 = Scanline
                Next j
                Inc2 = Inc2 + IWidth * IHeight * 4 * BitReduction + IHeight
            Next n
        End Select
        Erase OutStr
        Erase Scanline
        Erase Scanline2
    End If
    Erase Palette
    Erase PaletteTrans

    'Done!!!!!!
ExitOut:
    Close #1
    Exit Sub
    
ErrorTrap:
    MsgBox "There was an error while reading the file: " + Err.Description, vbCritical, "Error"
    Resume ExitOut
End Sub

Function GetByte() As Integer
    Dim a As Byte
    Get #1, , a
    GetByte = a
End Function

Function GetWord() As Long
    Dim a As Byte
    Dim d As Long
    Get #1, , a: d = CLng(a) * 256
    Get #1, , a: d = d + CLng(a)
    GetWord = d
End Function

Function GetDword() As Long
    Dim a As Byte
    Dim d As Long
    Get #1, , a: d = CLng(a) * 16777216
    Get #1, , a: d = d + CLng(a) * 65536
    Get #1, , a: d = d + CLng(a) * 256
    Get #1, , a: d = d + CLng(a)
    GetDword = d
End Function

Function PaethPredictor(a As Integer, b As Integer, c As Integer) As Integer
    Dim p As Integer, pa As Integer, pb As Integer, pc As Integer
    'a = left, b = above, c = above left
    p = a + b - c
    pa = Abs(p - a)
    pb = Abs(p - b)
    pc = Abs(p - c)
    'straight from the pseudocode (optimizations?)
    If pa <= pb And pa <= pc Then
        PaethPredictor = a
    ElseIf pb <= pc Then
        PaethPredictor = b
    Else
        PaethPredictor = c
    End If
End Function

'Set a pixel in progressive mode
Sub SetPixelP(dc As Long, pass As Integer, x1 As Long, y1 As Long, Colour As Long)
    Select Case pass
    Case 1
        SetPixel dc, x1 * 8, y1 * 8, Colour
    Case 2
        SetPixel dc, x1 * 8 + 4, y1 * 8, Colour
    Case 3
        SetPixel dc, x1 * 4, y1 * 8 + 4, Colour
    Case 4
        SetPixel dc, x1 * 4 + 2, y1 * 4, Colour
    Case 5
        SetPixel dc, x1 * 2, y1 * 4 + 2, Colour
    Case 6
        SetPixel dc, x1 * 2 + 1, y1 * 2, Colour
    Case 7
        SetPixel dc, x1, y1 * 2 + 1, Colour
    End Select
End Sub

'Set an alpha-pixel in progressive mode
Sub SetPixelAP(dc As Long, pass As Integer, x1 As Long, y1 As Long, r1 As Integer, g1 As Integer, b1 As Integer, a1 As Integer)
    Select Case pass
    Case 1
        SetPixelA dc, x1 * 8, y1 * 8, r1, g1, b1, a1
    Case 2
        SetPixelA dc, x1 * 8 + 4, y1 * 8, r1, g1, b1, a1
    Case 3
        SetPixelA dc, x1 * 4, y1 * 8 + 4, r1, g1, b1, a1
    Case 4
        SetPixelA dc, x1 * 4 + 2, y1 * 4, r1, g1, b1, a1
    Case 5
        SetPixelA dc, x1 * 2, y1 * 4 + 2, r1, g1, b1, a1
    Case 6
        SetPixelA dc, x1 * 2 + 1, y1 * 2, r1, g1, b1, a1
    Case 7
        SetPixelA dc, x1, y1 * 2 + 1, r1, g1, b1, a1
    End Select
End Sub

'Set an indexed alpha-pixel in progressive mode
Sub SetPixelA3P(dc As Long, pass As Integer, x1 As Long, y1 As Long, Colour As Long, a1 As Byte)
    Select Case pass
    Case 1
        SetPixelA3 dc, x1 * 8, y1 * 8, Colour, a1
    Case 2
        SetPixelA3 dc, x1 * 8 + 4, y1 * 8, Colour, a1
    Case 3
        SetPixelA3 dc, x1 * 4, y1 * 8 + 4, Colour, a1
    Case 4
        SetPixelA3 dc, x1 * 4 + 2, y1 * 4, Colour, a1
    Case 5
        SetPixelA3 dc, x1 * 2, y1 * 4 + 2, Colour, a1
    Case 6
        SetPixelA3 dc, x1 * 2 + 1, y1 * 2, Colour, a1
    Case 7
        SetPixelA3 dc, x1, y1 * 2 + 1, Colour, a1
    End Select
End Sub

'Set an alpha-pixel
Sub SetPixelA(dc As Long, x1 As Long, y1 As Long, r1 As Integer, g1 As Integer, b1 As Integer, a1 As Integer)
    Dim col2 As Long, r As Integer, g As Integer, b As Integer, diff As Integer
    col2 = GetPixel(dc, x1, y1)
    b = (col2 \ 65536) And &HFF
    g = (col2 \ 256) And &HFF
    r = col2 And &HFF
    diff = CLng(b1 - b) * a1 / 256
    b = b + diff
    diff = CLng(g1 - g) * a1 / 256
    g = g + diff
    diff = CLng(r1 - r) * a1 / 256
    r = r + diff
    SetPixel dc, x1, y1, RGB(r, g, b)
End Sub

'Set an indexed alpha-pixel
Sub SetPixelA3(dc As Long, x1 As Long, y1 As Long, col1 As Long, a1 As Byte)
    Dim col2 As Long, r As Integer, g As Integer, b As Integer, diff As Integer
    Dim r1 As Integer, g1 As Integer, b1 As Integer
    col2 = GetPixel(dc, x1, y1)
    b = (col2 \ 65536) And &HFF
    g = (col2 \ 256) And &HFF
    r = col2 And &HFF
    b1 = (col1 \ 65536) And &HFF
    g1 = (col1 \ 256) And &HFF
    r1 = col1 And &HFF
    diff = CLng(b1 - b) * a1 / 256
    b = b + diff
    diff = CLng(g1 - g) * a1 / 256
    g = g + diff
    diff = CLng(r1 - r) * a1 / 256
    r = r + diff
    SetPixel dc, x1, y1, RGB(r, g, b)
End Sub

