unit UnitMisc;


interface
uses VCL.Controls, VCL.Menus, INIFiles;
type TShellExecuteShow = (
    SES_HIDE = 0,
    SES_SHOWNORMAL = 1,
    SES_SHOWMINIMIZED = 2,
    SES_MAXIMIZE = 3,
    SES_SHOWNOACTIVATE  = 4,
    SES_SHOW = 5,
    SES_MINIMIZE = 6,
    SES_SHOWMINNOACTIVE = 7,
    SES_SHOWNA = 8,
    SES_RESTORE = 9,
    SES_SHOWDEFAULT = 10
);
function ShellExecute(F : THandle; command : string; ShowAs : TShellExecuteShow = SES_SHOWNORMAL) : integer;

procedure waitForNoLock(filename : string; maxWaitMS : integer);
procedure ShowPopupRight(b : TControl; pm : TPopupMenu);
function ForceForeground(h : THandle) : boolean;
function StrSize(s : string) : cardinal;

function getAppPath : string;

type TMyINIFile = class(TINIFile)
    public
        procedure WriteString(const Section, Ident, Value: String); override;
end;

{////////////////////}
{//}implementation{//}
{////////////////////}

uses WinAPI.Windows, System.SysUtils, System.StrUtils, ShellAPI, Classes, Forms, IOUtils;



function getAppPath : string;
begin
    result := TPath.Combine(ExtractFilePath(Application.EXEName), '\');
end;

procedure TMyIniFile.WriteString(const Section, Ident, Value: String);
begin
    if StartsText('"', Value) and EndsText('"', Value) then begin
        inherited WriteString(section, ident, '"' + value + '"');
    end else if StartsText('''', Value) and EndsText('''', Value) then begin
        inherited WriteString(section, ident, '''' + value + '''');
    end else begin
        inherited WriteString(section, ident, value);
    end;
end;



function StrSize(s : string) : cardinal;
begin
    result := length(s) * sizeof(char);
end;

var ThreadAttached : boolean;
    ThreadTarget : THandle;
    ThreadOurs : THandle;
function ThreadAttach(TargetWindow: cardinal) : boolean;
begin
    If (ThreadAttached) then begin
//        showmessage('Error: Thread already attached');

    end;

    ThreadTarget := WinAPI.Windows.GetWindowThreadProcessId(TargetWindow, nil);
    ThreadOurs := WinAPI.Windows.GetCurrentThreadId();
    if (ThreadTarget <> ThreadOurs) then begin
        result := WinAPI.Windows.AttachThreadInput(ThreadTarget, ThreadOurs, true);
    end else begin
        result := true;
    end;
    ThreadAttached := result;
end;
procedure ThreadDetach();
begin
    if (ThreadTarget <> ThreadOurs) then begin
        WinAPI.Windows.AttachThreadInput(ThreadTarget, ThreadOurs, false);
    end;
    ThreadAttached := false;
end;
function IsThreadAttached : boolean;
begin
    result := ThreadAttached;
end;
function ForceForeground(h : THandle) : boolean;
var b : boolean;
    fore : THandle;

    dw : DWORD;
begin
    result := true;
    fore := GetForegroundWindow;
    if fore = h then EXIT;

    if (fore = 0) then begin
        fore := GetDesktopWindow;
    end;
    b := ThreadAttach(fore);
    WinAPI.Windows.BringWindowToTop(h);
    WinAPI.Windows.SetForegroundWindow(h);
    if b then ThreadDetach;

    fore := GetForegroundWindow;
    result := (fore<>h);
    if (not result) then begin
        // temporarily disable the foreground lock
        SystemParametersInfo(SPI_GETFOREGROUNDLOCKTIMEOUT, 0, @dw, 0);
        SystemParametersInfo(SPI_SETFOREGROUNDLOCKTIMEOUT, 0, TObject(0),SPIF_SENDCHANGE);
        WinAPI.Windows.BringWindowToTop(h);
        SetForegroundWindow(h);
        SystemParametersInfo(SPI_SETFOREGROUNDLOCKTIMEOUT, 0, TObject(dw), SPIF_SENDCHANGE);

        result := h = GetForegroundWindow;
    end;
end;






procedure ShowPopupRight(b : TControl; pm : TPopupMenu);
var p : TPoint;
begin
    p := b.ClientToScreen(point(b.width, 0));
    pm.Popup(p.x, p.y);
end;
procedure waitForNoLock(filename : string; maxWaitMS : integer);
const SLEEP_MS = 100;
var fs : TFileStream;
    ok : boolean;
begin
    repeat
        ok := false;
        try
            fs :=TFileStream.Create(filename, fmOpenRead or fmShareDenyNone);
            ok := true;
            fs.free;
        except

        end;
        if not ok then begin
            sleep(SLEEP_MS);
            dec(maxWaitMS,SLEEP_MS);
        end;
    until ok or (maxWaitMS<=0);

end;

function IsHiddenCommandPrompt(command : string) : boolean;
var s : string;
    i : integer;
    slashPos : integer;
begin
    //cmd/c
    //cmd.exe /c
    s := lowercase(command);

    slashPos := Pos('/',s);
    Delete(s, slashPos, length(s)-slashPos);
//    s := UnitToken.CutWordExclude(s,' /');

    i :=  pos('/c', command);
    result := StartsText('cmd', command) and
         (i>0) and (i <= length(s) );
end;
function RunCommandLine(command : string;priority : DWORD = NORMAL_PRIORITY_CLASS) : integer;
var  StartInfo  : _StartupInfo;
     ProcInfo   : _PROCESS_INFORMATION;
     b : boolean;
begin
    // nil for the program name treats the program name
    // as a command line to execute
    FillChar(StartInfo, SizeOf(StartInfo), #0);
    FillChar(ProcInfo, SizeOf(ProcInfo), #0);
    StartInfo.cb := SizeOf(TStartupInfo);

    // detect command prompt, and hide unless "keep open" is used
    if IsHiddenCommandPrompt(command) then begin
        StartInfo.dwFlags := STARTF_USESHOWWINDOW;
        StartInfo.wShowWindow := SW_HIDE;
    end;

    b := CreateProcess(nil, PChar(command),
                nil, nil, False,
                CREATE_NEW_PROCESS_GROUP + priority,
                nil, nil, StartInfo, ProcInfo);
    result := 0;
    if (not b) then begin
        result := WinAPI.Windows.GetLastError();
    end;
end;




function ShellExecute(F : THandle; command : string; ShowAs : TShellExecuteShow = SES_SHOWNORMAL) : integer;
    var s : string;
        i : integer;
    begin
        WinAPI.Windows.SetLastError(ERROR_SUCCESS);
        //
        // try to run it as a mail address if it fails
        // the first time - report any error otherwise

        // trim any whitespace - CRLFs
        s := trim(command);
        result := 0;
        if s = '' then EXIT;

        while CharInSet(s[length(s)],[#13, #10]) do begin
            s := Copy(s, 1, length(s) - 1);
        end;

        i := ShellAPI.ShellExecute(F,nil,
            PChar(s),nil,nil,Integer(ShowAs));
        if (i <= 32) then begin

            {if (pos('@',s) <> 0) then begin
                s := 'mailto:' + s;
                i := shellAPI.ShellExecute(F,nil,
                    PChar(s),nil,nil, Integer(ShowAs));
            end;}
        end;

        result := 0;
        if (i <= 32) then begin
            result := Integer(RunCommandLine(s));
            WinAPI.Windows.SetForegroundWindow(F);
        end;
    end;
end.
