unit UnitFrmTest;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.ComCtrls, Vcl.StdCtrls;

type
  TfrmTest = class(TForm)
    StatusBar1: TStatusBar;
    btnUpdate: TButton;
    btnClose: TButton;
    btnExecute: TButton;
    GroupBox1: TGroupBox;
    txtCommand: TEdit;
    cbxFiles: TComboBox;
    procedure btnCloseClick(Sender: TObject);
    procedure btnUpdateClick(Sender: TObject);
    procedure btnExecuteClick(Sender: TObject);
    procedure txtCommandChange(Sender: TObject);
  private
    { Private declarations }
  protected
    fFolder : string;
    procedure SetStatus(status : string);
  public
    { Public declarations }

    function show(command, folder, fileType : string) : string;
  end;

var
  frmTest: TfrmTest;

implementation

{$R *.dfm}

uses Types, IOUtils, UnitFrmMain, UnitMisc;

procedure TfrmTest.SetStatus(status : string);
begin
  StatusBar1.Panels[0].Text := status;
end;

procedure TfrmTest.btnCloseClick(Sender: TObject);
begin
    ModalResult := mrClose;
end;
procedure TfrmTest.btnExecuteClick(Sender: TObject);
var
    command : string;
begin
    command := FrmMain.formatCommand(
        txtCommand.Text,
        TPath.Combine(fFolder, cbxFiles.Text )
    );
    SetStatus('');
    if UnitMisc.ShellExecute(self.Handle, command) <> 0 then begin
        SetStatus('Error detected running command.');
    end;;
end;
procedure TfrmTest.btnUpdateClick(Sender: TObject);
begin
    ModalResult := mrOK;
end;

function TfrmTest.show(command, folder, fileType : string) : string;
var
    r : TStringDynArray;
    s : string;
begin

    txtCommand.Text := command;
    cbxFiles.Items.Clear;
    fFolder := folder;
    r := TDirectory.GetFiles(folder, fileType);
    SetStatus('');
    if length(r) > 0 then begin
        for s in r do begin
            cbxFiles.Items.Add( ExtractFileName(s) );
        end;
        cbxFiles.ItemIndex := 0;
    end else begin
        SetStatus('Warning: No files of type ('+filetype+') to use for testing.');
    end;

    btnUpdate.Enabled := false;

    ShowModal;
    result := '';
    if ModalResult = mrOk  then begin
        result := txtCommand.Text;
    end;
end;

procedure TfrmTest.txtCommandChange(Sender: TObject);
begin
    btnUpdate.Enabled := true;
end;

end.
