unit UnitFrmSettings;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls;

type
  TfrmSettings = class(TForm)
    gbExecute: TGroupBox;
    NOLOCK_WAIT_MS: TEdit;
    GroupBox1: TGroupBox;
    DROPDOWN_FILE_TYPES: TEdit;
    EXECUTE_QUEUE_DELAY: TEdit;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmSettings: TfrmSettings;

implementation

{$R *.dfm}

uses INIFiles;
procedure TfrmSettings.FormCreate(Sender: TObject);
const EXECUTE_SETTINGS = 'EXECUTE_SETTINGS';
var
    i, j : integer;
    ini : TIniFile;
    e : TEdit;
    cb : TCheckBox;
    gb : TGroupBox;
begin
    ini := TIniFile.Create(Application.ExeName + '.ini');
    for j := 0 to self.ControlCount-1 do begin
        if (self.Controls[j] is TGroupBox) then begin
            gb := TGroupBox(self.Controls[j]);
            for i := 0 to gb.ControlCount-1 do begin
                if (gb.Controls[i] is TEdit) then begin
                    e := TEdit(gb.Controls[i]);
                    e.Hint := e.Name;
                    e.Text := ini.readstring(gb.Caption, e.Name,e.Text);
                    ini.WriteString(gb.Caption, e.Name, e.text);
                end else if (self.Controls[i] is TCheckBox) then begin
                    cb := TCheckBox(gb.Controls[i]);
                    cb.Caption := cb.Name;
                end;
            end;
        end;
    end;
    ini.free;
end;

end.
