unit UnitFrmMain;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.ComCtrls, Vcl.ImgList, UnitFileChanges, Generics.Collections,
  Vcl.StdCtrls, Vcl.ExtCtrls, VirtualTrees, Vcl.Menus;

type
  TfrmMain = class(TForm)
    ilRules: TImageList;
    StatusBar1: TStatusBar;
    pnl1: TPanel;
    TrayIcon1: TTrayIcon;
    btnAbout: TButton;
    vstActions: TVirtualStringTree;
    pmAction: TPopupMenu;
    MIEnableDisable: TMenuItem;
    N1: TMenuItem;
    MIDelete: TMenuItem;
    MIDuplicate: TMenuItem;
    timChangeQueue: TTimer;
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);

    procedure TrayIcon1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure vstActionsGetText(Sender: TBaseVirtualTree; Node: PVirtualNode;
      Column: TColumnIndex; TextType: TVSTTextType; var CellText: string);
    procedure vstActionsGetNodeDataSize(Sender: TBaseVirtualTree;
      var NodeDataSize: Integer);
    procedure vstActionsGetImageIndex(Sender: TBaseVirtualTree;
      Node: PVirtualNode; Kind: TVTImageKind; Column: TColumnIndex;
      var Ghosted: Boolean; var ImageIndex: Integer);
    procedure vstActionsMeasureItem(Sender: TBaseVirtualTree;
      TargetCanvas: TCanvas; Node: PVirtualNode; var NodeHeight: Integer);
    procedure vstActionsGetImageText(Sender: TBaseVirtualTree;
      Node: PVirtualNode; Kind: TVTImageKind; Column: TColumnIndex;
      var ImageText: string);
    procedure vstActionsNodeDblClick(Sender: TBaseVirtualTree;
      const HitInfo: THitInfo);
    procedure vstActionsDrawText(Sender: TBaseVirtualTree;
      TargetCanvas: TCanvas; Node: PVirtualNode; Column: TColumnIndex;
      const Text: string; const CellRect: TRect; var DefaultDraw: Boolean);
    procedure vstActionsNodeClick(Sender: TBaseVirtualTree;
      const HitInfo: THitInfo);
    procedure vstActionsGetPopupMenu(Sender: TBaseVirtualTree;
      Node: PVirtualNode; Column: TColumnIndex; const P: TPoint;
      var AskParent: Boolean; var PopupMenu: TPopupMenu);
    procedure MIEnableDisableClick(Sender: TObject);
    procedure MIDeleteClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure MIDuplicateClick(Sender: TObject);
    procedure vstActionsBeforeCellPaint(Sender: TBaseVirtualTree;
      TargetCanvas: TCanvas; Node: PVirtualNode; Column: TColumnIndex;
      CellPaintMode: TVTCellPaintMode; CellRect: TRect; var ContentRect: TRect);
    procedure vstActionsExpanding(Sender: TBaseVirtualTree; Node: PVirtualNode;
      var Allowed: Boolean);
    procedure timChangeQueueTimer(Sender: TObject);
    procedure btnAboutMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure vstActionsGetHint(Sender: TBaseVirtualTree; Node: PVirtualNode;
      Column: TColumnIndex; var LineBreakStyle: TVTTooltipLineBreakStyle;
      var HintText: string);
  private
    { Private declarations }
    newVirtualNode : PVirtualNode;
    fileChangesList : TList<TFileChangesMonitor>;
    rightClicked : PVirtualNode;
    changesQueue : TFileChangesList;
    lastFileChangeMonitor : TFileChangesMonitor;
    procedure  HandleCloseEvent ;
    procedure updateFileList(refreshFileChangesOnly : boolean = false);
    procedure clearChangesList;
    procedure clearStatus;
    procedure FileChangeNotification(Sender : TObject);

    function getRulesData(Sender : TBaseVirtualTree; Node : PVirtualNode) : pointer;
    function getDisplayString(Node : PVirtualNode) : string;
  public
    { Public declarations }
    procedure init;
    function captionToFilename(caption : string) : string;
    function filenameToCaption(filename : string) : string;

    function formatCommand(const command, fullfilename : string) : string;
     procedure WMEndSession(var msg : TWMQueryEndSession); message WM_QUERYENDSESSION;

  end;

var
  frmMain: TfrmMain;

implementation

{$R *.dfm}

uses UnitFrmEdit, IOUtils, Types, UnitMisc,
System.StrUtils , UnitFrmAbout, INIFiles, UnitFrmSettings, Math, UnitFrmDebug,
ShellAPI;


type
RuleData = record
    caption : string;
    folder : string;
    command : string;
    filter: string;
    enabled : boolean;
    newFiles : boolean;
    changedFiles : boolean;
end;
PRuleData = ^RuleData;
const RuleDataSize = SizeOf(RuleData);
function TfrmMain.getRulesData(Sender : TBaseVirtualTree; Node : PVirtualNode) : pointer;
begin
    result := sender.GetNodeData(node);
end;
function TfrmMain.getDisplayString(Node : PVirtualNode) : string;
var
    data : PRuleData;
const
    MYSTUFF = '%MYSTUFF%';
begin
    data := getRulesData(vstActions, Node);
    result := data^.caption;
    if node=newVirtualNode then EXIT;

    result :=
        'FOLDER:     "'+Data^.caption+'"'+ MYSTUFF+  #13#10 +
        'COMMAND:    '+data^.command+#13#10+
        'FILE TYPE:  '+data^.filter;

    if data.enabled then begin
        result := replacestr(result,MYSTUFF,'');
    end else begin
        result := replacestr(result,MYSTUFF,' (disabled)');
    end;
end;



procedure TfrmMain.init;
begin
    updateFileList(true);
    timChangeQueue.Interval := StrToInt(FrmSettings.EXECUTE_QUEUE_DELAY.text);
    if (fileChangesList.Count = 0) then begin
        self.Show;
    end else begin
        // TODO minimalist splash screen
    end;
end;
procedure TfrmMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
    CanClose := True;
    if Application.Terminated then Exit;
    CanClose := MessageDlg(
        'Close NewFileGo?',mtConfirmation,[mbYes, mbCancel],0,mbCancel
    ) = mrYes;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
var
    ini : TIniFile;
begin
    fileChangesList := TList<TFileChangesMonitor>.create;
    vstActions.Header.Options := vstActions.Header.Options - [hoVisible];

    changesQueue := TFileChangesList.Create;
    lastFileChangeMonitor := nil;
end;
procedure TfrmMain.FormResize(Sender: TObject);
begin

    if self.WindowState = wsMinimized then begin
        self.Hide;
    end;
end;
procedure TfrmMain.FormShow(Sender: TObject);
begin
    updateFileList;
    clearStatus;
end;
procedure TfrmMain.WMEndSession(var msg : TWMQueryEndSession);
begin
    self.HandleCloseEvent;
    msg.Result := 1;       // do allow close
end;
procedure  TfrmMain.HandleCloseEvent ;
begin
     clearChangesList;
     Application.Terminate;
end;

procedure TfrmMain.updateFileList;
var
    files : TStringDynArray;
    name : string;
    fc : TFileChangesMonitor;
    node : PVirtualNode;
    data : PRuleData;
    subdata : PRuleData;
begin
    if not refreshFileChangesOnly then begin
        vstActions.BeginUpdate;
        vstActions.Clear;
    end;


    clearChangesList;
    files := TDirectory.GetFiles(  ExtractFilePath(Application.ExeName), '*' + DATA_EXT );
    for name in files do begin
        if not refreshFileChangesOnly then begin
            node := vstActions.AddChild(nil);
            vstActions.MultiLine[node] := true;

            data := PRuleData(vstActions.GetNodeData(node));
            data.caption := filenameToCaption(name);
            FrmDebug.AppendLog('Starting Monitor: '+data.caption);
        end;

        frmEdit.load(name);
        if not refreshFileChangesOnly then begin
            data.command := frmEdit.Command;
            data.folder := frmEdit.Folder;
            data.filter := frmEdit.FileType;
            data.enabled := frmEdit.ActionEnabled;
            data.newFiles := frmEdit.MonitorNewFiles;
            data.changedFiles := frmEdit.MonitorChangedFiles;
            if not data.enabled then begin
                node.States :=  node.states + [vsDisabled];
            end;
        end;

        if (frmEdit.ActionEnabled) then begin
            fc := TFileChangesMonitor.Create;
            fc.OnChange := FileChangeNotification;
            fc.MonitorFolder(
                frmEdit.Folder, frmEdit.FileType,
                frmEdit.MonitorChangedFiles, frmEdit.MonitorNewFiles
            );
            fc.setName( filenameToCaption(name) );
            fileChangesList.add(fc);
        end else begin

        end;
    end;

    if not refreshFileChangesOnly then begin
        newVirtualNode := vstActions.AddChild(nil);
        data := PRuleData(vstActions.GetNodeData(newVirtualNode));
        data.caption := '[ Add new Watcher ]';

        vstActions.EndUpdate;
    end;
end;
procedure TfrmMain.btnAboutMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   if ssCtrl in Shift then begin
        FrmDebug.Show;
    end;
end;

function TfrmMain.captionToFilename(caption : string) : string;
begin
    result := TPath.Combine(ExtractFilePath(Application.ExeName), Caption + DATA_EXT);
end;
function TfrmMain.filenameToCaption(filename : string) : string;
begin
    result := ReplaceStr(
        ExtractFileName(ExtractFilename(filename)),
        DATA_EXT,
        '');
end;



var timerRunning : boolean = false;
procedure TfrmMain.FileChangeNotification(Sender : TObject);
var
    fc : TFileChangesMonitor;
    fcl : TFileChangesList;

    procedure HandleUnprocessedFiles;
    begin
        // files from another monitor need processing first
        if (lastFileChangeMonitor <> nil) and (fc <> lastFileChangeMonitor) then begin
            if (changesQueue.Count > 0) then begin
                timChangeQueueTimer(nil);
            end;
        end;
    end;
    procedure HandleNewFiles;
    begin
        if (fc.watchingNewFiles) then begin
            fcl := fc.GetNewFiles;
            FrmDebug.AppendLog('new file(s): ' + IntToStr(fcl.Count));
            changesQueue.AddRange(fcl);
            fcl.free;
        end;
    end;
    procedure HandleChangedFiles;
    begin
        if (fc.watchingAttributes) then begin
            fcl := fc.GetChangedFiles;
            FrmDebug.AppendLog('changed file(s): ' + IntToStr(fcl.Count));
            changesQueue.AddRange(fcl);
            fcl.Free;
        end;
    end;
begin
    while (timerRunning) do begin
        sleep(50);
    end;
    timChangeQueue.Enabled := false;

        fc := TFileChangesMonitor(Sender);
        FrmDebug.AppendLog('MonitorName: '+FC.getName);
        HandleUnprocessedFiles;
        lastFileChangeMonitor := fc;

        HandleNewFiles;
        HandleChangedFiles;
        fc.resetAllFileLists;

    if timChangeQueue.interval = 0 then begin
        timChangeQueueTimer(nil);
    end else begin
        timChangeQueue.Enabled := true;
    end;
end;
procedure TfrmMain.timChangeQueueTimer(Sender: TObject);
var
    s, filelist : string;
    command, formattedCommand : string;
    waitMS : integer;
begin
    timChangeQueue.Enabled := false;
    timerRunning := true;

    if (changesQueue.Count > 0) then begin
        frmEdit.load( captionToFilename(lastFileChangeMonitor.getName) );
        command := frmEdit.Command;

        waitMS := StrToInt(FrmSettings.NOLOCK_WAIT_MS.text);
        if (frmEdit.SingleRun) then begin
            for s in changesQueue do begin
                filelist := filelist + '"'+s+'" ';
            end;
            if (waitMS > 0) then waitForNoLock(s, waitMS);
            formattedCommand := ReplaceText(command,'%s', filelist);
            formattedCommand := ReplaceText(formattedCommand,'%fp', ExtractFilePath(s));


            FrmDebug.AppendLog('Single Execute - '+formattedCommand);
            if UnitMisc.ShellExecute(self.Handle,formattedCommand) <> 0 then begin
                ShowMessage( SysErrorMessage(WinAPI.Windows.GetLastError) );
            end;
        end else begin
            for s in changesQueue do begin
                if (waitMS > 0) then waitForNoLock(s, waitMS);

                if (frmEdit.IsExplorerCommand) then begin
                    formattedCommand := frmEdit.ExplorerCommand;
                    FrmDebug.AppendLog('Multiple Execute - '+formattedCommand);
                    ShellAPI.ShellExecute(self.Handle,PChar(formattedCommand),PChar(s),nil,nil,Integer(SES_SHOWNORMAL));
                end else begin

                    formattedCommand := self.formatCommand(command, s);
                    FrmDebug.AppendLog('Multiple Execute - '+formattedCommand);
                    if UnitMisc.ShellExecute(self.Handle,formattedCommand) <> 0 then begin
                        ShowMessage( SysErrorMessage(WinAPI.Windows.GetLastError) );
                    end;
                end;
            end;
        end;
    end;
    changesQueue.clear;
    timerRunning := false;
end;

function TfrmMain.formatCommand(const command, fullfilename : string) : string;
begin
    result := ReplaceText(command,'%s', fullfilename);
    result := ReplaceText(result,'%fp', ExtractFilePath(fullfilename));
    result := ReplaceText(result,'%fn', ExtractFileName(fullfilename));
end;



procedure TfrmMain.clearChangesList;
var
    changes : TFileChangesMonitor;
begin
    for changes in filechangesList do begin
        changes.Cancel;
        changes.Free;
    end;
    fileChangesList.Clear;
end;

procedure TfrmMain.TrayIcon1Click(Sender: TObject);
begin
    ForceForeground(Application.Handle);
    self.Show;
end;

procedure TFrmMain.clearStatus;
begin
end;
procedure TfrmMain.MIDeleteClick(Sender: TObject);
var
    s : string;
    data : PRuleData;
begin
    data := getRulesData(vstActions, rightClicked);
    s := captionToFilename(data^.caption);

    if MessageDlg(
        'Delete this folder monitor ?',
        mtConfirmation, [mbYes, mbNo],
        0, mbYes) = mrNo then
        EXIT;

    DeleteFile(s);
    updateFileList;
end;
procedure TfrmMain.MIEnableDisableClick(Sender: TObject);
var
    data : PRuleData;
begin
    data := getRulesData(vstActions, rightClicked);
    frmEdit.load(captionToFilename(data^.caption));
    frmEdit.ActionEnabled := not frmEdit.ActionEnabled;

    updateFileList;
end;

procedure TfrmMain.MIDuplicateClick(Sender: TObject);
var
    s : string;
    data : PRuleData;
begin
    data := getRulesData(vstActions, rightClicked);
    frmEdit.duplicate(captionToFilename(data^.caption));
    updateFileList;
end;

procedure TfrmMain.btnAboutClick(Sender: TObject);
begin
    FrmAbout.Show;
end;



//
// user input
//
procedure TfrmMain.vstActionsNodeClick(
    Sender: TBaseVirtualTree;
  const HitInfo: THitInfo);
begin
    if (HitInfo.HitNode=nil) then EXIT;

    if HitInfo.HitNode = newVirtualNode then begin
        vstActions.Selected[newVirtualNode] := false;
        frmEdit.show();
        self.updateFileList;
    end;
end;

procedure TfrmMain.vstActionsNodeDblClick(
    Sender: TBaseVirtualTree;
  const HitInfo: THitInfo);
var
    caption : string;
begin
    if (HitInfo.HitNode=nil) then EXIT;

    caption := PRuleData(Sender.GetNodeData(HitInfo.HitNode) )^.caption;



    FrmEdit.show(
        captionToFilename(caption)
    );
    if (FrmEdit.ModalResult = mrOK) then
        updateFileList;

end;
procedure TfrmMain.vstActionsExpanding(Sender: TBaseVirtualTree;
  Node: PVirtualNode; var Allowed: Boolean);
begin
    allowed := false;
    // Double Clicking caused a crash if this was allowed
end;


procedure TfrmMain.vstActionsGetPopupMenu(
    Sender: TBaseVirtualTree;
  Node: PVirtualNode; Column: TColumnIndex; const P: TPoint;
  var AskParent: Boolean; var PopupMenu: TPopupMenu);
begin
    rightClicked := node;
    PopupMenu := pmAction;
end;


//
// drawing
//
procedure TfrmMain.vstActionsBeforeCellPaint(Sender: TBaseVirtualTree;
  TargetCanvas: TCanvas; Node: PVirtualNode; Column: TColumnIndex;
  CellPaintMode: TVTCellPaintMode; CellRect: TRect; var ContentRect: TRect);
begin

    if (Node = newVirtualNode) then begin
        TargetCanvas.Brush.Color := clBtnFace;
        TargetCanvas.FillRect(CellRect);
    end else if (column = 0) then begin
        TargetCanvas.Brush.Color := $00CEE3DA;
        TargetCanvas.FillRect(CellRect);
    end;
end;

procedure TfrmMain.vstActionsDrawText(
    Sender: TBaseVirtualTree;
  TargetCanvas: TCanvas; Node: PVirtualNode; Column: TColumnIndex;
  const Text: string; const CellRect: TRect; var DefaultDraw: Boolean
);
var
    r : TRect;
    s,str : string;
    row, col, topOffset, leftIndent : integer;
    regheight, bigheight, space : integer;
    data : PRuleData;
    fontColor : TColor;
    fontGrayColor : TColor;
const
    FONT_OFFSET = 1;
    FONT_SPACE = 3;
begin
    defaultDraw :=  true;
    case column of
    1:
        begin
            if (node = newVirtualNode) then EXIT;

            defaultDraw := false;

            fontColor := clBlack;
            fontGrayColor := clGrayText;
            if Sender.Selected[node] then begin
                fontColor := clWhite;
                fontGrayColor := $E0E0E0;
            end;

            r := CellRect;
            s := Text;

            regheight := TargetCanvas.TextHeight('ASDF_');
            TargetCanvas.Font.Height := TargetCanvas.Font.Height - FONT_OFFSET;
            bigheight := TargetCanvas.TextHeight('ASDF_');
            TargetCanvas.Font.Height := TargetCanvas.Font.Height + FONT_OFFSET;
            leftIndent := TargetCanvas.TextWidth('command:');

            topOffset := r.Height div 2 - (regheight*2 + bigheight + FONT_SPACE*2) div 2;
            row := r.Top + topOffset;
            col := r.Left;
            data := getRulesData(vstActions, node);


            TargetCanvas.Font.Color := fontColor;
            TargetCanvas.Font.Height := TargetCanvas.Font.Height - FONT_OFFSET;



            TargetCanvas.Font.Style := TargetCanvas.Font.Style + [fsBold];


            TargetCanvas.TextOut(col, row, data.caption);
            TargetCanvas.Font.Style := TargetCanvas.Font.Style - [fsBold];

            TargetCanvas.Font.Height := TargetCanvas.Font.Height + FONT_OFFSET;

            inc(col, (leftIndent div 3));
            TargetCanvas.Font.Color := fontGrayColor;
            inc(row, bigheight + FONT_SPACE);
            TargetCanvas.TextOut(col, row, 'command:');
            inc(row, regheight + FONT_SPACE);
            TargetCanvas.TextOut(col, row, 'files:');


            row := r.Top + topOffset;
            col := r.Left + leftIndent + (leftIndent div 3)  + 16;
            str := '';
            if data.newFiles then begin
                str := str + ' (new)';
            end;
            if data.changedFiles then begin
                str := str + ' (changed)';
            end;

            inc(row, bigheight + FONT_SPACE);
            TargetCanvas.TextOut(col, row, data.command);
            inc(row, regheight + FONT_SPACE);
            TargetCanvas.TextOut(col, row, data.filter+str);




//            TargetCanvas.TextRect(r,s,[tfVerticalCenter]);
        end;
    end;
end;


//
// data and measures
//
procedure TfrmMain.vstActionsGetHint(Sender: TBaseVirtualTree;
  Node: PVirtualNode; Column: TColumnIndex;
  var LineBreakStyle: TVTTooltipLineBreakStyle; var HintText: string);
var
    data : PRuleData;
begin
    if (node <> nil) then begin
        data := PRuleData(vstActions.GetNodeData(node));
        HintText := data.folder;
    end;
end;

procedure TfrmMain.vstActionsGetImageIndex(
    Sender: TBaseVirtualTree;
  Node: PVirtualNode; Kind: TVTImageKind; Column: TColumnIndex;
  var Ghosted: Boolean; var ImageIndex: Integer
);
var
    pdata : PRuleData;
begin
    ImageIndex := -1;
    if column <> 0 then EXIT;

    ImageIndex := 0;
    pdata := Sender.GetNodeData(node);
//    if not pdata.enabled then begin
//        ImageIndex := 2;
//    end;

    if node = newVirtualNode then
        ImageIndex := 1;
end;

procedure TfrmMain.vstActionsGetImageText(
    Sender: TBaseVirtualTree;
  Node: PVirtualNode; Kind: TVTImageKind; Column: TColumnIndex;
  var ImageText: string);
var data : PRuleData;
begin
    ImageText := 'NONONO';
end;

procedure TfrmMain.vstActionsGetNodeDataSize(
    Sender: TBaseVirtualTree;
  var NodeDataSize: Integer);
begin
    NodeDataSize := RuleDataSize;
end;


procedure TfrmMain.vstActionsGetText(
    Sender: TBaseVirtualTree;
  Node: PVirtualNode; Column: TColumnIndex; TextType: TVSTTextType;
  var CellText: string);
var
    data : RuleData;
begin
    CellText := '';
    case column of
    1:
        begin
            CellText := getDisplayString(Node)
        end;
    end;
end;

procedure TfrmMain.vstActionsMeasureItem(
    Sender: TBaseVirtualTree;
  TargetCanvas: TCanvas; Node: PVirtualNode; var NodeHeight: Integer);
var
    vst : TVirtualStringTree;
    r : TRect;
    s : string;
const SPACING = 12;
begin
    vst := TVirtualStringTree(Sender);
    NodeHeight := vst.Images.Height + SPACING;
    s := getDisplayString(Node);
    TargetCanvas.TextRect(r, s, [tfCalcRect,tfLeft]);

    NodeHeight := max(NodeHeight, r.Height+SPACING);
end;


end.
