unit UnitFrmFileTypes;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.ExtCtrls, Vcl.StdCtrls;

type
  TfrmFileTypes = class(TForm)
    lbTypes: TListBox;
    pnl1: TPanel;
    txtFind: TEdit;
    procedure FormShow(Sender: TObject);
    procedure txtFindChange(Sender: TObject);
    procedure lbTypesClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function getType : string;
    procedure getCommands(fileType : string; sl : TStringList);
  end;

var
  frmFileTypes: TfrmFileTypes;

implementation

{$R *.dfm}
uses Registry, System.Generics.Collections, StrUtils;



function TfrmFileTypes.getType : string;
begin
    self.ShowModal;
    result := '';
    if lbTypes.ItemIndex = -1 then EXIT;
    result := '.' + lbtypes.Items[lbTypes.ItemIndex];
end;
procedure TfrmFileTypes.getCommands(fileType : string; sl : TStringList) ;
var
    reg : TRegistry;
    fileAssociation : string;
    keys : TStringList;
    var s : string;
begin
    reg := TRegistry.Create;
    reg.RootKey := HKEY_CLASSES_ROOT;
    if not reg.OpenKeyReadOnly(fileType+'\') then EXIT;
    fileAssociation := reg.ReadString('');
    reg.CloseKey;

    reg := TRegistry.Create;
    reg.RootKey := HKEY_CLASSES_ROOT;
    if not reg.OpenKeyReadOnly(fileAssociation+'\shell\') then EXIT;
    keys := TStringList.Create;
    reg.GetKeyNames(keys);
    reg.CloseKey;

    for s in keys do begin
        reg := TRegistry.Create;
        reg.RootKey := HKEY_CLASSES_ROOT;
        if reg.OpenKeyReadOnly(fileAssociation+'\shell\'+s+'\command\') then begin
            sl.Values[s] := reg.ReadString('');
        end;
        reg.CloseKey;
    end;
end;


procedure TfrmFileTypes.lbTypesClick(Sender: TObject);
begin
    if lbTypes.ItemIndex = -1 then EXIT;
    ModalResult := mrOK;
end;

procedure TfrmFileTypes.FormShow(Sender: TObject);
var
    reg : TRegistry;
    sl : TSTringList;
    s, str : string;
begin
    reg := TRegistry.Create;
    reg.RootKey := HKEY_CLASSES_ROOT;
    if reg.OpenKey('\', false) then begin


        sl := TStringList.Create;
        reg.GetKeyNames(sl);

        for s in sl do begin
            if s[1] = '.' then begin
                str := s;
                delete(str,1,1);
                lbTypes.Items.Add(str);
            end;
        end;


        reg.CloseKey;
    end;

    self.ActiveControl := txtFind;
end;

procedure TfrmFileTypes.txtFindChange(Sender: TObject);
var
    s, str : string;
    i : integer;

begin
    s := txtFind.Text;
    lbTypes.ItemIndex := lbTypes.Perform(
        LB_FINDSTRING,
        cardinal(-1),
        LongInt(@s[1])
    );
    if (lbTypes.ItemIndex=-1) then begin
        for i := 0 to lbTypes.Items.Count-1 do begin
            str := lbTypes.Items[i];
            if ContainsText(str,s) then begin
                lbTypes.ItemIndex := i;
                EXIT;
            end;
        end;
    end;
end;

end.
