unit UnitFrmEdit;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.Buttons, Vcl.Menus;

const DATA_EXT = '.go.ini';
type
  TfrmEdit = class(TForm)
    GroupBox1: TGroupBox;
    GroupBox4: TGroupBox;
    cbxAction: TComboBox;
    txtFolder: TEdit;
    btnBrowse: TSpeedButton;
    fodFolder: TFileOpenDialog;
    odFolder: TOpenDialog;
    cbxType: TComboBox;
    btnSave: TButton;
    Button2: TButton;
    btnExamples: TSpeedButton;
    pmExamples: TPopupMenu;
    Echoatcommandline1: TMenuItem;
    RunFile1: TMenuItem;
    CopytoParent1: TMenuItem;
    MakeHidden1: TMenuItem;
    cbxEvent: TComboBox;
    btnFileType: TSpeedButton;
    txtCommand: TEdit;
    N1: TMenuItem;
    btnTest: TSpeedButton;
    InsertMetaVariable1: TMenuItem;
    MIfullfilenames: TMenuItem;
    MIfilespathfp: TMenuItem;
    MIfilenamenopathfn: TMenuItem;
    N2: TMenuItem;
    procedure btnBrowseClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure txtFolderChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure MIClick(Sender: TObject);
    procedure btnExamplesClick(Sender: TObject);
    procedure btnFileTypeClick(Sender: TObject);
    procedure btnTestClick(Sender: TObject);
    procedure txtCommandChange(Sender: TObject);
    procedure MIfullfilenamesClick(Sender: TObject);
    procedure MIfilespathfpClick(Sender: TObject);
    procedure MIfilenamenopathfnClick(Sender: TObject);
  private
    { Private declarations }
    fEnabled : boolean;
    newFile : boolean;
    filename, originalFolder : string;

    saveFileType : string;
    commandsList : TStringList;
    procedure setEnabled(value : boolean);
    procedure save(name : string);
    function getMonitorNewFiles : boolean;
    function getMonitorChangedFiles : boolean;
    function getFolder : string;
    function getFileType : string;
    function getCommand: string;
    function getExplorerCommand : string;
    function getSingleRun: boolean;
    function GetIsExplorerCommand : boolean;
    procedure ExplorerCommandClick(Sender : TObject);
    procedure ExplorerCodeClick(Sender : TObject);
    procedure InsertMetavariable(const variable : string);
  public
    { Public declarations }
    procedure show(datafile : string='');
    procedure load(datafile : string);
    procedure duplicate(datafile : string);



    // API for retrieving loaded settings
    property ActionEnabled : boolean read fenabled write setEnabled;
    property MonitorNewFiles : boolean read getMonitorNewFiles;
    property MonitorChangedFiles : boolean read getMonitorChangedFiles;
    property Folder : string read getFolder;
    property FileType : string read getFileType;
    property Command : string read getCommand;
    property SingleRun : boolean read getSingleRun;
    property IsExplorerCommand : boolean read GetIsExplorerCommand;
    property ExplorerCommand : string read getExplorerCommand;
  end;
const
    TNewFileEventIndexes = [0,2];
    TChangesFileEventIndexes = [1,2];

var
  frmEdit: TfrmEdit;


implementation

{$R *.dfm}

uses IOUtils, INIFiles, UnitMisc, Types, StrUtils, UnitFrmSettings,
  UnitFrmFileTypes, UnitFrmMain, UnitFrmTest, UnitDummyShellForm;


const
    EXPLORER_VERB_COMMAND =   'Explorer: (';
    EXPLORER_VERB_COMMAND_END = ')';

procedure TfrmEdit.FormShow(Sender: TObject);
var
    s : string;
    str : TStringDynArray;
begin
    commandsList := TStringList.Create;
    self.txtFolderChange(txtFolder);
    cbxType.Items.Clear;

    s := frmSettings.DROPDOWN_FILE_TYPES.Text;

    str := SplitString(s,'|');
    for s in str do
        cbxType.Items.Add(s);
end;

//
procedure TfrmEdit.InsertMetavariable(const variable : string);
begin
    if (ActiveControl <> txtCommand) then begin
        if (length(txtCommand.Text) > 0) and (txtCommand.SelStart=0) then begin
            txtCommand.SelStart := length(txtCommand.Text);
        end;
    end;
    txtCommand.SelText := '"'+variable+'"';
end;
procedure TfrmEdit.MIfilenamenopathfnClick(Sender: TObject);
begin
    InsertMetavariable('%fn');
end;
procedure TfrmEdit.MIfilespathfpClick(Sender: TObject);
begin
    InsertMetavariable('%fp');
end;
procedure TfrmEdit.MIfullfilenamesClick(Sender: TObject);
begin
    InsertMetavariable('%s');
end;

//

procedure TfrmEdit.setEnabled(value : boolean);
begin
    fEnabled := value;
    self.save(filename);
end;
function TfrmEdit.getMonitorNewFiles : boolean;
begin
    result := cbxEvent.ItemIndex in TNewFileEventIndexes;
end;
function TfrmEdit.getMonitorChangedFiles : boolean;
begin
    result := cbxEvent.ItemIndex in TChangesFileEventIndexes;
end;
function TfrmEdit.getFolder : string;
begin
    result := txtFolder.Text;
end;
function TfrmEdit.getFileType : string;
begin
    result := cbxType.Text;
    if result[1] = '.' then result := '*'+result;
end;
function TfrmEdit.getCommand: string;
begin
//    result := '';
//    if GetIsExplorerCommand then EXIT;
    result := txtCommand.Text;
end;
function TfrmEdit.getExplorerCommand : string;
begin
    result := txtCommand.Text;
    delete(result,1,length(EXPLORER_VERB_COMMAND));
    delete(result,length(result), 1);
end;
function TfrmEdit.getSingleRun: boolean;
begin
    result := (cbxAction.ItemIndex = 1) and not GetIsExplorerCommand;
end;
function TfrmEdit.GetIsExplorerCommand : boolean;
begin
    result := StartsText(EXPLORER_VERB_COMMAND, txtCommand.text);
end;

procedure TfrmEdit.duplicate(datafile : string);
begin
    self.load(datafile);
    filename := '';
    btnSaveClick(nil);
end;
procedure TfrmEdit.show(datafile : string='');
begin
    txtFolder.Text := '';
    cbxType.ItemIndex := 0;
    cbxAction.ItemIndex := 0;
    txtCommand.Text := '';
    enabled := true;
    filename := datafile;

    self.Caption := 'Edit Action';
    if (filename <> '') then begin
        self.Caption := self.Caption + '    ['+ FrmMain.filenameToCaption(filename)+']';
    end;

    load(datafile);
    btnTest.Enabled := not (IsExplorerCommand);
    ShowModal;
end;

procedure TfrmEdit.load(datafile : string);
var
    ini : TIniFile;
begin
    filename := datafile;
    if datafile <> '' then begin
        ini := TIniFile.Create(datafile);
        txtFolder.text := ini.ReadString('FolderInfo',txtFolder.name, txtFolder.text);
        originalFolder := txtFolder.text;
        cbxType.Text := ini.ReadString('FolderInfo',cbxType.Name, cbxType.Text);
        cbxEvent.ItemIndex := ini.ReadInteger('Event',cbxEvent.Name, cbxEvent.ItemIndex);
        cbxAction.ItemIndex := ini.ReadInteger('Action',cbxAction.Name, cbxAction.ItemIndex);
        txtCommand.text := ini.ReadString('Action',txtCommand.Name, txtCommand.text);
        self.fEnabled := ini.ReadBool('Misc','enabled',true);
        ini.Free
    end;
end;
procedure TfrmEdit.btnBrowseClick(Sender: TObject);
begin
    fodFolder.Options := fodFolder.Options + [fdoPickFolders];
    if fodFolder.Execute(self.Handle) then begin
        txtFolder.Text := fodFolder.FileName;
    end;
end;

procedure TfrmEdit.btnExamplesClick(Sender: TObject);
var
    i : integer;
    s, typeMask : string;
    mi, mi2 : TMenuItem;
    verbList : TVerbList;
    tf : file;
    dummyfile : string;
const EXPLORER_CODE = 'Explorer Code';
begin
    while StartsText(EXPLORER_VERB_COMMAND, pmExamples.Items[0].Caption) do begin
        pmExamples.Items.Delete(0);
    end;
    if (EXPLORER_CODE = pmExamples.Items[0].Caption) then begin
        pmExamples.Items.Delete(0);
    end;
    commandsList.Clear;
    typeMask := cbxType.Text;
    if (typeMask[1]='*') then begin
        Delete(typeMask,1,1);
    end;
    if (typemask='.*') then begin
        typeMask:='*';
    end;
    frmFileTypes.getCommands(typeMask, commandsList);
    if (commandsList.count > 0) then begin

        mi2 := TMenuItem.Create(pmExamples);
        mi2.Caption := EXPLORER_CODE;
        for i := commandsList.Count-1 downto 0 do begin
            mi := TMenuItem.Create(pmExamples);
            mi.Caption := EXPLORER_VERB_COMMAND + commandsList.Names[i] + EXPLORER_VERB_COMMAND_END;
            mi.OnClick := self.ExplorerCommandClick;
            pmExamples.Items.Insert(0, mi);

            mi := TMenuItem.Create(pmExamples);
            mi.Caption := commandsList.Names[i];
            mi.OnClick := self.ExplorerCodeClick;
            mi2.Insert(0, mi);
        end;

        pmExamples.Items.Insert(commandsList.Count, mi2);
    end;


    try
        dummyfile :=  TPath.Combine( ExtractFilePath(Application.ExeName), 'DUMMY.' + ExtractFileExt(typeMask));
        AssignFile(tf, dummyfile);
        ReWrite(tf);

        CloseFile(tf);
        verbList := FrmDummyShellForm.getVerbs(dummyfile);

        DeleteFile(dummyfile);
    except

    end;

    UnitMisc.ShowPopupRight(btnExamples, pmExamples);
end;
procedure TfrmEdit.ExplorerCommandClick(Sender : TObject);
var
    mi : TMenuItem;
    s : string;
begin
    mi := TMenuItem(Sender);
    txtCommand.Text := mi.Caption;
    cbxAction.ItemIndex := 0;
end;

procedure TfrmEdit.ExplorerCodeClick(Sender : TObject);
var
    mi : TMenuItem;
    s : string;
begin
    mi := TMenuItem(Sender);
    s := commandsList.ValueFromIndex[mi.menuIndex];
    s := ReplaceText(s,'%1','%s');
    s := ReplaceText(s,'%L','%s');
    s := ReplaceText(s,'%D','%s');
    txtCommand.Text := s;
end;


procedure TfrmEdit.btnFileTypeClick(Sender: TObject);
var
    s : string;
begin
    s := frmFileTypes.getType;
    if (s='') then EXIT;

    cbxType.Text := s;
end;

procedure TfrmEdit.btnSaveClick(Sender: TObject);
var
    i : integer;
    name, suffix, f : string;
begin


    if (filename <> '') and (txtFolder.Text <> originalFolder) then begin
        deleteFile(filename);
        filename := '';
    end;

    if (filename = '') then begin
        f := txtFolder.Text;
        if EndsText('\', f) then begin
            delete(f, length(f), 1);
        end;
        f := TPath.GetFileName(f);
        name := TPath.Combine(
            ExtractFilePath(Application.ExeName),
            f
        );
        i := 0;
        repeat
            inc(i);
            suffix := '-'+IntToStr(i) + DATA_EXT;
        until not TFile.Exists(name + suffix);
        name := name + suffix;
    end else begin
        name := filename;
    end;

    save(name);

    self.ModalResult := mrOK;
end;
procedure TfrmEdit.btnTestClick(Sender: TObject);
var
    s : string;
begin
    s := FrmTest.show(self.Command,  self.Folder, self.FileType);
    if (s <> '') then begin
        txtCommand.Text := s;
    end;
end;

procedure TfrmEdit.save(name : string);
var
    ini : TMyIniFile;
begin
    ini := TMyIniFile.Create(name);
    ini.WriteString('FolderInfo',txtFolder.name, txtFolder.text);
    ini.WriteString('FolderInfo',cbxType.Name, cbxType.Text);
    ini.WriteInteger('Event',cbxEvent.Name, cbxEvent.ItemIndex);
    ini.WriteInteger('Action',cbxAction.Name, cbxAction.ItemIndex);
    ini.WriteString('Action',txtCommand.Name, txtCommand.text);
    ini.WriteBool('Misc','enabled',fEnabled);
    ini.UpdateFile;
    ini.Free
end;
procedure TfrmEdit.Button2Click(Sender: TObject);
begin
    self.ModalResult := mrCancel;
end;

procedure TfrmEdit.MIClick(Sender: TObject);
begin
    txtCommand.Text := TMenuItem(Sender).Hint;
end;

procedure TfrmEdit.txtCommandChange(Sender: TObject);
begin
    btnTest.Enabled := not IsExplorerCommand;
end;

procedure TfrmEdit.txtFolderChange(Sender: TObject);
begin
    btnSave.Enabled := DirectoryExists(txtFolder.Text);
end;


end.
