unit UnitFolderMonitor;

//
// Watch a folder for file change / new file notification
//
interface

uses Windows, Classes, SysUtils, Messages, VCL.Dialogs;

type
TFolderMonitor = class;
TFolderMonitorThread = class(TThread)
    protected
        h : THandle;
        folder : string;
        fOnChange : TNotifyEvent;
        fFolderMonitor : TFolderMonitor;
        ftriggered : boolean;
    public
        procedure Execute; override;
        property triggered : boolean read ftriggered write ftriggered;
end;
TFolderMonitor = class(TObject)
    protected
        folder : string;
        thread : TFolderMonitorThread;
        fOnChange : TNotifyEvent;

        procedure setOnChange(value : TNotifyEvent);
        function getOnChange : TNotifyEvent;
        procedure TerminatedCallback(Sender : TObject);
    public
        procedure MonitorFolder(f : string);
        procedure Cancel;
    property
        OnChange :  TNotifyEvent read getOnChange write setOnChange;
end;


var FolderMonitor : TFolderMonitor;

implementation


procedure TFolderMonitor.setOnChange(value : TNotifyEvent);
begin
    fOnChange := value;
    if (thread <> nil) then begin
        thread.fOnChange := value;
    end;
end;
function TFolderMonitor.getOnChange : TNotifyEvent;
begin
    result := fOnChange;
end;

procedure TFolderMonitor.TerminatedCallback(Sender : TObject);
begin
end;

procedure TFolderMonitor.MonitorFolder(f : string);
begin
    f := IncludeTrailingBackslash(f);
    if (f <> '') then begin
        // kill thread and re-create each time

        thread := TFolderMonitorThread.Create(True);
        thread.folder := f;
        self.folder := f;
        thread.fOnChange := self.fOnChange;
        thread.fFolderMonitor := self;
        thread.FreeOnTerminate := true;
//        thread.OnTerminate := TerminatedCallback;
        thread.Start;
    end;
end;
procedure TFolderMonitor.Cancel;
begin
    if (thread <> nil) then  begin
        try
            thread.Terminate;
        except on e: Exception do begin
            //FrmDebug.AppendLog('FoderMonitor.Cancel - exception: ' + e.message);
        end;
        end;

    end;
end;


procedure TFolderMonitorThread.Execute;
var c : Cardinal;
    i : integer;


    procedure followLinks;
    const STRING_SIZE = 512;
    var
        h : THandle;
        TargetName: array [0..STRING_SIZE] of Char;
    begin
        h := CreateFile(PChar(folder), 0, FILE_SHARE_READ, nil, OPEN_EXISTING, FILE_FLAG_BACKUP_SEMANTICS, 0);

        try
            if GetFinalPathNameByHandle(h, TargetName, STRING_SIZE, FILE_NAME_NORMALIZED) > 0 then begin
                folder := TargetName;
            end;
        finally
            CloseHandle(h);
        end;
    end;
begin
//    FrmDebug.AppendLog('FolderMonitor: start');
    repeat
        triggered := false;

        followLinks;
        h := INVALID_HANDLE_VALUE;
        i := 0;
        while (h = INVALID_HANDLE_VALUE) do begin
            h := FindFirstChangeNotification(
                pchar(folder),
                false,
                {FILE_NOTIFY_CHANGE_ATTRIBUTES or} FILE_NOTIFY_CHANGE_FILE_NAME or
                FILE_NOTIFY_CHANGE_LAST_WRITE or FILE_NOTIFY_CHANGE_CREATION
            );
            inc(i);
            if (i=10) then BREAK;
            sleep(100);
        end;

        if (h = INVALID_HANDLE_VALUE) then begin
        //        FrmDebug.AppendLog('FolderMonitor: Unable to monitor folder');
        end else begin
            repeat
                c := WaitForSingleObject(h, 1000);
            until (c <> WAIT_TIMEOUT) or self.Terminated;
            FindCloseChangeNotification(h);

            triggered := not self.Terminated;
            if (triggered) then begin
                if assigned(fonChange) then begin
                    Synchronize(
                        procedure
                        begin
                            fonChange(fFolderMonitor)
                        end
                    );
                end;
            end;
        end;
    until self.Terminated;
end;

initialization
begin

end;

end.
