unit UnitFileChanges;



interface

uses UnitFolderMonitor, Generics.Collections, WinAPI.Windows, SysUtils;
type
TFileChangesList = TList<string>;
TFileWatchedData = record
    lastWrite : _FILETIME;
end;
TFileDataList = TList<TFileWatchedData>;

type TFileChangesMonitor = class(TFolderMonitor)
    protected
        fileList : TFileChangesList;
        fileData : TFileDataList;

        fExtensionMask : string;
        fName  : string;
        fWatchAttributes : boolean;
        fNewFiles : boolean;
        function getFileList : TFileChangesList;
        function getDataList(files : TFileChangesList) : TFileDataList;
        procedure TerminatedCallback(Sender : TObject);
    public
        procedure setName(caption : string);
        function getName : string;

        procedure MonitorFolder(
            f : string; extensionMask : string;
            watchAttributes : boolean = false;
            watchNewFiles : boolean = true
        );
        function GetNewFiles : TFileChangesList;
        function GetChangedFiles : TFileChangesList;
        procedure resetAllFileLists;

        function watchingAttributes : boolean;
        function watchingNewFiles : boolean;


        procedure restart;
end;

implementation

uses IOUtils, Types;


procedure TFileChangesMonitor.TerminatedCallback(Sender : TObject);
begin
    inherited TerminatedCallback(sender);
end;
function TFileChangesMonitor.watchingAttributes : boolean;
begin
    result := fWatchAttributes;
end;
function TFileChangesMonitor.watchingNewFiles : boolean;
begin
    result := fNewFiles;
end;
procedure TFileChangesMonitor.setName(caption : string);
begin
    fName := caption;
end;
function TFileChangesMonitor.getName : string;
begin
    result := fName;
end;
procedure TFileChangesMonitor.MonitorFolder(
    f : string; extensionMask : string;
    watchAttributes : boolean = false; watchNewFiles : boolean = true
);
var
    s : string;
begin
    folder := f;
    fExtensionMask := extensionMask;
    fWatchAttributes := watchAttributes;
    fNewFiles := watchNewFiles;

    if (fExtensionMask = '') then
        fExtensionMask := '*.*';
    if (fileList <> nil) then fileList.Free;
    if (fileData <> nil) then fileData.Free;

    fileList := getFileList;
    if fWatchAttributes then begin
        fileData := getDataList(fileList);
    end;
    inherited MonitorFolder(f);
end;
function TFileChangesMonitor.GetNewFiles : TFileChangesList;
var curList : TFileChangesList;
    s : string;
begin
    result := TFileChangesList.Create;

    curList := getFileList;
    for s in curList do begin
        if fileList.IndexOf(s) <> -1 then CONTINUE;
        result.Add(s)
    end;
    curList.Free;
end;
function TFileChangesMonitor.GetChangedFiles : TFileChangesList;
var
    curData : TFileDataList;
    curList : TFileChangesList;
    fwd, fwd2 : TFileWatchedData;
    i, j : integer;
    s : string;
    function equal(f1, f2 : TFileWatchedData) : boolean;
    begin
        result :=
            (fwd.lastWrite.dwLowDateTime = fwd2.lastWrite.dwLowDateTime) and
            (fwd.lastWrite.dwHighDateTime = fwd2.lastWrite.dwHighDateTime);
    end;
begin
    result := TFileChangesList.Create;
    curList := getFileList;
    curData := getDataList(curList);

    if (curList.Count <> curData.Count) then begin
        raise Exception.Create('Damn');
    end;

    j := 0;
    for s in curList do begin
        i := fileList.IndexOf(s);
        if (i = -1) then CONTINUE;
        fwd := fileData.Items[i];

        j := curList.IndexOf(s);
        if (j = -1) then CONTINUE;
        fwd2 := curData.Items[j];

        if not equal(fwd, fwd2) then begin
            result.Add(s);
        end;
    end;
    curList.Free;
    curData.Free;
end;
procedure TFileChangesMonitor.resetAllFileLists;
begin

    if (assigned(filedata)) then fileData.free;

    fileList.free;
    fileList := getFileList;
    if fWatchAttributes then begin
        //filedata.Free;
        filedata := getDataList(fileList);
    end;

end;
procedure TFileChangesMonitor.restart;
begin
    MonitorFolder(folder, fExtensionMask, fWatchAttributes, fNewFiles);
end;

function TFileChangesMonitor.getFileList : TFileChangesList;
var s : string;
    files : TStringDynArray;
begin
    result := TFileChangesList.create;
    files := TDirectory.GetFiles(self.folder, fExtensionMask);
    if (files = nil) or (length(files) = 0) then
        EXIT;

    for s in files do begin
        result.Add(s);
    end;
end;
function TFileChangesMonitor.getDataList(files : TFileChangesList)  : TFileDataList;
    procedure getTimes(filename : string);
    var
        sr : TSearchRec;
        fwd : TFileWatchedData;
    begin
        FindFirst(filename,faAnyFile,sr);
        fwd.lastWrite := sr.FindData.ftLastWriteTime;
        result.Add(fwd);
    end;
var
    s : string;
begin
    result := TFileDataList.Create;

    for s in files do begin
        getTimes(s);
    end;
end;

end.
