unit UnitDummyShellForm;
{
    Purpose:
        Jesus H Christ the shell crap is overly and unnecessarily
        complication. This unit is trying to simplify this stuff and
        not doing a good job of it.
    Updates:
        Support for multiple filenames at once
}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ShlObj, ShellAPI, System.Generics.Collections;



type
    TOnItemBreakEvent = function (const index : integer; const caption : string) : boolean of object;
    TVerbList = TList<string>;
    TContextObject = class(TObject)
    private
        ICM3 : ICOntextMenu3;

        verbs : TVerbList;
        verbCaption : string;
        verbIndex : integer;
        verbFound : boolean;

        Desk, Folder : IShellFolder;
        function assignFiles(FileNames : array of string) : IContextMenu3;
        procedure enumerateMenu(OnItemBreak : TOnItemBreakEvent);
        function SaveVerbs(const index : integer; const caption : string) : boolean;
        function FindVerb(const index : integer; const caption : string) : boolean;
    public
        constructor Create(FileNames : array of string);

        procedure HandleMeasureItem(var msg : TWMMeasureItem);
        procedure HandeDrawItem(var msg : TWMDrawItem);
        procedure HandleInitMenuPopup(var Msg : TWMInitMenuPopup);

        function getVerbs : TVerbList;
        function executeVerb(const handle : THandle;const verb : string) : boolean;
    end;
  TFrmDummyShellForm = class(TForm)
  private
    { Private declarations }
    context : TContextObject;
    procedure WMInitMenuPopup(var Msg : TWMInitMenuPopup); message WM_INITMENUPOPUP;
    procedure WMDrawItem(var msg : TWMDrawItem); message WM_DRAWITEM;
    procedure WMeasureItem(var msg : TWMMeasureItem); message WM_MEASUREITEM;

  public
    { Public declarations }
    function getVerbs(const filenames : array of string) : TVerbList;
    procedure executeVerb(const filenames : array of string; const verb : string);
  end;

var
  FrmDummyShellForm: TFrmDummyShellForm;

{////////////////////}
{//}implementation{//}
{////////////////////}

uses Menus, ActiveX, ComObj;
const  IID_IContextMenu3: TGUID = (D1: $BCFCE0A0; D2: $EC17; D3: $11D0; D4: ($8D, $10, $00, $A0, $C9, $0F, $27, $19));


{$R *.dfm}

constructor TContextObject.Create(FileNames : array of string);
begin
    verbs := TVerbList.Create;
    icm3 := assignFiles(FileNames);

end;
function TContextObject.assignFiles(FileNames : array of string) : IContextMenu3;
var
    tokIndex : Cardinal;
    Count, Attr: Cardinal;
    Path, WFileName : string;
    ICM1 : IContextMenu;
    pidl: array of PItemIDList;
begin
    result := nil;
    if FAILED(SHGetDesktopFolder(Desk)) then EXIT;
    if length(filenames) = 0 then EXIT;

    SetLength(pidl, length(filenames));
    for tokIndex := low(filenames) to high(filenames) do begin
        //
        // the process is diferent for a Folder and a File
        // The idea is the same, use the "Desktop" to file the file or
        // folder object
        Path := ExtractFileDir(filenames[tokIndex]);
        if (Path = filenames[tokIndex]) then begin
            if FAILED(SHGetSpecialFolderLocation(0, CSIDL_DRIVES, pidl[tokIndex])) then EXIT;
            if FAILED(Desk.BindToObject(pidl[tokIndex], nil, IID_IShellFolder, Pointer(Folder))) then EXIT;

            WFileName := filenames[tokIndex];
            if FAILED(Folder.ParseDisplayName(0, nil, PWideChar(WFileName), Count, pidl[tokIndex], Attr)) then EXIT;

        end else begin
            WFileName := ExtractFilePath(filenames[tokIndex]);
            if FAILED(Desk.ParseDisplayName(0, nil, PWideChar(WFileName), Count, pidl[tokIndex], Attr)) then EXIT;
            if FAILED(Desk.BindToObject(pidl[tokIndex], nil, IID_IShellFolder, Pointer(Folder))) then EXIT;

            WFileName := ExtractFileName(filenames[tokIndex]);
            if FAILED(Folder.ParseDisplayName(0, nil, PWideChar(WFileName), Count, pidl[tokIndex], Attr)) then EXIT;
        end;
    end;

    Folder.GetUIObjectOf(0, Length(pidl), pidl[0], IID_IContextMenu, nil, Pointer(ICM1));
    ICM1.QueryInterface(IID_IContextMenu3, pointer(result));
end;
procedure TContextObject.HandleMeasureItem(var msg : TWMMeasureItem);
begin
    if ICM3 = nil then EXIT;

    ICM3.HandleMenuMsg2(msg.msg, msg.IDCtl, Integer(msg.MeasureItemStruct), msg.Result );
end;
procedure TContextObject.HandeDrawItem(var msg : TWMDrawItem);
begin
    if ICM3 = nil then EXIT;

    ICM3.HandleMenuMsg2(msg.Msg, msg.Ctl, Integer(msg.DrawItemStruct), msg.Result );
end;
procedure TContextObject.HandleInitMenuPopup(var Msg : TWMInitMenuPopup);
var m : cardinal;
    menu : HMENU;
    p : smallint;
    r : nativeInt;
begin
    if ICM3 = nil then EXIT;

    m := msg.Msg;
    menu := msg.MenuPopup;
    p := msg.Pos;
    r := msg.Result;

    if (m = WM_INITMENUPOPUP) then begin
        ICM3.HandleMenuMsg2(m, menu, p, r);
    end;
end;

procedure TContextObject.enumerateMenu(OnItemBreak : TOnItemBreakEvent);
var
    menu : HMenu;
    i, j, k : integer;
    caption : string;
begin
    menu := Windows.CreatePopupMenu;
    i := ICM3.QueryContextMenu(menu, 0, 1, $7FFF, CMF_EXPLORE);
    if ResultSeverity(i) <> SEVERITY_SUCCESS  then begin
        i := ICM3.QueryContextMenu(menu, 0, 1, $7FFF, CMF_EXPLORE);
    end;


    j := ResultCode(i)-1;
    repeat
        setlength(caption, MAX_PATH);
        k := ICM3.GetCommandString(j, GCS_VERBW, 0, pansichar(caption), MAX_PATH-1);
        if (k = 0) then begin
            caption := pchar(caption);
            if OnItemBreak(k, caption) then
                BREAK;
        end;
        dec(j);
    until (j = 0);

    DestroyMenu(menu);
end;
function TContextObject.SaveVerbs(const index : integer; const caption : string) : boolean;
begin
    verbs.Add(caption);
    result := false;
end;
function TContextObject.FindVerb(const index : integer; const caption : string) : boolean;
begin
    verbFound := caption = verbCaption;
    if verbFound then
        verbIndex := index;

    result := verbFound;
end;




function TContextObject.getVerbs : TVerbList;
var
    menu : HMenu;
    i, j, k : integer;
    caption : string;

begin
    self.verbs.Clear;
    result := self.verbs;

    enumerateMenu(self.SaveVerbs);
end;
function TContextObject.executeVerb(const handle : THandle; const verb : string) : boolean;
var
    ICI : CMINVOKECOMMANDINFO;
begin
    result := false;

    verbCaption := verb;
    enumerateMenu(FindVerb);
    if (verbFound) then begin
        ici.cbSize := sizeof(CMINVOKECOMMANDINFO);
        ici.fMask := 0;
        ici.hwnd := Handle;
        ici.lpVerb := MAKEINTRESOURCEA(verbIndex - 1);
        ici.lpParameters := NIL;
        ici.lpDirectory := NIL;
        ici.nShow := SW_SHOWNORMAL;
        ici.dwHotKey := 0;
        ici.hIcon := 0;
        ICM3.InvokeCommand(ici);
    end;

    result := verbFound;
end;

//
// To display the "send to" and "open with" dialogs,
// we have to pass these messages to the popup
//
procedure TFrmDummyShellForm.WMeasureItem(var msg : TWMMeasureItem);
begin
    context.HandleMeasureItem(msg);
end;
procedure TFrmDummyShellForm.WMDrawItem(var msg : TWMDrawItem);
begin
    context.HandeDrawItem(msg);
end;
procedure TFrmDummyShellForm.WMInitMenuPopup(var Msg : TWMInitMenuPopup);
begin
    context.HandleInitMenuPopup(msg);
end;



function TFrmDummyShellForm.getVerbs(const filenames : array of string) : TVerbList;
begin
    if context <> nil then
        context.Free;

    context := TContextObject.Create(filenames);
    result := context.getVerbs;
end;
procedure TFrmDummyShellForm.executeVerb(const filenames : array of string; const verb : string);
begin
    if context <> nil then
        context.Free;
    context := TContextObject.Create(filenames);
    context.executeVerb(self.Handle, verb);
end;


initialization
  OleInitialize(nil);

finalization
  OleUninitialize;

end.
