// 去除错误冗余插件
UE.registerUI('plugins_redundant',function(editor,uiName){
	
	//创建按钮
	var btn = new UE.ui.Button({
		name:"plugins_redundant",
		title:"去除错误冗余",
		cssRules :'background-position:-90px -120px;',
		onclick:function () {
			editor.execCommand('plugins_redundant_commands', "all");
		}
	});
	
	var ListenerList = [
		"afterpaste"
		, "plugins_autostyleset_before"
		, "plugins_autostyleset_after"
	];	
	
	editor.addListener(ListenerList[0], function () {
		var auto_format = G_Options["auto_format"];
		if( auto_format["redundant"] ) {
			editor.execCommand("plugins_redundant_commands", ListenerList[0]);
		}
	});
	
	editor.addListener(ListenerList[1], function () {
		var auto_format = G_Options["auto_format"];
		if( auto_format["redundant"] ) {
			editor.execCommand("plugins_redundant_commands", ListenerList[1]);
		}
	});
	
	editor.addListener(ListenerList[2], function () {
		var auto_format = G_Options["auto_format"];
		if( auto_format["redundant"] ) {
			editor.execCommand("plugins_redundant_commands", ListenerList[2]);
		}
	});

	editor.addListener('selectionchange', function () {
		var state = editor.queryCommandState(uiName);
		if (state == -1) {
			btn.setDisabled(true);
			btn.setChecked(false);
		} else {
			btn.setDisabled(false);
			btn.setChecked(state);
		}
	});

		
	return btn;
},5,0);

var plugins_redundant_var_flag=0, plugins_redundant_var_rules=new Array();

UE.commands['plugins_redundant_commands'] = {
	execCommand : function( cmd, onevent ){
		//if(typeof(redundant) == "undefined") { redundant = "";}
		
		if(plugins_redundant_var_flag==0){
			var t_data;
			$.ajaxSetup({async: false});
			$.get(G_Options["format"]["redundantFile"], function(data){
				t_data = data;
			});
			var t_data_split = t_data.split("\n");
			for (i = 0; i < t_data_split.length; i++) {
				if(t_data_split[i].trim().length==0){continue;}	//空行不处理
				if(t_data_split[i].trim().substr(0,2)=="//"){continue;} //以此开头表示注释
				var t_s = t_data_split[i].split("|-|");
				for(j=t_s.length;j<5;j++){
					t_s[j] = "";
				}
				plugins_redundant_var_rules[i] = new Array();
				plugins_redundant_var_rules[i]["substrs"]=t_s[0];
				plugins_redundant_var_rules[i]["replacement"]=t_s[1];
				plugins_redundant_var_rules[i]["rules"]=t_s[2].trim();
				plugins_redundant_var_rules[i]["attributes"]=(t_s[3].trim()=="")?"gim":t_s[3].trim();
				plugins_redundant_var_rules[i]["event"]=(t_s[4].trim()=="")?"plugins_autostyleset_after":t_s[4].trim();
			}
			plugins_conversion_var_flag==1;
		}
		
		var t_html = this.getContent();
		for(var key in plugins_redundant_var_rules){
			if(!(onevent=="all" || onevent==plugins_redundant_var_rules[key]["event"])){continue;}
			rules = plugins_redundant_var_rules[key]["rules"];
			replacement = plugins_redundant_var_rules[key]["replacement"];
			if(rules=="regular"){
				substrs = new RegExp(plugins_redundant_var_rules[key]["substrs"], plugins_redundant_var_rules[key]["attributes"]);
				t_html = t_html.replace(substrs, replacement);
			} else {
				substrs = plugins_redundant_var_rules[key]["substrs"];
				t_html = t_html.replaceAll(substrs, replacement);
			}
		}
		this.setContent(t_html);
		

	},
	queryCommandState : function(){},
	queryCommandValue : function(){}
}