// 简繁体转换插件
UE.registerUI('plugins_conversion_simplified',function(editor,uiName){
	
	//创建按钮
	var btn = new UE.ui.Button({
		name:"plugins_conversion_simplified",
		title:"转换为简体",
		cssRules :'background-position:-30px -120px;',
		onclick:function () {
			editor.execCommand("plugins_conversion_commands", "simplified");
		}
	});
	
	editor.addListener('plugins_autostyleset_after', function () {
		var auto_format = G_Options["auto_format"];
		if(auto_format["conversion"]=="simplified" ) {
			editor.execCommand("plugins_conversion_commands", auto_format["conversion"]);
		}
	});
	
	return btn;
},3,0);
UE.registerUI('plugins_conversion_traditional',function(editor,uiName){
	
	//创建按钮
	var btn = new UE.ui.Button({
		name:"plugins_conversion_traditional",
		title:"转换为繁体",
		cssRules :'background-position:-60px -120px;',
		onclick:function () {
			editor.execCommand("plugins_conversion_commands", "traditional");
		}
	});
	
	editor.addListener('plugins_autostyleset_after', function () {
		var auto_format = G_Options["auto_format"];
		if( auto_format["conversion"]=="traditional" ) {
			editor.execCommand("plugins_conversion_commands", auto_format["conversion"]);
		}
	});
	
	return btn;
},4,0);

var plugins_conversion_var_flag=0, plugins_conversion_var_simplified=new Array(), plugins_conversion_var_traditional=new Array()

UE.commands['plugins_conversion_commands'] = {
	execCommand : function( cmd, conversion ){
		if(typeof(conversion) == "undefined") { conversion = G_Options["auto_format"]["conversion"];}
		if(plugins_conversion_var_flag==0){
			var t_data;
			$.ajaxSetup({async: false});
			$.get(G_Options["format"]["conversionFile"], function(data){
				t_data = data;
			});
			var t_data_split = t_data.split("\n");
			for (i = 0; i < t_data_split.length; i++) {
				var t_s = t_data_split[i].split("|||");
				plugins_conversion_var_traditional[t_s[0].trim()]=t_s[1].trim();
				plugins_conversion_var_simplified[t_s[1].trim()]=t_s[0].trim();
			}
			plugins_conversion_var_flag==1;
		}
		var conversion_content;
		if(conversion=="traditional") {
			conversion_content = plugins_conversion_var_traditional;
		} else {
			conversion_content = plugins_conversion_var_simplified;
		}
		
		var t_html_c = "", t_html_s = this.getContent();
		for(i=0;i<t_html_s.length;i++){
			var str_char = t_html_s.charAt(i);
			if( typeof(conversion_content[str_char]) == "undefined" ) {
				t_html_c += str_char;
			} else {
				t_html_c += conversion_content[str_char];
			}
		}
		this.setContent(t_html_c);

	},
	queryCommandState : function(){},
	queryCommandValue : function(){}
}