/*
 * Decompiled with CFR 0.152.
 */
package net.nlanr.jperf.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.nlanr.jperf.core.IperfSizeUnit;
import net.nlanr.jperf.core.IperfSpeedUnit;
import net.nlanr.jperf.core.IperfThread;
import net.nlanr.jperf.core.Measurement;
import net.nlanr.jperf.core.OutputFormat;
import net.nlanr.jperf.core.TosOption;
import net.nlanr.jperf.ui.FormLayoutBuilder;
import net.nlanr.jperf.ui.FormLayoutColumn;
import net.nlanr.jperf.ui.JPerfAboutPanel;
import net.nlanr.jperf.ui.XJIntegerSpinner;
import net.nlanr.jperf.ui.chart.IPerfChartPanel;
import net.nlanr.jperf.ui.chart.SeriesColorGenerator;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;

public class JPerfUI
extends JFrame
implements ActionListener,
KeyListener,
ChangeListener,
WindowListener {
    private JPerfAboutPanel aboutPanel;
    private JMenuBar menuBar;
    private JMenu menu;
    private JMenuItem menuItem;
    private JSplitPane centerPanel;
    private JTabbedPane tabbedPane;
    private JScrollPane outputScrollPane;
    private JTextArea output;
    private JTextField iperfCommandLabel;
    private JRadioButton serverModeRadioButton;
    private JRadioButton clientModeRadioButton;
    private JCheckBox lb_clientLimit;
    private JLabel lb_serverAddress;
    private JLabel lb_serverPort;
    private JLabel lb_listenPort;
    private JLabel lb_simultaneousConnectionsNumber;
    private JLabel lb_connectionsLimitNumber;
    private JTextField serverAddress;
    private JTextField clientLimit;
    private XJIntegerSpinner serverPort;
    private XJIntegerSpinner listenPort;
    private XJIntegerSpinner simultaneousConnectionsNumber;
    private XJIntegerSpinner connectionsLimitNumber;
    private JButton startIperf;
    private JButton stopIperf;
    private JButton restoreDefaults;
    private JRadioButton tcpRadioButton;
    private JRadioButton udpRadioButton;
    private JCheckBox lb_tcpBufferLength;
    private XJIntegerSpinner tcpBufferLength;
    private JComboBox tcpBufferSizeUnit;
    private JCheckBox lb_tcpWindowSize;
    private XJIntegerSpinner tcpWindowSize;
    private JComboBox tcpWindowSizeUnit;
    private JCheckBox lb_mss;
    private XJIntegerSpinner mss;
    private JComboBox mssUnit;
    private JCheckBox lb_udpBufferSize;
    private XJIntegerSpinner udpBufferSize;
    private JComboBox udpBufferSizeUnit;
    private JCheckBox lb_udpPacketSize;
    private XJIntegerSpinner udpPacketSize;
    private JComboBox udpPacketSizeUnit;
    private JLabel lb_udpBandwidth;
    private XJIntegerSpinner udpBandwidth;
    private JComboBox udpBandwidthUnit;
    private JCheckBox tcpNoDelay;
    private JLabel lb_bindHost;
    private JLabel lb_TTL;
    private JTextField bindhost;
    private XJIntegerSpinner TTL;
    private JComboBox tos;
    private JCheckBox printMSS;
    private JTextField representativeFile;
    private XJIntegerSpinner transmit;
    private JComboBox formatList;
    private XJIntegerSpinner interval;
    private ButtonGroup iperfModeButtonGroup;
    private ButtonGroup protocolButtonGroup;
    private JRadioButton transmitBytesRadioButton;
    private JRadioButton transmitSecondsRadioButton;
    private JCheckBox ipv6;
    private IperfThread iperf;
    private JCheckBox alwaysClearOutput;
    private JButton clearOutputButton;
    private JButton saveOutputButton;
    private JCheckBox compatibilityMode;
    private XJIntegerSpinner testPort;
    private JCheckBox dualMode;
    private JCheckBox tradeMode;
    private JButton browse;
    private float iperfVersion;
    private JToolBar toolbar;
    private JLabel lb_transmit;
    private JLabel lb_tos;
    private JLabel lb_representativeFile;
    private JLabel lb_testingMode;
    private JLabel lb_testPort;
    private JLabel lb_outputFormat;
    private JLabel lb_reportInterval;
    private String options;
    private String version;
    private String iperfCommand;
    private JPanel quickStartPanel = null;
    private JPanel applicationPanel = null;
    private JPanel transportPanel = null;
    private JPanel tcpPanel = null;
    private JPanel udpPanel = null;
    private JPanel ipPanel = null;
    private JPanel outputPanel = null;
    private IPerfChartPanel chartPanel = null;

    public JPerfUI(String string, String string2) {
        super("JPerf 2.0 - Network performance measurement graphical tool");
        this.iperfCommand = string;
        this.version = string2;
        String[] stringArray = string2.split(" ");
        String string3 = stringArray[2].replace('.', '-');
        String[] stringArray2 = string3.split("-");
        this.iperfVersion = new Float(stringArray2[1]).floatValue();
        this.iperfVersion = (float)((double)this.iperfVersion / 10.0);
        this.iperfVersion += new Float(stringArray2[0]).floatValue();
        this.init();
        this.applyDefaultValues();
        this.chartPanel.start();
        this.setDefaultCloseOperation(3);
        this.setSize(970, 700);
        this.setVisible(true);
        this.serverAddress.grabFocus();
    }

    private void applyDefaultValues() {
        this.setServerModeSelected(false);
        this.setClientModeSelected(true);
        this.clientModeRadioButton.doClick();
        this.setUDPOptionsEnabled(false);
        this.setTCPOptionsEnabled(true);
        this.tcpRadioButton.doClick();
        this.serverPort.setValue(5001);
        this.testPort.setValue(5001);
        this.tcpBufferLength.setValue(2);
        this.tcpBufferSizeUnit.setSelectedItem((Object)IperfSizeUnit.MBYTES);
        this.tcpWindowSize.setValue(56);
        this.tcpWindowSizeUnit.setSelectedItem((Object)IperfSizeUnit.KBYTES);
        this.mss.setValue(1);
        this.mssUnit.setSelectedItem((Object)IperfSizeUnit.KBYTES);
        this.udpBufferSize.setValue(41);
        this.udpBufferSizeUnit.setSelectedItem((Object)IperfSizeUnit.KBYTES);
        this.udpPacketSize.setValue(32);
        this.udpPacketSizeUnit.setSelectedItem((Object)IperfSizeUnit.KBYTES);
        this.compatibilityMode.setSelected(true);
        this.compatibilityMode.doClick();
        this.ipv6.setSelected(true);
        this.ipv6.doClick();
        this.dualMode.setSelected(false);
        this.tradeMode.setSelected(false);
    }

    private void setClientModeSelected(boolean bl) {
        this.serverAddress.setEnabled(bl);
        this.lb_serverAddress.setEnabled(bl);
        this.lb_serverPort.setEnabled(bl);
        this.serverPort.setEnabled(bl);
        this.lb_simultaneousConnectionsNumber.setEnabled(bl);
        this.simultaneousConnectionsNumber.setEnabled(bl);
        this.lb_representativeFile.setEnabled((double)this.iperfVersion >= 1.2 && bl);
        this.representativeFile.setEnabled((double)this.iperfVersion >= 1.2 && bl);
        this.browse.setEnabled((double)this.iperfVersion >= 1.2 && bl);
        this.lb_testingMode.setEnabled(!this.compatibilityMode.isSelected() && (double)this.iperfVersion >= 1.7 && bl);
        this.dualMode.setEnabled(!this.compatibilityMode.isSelected() && (double)this.iperfVersion >= 1.7 && bl);
        this.tradeMode.setEnabled(!this.compatibilityMode.isSelected() && (double)this.iperfVersion >= 1.7 && bl);
        this.lb_testPort.setEnabled(!this.compatibilityMode.isSelected() && (double)this.iperfVersion >= 1.7 && bl);
        this.testPort.setEnabled(!this.compatibilityMode.isSelected() && (double)this.iperfVersion >= 1.7 && bl);
    }

    private void setServerModeSelected(boolean bl) {
        this.lb_clientLimit.setEnabled(false);
        this.clientLimit.setEnabled(false);
        this.lb_connectionsLimitNumber.setEnabled(false);
        this.connectionsLimitNumber.setEnabled(false);
        this.lb_transmit.setEnabled(!bl);
        this.transmit.setEnabled(!bl);
        this.transmitSecondsRadioButton.setEnabled(!bl);
        this.transmitBytesRadioButton.setEnabled(!bl);
        this.lb_testingMode.setEnabled(!bl);
        this.dualMode.setEnabled(!bl);
        this.lb_testPort.setEnabled(!bl);
        this.tradeMode.setEnabled(!bl);
        this.testPort.setEnabled(!bl);
        this.lb_representativeFile.setEnabled(!bl);
        this.representativeFile.setEnabled(!bl);
        this.browse.setEnabled(!bl);
        this.lb_udpBandwidth.setEnabled(!bl && this.udpRadioButton.isSelected());
        this.udpBandwidth.setEnabled(!bl && this.udpRadioButton.isSelected());
        this.udpBandwidthUnit.setEnabled(!bl && this.udpRadioButton.isSelected());
        this.lb_tos.setEnabled(!bl);
        this.tos.setEnabled(!bl);
        this.lb_TTL.setEnabled(!bl);
        this.TTL.setEnabled(!bl);
        if ((double)this.iperfVersion >= 1.7) {
            this.lb_clientLimit.setEnabled(bl);
            this.clientLimit.setEnabled(bl);
            this.lb_connectionsLimitNumber.setEnabled(bl);
            this.connectionsLimitNumber.setEnabled(bl);
        }
        this.lb_listenPort.setEnabled(bl);
        this.listenPort.setEnabled(bl);
    }

    private JPanel getQuickStartPanel() {
        if (this.quickStartPanel == null) {
            FormLayoutBuilder formLayoutBuilder = new FormLayoutBuilder(5, new FormLayoutColumn(FormLayoutBuilder.Alignment.left, true));
            this.iperfCommandLabel = new JTextField("");
            this.iperfCommandLabel.setEditable(false);
            formLayoutBuilder.addCell(new JLabel("Iperf command:"));
            formLayoutBuilder.addCell(this.iperfCommandLabel, 5);
            formLayoutBuilder.newLine();
            formLayoutBuilder.addCell(new JLabel("Choose iPerf Mode:"));
            this.clientModeRadioButton = new JRadioButton("Client");
            this.clientModeRadioButton.setOpaque(false);
            this.clientModeRadioButton.setSelected(true);
            this.clientModeRadioButton.setActionCommand("client");
            this.clientModeRadioButton.addActionListener(this);
            this.clientModeRadioButton.setToolTipText("Run Iperf as a client   (command line: -c)");
            formLayoutBuilder.addCell(this.clientModeRadioButton);
            this.lb_serverAddress = new JLabel("Server address");
            this.lb_serverAddress.setOpaque(false);
            this.lb_serverAddress.setToolTipText("Specify what server the Iperf client should connect to   (command line: -c)");
            this.serverAddress = new JTextField(15);
            this.serverAddress.addKeyListener(this);
            this.lb_serverPort = new JLabel("Port");
            this.lb_serverPort.setOpaque(false);
            this.lb_serverPort.setToolTipText("Specify port   (command line: -p)");
            this.serverPort = new XJIntegerSpinner(1, Integer.MAX_VALUE, 5001);
            this.serverPort.addChangeListener(this);
            formLayoutBuilder.addCell(this.lb_serverAddress);
            formLayoutBuilder.addCompositeCell(this.serverAddress, this.lb_serverPort, this.serverPort);
            formLayoutBuilder.newLine();
            formLayoutBuilder.addCell(new JLabel());
            formLayoutBuilder.addCell(new JLabel());
            this.lb_simultaneousConnectionsNumber = new JLabel("Parallel Streams");
            this.lb_simultaneousConnectionsNumber.setOpaque(false);
            this.lb_simultaneousConnectionsNumber.setToolTipText("The number of simultaneous connections to make to the server. Default is 1.   (command line: -P)");
            this.simultaneousConnectionsNumber = new XJIntegerSpinner(1, Integer.MAX_VALUE, 1);
            this.simultaneousConnectionsNumber.addChangeListener(this);
            formLayoutBuilder.addCell(this.lb_simultaneousConnectionsNumber);
            formLayoutBuilder.addCell(this.simultaneousConnectionsNumber);
            formLayoutBuilder.newLine();
            formLayoutBuilder.addEmptyCell();
            this.serverModeRadioButton = new JRadioButton("Server");
            this.serverModeRadioButton.setOpaque(false);
            this.serverModeRadioButton.setActionCommand("server");
            this.serverModeRadioButton.addActionListener(this);
            this.serverModeRadioButton.setToolTipText("Run Iperf as a server   (command line: -s)");
            formLayoutBuilder.addCell(this.serverModeRadioButton);
            this.lb_listenPort = new JLabel("Listen Port");
            this.lb_listenPort.setOpaque(false);
            this.lb_listenPort.setToolTipText("Specify listen port   (command line: -p)");
            this.listenPort = new XJIntegerSpinner(1, Integer.MAX_VALUE, 5001);
            this.listenPort.addChangeListener(this);
            formLayoutBuilder.addCell(this.lb_listenPort);
            this.lb_clientLimit = new JCheckBox("Client Limit");
            this.lb_clientLimit.addActionListener(this);
            this.lb_clientLimit.setOpaque(false);
            this.lb_clientLimit.setToolTipText("Specify a host for Iperf server to only accept connections from");
            this.clientLimit = new JTextField(15);
            this.clientLimit.addKeyListener(this);
            formLayoutBuilder.addCompositeCell(this.listenPort, this.lb_clientLimit, this.clientLimit);
            formLayoutBuilder.newLine();
            formLayoutBuilder.addEmptyCell();
            formLayoutBuilder.addEmptyCell();
            this.lb_connectionsLimitNumber = new JLabel("Num Connections");
            this.lb_connectionsLimitNumber.setOpaque(false);
            this.lb_connectionsLimitNumber.setToolTipText("The number of connections to handle by the server before closing. Default is 0 (handle forever)   (command line: -P)");
            formLayoutBuilder.addCell(this.lb_connectionsLimitNumber);
            this.connectionsLimitNumber = new XJIntegerSpinner(0, Integer.MAX_VALUE, 0);
            this.connectionsLimitNumber.addChangeListener(this);
            formLayoutBuilder.addCell(this.connectionsLimitNumber);
            formLayoutBuilder.newLine();
            this.iperfModeButtonGroup = new ButtonGroup();
            this.iperfModeButtonGroup.add(this.clientModeRadioButton);
            this.iperfModeButtonGroup.add(this.serverModeRadioButton);
            this.quickStartPanel = formLayoutBuilder.getPanel();
            this.quickStartPanel.setOpaque(false);
        }
        return this.quickStartPanel;
    }

    private JPanel getApplicationPanel() {
        if (this.applicationPanel == null) {
            FormLayoutBuilder formLayoutBuilder = new FormLayoutBuilder(3);
            this.compatibilityMode = new JCheckBox("Enable Compatibility Mode");
            formLayoutBuilder.addCell(this.compatibilityMode, 3);
            this.compatibilityMode.setToolTipText("Compatibility mode allows for use with older version of iperf   (command line: -C)");
            this.compatibilityMode.setSelected(false);
            if ((double)this.iperfVersion < 1.7) {
                this.compatibilityMode.setEnabled(false);
            }
            this.compatibilityMode.addActionListener(this);
            formLayoutBuilder.newLine();
            this.lb_transmit = new JLabel("Transmit");
            this.lb_transmit.setToolTipText("Time to transmit, or number of buffers to transmit. Default is 10secs   (command line: -t, -n)");
            this.transmit = new XJIntegerSpinner(0, Integer.MAX_VALUE, 10);
            this.transmit.addChangeListener(this);
            formLayoutBuilder.addCell(this.lb_transmit);
            formLayoutBuilder.addCell(this.transmit);
            formLayoutBuilder.newLine();
            this.transmitBytesRadioButton = new JRadioButton("Bytes");
            this.transmitBytesRadioButton.addActionListener(this);
            this.transmitSecondsRadioButton = new JRadioButton("Seconds");
            this.transmitSecondsRadioButton.addActionListener(this);
            formLayoutBuilder.addEmptyCell();
            formLayoutBuilder.addCompositeCell(this.transmitBytesRadioButton, this.transmitSecondsRadioButton);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.transmitSecondsRadioButton.setSelected(true);
            buttonGroup.add(this.transmitSecondsRadioButton);
            buttonGroup.add(this.transmitBytesRadioButton);
            formLayoutBuilder.newLine();
            this.lb_outputFormat = new JLabel("Output Format");
            this.lb_outputFormat.setToolTipText("Format to print bandwidth numbers in. Adaptive formats choose between kilo- and mega-   (command line: -f)");
            this.formatList = new JComboBox<OutputFormat>(OutputFormat.values());
            this.formatList.addActionListener(this);
            this.formatList.setSelectedItem((Object)OutputFormat.KBITS);
            formLayoutBuilder.addCell(this.lb_outputFormat);
            formLayoutBuilder.addCell(this.formatList);
            formLayoutBuilder.newLine();
            this.lb_reportInterval = new JLabel("Report Interval");
            this.lb_reportInterval.setToolTipText("Sets the interval time (secs) between periodic bandwidth, jitter, and loss reports   (command line: -i)");
            this.interval = new XJIntegerSpinner(1, Integer.MAX_VALUE, 1);
            this.interval.addChangeListener(this);
            formLayoutBuilder.addCell(this.lb_reportInterval);
            formLayoutBuilder.addCompositeCell(this.interval, new JLabel("seconds"));
            formLayoutBuilder.newLine();
            this.lb_testingMode = new JLabel("Testing Mode");
            formLayoutBuilder.addCell(this.lb_testingMode);
            this.dualMode = new JCheckBox("Dual");
            this.dualMode.addActionListener(this);
            this.dualMode.setToolTipText("Cause the server to connect back to the client immediately and run tests simultaneously   (command line: -d)");
            this.tradeMode = new JCheckBox("Trade");
            this.tradeMode.addActionListener(this);
            this.tradeMode.setToolTipText("Cause the server to connect back to the client following termination of the client   (command line: -r)");
            formLayoutBuilder.addCompositeCell(this.dualMode, this.tradeMode);
            formLayoutBuilder.newLine();
            this.lb_testPort = new JLabel("test port");
            this.lb_testPort.setToolTipText("This specifies the port that the server will connect back to the client on   (command line: -L)");
            this.testPort = new XJIntegerSpinner(1, Integer.MAX_VALUE, 5001);
            this.testPort.addChangeListener(this);
            formLayoutBuilder.addEmptyCell();
            formLayoutBuilder.addCompositeCell(this.lb_testPort, this.testPort);
            if ((double)this.iperfVersion < 1.7) {
                this.lb_testingMode.setEnabled(false);
                this.dualMode.setEnabled(false);
                this.tradeMode.setEnabled(false);
                this.lb_testPort.setEnabled(false);
                this.testPort.setEnabled(false);
            }
            formLayoutBuilder.newLine();
            this.lb_representativeFile = new JLabel("Representative File");
            this.lb_representativeFile.setToolTipText("Use a representative stream to measure bandwidth   (command line: -F)");
            formLayoutBuilder.addCell(this.lb_representativeFile);
            this.representativeFile = new JTextField(14);
            this.representativeFile.addKeyListener(this);
            this.browse = new JButton("...");
            this.browse.setPreferredSize(new Dimension(35, 20));
            this.browse.setActionCommand("Browse");
            this.browse.addActionListener(this);
            formLayoutBuilder.addCompositeCell(this.representativeFile, this.browse);
            if ((double)this.iperfVersion < 1.2) {
                this.representativeFile.setEnabled(false);
                this.lb_representativeFile.setEnabled(false);
                this.browse.setEnabled(false);
            }
            formLayoutBuilder.newLine();
            this.printMSS = new JCheckBox("Print MSS");
            this.printMSS.addActionListener(this);
            this.printMSS.setToolTipText("Print out TCP maximum segment size   (command line: -m)");
            this.printMSS.setSelected(false);
            formLayoutBuilder.addCell(this.printMSS);
            formLayoutBuilder.newLine();
            this.applicationPanel = formLayoutBuilder.getPanel();
        }
        return this.applicationPanel;
    }

    private JPanel getTransportPanel() {
        if (this.transportPanel == null) {
            FormLayoutBuilder formLayoutBuilder = new FormLayoutBuilder(1, new FormLayoutColumn(FormLayoutBuilder.Alignment.fill));
            formLayoutBuilder.addCell(new JLabel("Choose the protocol to use"));
            formLayoutBuilder.newLine();
            this.tcpRadioButton = new JRadioButton("TCP");
            this.tcpRadioButton.setSelected(true);
            this.tcpRadioButton.setActionCommand("TCP");
            this.tcpRadioButton.addActionListener(this);
            this.tcpRadioButton.setToolTipText("Use TCP Protocol   (command line: default)");
            formLayoutBuilder.addCell(this.getTCPPanel());
            formLayoutBuilder.newLine();
            this.udpRadioButton = new JRadioButton("UDP");
            this.udpRadioButton.setActionCommand("UDP");
            this.udpRadioButton.addActionListener(this);
            this.udpRadioButton.setToolTipText("Use UDP Protocol   (command line: -u)");
            formLayoutBuilder.addCell(this.getUDPPanel());
            formLayoutBuilder.newLine();
            this.protocolButtonGroup = new ButtonGroup();
            this.protocolButtonGroup.add(this.tcpRadioButton);
            this.protocolButtonGroup.add(this.udpRadioButton);
            this.transportPanel = formLayoutBuilder.getPanel();
        }
        return this.transportPanel;
    }

    private void setTCPOptionsEnabled(boolean bl) {
        this.lb_tcpBufferLength.setEnabled(bl);
        this.tcpBufferLength.setEnabled(bl && this.lb_tcpBufferLength.isSelected());
        this.tcpBufferSizeUnit.setEnabled(bl && this.lb_tcpBufferLength.isSelected());
        this.lb_tcpWindowSize.setEnabled(bl);
        this.tcpWindowSize.setEnabled(bl && this.lb_tcpWindowSize.isSelected());
        this.tcpWindowSizeUnit.setEnabled(bl && this.lb_tcpWindowSize.isSelected());
        this.lb_mss.setEnabled(bl);
        this.mss.setEnabled(bl && this.lb_mss.isSelected());
        this.mssUnit.setEnabled(bl && this.lb_mss.isSelected());
        this.tcpNoDelay.setEnabled(bl);
        this.printMSS.setEnabled(bl);
        this.lb_TTL.setEnabled(!bl);
        this.TTL.setEnabled(!bl);
    }

    private JPanel getTCPPanel() {
        if (this.tcpPanel == null) {
            FormLayoutBuilder formLayoutBuilder = new FormLayoutBuilder(3);
            formLayoutBuilder.addCell(this.tcpRadioButton);
            formLayoutBuilder.newLine();
            this.lb_tcpBufferLength = new JCheckBox("Buffer Length");
            this.lb_tcpBufferLength.setToolTipText("Read/Write buffer length. Use 'K' or 'M' for kilo/mega bytes. (i.e 8K)   (command line: -l)");
            this.lb_tcpBufferLength.addActionListener(this);
            formLayoutBuilder.addCell(this.lb_tcpBufferLength);
            this.tcpBufferLength = new XJIntegerSpinner(1, 9999, 8);
            this.tcpBufferLength.addChangeListener(this);
            formLayoutBuilder.addCell(this.tcpBufferLength);
            this.tcpBufferSizeUnit = new JComboBox<IperfSizeUnit>(IperfSizeUnit.values());
            this.tcpBufferSizeUnit.addActionListener(this);
            this.tcpBufferSizeUnit.setSelectedItem((Object)IperfSizeUnit.KBYTES);
            formLayoutBuilder.addCell(this.tcpBufferSizeUnit);
            formLayoutBuilder.newLine();
            this.lb_tcpWindowSize = new JCheckBox("TCP Window Size");
            this.lb_tcpWindowSize.setToolTipText("Set TCP window size. Use 'K' or 'M' for kilo/mega bytes. (i.e 8K)   (command line: -w)");
            this.lb_tcpWindowSize.addActionListener(this);
            formLayoutBuilder.addCell(this.lb_tcpWindowSize);
            this.tcpWindowSize = new XJIntegerSpinner(1, 9999, 8);
            this.tcpWindowSize.addChangeListener(this);
            formLayoutBuilder.addCell(this.tcpWindowSize);
            this.tcpWindowSizeUnit = new JComboBox<IperfSizeUnit>(IperfSizeUnit.values());
            this.tcpWindowSizeUnit.addActionListener(this);
            this.tcpWindowSizeUnit.setSelectedItem((Object)IperfSizeUnit.KBYTES);
            formLayoutBuilder.addCell(this.tcpWindowSizeUnit);
            formLayoutBuilder.newLine();
            this.lb_mss = new JCheckBox("Max Segment Size");
            this.lb_mss.setToolTipText("Attempt to set max segment size. Use 'K' or 'M' for kilo/mega bytes. (i.e 8K)   (command line: -M)");
            this.lb_mss.addActionListener(this);
            formLayoutBuilder.addCell(this.lb_mss);
            this.mss = new XJIntegerSpinner(1, 9999, 8);
            this.mss.addChangeListener(this);
            formLayoutBuilder.addCell(this.mss);
            this.mssUnit = new JComboBox<IperfSizeUnit>(IperfSizeUnit.values());
            this.mssUnit.addActionListener(this);
            this.mssUnit.setSelectedItem((Object)IperfSizeUnit.KBYTES);
            formLayoutBuilder.addCell(this.mssUnit);
            formLayoutBuilder.newLine();
            this.tcpNoDelay = new JCheckBox("TCP No Delay");
            this.tcpNoDelay.addActionListener(this);
            this.tcpNoDelay.setToolTipText("Disable Nagle's algorithm   (command line: -N)");
            this.tcpNoDelay.setSelected(false);
            formLayoutBuilder.addCell(this.tcpNoDelay);
            formLayoutBuilder.newLine();
            this.tcpPanel = formLayoutBuilder.getPanel();
            this.tcpPanel.setBorder(new TitledBorder(""));
        }
        return this.tcpPanel;
    }

    private void setUDPOptionsEnabled(boolean bl) {
        this.lb_udpBufferSize.setEnabled(bl);
        this.udpBufferSize.setEnabled(bl && this.lb_udpBufferSize.isSelected());
        this.udpBufferSizeUnit.setEnabled(bl && this.lb_udpBufferSize.isSelected());
        this.lb_udpPacketSize.setEnabled(bl);
        this.udpPacketSize.setEnabled(bl && this.lb_udpPacketSize.isSelected());
        this.udpPacketSizeUnit.setEnabled(bl && this.lb_udpPacketSize.isSelected());
        this.lb_udpBandwidth.setEnabled(!this.serverModeRadioButton.isSelected() && bl);
        this.udpBandwidth.setEnabled(!this.serverModeRadioButton.isSelected() && bl);
        this.udpBandwidthUnit.setEnabled(!this.serverModeRadioButton.isSelected() && bl);
        this.lb_TTL.setEnabled(!this.serverModeRadioButton.isSelected() && bl);
        this.TTL.setEnabled(!this.serverModeRadioButton.isSelected() && bl);
    }

    private JPanel getUDPPanel() {
        if (this.udpPanel == null) {
            FormLayoutBuilder formLayoutBuilder = new FormLayoutBuilder(3, new FormLayoutColumn(FormLayoutBuilder.Alignment.fill));
            formLayoutBuilder.addCell(this.udpRadioButton);
            formLayoutBuilder.newLine();
            this.lb_udpBandwidth = new JLabel("UDP Bandwidth");
            this.lb_udpBandwidth.setToolTipText("Set bandwidth to send in bits/sec. Use 'K' or 'M' for kilo/mega bits. (i.e 8K)   (command line: -b)");
            formLayoutBuilder.addCell(this.lb_udpBandwidth);
            this.udpBandwidth = new XJIntegerSpinner(1, 9999, 1);
            this.udpBandwidth.addChangeListener(this);
            formLayoutBuilder.addCell(this.udpBandwidth);
            this.udpBandwidthUnit = new JComboBox<IperfSpeedUnit>(IperfSpeedUnit.values());
            this.udpBandwidthUnit.addActionListener(this);
            this.udpBandwidthUnit.setSelectedItem((Object)IperfSpeedUnit.MEGABYTES_PERSEC);
            formLayoutBuilder.addCell(this.udpBandwidthUnit);
            formLayoutBuilder.newLine();
            this.lb_udpBufferSize = new JCheckBox("UDP Buffer Size");
            this.lb_udpBufferSize.setToolTipText("Set UDP buffer size. Use 'K' or 'M' for kilo/mega bytes. (i.e 8K)   (command line: -w)");
            this.lb_udpBufferSize.addActionListener(this);
            formLayoutBuilder.addCell(this.lb_udpBufferSize);
            this.udpBufferSize = new XJIntegerSpinner(1, 9999, 8);
            this.udpBufferSize.addChangeListener(this);
            formLayoutBuilder.addCell(this.udpBufferSize);
            this.udpBufferSizeUnit = new JComboBox<IperfSizeUnit>(IperfSizeUnit.values());
            this.udpBufferSizeUnit.addActionListener(this);
            this.udpBufferSizeUnit.setSelectedItem((Object)IperfSizeUnit.KBYTES);
            formLayoutBuilder.addCell(this.udpBufferSizeUnit);
            formLayoutBuilder.newLine();
            this.lb_udpPacketSize = new JCheckBox("UDP Packet Size");
            this.lb_udpPacketSize.setToolTipText("Set UDP datagram buffer size. Use 'K' or 'M' for kilo/mega bytes. (i.e 1470)   (command line: -l)");
            this.lb_udpPacketSize.addActionListener(this);
            formLayoutBuilder.addCell(this.lb_udpPacketSize);
            this.udpPacketSize = new XJIntegerSpinner(1, 9999, 1470);
            this.udpPacketSize.addChangeListener(this);
            formLayoutBuilder.addCell(this.udpPacketSize);
            this.udpPacketSizeUnit = new JComboBox<IperfSizeUnit>(IperfSizeUnit.values());
            this.udpPacketSizeUnit.addActionListener(this);
            this.udpPacketSizeUnit.setSelectedItem((Object)IperfSizeUnit.KBYTES);
            formLayoutBuilder.addCell(this.udpPacketSizeUnit);
            formLayoutBuilder.newLine();
            this.udpPanel = formLayoutBuilder.getPanel();
            this.udpPanel.setBorder(new TitledBorder(""));
        }
        return this.udpPanel;
    }

    private JPanel getIPPanel() {
        if (this.ipPanel == null) {
            FormLayoutBuilder formLayoutBuilder = new FormLayoutBuilder(2);
            this.lb_TTL = new JLabel("TTL");
            this.lb_TTL.setToolTipText("Set time to live (number of hops). Default is 1.   (command line: -T)");
            formLayoutBuilder.addCell(this.lb_TTL);
            this.TTL = new XJIntegerSpinner(0, Integer.MAX_VALUE, 1);
            this.TTL.addChangeListener(this);
            formLayoutBuilder.addCell(this.TTL);
            formLayoutBuilder.newLine();
            this.lb_tos = new JLabel("Type of Service");
            this.lb_tos.setToolTipText("The type-of-service for outgoing packets. (Many routers ignore the TOS field)   (command line: -S)");
            formLayoutBuilder.addCell(this.lb_tos);
            this.tos = new JComboBox<TosOption>(TosOption.values());
            this.tos.addActionListener(this);
            this.tos.setSelectedItem((Object)TosOption.NONE);
            formLayoutBuilder.addCell(this.tos);
            formLayoutBuilder.newLine();
            this.lb_bindHost = new JLabel("Bind to Host");
            this.lb_bindHost.setToolTipText("Bind to host, one of this machine's addresses. For multihomed hosts.   (command line: -B)");
            formLayoutBuilder.addCell(this.lb_bindHost);
            this.bindhost = new JTextField(18);
            this.bindhost.addKeyListener(this);
            formLayoutBuilder.addCell(this.bindhost);
            formLayoutBuilder.newLine();
            this.ipv6 = new JCheckBox("IPv6");
            formLayoutBuilder.addCell(this.ipv6);
            this.ipv6.setToolTipText("Bind to an IPv6 address   (command line: -V)");
            this.ipv6.setSelected(false);
            if ((double)this.iperfVersion < 1.6) {
                this.ipv6.setEnabled(false);
            }
            this.ipv6.addActionListener(this);
            formLayoutBuilder.newLine();
            this.ipPanel = formLayoutBuilder.getPanel();
        }
        return this.ipPanel;
    }

    public void init() {
        this.addWindowListener(this);
        this.setLayout(new BorderLayout());
        this.menuBar = new JMenuBar();
        this.menu = new JMenu("Help");
        this.menu.setMnemonic(72);
        this.menuItem = new JMenuItem("About...");
        this.menuItem.setActionCommand("About");
        this.menuItem.addActionListener(this);
        this.menu.add(this.menuItem);
        this.menuBar.add(this.menu);
        this.setJMenuBar(this.menuBar);
        this.toolbar = new JToolBar(0);
        this.toolbar.setFloatable(false);
        this.toolbar.add(this.getQuickStartPanel());
        this.startIperf = new JButton(new ImageIcon(JPerfUI.class.getResource("start.png")));
        this.startIperf.setToolTipText("Run Iperf!");
        this.startIperf.setActionCommand("Run");
        this.startIperf.addActionListener(this);
        this.stopIperf = new JButton(new ImageIcon(JPerfUI.class.getResource("stop.png")));
        this.stopIperf.setToolTipText("Stop Iperf");
        this.stopIperf.setActionCommand("Stop");
        this.stopIperf.addActionListener(this);
        this.stopIperf.setEnabled(false);
        this.restoreDefaults = new JButton(new ImageIcon(JPerfUI.class.getResource("restore-default-settings.png")));
        this.restoreDefaults.setToolTipText("Restore default settings");
        this.restoreDefaults.setActionCommand("Restore");
        this.restoreDefaults.addActionListener(this);
        this.toolbar.add(this.startIperf);
        this.toolbar.add(this.stopIperf);
        this.toolbar.add(this.restoreDefaults);
        this.add((Component)this.toolbar, "First");
        JXTaskPaneContainer jXTaskPaneContainer = new JXTaskPaneContainer();
        JXTaskPane jXTaskPane = new JXTaskPane();
        jXTaskPane.setAnimated(true);
        jXTaskPane.setTitle("Application layer options");
        jXTaskPane.add((Component)this.getApplicationPanel());
        JXTaskPane jXTaskPane2 = new JXTaskPane();
        jXTaskPane2.setAnimated(true);
        jXTaskPane2.setTitle("Transport layer options");
        jXTaskPane2.add((Component)this.getTransportPanel());
        JXTaskPane jXTaskPane3 = new JXTaskPane();
        jXTaskPane3.setAnimated(true);
        jXTaskPane3.setTitle("IP layer options");
        jXTaskPane3.add((Component)this.getIPPanel());
        jXTaskPaneContainer.add(jXTaskPane);
        jXTaskPaneContainer.add(jXTaskPane2);
        jXTaskPaneContainer.add(jXTaskPane3);
        jXTaskPaneContainer.setScrollableTracksViewportHeight(true);
        jXTaskPaneContainer.setScrollableTracksViewportWidth(true);
        JScrollPane jScrollPane = new JScrollPane((Component)jXTaskPaneContainer);
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.add((Component)jScrollPane, "West");
        this.centerPanel = new JSplitPane(0);
        this.centerPanel.setLeftComponent(this.getGraphPanel());
        this.centerPanel.setRightComponent(this.getOutputPanel());
        this.centerPanel.setDividerLocation(300);
        this.centerPanel.setResizeWeight(1.0);
        this.centerPanel.setOneTouchExpandable(true);
        this.add((Component)this.centerPanel, "Center");
        this.createAbout();
    }

    public void logMessage(String string) {
        this.output.append(string + "\n");
        this.output.setCaretPosition(this.output.getDocument().getLength());
    }

    public void addNewStreamBandwidthMeasurement(int n, Measurement measurement) {
        this.chartPanel.maybeAddNewSeries("" + n, "#" + n + ": ", "Jitter: ", SeriesColorGenerator.nextColor());
        this.chartPanel.addSeriesBandwidthMeasurement("" + n, measurement);
    }

    public void addNewStreamBandwidthAndJitterMeasurement(int n, Measurement measurement, Measurement measurement2) {
        this.chartPanel.maybeAddNewSeries("" + n, "#" + n + ": ", "Jitter: ", SeriesColorGenerator.nextColor());
        this.chartPanel.addSeriesBandwidthAndJitterMeasurement("" + n, measurement, measurement2);
    }

    public void setStartedStatus() {
        this.startIperf.setEnabled(false);
        this.stopIperf.setEnabled(true);
    }

    public void setStoppedStatus() {
        this.stopIperf.setEnabled(false);
        this.startIperf.setEnabled(true);
    }

    private JPanel getGraphPanel() {
        if (this.chartPanel == null) {
            this.chartPanel = new IPerfChartPanel("Bandwidth", "KBits", "ms", "Time", "Bandwidth", "Jitter", 1.0, 20.0, 1.0, Color.black, Color.white, Color.gray);
        }
        return this.chartPanel;
    }

    private JPanel getOutputPanel() {
        if (this.outputPanel == null) {
            this.outputPanel = new JPanel(new BorderLayout());
            this.tabbedPane = new JTabbedPane();
            this.output = new JTextArea();
            this.output.setWrapStyleWord(false);
            this.outputScrollPane = new JScrollPane(this.output);
            this.tabbedPane.addTab("Output", null, this.outputScrollPane, "Iperf Output");
            this.outputPanel.add((Component)this.tabbedPane, "Center");
            JPanel jPanel = new JPanel(new FlowLayout(1));
            this.clearOutputButton = new JButton("Clear now");
            this.clearOutputButton.setActionCommand("Clear");
            this.clearOutputButton.addActionListener(this);
            this.clearOutputButton.setToolTipText("Clears output from Iperf run");
            this.saveOutputButton = new JButton("Save");
            this.saveOutputButton.setActionCommand("Save");
            this.saveOutputButton.addActionListener(this);
            this.saveOutputButton.setToolTipText("Save output to a file");
            this.alwaysClearOutput = new JCheckBox("Clear Output for new Iperf Run");
            this.alwaysClearOutput.setToolTipText("Always clear Iperf output between runs.");
            this.alwaysClearOutput.setSelected(false);
            jPanel.add(this.saveOutputButton);
            jPanel.add(this.clearOutputButton);
            jPanel.add(this.alwaysClearOutput);
            this.outputPanel.add((Component)jPanel, "South");
        }
        return this.outputPanel;
    }

    public void updateIperfCommandLabel() {
        try {
            this.validateFormOptions();
            this.iperfCommandLabel.setForeground(Color.black);
            this.iperfCommandLabel.setText(this.options);
        }
        catch (Exception exception) {
            this.iperfCommandLabel.setForeground(Color.red);
            this.iperfCommandLabel.setText(exception.getMessage());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ipv6) {
            if (this.ipv6.isSelected()) {
                if (this.udpRadioButton.isSelected()) {
                    this.udpBufferSize.setValue(1450);
                }
            } else if (this.udpRadioButton.isSelected()) {
                this.udpBufferSize.setValue(1470);
            }
        } else if (object == this.compatibilityMode) {
            if (this.compatibilityMode.isSelected()) {
                this.lb_testingMode.setEnabled(false);
                this.dualMode.setEnabled(false);
                this.tradeMode.setEnabled(false);
                this.lb_testPort.setEnabled(false);
                this.testPort.setEnabled(false);
            } else if (!this.serverModeRadioButton.isSelected()) {
                this.lb_testingMode.setEnabled(true);
                this.dualMode.setEnabled(true);
                this.tradeMode.setEnabled(true);
                this.lb_testPort.setEnabled(true);
                this.testPort.setEnabled(true);
            }
        } else if (object == this.lb_tcpBufferLength) {
            this.tcpBufferLength.setEnabled(this.lb_tcpBufferLength.isSelected());
            this.tcpBufferSizeUnit.setEnabled(this.lb_tcpBufferLength.isSelected());
        } else if (object == this.lb_tcpWindowSize) {
            this.tcpWindowSize.setEnabled(this.lb_tcpWindowSize.isSelected());
            this.tcpWindowSizeUnit.setEnabled(this.lb_tcpWindowSize.isSelected());
        } else if (object == this.lb_mss) {
            this.mss.setEnabled(this.lb_mss.isSelected());
            this.mssUnit.setEnabled(this.lb_mss.isSelected());
        } else if (object == this.lb_udpBufferSize) {
            this.udpBufferSize.setEnabled(this.lb_udpBufferSize.isSelected());
            this.udpBufferSizeUnit.setEnabled(this.lb_udpBufferSize.isSelected());
        } else if (object == this.lb_udpPacketSize) {
            this.udpPacketSize.setEnabled(this.lb_udpPacketSize.isSelected());
            this.udpPacketSizeUnit.setEnabled(this.lb_udpPacketSize.isSelected());
        } else {
            JFileChooser jFileChooser;
            int n;
            String string = actionEvent.getActionCommand();
            if (string == "Restore") {
                this.applyDefaultValues();
            } else if (string == "TCP") {
                this.setUDPOptionsEnabled(false);
                this.setTCPOptionsEnabled(true);
            } else if (string == "UDP") {
                this.setTCPOptionsEnabled(false);
                this.setUDPOptionsEnabled(true);
            } else if (string == "Run") {
                boolean bl = false;
                try {
                    bl = this.validateFormOptions();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, exception.getMessage(), "Error", 0);
                    return;
                }
                OutputFormat outputFormat = (OutputFormat)((Object)this.formatList.getSelectedItem());
                if (outputFormat == OutputFormat.ADAPTIVE_BITS || outputFormat == OutputFormat.ADAPTIVE_BYTES) {
                    JOptionPane.showMessageDialog(this, "The bandwidth graph will not be created because an adaptive format is selected", "Information", 1);
                }
                if (bl) {
                    this.chartPanel.reconfigure(this.serverModeRadioButton.isSelected(), this.serverModeRadioButton.isSelected() ? "Bandwidth & Jitter" : "Bandwidth", this.formatList.getSelectedItem().toString(), "ms", this.transmitSecondsRadioButton.isSelected() ? "Time (sec)" : "Bytes transmitted", this.formatList.getSelectedItem().toString() + " (BW)", "ms (Jitter)", this.transmit.getValue().intValue(), this.interval.getValue().intValue());
                    if (this.alwaysClearOutput.isSelected()) {
                        this.output.setText("");
                    }
                    this.iperf = new IperfThread(this.serverModeRadioButton.isSelected(), this.options, this);
                    this.iperf.start();
                }
            } else if (string == "Stop") {
                this.iperf.quit();
            } else if (string == "Clear") {
                this.iperf.quit();
                this.output.setText("");
            } else if (string == "server") {
                this.setClientModeSelected(false);
                this.setServerModeSelected(true);
            } else if (string == "client") {
                this.setServerModeSelected(false);
                this.setClientModeSelected(true);
            } else if (string == "About") {
                JOptionPane.showMessageDialog(this, this.aboutPanel);
            } else if (string == "Browse") {
                JFileChooser jFileChooser2 = new JFileChooser();
                int n2 = jFileChooser2.showDialog(this, "Select representative file");
                if (n2 == 0) {
                    File file = jFileChooser2.getSelectedFile();
                    this.representativeFile.setText(file.getAbsolutePath());
                }
            } else if (string == "Save" && (n = (jFileChooser = new JFileChooser()).showDialog(this, "Save")) == 0) {
                File file = jFileChooser.getSelectedFile();
                String string2 = new String(this.output.getText());
                try {
                    FileWriter fileWriter = new FileWriter(file);
                    fileWriter.write(string2);
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, "Error while saving output: " + iOException.getMessage(), "Error", 0);
                }
            }
        }
        this.updateIperfCommandLabel();
    }

    private boolean validateFormOptions() throws Exception {
        this.options = this.iperfCommand;
        if (this.serverModeRadioButton.isSelected()) {
            this.options = this.options + " -s";
            if (this.clientLimit.getText().length() > 0 && this.lb_clientLimit.isSelected()) {
                this.options = this.options + " -c " + this.clientLimit.getText();
            }
        } else if (this.serverAddress.getText().length() > 0) {
            this.options = this.options + " -c " + this.serverAddress.getText();
        } else {
            this.serverAddress.grabFocus();
            throw new Exception("Please enter the host to connect to");
        }
        if (this.udpRadioButton.isSelected()) {
            this.options = this.options + " -u";
        }
        if (this.simultaneousConnectionsNumber.isEnabled()) {
            this.options = this.options + " -P " + this.simultaneousConnectionsNumber.getValue();
        } else if (this.connectionsLimitNumber.isEnabled()) {
            this.options = this.options + " -P " + this.connectionsLimitNumber.getValue();
        }
        this.options = this.options + " -i " + this.interval.getValue();
        if (this.printMSS.isSelected() && this.printMSS.isEnabled()) {
            this.options = this.options + " -m";
        }
        if (this.serverPort.isEnabled()) {
            this.options = this.options + " -p " + this.serverPort.getValue();
        } else if (this.listenPort.isEnabled()) {
            this.options = this.options + " -p " + this.listenPort.getValue();
        }
        if (this.lb_tcpWindowSize.isSelected() && this.tcpWindowSize.isEnabled()) {
            this.options = this.options + " -w " + this.tcpWindowSize.getValue() + ((IperfSizeUnit)((Object)this.tcpWindowSizeUnit.getSelectedItem())).getShortcut();
        } else if (this.lb_udpBufferSize.isSelected() && this.udpBufferSize.isEnabled()) {
            this.options = this.options + " -w " + this.udpBufferSize.getValue() + ((IperfSizeUnit)((Object)this.udpBufferSizeUnit.getSelectedItem())).getShortcut();
        }
        if (this.bindhost.getText().length() > 0) {
            this.options = this.options + " -B " + this.bindhost.getText();
        }
        if (this.lb_mss.isSelected() && this.mss.isEnabled()) {
            this.options = this.options + " -M " + this.mss.getValue() + ((IperfSizeUnit)((Object)this.mssUnit.getSelectedItem())).getShortcut();
        }
        if (this.tcpNoDelay.isSelected() && this.tcpNoDelay.isEnabled()) {
            this.options = this.options + " -N";
        }
        if (this.ipv6.isSelected() && this.ipv6.isEnabled()) {
            this.options = this.options + " -V";
        }
        if (this.lb_tcpBufferLength.isSelected() && this.tcpBufferLength.isEnabled()) {
            this.options = this.options + " -l " + this.tcpBufferLength.getValue() + ((IperfSizeUnit)((Object)this.tcpBufferSizeUnit.getSelectedItem())).getShortcut();
        } else if (this.lb_udpPacketSize.isSelected() && this.udpPacketSize.isEnabled()) {
            this.options = this.options + " -l " + this.udpPacketSize.getValue() + ((IperfSizeUnit)((Object)this.udpPacketSizeUnit.getSelectedItem())).getShortcut();
        }
        if (this.compatibilityMode.isSelected() && this.compatibilityMode.isEnabled()) {
            this.options = this.options + " -C";
        }
        this.options = this.options + " -f " + ((OutputFormat)((Object)this.formatList.getSelectedItem())).getShortcut();
        if (this.udpBandwidthUnit.isEnabled() && this.udpBandwidth.isEnabled()) {
            this.options = this.options + " -b " + this.udpBandwidth.getValue() + ((IperfSpeedUnit)((Object)this.udpBandwidthUnit.getSelectedItem())).getUnit();
        }
        if (this.transmit.isEnabled()) {
            if (this.transmitBytesRadioButton.isSelected()) {
                this.options = this.options + " -n " + this.transmit.getValue();
            } else if (this.transmitSecondsRadioButton.isSelected()) {
                this.options = this.options + " -t " + this.transmit.getValue();
            }
        }
        if (this.dualMode.isSelected() && this.dualMode.isEnabled()) {
            this.options = this.options + " -d";
        }
        if (this.tradeMode.isSelected() && this.tradeMode.isEnabled()) {
            this.options = this.options + " -r";
        }
        if ((this.dualMode.isSelected() && this.dualMode.isEnabled() || this.tradeMode.isSelected() && this.tradeMode.isEnabled()) && this.testPort.isEnabled()) {
            this.options = this.options + " -L " + this.testPort.getValue();
        }
        if (this.TTL.isEnabled()) {
            this.options = this.options + " -T " + this.TTL.getValue();
        }
        if ((TosOption)((Object)this.tos.getSelectedItem()) != TosOption.NONE) {
            this.options = this.options + " -S " + ((TosOption)((Object)this.tos.getSelectedItem())).getCode();
        }
        if (this.representativeFile.getText().length() > 0 && this.representativeFile.isEnabled()) {
            File file = new File(this.representativeFile.getText());
            if (!file.exists()) {
                this.representativeFile.grabFocus();
                throw new Exception("The file you selected does not exist");
            }
            this.options = this.options + " -F " + this.representativeFile.getText();
        }
        return true;
    }

    private void createAbout() {
        this.aboutPanel = new JPerfAboutPanel(this.version);
        this.aboutPanel.setPreferredSize(new Dimension(450, 350));
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.updateIperfCommandLabel();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.updateIperfCommandLabel();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.stopIperf.doClick();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

