/*
 * Decompiled with CFR 0.152.
 */
package net.nlanr.jperf.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import net.nlanr.jperf.ui.FormLayoutColumn;

public class FormLayoutBuilder {
    private ArrayList<ArrayList<Component>> formLines = new ArrayList();
    private ArrayList<FormLayoutColumn> columnsSpec = new ArrayList();
    private ArrayList<Component> currentLineCells;
    private HashMap<Component, Integer> componentsColSpan = new HashMap();

    public FormLayoutBuilder(int n) {
        this(n, new FormLayoutColumn());
    }

    public FormLayoutBuilder(int n, FormLayoutColumn formLayoutColumn) {
        for (int i = 0; i < n; ++i) {
            this.columnsSpec.add(formLayoutColumn);
        }
    }

    public FormLayoutBuilder(FormLayoutColumn formLayoutColumn, FormLayoutColumn ... formLayoutColumnArray) {
        this.columnsSpec.add(formLayoutColumn);
        for (FormLayoutColumn formLayoutColumn2 : formLayoutColumnArray) {
            this.columnsSpec.add(formLayoutColumn2);
        }
    }

    public void addEmptyCell() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        this.addCell(jPanel, 1);
    }

    public void addCell(Component component) {
        this.addCell(component, 1);
    }

    public void addCompositeCell(Component ... componentArray) {
        FormLayoutBuilder formLayoutBuilder = new FormLayoutBuilder(componentArray.length);
        for (Component component : componentArray) {
            formLayoutBuilder.addCell(component);
        }
        JPanel jPanel = formLayoutBuilder.getPanel();
        jPanel.setOpaque(false);
        this.addCell(jPanel);
    }

    public void addVerticalCompositeCell(Component ... componentArray) {
        FormLayoutBuilder formLayoutBuilder = new FormLayoutBuilder(componentArray.length);
        for (Component component : componentArray) {
            formLayoutBuilder.addCell(component);
            formLayoutBuilder.newLine();
        }
        JPanel jPanel = formLayoutBuilder.getPanel();
        jPanel.setOpaque(false);
        this.addCell(jPanel);
    }

    public void addCell(Component component, int n) {
        if (this.currentLineCells == null) {
            this.newLine();
        }
        this.currentLineCells.add(component);
        this.componentsColSpan.put(component, new Integer(n));
    }

    public void newLine() {
        if (this.currentLineCells != null && this.currentLineCells.size() != 0) {
            this.formLines.add(this.currentLineCells);
            this.currentLineCells = null;
        }
        this.currentLineCells = new ArrayList();
    }

    public JPanel getPanel() {
        if (this.currentLineCells != null && this.currentLineCells.size() != 0) {
            this.formLines.add(this.currentLineCells);
            this.currentLineCells = null;
        }
        String string = "";
        for (int i = 1; i <= this.formLines.size(); ++i) {
            string = string + "pref";
            if (i == this.formLines.size()) continue;
            string = string + ",";
            string = string + "2dlu,";
        }
        String string2 = "";
        int n = 0;
        for (FormLayoutColumn object2 : this.columnsSpec) {
            ++n;
            string2 = string2 + object2.alignment.name();
            string2 = object2.width <= 0 ? string2 + ":pref" : string2 + ":" + object2.width + "dlu";
            if (object2.grow) {
                string2 = string2 + ":grow";
            }
            string2 = n < this.columnsSpec.size() ? string2 + ",4dlu" : string2 + ",0dlu";
            if (n >= this.columnsSpec.size()) continue;
            string2 = string2 + ",";
        }
        FormLayout formLayout = new FormLayout(string2, string);
        JPanel jPanel = new JPanel((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        int n2 = 1;
        for (ArrayList<Component> arrayList : this.formLines) {
            int n3 = 1;
            for (Component component : arrayList) {
                int n4 = this.componentsColSpan.get(component);
                jPanel.add(component, cellConstraints.xyw(n3, n2, n4));
                n3 += n4;
                ++n3;
            }
            n2 += 2;
        }
        return jPanel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        left,
        right,
        fill,
        center;

    }
}

