/*
 * Decompiled with CFR 0.152.
 */
package net.nlanr.jperf.core;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Vector;
import java.util.regex.Pattern;
import net.nlanr.jperf.core.JperfStreamResult;
import net.nlanr.jperf.core.Measurement;
import net.nlanr.jperf.ui.JPerfUI;
import net.nlanr.jperf.ui.JPerfWaitWindow;

public class IperfThread
extends Thread {
    private String command;
    private Process process;
    private JPerfUI frame;
    private Vector<JperfStreamResult> finalResults;
    private BufferedReader input;
    private BufferedReader errors;
    private boolean isServerMode;

    public IperfThread(boolean bl, String string, JPerfUI jPerfUI) {
        this.isServerMode = bl;
        this.command = string;
        this.frame = jPerfUI;
        this.finalResults = new Vector();
        this.frame.logMessage(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.frame.setStartedStatus();
            this.process = Runtime.getRuntime().exec(this.command);
            this.input = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            this.errors = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
            String string = null;
            while ((string = this.input.readLine()) != null) {
                this.parseLine(string);
                this.frame.logMessage(string);
            }
            String string2 = null;
            while ((string2 = this.errors.readLine()) != null) {
                this.frame.logMessage(string2);
            }
            this.frame.logMessage("Done.\n");
        }
        catch (Exception exception) {
            this.frame.logMessage("\nIperf thread stopped [CAUSE=" + exception.getMessage() + "]");
        }
        finally {
            this.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void quit() {
        if (this.process != null) {
            JPerfWaitWindow jPerfWaitWindow = new JPerfWaitWindow(this.frame);
            this.frame.setEnabled(false);
            jPerfWaitWindow.setVisible(true);
            jPerfWaitWindow.repaint();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isServerMode) {
                if (this.input != null) {
                    try {
                        this.input.close();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        this.input = null;
                    }
                }
                if (this.errors != null) {
                    try {
                        this.errors.close();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        this.errors = null;
                    }
                }
                try {
                    this.process.getInputStream().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.process.getOutputStream().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.process.getErrorStream().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.process.destroy();
            try {
                this.process.waitFor();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.process = null;
            this.frame.setStoppedStatus();
            jPerfWaitWindow.setVisible(false);
            this.frame.setEnabled(true);
        }
    }

    public void parseLine(String string) {
        if (string.matches("\\[[ \\d]+\\]\\s*[\\d]+.*")) {
            Pattern pattern = Pattern.compile("[-\\[\\]\\s]+");
            String[] stringArray = pattern.split(string);
            Integer n = new Integer(stringArray[1].trim());
            int n2 = n;
            boolean bl = false;
            JperfStreamResult jperfStreamResult = new JperfStreamResult(n2);
            for (int i = 0; i < this.finalResults.size(); ++i) {
                if (this.finalResults.elementAt(i).getID() != n2) continue;
                jperfStreamResult = this.finalResults.elementAt(i);
                bl = true;
                break;
            }
            if (!bl) {
                this.finalResults.add(jperfStreamResult);
            }
            if (stringArray.length == 9) {
                Double d = new Double(stringArray[2].trim());
                Double d2 = new Double(stringArray[3].trim());
                Double d3 = new Double(stringArray[7].trim());
                Measurement measurement = new Measurement(d, d2, d3, stringArray[8]);
                jperfStreamResult.addBW(measurement);
                this.frame.addNewStreamBandwidthMeasurement(n2, measurement);
            } else if (stringArray.length == 14) {
                Double d = new Double(stringArray[2].trim());
                Double d4 = new Double(stringArray[3].trim());
                Double d5 = new Double(stringArray[7].trim());
                Measurement measurement = new Measurement(d, d4, d5, stringArray[7]);
                jperfStreamResult.addBW(measurement);
                Double d6 = new Double(stringArray[9].trim());
                Measurement measurement2 = new Measurement(d, d4, d6, stringArray[10]);
                jperfStreamResult.addJitter(measurement2);
                this.frame.addNewStreamBandwidthAndJitterMeasurement(n2, measurement, measurement2);
            }
        }
    }
}

