/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

public class BorderHighlighter
extends AbstractHighlighter {
    private Border paddingBorder;
    private boolean inner;
    private boolean compound;

    public BorderHighlighter(Border paddingBorder) {
        this(paddingBorder, null);
    }

    public BorderHighlighter(Border paddingBorder, HighlightPredicate predicate) {
        this(paddingBorder, predicate, true);
    }

    public BorderHighlighter(Border paddingBorder, HighlightPredicate predicate, boolean compound) {
        super(predicate);
        if (paddingBorder == null) {
            throw new NullPointerException("border must not be null");
        }
        this.paddingBorder = paddingBorder;
        this.compound = compound;
    }

    public BorderHighlighter(Border paddingBorder, HighlightPredicate predicate, boolean compound, boolean inner) {
        super(predicate);
        if (paddingBorder == null) {
            throw new NullPointerException("border must not be null");
        }
        this.paddingBorder = paddingBorder;
        this.compound = compound;
        this.inner = inner;
    }

    protected Component doHighlight(Component renderer, ComponentAdapter adapter) {
        if (renderer instanceof JComponent) {
            ((JComponent)renderer).setBorder(this.compoundBorder(((JComponent)renderer).getBorder()));
        }
        return renderer;
    }

    public void setCompound(boolean compound) {
        if (this.isCompound() == compound) {
            return;
        }
        this.compound = compound;
        this.fireStateChanged();
    }

    public boolean isCompound() {
        return this.compound;
    }

    public void setInner(boolean inner) {
        if (this.isInner() == inner) {
            return;
        }
        this.inner = inner;
        this.fireStateChanged();
    }

    public boolean isInner() {
        return this.inner;
    }

    private Border compoundBorder(Border border) {
        if (this.compound && border != null) {
            if (this.inner) {
                return BorderFactory.createCompoundBorder(border, this.paddingBorder);
            }
            return BorderFactory.createCompoundBorder(this.paddingBorder, border);
        }
        return this.paddingBorder;
    }
}

